/* Copyright 2017 - 2021 R. Thomas
 * Copyright 2017 - 2021 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_PE_NTDLL_DLL_LOOKUP_H_
#define LIEF_PE_NTDLL_DLL_LOOKUP_H_

#include <map>

namespace LIEF {
namespace PE {

static const std::map<uint32_t, const char*> ntdll_dll_lookup {
    { 0x0008, "CsrAllocateCaptureBuffer"                       },
    { 0x0009, "CsrAllocateMessagePointer"                      },
    { 0x000a, "CsrCaptureMessageBuffer"                        },
    { 0x000b, "CsrCaptureMessageMultiUnicodeStringsInPlace"    },
    { 0x000c, "CsrCaptureMessageString"                        },
    { 0x000d, "CsrCaptureTimeout"                              },
    { 0x000e, "CsrClientCallServer"                            },
    { 0x000f, "CsrClientConnectToServer"                       },
    { 0x0010, "CsrFreeCaptureBuffer"                           },
    { 0x0011, "CsrGetProcessId"                                },
    { 0x0012, "CsrIdentifyAlertableThread"                     },
    { 0x0013, "CsrNewThread"                                   },
    { 0x0014, "CsrProbeForRead"                                },
    { 0x0015, "CsrProbeForWrite"                               },
    { 0x0016, "CsrSetPriorityClass"                            },
    { 0x0017, "DbgBreakPoint"                                  },
    { 0x0018, "DbgPrint"                                       },
    { 0x0019, "DbgPrintEx"                                     },
    { 0x001a, "DbgPrintReturnControlC"                         },
    { 0x001b, "DbgPrompt"                                      },
    { 0x001c, "DbgQueryDebugFilterState"                       },
    { 0x001d, "DbgSetDebugFilterState"                         },
    { 0x001e, "DbgUiConnectToDbg"                              },
    { 0x001f, "DbgUiContinue"                                  },
    { 0x0020, "DbgUiConvertStateChangeStructure"               },
    { 0x0021, "DbgUiDebugActiveProcess"                        },
    { 0x0022, "DbgUiGetThreadDebugObject"                      },
    { 0x0023, "DbgUiIssueRemoteBreakin"                        },
    { 0x0024, "DbgUiRemoteBreakin"                             },
    { 0x0025, "DbgUiSetThreadDebugObject"                      },
    { 0x0026, "DbgUiStopDebugging"                             },
    { 0x0027, "DbgUiWaitStateChange"                           },
    { 0x0028, "DbgUserBreakPoint"                              },
    { 0x0029, "KiFastSystemCall"                               },
    { 0x002a, "KiFastSystemCallRet"                            },
    { 0x002b, "KiIntSystemCall"                                },
    { 0x002c, "KiRaiseUserExceptionDispatcher"                 },
    { 0x002d, "KiUserApcDispatcher"                            },
    { 0x002e, "KiUserCallbackDispatcher"                       },
    { 0x002f, "KiUserExceptionDispatcher"                      },
    { 0x0030, "LdrAccessOutOfProcessResource"                  },
    { 0x0031, "LdrAccessResource"                              },
    { 0x0032, "LdrAddRefDll"                                   },
    { 0x0033, "LdrAlternateResourcesEnabled"                   },
    { 0x0034, "LdrCreateOutOfProcessImage"                     },
    { 0x0035, "LdrDestroyOutOfProcessImage"                    },
    { 0x0036, "LdrDisableThreadCalloutsForDll"                 },
    { 0x0037, "LdrEnumResources"                               },
    { 0x0038, "LdrEnumerateLoadedModules"                      },
    { 0x0039, "LdrFindCreateProcessManifest"                   },
    { 0x003a, "LdrFindEntryForAddress"                         },
    { 0x003b, "LdrFindResourceDirectory_U"                     },
    { 0x003c, "LdrFindResourceEx_U"                            },
    { 0x003d, "LdrFindResource_U"                              },
    { 0x003e, "LdrFlushAlternateResourceModules"               },
    { 0x003f, "LdrGetDllHandle"                                },
    { 0x0040, "LdrGetDllHandleEx"                              },
    { 0x0041, "LdrGetProcedureAddress"                         },
    { 0x0042, "LdrHotPatchRoutine"                             },
    { 0x0043, "LdrInitShimEngineDynamic"                       },
    { 0x0044, "LdrInitializeThunk"                             },
    { 0x0045, "LdrLoadAlternateResourceModule"                 },
    { 0x0046, "LdrLoadDll"                                     },
    { 0x0047, "LdrLockLoaderLock"                              },
    { 0x0048, "LdrProcessRelocationBlock"                      },
    { 0x0049, "LdrQueryImageFileExecutionOptions"              },
    { 0x004a, "LdrQueryProcessModuleInformation"               },
    { 0x004b, "LdrSetAppCompatDllRedirectionCallback"          },
    { 0x004c, "LdrSetDllManifestProber"                        },
    { 0x004d, "LdrShutdownProcess"                             },
    { 0x004e, "LdrShutdownThread"                              },
    { 0x004f, "LdrUnloadAlternateResourceModule"               },
    { 0x0050, "LdrUnloadDll"                                   },
    { 0x0051, "LdrUnlockLoaderLock"                            },
    { 0x0052, "LdrVerifyImageMatchesChecksum"                  },
    { 0x0053, "NlsAnsiCodePage"                                },
    { 0x0054, "NlsMbCodePageTag"                               },
    { 0x0055, "NlsMbOemCodePageTag"                            },
    { 0x0056, "NtAcceptConnectPort"                            },
    { 0x0057, "NtAccessCheck"                                  },
    { 0x0058, "NtAccessCheckAndAuditAlarm"                     },
    { 0x0059, "NtAccessCheckByType"                            },
    { 0x005a, "NtAccessCheckByTypeAndAuditAlarm"               },
    { 0x005b, "NtAccessCheckByTypeResultList"                  },
    { 0x005c, "NtAccessCheckByTypeResultListAndAuditAlarm"     },
    { 0x005d, "NtAccessCheckByTypeResultListAndAuditAlarmByHandle" },
    { 0x005e, "NtAddAtom"                                      },
    { 0x005f, "NtAddBootEntry"                                 },
    { 0x0060, "NtAdjustGroupsToken"                            },
    { 0x0061, "NtAdjustPrivilegesToken"                        },
    { 0x0062, "NtAlertResumeThread"                            },
    { 0x0063, "NtAlertThread"                                  },
    { 0x0064, "NtAllocateLocallyUniqueId"                      },
    { 0x0065, "NtAllocateUserPhysicalPages"                    },
    { 0x0066, "NtAllocateUuids"                                },
    { 0x0067, "NtAllocateVirtualMemory"                        },
    { 0x0068, "NtAreMappedFilesTheSame"                        },
    { 0x0069, "NtAssignProcessToJobObject"                     },
    { 0x006a, "NtCallbackReturn"                               },
    { 0x006b, "NtCancelDeviceWakeupRequest"                    },
    { 0x006c, "NtCancelIoFile"                                 },
    { 0x006d, "NtCancelTimer"                                  },
    { 0x006e, "NtClearEvent"                                   },
    { 0x006f, "NtClose"                                        },
    { 0x0070, "NtCloseObjectAuditAlarm"                        },
    { 0x0071, "NtCompactKeys"                                  },
    { 0x0072, "NtCompareTokens"                                },
    { 0x0073, "NtCompleteConnectPort"                          },
    { 0x0074, "NtCompressKey"                                  },
    { 0x0075, "NtConnectPort"                                  },
    { 0x0076, "NtContinue"                                     },
    { 0x0077, "NtCreateDebugObject"                            },
    { 0x0078, "NtCreateDirectoryObject"                        },
    { 0x0079, "NtCreateEvent"                                  },
    { 0x007a, "NtCreateEventPair"                              },
    { 0x007b, "NtCreateFile"                                   },
    { 0x007c, "NtCreateIoCompletion"                           },
    { 0x007d, "NtCreateJobObject"                              },
    { 0x007e, "NtCreateJobSet"                                 },
    { 0x007f, "NtCreateKey"                                    },
    { 0x0080, "NtCreateKeyedEvent"                             },
    { 0x0081, "NtCreateMailslotFile"                           },
    { 0x0082, "NtCreateMutant"                                 },
    { 0x0083, "NtCreateNamedPipeFile"                          },
    { 0x0084, "NtCreatePagingFile"                             },
    { 0x0085, "NtCreatePort"                                   },
    { 0x0086, "NtCreateProcess"                                },
    { 0x0087, "NtCreateProcessEx"                              },
    { 0x0088, "NtCreateProfile"                                },
    { 0x0089, "NtCreateSection"                                },
    { 0x008a, "NtCreateSemaphore"                              },
    { 0x008b, "NtCreateSymbolicLinkObject"                     },
    { 0x008c, "NtCreateThread"                                 },
    { 0x008d, "NtCreateTimer"                                  },
    { 0x008e, "NtCreateToken"                                  },
    { 0x008f, "NtCreateWaitablePort"                           },
    { 0x0090, "NtCurrentTeb"                                   },
    { 0x0091, "NtDebugActiveProcess"                           },
    { 0x0092, "NtDebugContinue"                                },
    { 0x0093, "NtDelayExecution"                               },
    { 0x0094, "NtDeleteAtom"                                   },
    { 0x0095, "NtDeleteBootEntry"                              },
    { 0x0096, "NtDeleteFile"                                   },
    { 0x0097, "NtDeleteKey"                                    },
    { 0x0098, "NtDeleteObjectAuditAlarm"                       },
    { 0x0099, "NtDeleteValueKey"                               },
    { 0x009a, "NtDeviceIoControlFile"                          },
    { 0x009b, "NtDisplayString"                                },
    { 0x009c, "NtDuplicateObject"                              },
    { 0x009d, "NtDuplicateToken"                               },
    { 0x009e, "NtEnumerateBootEntries"                         },
    { 0x009f, "NtEnumerateKey"                                 },
    { 0x00a0, "NtEnumerateSystemEnvironmentValuesEx"           },
    { 0x00a1, "NtEnumerateValueKey"                            },
    { 0x00a2, "NtExtendSection"                                },
    { 0x00a3, "NtFilterToken"                                  },
    { 0x00a4, "NtFindAtom"                                     },
    { 0x00a5, "NtFlushBuffersFile"                             },
    { 0x00a6, "NtFlushInstructionCache"                        },
    { 0x00a7, "NtFlushKey"                                     },
    { 0x00a8, "NtFlushVirtualMemory"                           },
    { 0x00a9, "NtFlushWriteBuffer"                             },
    { 0x00aa, "NtFreeUserPhysicalPages"                        },
    { 0x00ab, "NtFreeVirtualMemory"                            },
    { 0x00ac, "NtFsControlFile"                                },
    { 0x00ad, "NtGetContextThread"                             },
    { 0x00ae, "NtGetDevicePowerState"                          },
    { 0x00af, "NtGetPlugPlayEvent"                             },
    { 0x00b0, "NtGetWriteWatch"                                },
    { 0x00b1, "NtImpersonateAnonymousToken"                    },
    { 0x00b2, "NtImpersonateClientOfPort"                      },
    { 0x00b3, "NtImpersonateThread"                            },
    { 0x00b4, "NtInitializeRegistry"                           },
    { 0x00b5, "NtInitiatePowerAction"                          },
    { 0x00b6, "NtIsProcessInJob"                               },
    { 0x00b7, "NtIsSystemResumeAutomatic"                      },
    { 0x00b8, "NtListenPort"                                   },
    { 0x00b9, "NtLoadDriver"                                   },
    { 0x00bb, "NtLoadKey"                                      },
    { 0x00ba, "NtLoadKey2"                                     },
    { 0x00bc, "NtLockFile"                                     },
    { 0x00bd, "NtLockProductActivationKeys"                    },
    { 0x00be, "NtLockRegistryKey"                              },
    { 0x00bf, "NtLockVirtualMemory"                            },
    { 0x00c0, "NtMakePermanentObject"                          },
    { 0x00c1, "NtMakeTemporaryObject"                          },
    { 0x00c2, "NtMapUserPhysicalPages"                         },
    { 0x00c3, "NtMapUserPhysicalPagesScatter"                  },
    { 0x00c4, "NtMapViewOfSection"                             },
    { 0x00c5, "NtModifyBootEntry"                              },
    { 0x00c6, "NtNotifyChangeDirectoryFile"                    },
    { 0x00c7, "NtNotifyChangeKey"                              },
    { 0x00c8, "NtNotifyChangeMultipleKeys"                     },
    { 0x00c9, "NtOpenDirectoryObject"                          },
    { 0x00ca, "NtOpenEvent"                                    },
    { 0x00cb, "NtOpenEventPair"                                },
    { 0x00cc, "NtOpenFile"                                     },
    { 0x00cd, "NtOpenIoCompletion"                             },
    { 0x00ce, "NtOpenJobObject"                                },
    { 0x00cf, "NtOpenKey"                                      },
    { 0x00d0, "NtOpenKeyedEvent"                               },
    { 0x00d1, "NtOpenMutant"                                   },
    { 0x00d2, "NtOpenObjectAuditAlarm"                         },
    { 0x00d3, "NtOpenProcess"                                  },
    { 0x00d4, "NtOpenProcessToken"                             },
    { 0x00d5, "NtOpenProcessTokenEx"                           },
    { 0x00d6, "NtOpenSection"                                  },
    { 0x00d7, "NtOpenSemaphore"                                },
    { 0x00d8, "NtOpenSymbolicLinkObject"                       },
    { 0x00d9, "NtOpenThread"                                   },
    { 0x00da, "NtOpenThreadToken"                              },
    { 0x00db, "NtOpenThreadTokenEx"                            },
    { 0x00dc, "NtOpenTimer"                                    },
    { 0x00dd, "NtPlugPlayControl"                              },
    { 0x00de, "NtPowerInformation"                             },
    { 0x00df, "NtPrivilegeCheck"                               },
    { 0x00e0, "NtPrivilegeObjectAuditAlarm"                    },
    { 0x00e1, "NtPrivilegedServiceAuditAlarm"                  },
    { 0x00e2, "NtProtectVirtualMemory"                         },
    { 0x00e3, "NtPulseEvent"                                   },
    { 0x00e4, "NtQueryAttributesFile"                          },
    { 0x00e5, "NtQueryBootEntryOrder"                          },
    { 0x00e6, "NtQueryBootOptions"                             },
    { 0x00e7, "NtQueryDebugFilterState"                        },
    { 0x00e8, "NtQueryDefaultLocale"                           },
    { 0x00e9, "NtQueryDefaultUILanguage"                       },
    { 0x00ea, "NtQueryDirectoryFile"                           },
    { 0x00eb, "NtQueryDirectoryObject"                         },
    { 0x00ec, "NtQueryEaFile"                                  },
    { 0x00ed, "NtQueryEvent"                                   },
    { 0x00ee, "NtQueryFullAttributesFile"                      },
    { 0x00ef, "NtQueryInformationAtom"                         },
    { 0x00f0, "NtQueryInformationFile"                         },
    { 0x00f1, "NtQueryInformationJobObject"                    },
    { 0x00f2, "NtQueryInformationPort"                         },
    { 0x00f3, "NtQueryInformationProcess"                      },
    { 0x00f4, "NtQueryInformationThread"                       },
    { 0x00f5, "NtQueryInformationToken"                        },
    { 0x00f6, "NtQueryInstallUILanguage"                       },
    { 0x00f7, "NtQueryIntervalProfile"                         },
    { 0x00f8, "NtQueryIoCompletion"                            },
    { 0x00f9, "NtQueryKey"                                     },
    { 0x00fa, "NtQueryMultipleValueKey"                        },
    { 0x00fb, "NtQueryMutant"                                  },
    { 0x00fc, "NtQueryObject"                                  },
    { 0x00fd, "NtQueryOpenSubKeys"                             },
    { 0x00fe, "NtQueryPerformanceCounter"                      },
    { 0x00ff, "NtQueryPortInformationProcess"                  },
    { 0x0100, "NtQueryQuotaInformationFile"                    },
    { 0x0101, "NtQuerySection"                                 },
    { 0x0102, "NtQuerySecurityObject"                          },
    { 0x0103, "NtQuerySemaphore"                               },
    { 0x0104, "NtQuerySymbolicLinkObject"                      },
    { 0x0105, "NtQuerySystemEnvironmentValue"                  },
    { 0x0106, "NtQuerySystemEnvironmentValueEx"                },
    { 0x0107, "NtQuerySystemInformation"                       },
    { 0x0108, "NtQuerySystemTime"                              },
    { 0x0109, "NtQueryTimer"                                   },
    { 0x010a, "NtQueryTimerResolution"                         },
    { 0x010b, "NtQueryValueKey"                                },
    { 0x010c, "NtQueryVirtualMemory"                           },
    { 0x010d, "NtQueryVolumeInformationFile"                   },
    { 0x010e, "NtQueueApcThread"                               },
    { 0x010f, "NtRaiseException"                               },
    { 0x0110, "NtRaiseHardError"                               },
    { 0x0111, "NtReadFile"                                     },
    { 0x0112, "NtReadFileScatter"                              },
    { 0x0113, "NtReadRequestData"                              },
    { 0x0114, "NtReadVirtualMemory"                            },
    { 0x0115, "NtRegisterThreadTerminatePort"                  },
    { 0x0116, "NtReleaseKeyedEvent"                            },
    { 0x0117, "NtReleaseMutant"                                },
    { 0x0118, "NtReleaseSemaphore"                             },
    { 0x0119, "NtRemoveIoCompletion"                           },
    { 0x011a, "NtRemoveProcessDebug"                           },
    { 0x011b, "NtRenameKey"                                    },
    { 0x011c, "NtReplaceKey"                                   },
    { 0x011d, "NtReplyPort"                                    },
    { 0x011e, "NtReplyWaitReceivePort"                         },
    { 0x011f, "NtReplyWaitReceivePortEx"                       },
    { 0x0120, "NtReplyWaitReplyPort"                           },
    { 0x0121, "NtRequestDeviceWakeup"                          },
    { 0x0122, "NtRequestPort"                                  },
    { 0x0123, "NtRequestWaitReplyPort"                         },
    { 0x0124, "NtRequestWakeupLatency"                         },
    { 0x0125, "NtResetEvent"                                   },
    { 0x0126, "NtResetWriteWatch"                              },
    { 0x0127, "NtRestoreKey"                                   },
    { 0x0128, "NtResumeProcess"                                },
    { 0x0129, "NtResumeThread"                                 },
    { 0x012a, "NtSaveKey"                                      },
    { 0x012b, "NtSaveKeyEx"                                    },
    { 0x012c, "NtSaveMergedKeys"                               },
    { 0x012d, "NtSecureConnectPort"                            },
    { 0x012e, "NtSetBootEntryOrder"                            },
    { 0x012f, "NtSetBootOptions"                               },
    { 0x0130, "NtSetContextThread"                             },
    { 0x0131, "NtSetDebugFilterState"                          },
    { 0x0132, "NtSetDefaultHardErrorPort"                      },
    { 0x0133, "NtSetDefaultLocale"                             },
    { 0x0134, "NtSetDefaultUILanguage"                         },
    { 0x0135, "NtSetEaFile"                                    },
    { 0x0136, "NtSetEvent"                                     },
    { 0x0137, "NtSetEventBoostPriority"                        },
    { 0x0138, "NtSetHighEventPair"                             },
    { 0x0139, "NtSetHighWaitLowEventPair"                      },
    { 0x013a, "NtSetInformationDebugObject"                    },
    { 0x013b, "NtSetInformationFile"                           },
    { 0x013c, "NtSetInformationJobObject"                      },
    { 0x013d, "NtSetInformationKey"                            },
    { 0x013e, "NtSetInformationObject"                         },
    { 0x013f, "NtSetInformationProcess"                        },
    { 0x0140, "NtSetInformationThread"                         },
    { 0x0141, "NtSetInformationToken"                          },
    { 0x0142, "NtSetIntervalProfile"                           },
    { 0x0143, "NtSetIoCompletion"                              },
    { 0x0144, "NtSetLdtEntries"                                },
    { 0x0145, "NtSetLowEventPair"                              },
    { 0x0146, "NtSetLowWaitHighEventPair"                      },
    { 0x0147, "NtSetQuotaInformationFile"                      },
    { 0x0148, "NtSetSecurityObject"                            },
    { 0x0149, "NtSetSystemEnvironmentValue"                    },
    { 0x014a, "NtSetSystemEnvironmentValueEx"                  },
    { 0x014b, "NtSetSystemInformation"                         },
    { 0x014c, "NtSetSystemPowerState"                          },
    { 0x014d, "NtSetSystemTime"                                },
    { 0x014e, "NtSetThreadExecutionState"                      },
    { 0x014f, "NtSetTimer"                                     },
    { 0x0150, "NtSetTimerResolution"                           },
    { 0x0151, "NtSetUuidSeed"                                  },
    { 0x0152, "NtSetValueKey"                                  },
    { 0x0153, "NtSetVolumeInformationFile"                     },
    { 0x0154, "NtShutdownSystem"                               },
    { 0x0155, "NtSignalAndWaitForSingleObject"                 },
    { 0x0156, "NtStartProfile"                                 },
    { 0x0157, "NtStopProfile"                                  },
    { 0x0158, "NtSuspendProcess"                               },
    { 0x0159, "NtSuspendThread"                                },
    { 0x015a, "NtSystemDebugControl"                           },
    { 0x015b, "NtTerminateJobObject"                           },
    { 0x015c, "NtTerminateProcess"                             },
    { 0x015d, "NtTerminateThread"                              },
    { 0x015e, "NtTestAlert"                                    },
    { 0x015f, "NtTraceEvent"                                   },
    { 0x0160, "NtTranslateFilePath"                            },
    { 0x0161, "NtUnloadDriver"                                 },
    { 0x0162, "NtUnloadKey"                                    },
    { 0x0163, "NtUnloadKeyEx"                                  },
    { 0x0164, "NtUnlockFile"                                   },
    { 0x0165, "NtUnlockVirtualMemory"                          },
    { 0x0166, "NtUnmapViewOfSection"                           },
    { 0x0167, "NtVdmControl"                                   },
    { 0x0168, "NtWaitForDebugEvent"                            },
    { 0x0169, "NtWaitForKeyedEvent"                            },
    { 0x016a, "NtWaitForMultipleObjects"                       },
    { 0x016b, "NtWaitForSingleObject"                          },
    { 0x016c, "NtWaitHighEventPair"                            },
    { 0x016d, "NtWaitLowEventPair"                             },
    { 0x016e, "NtWriteFile"                                    },
    { 0x016f, "NtWriteFileGather"                              },
    { 0x0170, "NtWriteRequestData"                             },
    { 0x0171, "NtWriteVirtualMemory"                           },
    { 0x0172, "NtYieldExecution"                               },
    { 0x0173, "PfxFindPrefix"                                  },
    { 0x0174, "PfxInitialize"                                  },
    { 0x0175, "PfxInsertPrefix"                                },
    { 0x0176, "PfxRemovePrefix"                                },
    { 0x0001, "PropertyLengthAsVariant"                        },
    { 0x0177, "RtlAbortRXact"                                  },
    { 0x0178, "RtlAbsoluteToSelfRelativeSD"                    },
    { 0x0179, "RtlAcquirePebLock"                              },
    { 0x017a, "RtlAcquireResourceExclusive"                    },
    { 0x017b, "RtlAcquireResourceShared"                       },
    { 0x017c, "RtlActivateActivationContext"                   },
    { 0x017d, "RtlActivateActivationContextEx"                 },
    { 0x017e, "RtlActivateActivationContextUnsafeFast"         },
    { 0x017f, "RtlAddAccessAllowedAce"                         },
    { 0x0180, "RtlAddAccessAllowedAceEx"                       },
    { 0x0181, "RtlAddAccessAllowedObjectAce"                   },
    { 0x0182, "RtlAddAccessDeniedAce"                          },
    { 0x0183, "RtlAddAccessDeniedAceEx"                        },
    { 0x0184, "RtlAddAccessDeniedObjectAce"                    },
    { 0x0185, "RtlAddAce"                                      },
    { 0x0186, "RtlAddActionToRXact"                            },
    { 0x0187, "RtlAddAtomToAtomTable"                          },
    { 0x0188, "RtlAddAttributeActionToRXact"                   },
    { 0x0189, "RtlAddAuditAccessAce"                           },
    { 0x018a, "RtlAddAuditAccessAceEx"                         },
    { 0x018b, "RtlAddAuditAccessObjectAce"                     },
    { 0x018c, "RtlAddCompoundAce"                              },
    { 0x018d, "RtlAddRange"                                    },
    { 0x018e, "RtlAddRefActivationContext"                     },
    { 0x018f, "RtlAddRefMemoryStream"                          },
    { 0x0190, "RtlAddVectoredExceptionHandler"                 },
    { 0x0191, "RtlAddressInSectionTable"                       },
    { 0x0192, "RtlAdjustPrivilege"                             },
    { 0x0193, "RtlAllocateAndInitializeSid"                    },
    { 0x0194, "RtlAllocateHandle"                              },
    { 0x0195, "RtlAllocateHeap"                                },
    { 0x0196, "RtlAnsiCharToUnicodeChar"                       },
    { 0x0197, "RtlAnsiStringToUnicodeSize"                     },
    { 0x0198, "RtlAnsiStringToUnicodeString"                   },
    { 0x0199, "RtlAppendAsciizToString"                        },
    { 0x019a, "RtlAppendPathElement"                           },
    { 0x019b, "RtlAppendStringToString"                        },
    { 0x019c, "RtlAppendUnicodeStringToString"                 },
    { 0x019d, "RtlAppendUnicodeToString"                       },
    { 0x019e, "RtlApplicationVerifierStop"                     },
    { 0x019f, "RtlApplyRXact"                                  },
    { 0x01a0, "RtlApplyRXactNoFlush"                           },
    { 0x01a1, "RtlAreAllAccessesGranted"                       },
    { 0x01a2, "RtlAreAnyAccessesGranted"                       },
    { 0x01a3, "RtlAreBitsClear"                                },
    { 0x01a4, "RtlAreBitsSet"                                  },
    { 0x01a6, "RtlAssert"                                      },
    { 0x01a5, "RtlAssert2"                                     },
    { 0x01a7, "RtlCancelTimer"                                 },
    { 0x01a8, "RtlCaptureContext"                              },
    { 0x01a9, "RtlCaptureStackBackTrace"                       },
    { 0x01aa, "RtlCaptureStackContext"                         },
    { 0x01ab, "RtlCharToInteger"                               },
    { 0x01ac, "RtlCheckForOrphanedCriticalSections"            },
    { 0x01ad, "RtlCheckProcessParameters"                      },
    { 0x01ae, "RtlCheckRegistryKey"                            },
    { 0x01af, "RtlClearAllBits"                                },
    { 0x01b0, "RtlClearBits"                                   },
    { 0x01b1, "RtlCloneMemoryStream"                           },
    { 0x01b2, "RtlCommitMemoryStream"                          },
    { 0x01b3, "RtlCompactHeap"                                 },
    { 0x01b4, "RtlCompareMemory"                               },
    { 0x01b5, "RtlCompareMemoryUlong"                          },
    { 0x01b6, "RtlCompareString"                               },
    { 0x01b7, "RtlCompareUnicodeString"                        },
    { 0x01b8, "RtlCompressBuffer"                              },
    { 0x01b9, "RtlComputeCrc32"                                },
    { 0x01ba, "RtlComputeImportTableHash"                      },
    { 0x01bb, "RtlComputePrivatizedDllName_U"                  },
    { 0x01bc, "RtlConsoleMultiByteToUnicodeN"                  },
    { 0x01bd, "RtlConvertExclusiveToShared"                    },
    { 0x01be, "RtlConvertLongToLargeInteger"                   },
    { 0x0002, "RtlConvertPropertyToVariant"                    },
    { 0x01bf, "RtlConvertSharedToExclusive"                    },
    { 0x01c0, "RtlConvertSidToUnicodeString"                   },
    { 0x01c1, "RtlConvertToAutoInheritSecurityObject"          },
    { 0x01c2, "RtlConvertUiListToApiList"                      },
    { 0x01c3, "RtlConvertUlongToLargeInteger"                  },
    { 0x0003, "RtlConvertVariantToProperty"                    },
    { 0x01c4, "RtlCopyLuid"                                    },
    { 0x01c5, "RtlCopyLuidAndAttributesArray"                  },
    { 0x01c6, "RtlCopyMemoryStreamTo"                          },
    { 0x01c7, "RtlCopyOutOfProcessMemoryStreamTo"              },
    { 0x01c8, "RtlCopyRangeList"                               },
    { 0x01c9, "RtlCopySecurityDescriptor"                      },
    { 0x01ca, "RtlCopySid"                                     },
    { 0x01cb, "RtlCopySidAndAttributesArray"                   },
    { 0x01cc, "RtlCopyString"                                  },
    { 0x01cd, "RtlCopyUnicodeString"                           },
    { 0x01ce, "RtlCreateAcl"                                   },
    { 0x01cf, "RtlCreateActivationContext"                     },
    { 0x01d0, "RtlCreateAndSetSD"                              },
    { 0x01d1, "RtlCreateAtomTable"                             },
    { 0x01d2, "RtlCreateBootStatusDataFile"                    },
    { 0x01d3, "RtlCreateEnvironment"                           },
    { 0x01d4, "RtlCreateHeap"                                  },
    { 0x01d5, "RtlCreateProcessParameters"                     },
    { 0x01d6, "RtlCreateQueryDebugBuffer"                      },
    { 0x01d7, "RtlCreateRegistryKey"                           },
    { 0x01d8, "RtlCreateSecurityDescriptor"                    },
    { 0x01d9, "RtlCreateSystemVolumeInformationFolder"         },
    { 0x01da, "RtlCreateTagHeap"                               },
    { 0x01db, "RtlCreateTimer"                                 },
    { 0x01dc, "RtlCreateTimerQueue"                            },
    { 0x01dd, "RtlCreateUnicodeString"                         },
    { 0x01de, "RtlCreateUnicodeStringFromAsciiz"               },
    { 0x01df, "RtlCreateUserProcess"                           },
    { 0x01e0, "RtlCreateUserSecurityObject"                    },
    { 0x01e1, "RtlCreateUserThread"                            },
    { 0x01e2, "RtlCustomCPToUnicodeN"                          },
    { 0x01e3, "RtlCutoverTimeToSystemTime"                     },
    { 0x01e4, "RtlDeNormalizeProcessParams"                    },
    { 0x01e5, "RtlDeactivateActivationContext"                 },
    { 0x01e6, "RtlDeactivateActivationContextUnsafeFast"       },
    { 0x01e7, "RtlDebugPrintTimes"                             },
    { 0x01e8, "RtlDecodePointer"                               },
    { 0x01e9, "RtlDecodeSystemPointer"                         },
    { 0x01ea, "RtlDecompressBuffer"                            },
    { 0x01eb, "RtlDecompressFragment"                          },
    { 0x01ec, "RtlDefaultNpAcl"                                },
    { 0x01ed, "RtlDelete"                                      },
    { 0x01ee, "RtlDeleteAce"                                   },
    { 0x01ef, "RtlDeleteAtomFromAtomTable"                     },
    { 0x01f0, "RtlDeleteCriticalSection"                       },
    { 0x01f1, "RtlDeleteElementGenericTable"                   },
    { 0x01f2, "RtlDeleteElementGenericTableAvl"                },
    { 0x01f3, "RtlDeleteNoSplay"                               },
    { 0x01f4, "RtlDeleteOwnersRanges"                          },
    { 0x01f5, "RtlDeleteRange"                                 },
    { 0x01f6, "RtlDeleteRegistryValue"                         },
    { 0x01f7, "RtlDeleteResource"                              },
    { 0x01f8, "RtlDeleteSecurityObject"                        },
    { 0x01f9, "RtlDeleteTimer"                                 },
    { 0x01fa, "RtlDeleteTimerQueue"                            },
    { 0x01fb, "RtlDeleteTimerQueueEx"                          },
    { 0x01fc, "RtlDeregisterWait"                              },
    { 0x01fd, "RtlDeregisterWaitEx"                            },
    { 0x01fe, "RtlDestroyAtomTable"                            },
    { 0x01ff, "RtlDestroyEnvironment"                          },
    { 0x0200, "RtlDestroyHandleTable"                          },
    { 0x0201, "RtlDestroyHeap"                                 },
    { 0x0202, "RtlDestroyProcessParameters"                    },
    { 0x0203, "RtlDestroyQueryDebugBuffer"                     },
    { 0x0204, "RtlDetermineDosPathNameType_U"                  },
    { 0x0205, "RtlDllShutdownInProgress"                       },
    { 0x0206, "RtlDnsHostNameToComputerName"                   },
    { 0x0207, "RtlDoesFileExists_U"                            },
    { 0x0208, "RtlDosApplyFileIsolationRedirection_Ustr"       },
    { 0x0209, "RtlDosPathNameToNtPathName_U"                   },
    { 0x020a, "RtlDosSearchPath_U"                             },
    { 0x020b, "RtlDosSearchPath_Ustr"                          },
    { 0x020c, "RtlDowncaseUnicodeChar"                         },
    { 0x020d, "RtlDowncaseUnicodeString"                       },
    { 0x020e, "RtlDumpResource"                                },
    { 0x020f, "RtlDuplicateUnicodeString"                      },
    { 0x0210, "RtlEmptyAtomTable"                              },
    { 0x0211, "RtlEnableEarlyCriticalSectionEventCreation"     },
    { 0x0212, "RtlEncodePointer"                               },
    { 0x0213, "RtlEncodeSystemPointer"                         },
    { 0x0214, "RtlEnlargedIntegerMultiply"                     },
    { 0x0215, "RtlEnlargedUnsignedDivide"                      },
    { 0x0216, "RtlEnlargedUnsignedMultiply"                    },
    { 0x0217, "RtlEnterCriticalSection"                        },
    { 0x0218, "RtlEnumProcessHeaps"                            },
    { 0x0219, "RtlEnumerateGenericTable"                       },
    { 0x021a, "RtlEnumerateGenericTableAvl"                    },
    { 0x021b, "RtlEnumerateGenericTableLikeADirectory"         },
    { 0x021c, "RtlEnumerateGenericTableWithoutSplaying"        },
    { 0x021d, "RtlEnumerateGenericTableWithoutSplayingAvl"     },
    { 0x021e, "RtlEqualComputerName"                           },
    { 0x021f, "RtlEqualDomainName"                             },
    { 0x0220, "RtlEqualLuid"                                   },
    { 0x0221, "RtlEqualPrefixSid"                              },
    { 0x0222, "RtlEqualSid"                                    },
    { 0x0223, "RtlEqualString"                                 },
    { 0x0224, "RtlEqualUnicodeString"                          },
    { 0x0225, "RtlEraseUnicodeString"                          },
    { 0x0226, "RtlExitUserThread"                              },
    { 0x0227, "RtlExpandEnvironmentStrings_U"                  },
    { 0x0228, "RtlExtendHeap"                                  },
    { 0x0229, "RtlExtendedIntegerMultiply"                     },
    { 0x022a, "RtlExtendedLargeIntegerDivide"                  },
    { 0x022b, "RtlExtendedMagicDivide"                         },
    { 0x022c, "RtlFillMemory"                                  },
    { 0x022d, "RtlFillMemoryUlong"                             },
    { 0x022e, "RtlFinalReleaseOutOfProcessMemoryStream"        },
    { 0x022f, "RtlFindActivationContextSectionGuid"            },
    { 0x0230, "RtlFindActivationContextSectionString"          },
    { 0x0231, "RtlFindCharInUnicodeString"                     },
    { 0x0232, "RtlFindClearBits"                               },
    { 0x0233, "RtlFindClearBitsAndSet"                         },
    { 0x0234, "RtlFindClearRuns"                               },
    { 0x0235, "RtlFindLastBackwardRunClear"                    },
    { 0x0236, "RtlFindLeastSignificantBit"                     },
    { 0x0237, "RtlFindLongestRunClear"                         },
    { 0x0238, "RtlFindMessage"                                 },
    { 0x0239, "RtlFindMostSignificantBit"                      },
    { 0x023a, "RtlFindNextForwardRunClear"                     },
    { 0x023b, "RtlFindRange"                                   },
    { 0x023c, "RtlFindSetBits"                                 },
    { 0x023d, "RtlFindSetBitsAndClear"                         },
    { 0x023e, "RtlFirstEntrySList"                             },
    { 0x023f, "RtlFirstFreeAce"                                },
    { 0x0240, "RtlFlushSecureMemoryCache"                      },
    { 0x0241, "RtlFormatCurrentUserKeyPath"                    },
    { 0x0242, "RtlFormatMessage"                               },
    { 0x0243, "RtlFreeAnsiString"                              },
    { 0x0244, "RtlFreeHandle"                                  },
    { 0x0245, "RtlFreeHeap"                                    },
    { 0x0246, "RtlFreeOemString"                               },
    { 0x0247, "RtlFreeRangeList"                               },
    { 0x0248, "RtlFreeSid"                                     },
    { 0x0249, "RtlFreeThreadActivationContextStack"            },
    { 0x024a, "RtlFreeUnicodeString"                           },
    { 0x024b, "RtlFreeUserThreadStack"                         },
    { 0x024c, "RtlGUIDFromString"                              },
    { 0x024d, "RtlGenerate8dot3Name"                           },
    { 0x024e, "RtlGetAce"                                      },
    { 0x024f, "RtlGetActiveActivationContext"                  },
    { 0x0250, "RtlGetCallersAddress"                           },
    { 0x0251, "RtlGetCompressionWorkSpaceSize"                 },
    { 0x0252, "RtlGetControlSecurityDescriptor"                },
    { 0x0253, "RtlGetCurrentDirectory_U"                       },
    { 0x0254, "RtlGetCurrentPeb"                               },
    { 0x0255, "RtlGetDaclSecurityDescriptor"                   },
    { 0x0256, "RtlGetElementGenericTable"                      },
    { 0x0257, "RtlGetElementGenericTableAvl"                   },
    { 0x0258, "RtlGetFirstRange"                               },
    { 0x0259, "RtlGetFrame"                                    },
    { 0x025a, "RtlGetFullPathName_U"                           },
    { 0x025b, "RtlGetGroupSecurityDescriptor"                  },
    { 0x025c, "RtlGetLastNtStatus"                             },
    { 0x025d, "RtlGetLastWin32Error"                           },
    { 0x025e, "RtlGetLengthWithoutLastFullDosOrNtPathElement"  },
    { 0x025f, "RtlGetLengthWithoutTrailingPathSeperators"      },
    { 0x0260, "RtlGetLongestNtPathLength"                      },
    { 0x0261, "RtlGetNativeSystemInformation"                  },
    { 0x0262, "RtlGetNextRange"                                },
    { 0x0263, "RtlGetNtGlobalFlags"                            },
    { 0x0264, "RtlGetNtProductType"                            },
    { 0x0265, "RtlGetNtVersionNumbers"                         },
    { 0x0266, "RtlGetOwnerSecurityDescriptor"                  },
    { 0x0267, "RtlGetProcessHeaps"                             },
    { 0x0268, "RtlGetSaclSecurityDescriptor"                   },
    { 0x0269, "RtlGetSecurityDescriptorRMControl"              },
    { 0x026a, "RtlGetSetBootStatusData"                        },
    { 0x026b, "RtlGetUnloadEventTrace"                         },
    { 0x026c, "RtlGetUserInfoHeap"                             },
    { 0x026d, "RtlGetVersion"                                  },
    { 0x026e, "RtlHashUnicodeString"                           },
    { 0x026f, "RtlIdentifierAuthoritySid"                      },
    { 0x0270, "RtlImageDirectoryEntryToData"                   },
    { 0x0271, "RtlImageNtHeader"                               },
    { 0x0272, "RtlImageRvaToSection"                           },
    { 0x0273, "RtlImageRvaToVa"                                },
    { 0x0274, "RtlImpersonateSelf"                             },
    { 0x0275, "RtlInitAnsiString"                              },
    { 0x0276, "RtlInitCodePageTable"                           },
    { 0x0277, "RtlInitMemoryStream"                            },
    { 0x0278, "RtlInitNlsTables"                               },
    { 0x0279, "RtlInitOutOfProcessMemoryStream"                },
    { 0x027a, "RtlInitString"                                  },
    { 0x027b, "RtlInitUnicodeString"                           },
    { 0x027c, "RtlInitUnicodeStringEx"                         },
    { 0x027d, "RtlInitializeAtomPackage"                       },
    { 0x027e, "RtlInitializeBitMap"                            },
    { 0x027f, "RtlInitializeContext"                           },
    { 0x0280, "RtlInitializeCriticalSection"                   },
    { 0x0281, "RtlInitializeCriticalSectionAndSpinCount"       },
    { 0x0282, "RtlInitializeGenericTable"                      },
    { 0x0283, "RtlInitializeGenericTableAvl"                   },
    { 0x0284, "RtlInitializeHandleTable"                       },
    { 0x0285, "RtlInitializeRXact"                             },
    { 0x0286, "RtlInitializeRangeList"                         },
    { 0x0287, "RtlInitializeResource"                          },
    { 0x0288, "RtlInitializeSListHead"                         },
    { 0x0289, "RtlInitializeSid"                               },
    { 0x028a, "RtlInitializeStackTraceDataBase"                },
    { 0x028b, "RtlInsertElementGenericTable"                   },
    { 0x028c, "RtlInsertElementGenericTableAvl"                },
    { 0x028d, "RtlInt64ToUnicodeString"                        },
    { 0x028e, "RtlIntegerToChar"                               },
    { 0x028f, "RtlIntegerToUnicodeString"                      },
    { 0x0290, "RtlInterlockedFlushSList"                       },
    { 0x0291, "RtlInterlockedPopEntrySList"                    },
    { 0x0292, "RtlInterlockedPushEntrySList"                   },
    { 0x0004, "RtlInterlockedPushListSList"                    },
    { 0x0293, "RtlInvertRangeList"                             },
    { 0x0294, "RtlIpv4AddressToStringA"                        },
    { 0x0295, "RtlIpv4AddressToStringExA"                      },
    { 0x0296, "RtlIpv4AddressToStringExW"                      },
    { 0x0297, "RtlIpv4AddressToStringW"                        },
    { 0x0298, "RtlIpv4StringToAddressA"                        },
    { 0x0299, "RtlIpv4StringToAddressExA"                      },
    { 0x029a, "RtlIpv4StringToAddressExW"                      },
    { 0x029b, "RtlIpv4StringToAddressW"                        },
    { 0x029c, "RtlIpv6AddressToStringA"                        },
    { 0x029d, "RtlIpv6AddressToStringExA"                      },
    { 0x029e, "RtlIpv6AddressToStringExW"                      },
    { 0x029f, "RtlIpv6AddressToStringW"                        },
    { 0x02a0, "RtlIpv6StringToAddressA"                        },
    { 0x02a1, "RtlIpv6StringToAddressExA"                      },
    { 0x02a2, "RtlIpv6StringToAddressExW"                      },
    { 0x02a3, "RtlIpv6StringToAddressW"                        },
    { 0x02a4, "RtlIsActivationContextActive"                   },
    { 0x02a5, "RtlIsDosDeviceName_U"                           },
    { 0x02a6, "RtlIsGenericTableEmpty"                         },
    { 0x02a7, "RtlIsGenericTableEmptyAvl"                      },
    { 0x02a8, "RtlIsNameLegalDOS8Dot3"                         },
    { 0x02a9, "RtlIsRangeAvailable"                            },
    { 0x02aa, "RtlIsTextUnicode"                               },
    { 0x02ab, "RtlIsThreadWithinLoaderCallout"                 },
    { 0x02ac, "RtlIsValidHandle"                               },
    { 0x02ad, "RtlIsValidIndexHandle"                          },
    { 0x02ae, "RtlLargeIntegerAdd"                             },
    { 0x02af, "RtlLargeIntegerArithmeticShift"                 },
    { 0x02b0, "RtlLargeIntegerDivide"                          },
    { 0x02b1, "RtlLargeIntegerNegate"                          },
    { 0x02b2, "RtlLargeIntegerShiftLeft"                       },
    { 0x02b3, "RtlLargeIntegerShiftRight"                      },
    { 0x02b4, "RtlLargeIntegerSubtract"                        },
    { 0x02b5, "RtlLargeIntegerToChar"                          },
    { 0x02b6, "RtlLeaveCriticalSection"                        },
    { 0x02b7, "RtlLengthRequiredSid"                           },
    { 0x02b8, "RtlLengthSecurityDescriptor"                    },
    { 0x02b9, "RtlLengthSid"                                   },
    { 0x02ba, "RtlLocalTimeToSystemTime"                       },
    { 0x02bb, "RtlLockBootStatusData"                          },
    { 0x02bc, "RtlLockHeap"                                    },
    { 0x02bd, "RtlLockMemoryStreamRegion"                      },
    { 0x02be, "RtlLogStackBackTrace"                           },
    { 0x02bf, "RtlLookupAtomInAtomTable"                       },
    { 0x02c0, "RtlLookupElementGenericTable"                   },
    { 0x02c1, "RtlLookupElementGenericTableAvl"                },
    { 0x02c2, "RtlMakeSelfRelativeSD"                          },
    { 0x02c3, "RtlMapGenericMask"                              },
    { 0x02c4, "RtlMapSecurityErrorToNtStatus"                  },
    { 0x02c5, "RtlMergeRangeLists"                             },
    { 0x02c6, "RtlMoveMemory"                                  },
    { 0x02c7, "RtlMultiAppendUnicodeStringBuffer"              },
    { 0x02c8, "RtlMultiByteToUnicodeN"                         },
    { 0x02c9, "RtlMultiByteToUnicodeSize"                      },
    { 0x02ca, "RtlNewInstanceSecurityObject"                   },
    { 0x02cb, "RtlNewSecurityGrantedAccess"                    },
    { 0x02cc, "RtlNewSecurityObject"                           },
    { 0x02cd, "RtlNewSecurityObjectEx"                         },
    { 0x02ce, "RtlNewSecurityObjectWithMultipleInheritance"    },
    { 0x02cf, "RtlNormalizeProcessParams"                      },
    { 0x02d0, "RtlNtPathNameToDosPathName"                     },
    { 0x02d1, "RtlNtStatusToDosError"                          },
    { 0x02d2, "RtlNtStatusToDosErrorNoTeb"                     },
    { 0x02d3, "RtlNumberGenericTableElements"                  },
    { 0x02d4, "RtlNumberGenericTableElementsAvl"               },
    { 0x02d5, "RtlNumberOfClearBits"                           },
    { 0x02d6, "RtlNumberOfSetBits"                             },
    { 0x02d7, "RtlOemStringToUnicodeSize"                      },
    { 0x02d8, "RtlOemStringToUnicodeString"                    },
    { 0x02d9, "RtlOemToUnicodeN"                               },
    { 0x02da, "RtlOpenCurrentUser"                             },
    { 0x02db, "RtlPcToFileHeader"                              },
    { 0x02dc, "RtlPinAtomInAtomTable"                          },
    { 0x02dd, "RtlPopFrame"                                    },
    { 0x02de, "RtlPrefixString"                                },
    { 0x02df, "RtlPrefixUnicodeString"                         },
    { 0x02e0, "RtlProtectHeap"                                 },
    { 0x02e1, "RtlPushFrame"                                   },
    { 0x02e2, "RtlQueryAtomInAtomTable"                        },
    { 0x02e3, "RtlQueryDepthSList"                             },
    { 0x02e4, "RtlQueryEnvironmentVariable_U"                  },
    { 0x02e5, "RtlQueryHeapInformation"                        },
    { 0x02e6, "RtlQueryInformationAcl"                         },
    { 0x02e7, "RtlQueryInformationActivationContext"           },
    { 0x02e8, "RtlQueryInformationActiveActivationContext"     },
    { 0x02e9, "RtlQueryInterfaceMemoryStream"                  },
    { 0x02ea, "RtlQueryProcessBackTraceInformation"            },
    { 0x02eb, "RtlQueryProcessDebugInformation"                },
    { 0x02ec, "RtlQueryProcessHeapInformation"                 },
    { 0x02ed, "RtlQueryProcessLockInformation"                 },
    { 0x02ee, "RtlQueryRegistryValues"                         },
    { 0x02ef, "RtlQuerySecurityObject"                         },
    { 0x02f0, "RtlQueryTagHeap"                                },
    { 0x02f1, "RtlQueryTimeZoneInformation"                    },
    { 0x02f2, "RtlQueueApcWow64Thread"                         },
    { 0x02f3, "RtlQueueWorkItem"                               },
    { 0x02f4, "RtlRaiseException"                              },
    { 0x02f5, "RtlRaiseStatus"                                 },
    { 0x02f6, "RtlRandom"                                      },
    { 0x02f7, "RtlRandomEx"                                    },
    { 0x02f8, "RtlReAllocateHeap"                              },
    { 0x02f9, "RtlReadMemoryStream"                            },
    { 0x02fa, "RtlReadOutOfProcessMemoryStream"                },
    { 0x02fb, "RtlRealPredecessor"                             },
    { 0x02fc, "RtlRealSuccessor"                               },
    { 0x02fd, "RtlRegisterSecureMemoryCacheCallback"           },
    { 0x02fe, "RtlRegisterWait"                                },
    { 0x02ff, "RtlReleaseActivationContext"                    },
    { 0x0300, "RtlReleaseMemoryStream"                         },
    { 0x0301, "RtlReleasePebLock"                              },
    { 0x0302, "RtlReleaseResource"                             },
    { 0x0303, "RtlRemoteCall"                                  },
    { 0x0304, "RtlRemoveVectoredExceptionHandler"              },
    { 0x0305, "RtlResetRtlTranslations"                        },
    { 0x0306, "RtlRestoreLastWin32Error"                       },
    { 0x0307, "RtlRevertMemoryStream"                          },
    { 0x0308, "RtlRunDecodeUnicodeString"                      },
    { 0x0309, "RtlRunEncodeUnicodeString"                      },
    { 0x030a, "RtlSecondsSince1970ToTime"                      },
    { 0x030b, "RtlSecondsSince1980ToTime"                      },
    { 0x030c, "RtlSeekMemoryStream"                            },
    { 0x030e, "RtlSelfRelativeToAbsoluteSD"                    },
    { 0x030d, "RtlSelfRelativeToAbsoluteSD2"                   },
    { 0x030f, "RtlSetAllBits"                                  },
    { 0x0310, "RtlSetAttributesSecurityDescriptor"             },
    { 0x0311, "RtlSetBits"                                     },
    { 0x0312, "RtlSetControlSecurityDescriptor"                },
    { 0x0313, "RtlSetCriticalSectionSpinCount"                 },
    { 0x0314, "RtlSetCurrentDirectory_U"                       },
    { 0x0315, "RtlSetCurrentEnvironment"                       },
    { 0x0316, "RtlSetDaclSecurityDescriptor"                   },
    { 0x0317, "RtlSetEnvironmentVariable"                      },
    { 0x0318, "RtlSetGroupSecurityDescriptor"                  },
    { 0x0319, "RtlSetHeapInformation"                          },
    { 0x031a, "RtlSetInformationAcl"                           },
    { 0x031b, "RtlSetIoCompletionCallback"                     },
    { 0x031c, "RtlSetLastWin32Error"                           },
    { 0x031d, "RtlSetLastWin32ErrorAndNtStatusFromNtStatus"    },
    { 0x031e, "RtlSetMemoryStreamSize"                         },
    { 0x031f, "RtlSetOwnerSecurityDescriptor"                  },
    { 0x0320, "RtlSetProcessIsCritical"                        },
    { 0x0321, "RtlSetSaclSecurityDescriptor"                   },
    { 0x0322, "RtlSetSecurityDescriptorRMControl"              },
    { 0x0323, "RtlSetSecurityObject"                           },
    { 0x0324, "RtlSetSecurityObjectEx"                         },
    { 0x0325, "RtlSetThreadIsCritical"                         },
    { 0x0326, "RtlSetThreadPoolStartFunc"                      },
    { 0x0327, "RtlSetTimeZoneInformation"                      },
    { 0x0328, "RtlSetTimer"                                    },
    { 0x0329, "RtlSetUnicodeCallouts"                          },
    { 0x032a, "RtlSetUserFlagsHeap"                            },
    { 0x032b, "RtlSetUserValueHeap"                            },
    { 0x032c, "RtlSizeHeap"                                    },
    { 0x032d, "RtlSplay"                                       },
    { 0x032e, "RtlStartRXact"                                  },
    { 0x032f, "RtlStatMemoryStream"                            },
    { 0x0330, "RtlStringFromGUID"                              },
    { 0x0331, "RtlSubAuthorityCountSid"                        },
    { 0x0332, "RtlSubAuthoritySid"                             },
    { 0x0333, "RtlSubtreePredecessor"                          },
    { 0x0334, "RtlSubtreeSuccessor"                            },
    { 0x0335, "RtlSystemTimeToLocalTime"                       },
    { 0x0336, "RtlTimeFieldsToTime"                            },
    { 0x0337, "RtlTimeToElapsedTimeFields"                     },
    { 0x0338, "RtlTimeToSecondsSince1970"                      },
    { 0x0339, "RtlTimeToSecondsSince1980"                      },
    { 0x033a, "RtlTimeToTimeFields"                            },
    { 0x033b, "RtlTraceDatabaseAdd"                            },
    { 0x033c, "RtlTraceDatabaseCreate"                         },
    { 0x033d, "RtlTraceDatabaseDestroy"                        },
    { 0x033e, "RtlTraceDatabaseEnumerate"                      },
    { 0x033f, "RtlTraceDatabaseFind"                           },
    { 0x0340, "RtlTraceDatabaseLock"                           },
    { 0x0341, "RtlTraceDatabaseUnlock"                         },
    { 0x0342, "RtlTraceDatabaseValidate"                       },
    { 0x0343, "RtlTryEnterCriticalSection"                     },
    { 0x0005, "RtlUlongByteSwap"                               },
    { 0x0006, "RtlUlonglongByteSwap"                           },
    { 0x0345, "RtlUnhandledExceptionFilter"                    },
    { 0x0344, "RtlUnhandledExceptionFilter2"                   },
    { 0x0346, "RtlUnicodeStringToAnsiSize"                     },
    { 0x0347, "RtlUnicodeStringToAnsiString"                   },
    { 0x0348, "RtlUnicodeStringToCountedOemString"             },
    { 0x0349, "RtlUnicodeStringToInteger"                      },
    { 0x034a, "RtlUnicodeStringToOemSize"                      },
    { 0x034b, "RtlUnicodeStringToOemString"                    },
    { 0x034c, "RtlUnicodeToCustomCPN"                          },
    { 0x034d, "RtlUnicodeToMultiByteN"                         },
    { 0x034e, "RtlUnicodeToMultiByteSize"                      },
    { 0x034f, "RtlUnicodeToOemN"                               },
    { 0x0350, "RtlUniform"                                     },
    { 0x0351, "RtlUnlockBootStatusData"                        },
    { 0x0352, "RtlUnlockHeap"                                  },
    { 0x0353, "RtlUnlockMemoryStreamRegion"                    },
    { 0x0354, "RtlUnwind"                                      },
    { 0x0355, "RtlUpcaseUnicodeChar"                           },
    { 0x0356, "RtlUpcaseUnicodeString"                         },
    { 0x0357, "RtlUpcaseUnicodeStringToAnsiString"             },
    { 0x0358, "RtlUpcaseUnicodeStringToCountedOemString"       },
    { 0x0359, "RtlUpcaseUnicodeStringToOemString"              },
    { 0x035a, "RtlUpcaseUnicodeToCustomCPN"                    },
    { 0x035b, "RtlUpcaseUnicodeToMultiByteN"                   },
    { 0x035c, "RtlUpcaseUnicodeToOemN"                         },
    { 0x035d, "RtlUpdateTimer"                                 },
    { 0x035e, "RtlUpperChar"                                   },
    { 0x035f, "RtlUpperString"                                 },
    { 0x0360, "RtlUsageHeap"                                   },
    { 0x0007, "RtlUshortByteSwap"                              },
    { 0x0361, "RtlValidAcl"                                    },
    { 0x0362, "RtlValidRelativeSecurityDescriptor"             },
    { 0x0363, "RtlValidSecurityDescriptor"                     },
    { 0x0364, "RtlValidSid"                                    },
    { 0x0365, "RtlValidateHeap"                                },
    { 0x0366, "RtlValidateProcessHeaps"                        },
    { 0x0367, "RtlValidateUnicodeString"                       },
    { 0x0368, "RtlVerifyVersionInfo"                           },
    { 0x0369, "RtlWalkFrameChain"                              },
    { 0x036a, "RtlWalkHeap"                                    },
    { 0x036b, "RtlWriteMemoryStream"                           },
    { 0x036c, "RtlWriteRegistryValue"                          },
    { 0x036d, "RtlZeroHeap"                                    },
    { 0x036e, "RtlZeroMemory"                                  },
    { 0x036f, "RtlZombifyActivationContext"                    },
    { 0x0370, "RtlpApplyLengthFunction"                        },
    { 0x0371, "RtlpEnsureBufferSize"                           },
    { 0x0372, "RtlpNotOwnerCriticalSection"                    },
    { 0x0373, "RtlpNtCreateKey"                                },
    { 0x0374, "RtlpNtEnumerateSubKey"                          },
    { 0x0375, "RtlpNtMakeTemporaryKey"                         },
    { 0x0376, "RtlpNtOpenKey"                                  },
    { 0x0377, "RtlpNtQueryValueKey"                            },
    { 0x0378, "RtlpNtSetValueKey"                              },
    { 0x0379, "RtlpUnWaitCriticalSection"                      },
    { 0x037a, "RtlpWaitForCriticalSection"                     },
    { 0x037b, "RtlxAnsiStringToUnicodeSize"                    },
    { 0x037c, "RtlxOemStringToUnicodeSize"                     },
    { 0x037d, "RtlxUnicodeStringToAnsiSize"                    },
    { 0x037e, "RtlxUnicodeStringToOemSize"                     },
    { 0x037f, "VerSetConditionMask"                            },
    { 0x0380, "ZwAcceptConnectPort"                            },
    { 0x0381, "ZwAccessCheck"                                  },
    { 0x0382, "ZwAccessCheckAndAuditAlarm"                     },
    { 0x0383, "ZwAccessCheckByType"                            },
    { 0x0384, "ZwAccessCheckByTypeAndAuditAlarm"               },
    { 0x0385, "ZwAccessCheckByTypeResultList"                  },
    { 0x0386, "ZwAccessCheckByTypeResultListAndAuditAlarm"     },
    { 0x0387, "ZwAccessCheckByTypeResultListAndAuditAlarmByHandle" },
    { 0x0388, "ZwAddAtom"                                      },
    { 0x0389, "ZwAddBootEntry"                                 },
    { 0x038a, "ZwAdjustGroupsToken"                            },
    { 0x038b, "ZwAdjustPrivilegesToken"                        },
    { 0x038c, "ZwAlertResumeThread"                            },
    { 0x038d, "ZwAlertThread"                                  },
    { 0x038e, "ZwAllocateLocallyUniqueId"                      },
    { 0x038f, "ZwAllocateUserPhysicalPages"                    },
    { 0x0390, "ZwAllocateUuids"                                },
    { 0x0391, "ZwAllocateVirtualMemory"                        },
    { 0x0392, "ZwAreMappedFilesTheSame"                        },
    { 0x0393, "ZwAssignProcessToJobObject"                     },
    { 0x0394, "ZwCallbackReturn"                               },
    { 0x0395, "ZwCancelDeviceWakeupRequest"                    },
    { 0x0396, "ZwCancelIoFile"                                 },
    { 0x0397, "ZwCancelTimer"                                  },
    { 0x0398, "ZwClearEvent"                                   },
    { 0x0399, "ZwClose"                                        },
    { 0x039a, "ZwCloseObjectAuditAlarm"                        },
    { 0x039b, "ZwCompactKeys"                                  },
    { 0x039c, "ZwCompareTokens"                                },
    { 0x039d, "ZwCompleteConnectPort"                          },
    { 0x039e, "ZwCompressKey"                                  },
    { 0x039f, "ZwConnectPort"                                  },
    { 0x03a0, "ZwContinue"                                     },
    { 0x03a1, "ZwCreateDebugObject"                            },
    { 0x03a2, "ZwCreateDirectoryObject"                        },
    { 0x03a3, "ZwCreateEvent"                                  },
    { 0x03a4, "ZwCreateEventPair"                              },
    { 0x03a5, "ZwCreateFile"                                   },
    { 0x03a6, "ZwCreateIoCompletion"                           },
    { 0x03a7, "ZwCreateJobObject"                              },
    { 0x03a8, "ZwCreateJobSet"                                 },
    { 0x03a9, "ZwCreateKey"                                    },
    { 0x03aa, "ZwCreateKeyedEvent"                             },
    { 0x03ab, "ZwCreateMailslotFile"                           },
    { 0x03ac, "ZwCreateMutant"                                 },
    { 0x03ad, "ZwCreateNamedPipeFile"                          },
    { 0x03ae, "ZwCreatePagingFile"                             },
    { 0x03af, "ZwCreatePort"                                   },
    { 0x03b0, "ZwCreateProcess"                                },
    { 0x03b1, "ZwCreateProcessEx"                              },
    { 0x03b2, "ZwCreateProfile"                                },
    { 0x03b3, "ZwCreateSection"                                },
    { 0x03b4, "ZwCreateSemaphore"                              },
    { 0x03b5, "ZwCreateSymbolicLinkObject"                     },
    { 0x03b6, "ZwCreateThread"                                 },
    { 0x03b7, "ZwCreateTimer"                                  },
    { 0x03b8, "ZwCreateToken"                                  },
    { 0x03b9, "ZwCreateWaitablePort"                           },
    { 0x03ba, "ZwDebugActiveProcess"                           },
    { 0x03bb, "ZwDebugContinue"                                },
    { 0x03bc, "ZwDelayExecution"                               },
    { 0x03bd, "ZwDeleteAtom"                                   },
    { 0x03be, "ZwDeleteBootEntry"                              },
    { 0x03bf, "ZwDeleteFile"                                   },
    { 0x03c0, "ZwDeleteKey"                                    },
    { 0x03c1, "ZwDeleteObjectAuditAlarm"                       },
    { 0x03c2, "ZwDeleteValueKey"                               },
    { 0x03c3, "ZwDeviceIoControlFile"                          },
    { 0x03c4, "ZwDisplayString"                                },
    { 0x03c5, "ZwDuplicateObject"                              },
    { 0x03c6, "ZwDuplicateToken"                               },
    { 0x03c7, "ZwEnumerateBootEntries"                         },
    { 0x03c8, "ZwEnumerateKey"                                 },
    { 0x03c9, "ZwEnumerateSystemEnvironmentValuesEx"           },
    { 0x03ca, "ZwEnumerateValueKey"                            },
    { 0x03cb, "ZwExtendSection"                                },
    { 0x03cc, "ZwFilterToken"                                  },
    { 0x03cd, "ZwFindAtom"                                     },
    { 0x03ce, "ZwFlushBuffersFile"                             },
    { 0x03cf, "ZwFlushInstructionCache"                        },
    { 0x03d0, "ZwFlushKey"                                     },
    { 0x03d1, "ZwFlushVirtualMemory"                           },
    { 0x03d2, "ZwFlushWriteBuffer"                             },
    { 0x03d3, "ZwFreeUserPhysicalPages"                        },
    { 0x03d4, "ZwFreeVirtualMemory"                            },
    { 0x03d5, "ZwFsControlFile"                                },
    { 0x03d6, "ZwGetContextThread"                             },
    { 0x03d7, "ZwGetDevicePowerState"                          },
    { 0x03d8, "ZwGetPlugPlayEvent"                             },
    { 0x03d9, "ZwGetWriteWatch"                                },
    { 0x03da, "ZwImpersonateAnonymousToken"                    },
    { 0x03db, "ZwImpersonateClientOfPort"                      },
    { 0x03dc, "ZwImpersonateThread"                            },
    { 0x03dd, "ZwInitializeRegistry"                           },
    { 0x03de, "ZwInitiatePowerAction"                          },
    { 0x03df, "ZwIsProcessInJob"                               },
    { 0x03e0, "ZwIsSystemResumeAutomatic"                      },
    { 0x03e1, "ZwListenPort"                                   },
    { 0x03e2, "ZwLoadDriver"                                   },
    { 0x03e4, "ZwLoadKey"                                      },
    { 0x03e3, "ZwLoadKey2"                                     },
    { 0x03e5, "ZwLockFile"                                     },
    { 0x03e6, "ZwLockProductActivationKeys"                    },
    { 0x03e7, "ZwLockRegistryKey"                              },
    { 0x03e8, "ZwLockVirtualMemory"                            },
    { 0x03e9, "ZwMakePermanentObject"                          },
    { 0x03ea, "ZwMakeTemporaryObject"                          },
    { 0x03eb, "ZwMapUserPhysicalPages"                         },
    { 0x03ec, "ZwMapUserPhysicalPagesScatter"                  },
    { 0x03ed, "ZwMapViewOfSection"                             },
    { 0x03ee, "ZwModifyBootEntry"                              },
    { 0x03ef, "ZwNotifyChangeDirectoryFile"                    },
    { 0x03f0, "ZwNotifyChangeKey"                              },
    { 0x03f1, "ZwNotifyChangeMultipleKeys"                     },
    { 0x03f2, "ZwOpenDirectoryObject"                          },
    { 0x03f3, "ZwOpenEvent"                                    },
    { 0x03f4, "ZwOpenEventPair"                                },
    { 0x03f5, "ZwOpenFile"                                     },
    { 0x03f6, "ZwOpenIoCompletion"                             },
    { 0x03f7, "ZwOpenJobObject"                                },
    { 0x03f8, "ZwOpenKey"                                      },
    { 0x03f9, "ZwOpenKeyedEvent"                               },
    { 0x03fa, "ZwOpenMutant"                                   },
    { 0x03fb, "ZwOpenObjectAuditAlarm"                         },
    { 0x03fc, "ZwOpenProcess"                                  },
    { 0x03fd, "ZwOpenProcessToken"                             },
    { 0x03fe, "ZwOpenProcessTokenEx"                           },
    { 0x03ff, "ZwOpenSection"                                  },
    { 0x0400, "ZwOpenSemaphore"                                },
    { 0x0401, "ZwOpenSymbolicLinkObject"                       },
    { 0x0402, "ZwOpenThread"                                   },
    { 0x0403, "ZwOpenThreadToken"                              },
    { 0x0404, "ZwOpenThreadTokenEx"                            },
    { 0x0405, "ZwOpenTimer"                                    },
    { 0x0406, "ZwPlugPlayControl"                              },
    { 0x0407, "ZwPowerInformation"                             },
    { 0x0408, "ZwPrivilegeCheck"                               },
    { 0x0409, "ZwPrivilegeObjectAuditAlarm"                    },
    { 0x040a, "ZwPrivilegedServiceAuditAlarm"                  },
    { 0x040b, "ZwProtectVirtualMemory"                         },
    { 0x040c, "ZwPulseEvent"                                   },
    { 0x040d, "ZwQueryAttributesFile"                          },
    { 0x040e, "ZwQueryBootEntryOrder"                          },
    { 0x040f, "ZwQueryBootOptions"                             },
    { 0x0410, "ZwQueryDebugFilterState"                        },
    { 0x0411, "ZwQueryDefaultLocale"                           },
    { 0x0412, "ZwQueryDefaultUILanguage"                       },
    { 0x0413, "ZwQueryDirectoryFile"                           },
    { 0x0414, "ZwQueryDirectoryObject"                         },
    { 0x0415, "ZwQueryEaFile"                                  },
    { 0x0416, "ZwQueryEvent"                                   },
    { 0x0417, "ZwQueryFullAttributesFile"                      },
    { 0x0418, "ZwQueryInformationAtom"                         },
    { 0x0419, "ZwQueryInformationFile"                         },
    { 0x041a, "ZwQueryInformationJobObject"                    },
    { 0x041b, "ZwQueryInformationPort"                         },
    { 0x041c, "ZwQueryInformationProcess"                      },
    { 0x041d, "ZwQueryInformationThread"                       },
    { 0x041e, "ZwQueryInformationToken"                        },
    { 0x041f, "ZwQueryInstallUILanguage"                       },
    { 0x0420, "ZwQueryIntervalProfile"                         },
    { 0x0421, "ZwQueryIoCompletion"                            },
    { 0x0422, "ZwQueryKey"                                     },
    { 0x0423, "ZwQueryMultipleValueKey"                        },
    { 0x0424, "ZwQueryMutant"                                  },
    { 0x0425, "ZwQueryObject"                                  },
    { 0x0426, "ZwQueryOpenSubKeys"                             },
    { 0x0427, "ZwQueryPerformanceCounter"                      },
    { 0x0428, "ZwQueryPortInformationProcess"                  },
    { 0x0429, "ZwQueryQuotaInformationFile"                    },
    { 0x042a, "ZwQuerySection"                                 },
    { 0x042b, "ZwQuerySecurityObject"                          },
    { 0x042c, "ZwQuerySemaphore"                               },
    { 0x042d, "ZwQuerySymbolicLinkObject"                      },
    { 0x042e, "ZwQuerySystemEnvironmentValue"                  },
    { 0x042f, "ZwQuerySystemEnvironmentValueEx"                },
    { 0x0430, "ZwQuerySystemInformation"                       },
    { 0x0431, "ZwQuerySystemTime"                              },
    { 0x0432, "ZwQueryTimer"                                   },
    { 0x0433, "ZwQueryTimerResolution"                         },
    { 0x0434, "ZwQueryValueKey"                                },
    { 0x0435, "ZwQueryVirtualMemory"                           },
    { 0x0436, "ZwQueryVolumeInformationFile"                   },
    { 0x0437, "ZwQueueApcThread"                               },
    { 0x0438, "ZwRaiseException"                               },
    { 0x0439, "ZwRaiseHardError"                               },
    { 0x043a, "ZwReadFile"                                     },
    { 0x043b, "ZwReadFileScatter"                              },
    { 0x043c, "ZwReadRequestData"                              },
    { 0x043d, "ZwReadVirtualMemory"                            },
    { 0x043e, "ZwRegisterThreadTerminatePort"                  },
    { 0x043f, "ZwReleaseKeyedEvent"                            },
    { 0x0440, "ZwReleaseMutant"                                },
    { 0x0441, "ZwReleaseSemaphore"                             },
    { 0x0442, "ZwRemoveIoCompletion"                           },
    { 0x0443, "ZwRemoveProcessDebug"                           },
    { 0x0444, "ZwRenameKey"                                    },
    { 0x0445, "ZwReplaceKey"                                   },
    { 0x0446, "ZwReplyPort"                                    },
    { 0x0447, "ZwReplyWaitReceivePort"                         },
    { 0x0448, "ZwReplyWaitReceivePortEx"                       },
    { 0x0449, "ZwReplyWaitReplyPort"                           },
    { 0x044a, "ZwRequestDeviceWakeup"                          },
    { 0x044b, "ZwRequestPort"                                  },
    { 0x044c, "ZwRequestWaitReplyPort"                         },
    { 0x044d, "ZwRequestWakeupLatency"                         },
    { 0x044e, "ZwResetEvent"                                   },
    { 0x044f, "ZwResetWriteWatch"                              },
    { 0x0450, "ZwRestoreKey"                                   },
    { 0x0451, "ZwResumeProcess"                                },
    { 0x0452, "ZwResumeThread"                                 },
    { 0x0453, "ZwSaveKey"                                      },
    { 0x0454, "ZwSaveKeyEx"                                    },
    { 0x0455, "ZwSaveMergedKeys"                               },
    { 0x0456, "ZwSecureConnectPort"                            },
    { 0x0457, "ZwSetBootEntryOrder"                            },
    { 0x0458, "ZwSetBootOptions"                               },
    { 0x0459, "ZwSetContextThread"                             },
    { 0x045a, "ZwSetDebugFilterState"                          },
    { 0x045b, "ZwSetDefaultHardErrorPort"                      },
    { 0x045c, "ZwSetDefaultLocale"                             },
    { 0x045d, "ZwSetDefaultUILanguage"                         },
    { 0x045e, "ZwSetEaFile"                                    },
    { 0x045f, "ZwSetEvent"                                     },
    { 0x0460, "ZwSetEventBoostPriority"                        },
    { 0x0461, "ZwSetHighEventPair"                             },
    { 0x0462, "ZwSetHighWaitLowEventPair"                      },
    { 0x0463, "ZwSetInformationDebugObject"                    },
    { 0x0464, "ZwSetInformationFile"                           },
    { 0x0465, "ZwSetInformationJobObject"                      },
    { 0x0466, "ZwSetInformationKey"                            },
    { 0x0467, "ZwSetInformationObject"                         },
    { 0x0468, "ZwSetInformationProcess"                        },
    { 0x0469, "ZwSetInformationThread"                         },
    { 0x046a, "ZwSetInformationToken"                          },
    { 0x046b, "ZwSetIntervalProfile"                           },
    { 0x046c, "ZwSetIoCompletion"                              },
    { 0x046d, "ZwSetLdtEntries"                                },
    { 0x046e, "ZwSetLowEventPair"                              },
    { 0x046f, "ZwSetLowWaitHighEventPair"                      },
    { 0x0470, "ZwSetQuotaInformationFile"                      },
    { 0x0471, "ZwSetSecurityObject"                            },
    { 0x0472, "ZwSetSystemEnvironmentValue"                    },
    { 0x0473, "ZwSetSystemEnvironmentValueEx"                  },
    { 0x0474, "ZwSetSystemInformation"                         },
    { 0x0475, "ZwSetSystemPowerState"                          },
    { 0x0476, "ZwSetSystemTime"                                },
    { 0x0477, "ZwSetThreadExecutionState"                      },
    { 0x0478, "ZwSetTimer"                                     },
    { 0x0479, "ZwSetTimerResolution"                           },
    { 0x047a, "ZwSetUuidSeed"                                  },
    { 0x047b, "ZwSetValueKey"                                  },
    { 0x047c, "ZwSetVolumeInformationFile"                     },
    { 0x047d, "ZwShutdownSystem"                               },
    { 0x047e, "ZwSignalAndWaitForSingleObject"                 },
    { 0x047f, "ZwStartProfile"                                 },
    { 0x0480, "ZwStopProfile"                                  },
    { 0x0481, "ZwSuspendProcess"                               },
    { 0x0482, "ZwSuspendThread"                                },
    { 0x0483, "ZwSystemDebugControl"                           },
    { 0x0484, "ZwTerminateJobObject"                           },
    { 0x0485, "ZwTerminateProcess"                             },
    { 0x0486, "ZwTerminateThread"                              },
    { 0x0487, "ZwTestAlert"                                    },
    { 0x0488, "ZwTraceEvent"                                   },
    { 0x0489, "ZwTranslateFilePath"                            },
    { 0x048a, "ZwUnloadDriver"                                 },
    { 0x048b, "ZwUnloadKey"                                    },
    { 0x048c, "ZwUnloadKeyEx"                                  },
    { 0x048d, "ZwUnlockFile"                                   },
    { 0x048e, "ZwUnlockVirtualMemory"                          },
    { 0x048f, "ZwUnmapViewOfSection"                           },
    { 0x0490, "ZwVdmControl"                                   },
    { 0x0491, "ZwWaitForDebugEvent"                            },
    { 0x0492, "ZwWaitForKeyedEvent"                            },
    { 0x0493, "ZwWaitForMultipleObjects"                       },
    { 0x0494, "ZwWaitForSingleObject"                          },
    { 0x0495, "ZwWaitHighEventPair"                            },
    { 0x0496, "ZwWaitLowEventPair"                             },
    { 0x0497, "ZwWriteFile"                                    },
    { 0x0498, "ZwWriteFileGather"                              },
    { 0x0499, "ZwWriteRequestData"                             },
    { 0x049a, "ZwWriteVirtualMemory"                           },
    { 0x049b, "ZwYieldExecution"                               },
    { 0x049c, "_CIcos"                                         },
    { 0x049d, "_CIlog"                                         },
    { 0x049e, "_CIpow"                                         },
    { 0x049f, "_CIsin"                                         },
    { 0x04a0, "_CIsqrt"                                        },
    { 0x04a1, "__isascii"                                      },
    { 0x04a2, "__iscsym"                                       },
    { 0x04a3, "__iscsymf"                                      },
    { 0x04a4, "__toascii"                                      },
    { 0x04a5, "_alldiv"                                        },
    { 0x04a6, "_alldvrm"                                       },
    { 0x04a7, "_allmul"                                        },
    { 0x04a8, "_alloca_probe"                                  },
    { 0x04a9, "_allrem"                                        },
    { 0x04aa, "_allshl"                                        },
    { 0x04ab, "_allshr"                                        },
    { 0x04ac, "_atoi64"                                        },
    { 0x04ad, "_aulldiv"                                       },
    { 0x04ae, "_aulldvrm"                                      },
    { 0x04af, "_aullrem"                                       },
    { 0x04b0, "_aullshr"                                       },
    { 0x04b1, "_chkstk"                                        },
    { 0x04b2, "_fltused"                                       },
    { 0x04b3, "_ftol"                                          },
    { 0x04b4, "_i64toa"                                        },
    { 0x04b5, "_i64tow"                                        },
    { 0x04b6, "_itoa"                                          },
    { 0x04b7, "_itow"                                          },
    { 0x04b8, "_lfind"                                         },
    { 0x04b9, "_ltoa"                                          },
    { 0x04ba, "_ltow"                                          },
    { 0x04bb, "_memccpy"                                       },
    { 0x04bc, "_memicmp"                                       },
    { 0x04bd, "_snprintf"                                      },
    { 0x04be, "_snwprintf"                                     },
    { 0x04bf, "_splitpath"                                     },
    { 0x04c0, "_strcmpi"                                       },
    { 0x04c1, "_stricmp"                                       },
    { 0x04c2, "_strlwr"                                        },
    { 0x04c3, "_strnicmp"                                      },
    { 0x04c4, "_strupr"                                        },
    { 0x04c5, "_tolower"                                       },
    { 0x04c6, "_toupper"                                       },
    { 0x04c7, "_ui64toa"                                       },
    { 0x04c8, "_ui64tow"                                       },
    { 0x04c9, "_ultoa"                                         },
    { 0x04ca, "_ultow"                                         },
    { 0x04cb, "_vsnprintf"                                     },
    { 0x04cc, "_vsnwprintf"                                    },
    { 0x04cd, "_wcsicmp"                                       },
    { 0x04ce, "_wcslwr"                                        },
    { 0x04cf, "_wcsnicmp"                                      },
    { 0x04d0, "_wcsupr"                                        },
    { 0x04d1, "_wtoi"                                          },
    { 0x04d2, "_wtoi64"                                        },
    { 0x04d3, "_wtol"                                          },
    { 0x04d4, "abs"                                            },
    { 0x04d5, "atan"                                           },
    { 0x04d6, "atoi"                                           },
    { 0x04d7, "atol"                                           },
    { 0x04d8, "bsearch"                                        },
    { 0x04d9, "ceil"                                           },
    { 0x04da, "cos"                                            },
    { 0x04db, "fabs"                                           },
    { 0x04dc, "floor"                                          },
    { 0x04dd, "isalnum"                                        },
    { 0x04de, "isalpha"                                        },
    { 0x04df, "iscntrl"                                        },
    { 0x04e0, "isdigit"                                        },
    { 0x04e1, "isgraph"                                        },
    { 0x04e2, "islower"                                        },
    { 0x04e3, "isprint"                                        },
    { 0x04e4, "ispunct"                                        },
    { 0x04e5, "isspace"                                        },
    { 0x04e6, "isupper"                                        },
    { 0x04e7, "iswalpha"                                       },
    { 0x04e8, "iswctype"                                       },
    { 0x04e9, "iswdigit"                                       },
    { 0x04ea, "iswlower"                                       },
    { 0x04eb, "iswspace"                                       },
    { 0x04ec, "iswxdigit"                                      },
    { 0x04ed, "isxdigit"                                       },
    { 0x04ee, "labs"                                           },
    { 0x04ef, "log"                                            },
    { 0x04f0, "mbstowcs"                                       },
    { 0x04f1, "memchr"                                         },
    { 0x04f2, "memcmp"                                         },
    { 0x04f3, "memcpy"                                         },
    { 0x04f4, "memmove"                                        },
    { 0x04f5, "memset"                                         },
    { 0x04f6, "pow"                                            },
    { 0x04f7, "qsort"                                          },
    { 0x04f8, "sin"                                            },
    { 0x04f9, "sprintf"                                        },
    { 0x04fa, "sqrt"                                           },
    { 0x04fb, "sscanf"                                         },
    { 0x04fc, "strcat"                                         },
    { 0x04fd, "strchr"                                         },
    { 0x04fe, "strcmp"                                         },
    { 0x04ff, "strcpy"                                         },
    { 0x0500, "strcspn"                                        },
    { 0x0501, "strlen"                                         },
    { 0x0502, "strncat"                                        },
    { 0x0503, "strncmp"                                        },
    { 0x0504, "strncpy"                                        },
    { 0x0505, "strpbrk"                                        },
    { 0x0506, "strrchr"                                        },
    { 0x0507, "strspn"                                         },
    { 0x0508, "strstr"                                         },
    { 0x0509, "strtol"                                         },
    { 0x050a, "strtoul"                                        },
    { 0x050b, "swprintf"                                       },
    { 0x050c, "tan"                                            },
    { 0x050d, "tolower"                                        },
    { 0x050e, "toupper"                                        },
    { 0x050f, "towlower"                                       },
    { 0x0510, "towupper"                                       },
    { 0x0511, "vDbgPrintEx"                                    },
    { 0x0512, "vDbgPrintExWithPrefix"                          },
    { 0x0513, "vsprintf"                                       },
    { 0x0514, "wcscat"                                         },
    { 0x0515, "wcschr"                                         },
    { 0x0516, "wcscmp"                                         },
    { 0x0517, "wcscpy"                                         },
    { 0x0518, "wcscspn"                                        },
    { 0x0519, "wcslen"                                         },
    { 0x051a, "wcsncat"                                        },
    { 0x051b, "wcsncmp"                                        },
    { 0x051c, "wcsncpy"                                        },
    { 0x051d, "wcspbrk"                                        },
    { 0x051e, "wcsrchr"                                        },
    { 0x051f, "wcsspn"                                         },
    { 0x0520, "wcsstr"                                         },
    { 0x0521, "wcstol"                                         },
    { 0x0522, "wcstombs"                                       },
    { 0x0523, "wcstoul"                                        },
};


}
}

#endif

