from Crypto.Cipher import AES
import random
import string
import redis
import os

DEFAULT_IV_PATH = './ivr'
DEFAULT_KEY_PATH = './key'


# utility function used across all methods here to make sure defaults are read if no path is specified
def get_paths(key, ivr):
    _key = DEFAULT_KEY_PATH if key is None else key
    _ivr = DEFAULT_IV_PATH if ivr is None else ivr
    return _key, _ivr


def initialize_encryption(key_path=None, ivr_path=None):
    """ This function (re)generates the keys we'll use for encryption and stores them on the file system."""
    key_path, ivr_path = get_paths(key_path, ivr_path)
    # We are using w+ here because during initialization, we are absolutely going to want to truncate it
    # and write a new key.
    with open(key_path, "w+") as key:
        key.write(''.join(random.choice(string.ascii_uppercase + string.ascii_lowercase + string.digits) for _ in range(16)))
    # with CFB, the IV must be at least length of 16
    with open(ivr_path, "w+") as ivr:
        ivr.write(''.join(random.choice(string.ascii_uppercase + string.ascii_lowercase + string.digits) for _ in range(16)))


# private method
def get_hash(key_path, ivr_path):
    """ This is a utility function to grab the values needed to produce the AES key"""
    with open(key_path, "r+") as key_file:
        key = key_file.read()
    with open(ivr_path, "r+") as ivr_file:
        ivr = ivr_file.read()
    return AES.new(key, AES.MODE_CFB, ivr)


def setencrypted(name, value, key_path=None, ivr_path=None, overredis=None):
    """ This sets a value encrypted in redis """
    key_path, ivr_path = get_paths(key_path, ivr_path)
    aes = get_hash(key_path, ivr_path)
    ciphertext = aes.encrypt(value)
    r = overredis if overredis is not None else loadconfiguration()
    r.set(name, ciphertext)


def getencrypted(name, key_path=None, ivr_path=None, overredis=None):
    """ This gets a value that is encrypted in redis."""
    key_path, ivr_path = get_paths(key_path, ivr_path)
    r = overredis if overredis is not None else loadconfiguration()
    cipher = r.get(name)
    aes = get_hash(key_path, ivr_path)
    return aes.decrypt(cipher)


def test_availability(overredis=None):
    test = loadconfiguration(overredis)
    return True if test is not None else False


def loadconfiguration(override=None):
    try:
        if override is not None:
            return redis.StrictRedis(host=override)
        else:
            url = os.environ['REDIS_ENDPOINT']
            return redis.StrictRedis(host=url)
    except Exception, e:
        raise e
