# Copyright (c) 2013, The MITRE Corporation. All rights reserved.
# See LICENSE.txt for complete terms.

#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Thu Apr 11 15:06:30 2013 by generateDS.py version 2.9a.
#

import sys
import getopt
import re as re_

import cybox.bindings.cybox_core as cybox_core_binding
import cybox.bindings.cybox_common as cybox_common_binding
import stix.bindings.stix_common as stix_common_binding
import stix.bindings.data_marking as data_marking_binding

import base64
from datetime import datetime, tzinfo, timedelta

XML_NS = "http://stix.mitre.org/TTP-1"

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
# lxml
from lxml import etree as etree_
XMLParser_import_library = XMLParser_import_lxml
if Verbose_import_:
    print("running with lxml.etree")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser(huge_tree=True)
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(tzinfo):
            def __init__(self, offset, name):
                self.__offset = timedelta(minutes = offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S')
            else:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S.%f')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_datetime(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S')
            return dt.replace(tzinfo = tz)

        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = input_data.strftime('%Y-%m-%d')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_date(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            return datetime.strptime(input_data,
                '%Y-%m-%d').replace(tzinfo = tz)
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' %
                (self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class AttackPatternType(GeneratedsSuper):
    """Captures prose information about an individual attack pattern as
    well as a CAPEC reference. In addition to capturing basic
    information, this type is intended to be extended to enable the
    structured description of an attack pattern instance using the
    XML Schema extension feature. The STIX default extension uses
    the Common Attack Pattern Enumeration and Classification (CAPEC)
    schema to do so. The extension that defines this is captured in
    the CAPEC2.5InstanceType in the
    http://stix.mitre.org/extensions/AP#CAPEC2.5-1 namespace. This
    type is defined in the extensions/attack_pattern/capec_2.5.xsd
    file or at the URL http://stix.mitre.org/XMLSchema/extensions/at
    tack_pattern/capec_2.5/1.0/capec_2.5.xsd. This field specifies a
    reference to a particular entry within the Common Attack Pattern
    Enumeration and Classification (CAPEC)"""
    subclass = None
    superclass = None
    def __init__(self, capec_id=None, Description=None):
        self.capec_id = _cast(None, capec_id)
        self.Description = Description
    def factory(*args_, **kwargs_):
        if AttackPatternType.subclass:
            return AttackPatternType.subclass(*args_, **kwargs_)
        else:
            return AttackPatternType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_capec_id(self): return self.capec_id
    def set_capec_id(self, capec_id): self.capec_id = capec_id
    def hasContent_(self):
        if (
            self.Description is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, nsmap, namespace_=XML_NS, name_='AttackPatternType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AttackPatternType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ttp:', name_='AttackPatternType'):
        if self.capec_id is not None and 'capec_id' not in already_processed:
            already_processed.add('capec_id')
            outfile.write(' capec_id=%s' % (self.gds_format_string(quote_attrib(self.capec_id).encode(ExternalEncoding), input_name='capec_id'), ))
    def exportChildren(self, outfile, level, nsmap, namespace_=XML_NS, name_='AttackPatternType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            self.Description.export(outfile, level, nsmap, namespace_, name_='Description', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='AttackPatternType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.capec_id is not None and 'capec_id' not in already_processed:
            already_processed.add('capec_id')
            showIndent(outfile, level)
            outfile.write('capec_id = "%s",\n' % (self.capec_id,))
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Description is not None:
            outfile.write('Description=model_.stix_common_binding.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('capec_id', node)
        if value is not None and 'capec_id' not in already_processed:
            already_processed.add('capec_id')
            self.capec_id = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            obj_ = stix_common_binding.StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
# end class AttackPatternType

class MalwareInstanceType(GeneratedsSuper):
    """Captures basic information about an individual malware instance. In
    addition to capturing basic information, this type is intended
    to be extended to enable the structured description of a malware
    instance using the XML Schema extension feature. The STIX
    default extension uses the Malware Attribute Enumeration and
    Classification (MAEC) schema to do so. The extension that
    defines this is captured in the MAECInstanceType in the
    http://stix.mitre.org/extensions/Malware#MAEC-1 namespace. This
    type is defined in the extensions/malware/maec-4.0.xsd file or
    at the URL http://stix.mitre.org/XMLSchema/extensions/malware/ma
    ec-4.0/1.0/maec-4.0.xsd."""
    subclass = None
    superclass = None
    def __init__(self, Type=None, Name=None, Description=None):
        if Type is None:
            self.Type = []
        else:
            self.Type = Type
        if Name is None:
            self.Name = []
        else:
            self.Name = Name
        self.Description = Description
    def factory(*args_, **kwargs_):
        if MalwareInstanceType.subclass:
            return MalwareInstanceType.subclass(*args_, **kwargs_)
        else:
            return MalwareInstanceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def add_Type(self, value): self.Type.append(value)
    def insert_Type(self, index, value): self.Type[index] = value
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def add_Name(self, value): self.Name.append(value)
    def insert_Name(self, index, value): self.Name[index] = value
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def hasContent_(self):
        if (
            self.Type or
            self.Name or
            self.Description is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, nsmap, namespace_=XML_NS, name_='MalwareInstanceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MalwareInstanceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ttp:', name_='MalwareInstanceType'):
        pass
    def exportChildren(self, outfile, level, nsmap, namespace_=XML_NS, name_='MalwareInstanceType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Type_ in self.Type:
            Type_.export(outfile, level, nsmap, namespace_, name_='Type', pretty_print=pretty_print)
        for Name_ in self.Name:
            Name_.export(outfile, level, nsmap, namespace_, name_='Name', pretty_print=pretty_print)
        if self.Description is not None:
            self.Description.export(outfile, level, nsmap, namespace_, name_='Description', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='MalwareInstanceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Type=[\n')
        level += 1
        for Type_ in self.Type:
            outfile.write('model_.stix_common_binding.ControlledVocabularyStringType(\n')
            Type_.exportLiteral(outfile, level, name_='stix_common_binding.ControlledVocabularyStringType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Name=[\n')
        level += 1
        for Name_ in self.Name:
            outfile.write('model_.stix_common_binding.ControlledVocabularyStringType(\n')
            Name_.exportLiteral(outfile, level, name_='stix_common_binding.ControlledVocabularyStringType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Description is not None:
            outfile.write('Description=model_.stix_common_binding.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Type':
            obj_ = stix_common_binding.ControlledVocabularyStringType.factory()
            obj_.build(child_)
            self.Type.append(obj_)
        elif nodeName_ == 'Name':
            obj_ = stix_common_binding.ControlledVocabularyStringType.factory()
            obj_.build(child_)
            self.Name.append(obj_)
        elif nodeName_ == 'Description':
            obj_ = stix_common_binding.StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
# end class MalwareInstanceType

class ExploitType(GeneratedsSuper):
    """Characterizes a description of an individual exploit. In addition to
    capturing basic information, this type is intended to be
    extended to enable the structured description of an exploit
    using the XML Schema extension feature. No extension is provided
    by STIX to support this, however those wishing to represent
    structured exploit information may develop such an extension."""
    subclass = None
    superclass = None
    def __init__(self, Description=None):
        self.Description = Description
    def factory(*args_, **kwargs_):
        if ExploitType.subclass:
            return ExploitType.subclass(*args_, **kwargs_)
        else:
            return ExploitType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def hasContent_(self):
        if (
            self.Description is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, nsmap, namespace_=XML_NS, name_='ExploitType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExploitType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ttp:', name_='ExploitType'):
        pass
    def exportChildren(self, outfile, level, nsmap, namespace_=XML_NS, name_='ExploitType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Description is not None:
            self.Description.export(outfile, level, nsmap, namespace_, name_='Description', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ExploitType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Description is not None:
            outfile.write('Description=model_.stix_common_binding.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            obj_ = stix_common_binding.StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
# end class ExploitType

class InfrastructureType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Type=None, Description=None, Observable_Characterization=None):
        if Type is None:
            self.Type = []
        else:
            self.Type = Type
        self.Description = Description
        self.Observable_Characterization = Observable_Characterization
    def factory(*args_, **kwargs_):
        if InfrastructureType.subclass:
            return InfrastructureType.subclass(*args_, **kwargs_)
        else:
            return InfrastructureType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def add_Type(self, value): self.Type.append(value)
    def insert_Type(self, index, value): self.Type[index] = value
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Observable_Characterization(self): return self.Observable_Characterization
    def set_Observable_Characterization(self, Observable_Characterization): self.Observable_Characterization = Observable_Characterization
    def hasContent_(self):
        if (
            self.Type or
            self.Description is not None or
            self.Observable_Characterization is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, nsmap, namespace_=XML_NS, name_='InfrastructureType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='InfrastructureType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ttp:', name_='InfrastructureType'):
        pass
    def exportChildren(self, outfile, level, nsmap, namespace_=XML_NS, name_='InfrastructureType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Type_ in self.Type:
            Type_.export(outfile, level, nsmap, namespace_, name_='Type', pretty_print=pretty_print)
        if self.Description is not None:
            self.Description.export(outfile, level, nsmap, namespace_, name_='Description', pretty_print=pretty_print)
        if self.Observable_Characterization is not None:
            self.Observable_Characterization.export(outfile, level, "%s:" % (nsmap[namespace_]), name_='Observable_Characterization', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='InfrastructureType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Type=[\n')
        level += 1
        for Type_ in self.Type:
            outfile.write('model_.stix_common_binding.ControlledVocabularyStringType(\n')
            Type_.exportLiteral(outfile, level, name_='stix_common_binding.ControlledVocabularyStringType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Description is not None:
            outfile.write('Description=model_.stix_common_binding.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            outfile.write('),\n')
        if self.Observable_Characterization is not None:
            outfile.write('Observable_Characterization=model_.cybox_core_binding.ObservablesType(\n')
            self.Observable_Characterization.exportLiteral(outfile, level, name_='Observable_Characterization')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Type':
            obj_ = stix_common_binding.ControlledVocabularyStringType.factory()
            obj_.build(child_)
            self.Type.append(obj_)
        elif nodeName_ == 'Description':
            obj_ = stix_common_binding.StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif nodeName_ == 'Observable_Characterization':
            obj_ = cybox_core_binding.ObservablesType.factory()
            obj_.build(child_)
            self.set_Observable_Characterization(obj_)
# end class InfrastructureType

class ToolsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Tool=None):
        if Tool is None:
            self.Tool = []
        else:
            self.Tool = Tool
    def factory(*args_, **kwargs_):
        if ToolsType.subclass:
            return ToolsType.subclass(*args_, **kwargs_)
        else:
            return ToolsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Tool(self): return self.Tool
    def set_Tool(self, Tool): self.Tool = Tool
    def add_Tool(self, value): self.Tool.append(value)
    def insert_Tool(self, index, value): self.Tool[index] = value
    def hasContent_(self):
        if (
            self.Tool
            ):
            return True
        else:
            return False
    def export(self, outfile, level, nsmap, namespace_=XML_NS, name_='ToolsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ToolsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ttp:', name_='ToolsType'):
        pass
    def exportChildren(self, outfile, level, nsmap, namespace_=XML_NS, name_='ToolsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Tool_ in self.Tool:
            Tool_.export(outfile, level, "%s:" % (nsmap[namespace_]), name_='Tool', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ToolsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Tool=[\n')
        level += 1
        for Tool_ in self.Tool:
            outfile.write('model_.cybox_common_binding.ToolInformationType(\n')
            Tool_.exportLiteral(outfile, level, name_='cybox_common_binding.ToolInformationType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Tool':
            obj_ = cybox_common_binding.ToolInformationType.factory()
            obj_.build(child_)
            self.Tool.append(obj_)
# end class ToolsType

class ExploitsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Exploit=None):
        if Exploit is None:
            self.Exploit = []
        else:
            self.Exploit = Exploit
    def factory(*args_, **kwargs_):
        if ExploitsType.subclass:
            return ExploitsType.subclass(*args_, **kwargs_)
        else:
            return ExploitsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Exploit(self): return self.Exploit
    def set_Exploit(self, Exploit): self.Exploit = Exploit
    def add_Exploit(self, value): self.Exploit.append(value)
    def insert_Exploit(self, index, value): self.Exploit[index] = value
    def hasContent_(self):
        if (
            self.Exploit
            ):
            return True
        else:
            return False
    def export(self, outfile, level, nsmap, namespace_=XML_NS, name_='ExploitsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ExploitsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ttp:', name_='ExploitsType'):
        pass
    def exportChildren(self, outfile, level, nsmap, namespace_=XML_NS, name_='ExploitsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Exploit_ in self.Exploit:
            Exploit_.export(outfile, level, nsmap, namespace_, name_='Exploit', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ExploitsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Exploit=[\n')
        level += 1
        for Exploit_ in self.Exploit:
            outfile.write('model_.ExploitType(\n')
            Exploit_.exportLiteral(outfile, level, name_='ExploitType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Exploit':
            obj_ = ExploitType.factory()
            obj_.build(child_)
            self.Exploit.append(obj_)
# end class ExploitsType

class MalwareType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Malware_Instance=None):
        if Malware_Instance is None:
            self.Malware_Instance = []
        else:
            self.Malware_Instance = Malware_Instance
    def factory(*args_, **kwargs_):
        if MalwareType.subclass:
            return MalwareType.subclass(*args_, **kwargs_)
        else:
            return MalwareType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Malware_Instance(self): return self.Malware_Instance
    def set_Malware_Instance(self, Malware_Instance): self.Malware_Instance = Malware_Instance
    def add_Malware_Instance(self, value): self.Malware_Instance.append(value)
    def insert_Malware_Instance(self, index, value): self.Malware_Instance[index] = value
    def hasContent_(self):
        if (
            self.Malware_Instance
            ):
            return True
        else:
            return False
    def export(self, outfile, level, nsmap, namespace_=XML_NS, name_='MalwareType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MalwareType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ttp:', name_='MalwareType'):
        pass
    def exportChildren(self, outfile, level, nsmap, namespace_=XML_NS, name_='MalwareType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Malware_Instance_ in self.Malware_Instance:
            Malware_Instance_.export(outfile, level, nsmap, namespace_, name_='Malware_Instance', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='MalwareType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Malware_Instance=[\n')
        level += 1
        for Malware_Instance_ in self.Malware_Instance:
            outfile.write('model_.MalwareInstanceType(\n')
            Malware_Instance_.exportLiteral(outfile, level, name_='MalwareInstanceType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Malware_Instance':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
            
                if type_name_ == "MAEC4.0InstanceType":
                    import stix.bindings.extensions.malware.maec_4_0_1 as maec_4_0_1_binding
                    obj_ = maec_4_0_1_binding.MAEC4_0InstanceType.factory()
            else:
                obj_ = MalwareInstanceType.factory() # MalwareInstanceType is not abstract
            
            obj_.build(child_)
            self.Malware_Instance.append(obj_)
# end class MalwareType

class AttackPatternsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Attack_Pattern=None):
        if Attack_Pattern is None:
            self.Attack_Pattern = []
        else:
            self.Attack_Pattern = Attack_Pattern
    def factory(*args_, **kwargs_):
        if AttackPatternsType.subclass:
            return AttackPatternsType.subclass(*args_, **kwargs_)
        else:
            return AttackPatternsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Attack_Pattern(self): return self.Attack_Pattern
    def set_Attack_Pattern(self, Attack_Pattern): self.Attack_Pattern = Attack_Pattern
    def add_Attack_Pattern(self, value): self.Attack_Pattern.append(value)
    def insert_Attack_Pattern(self, index, value): self.Attack_Pattern[index] = value
    def hasContent_(self):
        if (
            self.Attack_Pattern
            ):
            return True
        else:
            return False
    def export(self, outfile, level, nsmap, namespace_=XML_NS, name_='AttackPatternsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AttackPatternsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ttp:', name_='AttackPatternsType'):
        pass
    def exportChildren(self, outfile, level, nsmap, namespace_=XML_NS, name_='AttackPatternsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Attack_Pattern_ in self.Attack_Pattern:
            Attack_Pattern_.export(outfile, level, nsmap, namespace_, name_='Attack_Pattern', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='AttackPatternsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Attack_Pattern=[\n')
        level += 1
        for Attack_Pattern_ in self.Attack_Pattern:
            outfile.write('model_.AttackPatternType(\n')
            Attack_Pattern_.exportLiteral(outfile, level, name_='AttackPatternType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Attack_Pattern':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                
                if type_name_ == "CAPEC2.6InstanceType":
                    import stix.bindings.extensions.attack_pattern.capec_2_6_1 as capec_2_6_1_binding
                    obj_ = capec_2_6_1_binding.CAPEC2_6InstanceType.factory()
                else:
                    raise NotImplementedError('No implementation for type: ' + type_name_)
            else:
                obj_ = AttackPatternType.factory() # AttackPattern is not abstract
                
            obj_.build(child_)
            self.Attack_Pattern.append(obj_)
# end class AttackPatternsType

class ResourceType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Tools=None, Infrastructure=None):
        self.Tools = Tools
        self.Infrastructure = Infrastructure
    def factory(*args_, **kwargs_):
        if ResourceType.subclass:
            return ResourceType.subclass(*args_, **kwargs_)
        else:
            return ResourceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Tools(self): return self.Tools
    def set_Tools(self, Tools): self.Tools = Tools
    def get_Infrastructure(self): return self.Infrastructure
    def set_Infrastructure(self, Infrastructure): self.Infrastructure = Infrastructure
    def hasContent_(self):
        if (
            self.Tools is not None or
            self.Infrastructure is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, nsmap, namespace_=XML_NS, name_='ResourceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ttp:', name_='ResourceType'):
        pass
    def exportChildren(self, outfile, level, nsmap, namespace_=XML_NS, name_='ResourceType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Tools is not None:
            self.Tools.export(outfile, level, nsmap, namespace_, name_='Tools', pretty_print=pretty_print)
        if self.Infrastructure is not None:
            self.Infrastructure.export(outfile, level, nsmap, namespace_, name_='Infrastructure', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='ResourceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Tools is not None:
            outfile.write('Tools=model_.ToolsType(\n')
            self.Tools.exportLiteral(outfile, level, name_='Tools')
            outfile.write('),\n')
        if self.Infrastructure is not None:
            outfile.write('Infrastructure=model_.InfrastructureType(\n')
            self.Infrastructure.exportLiteral(outfile, level, name_='Infrastructure')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Tools':
            obj_ = ToolsType.factory()
            obj_.build(child_)
            self.set_Tools(obj_)
        elif nodeName_ == 'Infrastructure':
            obj_ = InfrastructureType.factory()
            obj_.build(child_)
            self.set_Infrastructure(obj_)
# end class ResourceType

class BehaviorType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Attack_Patterns=None, Malware=None, Exploits=None):
        self.Attack_Patterns = Attack_Patterns
        self.Malware = Malware
        self.Exploits = Exploits
    def factory(*args_, **kwargs_):
        if BehaviorType.subclass:
            return BehaviorType.subclass(*args_, **kwargs_)
        else:
            return BehaviorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Attack_Patterns(self): return self.Attack_Patterns
    def set_Attack_Patterns(self, Attack_Patterns): self.Attack_Patterns = Attack_Patterns
    def get_Malware(self): return self.Malware
    def set_Malware(self, Malware): self.Malware = Malware
    def get_Exploits(self): return self.Exploits
    def set_Exploits(self, Exploits): self.Exploits = Exploits
    def hasContent_(self):
        if (
            self.Attack_Patterns is not None or
            self.Malware is not None or
            self.Exploits is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, nsmap, namespace_=XML_NS, name_='BehaviorType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='BehaviorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ttp:', name_='BehaviorType'):
        pass
    def exportChildren(self, outfile, level, nsmap, namespace_=XML_NS, name_='BehaviorType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Attack_Patterns is not None:
            self.Attack_Patterns.export(outfile, level, nsmap, namespace_, name_='Attack_Patterns', pretty_print=pretty_print)
        if self.Malware is not None:
            self.Malware.export(outfile, level, nsmap, namespace_, name_='Malware', pretty_print=pretty_print)
        if self.Exploits is not None:
            self.Exploits.export(outfile, level, nsmap, namespace_, name_='Exploits', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='BehaviorType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Attack_Patterns is not None:
            outfile.write('Attack_Patterns=model_.AttackPatternsType(\n')
            self.Attack_Patterns.exportLiteral(outfile, level, name_='Attack_Patterns')
            outfile.write('),\n')
        if self.Malware is not None:
            outfile.write('Malware=model_.MalwareType(\n')
            self.Malware.exportLiteral(outfile, level, name_='Malware')
            outfile.write('),\n')
        if self.Exploits is not None:
            outfile.write('Exploits=model_.ExploitsType(\n')
            self.Exploits.exportLiteral(outfile, level, name_='Exploits')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Attack_Patterns':
            obj_ = AttackPatternsType.factory()
            obj_.build(child_)
            self.set_Attack_Patterns(obj_)
        elif nodeName_ == 'Malware':
            obj_ = MalwareType.factory()
            obj_.build(child_)
            self.set_Malware(obj_)
        elif nodeName_ == 'Exploits':
            obj_ = ExploitsType.factory()
            obj_.build(child_)
            self.set_Exploits(obj_)
# end class BehaviorType

class VictimTargetingType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Identity=None, Targeted_Systems=None, Targeted_Information=None):
        self.Identity = Identity
        if Targeted_Systems is None:
            self.Targeted_Systems = []
        else:
            self.Targeted_Systems = Targeted_Systems
        if Targeted_Information is None:
            self.Targeted_Information = []
        else:
            self.Targeted_Information = Targeted_Information
    def factory(*args_, **kwargs_):
        if VictimTargetingType.subclass:
            return VictimTargetingType.subclass(*args_, **kwargs_)
        else:
            return VictimTargetingType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Identity(self): return self.Identity
    def set_Identity(self, Identity): self.Identity = Identity
    def get_Targeted_Systems(self): return self.Targeted_Systems
    def set_Targeted_Systems(self, Targeted_Systems): self.Targeted_Systems = Targeted_Systems
    def add_Targeted_Systems(self, value): self.Targeted_Systems.append(value)
    def insert_Targeted_Systems(self, index, value): self.Targeted_Systems[index] = value
    def get_Targeted_Information(self): return self.Targeted_Information
    def set_Targeted_Information(self, Targeted_Information): self.Targeted_Information = Targeted_Information
    def add_Targeted_Information(self, value): self.Targeted_Information.append(value)
    def insert_Targeted_Information(self, index, value): self.Targeted_Information[index] = value
    def hasContent_(self):
        if (
            self.Identity is not None or
            self.Targeted_Systems or
            self.Targeted_Information
            ):
            return True
        else:
            return False
    def export(self, outfile, level, nsmap, namespace_=XML_NS, name_='VictimTargetingType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VictimTargetingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ttp:', name_='VictimTargetingType'):
        pass
    def exportChildren(self, outfile, level, nsmap, namespace_=XML_NS, name_='VictimTargetingType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Identity is not None:
            self.Identity.export(outfile, level, nsmap, namespace_, name_='Identity', pretty_print=pretty_print)
        for Targeted_Systems_ in self.Targeted_Systems:
            Targeted_Systems_.export(outfile, level, nsmap, namespace_, name_='Targeted_Systems', pretty_print=pretty_print)
        for Targeted_Information_ in self.Targeted_Information:
            Targeted_Information_.export(outfile, level, nsmap, namespace_, name_='Targeted_Information', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='VictimTargetingType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Identity is not None:
            outfile.write('Identity=model_.stix_common_binding.IdentityType(\n')
            self.Identity.exportLiteral(outfile, level, name_='Identity')
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Targeted_Systems=[\n')
        level += 1
        for Targeted_Systems_ in self.Targeted_Systems:
            outfile.write('model_.stix_common_binding.ControlledVocabularyStringType(\n')
            Targeted_Systems_.exportLiteral(outfile, level, name_='stix_common_binding.ControlledVocabularyStringType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Targeted_Information=[\n')
        level += 1
        for Targeted_Information_ in self.Targeted_Information:
            outfile.write('model_.stix_common_binding.ControlledVocabularyStringType(\n')
            Targeted_Information_.exportLiteral(outfile, level, name_='stix_common_binding.ControlledVocabularyStringType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Identity':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
            
                if type_name_ == "CIQIdentity3.0InstanceType":
                    import stix.bindings.extensions.identity.ciq_identity_3_0 as ciq_identity_binding
                    obj_ = ciq_identity_binding.CIQIdentity3_0InstanceType.factory()
            else:
                obj_ = stix_common_binding.IdentityType.factory() # IdentityType is not abstract
            
            obj_.build(child_)
            self.set_Identity(obj_)
        elif nodeName_ == 'Targeted_Systems':
            obj_ = stix_common_binding.ControlledVocabularyStringType.factory()
            obj_.build(child_)
            self.Targeted_Systems.append(obj_)
        elif nodeName_ == 'Targeted_Information':
            obj_ = stix_common_binding.ControlledVocabularyStringType.factory()
            obj_.build(child_)
            self.Targeted_Information.append(obj_)
# end class VictimTargetingType

class RelatedTTPsType(stix_common_binding.GenericRelationshipListType):
    subclass = None
    superclass = stix_common_binding.GenericRelationshipListType
    def __init__(self, scope='exclusive', Related_TTP=None):
        super(RelatedTTPsType, self).__init__(scope, )
        if Related_TTP is None:
            self.Related_TTP = []
        else:
            self.Related_TTP = Related_TTP
    def factory(*args_, **kwargs_):
        if RelatedTTPsType.subclass:
            return RelatedTTPsType.subclass(*args_, **kwargs_)
        else:
            return RelatedTTPsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Related_TTP(self): return self.Related_TTP
    def set_Related_TTP(self, Related_TTP): self.Related_TTP = Related_TTP
    def add_Related_TTP(self, value): self.Related_TTP.append(value)
    def insert_Related_TTP(self, index, value): self.Related_TTP[index] = value
    def hasContent_(self):
        if (
            self.Related_TTP or
            super(RelatedTTPsType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, nsmap, namespace_=XML_NS, name_='RelatedTTPsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RelatedTTPsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ttp:', name_='RelatedTTPsType'):
        super(RelatedTTPsType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RelatedTTPsType')
    def exportChildren(self, outfile, level, nsmap, namespace_=XML_NS, name_='RelatedTTPsType', fromsubclass_=False, pretty_print=True):
        super(RelatedTTPsType, self).exportChildren(outfile, level, nsmap, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Related_TTP_ in self.Related_TTP:
            Related_TTP_.export(outfile, level, nsmap, namespace_, name_='Related_TTP', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='RelatedTTPsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RelatedTTPsType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RelatedTTPsType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('Related_TTP=[\n')
        level += 1
        for Related_TTP_ in self.Related_TTP:
            outfile.write('model_.stix_common_binding.RelatedTTPType(\n')
            Related_TTP_.exportLiteral(outfile, level, name_='stix_common_binding.RelatedTTPType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RelatedTTPsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Related_TTP':
            obj_ = stix_common_binding.RelatedTTPType.factory()
            obj_.build(child_)
            self.Related_TTP.append(obj_)
        super(RelatedTTPsType, self).buildChildren(child_, node, nodeName_, True)
# end class RelatedTTPsType

class TTPType(stix_common_binding.TTPBaseType):
    """TTPType characterizes an individual adversary TTP.Specifies the
    relevant STIX-TTP schema version for this content."""
    subclass = None
    superclass = stix_common_binding.TTPBaseType
    def __init__(self, idref=None, id=None, version=None, Title=None, Description=None, Intended_Effect=None, Behavior=None, Resources=None, Victim_Targeting=None, Exploit_Targets=None, Related_TTPs=None, Kill_Chain_Phases=None, Information_Source=None, Kill_Chains=None, Handling=None):
        super(TTPType, self).__init__(idref, id, )
        self.xmlns          = "http://stix.mitre.org/TTP-1"
        self.xmlns_prefix   = "ttp"
        self.xml_type       = "TTPType"
        self.version = _cast(None, version)
        self.Title = Title
        self.Description = Description
        if Intended_Effect is None:
            self.Intended_Effect = []
        else:
            self.Intended_Effect = Intended_Effect
        self.Behavior = Behavior
        self.Resources = Resources
        self.Victim_Targeting = Victim_Targeting
        self.Exploit_Targets = Exploit_Targets
        self.Related_TTPs = Related_TTPs
        self.Kill_Chain_Phases = Kill_Chain_Phases
        self.Information_Source = Information_Source
        self.Kill_Chains = Kill_Chains
        self.Handling = Handling
    def factory(*args_, **kwargs_):
        if TTPType.subclass:
            return TTPType.subclass(*args_, **kwargs_)
        else:
            return TTPType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Title(self): return self.Title
    def set_Title(self, Title): self.Title = Title
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_Intended_Effect(self): return self.Intended_Effect
    def set_Intended_Effect(self, Intended_Effect): self.Intended_Effect = Intended_Effect
    def add_Intended_Effect(self, value): self.Intended_Effect.append(value)
    def insert_Intended_Effect(self, index, value): self.Intended_Effect[index] = value
    def get_Behavior(self): return self.Behavior
    def set_Behavior(self, Behavior): self.Behavior = Behavior
    def get_Resources(self): return self.Resources
    def set_Resources(self, Resources): self.Resources = Resources
    def get_Victim_Targeting(self): return self.Victim_Targeting
    def set_Victim_Targeting(self, Victim_Targeting): self.Victim_Targeting = Victim_Targeting
    def get_Exploit_Targets(self): return self.Exploit_Targets
    def set_Exploit_Targets(self, Exploit_Targets): self.Exploit_Targets = Exploit_Targets
    def get_Related_TTPs(self): return self.Related_TTPs
    def set_Related_TTPs(self, Related_TTPs): self.Related_TTPs = Related_TTPs
    def get_Kill_Chain_Phases(self): return self.Kill_Chain_Phases
    def set_Kill_Chain_Phases(self, Kill_Chain_Phases): self.Kill_Chain_Phases = Kill_Chain_Phases
    def get_Information_Source(self): return self.Information_Source
    def set_Information_Source(self, Information_Source): self.Information_Source = Information_Source
    def get_Kill_Chains(self): return self.Kill_Chains
    def set_Kill_Chains(self, Kill_Chains): self.Kill_Chains = Kill_Chains
    def get_Handling(self): return self.Handling
    def set_Handling(self, Handling): self.Handling = Handling
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def hasContent_(self):
        if (
            self.Title is not None or
            self.Description is not None or
            self.Intended_Effect or
            self.Behavior is not None or
            self.Resources is not None or
            self.Victim_Targeting is not None or
            self.Exploit_Targets is not None or
            self.Related_TTPs is not None or
            self.Kill_Chain_Phases is not None or
            self.Information_Source is not None or
            self.Kill_Chains is not None or
            self.Handling is not None or
            super(TTPType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, nsmap, namespace_=XML_NS, name_='TTPType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TTPType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ttp:', name_='TTPType'):
        super(TTPType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TTPType')
        if 'xmlns' not in already_processed:
            already_processed.add('xmlns')
            xmlns = " xmlns:%s='%s'" % (self.xmlns_prefix, self.xmlns)
            outfile.write(xmlns)   
        if 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            xsi_type = " xsi:type='%s:%s'" % (self.xmlns_prefix, self.xml_type)
            outfile.write(xsi_type)
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            outfile.write(' version=%s' % (quote_attrib(self.version), ))
    def exportChildren(self, outfile, level, nsmap, namespace_=XML_NS, name_='TTPType', fromsubclass_=False, pretty_print=True):
        super(TTPType, self).exportChildren(outfile, level, nsmap, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%s:Title>%s</%s:Title>%s' % (nsmap[namespace_], self.gds_format_string(quote_xml(self.Title).encode(ExternalEncoding), input_name='Title'), nsmap[namespace_], eol_))
        if self.Description is not None:
            self.Description.export(outfile, level, nsmap, namespace_, name_='Description', pretty_print=pretty_print)
        for Intended_Effect_ in self.Intended_Effect:
            Intended_Effect_.export(outfile, level, nsmap, namespace_, name_='Intended_Effect', pretty_print=pretty_print)
        if self.Behavior is not None:
            self.Behavior.export(outfile, level, nsmap, namespace_, name_='Behavior', pretty_print=pretty_print)
        if self.Resources is not None:
            self.Resources.export(outfile, level, nsmap, namespace_, name_='Resources', pretty_print=pretty_print)
        if self.Victim_Targeting is not None:
            self.Victim_Targeting.export(outfile, level, nsmap, namespace_, name_='Victim_Targeting', pretty_print=pretty_print)
        if self.Exploit_Targets is not None:
            self.Exploit_Targets.export(outfile, level, nsmap, namespace_, name_='Exploit_Targets', pretty_print=pretty_print)
        if self.Related_TTPs is not None:
            self.Related_TTPs.export(outfile, level, nsmap, namespace_, name_='Related_TTPs', pretty_print=pretty_print)
        if self.Kill_Chain_Phases is not None:
            self.Kill_Chain_Phases.export(outfile, level, nsmap, namespace_, name_='Kill_Chain_Phases', pretty_print=pretty_print)
        if self.Information_Source is not None:
            self.Information_Source.export(outfile, level, nsmap, namespace_, name_='Information_Source', pretty_print=pretty_print)
        if self.Kill_Chains is not None:
            self.Kill_Chains.export(outfile, level, nsmap, namespace_, name_='Kill_Chains', pretty_print=pretty_print)
        if self.Handling is not None:
            self.Handling.export(outfile, level, nsmap, namespace_, name_='Handling', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='TTPType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            showIndent(outfile, level)
            outfile.write('version = %s,\n' % (self.version,))
        super(TTPType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TTPType, self).exportLiteralChildren(outfile, level, name_)
        if self.Title is not None:
            showIndent(outfile, level)
            outfile.write('Title=%s,\n' % quote_python(self.Title).encode(ExternalEncoding))
        if self.Description is not None:
            outfile.write('Description=model_.stix_common_binding.StructuredTextType(\n')
            self.Description.exportLiteral(outfile, level, name_='Description')
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('Intended_Effect=[\n')
        level += 1
        for Intended_Effect_ in self.Intended_Effect:
            outfile.write('model_.stix_common_binding.StatementType(\n')
            Intended_Effect_.exportLiteral(outfile, level, name_='stix_common_binding.StatementType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.Behavior is not None:
            outfile.write('Behavior=model_.BehaviorType(\n')
            self.Behavior.exportLiteral(outfile, level, name_='Behavior')
            outfile.write('),\n')
        if self.Resources is not None:
            outfile.write('Resources=model_.ResourceType(\n')
            self.Resources.exportLiteral(outfile, level, name_='Resources')
            outfile.write('),\n')
        if self.Victim_Targeting is not None:
            outfile.write('Victim_Targeting=model_.VictimTargetingType(\n')
            self.Victim_Targeting.exportLiteral(outfile, level, name_='Victim_Targeting')
            outfile.write('),\n')
        if self.Exploit_Targets is not None:
            outfile.write('Exploit_Targets=model_.stix_common_binding.ExploitTargetsType(\n')
            self.Exploit_Targets.exportLiteral(outfile, level, name_='Exploit_Targets')
            outfile.write('),\n')
        if self.Related_TTPs is not None:
            outfile.write('Related_TTPs=model_.RelatedTTPsType(\n')
            self.Related_TTPs.exportLiteral(outfile, level, name_='Related_TTPs')
            outfile.write('),\n')
        if self.Kill_Chain_Phases is not None:
            outfile.write('Kill_Chain_Phases=model_.stix_common_binding.KillChainPhasesReferenceType(\n')
            self.Kill_Chain_Phases.exportLiteral(outfile, level, name_='Kill_Chain_Phases')
            outfile.write('),\n')
        if self.Information_Source is not None:
            outfile.write('Information_Source=model_.stix_common_binding.InformationSourceType(\n')
            self.Information_Source.exportLiteral(outfile, level, name_='Information_Source')
            outfile.write('),\n')
        if self.Kill_Chains is not None:
            outfile.write('Kill_Chains=model_.stix_common_binding.KillChainsType(\n')
            self.Kill_Chains.exportLiteral(outfile, level, name_='Kill_Chains')
            outfile.write('),\n')
        if self.Handling is not None:
            outfile.write('Handling=model_.data_marking_binding.MarkingType(\n')
            self.Handling.exportLiteral(outfile, level, name_='Handling')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value
        super(TTPType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Title':
            Title_ = child_.text
            Title_ = self.gds_validate_string(Title_, node, 'Title')
            self.Title = Title_
        elif nodeName_ == 'Description':
            obj_ = stix_common_binding.StructuredTextType.factory()
            obj_.build(child_)
            self.set_Description(obj_)
        elif nodeName_ == 'Intended_Effect':
            obj_ = stix_common_binding.StatementType.factory()
            obj_.build(child_)
            self.Intended_Effect.append(obj_)
        elif nodeName_ == 'Behavior':
            obj_ = BehaviorType.factory()
            obj_.build(child_)
            self.set_Behavior(obj_)
        elif nodeName_ == 'Resources':
            obj_ = ResourceType.factory()
            obj_.build(child_)
            self.set_Resources(obj_)
        elif nodeName_ == 'Victim_Targeting':
            obj_ = VictimTargetingType.factory()
            obj_.build(child_)
            self.set_Victim_Targeting(obj_)
        elif nodeName_ == 'Exploit_Targets':
            obj_ = stix_common_binding.ExploitTargetsType.factory()
            obj_.build(child_)
            self.set_Exploit_Targets(obj_)
        elif nodeName_ == 'Related_TTPs':
            obj_ = RelatedTTPsType.factory()
            obj_.build(child_)
            self.set_Related_TTPs(obj_)
        elif nodeName_ == 'Kill_Chain_Phases':
            obj_ = stix_common_binding.KillChainPhasesReferenceType.factory()
            obj_.build(child_)
            self.set_Kill_Chain_Phases(obj_)
        elif nodeName_ == 'Information_Source':
            obj_ = stix_common_binding.InformationSourceType.factory()
            obj_.build(child_)
            self.set_Information_Source(obj_)
        elif nodeName_ == 'Kill_Chains':
            obj_ = stix_common_binding.KillChainsType.factory()
            obj_.build(child_)
            self.set_Kill_Chains(obj_)
        elif nodeName_ == 'Handling':
            obj_ = data_marking_binding.MarkingType.factory()
            obj_.build(child_)
            self.set_Handling(obj_)
        super(TTPType, self).buildChildren(child_, node, nodeName_, True)
# end class TTPType

GDSClassesMapping = {
    'Information_Source': stix_common_binding.InformationSourceType,
    'Relationships': cybox_core_binding.RelationshipsType,
    'Indicator': stix_common_binding.IndicatorBaseType,
    'Errors': cybox_common_binding.ErrorsType,
    'Defined_Effect': cybox_core_binding.DefinedEffectType,
    'Action_Argument': cybox_core_binding.ActionArgumentType,
    'Exploit_Target': stix_common_binding.ExploitTargetBaseType,
    'Action': cybox_core_binding.ActionType,
    'Certificate_Issuer': cybox_common_binding.StringObjectPropertyType,
    'Metadata': cybox_common_binding.MetadataType,
    'Hash': cybox_common_binding.HashType,
    'Object': cybox_core_binding.ObjectType,
    'Incident': stix_common_binding.IncidentBaseType,
    'Information_Source_Type': stix_common_binding.ControlledVocabularyStringType,
    'Confidence_Assertion_Chain': stix_common_binding.ConfidenceAssertionChainType,
    'Segment_Hash': cybox_common_binding.HashValueType,
    'Internal_Strings': cybox_common_binding.InternalStringsType,
    'Observable': cybox_core_binding.ObservableType,
    'SubDatum': cybox_common_binding.MetadataType,
    'Tool_Hashes': cybox_common_binding.HashListType,
    'Digital_Signature': cybox_common_binding.DigitalSignatureInfoType,
    'Confidence_Assertion': stix_common_binding.ConfidenceType,
    'Code_Snippets': cybox_common_binding.CodeSnippetsType,
    'Address': cybox_common_binding.HexBinaryObjectPropertyType,
    'Value': stix_common_binding.ControlledVocabularyStringType,
    'English_Translation': cybox_common_binding.StringObjectPropertyType,
    'Length': cybox_common_binding.IntegerObjectPropertyType,
    'Evasion_Techniques': cybox_core_binding.ObfuscationTechniquesType,
    'Campaign': stix_common_binding.CampaignBaseType,
    'Reference': cybox_common_binding.ReferenceType,
    'Encoding': stix_common_binding.ControlledVocabularyStringType,
    'Internationalization_Settings': cybox_common_binding.InternationalizationSettingsType,
    'Image_Offset': cybox_common_binding.IntegerObjectPropertyType,
    'Kill_Chain_Phases': stix_common_binding.KillChainPhasesReferenceType,
    'Associated_Objects': cybox_core_binding.AssociatedObjectsType,
    'Signature_Description': cybox_common_binding.StringObjectPropertyType,
    'File_System_Offset': cybox_common_binding.IntegerObjectPropertyType,
    'Imports': cybox_common_binding.ImportsType,
    'Targeted_Information': stix_common_binding.ControlledVocabularyStringType,
    'Event': cybox_core_binding.EventType,
    'Segments': cybox_common_binding.HashSegmentsType,
    'Functions': cybox_common_binding.FunctionsType,
    'String_Value': cybox_common_binding.StringObjectPropertyType,
    'Build_Utility_Platform_Specification': cybox_common_binding.PlatformSpecificationType,
    'Domain_Specific_Object_Properties': cybox_core_binding.DomainSpecificObjectPropertiesType,
    'Intended_Effect': stix_common_binding.StatementType,
    'System': cybox_common_binding.ObjectPropertiesType,
    'Platform': cybox_common_binding.PlatformSpecificationType,
    'State': stix_common_binding.ControlledVocabularyStringType,
    'Usage_Context_Assumptions': cybox_common_binding.UsageContextAssumptionsType,
    'Marking_Structure': data_marking_binding.MarkingStructureType,
    'Action_Arguments': cybox_core_binding.ActionArgumentsType,
    'Type': stix_common_binding.ControlledVocabularyStringType,
    'Compilers': cybox_common_binding.CompilersType,
    'Tool_Type': stix_common_binding.ControlledVocabularyStringType,
    'String': cybox_common_binding.ExtractedStringType,
    'Relationship': stix_common_binding.ControlledVocabularyStringType,
    'Tool': cybox_common_binding.ToolInformationType,
    'TTP': stix_common_binding.TTPBaseType,
    'Build_Information': cybox_common_binding.BuildInformationType,
    'Obfuscation_Technique': cybox_core_binding.ObfuscationTechniqueType,
    'Exploit_Targets': stix_common_binding.ExploitTargetsType,
    'Observable_Composition': cybox_core_binding.ObservableCompositionType,
    'Targeted_Systems': stix_common_binding.ControlledVocabularyStringType,
    'Error_Instances': cybox_common_binding.ErrorInstancesType,
    'Action_Pool': cybox_core_binding.ActionPoolType,
    'Data_Segment': cybox_common_binding.StringObjectPropertyType,
    'Certificate_Subject': cybox_common_binding.StringObjectPropertyType,
    'Property': cybox_common_binding.PropertyType,
    'Strings': cybox_common_binding.ExtractedStringsType,
    'Course_Of_Action': stix_common_binding.CourseOfActionBaseType,
    'Contributors': stix_common_binding.ContributorsType,
    'Reference_Description': stix_common_binding.StructuredTextType,
    'User_Account_Info': cybox_common_binding.ObjectPropertiesType,
    'Configuration_Settings': cybox_common_binding.ConfigurationSettingsType,
    'Compiler_Platform_Specification': cybox_common_binding.PlatformSpecificationType,
    'Observable_Source': cybox_common_binding.MeasureSourceType,
    'Byte_String_Value': cybox_common_binding.HexBinaryObjectPropertyType,
    'Association_Type': stix_common_binding.ControlledVocabularyStringType,
    'Confidence': stix_common_binding.ConfidenceType,
    'Observable_Package_Source': cybox_common_binding.MeasureSourceType,
    'Instance': cybox_common_binding.ObjectPropertiesType,
    'Associated_Object': cybox_core_binding.AssociatedObjectType,
    'Related_Objects': cybox_core_binding.RelatedObjectsType,
    'Related_Identities': stix_common_binding.RelatedIdentitiesType,
    'Import': cybox_common_binding.StringObjectPropertyType,
    'Observable_Characterization': cybox_core_binding.ObservablesType,
    'Identifier': cybox_common_binding.PlatformIdentifierType,
    'Tool_Specific_Data': cybox_common_binding.ToolSpecificDataType,
    'Execution_Environment': cybox_common_binding.ExecutionEnvironmentType,
    'Search_Distance': cybox_common_binding.IntegerObjectPropertyType,
    'Compiler_Informal_Description': cybox_common_binding.CompilerInformalDescriptionType,
    'Dependencies': cybox_common_binding.DependenciesType,
    'Segment_Count': cybox_common_binding.IntegerObjectPropertyType,
    'Kill_Chains': stix_common_binding.KillChainsType,
    'Offset': cybox_common_binding.IntegerObjectPropertyType,
    'Date': cybox_common_binding.DateRangeType,
    'Hashes': cybox_common_binding.HashListType,
    'Data': cybox_common_binding.DataSegmentType,
    'Property_Pool': cybox_core_binding.PropertyPoolType,
    'Identity': stix_common_binding.IdentityType,
    'Action_Reference': cybox_core_binding.ActionReferenceType,
    'Language': cybox_common_binding.StringObjectPropertyType,
    'Usage_Context_Assumption': stix_common_binding.StructuredTextType,
    'Block_Hash': cybox_common_binding.FuzzyHashBlockType,
    'Dependency': cybox_common_binding.DependencyType,
    'Build_Utility': cybox_common_binding.BuildUtilityType,
    'Time': cybox_common_binding.TimeType,
    'Pools': cybox_core_binding.PoolsType,
    'Threat_Actor': stix_common_binding.ThreatActorBaseType,
    'Event_Pool': cybox_core_binding.EventPoolType,
    'Trigger_Point': cybox_common_binding.HexBinaryObjectPropertyType,
    'Environment_Variable': cybox_common_binding.EnvironmentVariableType,
    'Byte_Run': cybox_common_binding.ByteRunType,
    'Kill_Chain': stix_common_binding.KillChainType,
    'Old_Object': cybox_core_binding.ObjectType,
    'Tool_Configuration': cybox_common_binding.ToolConfigurationType,
    'Object_Pool': cybox_core_binding.ObjectPoolType,
    'Library': cybox_common_binding.LibraryType,
    'Properties': cybox_core_binding.PropertiesType,
    'Frequency': cybox_core_binding.FrequencyType,
    'References': stix_common_binding.ReferencesType,
    'Keywords': cybox_core_binding.KeywordsType,
    'Pattern_Fidelity': cybox_core_binding.PatternFidelityType,
    'Block_Hash_Value': cybox_common_binding.HashValueType,
    'Fuzzy_Hash_Structure': cybox_common_binding.FuzzyHashStructureType,
    'Configuration_Setting': cybox_common_binding.ConfigurationSettingType,
    'Libraries': cybox_common_binding.LibrariesType,
    'Function': cybox_common_binding.StringObjectPropertyType,
    'Description': stix_common_binding.StructuredTextType,
    'Code_Snippet': cybox_common_binding.ObjectPropertiesType,
    'Build_Configuration': cybox_common_binding.BuildConfigurationType,
    'Discovery_Method': cybox_common_binding.MeasureSourceType,
    'Dependency_Description': stix_common_binding.StructuredTextType,
    'Action_Pertinent_Object_Properties': cybox_core_binding.ActionPertinentObjectPropertiesType,
    'Related_TTP': stix_common_binding.RelatedTTPType,
    'Observation_Method': cybox_common_binding.MeasureSourceType,
    'Error': cybox_common_binding.ErrorType,
    'Related_Object': cybox_core_binding.RelatedObjectType,
    'Search_Within': cybox_common_binding.IntegerObjectPropertyType,
    'Segment': cybox_common_binding.HashSegmentType,
    'Compiler': cybox_common_binding.CompilerType,
    'Handling': data_marking_binding.MarkingType,
    'Name': cybox_common_binding.StringObjectPropertyType,
    'Kill_Chain_Phase': stix_common_binding.KillChainPhaseReferenceType,
    'Related_Identity': stix_common_binding.RelatedIdentityType,
    'Values': cybox_core_binding.ValuesType,
    'Marking': data_marking_binding.MarkingSpecificationType,
    'Observables': cybox_core_binding.ObservablesType,
    'Block_Size': cybox_common_binding.IntegerObjectPropertyType,
    'Simple_Hash_Value': cybox_common_binding.SimpleHashValueType,
    'New_Object': cybox_core_binding.ObjectType,
    'Source': stix_common_binding.ControlledVocabularyStringType,
    'Tools': cybox_common_binding.ToolsInformationType,
    'Fuzzy_Hash_Value': cybox_common_binding.FuzzyHashValueType,
    'Actions': cybox_core_binding.ActionsType,
    'Data_Size': cybox_common_binding.DataSizeType,
    'Contributor': stix_common_binding.IdentityType,
    'Action_Aliases': cybox_core_binding.ActionAliasesType,
    'Argument_Name': stix_common_binding.ControlledVocabularyStringType,
    'Custom_Properties': cybox_common_binding.CustomPropertiesType,
}

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'TTP'
        rootClass = TTPType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
        namespacedef_='',
        pretty_print=True)
    return rootObj

def parseEtree(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'TTP'
        rootClass = TTPType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    rootElement = rootObj.to_etree(None, name_=rootTag)
    content = etree_.tostring(rootElement, pretty_print=True,
        xml_declaration=True, encoding="utf-8")
    sys.stdout.write(content)
    sys.stdout.write('\n')
    return rootObj, rootElement

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'TTP'
        rootClass = TTPType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="TTP",
        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'TTP'
        rootClass = TTPType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from ttp import *\n\n')
    sys.stdout.write('from datetime import datetime as datetime_\n\n')
    sys.stdout.write('import ttp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "AttackPatternType",
    "MalwareInstanceType",
    "ExploitType",
    "InfrastructureType",
    "ToolsType",
    "ExploitsType",
    "MalwareType",
    "AttackPatternsType",
    "ResourceType",
    "BehaviorType",
    "VictimTargetingType",
    "RelatedTTPsType",
    "TTPType"
    ]