# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional, TYPE_CHECKING, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    import __init__ as _models


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class LocalizableString(msrest.serialization.Model):
    """The localizable string class.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. the invariant value.
    :vartype value: str
    :ivar localized_value: the locale specific value.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. the invariant value.
        :paramtype value: str
        :keyword localized_value: the locale specific value.
        :paramtype localized_value: str
        """
        super(LocalizableString, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class MetadataValue(msrest.serialization.Model):
    """Represents a metric metadata value.

    :ivar name: the name of the metadata.
    :vartype name: ~$(python-base-namespace).v2018_01_01.models.LocalizableString
    :ivar value: the value of the metadata.
    :vartype value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'LocalizableString'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional["_models.LocalizableString"] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: the name of the metadata.
        :paramtype name: ~$(python-base-namespace).v2018_01_01.models.LocalizableString
        :keyword value: the value of the metadata.
        :paramtype value: str
        """
        super(MetadataValue, self).__init__(**kwargs)
        self.name = name
        self.value = value


class Metric(msrest.serialization.Model):
    """The result data of a query.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. the metric Id.
    :vartype id: str
    :ivar type: Required. the resource type of the metric resource.
    :vartype type: str
    :ivar name: Required. the name and the display name of the metric, i.e. it is localizable
     string.
    :vartype name: ~$(python-base-namespace).v2018_01_01.models.LocalizableString
    :ivar display_description: Detailed description of this metric.
    :vartype display_description: str
    :ivar error_code: 'Success' or the error details on query failures for this metric.
    :vartype error_code: str
    :ivar error_message: Error message encountered querying this specific metric.
    :vartype error_message: str
    :ivar unit: Required. The unit of the metric. Known values are: "Count", "Bytes", "Seconds",
     "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
     "Cores", "MilliCores", "NanoCores", "BitsPerSecond".
    :vartype unit: str or ~$(python-base-namespace).v2018_01_01.models.MetricUnit
    :ivar timeseries: Required. the time series returned when a data query is performed.
    :vartype timeseries: list[~$(python-base-namespace).v2018_01_01.models.TimeSeriesElement]
    """

    _validation = {
        'id': {'required': True},
        'type': {'required': True},
        'name': {'required': True},
        'unit': {'required': True},
        'timeseries': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'LocalizableString'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'timeseries': {'key': 'timeseries', 'type': '[TimeSeriesElement]'},
    }

    def __init__(
        self,
        *,
        id: str,
        type: str,
        name: "_models.LocalizableString",
        unit: Union[str, "_models.MetricUnit"],
        timeseries: List["_models.TimeSeriesElement"],
        display_description: Optional[str] = None,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Required. the metric Id.
        :paramtype id: str
        :keyword type: Required. the resource type of the metric resource.
        :paramtype type: str
        :keyword name: Required. the name and the display name of the metric, i.e. it is localizable
         string.
        :paramtype name: ~$(python-base-namespace).v2018_01_01.models.LocalizableString
        :keyword display_description: Detailed description of this metric.
        :paramtype display_description: str
        :keyword error_code: 'Success' or the error details on query failures for this metric.
        :paramtype error_code: str
        :keyword error_message: Error message encountered querying this specific metric.
        :paramtype error_message: str
        :keyword unit: Required. The unit of the metric. Known values are: "Count", "Bytes", "Seconds",
         "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
         "Cores", "MilliCores", "NanoCores", "BitsPerSecond".
        :paramtype unit: str or ~$(python-base-namespace).v2018_01_01.models.MetricUnit
        :keyword timeseries: Required. the time series returned when a data query is performed.
        :paramtype timeseries: list[~$(python-base-namespace).v2018_01_01.models.TimeSeriesElement]
        """
        super(Metric, self).__init__(**kwargs)
        self.id = id
        self.type = type
        self.name = name
        self.display_description = display_description
        self.error_code = error_code
        self.error_message = error_message
        self.unit = unit
        self.timeseries = timeseries


class MetricAvailability(msrest.serialization.Model):
    """Metric availability specifies the time grain (aggregation interval or frequency) and the retention period for that time grain.

    :ivar time_grain: the time grain specifies the aggregation interval for the metric. Expressed
     as a duration 'PT1M', 'P1D', etc.
    :vartype time_grain: ~datetime.timedelta
    :ivar retention: the retention period for the metric at the specified timegrain.  Expressed as
     a duration 'PT1M', 'P1D', etc.
    :vartype retention: ~datetime.timedelta
    """

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'duration'},
        'retention': {'key': 'retention', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        time_grain: Optional[datetime.timedelta] = None,
        retention: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword time_grain: the time grain specifies the aggregation interval for the metric.
         Expressed as a duration 'PT1M', 'P1D', etc.
        :paramtype time_grain: ~datetime.timedelta
        :keyword retention: the retention period for the metric at the specified timegrain.  Expressed
         as a duration 'PT1M', 'P1D', etc.
        :paramtype retention: ~datetime.timedelta
        """
        super(MetricAvailability, self).__init__(**kwargs)
        self.time_grain = time_grain
        self.retention = retention


class MetricDefinition(msrest.serialization.Model):
    """Metric definition class specifies the metadata for a metric.

    :ivar is_dimension_required: Flag to indicate whether the dimension is required.
    :vartype is_dimension_required: bool
    :ivar resource_id: the resource identifier of the resource that emitted the metric.
    :vartype resource_id: str
    :ivar namespace: the namespace the metric belongs to.
    :vartype namespace: str
    :ivar name: the name and the display name of the metric, i.e. it is a localizable string.
    :vartype name: ~$(python-base-namespace).v2018_01_01.models.LocalizableString
    :ivar display_description: Detailed description of this metric.
    :vartype display_description: str
    :ivar category: Custom category name for this metric.
    :vartype category: str
    :ivar metric_class: The class of the metric. Known values are: "Availability", "Transactions",
     "Errors", "Latency", "Saturation".
    :vartype metric_class: str or ~$(python-base-namespace).v2018_01_01.models.MetricClass
    :ivar unit: The unit of the metric. Known values are: "Count", "Bytes", "Seconds",
     "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
     "Cores", "MilliCores", "NanoCores", "BitsPerSecond".
    :vartype unit: str or ~$(python-base-namespace).v2018_01_01.models.MetricUnit
    :ivar primary_aggregation_type: the primary aggregation type value defining how to use the
     values for display. Known values are: "None", "Average", "Count", "Minimum", "Maximum",
     "Total".
    :vartype primary_aggregation_type: str or
     ~$(python-base-namespace).v2018_01_01.models.AggregationType
    :ivar supported_aggregation_types: the collection of what aggregation types are supported.
    :vartype supported_aggregation_types: list[str or
     ~$(python-base-namespace).v2018_01_01.models.AggregationType]
    :ivar metric_availabilities: the collection of what aggregation intervals are available to be
     queried.
    :vartype metric_availabilities:
     list[~$(python-base-namespace).v2018_01_01.models.MetricAvailability]
    :ivar id: the resource identifier of the metric definition.
    :vartype id: str
    :ivar dimensions: the name and the display name of the dimension, i.e. it is a localizable
     string.
    :vartype dimensions: list[~$(python-base-namespace).v2018_01_01.models.LocalizableString]
    """

    _attribute_map = {
        'is_dimension_required': {'key': 'isDimensionRequired', 'type': 'bool'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'name': {'key': 'name', 'type': 'LocalizableString'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'metric_class': {'key': 'metricClass', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'primary_aggregation_type': {'key': 'primaryAggregationType', 'type': 'str'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
        'metric_availabilities': {'key': 'metricAvailabilities', 'type': '[MetricAvailability]'},
        'id': {'key': 'id', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[LocalizableString]'},
    }

    def __init__(
        self,
        *,
        is_dimension_required: Optional[bool] = None,
        resource_id: Optional[str] = None,
        namespace: Optional[str] = None,
        name: Optional["_models.LocalizableString"] = None,
        display_description: Optional[str] = None,
        category: Optional[str] = None,
        metric_class: Optional[Union[str, "_models.MetricClass"]] = None,
        unit: Optional[Union[str, "_models.MetricUnit"]] = None,
        primary_aggregation_type: Optional[Union[str, "_models.AggregationType"]] = None,
        supported_aggregation_types: Optional[List[Union[str, "_models.AggregationType"]]] = None,
        metric_availabilities: Optional[List["_models.MetricAvailability"]] = None,
        id: Optional[str] = None,
        dimensions: Optional[List["_models.LocalizableString"]] = None,
        **kwargs
    ):
        """
        :keyword is_dimension_required: Flag to indicate whether the dimension is required.
        :paramtype is_dimension_required: bool
        :keyword resource_id: the resource identifier of the resource that emitted the metric.
        :paramtype resource_id: str
        :keyword namespace: the namespace the metric belongs to.
        :paramtype namespace: str
        :keyword name: the name and the display name of the metric, i.e. it is a localizable string.
        :paramtype name: ~$(python-base-namespace).v2018_01_01.models.LocalizableString
        :keyword display_description: Detailed description of this metric.
        :paramtype display_description: str
        :keyword category: Custom category name for this metric.
        :paramtype category: str
        :keyword metric_class: The class of the metric. Known values are: "Availability",
         "Transactions", "Errors", "Latency", "Saturation".
        :paramtype metric_class: str or ~$(python-base-namespace).v2018_01_01.models.MetricClass
        :keyword unit: The unit of the metric. Known values are: "Count", "Bytes", "Seconds",
         "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
         "Cores", "MilliCores", "NanoCores", "BitsPerSecond".
        :paramtype unit: str or ~$(python-base-namespace).v2018_01_01.models.MetricUnit
        :keyword primary_aggregation_type: the primary aggregation type value defining how to use the
         values for display. Known values are: "None", "Average", "Count", "Minimum", "Maximum",
         "Total".
        :paramtype primary_aggregation_type: str or
         ~$(python-base-namespace).v2018_01_01.models.AggregationType
        :keyword supported_aggregation_types: the collection of what aggregation types are supported.
        :paramtype supported_aggregation_types: list[str or
         ~$(python-base-namespace).v2018_01_01.models.AggregationType]
        :keyword metric_availabilities: the collection of what aggregation intervals are available to
         be queried.
        :paramtype metric_availabilities:
         list[~$(python-base-namespace).v2018_01_01.models.MetricAvailability]
        :keyword id: the resource identifier of the metric definition.
        :paramtype id: str
        :keyword dimensions: the name and the display name of the dimension, i.e. it is a localizable
         string.
        :paramtype dimensions: list[~$(python-base-namespace).v2018_01_01.models.LocalizableString]
        """
        super(MetricDefinition, self).__init__(**kwargs)
        self.is_dimension_required = is_dimension_required
        self.resource_id = resource_id
        self.namespace = namespace
        self.name = name
        self.display_description = display_description
        self.category = category
        self.metric_class = metric_class
        self.unit = unit
        self.primary_aggregation_type = primary_aggregation_type
        self.supported_aggregation_types = supported_aggregation_types
        self.metric_availabilities = metric_availabilities
        self.id = id
        self.dimensions = dimensions


class MetricDefinitionCollection(msrest.serialization.Model):
    """Represents collection of metric definitions.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. the values for the metric definitions.
    :vartype value: list[~$(python-base-namespace).v2018_01_01.models.MetricDefinition]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MetricDefinition]'},
    }

    def __init__(
        self,
        *,
        value: List["_models.MetricDefinition"],
        **kwargs
    ):
        """
        :keyword value: Required. the values for the metric definitions.
        :paramtype value: list[~$(python-base-namespace).v2018_01_01.models.MetricDefinition]
        """
        super(MetricDefinitionCollection, self).__init__(**kwargs)
        self.value = value


class MetricValue(msrest.serialization.Model):
    """Represents a metric value.

    All required parameters must be populated in order to send to Azure.

    :ivar time_stamp: Required. the timestamp for the metric value in ISO 8601 format.
    :vartype time_stamp: ~datetime.datetime
    :ivar average: the average value in the time range.
    :vartype average: float
    :ivar minimum: the least value in the time range.
    :vartype minimum: float
    :ivar maximum: the greatest value in the time range.
    :vartype maximum: float
    :ivar total: the sum of all of the values in the time range.
    :vartype total: float
    :ivar count: the number of samples in the time range. Can be used to determine the number of
     values that contributed to the average value.
    :vartype count: float
    """

    _validation = {
        'time_stamp': {'required': True},
    }

    _attribute_map = {
        'time_stamp': {'key': 'timeStamp', 'type': 'iso-8601'},
        'average': {'key': 'average', 'type': 'float'},
        'minimum': {'key': 'minimum', 'type': 'float'},
        'maximum': {'key': 'maximum', 'type': 'float'},
        'total': {'key': 'total', 'type': 'float'},
        'count': {'key': 'count', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        time_stamp: datetime.datetime,
        average: Optional[float] = None,
        minimum: Optional[float] = None,
        maximum: Optional[float] = None,
        total: Optional[float] = None,
        count: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword time_stamp: Required. the timestamp for the metric value in ISO 8601 format.
        :paramtype time_stamp: ~datetime.datetime
        :keyword average: the average value in the time range.
        :paramtype average: float
        :keyword minimum: the least value in the time range.
        :paramtype minimum: float
        :keyword maximum: the greatest value in the time range.
        :paramtype maximum: float
        :keyword total: the sum of all of the values in the time range.
        :paramtype total: float
        :keyword count: the number of samples in the time range. Can be used to determine the number of
         values that contributed to the average value.
        :paramtype count: float
        """
        super(MetricValue, self).__init__(**kwargs)
        self.time_stamp = time_stamp
        self.average = average
        self.minimum = minimum
        self.maximum = maximum
        self.total = total
        self.count = count


class Response(msrest.serialization.Model):
    """The response to a metrics query.

    All required parameters must be populated in order to send to Azure.

    :ivar cost: The integer value representing the relative cost of the query.
    :vartype cost: int
    :ivar timespan: Required. The timespan for which the data was retrieved. Its value consists of
     two datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned
     back from what was originally requested.
    :vartype timespan: str
    :ivar interval: The interval (window size) for which the metric data was returned in.  This may
     be adjusted in the future and returned back from what was originally requested.  This is not
     present if a metadata request was made.
    :vartype interval: ~datetime.timedelta
    :ivar namespace: The namespace of the metrics being queried.
    :vartype namespace: str
    :ivar resourceregion: The region of the resource being queried for metrics.
    :vartype resourceregion: str
    :ivar value: Required. the value of the collection.
    :vartype value: list[~$(python-base-namespace).v2018_01_01.models.Metric]
    """

    _validation = {
        'cost': {'minimum': 0},
        'timespan': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'cost': {'key': 'cost', 'type': 'int'},
        'timespan': {'key': 'timespan', 'type': 'str'},
        'interval': {'key': 'interval', 'type': 'duration'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'resourceregion': {'key': 'resourceregion', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Metric]'},
    }

    def __init__(
        self,
        *,
        timespan: str,
        value: List["_models.Metric"],
        cost: Optional[int] = None,
        interval: Optional[datetime.timedelta] = None,
        namespace: Optional[str] = None,
        resourceregion: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword cost: The integer value representing the relative cost of the query.
        :paramtype cost: int
        :keyword timespan: Required. The timespan for which the data was retrieved. Its value consists
         of two datetimes concatenated, separated by '/'.  This may be adjusted in the future and
         returned back from what was originally requested.
        :paramtype timespan: str
        :keyword interval: The interval (window size) for which the metric data was returned in.  This
         may be adjusted in the future and returned back from what was originally requested.  This is
         not present if a metadata request was made.
        :paramtype interval: ~datetime.timedelta
        :keyword namespace: The namespace of the metrics being queried.
        :paramtype namespace: str
        :keyword resourceregion: The region of the resource being queried for metrics.
        :paramtype resourceregion: str
        :keyword value: Required. the value of the collection.
        :paramtype value: list[~$(python-base-namespace).v2018_01_01.models.Metric]
        """
        super(Response, self).__init__(**kwargs)
        self.cost = cost
        self.timespan = timespan
        self.interval = interval
        self.namespace = namespace
        self.resourceregion = resourceregion
        self.value = value


class TimeSeriesElement(msrest.serialization.Model):
    """A time series result type. The discriminator value is always TimeSeries in this case.

    :ivar metadatavalues: the metadata values returned if $filter was specified in the call.
    :vartype metadatavalues: list[~$(python-base-namespace).v2018_01_01.models.MetadataValue]
    :ivar data: An array of data points representing the metric values.  This is only returned if a
     result type of data is specified.
    :vartype data: list[~$(python-base-namespace).v2018_01_01.models.MetricValue]
    """

    _attribute_map = {
        'metadatavalues': {'key': 'metadatavalues', 'type': '[MetadataValue]'},
        'data': {'key': 'data', 'type': '[MetricValue]'},
    }

    def __init__(
        self,
        *,
        metadatavalues: Optional[List["_models.MetadataValue"]] = None,
        data: Optional[List["_models.MetricValue"]] = None,
        **kwargs
    ):
        """
        :keyword metadatavalues: the metadata values returned if $filter was specified in the call.
        :paramtype metadatavalues: list[~$(python-base-namespace).v2018_01_01.models.MetadataValue]
        :keyword data: An array of data points representing the metric values.  This is only returned
         if a result type of data is specified.
        :paramtype data: list[~$(python-base-namespace).v2018_01_01.models.MetricValue]
        """
        super(TimeSeriesElement, self).__init__(**kwargs)
        self.metadatavalues = metadatavalues
        self.data = data
