# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, AsyncIterable, Callable, Dict, Optional, TypeVar

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._activity_logs_operations import build_list_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class ActivityLogsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~$(python-base-namespace).v2015_04_01.aio.MonitorManagementClient`'s
        :attr:`activity_logs` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")


    @distributed_trace
    def list(
        self,
        filter: str,
        select: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[_models.EventDataCollection]:
        """Provides the list of records from the activity logs.

        :param filter: Reduces the set of data collected.:code:`<br>`This argument is required and it
         also requires at least the start date/time.:code:`<br>`The **$filter** argument is very
         restricted and allows only the following patterns.:code:`<br>`- *List events for a resource
         group*\ : $filter=eventTimestamp ge '2014-07-16T04:36:37.6407898Z' and eventTimestamp le
         '2014-07-20T04:36:37.6407898Z' and resourceGroupName eq 'resourceGroupName'.:code:`<br>`- *List
         events for resource*\ : $filter=eventTimestamp ge '2014-07-16T04:36:37.6407898Z' and
         eventTimestamp le '2014-07-20T04:36:37.6407898Z' and resourceUri eq 'resourceURI'.:code:`<br>`-
         *List events for a subscription in a time range*\ : $filter=eventTimestamp ge
         '2014-07-16T04:36:37.6407898Z' and eventTimestamp le
         '2014-07-20T04:36:37.6407898Z'.:code:`<br>`- *List events for a resource provider*\ :
         $filter=eventTimestamp ge '2014-07-16T04:36:37.6407898Z' and eventTimestamp le
         '2014-07-20T04:36:37.6407898Z' and resourceProvider eq 'resourceProviderName'.:code:`<br>`-
         *List events for a correlation Id*\ : $filter=eventTimestamp ge '2014-07-16T04:36:37.6407898Z'
         and eventTimestamp le '2014-07-20T04:36:37.6407898Z' and correlationId eq
         'correlationID'.:code:`<br>`:code:`<br>`\ **NOTE**\ : No other syntax is allowed.
        :type filter: str
        :param select: Used to fetch events with only the given properties.:code:`<br>`The **$select**
         argument is a comma separated list of property names to be returned. Possible values are:
         *authorization*\ , *claims*\ , *correlationId*\ , *description*\ , *eventDataId*\ ,
         *eventName*\ , *eventTimestamp*\ , *httpRequest*\ , *level*\ , *operationId*\ ,
         *operationName*\ , *properties*\ , *resourceGroupName*\ , *resourceProviderName*\ ,
         *resourceId*\ , *status*\ , *submissionTimestamp*\ , *subStatus*\ , *subscriptionId*. Default
         value is None.
        :type select: str
        :keyword api_version: Api Version. Default value is "2015-04-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either EventDataCollection or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~$(python-base-namespace).v2015_04_01.models.EventDataCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop('api_version', _params.pop('api-version', "2015-04-01"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.EventDataCollection]

        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    filter=filter,
                    select=select,
                    template_url=self.list.metadata['url'],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                
                request = build_list_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    filter=filter,
                    select=select,
                    template_url=next_link,
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("EventDataCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list.metadata = {'url': "/subscriptions/{subscriptionId}/providers/Microsoft.Insights/eventtypes/management/values"}  # type: ignore
