# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class StorageNetworkAcls(Model):
    """Network ACL.

    :param bypass: Specifies whether traffic is bypassed for
     Logging/Metrics/AzureServices. Possible values are any combination of
     Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None
     to bypass none of those traffics. Possible values include: 'None',
     'Logging', 'Metrics', 'AzureServices'. Default value: "AzureServices" .
    :type bypass: str or :class:`Bypass
     <azure.mgmt.storage.v2017_06_01.models.Bypass>`
    :param virtual_network_rules: Sets the virtual network ACL rules
    :type virtual_network_rules: list of :class:`VirtualNetworkRule
     <azure.mgmt.storage.v2017_06_01.models.VirtualNetworkRule>`
    :param ip_rules: Sets the IP ACL rules
    :type ip_rules: list of :class:`IPRule
     <azure.mgmt.storage.v2017_06_01.models.IPRule>`
    :param default_action: Specifies the default action of allow or deny when
     no other rules match. Possible values include: 'Allow', 'Deny'. Default
     value: "Allow" .
    :type default_action: str or :class:`DefaultAction
     <azure.mgmt.storage.v2017_06_01.models.DefaultAction>`
    """

    _validation = {
        'default_action': {'required': True},
    }

    _attribute_map = {
        'bypass': {'key': 'bypass', 'type': 'str'},
        'virtual_network_rules': {'key': 'virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'ip_rules': {'key': 'ipRules', 'type': '[IPRule]'},
        'default_action': {'key': 'defaultAction', 'type': 'DefaultAction'},
    }

    def __init__(self, bypass="AzureServices", virtual_network_rules=None, ip_rules=None, default_action="Allow"):
        self.bypass = bypass
        self.virtual_network_rules = virtual_network_rules
        self.ip_rules = ip_rules
        self.default_action = default_action
