# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------
from msrest import Serializer, Deserializer


class WebSiteManagementClientOperationsMixin(object):


    def check_name_availability(self, name, type, is_fqdn=None, custom_headers=None, raw=False, **operation_config):
        """Check if a resource name is available.

        Check if a resource name is available.

        :param name: Resource name to verify.
        :type name: str
        :param type: Resource type used for verification. Possible values
         include: 'Site', 'Slot', 'HostingEnvironment', 'PublishingUser',
         'Microsoft.Web/sites', 'Microsoft.Web/sites/slots',
         'Microsoft.Web/hostingEnvironments', 'Microsoft.Web/publishingUsers'
        :type type: str or
         ~azure.mgmt.web.v2018_02_01.models.CheckNameResourceTypes
        :param is_fqdn: Is fully qualified domain name.
        :type is_fqdn: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ResourceNameAvailability or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.web.v2018_02_01.models.ResourceNameAvailability or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`DefaultErrorResponseException<azure.mgmt.web.v2018_02_01.models.DefaultErrorResponseException>`
        
        """
        api_version = self._get_api_version('check_name_availability')
        if api_version == '2016-03-01':
            from .v2016_03_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.check_name_availability(name, type, is_fqdn, custom_headers, raw, **operation_config)

    def get_publishing_user(self, custom_headers=None, raw=False, **operation_config):
        """Gets publishing user.

        Gets publishing user.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: User or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.web.v2018_02_01.models.User or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`DefaultErrorResponseException<azure.mgmt.web.v2018_02_01.models.DefaultErrorResponseException>`
        
        """
        api_version = self._get_api_version('get_publishing_user')
        if api_version == '2016-03-01':
            from .v2016_03_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_publishing_user(custom_headers, raw, **operation_config)

    def get_source_control(self, source_control_type, custom_headers=None, raw=False, **operation_config):
        """Gets source control token.

        Gets source control token.

        :param source_control_type: Type of source control
        :type source_control_type: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: SourceControl or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.web.v2018_02_01.models.SourceControl or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`DefaultErrorResponseException<azure.mgmt.web.v2018_02_01.models.DefaultErrorResponseException>`
        
        """
        api_version = self._get_api_version('get_source_control')
        if api_version == '2016-03-01':
            from .v2016_03_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_source_control(source_control_type, custom_headers, raw, **operation_config)

    def get_subscription_deployment_locations(self, custom_headers=None, raw=False, **operation_config):
        """Gets list of available geo regions plus ministamps.

        Gets list of available geo regions plus ministamps.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: DeploymentLocations or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.web.v2018_02_01.models.DeploymentLocations or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`DefaultErrorResponseException<azure.mgmt.web.v2018_02_01.models.DefaultErrorResponseException>`
        
        """
        api_version = self._get_api_version('get_subscription_deployment_locations')
        if api_version == '2016-03-01':
            from .v2016_03_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_subscription_deployment_locations(custom_headers, raw, **operation_config)

    def list_billing_meters(self, billing_location=None, os_type=None, custom_headers=None, raw=False, **operation_config):
        """Gets a list of meters for a given location.

        Gets a list of meters for a given location.

        :param billing_location: Azure Location of billable resource
        :type billing_location: str
        :param os_type: App Service OS type meters used for
        :type os_type: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of BillingMeter
        :rtype:
         ~azure.mgmt.web.v2018_02_01.models.BillingMeterPaged[~azure.mgmt.web.v2018_02_01.models.BillingMeter]
        :raises:
         :class:`DefaultErrorResponseException<azure.mgmt.web.v2018_02_01.models.DefaultErrorResponseException>`
        
        """
        api_version = self._get_api_version('list_billing_meters')
        if api_version == '2018-02-01':
            from .v2018_02_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_billing_meters(billing_location, os_type, custom_headers, raw, **operation_config)

    def list_geo_regions(self, sku=None, linux_workers_enabled=None, xenon_workers_enabled=None, linux_dynamic_workers_enabled=None, custom_headers=None, raw=False, **operation_config):
        """Get a list of available geographical regions.

        Get a list of available geographical regions.

        :param sku: Name of SKU used to filter the regions. Possible values
         include: 'Free', 'Shared', 'Basic', 'Standard', 'Premium', 'Dynamic',
         'Isolated', 'PremiumV2', 'ElasticPremium', 'ElasticIsolated'
        :type sku: str or ~azure.mgmt.web.v2018_02_01.models.SkuName
        :param linux_workers_enabled: Specify <code>true</code> if you want to
         filter to only regions that support Linux workers.
        :type linux_workers_enabled: bool
        :param xenon_workers_enabled: Specify <code>true</code> if you want to
         filter to only regions that support Xenon workers.
        :type xenon_workers_enabled: bool
        :param linux_dynamic_workers_enabled: Specify <code>true</code> if you
         want to filter to only regions that support Linux Consumption Workers.
        :type linux_dynamic_workers_enabled: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of GeoRegion
        :rtype:
         ~azure.mgmt.web.v2018_02_01.models.GeoRegionPaged[~azure.mgmt.web.v2018_02_01.models.GeoRegion]
        :raises:
         :class:`DefaultErrorResponseException<azure.mgmt.web.v2018_02_01.models.DefaultErrorResponseException>`
        
        """
        api_version = self._get_api_version('list_geo_regions')
        if api_version == '2016-03-01':
            from .v2016_03_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_geo_regions(sku, linux_workers_enabled, xenon_workers_enabled, linux_dynamic_workers_enabled, custom_headers, raw, **operation_config)

    def list_premier_add_on_offers(self, custom_headers=None, raw=False, **operation_config):
        """List all premier add-on offers.

        List all premier add-on offers.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of PremierAddOnOffer
        :rtype:
         ~azure.mgmt.web.v2018_02_01.models.PremierAddOnOfferPaged[~azure.mgmt.web.v2018_02_01.models.PremierAddOnOffer]
        :raises:
         :class:`DefaultErrorResponseException<azure.mgmt.web.v2018_02_01.models.DefaultErrorResponseException>`
        
        """
        api_version = self._get_api_version('list_premier_add_on_offers')
        if api_version == '2016-03-01':
            from .v2016_03_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_premier_add_on_offers(custom_headers, raw, **operation_config)

    def list_site_identifiers_assigned_to_host_name(self, name=None, custom_headers=None, raw=False, **operation_config):
        """List all apps that are assigned to a hostname.

        List all apps that are assigned to a hostname.

        :param name: Name of the object.
        :type name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of Identifier
        :rtype:
         ~azure.mgmt.web.v2018_02_01.models.IdentifierPaged[~azure.mgmt.web.v2018_02_01.models.Identifier]
        :raises:
         :class:`DefaultErrorResponseException<azure.mgmt.web.v2018_02_01.models.DefaultErrorResponseException>`
        
        """
        api_version = self._get_api_version('list_site_identifiers_assigned_to_host_name')
        if api_version == '2016-03-01':
            from .v2016_03_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_site_identifiers_assigned_to_host_name(name, custom_headers, raw, **operation_config)

    def list_skus(self, custom_headers=None, raw=False, **operation_config):
        """List all SKUs.

        List all SKUs.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: SkuInfos or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.web.v2018_02_01.models.SkuInfos or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`DefaultErrorResponseException<azure.mgmt.web.v2018_02_01.models.DefaultErrorResponseException>`
        
        """
        api_version = self._get_api_version('list_skus')
        if api_version == '2016-03-01':
            from .v2016_03_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_skus(custom_headers, raw, **operation_config)

    def list_source_controls(self, custom_headers=None, raw=False, **operation_config):
        """Gets the source controls available for Azure websites.

        Gets the source controls available for Azure websites.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of SourceControl
        :rtype:
         ~azure.mgmt.web.v2018_02_01.models.SourceControlPaged[~azure.mgmt.web.v2018_02_01.models.SourceControl]
        :raises:
         :class:`DefaultErrorResponseException<azure.mgmt.web.v2018_02_01.models.DefaultErrorResponseException>`
        
        """
        api_version = self._get_api_version('list_source_controls')
        if api_version == '2016-03-01':
            from .v2016_03_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_source_controls(custom_headers, raw, **operation_config)

    def move(self, resource_group_name, target_resource_group=None, resources=None, custom_headers=None, raw=False, **operation_config):
        """Move resources between resource groups.

        Move resources between resource groups.

        :param resource_group_name: Name of the resource group to which the
         resource belongs.
        :type resource_group_name: str
        :param target_resource_group:
        :type target_resource_group: str
        :param resources:
        :type resources: list[str]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        
        """
        api_version = self._get_api_version('move')
        if api_version == '2016-03-01':
            from .v2016_03_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.move(resource_group_name, target_resource_group, resources, custom_headers, raw, **operation_config)

    def update_publishing_user(self, user_details, custom_headers=None, raw=False, **operation_config):
        """Updates publishing user.

        Updates publishing user.

        :param user_details: Details of publishing user
        :type user_details: ~azure.mgmt.web.v2018_02_01.models.User
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: User or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.web.v2018_02_01.models.User or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`DefaultErrorResponseException<azure.mgmt.web.v2018_02_01.models.DefaultErrorResponseException>`
        
        """
        api_version = self._get_api_version('update_publishing_user')
        if api_version == '2016-03-01':
            from .v2016_03_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.update_publishing_user(user_details, custom_headers, raw, **operation_config)

    def update_source_control(self, source_control_type, request_message, custom_headers=None, raw=False, **operation_config):
        """Updates source control token.

        Updates source control token.

        :param source_control_type: Type of source control
        :type source_control_type: str
        :param request_message: Source control token information
        :type request_message:
         ~azure.mgmt.web.v2018_02_01.models.SourceControl
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: SourceControl or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.web.v2018_02_01.models.SourceControl or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`DefaultErrorResponseException<azure.mgmt.web.v2018_02_01.models.DefaultErrorResponseException>`
        
        """
        api_version = self._get_api_version('update_source_control')
        if api_version == '2016-03-01':
            from .v2016_03_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.update_source_control(source_control_type, request_message, custom_headers, raw, **operation_config)

    def validate(self, resource_group_name, validate_request, custom_headers=None, raw=False, **operation_config):
        """Validate if a resource can be created.

        Validate if a resource can be created.

        :param resource_group_name: Name of the resource group to which the
         resource belongs.
        :type resource_group_name: str
        :param validate_request: Request with the resources to validate.
        :type validate_request:
         ~azure.mgmt.web.v2018_02_01.models.ValidateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ValidateResponse or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.web.v2018_02_01.models.ValidateResponse or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`DefaultErrorResponseException<azure.mgmt.web.v2018_02_01.models.DefaultErrorResponseException>`
        
        """
        api_version = self._get_api_version('validate')
        if api_version == '2016-03-01':
            from .v2016_03_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.validate(resource_group_name, validate_request, custom_headers, raw, **operation_config)

    def validate_container_settings(self, validate_container_settings_request, resource_group_name, custom_headers=None, raw=False, **operation_config):
        """Validate if the container settings are correct.

        Validate if the container settings are correct.

        :param validate_container_settings_request:
        :type validate_container_settings_request:
         ~azure.mgmt.web.v2018_02_01.models.ValidateContainerSettingsRequest
        :param resource_group_name: Name of the resource group to which the
         resource belongs.
        :type resource_group_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`DefaultErrorResponseException<azure.mgmt.web.v2018_02_01.models.DefaultErrorResponseException>`
        
        """
        api_version = self._get_api_version('validate_container_settings')
        if api_version == '2018-02-01':
            from .v2018_02_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.validate_container_settings(validate_container_settings_request, resource_group_name, custom_headers, raw, **operation_config)

    def validate_move(self, resource_group_name, target_resource_group=None, resources=None, custom_headers=None, raw=False, **operation_config):
        """Validate whether a resource can be moved.

        Validate whether a resource can be moved.

        :param resource_group_name: Name of the resource group to which the
         resource belongs.
        :type resource_group_name: str
        :param target_resource_group:
        :type target_resource_group: str
        :param resources:
        :type resources: list[str]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        
        """
        api_version = self._get_api_version('validate_move')
        if api_version == '2016-03-01':
            from .v2016_03_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.validate_move(resource_group_name, target_resource_group, resources, custom_headers, raw, **operation_config)

    def verify_hosting_environment_vnet(self, parameters, custom_headers=None, raw=False, **operation_config):
        """Verifies if this VNET is compatible with an App Service Environment by
        analyzing the Network Security Group rules.

        Verifies if this VNET is compatible with an App Service Environment by
        analyzing the Network Security Group rules.

        :param parameters: VNET information
        :type parameters: ~azure.mgmt.web.v2018_02_01.models.VnetParameters
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: VnetValidationFailureDetails or ClientRawResponse if raw=true
        :rtype:
         ~azure.mgmt.web.v2018_02_01.models.VnetValidationFailureDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`DefaultErrorResponseException<azure.mgmt.web.v2018_02_01.models.DefaultErrorResponseException>`
        
        """
        api_version = self._get_api_version('verify_hosting_environment_vnet')
        if api_version == '2016-03-01':
            from .v2016_03_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import WebSiteManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.verify_hosting_environment_vnet(parameters, custom_headers, raw, **operation_config)
