# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EnrichmentProperties(Model):
    """The properties of an enrichment that your IoT hub applies to messages
    delivered to endpoints.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. The key or name for the enrichment property.
    :type key: str
    :param value: Required. The value for the enrichment property.
    :type value: str
    :param endpoint_names: Required. The list of endpoints for which the
     enrichment is applied to the message.
    :type endpoint_names: list[str]
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
        'endpoint_names': {'required': True, 'min_items': 1},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'endpoint_names': {'key': 'endpointNames', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(EnrichmentProperties, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)
        self.endpoint_names = kwargs.get('endpoint_names', None)
