# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from azure.mgmt.core import AsyncARMPipelineClient
from msrest import Serializer, Deserializer

from azure.profiles import KnownProfiles, ProfileDefinition
from azure.profiles.multiapiclient import MultiApiClientMixin
from ._configuration_async import NetworkManagementClientConfiguration
from ._operations_mixin_async import NetworkManagementClientOperationsMixin
class _SDKClient(object):
    def __init__(self, *args, **kwargs):
        """This is a fake class to support current implemetation of MultiApiClientMixin."
        Will be removed in final version of multiapi azure-core based client
        """
        pass

class NetworkManagementClient(NetworkManagementClientOperationsMixin, MultiApiClientMixin, _SDKClient):
    """Network Client.

    This ready contains multiple API versions, to help you deal with all of the Azure clouds
    (Azure Stack, Azure Government, Azure China, etc.).
    By default, it uses the latest API version available on public Azure.
    For production, you should stick to a particular api-version and/or profile.
    The profile sets a mapping between an operation group and its API version.
    The api-version parameter sets the default API version if the operation
    group is not described in the profile.

    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The subscription credentials which uniquely identify the Microsoft Azure subscription. The subscription ID forms part of the URI for every service call.
    :type subscription_id: str
    :param str api_version: API version to use if no profile is provided, or if
     missing in profile.
    :param str base_url: Service URL
    :param profile: A profile definition, from KnownProfiles to dict.
    :type profile: azure.profiles.KnownProfiles
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    DEFAULT_API_VERSION = '2020-04-01'
    _PROFILE_TAG = "azure.mgmt.network.NetworkManagementClient"
    LATEST_PROFILE = ProfileDefinition({
        _PROFILE_TAG: {
            None: DEFAULT_API_VERSION,
            'interface_endpoints': '2019-02-01',
            'p2_svpn_server_configurations': '2019-07-01',
        }},
        _PROFILE_TAG + " latest"
    )

    def __init__(
        self,
        credential,  # type: "AsyncTokenCredential"
        subscription_id,  # type: str
        api_version=None,
        base_url=None,
        profile=KnownProfiles.default,
        **kwargs  # type: Any
    ) -> None:
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = NetworkManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)
        super(NetworkManagementClient, self).__init__(
            credential,
            self._config,
            api_version=api_version,
            profile=profile
        )

    @classmethod
    def _models_dict(cls, api_version):
        return {k: v for k, v in cls.models(api_version).__dict__.items() if isinstance(v, type)}

    @classmethod
    def models(cls, api_version=DEFAULT_API_VERSION):
        """Module depends on the API version:

           * 2015-06-15: :mod:`v2015_06_15.models<azure.mgmt.network.v2015_06_15.models>`
           * 2016-09-01: :mod:`v2016_09_01.models<azure.mgmt.network.v2016_09_01.models>`
           * 2016-12-01: :mod:`v2016_12_01.models<azure.mgmt.network.v2016_12_01.models>`
           * 2017-03-01: :mod:`v2017_03_01.models<azure.mgmt.network.v2017_03_01.models>`
           * 2017-06-01: :mod:`v2017_06_01.models<azure.mgmt.network.v2017_06_01.models>`
           * 2017-08-01: :mod:`v2017_08_01.models<azure.mgmt.network.v2017_08_01.models>`
           * 2017-09-01: :mod:`v2017_09_01.models<azure.mgmt.network.v2017_09_01.models>`
           * 2017-10-01: :mod:`v2017_10_01.models<azure.mgmt.network.v2017_10_01.models>`
           * 2017-11-01: :mod:`v2017_11_01.models<azure.mgmt.network.v2017_11_01.models>`
           * 2018-01-01: :mod:`v2018_01_01.models<azure.mgmt.network.v2018_01_01.models>`
           * 2018-02-01: :mod:`v2018_02_01.models<azure.mgmt.network.v2018_02_01.models>`
           * 2018-04-01: :mod:`v2018_04_01.models<azure.mgmt.network.v2018_04_01.models>`
           * 2018-06-01: :mod:`v2018_06_01.models<azure.mgmt.network.v2018_06_01.models>`
           * 2018-07-01: :mod:`v2018_07_01.models<azure.mgmt.network.v2018_07_01.models>`
           * 2018-08-01: :mod:`v2018_08_01.models<azure.mgmt.network.v2018_08_01.models>`
           * 2018-10-01: :mod:`v2018_10_01.models<azure.mgmt.network.v2018_10_01.models>`
           * 2018-11-01: :mod:`v2018_11_01.models<azure.mgmt.network.v2018_11_01.models>`
           * 2018-12-01: :mod:`v2018_12_01.models<azure.mgmt.network.v2018_12_01.models>`
           * 2019-02-01: :mod:`v2019_02_01.models<azure.mgmt.network.v2019_02_01.models>`
           * 2019-04-01: :mod:`v2019_04_01.models<azure.mgmt.network.v2019_04_01.models>`
           * 2019-06-01: :mod:`v2019_06_01.models<azure.mgmt.network.v2019_06_01.models>`
           * 2019-07-01: :mod:`v2019_07_01.models<azure.mgmt.network.v2019_07_01.models>`
           * 2019-08-01: :mod:`v2019_08_01.models<azure.mgmt.network.v2019_08_01.models>`
           * 2019-09-01: :mod:`v2019_09_01.models<azure.mgmt.network.v2019_09_01.models>`
           * 2019-11-01: :mod:`v2019_11_01.models<azure.mgmt.network.v2019_11_01.models>`
           * 2019-12-01: :mod:`v2019_12_01.models<azure.mgmt.network.v2019_12_01.models>`
           * 2020-03-01: :mod:`v2020_03_01.models<azure.mgmt.network.v2020_03_01.models>`
           * 2020-04-01: :mod:`v2020_04_01.models<azure.mgmt.network.v2020_04_01.models>`
        """
        if api_version == '2015-06-15':
            from ..v2015_06_15 import models
            return models
        elif api_version == '2016-09-01':
            from ..v2016_09_01 import models
            return models
        elif api_version == '2016-12-01':
            from ..v2016_12_01 import models
            return models
        elif api_version == '2017-03-01':
            from ..v2017_03_01 import models
            return models
        elif api_version == '2017-06-01':
            from ..v2017_06_01 import models
            return models
        elif api_version == '2017-08-01':
            from ..v2017_08_01 import models
            return models
        elif api_version == '2017-09-01':
            from ..v2017_09_01 import models
            return models
        elif api_version == '2017-10-01':
            from ..v2017_10_01 import models
            return models
        elif api_version == '2017-11-01':
            from ..v2017_11_01 import models
            return models
        elif api_version == '2018-01-01':
            from ..v2018_01_01 import models
            return models
        elif api_version == '2018-02-01':
            from ..v2018_02_01 import models
            return models
        elif api_version == '2018-04-01':
            from ..v2018_04_01 import models
            return models
        elif api_version == '2018-06-01':
            from ..v2018_06_01 import models
            return models
        elif api_version == '2018-07-01':
            from ..v2018_07_01 import models
            return models
        elif api_version == '2018-08-01':
            from ..v2018_08_01 import models
            return models
        elif api_version == '2018-10-01':
            from ..v2018_10_01 import models
            return models
        elif api_version == '2018-11-01':
            from ..v2018_11_01 import models
            return models
        elif api_version == '2018-12-01':
            from ..v2018_12_01 import models
            return models
        elif api_version == '2019-02-01':
            from ..v2019_02_01 import models
            return models
        elif api_version == '2019-04-01':
            from ..v2019_04_01 import models
            return models
        elif api_version == '2019-06-01':
            from ..v2019_06_01 import models
            return models
        elif api_version == '2019-07-01':
            from ..v2019_07_01 import models
            return models
        elif api_version == '2019-08-01':
            from ..v2019_08_01 import models
            return models
        elif api_version == '2019-09-01':
            from ..v2019_09_01 import models
            return models
        elif api_version == '2019-11-01':
            from ..v2019_11_01 import models
            return models
        elif api_version == '2019-12-01':
            from ..v2019_12_01 import models
            return models
        elif api_version == '2020-03-01':
            from ..v2020_03_01 import models
            return models
        elif api_version == '2020-04-01':
            from ..v2020_04_01 import models
            return models
        raise NotImplementedError("APIVersion {} is not available".format(api_version))

    @property
    def application_gateways(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2015_06_15.aio.operations_async.ApplicationGatewaysOperations>`
           * 2016-09-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2016-12-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2017-03-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2017-06-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2017-08-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2017-09-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2017-10-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2017-11-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2018-01-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2018-02-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2018-04-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2018-06-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2018-07-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2018-08-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2018-10-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2018-11-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2018-12-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2019-02-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2019-04-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2019-06-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2019-07-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2019-08-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2019-09-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2019-11-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2019-12-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2020-03-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ApplicationGatewaysOperations>`
           * 2020-04-01: :class:`ApplicationGatewaysOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ApplicationGatewaysOperations>`
        """
        api_version = self._get_api_version('application_gateways')
        if api_version == '2015-06-15':
            from ..v2015_06_15.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ApplicationGatewaysOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def application_security_groups(self):
        """Instance depends on the API version:

           * 2017-09-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2017-10-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2017-11-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2018-01-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2018-02-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2018-04-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2018-06-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2018-07-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2018-08-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2018-10-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2018-11-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2018-12-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2019-02-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2019-04-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2019-06-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2019-07-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2019-08-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2019-09-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2019-11-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2019-12-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2020-03-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
           * 2020-04-01: :class:`ApplicationSecurityGroupsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ApplicationSecurityGroupsOperations>`
        """
        api_version = self._get_api_version('application_security_groups')
        if api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ApplicationSecurityGroupsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def available_delegations(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.AvailableDelegationsOperations>`
           * 2018-10-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.AvailableDelegationsOperations>`
           * 2018-11-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.AvailableDelegationsOperations>`
           * 2018-12-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.AvailableDelegationsOperations>`
           * 2019-02-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.AvailableDelegationsOperations>`
           * 2019-04-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.AvailableDelegationsOperations>`
           * 2019-06-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.AvailableDelegationsOperations>`
           * 2019-07-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.AvailableDelegationsOperations>`
           * 2019-08-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.AvailableDelegationsOperations>`
           * 2019-09-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.AvailableDelegationsOperations>`
           * 2019-11-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.AvailableDelegationsOperations>`
           * 2019-12-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.AvailableDelegationsOperations>`
           * 2020-03-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.AvailableDelegationsOperations>`
           * 2020-04-01: :class:`AvailableDelegationsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.AvailableDelegationsOperations>`
        """
        api_version = self._get_api_version('available_delegations')
        if api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import AvailableDelegationsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import AvailableDelegationsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import AvailableDelegationsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import AvailableDelegationsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import AvailableDelegationsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import AvailableDelegationsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import AvailableDelegationsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import AvailableDelegationsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import AvailableDelegationsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import AvailableDelegationsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import AvailableDelegationsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import AvailableDelegationsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import AvailableDelegationsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import AvailableDelegationsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def available_endpoint_services(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2017-08-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2017-09-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2017-10-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2017-11-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2018-01-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2018-02-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2018-04-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2018-06-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2018-07-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2018-08-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2018-10-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2018-11-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2018-12-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2019-02-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2019-04-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2019-06-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2019-07-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2019-08-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2019-09-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2019-11-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2019-12-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2020-03-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.AvailableEndpointServicesOperations>`
           * 2020-04-01: :class:`AvailableEndpointServicesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.AvailableEndpointServicesOperations>`
        """
        api_version = self._get_api_version('available_endpoint_services')
        if api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import AvailableEndpointServicesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def available_private_endpoint_types(self):
        """Instance depends on the API version:

           * 2019-04-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.AvailablePrivateEndpointTypesOperations>`
           * 2019-06-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.AvailablePrivateEndpointTypesOperations>`
           * 2019-07-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.AvailablePrivateEndpointTypesOperations>`
           * 2019-08-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.AvailablePrivateEndpointTypesOperations>`
           * 2019-09-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.AvailablePrivateEndpointTypesOperations>`
           * 2019-11-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.AvailablePrivateEndpointTypesOperations>`
           * 2019-12-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.AvailablePrivateEndpointTypesOperations>`
           * 2020-03-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.AvailablePrivateEndpointTypesOperations>`
           * 2020-04-01: :class:`AvailablePrivateEndpointTypesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.AvailablePrivateEndpointTypesOperations>`
        """
        api_version = self._get_api_version('available_private_endpoint_types')
        if api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import AvailablePrivateEndpointTypesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import AvailablePrivateEndpointTypesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def available_resource_group_delegations(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.AvailableResourceGroupDelegationsOperations>`
           * 2018-10-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.AvailableResourceGroupDelegationsOperations>`
           * 2018-11-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.AvailableResourceGroupDelegationsOperations>`
           * 2018-12-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.AvailableResourceGroupDelegationsOperations>`
           * 2019-02-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.AvailableResourceGroupDelegationsOperations>`
           * 2019-04-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.AvailableResourceGroupDelegationsOperations>`
           * 2019-06-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.AvailableResourceGroupDelegationsOperations>`
           * 2019-07-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.AvailableResourceGroupDelegationsOperations>`
           * 2019-08-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.AvailableResourceGroupDelegationsOperations>`
           * 2019-09-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.AvailableResourceGroupDelegationsOperations>`
           * 2019-11-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.AvailableResourceGroupDelegationsOperations>`
           * 2019-12-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.AvailableResourceGroupDelegationsOperations>`
           * 2020-03-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.AvailableResourceGroupDelegationsOperations>`
           * 2020-04-01: :class:`AvailableResourceGroupDelegationsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.AvailableResourceGroupDelegationsOperations>`
        """
        api_version = self._get_api_version('available_resource_group_delegations')
        if api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import AvailableResourceGroupDelegationsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import AvailableResourceGroupDelegationsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def available_service_aliases(self):
        """Instance depends on the API version:

           * 2019-08-01: :class:`AvailableServiceAliasesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.AvailableServiceAliasesOperations>`
           * 2019-09-01: :class:`AvailableServiceAliasesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.AvailableServiceAliasesOperations>`
           * 2019-11-01: :class:`AvailableServiceAliasesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.AvailableServiceAliasesOperations>`
           * 2019-12-01: :class:`AvailableServiceAliasesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.AvailableServiceAliasesOperations>`
           * 2020-03-01: :class:`AvailableServiceAliasesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.AvailableServiceAliasesOperations>`
           * 2020-04-01: :class:`AvailableServiceAliasesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.AvailableServiceAliasesOperations>`
        """
        api_version = self._get_api_version('available_service_aliases')
        if api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import AvailableServiceAliasesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import AvailableServiceAliasesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import AvailableServiceAliasesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import AvailableServiceAliasesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import AvailableServiceAliasesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import AvailableServiceAliasesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def azure_firewall_fqdn_tags(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.AzureFirewallFqdnTagsOperations>`
           * 2018-10-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.AzureFirewallFqdnTagsOperations>`
           * 2018-11-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.AzureFirewallFqdnTagsOperations>`
           * 2018-12-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.AzureFirewallFqdnTagsOperations>`
           * 2019-02-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.AzureFirewallFqdnTagsOperations>`
           * 2019-04-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.AzureFirewallFqdnTagsOperations>`
           * 2019-06-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.AzureFirewallFqdnTagsOperations>`
           * 2019-07-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.AzureFirewallFqdnTagsOperations>`
           * 2019-08-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.AzureFirewallFqdnTagsOperations>`
           * 2019-09-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.AzureFirewallFqdnTagsOperations>`
           * 2019-11-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.AzureFirewallFqdnTagsOperations>`
           * 2019-12-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.AzureFirewallFqdnTagsOperations>`
           * 2020-03-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.AzureFirewallFqdnTagsOperations>`
           * 2020-04-01: :class:`AzureFirewallFqdnTagsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.AzureFirewallFqdnTagsOperations>`
        """
        api_version = self._get_api_version('azure_firewall_fqdn_tags')
        if api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import AzureFirewallFqdnTagsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import AzureFirewallFqdnTagsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def azure_firewalls(self):
        """Instance depends on the API version:

           * 2018-04-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.AzureFirewallsOperations>`
           * 2018-06-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.AzureFirewallsOperations>`
           * 2018-07-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.AzureFirewallsOperations>`
           * 2018-08-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.AzureFirewallsOperations>`
           * 2018-10-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.AzureFirewallsOperations>`
           * 2018-11-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.AzureFirewallsOperations>`
           * 2018-12-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.AzureFirewallsOperations>`
           * 2019-02-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.AzureFirewallsOperations>`
           * 2019-04-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.AzureFirewallsOperations>`
           * 2019-06-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.AzureFirewallsOperations>`
           * 2019-07-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.AzureFirewallsOperations>`
           * 2019-08-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.AzureFirewallsOperations>`
           * 2019-09-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.AzureFirewallsOperations>`
           * 2019-11-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.AzureFirewallsOperations>`
           * 2019-12-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.AzureFirewallsOperations>`
           * 2020-03-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.AzureFirewallsOperations>`
           * 2020-04-01: :class:`AzureFirewallsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.AzureFirewallsOperations>`
        """
        api_version = self._get_api_version('azure_firewalls')
        if api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import AzureFirewallsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import AzureFirewallsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import AzureFirewallsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import AzureFirewallsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import AzureFirewallsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import AzureFirewallsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import AzureFirewallsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import AzureFirewallsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import AzureFirewallsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import AzureFirewallsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import AzureFirewallsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import AzureFirewallsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import AzureFirewallsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import AzureFirewallsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import AzureFirewallsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import AzureFirewallsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import AzureFirewallsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def bastion_hosts(self):
        """Instance depends on the API version:

           * 2019-04-01: :class:`BastionHostsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.BastionHostsOperations>`
           * 2019-06-01: :class:`BastionHostsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.BastionHostsOperations>`
           * 2019-07-01: :class:`BastionHostsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.BastionHostsOperations>`
           * 2019-08-01: :class:`BastionHostsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.BastionHostsOperations>`
           * 2019-09-01: :class:`BastionHostsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.BastionHostsOperations>`
           * 2019-11-01: :class:`BastionHostsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.BastionHostsOperations>`
           * 2019-12-01: :class:`BastionHostsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.BastionHostsOperations>`
           * 2020-03-01: :class:`BastionHostsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.BastionHostsOperations>`
           * 2020-04-01: :class:`BastionHostsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.BastionHostsOperations>`
        """
        api_version = self._get_api_version('bastion_hosts')
        if api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import BastionHostsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import BastionHostsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import BastionHostsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import BastionHostsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import BastionHostsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import BastionHostsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import BastionHostsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import BastionHostsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import BastionHostsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def bgp_service_communities(self):
        """Instance depends on the API version:

           * 2016-12-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2017-03-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2017-06-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2017-08-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2017-09-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2017-10-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2017-11-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2018-01-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2018-02-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2018-04-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2018-06-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2018-07-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2018-08-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2018-10-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2018-11-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2018-12-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2019-02-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2019-04-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2019-06-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2019-07-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2019-08-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2019-09-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2019-11-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2019-12-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2020-03-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.BgpServiceCommunitiesOperations>`
           * 2020-04-01: :class:`BgpServiceCommunitiesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.BgpServiceCommunitiesOperations>`
        """
        api_version = self._get_api_version('bgp_service_communities')
        if api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import BgpServiceCommunitiesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def connection_monitors(self):
        """Instance depends on the API version:

           * 2017-10-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2017-11-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2018-01-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2018-02-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2018-04-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2018-06-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2018-07-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2018-08-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2018-10-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2018-11-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2018-12-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2019-02-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2019-04-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2019-06-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2019-07-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2019-08-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2019-09-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2019-11-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2019-12-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2020-03-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ConnectionMonitorsOperations>`
           * 2020-04-01: :class:`ConnectionMonitorsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ConnectionMonitorsOperations>`
        """
        api_version = self._get_api_version('connection_monitors')
        if api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ConnectionMonitorsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def ddos_custom_policies(self):
        """Instance depends on the API version:

           * 2018-11-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.DdosCustomPoliciesOperations>`
           * 2018-12-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.DdosCustomPoliciesOperations>`
           * 2019-02-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.DdosCustomPoliciesOperations>`
           * 2019-04-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.DdosCustomPoliciesOperations>`
           * 2019-06-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.DdosCustomPoliciesOperations>`
           * 2019-07-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.DdosCustomPoliciesOperations>`
           * 2019-08-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.DdosCustomPoliciesOperations>`
           * 2019-09-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.DdosCustomPoliciesOperations>`
           * 2019-11-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.DdosCustomPoliciesOperations>`
           * 2019-12-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.DdosCustomPoliciesOperations>`
           * 2020-03-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.DdosCustomPoliciesOperations>`
           * 2020-04-01: :class:`DdosCustomPoliciesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.DdosCustomPoliciesOperations>`
        """
        api_version = self._get_api_version('ddos_custom_policies')
        if api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import DdosCustomPoliciesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import DdosCustomPoliciesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def ddos_protection_plans(self):
        """Instance depends on the API version:

           * 2018-02-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.DdosProtectionPlansOperations>`
           * 2018-04-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.DdosProtectionPlansOperations>`
           * 2018-06-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.DdosProtectionPlansOperations>`
           * 2018-07-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.DdosProtectionPlansOperations>`
           * 2018-08-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.DdosProtectionPlansOperations>`
           * 2018-10-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.DdosProtectionPlansOperations>`
           * 2018-11-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.DdosProtectionPlansOperations>`
           * 2018-12-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.DdosProtectionPlansOperations>`
           * 2019-02-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.DdosProtectionPlansOperations>`
           * 2019-04-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.DdosProtectionPlansOperations>`
           * 2019-06-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.DdosProtectionPlansOperations>`
           * 2019-07-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.DdosProtectionPlansOperations>`
           * 2019-08-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.DdosProtectionPlansOperations>`
           * 2019-09-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.DdosProtectionPlansOperations>`
           * 2019-11-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.DdosProtectionPlansOperations>`
           * 2019-12-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.DdosProtectionPlansOperations>`
           * 2020-03-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.DdosProtectionPlansOperations>`
           * 2020-04-01: :class:`DdosProtectionPlansOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.DdosProtectionPlansOperations>`
        """
        api_version = self._get_api_version('ddos_protection_plans')
        if api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import DdosProtectionPlansOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import DdosProtectionPlansOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def default_security_rules(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2017-08-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2017-09-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2017-10-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2017-11-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2018-01-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2018-02-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2018-04-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2018-06-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2018-07-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2018-08-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2018-10-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2018-11-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2018-12-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2019-02-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2019-04-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2019-06-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2019-07-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2019-08-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2019-09-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2019-11-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2019-12-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2020-03-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.DefaultSecurityRulesOperations>`
           * 2020-04-01: :class:`DefaultSecurityRulesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.DefaultSecurityRulesOperations>`
        """
        api_version = self._get_api_version('default_security_rules')
        if api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import DefaultSecurityRulesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_circuit_authorizations(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2015_06_15.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2016-09-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2016-12-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-03-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-06-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-08-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-09-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-10-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2017-11-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2018-01-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2018-02-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2018-04-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2018-06-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2018-07-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2018-08-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2018-10-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2018-11-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2018-12-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2019-02-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2019-04-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2019-06-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2019-07-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2019-08-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2019-09-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2019-11-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2019-12-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2020-03-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
           * 2020-04-01: :class:`ExpressRouteCircuitAuthorizationsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ExpressRouteCircuitAuthorizationsOperations>`
        """
        api_version = self._get_api_version('express_route_circuit_authorizations')
        if api_version == '2015-06-15':
            from ..v2015_06_15.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ExpressRouteCircuitAuthorizationsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_circuit_connections(self):
        """Instance depends on the API version:

           * 2018-02-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.ExpressRouteCircuitConnectionsOperations>`
           * 2018-04-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.ExpressRouteCircuitConnectionsOperations>`
           * 2018-06-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.ExpressRouteCircuitConnectionsOperations>`
           * 2018-07-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.ExpressRouteCircuitConnectionsOperations>`
           * 2018-08-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.ExpressRouteCircuitConnectionsOperations>`
           * 2018-10-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.ExpressRouteCircuitConnectionsOperations>`
           * 2018-11-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.ExpressRouteCircuitConnectionsOperations>`
           * 2018-12-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.ExpressRouteCircuitConnectionsOperations>`
           * 2019-02-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.ExpressRouteCircuitConnectionsOperations>`
           * 2019-04-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ExpressRouteCircuitConnectionsOperations>`
           * 2019-06-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ExpressRouteCircuitConnectionsOperations>`
           * 2019-07-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ExpressRouteCircuitConnectionsOperations>`
           * 2019-08-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ExpressRouteCircuitConnectionsOperations>`
           * 2019-09-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ExpressRouteCircuitConnectionsOperations>`
           * 2019-11-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ExpressRouteCircuitConnectionsOperations>`
           * 2019-12-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ExpressRouteCircuitConnectionsOperations>`
           * 2020-03-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ExpressRouteCircuitConnectionsOperations>`
           * 2020-04-01: :class:`ExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ExpressRouteCircuitConnectionsOperations>`
        """
        api_version = self._get_api_version('express_route_circuit_connections')
        if api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ExpressRouteCircuitConnectionsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_circuit_peerings(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2015_06_15.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2016-09-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2016-12-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2017-03-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2017-06-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2017-08-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2017-09-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2017-10-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2017-11-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2018-01-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2018-02-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2018-04-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2018-06-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2018-07-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2018-08-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2018-10-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2018-11-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2018-12-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2019-02-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2019-04-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2019-06-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2019-07-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2019-08-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2019-09-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2019-11-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2019-12-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2020-03-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
           * 2020-04-01: :class:`ExpressRouteCircuitPeeringsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ExpressRouteCircuitPeeringsOperations>`
        """
        api_version = self._get_api_version('express_route_circuit_peerings')
        if api_version == '2015-06-15':
            from ..v2015_06_15.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ExpressRouteCircuitPeeringsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_circuits(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2015_06_15.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2016-09-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2016-12-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2017-03-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2017-06-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2017-08-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2017-09-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2017-10-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2017-11-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2018-01-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2018-02-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2018-04-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2018-06-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2018-07-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2018-08-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2018-10-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2018-11-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2018-12-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2019-02-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2019-04-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2019-06-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2019-07-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2019-08-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2019-09-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2019-11-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2019-12-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2020-03-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ExpressRouteCircuitsOperations>`
           * 2020-04-01: :class:`ExpressRouteCircuitsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ExpressRouteCircuitsOperations>`
        """
        api_version = self._get_api_version('express_route_circuits')
        if api_version == '2015-06-15':
            from ..v2015_06_15.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ExpressRouteCircuitsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_connections(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.ExpressRouteConnectionsOperations>`
           * 2018-10-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.ExpressRouteConnectionsOperations>`
           * 2018-11-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.ExpressRouteConnectionsOperations>`
           * 2018-12-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.ExpressRouteConnectionsOperations>`
           * 2019-02-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.ExpressRouteConnectionsOperations>`
           * 2019-04-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ExpressRouteConnectionsOperations>`
           * 2019-06-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ExpressRouteConnectionsOperations>`
           * 2019-07-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ExpressRouteConnectionsOperations>`
           * 2019-08-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ExpressRouteConnectionsOperations>`
           * 2019-09-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ExpressRouteConnectionsOperations>`
           * 2019-11-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ExpressRouteConnectionsOperations>`
           * 2019-12-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ExpressRouteConnectionsOperations>`
           * 2020-03-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ExpressRouteConnectionsOperations>`
           * 2020-04-01: :class:`ExpressRouteConnectionsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ExpressRouteConnectionsOperations>`
        """
        api_version = self._get_api_version('express_route_connections')
        if api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ExpressRouteConnectionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ExpressRouteConnectionsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_cross_connection_peerings(self):
        """Instance depends on the API version:

           * 2018-02-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2018-04-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2018-06-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2018-07-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2018-08-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2018-10-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2018-11-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2018-12-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2019-02-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2019-04-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2019-06-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2019-07-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2019-08-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2019-09-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2019-11-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2019-12-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2020-03-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ExpressRouteCrossConnectionPeeringsOperations>`
           * 2020-04-01: :class:`ExpressRouteCrossConnectionPeeringsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ExpressRouteCrossConnectionPeeringsOperations>`
        """
        api_version = self._get_api_version('express_route_cross_connection_peerings')
        if api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ExpressRouteCrossConnectionPeeringsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_cross_connections(self):
        """Instance depends on the API version:

           * 2018-02-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.ExpressRouteCrossConnectionsOperations>`
           * 2018-04-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.ExpressRouteCrossConnectionsOperations>`
           * 2018-06-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.ExpressRouteCrossConnectionsOperations>`
           * 2018-07-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.ExpressRouteCrossConnectionsOperations>`
           * 2018-08-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.ExpressRouteCrossConnectionsOperations>`
           * 2018-10-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.ExpressRouteCrossConnectionsOperations>`
           * 2018-11-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.ExpressRouteCrossConnectionsOperations>`
           * 2018-12-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.ExpressRouteCrossConnectionsOperations>`
           * 2019-02-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.ExpressRouteCrossConnectionsOperations>`
           * 2019-04-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ExpressRouteCrossConnectionsOperations>`
           * 2019-06-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ExpressRouteCrossConnectionsOperations>`
           * 2019-07-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ExpressRouteCrossConnectionsOperations>`
           * 2019-08-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ExpressRouteCrossConnectionsOperations>`
           * 2019-09-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ExpressRouteCrossConnectionsOperations>`
           * 2019-11-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ExpressRouteCrossConnectionsOperations>`
           * 2019-12-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ExpressRouteCrossConnectionsOperations>`
           * 2020-03-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ExpressRouteCrossConnectionsOperations>`
           * 2020-04-01: :class:`ExpressRouteCrossConnectionsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ExpressRouteCrossConnectionsOperations>`
        """
        api_version = self._get_api_version('express_route_cross_connections')
        if api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ExpressRouteCrossConnectionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ExpressRouteCrossConnectionsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_gateways(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.ExpressRouteGatewaysOperations>`
           * 2018-10-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.ExpressRouteGatewaysOperations>`
           * 2018-11-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.ExpressRouteGatewaysOperations>`
           * 2018-12-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.ExpressRouteGatewaysOperations>`
           * 2019-02-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.ExpressRouteGatewaysOperations>`
           * 2019-04-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ExpressRouteGatewaysOperations>`
           * 2019-06-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ExpressRouteGatewaysOperations>`
           * 2019-07-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ExpressRouteGatewaysOperations>`
           * 2019-08-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ExpressRouteGatewaysOperations>`
           * 2019-09-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ExpressRouteGatewaysOperations>`
           * 2019-11-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ExpressRouteGatewaysOperations>`
           * 2019-12-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ExpressRouteGatewaysOperations>`
           * 2020-03-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ExpressRouteGatewaysOperations>`
           * 2020-04-01: :class:`ExpressRouteGatewaysOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ExpressRouteGatewaysOperations>`
        """
        api_version = self._get_api_version('express_route_gateways')
        if api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ExpressRouteGatewaysOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ExpressRouteGatewaysOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_links(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.ExpressRouteLinksOperations>`
           * 2018-10-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.ExpressRouteLinksOperations>`
           * 2018-11-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.ExpressRouteLinksOperations>`
           * 2018-12-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.ExpressRouteLinksOperations>`
           * 2019-02-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.ExpressRouteLinksOperations>`
           * 2019-04-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ExpressRouteLinksOperations>`
           * 2019-06-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ExpressRouteLinksOperations>`
           * 2019-07-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ExpressRouteLinksOperations>`
           * 2019-08-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ExpressRouteLinksOperations>`
           * 2019-09-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ExpressRouteLinksOperations>`
           * 2019-11-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ExpressRouteLinksOperations>`
           * 2019-12-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ExpressRouteLinksOperations>`
           * 2020-03-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ExpressRouteLinksOperations>`
           * 2020-04-01: :class:`ExpressRouteLinksOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ExpressRouteLinksOperations>`
        """
        api_version = self._get_api_version('express_route_links')
        if api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ExpressRouteLinksOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ExpressRouteLinksOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_ports(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.ExpressRoutePortsOperations>`
           * 2018-10-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.ExpressRoutePortsOperations>`
           * 2018-11-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.ExpressRoutePortsOperations>`
           * 2018-12-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.ExpressRoutePortsOperations>`
           * 2019-02-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.ExpressRoutePortsOperations>`
           * 2019-04-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ExpressRoutePortsOperations>`
           * 2019-06-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ExpressRoutePortsOperations>`
           * 2019-07-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ExpressRoutePortsOperations>`
           * 2019-08-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ExpressRoutePortsOperations>`
           * 2019-09-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ExpressRoutePortsOperations>`
           * 2019-11-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ExpressRoutePortsOperations>`
           * 2019-12-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ExpressRoutePortsOperations>`
           * 2020-03-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ExpressRoutePortsOperations>`
           * 2020-04-01: :class:`ExpressRoutePortsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ExpressRoutePortsOperations>`
        """
        api_version = self._get_api_version('express_route_ports')
        if api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ExpressRoutePortsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ExpressRoutePortsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_ports_locations(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.ExpressRoutePortsLocationsOperations>`
           * 2018-10-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.ExpressRoutePortsLocationsOperations>`
           * 2018-11-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.ExpressRoutePortsLocationsOperations>`
           * 2018-12-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.ExpressRoutePortsLocationsOperations>`
           * 2019-02-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.ExpressRoutePortsLocationsOperations>`
           * 2019-04-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ExpressRoutePortsLocationsOperations>`
           * 2019-06-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ExpressRoutePortsLocationsOperations>`
           * 2019-07-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ExpressRoutePortsLocationsOperations>`
           * 2019-08-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ExpressRoutePortsLocationsOperations>`
           * 2019-09-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ExpressRoutePortsLocationsOperations>`
           * 2019-11-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ExpressRoutePortsLocationsOperations>`
           * 2019-12-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ExpressRoutePortsLocationsOperations>`
           * 2020-03-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ExpressRoutePortsLocationsOperations>`
           * 2020-04-01: :class:`ExpressRoutePortsLocationsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ExpressRoutePortsLocationsOperations>`
        """
        api_version = self._get_api_version('express_route_ports_locations')
        if api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ExpressRoutePortsLocationsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ExpressRoutePortsLocationsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def express_route_service_providers(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2015_06_15.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2016-09-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2016-12-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2017-03-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2017-06-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2017-08-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2017-09-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2017-10-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2017-11-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2018-01-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2018-02-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2018-04-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2018-06-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2018-07-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2018-08-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2018-10-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2018-11-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2018-12-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2019-02-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2019-04-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2019-06-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2019-07-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2019-08-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2019-09-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2019-11-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2019-12-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2020-03-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
           * 2020-04-01: :class:`ExpressRouteServiceProvidersOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ExpressRouteServiceProvidersOperations>`
        """
        api_version = self._get_api_version('express_route_service_providers')
        if api_version == '2015-06-15':
            from ..v2015_06_15.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ExpressRouteServiceProvidersOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def firewall_policies(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.FirewallPoliciesOperations>`
           * 2019-07-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.FirewallPoliciesOperations>`
           * 2019-08-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.FirewallPoliciesOperations>`
           * 2019-09-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.FirewallPoliciesOperations>`
           * 2019-11-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.FirewallPoliciesOperations>`
           * 2019-12-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.FirewallPoliciesOperations>`
           * 2020-03-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.FirewallPoliciesOperations>`
           * 2020-04-01: :class:`FirewallPoliciesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.FirewallPoliciesOperations>`
        """
        api_version = self._get_api_version('firewall_policies')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import FirewallPoliciesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import FirewallPoliciesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import FirewallPoliciesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import FirewallPoliciesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import FirewallPoliciesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import FirewallPoliciesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import FirewallPoliciesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import FirewallPoliciesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def firewall_policy_rule_groups(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`FirewallPolicyRuleGroupsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.FirewallPolicyRuleGroupsOperations>`
           * 2019-07-01: :class:`FirewallPolicyRuleGroupsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.FirewallPolicyRuleGroupsOperations>`
           * 2019-08-01: :class:`FirewallPolicyRuleGroupsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.FirewallPolicyRuleGroupsOperations>`
           * 2019-09-01: :class:`FirewallPolicyRuleGroupsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.FirewallPolicyRuleGroupsOperations>`
           * 2019-11-01: :class:`FirewallPolicyRuleGroupsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.FirewallPolicyRuleGroupsOperations>`
           * 2019-12-01: :class:`FirewallPolicyRuleGroupsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.FirewallPolicyRuleGroupsOperations>`
           * 2020-03-01: :class:`FirewallPolicyRuleGroupsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.FirewallPolicyRuleGroupsOperations>`
           * 2020-04-01: :class:`FirewallPolicyRuleGroupsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.FirewallPolicyRuleGroupsOperations>`
        """
        api_version = self._get_api_version('firewall_policy_rule_groups')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import FirewallPolicyRuleGroupsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import FirewallPolicyRuleGroupsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import FirewallPolicyRuleGroupsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import FirewallPolicyRuleGroupsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import FirewallPolicyRuleGroupsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import FirewallPolicyRuleGroupsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import FirewallPolicyRuleGroupsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import FirewallPolicyRuleGroupsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def flow_logs(self):
        """Instance depends on the API version:

           * 2019-11-01: :class:`FlowLogsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.FlowLogsOperations>`
           * 2019-12-01: :class:`FlowLogsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.FlowLogsOperations>`
           * 2020-03-01: :class:`FlowLogsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.FlowLogsOperations>`
           * 2020-04-01: :class:`FlowLogsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.FlowLogsOperations>`
        """
        api_version = self._get_api_version('flow_logs')
        if api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import FlowLogsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import FlowLogsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import FlowLogsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import FlowLogsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def hub_route_tables(self):
        """Instance depends on the API version:

           * 2020-04-01: :class:`HubRouteTablesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.HubRouteTablesOperations>`
        """
        api_version = self._get_api_version('hub_route_tables')
        if api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import HubRouteTablesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def hub_virtual_network_connections(self):
        """Instance depends on the API version:

           * 2018-04-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.HubVirtualNetworkConnectionsOperations>`
           * 2018-06-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.HubVirtualNetworkConnectionsOperations>`
           * 2018-07-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.HubVirtualNetworkConnectionsOperations>`
           * 2018-08-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.HubVirtualNetworkConnectionsOperations>`
           * 2018-10-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.HubVirtualNetworkConnectionsOperations>`
           * 2018-11-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.HubVirtualNetworkConnectionsOperations>`
           * 2018-12-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.HubVirtualNetworkConnectionsOperations>`
           * 2019-02-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.HubVirtualNetworkConnectionsOperations>`
           * 2019-04-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.HubVirtualNetworkConnectionsOperations>`
           * 2019-06-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.HubVirtualNetworkConnectionsOperations>`
           * 2019-07-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.HubVirtualNetworkConnectionsOperations>`
           * 2019-08-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.HubVirtualNetworkConnectionsOperations>`
           * 2019-09-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.HubVirtualNetworkConnectionsOperations>`
           * 2019-11-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.HubVirtualNetworkConnectionsOperations>`
           * 2019-12-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.HubVirtualNetworkConnectionsOperations>`
           * 2020-03-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.HubVirtualNetworkConnectionsOperations>`
           * 2020-04-01: :class:`HubVirtualNetworkConnectionsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.HubVirtualNetworkConnectionsOperations>`
        """
        api_version = self._get_api_version('hub_virtual_network_connections')
        if api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import HubVirtualNetworkConnectionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import HubVirtualNetworkConnectionsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def inbound_nat_rules(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.InboundNatRulesOperations>`
           * 2017-08-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.InboundNatRulesOperations>`
           * 2017-09-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.InboundNatRulesOperations>`
           * 2017-10-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.InboundNatRulesOperations>`
           * 2017-11-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.InboundNatRulesOperations>`
           * 2018-01-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.InboundNatRulesOperations>`
           * 2018-02-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.InboundNatRulesOperations>`
           * 2018-04-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.InboundNatRulesOperations>`
           * 2018-06-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.InboundNatRulesOperations>`
           * 2018-07-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.InboundNatRulesOperations>`
           * 2018-08-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.InboundNatRulesOperations>`
           * 2018-10-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.InboundNatRulesOperations>`
           * 2018-11-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.InboundNatRulesOperations>`
           * 2018-12-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.InboundNatRulesOperations>`
           * 2019-02-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.InboundNatRulesOperations>`
           * 2019-04-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.InboundNatRulesOperations>`
           * 2019-06-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.InboundNatRulesOperations>`
           * 2019-07-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.InboundNatRulesOperations>`
           * 2019-08-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.InboundNatRulesOperations>`
           * 2019-09-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.InboundNatRulesOperations>`
           * 2019-11-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.InboundNatRulesOperations>`
           * 2019-12-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.InboundNatRulesOperations>`
           * 2020-03-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.InboundNatRulesOperations>`
           * 2020-04-01: :class:`InboundNatRulesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.InboundNatRulesOperations>`
        """
        api_version = self._get_api_version('inbound_nat_rules')
        if api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import InboundNatRulesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def interface_endpoints(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`InterfaceEndpointsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.InterfaceEndpointsOperations>`
           * 2018-10-01: :class:`InterfaceEndpointsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.InterfaceEndpointsOperations>`
           * 2018-11-01: :class:`InterfaceEndpointsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.InterfaceEndpointsOperations>`
           * 2018-12-01: :class:`InterfaceEndpointsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.InterfaceEndpointsOperations>`
           * 2019-02-01: :class:`InterfaceEndpointsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.InterfaceEndpointsOperations>`
        """
        api_version = self._get_api_version('interface_endpoints')
        if api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import InterfaceEndpointsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import InterfaceEndpointsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import InterfaceEndpointsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import InterfaceEndpointsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import InterfaceEndpointsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def ip_allocations(self):
        """Instance depends on the API version:

           * 2020-03-01: :class:`IpAllocationsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.IpAllocationsOperations>`
           * 2020-04-01: :class:`IpAllocationsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.IpAllocationsOperations>`
        """
        api_version = self._get_api_version('ip_allocations')
        if api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import IpAllocationsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import IpAllocationsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def ip_groups(self):
        """Instance depends on the API version:

           * 2019-09-01: :class:`IpGroupsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.IpGroupsOperations>`
           * 2019-11-01: :class:`IpGroupsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.IpGroupsOperations>`
           * 2019-12-01: :class:`IpGroupsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.IpGroupsOperations>`
           * 2020-03-01: :class:`IpGroupsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.IpGroupsOperations>`
           * 2020-04-01: :class:`IpGroupsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.IpGroupsOperations>`
        """
        api_version = self._get_api_version('ip_groups')
        if api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import IpGroupsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import IpGroupsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import IpGroupsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import IpGroupsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import IpGroupsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancer_backend_address_pools(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2017-08-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2017-09-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2017-10-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2017-11-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2018-01-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2018-02-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2018-04-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2018-06-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2018-07-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2018-08-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2018-10-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2018-11-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2018-12-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2019-02-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2019-04-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2019-06-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2019-07-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2019-08-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2019-09-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2019-11-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2019-12-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2020-03-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
           * 2020-04-01: :class:`LoadBalancerBackendAddressPoolsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.LoadBalancerBackendAddressPoolsOperations>`
        """
        api_version = self._get_api_version('load_balancer_backend_address_pools')
        if api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import LoadBalancerBackendAddressPoolsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancer_frontend_ip_configurations(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2017-08-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2017-09-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2017-10-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2017-11-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2018-01-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2018-02-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2018-04-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2018-06-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2018-07-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2018-08-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2018-10-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2018-11-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2018-12-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2019-02-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2019-04-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2019-06-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2019-07-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2019-08-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2019-09-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2019-11-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2019-12-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2020-03-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
           * 2020-04-01: :class:`LoadBalancerFrontendIPConfigurationsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.LoadBalancerFrontendIPConfigurationsOperations>`
        """
        api_version = self._get_api_version('load_balancer_frontend_ip_configurations')
        if api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import LoadBalancerFrontendIPConfigurationsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancer_load_balancing_rules(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2017-08-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2017-09-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2017-10-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2017-11-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2018-01-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2018-02-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2018-04-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2018-06-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2018-07-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2018-08-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2018-10-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2018-11-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2018-12-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2019-02-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2019-04-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2019-06-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2019-07-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2019-08-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2019-09-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2019-11-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2019-12-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2020-03-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
           * 2020-04-01: :class:`LoadBalancerLoadBalancingRulesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.LoadBalancerLoadBalancingRulesOperations>`
        """
        api_version = self._get_api_version('load_balancer_load_balancing_rules')
        if api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import LoadBalancerLoadBalancingRulesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancer_network_interfaces(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2017-08-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2017-09-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2017-10-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2017-11-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2018-01-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2018-02-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2018-04-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2018-06-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2018-07-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2018-08-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2018-10-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2018-11-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2018-12-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2019-02-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2019-04-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2019-06-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2019-07-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2019-08-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2019-09-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2019-11-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2019-12-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2020-03-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
           * 2020-04-01: :class:`LoadBalancerNetworkInterfacesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.LoadBalancerNetworkInterfacesOperations>`
        """
        api_version = self._get_api_version('load_balancer_network_interfaces')
        if api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import LoadBalancerNetworkInterfacesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancer_outbound_rules(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.LoadBalancerOutboundRulesOperations>`
           * 2018-10-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.LoadBalancerOutboundRulesOperations>`
           * 2018-11-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.LoadBalancerOutboundRulesOperations>`
           * 2018-12-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.LoadBalancerOutboundRulesOperations>`
           * 2019-02-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.LoadBalancerOutboundRulesOperations>`
           * 2019-04-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.LoadBalancerOutboundRulesOperations>`
           * 2019-06-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.LoadBalancerOutboundRulesOperations>`
           * 2019-07-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.LoadBalancerOutboundRulesOperations>`
           * 2019-08-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.LoadBalancerOutboundRulesOperations>`
           * 2019-09-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.LoadBalancerOutboundRulesOperations>`
           * 2019-11-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.LoadBalancerOutboundRulesOperations>`
           * 2019-12-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.LoadBalancerOutboundRulesOperations>`
           * 2020-03-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.LoadBalancerOutboundRulesOperations>`
           * 2020-04-01: :class:`LoadBalancerOutboundRulesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.LoadBalancerOutboundRulesOperations>`
        """
        api_version = self._get_api_version('load_balancer_outbound_rules')
        if api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import LoadBalancerOutboundRulesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import LoadBalancerOutboundRulesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancer_probes(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2017-08-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2017-09-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2017-10-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2017-11-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2018-01-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2018-02-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2018-04-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2018-06-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2018-07-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2018-08-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2018-10-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2018-11-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2018-12-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2019-02-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2019-04-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2019-06-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2019-07-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2019-08-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2019-09-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2019-11-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2019-12-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2020-03-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.LoadBalancerProbesOperations>`
           * 2020-04-01: :class:`LoadBalancerProbesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.LoadBalancerProbesOperations>`
        """
        api_version = self._get_api_version('load_balancer_probes')
        if api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import LoadBalancerProbesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def load_balancers(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`LoadBalancersOperations<azure.mgmt.network.v2015_06_15.aio.operations_async.LoadBalancersOperations>`
           * 2016-09-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.LoadBalancersOperations>`
           * 2016-12-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.LoadBalancersOperations>`
           * 2017-03-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.LoadBalancersOperations>`
           * 2017-06-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.LoadBalancersOperations>`
           * 2017-08-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.LoadBalancersOperations>`
           * 2017-09-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.LoadBalancersOperations>`
           * 2017-10-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.LoadBalancersOperations>`
           * 2017-11-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.LoadBalancersOperations>`
           * 2018-01-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.LoadBalancersOperations>`
           * 2018-02-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.LoadBalancersOperations>`
           * 2018-04-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.LoadBalancersOperations>`
           * 2018-06-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.LoadBalancersOperations>`
           * 2018-07-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.LoadBalancersOperations>`
           * 2018-08-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.LoadBalancersOperations>`
           * 2018-10-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.LoadBalancersOperations>`
           * 2018-11-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.LoadBalancersOperations>`
           * 2018-12-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.LoadBalancersOperations>`
           * 2019-02-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.LoadBalancersOperations>`
           * 2019-04-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.LoadBalancersOperations>`
           * 2019-06-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.LoadBalancersOperations>`
           * 2019-07-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.LoadBalancersOperations>`
           * 2019-08-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.LoadBalancersOperations>`
           * 2019-09-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.LoadBalancersOperations>`
           * 2019-11-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.LoadBalancersOperations>`
           * 2019-12-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.LoadBalancersOperations>`
           * 2020-03-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.LoadBalancersOperations>`
           * 2020-04-01: :class:`LoadBalancersOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.LoadBalancersOperations>`
        """
        api_version = self._get_api_version('load_balancers')
        if api_version == '2015-06-15':
            from ..v2015_06_15.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import LoadBalancersOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import LoadBalancersOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def local_network_gateways(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2015_06_15.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2016-09-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2016-12-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2017-03-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2017-06-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2017-08-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2017-09-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2017-10-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2017-11-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2018-01-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2018-02-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2018-04-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2018-06-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2018-07-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2018-08-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2018-10-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2018-11-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2018-12-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2019-02-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2019-04-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2019-06-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2019-07-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2019-08-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2019-09-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2019-11-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2019-12-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2020-03-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.LocalNetworkGatewaysOperations>`
           * 2020-04-01: :class:`LocalNetworkGatewaysOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.LocalNetworkGatewaysOperations>`
        """
        api_version = self._get_api_version('local_network_gateways')
        if api_version == '2015-06-15':
            from ..v2015_06_15.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import LocalNetworkGatewaysOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def nat_gateways(self):
        """Instance depends on the API version:

           * 2019-02-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.NatGatewaysOperations>`
           * 2019-04-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.NatGatewaysOperations>`
           * 2019-06-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.NatGatewaysOperations>`
           * 2019-07-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.NatGatewaysOperations>`
           * 2019-08-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.NatGatewaysOperations>`
           * 2019-09-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.NatGatewaysOperations>`
           * 2019-11-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.NatGatewaysOperations>`
           * 2019-12-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.NatGatewaysOperations>`
           * 2020-03-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.NatGatewaysOperations>`
           * 2020-04-01: :class:`NatGatewaysOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.NatGatewaysOperations>`
        """
        api_version = self._get_api_version('nat_gateways')
        if api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import NatGatewaysOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import NatGatewaysOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import NatGatewaysOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import NatGatewaysOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import NatGatewaysOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import NatGatewaysOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import NatGatewaysOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import NatGatewaysOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import NatGatewaysOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import NatGatewaysOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_interface_ip_configurations(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2017-08-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2017-09-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2017-10-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2017-11-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2018-01-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2018-02-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2018-04-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2018-06-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2018-07-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2018-08-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2018-10-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2018-11-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2018-12-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2019-02-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2019-04-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2019-06-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2019-07-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2019-08-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2019-09-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2019-11-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2019-12-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2020-03-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
           * 2020-04-01: :class:`NetworkInterfaceIPConfigurationsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.NetworkInterfaceIPConfigurationsOperations>`
        """
        api_version = self._get_api_version('network_interface_ip_configurations')
        if api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import NetworkInterfaceIPConfigurationsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_interface_load_balancers(self):
        """Instance depends on the API version:

           * 2017-06-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2017-08-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2017-09-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2017-10-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2017-11-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2018-01-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2018-02-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2018-04-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2018-06-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2018-07-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2018-08-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2018-10-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2018-11-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2018-12-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2019-02-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2019-04-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2019-06-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2019-07-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2019-08-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2019-09-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2019-11-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2019-12-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2020-03-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
           * 2020-04-01: :class:`NetworkInterfaceLoadBalancersOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.NetworkInterfaceLoadBalancersOperations>`
        """
        api_version = self._get_api_version('network_interface_load_balancers')
        if api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import NetworkInterfaceLoadBalancersOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_interface_tap_configurations(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.NetworkInterfaceTapConfigurationsOperations>`
           * 2018-10-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.NetworkInterfaceTapConfigurationsOperations>`
           * 2018-11-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.NetworkInterfaceTapConfigurationsOperations>`
           * 2018-12-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.NetworkInterfaceTapConfigurationsOperations>`
           * 2019-02-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.NetworkInterfaceTapConfigurationsOperations>`
           * 2019-04-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.NetworkInterfaceTapConfigurationsOperations>`
           * 2019-06-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.NetworkInterfaceTapConfigurationsOperations>`
           * 2019-07-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.NetworkInterfaceTapConfigurationsOperations>`
           * 2019-08-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.NetworkInterfaceTapConfigurationsOperations>`
           * 2019-09-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.NetworkInterfaceTapConfigurationsOperations>`
           * 2019-11-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.NetworkInterfaceTapConfigurationsOperations>`
           * 2019-12-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.NetworkInterfaceTapConfigurationsOperations>`
           * 2020-03-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.NetworkInterfaceTapConfigurationsOperations>`
           * 2020-04-01: :class:`NetworkInterfaceTapConfigurationsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.NetworkInterfaceTapConfigurationsOperations>`
        """
        api_version = self._get_api_version('network_interface_tap_configurations')
        if api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import NetworkInterfaceTapConfigurationsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import NetworkInterfaceTapConfigurationsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_interfaces(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2015_06_15.aio.operations_async.NetworkInterfacesOperations>`
           * 2016-09-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2016-12-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2017-03-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2017-06-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2017-08-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2017-09-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2017-10-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2017-11-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2018-01-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2018-02-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2018-04-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2018-06-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2018-07-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2018-08-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2018-10-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2018-11-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2018-12-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2019-02-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2019-04-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2019-06-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2019-07-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2019-08-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2019-09-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2019-11-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2019-12-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2020-03-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.NetworkInterfacesOperations>`
           * 2020-04-01: :class:`NetworkInterfacesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.NetworkInterfacesOperations>`
        """
        api_version = self._get_api_version('network_interfaces')
        if api_version == '2015-06-15':
            from ..v2015_06_15.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import NetworkInterfacesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_profiles(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.NetworkProfilesOperations>`
           * 2018-10-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.NetworkProfilesOperations>`
           * 2018-11-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.NetworkProfilesOperations>`
           * 2018-12-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.NetworkProfilesOperations>`
           * 2019-02-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.NetworkProfilesOperations>`
           * 2019-04-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.NetworkProfilesOperations>`
           * 2019-06-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.NetworkProfilesOperations>`
           * 2019-07-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.NetworkProfilesOperations>`
           * 2019-08-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.NetworkProfilesOperations>`
           * 2019-09-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.NetworkProfilesOperations>`
           * 2019-11-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.NetworkProfilesOperations>`
           * 2019-12-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.NetworkProfilesOperations>`
           * 2020-03-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.NetworkProfilesOperations>`
           * 2020-04-01: :class:`NetworkProfilesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.NetworkProfilesOperations>`
        """
        api_version = self._get_api_version('network_profiles')
        if api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import NetworkProfilesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import NetworkProfilesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import NetworkProfilesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import NetworkProfilesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import NetworkProfilesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import NetworkProfilesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import NetworkProfilesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import NetworkProfilesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import NetworkProfilesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import NetworkProfilesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import NetworkProfilesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import NetworkProfilesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import NetworkProfilesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import NetworkProfilesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_security_groups(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2015_06_15.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2016-09-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2016-12-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2017-03-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2017-06-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2017-08-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2017-09-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2017-10-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2017-11-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2018-01-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2018-02-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2018-04-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2018-06-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2018-07-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2018-08-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2018-10-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2018-11-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2018-12-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2019-02-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2019-04-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2019-06-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2019-07-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2019-08-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2019-09-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2019-11-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2019-12-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2020-03-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.NetworkSecurityGroupsOperations>`
           * 2020-04-01: :class:`NetworkSecurityGroupsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.NetworkSecurityGroupsOperations>`
        """
        api_version = self._get_api_version('network_security_groups')
        if api_version == '2015-06-15':
            from ..v2015_06_15.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import NetworkSecurityGroupsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_virtual_appliances(self):
        """Instance depends on the API version:

           * 2019-12-01: :class:`NetworkVirtualAppliancesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.NetworkVirtualAppliancesOperations>`
           * 2020-03-01: :class:`NetworkVirtualAppliancesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.NetworkVirtualAppliancesOperations>`
           * 2020-04-01: :class:`NetworkVirtualAppliancesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.NetworkVirtualAppliancesOperations>`
        """
        api_version = self._get_api_version('network_virtual_appliances')
        if api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import NetworkVirtualAppliancesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import NetworkVirtualAppliancesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import NetworkVirtualAppliancesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def network_watchers(self):
        """Instance depends on the API version:

           * 2016-09-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.NetworkWatchersOperations>`
           * 2016-12-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.NetworkWatchersOperations>`
           * 2017-03-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.NetworkWatchersOperations>`
           * 2017-06-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.NetworkWatchersOperations>`
           * 2017-08-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.NetworkWatchersOperations>`
           * 2017-09-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.NetworkWatchersOperations>`
           * 2017-10-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.NetworkWatchersOperations>`
           * 2017-11-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.NetworkWatchersOperations>`
           * 2018-01-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.NetworkWatchersOperations>`
           * 2018-02-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.NetworkWatchersOperations>`
           * 2018-04-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.NetworkWatchersOperations>`
           * 2018-06-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.NetworkWatchersOperations>`
           * 2018-07-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.NetworkWatchersOperations>`
           * 2018-08-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.NetworkWatchersOperations>`
           * 2018-10-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.NetworkWatchersOperations>`
           * 2018-11-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.NetworkWatchersOperations>`
           * 2018-12-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.NetworkWatchersOperations>`
           * 2019-02-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.NetworkWatchersOperations>`
           * 2019-04-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.NetworkWatchersOperations>`
           * 2019-06-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.NetworkWatchersOperations>`
           * 2019-07-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.NetworkWatchersOperations>`
           * 2019-08-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.NetworkWatchersOperations>`
           * 2019-09-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.NetworkWatchersOperations>`
           * 2019-11-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.NetworkWatchersOperations>`
           * 2019-12-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.NetworkWatchersOperations>`
           * 2020-03-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.NetworkWatchersOperations>`
           * 2020-04-01: :class:`NetworkWatchersOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.NetworkWatchersOperations>`
        """
        api_version = self._get_api_version('network_watchers')
        if api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import NetworkWatchersOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def operations(self):
        """Instance depends on the API version:

           * 2017-09-01: :class:`Operations<azure.mgmt.network.v2017_09_01.aio.operations_async.Operations>`
           * 2017-10-01: :class:`Operations<azure.mgmt.network.v2017_10_01.aio.operations_async.Operations>`
           * 2017-11-01: :class:`Operations<azure.mgmt.network.v2017_11_01.aio.operations_async.Operations>`
           * 2018-01-01: :class:`Operations<azure.mgmt.network.v2018_01_01.aio.operations_async.Operations>`
           * 2018-02-01: :class:`Operations<azure.mgmt.network.v2018_02_01.aio.operations_async.Operations>`
           * 2018-04-01: :class:`Operations<azure.mgmt.network.v2018_04_01.aio.operations_async.Operations>`
           * 2018-06-01: :class:`Operations<azure.mgmt.network.v2018_06_01.aio.operations_async.Operations>`
           * 2018-07-01: :class:`Operations<azure.mgmt.network.v2018_07_01.aio.operations_async.Operations>`
           * 2018-08-01: :class:`Operations<azure.mgmt.network.v2018_08_01.aio.operations_async.Operations>`
           * 2018-10-01: :class:`Operations<azure.mgmt.network.v2018_10_01.aio.operations_async.Operations>`
           * 2018-11-01: :class:`Operations<azure.mgmt.network.v2018_11_01.aio.operations_async.Operations>`
           * 2018-12-01: :class:`Operations<azure.mgmt.network.v2018_12_01.aio.operations_async.Operations>`
           * 2019-02-01: :class:`Operations<azure.mgmt.network.v2019_02_01.aio.operations_async.Operations>`
           * 2019-04-01: :class:`Operations<azure.mgmt.network.v2019_04_01.aio.operations_async.Operations>`
           * 2019-06-01: :class:`Operations<azure.mgmt.network.v2019_06_01.aio.operations_async.Operations>`
           * 2019-07-01: :class:`Operations<azure.mgmt.network.v2019_07_01.aio.operations_async.Operations>`
           * 2019-08-01: :class:`Operations<azure.mgmt.network.v2019_08_01.aio.operations_async.Operations>`
           * 2019-09-01: :class:`Operations<azure.mgmt.network.v2019_09_01.aio.operations_async.Operations>`
           * 2019-11-01: :class:`Operations<azure.mgmt.network.v2019_11_01.aio.operations_async.Operations>`
           * 2019-12-01: :class:`Operations<azure.mgmt.network.v2019_12_01.aio.operations_async.Operations>`
           * 2020-03-01: :class:`Operations<azure.mgmt.network.v2020_03_01.aio.operations_async.Operations>`
           * 2020-04-01: :class:`Operations<azure.mgmt.network.v2020_04_01.aio.operations_async.Operations>`
        """
        api_version = self._get_api_version('operations')
        if api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import Operations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import Operations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def p2_svpn_gateways(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.P2SVpnGatewaysOperations>`
           * 2018-10-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.P2SVpnGatewaysOperations>`
           * 2018-11-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.P2SVpnGatewaysOperations>`
           * 2018-12-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.P2SVpnGatewaysOperations>`
           * 2019-02-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.P2SVpnGatewaysOperations>`
           * 2019-04-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.P2SVpnGatewaysOperations>`
           * 2019-06-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.P2SVpnGatewaysOperations>`
           * 2019-07-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.P2SVpnGatewaysOperations>`
           * 2019-08-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.P2SVpnGatewaysOperations>`
           * 2019-09-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.P2SVpnGatewaysOperations>`
           * 2019-11-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.P2SVpnGatewaysOperations>`
           * 2019-12-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.P2SVpnGatewaysOperations>`
           * 2020-03-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.P2SVpnGatewaysOperations>`
           * 2020-04-01: :class:`P2SVpnGatewaysOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.P2SVpnGatewaysOperations>`
        """
        api_version = self._get_api_version('p2_svpn_gateways')
        if api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import P2SVpnGatewaysOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import P2SVpnGatewaysOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def p2_svpn_server_configurations(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`P2SVpnServerConfigurationsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.P2SVpnServerConfigurationsOperations>`
           * 2018-10-01: :class:`P2SVpnServerConfigurationsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.P2SVpnServerConfigurationsOperations>`
           * 2018-11-01: :class:`P2SVpnServerConfigurationsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.P2SVpnServerConfigurationsOperations>`
           * 2018-12-01: :class:`P2SVpnServerConfigurationsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.P2SVpnServerConfigurationsOperations>`
           * 2019-02-01: :class:`P2SVpnServerConfigurationsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.P2SVpnServerConfigurationsOperations>`
           * 2019-04-01: :class:`P2SVpnServerConfigurationsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.P2SVpnServerConfigurationsOperations>`
           * 2019-06-01: :class:`P2SVpnServerConfigurationsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.P2SVpnServerConfigurationsOperations>`
           * 2019-07-01: :class:`P2SVpnServerConfigurationsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.P2SVpnServerConfigurationsOperations>`
        """
        api_version = self._get_api_version('p2_svpn_server_configurations')
        if api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import P2SVpnServerConfigurationsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import P2SVpnServerConfigurationsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import P2SVpnServerConfigurationsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import P2SVpnServerConfigurationsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import P2SVpnServerConfigurationsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import P2SVpnServerConfigurationsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import P2SVpnServerConfigurationsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import P2SVpnServerConfigurationsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def packet_captures(self):
        """Instance depends on the API version:

           * 2016-09-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.PacketCapturesOperations>`
           * 2016-12-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.PacketCapturesOperations>`
           * 2017-03-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.PacketCapturesOperations>`
           * 2017-06-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.PacketCapturesOperations>`
           * 2017-08-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.PacketCapturesOperations>`
           * 2017-09-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.PacketCapturesOperations>`
           * 2017-10-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.PacketCapturesOperations>`
           * 2017-11-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.PacketCapturesOperations>`
           * 2018-01-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.PacketCapturesOperations>`
           * 2018-02-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.PacketCapturesOperations>`
           * 2018-04-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.PacketCapturesOperations>`
           * 2018-06-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.PacketCapturesOperations>`
           * 2018-07-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.PacketCapturesOperations>`
           * 2018-08-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.PacketCapturesOperations>`
           * 2018-10-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.PacketCapturesOperations>`
           * 2018-11-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.PacketCapturesOperations>`
           * 2018-12-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.PacketCapturesOperations>`
           * 2019-02-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.PacketCapturesOperations>`
           * 2019-04-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.PacketCapturesOperations>`
           * 2019-06-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.PacketCapturesOperations>`
           * 2019-07-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.PacketCapturesOperations>`
           * 2019-08-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.PacketCapturesOperations>`
           * 2019-09-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.PacketCapturesOperations>`
           * 2019-11-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.PacketCapturesOperations>`
           * 2019-12-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.PacketCapturesOperations>`
           * 2020-03-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.PacketCapturesOperations>`
           * 2020-04-01: :class:`PacketCapturesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.PacketCapturesOperations>`
        """
        api_version = self._get_api_version('packet_captures')
        if api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import PacketCapturesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import PacketCapturesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def peer_express_route_circuit_connections(self):
        """Instance depends on the API version:

           * 2018-12-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.PeerExpressRouteCircuitConnectionsOperations>`
           * 2019-02-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.PeerExpressRouteCircuitConnectionsOperations>`
           * 2019-04-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.PeerExpressRouteCircuitConnectionsOperations>`
           * 2019-06-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.PeerExpressRouteCircuitConnectionsOperations>`
           * 2019-07-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.PeerExpressRouteCircuitConnectionsOperations>`
           * 2019-08-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.PeerExpressRouteCircuitConnectionsOperations>`
           * 2019-09-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.PeerExpressRouteCircuitConnectionsOperations>`
           * 2019-11-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.PeerExpressRouteCircuitConnectionsOperations>`
           * 2019-12-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.PeerExpressRouteCircuitConnectionsOperations>`
           * 2020-03-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.PeerExpressRouteCircuitConnectionsOperations>`
           * 2020-04-01: :class:`PeerExpressRouteCircuitConnectionsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.PeerExpressRouteCircuitConnectionsOperations>`
        """
        api_version = self._get_api_version('peer_express_route_circuit_connections')
        if api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import PeerExpressRouteCircuitConnectionsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def private_dns_zone_groups(self):
        """Instance depends on the API version:

           * 2020-03-01: :class:`PrivateDnsZoneGroupsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.PrivateDnsZoneGroupsOperations>`
           * 2020-04-01: :class:`PrivateDnsZoneGroupsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.PrivateDnsZoneGroupsOperations>`
        """
        api_version = self._get_api_version('private_dns_zone_groups')
        if api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import PrivateDnsZoneGroupsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import PrivateDnsZoneGroupsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def private_endpoints(self):
        """Instance depends on the API version:

           * 2019-04-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.PrivateEndpointsOperations>`
           * 2019-06-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.PrivateEndpointsOperations>`
           * 2019-07-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.PrivateEndpointsOperations>`
           * 2019-08-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.PrivateEndpointsOperations>`
           * 2019-09-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.PrivateEndpointsOperations>`
           * 2019-11-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.PrivateEndpointsOperations>`
           * 2019-12-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.PrivateEndpointsOperations>`
           * 2020-03-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.PrivateEndpointsOperations>`
           * 2020-04-01: :class:`PrivateEndpointsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.PrivateEndpointsOperations>`
        """
        api_version = self._get_api_version('private_endpoints')
        if api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import PrivateEndpointsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import PrivateEndpointsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import PrivateEndpointsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import PrivateEndpointsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import PrivateEndpointsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import PrivateEndpointsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import PrivateEndpointsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import PrivateEndpointsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import PrivateEndpointsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def private_link_services(self):
        """Instance depends on the API version:

           * 2019-04-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.PrivateLinkServicesOperations>`
           * 2019-06-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.PrivateLinkServicesOperations>`
           * 2019-07-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.PrivateLinkServicesOperations>`
           * 2019-08-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.PrivateLinkServicesOperations>`
           * 2019-09-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.PrivateLinkServicesOperations>`
           * 2019-11-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.PrivateLinkServicesOperations>`
           * 2019-12-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.PrivateLinkServicesOperations>`
           * 2020-03-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.PrivateLinkServicesOperations>`
           * 2020-04-01: :class:`PrivateLinkServicesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.PrivateLinkServicesOperations>`
        """
        api_version = self._get_api_version('private_link_services')
        if api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import PrivateLinkServicesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import PrivateLinkServicesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def public_ip_addresses(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2015_06_15.aio.operations_async.PublicIPAddressesOperations>`
           * 2016-09-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2016-12-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2017-03-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2017-06-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2017-08-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2017-09-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2017-10-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2017-11-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2018-01-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2018-02-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2018-04-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2018-06-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2018-07-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2018-08-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2018-10-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2018-11-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2018-12-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2019-02-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2019-04-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2019-06-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2019-07-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2019-08-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2019-09-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2019-11-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2019-12-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2020-03-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.PublicIPAddressesOperations>`
           * 2020-04-01: :class:`PublicIPAddressesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.PublicIPAddressesOperations>`
        """
        api_version = self._get_api_version('public_ip_addresses')
        if api_version == '2015-06-15':
            from ..v2015_06_15.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import PublicIPAddressesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def public_ip_prefixes(self):
        """Instance depends on the API version:

           * 2018-07-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.PublicIPPrefixesOperations>`
           * 2018-08-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.PublicIPPrefixesOperations>`
           * 2018-10-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.PublicIPPrefixesOperations>`
           * 2018-11-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.PublicIPPrefixesOperations>`
           * 2018-12-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.PublicIPPrefixesOperations>`
           * 2019-02-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.PublicIPPrefixesOperations>`
           * 2019-04-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.PublicIPPrefixesOperations>`
           * 2019-06-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.PublicIPPrefixesOperations>`
           * 2019-07-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.PublicIPPrefixesOperations>`
           * 2019-08-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.PublicIPPrefixesOperations>`
           * 2019-09-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.PublicIPPrefixesOperations>`
           * 2019-11-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.PublicIPPrefixesOperations>`
           * 2019-12-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.PublicIPPrefixesOperations>`
           * 2020-03-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.PublicIPPrefixesOperations>`
           * 2020-04-01: :class:`PublicIPPrefixesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.PublicIPPrefixesOperations>`
        """
        api_version = self._get_api_version('public_ip_prefixes')
        if api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import PublicIPPrefixesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import PublicIPPrefixesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def resource_navigation_links(self):
        """Instance depends on the API version:

           * 2019-02-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.ResourceNavigationLinksOperations>`
           * 2019-04-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ResourceNavigationLinksOperations>`
           * 2019-06-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ResourceNavigationLinksOperations>`
           * 2019-07-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ResourceNavigationLinksOperations>`
           * 2019-08-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ResourceNavigationLinksOperations>`
           * 2019-09-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ResourceNavigationLinksOperations>`
           * 2019-11-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ResourceNavigationLinksOperations>`
           * 2019-12-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ResourceNavigationLinksOperations>`
           * 2020-03-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ResourceNavigationLinksOperations>`
           * 2020-04-01: :class:`ResourceNavigationLinksOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ResourceNavigationLinksOperations>`
        """
        api_version = self._get_api_version('resource_navigation_links')
        if api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ResourceNavigationLinksOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ResourceNavigationLinksOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def route_filter_rules(self):
        """Instance depends on the API version:

           * 2016-12-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2017-03-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2017-06-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2017-08-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2017-09-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2017-10-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2017-11-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2018-01-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2018-02-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2018-04-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2018-06-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2018-07-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2018-08-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2018-10-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2018-11-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2018-12-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2019-02-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2019-04-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2019-06-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2019-07-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2019-08-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2019-09-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2019-11-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2019-12-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2020-03-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.RouteFilterRulesOperations>`
           * 2020-04-01: :class:`RouteFilterRulesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.RouteFilterRulesOperations>`
        """
        api_version = self._get_api_version('route_filter_rules')
        if api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import RouteFilterRulesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def route_filters(self):
        """Instance depends on the API version:

           * 2016-12-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.RouteFiltersOperations>`
           * 2017-03-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.RouteFiltersOperations>`
           * 2017-06-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.RouteFiltersOperations>`
           * 2017-08-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.RouteFiltersOperations>`
           * 2017-09-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.RouteFiltersOperations>`
           * 2017-10-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.RouteFiltersOperations>`
           * 2017-11-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.RouteFiltersOperations>`
           * 2018-01-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.RouteFiltersOperations>`
           * 2018-02-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.RouteFiltersOperations>`
           * 2018-04-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.RouteFiltersOperations>`
           * 2018-06-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.RouteFiltersOperations>`
           * 2018-07-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.RouteFiltersOperations>`
           * 2018-08-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.RouteFiltersOperations>`
           * 2018-10-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.RouteFiltersOperations>`
           * 2018-11-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.RouteFiltersOperations>`
           * 2018-12-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.RouteFiltersOperations>`
           * 2019-02-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.RouteFiltersOperations>`
           * 2019-04-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.RouteFiltersOperations>`
           * 2019-06-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.RouteFiltersOperations>`
           * 2019-07-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.RouteFiltersOperations>`
           * 2019-08-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.RouteFiltersOperations>`
           * 2019-09-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.RouteFiltersOperations>`
           * 2019-11-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.RouteFiltersOperations>`
           * 2019-12-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.RouteFiltersOperations>`
           * 2020-03-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.RouteFiltersOperations>`
           * 2020-04-01: :class:`RouteFiltersOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.RouteFiltersOperations>`
        """
        api_version = self._get_api_version('route_filters')
        if api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import RouteFiltersOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import RouteFiltersOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def route_tables(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`RouteTablesOperations<azure.mgmt.network.v2015_06_15.aio.operations_async.RouteTablesOperations>`
           * 2016-09-01: :class:`RouteTablesOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.RouteTablesOperations>`
           * 2016-12-01: :class:`RouteTablesOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.RouteTablesOperations>`
           * 2017-03-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.RouteTablesOperations>`
           * 2017-06-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.RouteTablesOperations>`
           * 2017-08-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.RouteTablesOperations>`
           * 2017-09-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.RouteTablesOperations>`
           * 2017-10-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.RouteTablesOperations>`
           * 2017-11-01: :class:`RouteTablesOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.RouteTablesOperations>`
           * 2018-01-01: :class:`RouteTablesOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.RouteTablesOperations>`
           * 2018-02-01: :class:`RouteTablesOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.RouteTablesOperations>`
           * 2018-04-01: :class:`RouteTablesOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.RouteTablesOperations>`
           * 2018-06-01: :class:`RouteTablesOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.RouteTablesOperations>`
           * 2018-07-01: :class:`RouteTablesOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.RouteTablesOperations>`
           * 2018-08-01: :class:`RouteTablesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.RouteTablesOperations>`
           * 2018-10-01: :class:`RouteTablesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.RouteTablesOperations>`
           * 2018-11-01: :class:`RouteTablesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.RouteTablesOperations>`
           * 2018-12-01: :class:`RouteTablesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.RouteTablesOperations>`
           * 2019-02-01: :class:`RouteTablesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.RouteTablesOperations>`
           * 2019-04-01: :class:`RouteTablesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.RouteTablesOperations>`
           * 2019-06-01: :class:`RouteTablesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.RouteTablesOperations>`
           * 2019-07-01: :class:`RouteTablesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.RouteTablesOperations>`
           * 2019-08-01: :class:`RouteTablesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.RouteTablesOperations>`
           * 2019-09-01: :class:`RouteTablesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.RouteTablesOperations>`
           * 2019-11-01: :class:`RouteTablesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.RouteTablesOperations>`
           * 2019-12-01: :class:`RouteTablesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.RouteTablesOperations>`
           * 2020-03-01: :class:`RouteTablesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.RouteTablesOperations>`
           * 2020-04-01: :class:`RouteTablesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.RouteTablesOperations>`
        """
        api_version = self._get_api_version('route_tables')
        if api_version == '2015-06-15':
            from ..v2015_06_15.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import RouteTablesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import RouteTablesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def routes(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`RoutesOperations<azure.mgmt.network.v2015_06_15.aio.operations_async.RoutesOperations>`
           * 2016-09-01: :class:`RoutesOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.RoutesOperations>`
           * 2016-12-01: :class:`RoutesOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.RoutesOperations>`
           * 2017-03-01: :class:`RoutesOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.RoutesOperations>`
           * 2017-06-01: :class:`RoutesOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.RoutesOperations>`
           * 2017-08-01: :class:`RoutesOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.RoutesOperations>`
           * 2017-09-01: :class:`RoutesOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.RoutesOperations>`
           * 2017-10-01: :class:`RoutesOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.RoutesOperations>`
           * 2017-11-01: :class:`RoutesOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.RoutesOperations>`
           * 2018-01-01: :class:`RoutesOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.RoutesOperations>`
           * 2018-02-01: :class:`RoutesOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.RoutesOperations>`
           * 2018-04-01: :class:`RoutesOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.RoutesOperations>`
           * 2018-06-01: :class:`RoutesOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.RoutesOperations>`
           * 2018-07-01: :class:`RoutesOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.RoutesOperations>`
           * 2018-08-01: :class:`RoutesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.RoutesOperations>`
           * 2018-10-01: :class:`RoutesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.RoutesOperations>`
           * 2018-11-01: :class:`RoutesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.RoutesOperations>`
           * 2018-12-01: :class:`RoutesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.RoutesOperations>`
           * 2019-02-01: :class:`RoutesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.RoutesOperations>`
           * 2019-04-01: :class:`RoutesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.RoutesOperations>`
           * 2019-06-01: :class:`RoutesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.RoutesOperations>`
           * 2019-07-01: :class:`RoutesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.RoutesOperations>`
           * 2019-08-01: :class:`RoutesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.RoutesOperations>`
           * 2019-09-01: :class:`RoutesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.RoutesOperations>`
           * 2019-11-01: :class:`RoutesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.RoutesOperations>`
           * 2019-12-01: :class:`RoutesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.RoutesOperations>`
           * 2020-03-01: :class:`RoutesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.RoutesOperations>`
           * 2020-04-01: :class:`RoutesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.RoutesOperations>`
        """
        api_version = self._get_api_version('routes')
        if api_version == '2015-06-15':
            from ..v2015_06_15.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import RoutesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import RoutesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def security_partner_providers(self):
        """Instance depends on the API version:

           * 2020-03-01: :class:`SecurityPartnerProvidersOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.SecurityPartnerProvidersOperations>`
           * 2020-04-01: :class:`SecurityPartnerProvidersOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.SecurityPartnerProvidersOperations>`
        """
        api_version = self._get_api_version('security_partner_providers')
        if api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import SecurityPartnerProvidersOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import SecurityPartnerProvidersOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def security_rules(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`SecurityRulesOperations<azure.mgmt.network.v2015_06_15.aio.operations_async.SecurityRulesOperations>`
           * 2016-09-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.SecurityRulesOperations>`
           * 2016-12-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.SecurityRulesOperations>`
           * 2017-03-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.SecurityRulesOperations>`
           * 2017-06-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.SecurityRulesOperations>`
           * 2017-08-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.SecurityRulesOperations>`
           * 2017-09-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.SecurityRulesOperations>`
           * 2017-10-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.SecurityRulesOperations>`
           * 2017-11-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.SecurityRulesOperations>`
           * 2018-01-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.SecurityRulesOperations>`
           * 2018-02-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.SecurityRulesOperations>`
           * 2018-04-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.SecurityRulesOperations>`
           * 2018-06-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.SecurityRulesOperations>`
           * 2018-07-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.SecurityRulesOperations>`
           * 2018-08-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.SecurityRulesOperations>`
           * 2018-10-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.SecurityRulesOperations>`
           * 2018-11-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.SecurityRulesOperations>`
           * 2018-12-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.SecurityRulesOperations>`
           * 2019-02-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.SecurityRulesOperations>`
           * 2019-04-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.SecurityRulesOperations>`
           * 2019-06-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.SecurityRulesOperations>`
           * 2019-07-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.SecurityRulesOperations>`
           * 2019-08-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.SecurityRulesOperations>`
           * 2019-09-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.SecurityRulesOperations>`
           * 2019-11-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.SecurityRulesOperations>`
           * 2019-12-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.SecurityRulesOperations>`
           * 2020-03-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.SecurityRulesOperations>`
           * 2020-04-01: :class:`SecurityRulesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.SecurityRulesOperations>`
        """
        api_version = self._get_api_version('security_rules')
        if api_version == '2015-06-15':
            from ..v2015_06_15.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import SecurityRulesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import SecurityRulesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def service_association_links(self):
        """Instance depends on the API version:

           * 2019-02-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.ServiceAssociationLinksOperations>`
           * 2019-04-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ServiceAssociationLinksOperations>`
           * 2019-06-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ServiceAssociationLinksOperations>`
           * 2019-07-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ServiceAssociationLinksOperations>`
           * 2019-08-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ServiceAssociationLinksOperations>`
           * 2019-09-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ServiceAssociationLinksOperations>`
           * 2019-11-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ServiceAssociationLinksOperations>`
           * 2019-12-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ServiceAssociationLinksOperations>`
           * 2020-03-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ServiceAssociationLinksOperations>`
           * 2020-04-01: :class:`ServiceAssociationLinksOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ServiceAssociationLinksOperations>`
        """
        api_version = self._get_api_version('service_association_links')
        if api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ServiceAssociationLinksOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ServiceAssociationLinksOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def service_endpoint_policies(self):
        """Instance depends on the API version:

           * 2018-07-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.ServiceEndpointPoliciesOperations>`
           * 2018-08-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.ServiceEndpointPoliciesOperations>`
           * 2018-10-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.ServiceEndpointPoliciesOperations>`
           * 2018-11-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.ServiceEndpointPoliciesOperations>`
           * 2018-12-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.ServiceEndpointPoliciesOperations>`
           * 2019-02-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.ServiceEndpointPoliciesOperations>`
           * 2019-04-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ServiceEndpointPoliciesOperations>`
           * 2019-06-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ServiceEndpointPoliciesOperations>`
           * 2019-07-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ServiceEndpointPoliciesOperations>`
           * 2019-08-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ServiceEndpointPoliciesOperations>`
           * 2019-09-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ServiceEndpointPoliciesOperations>`
           * 2019-11-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ServiceEndpointPoliciesOperations>`
           * 2019-12-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ServiceEndpointPoliciesOperations>`
           * 2020-03-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ServiceEndpointPoliciesOperations>`
           * 2020-04-01: :class:`ServiceEndpointPoliciesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ServiceEndpointPoliciesOperations>`
        """
        api_version = self._get_api_version('service_endpoint_policies')
        if api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ServiceEndpointPoliciesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ServiceEndpointPoliciesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def service_endpoint_policy_definitions(self):
        """Instance depends on the API version:

           * 2018-07-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.ServiceEndpointPolicyDefinitionsOperations>`
           * 2018-08-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.ServiceEndpointPolicyDefinitionsOperations>`
           * 2018-10-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.ServiceEndpointPolicyDefinitionsOperations>`
           * 2018-11-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.ServiceEndpointPolicyDefinitionsOperations>`
           * 2018-12-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.ServiceEndpointPolicyDefinitionsOperations>`
           * 2019-02-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.ServiceEndpointPolicyDefinitionsOperations>`
           * 2019-04-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ServiceEndpointPolicyDefinitionsOperations>`
           * 2019-06-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ServiceEndpointPolicyDefinitionsOperations>`
           * 2019-07-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ServiceEndpointPolicyDefinitionsOperations>`
           * 2019-08-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ServiceEndpointPolicyDefinitionsOperations>`
           * 2019-09-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ServiceEndpointPolicyDefinitionsOperations>`
           * 2019-11-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ServiceEndpointPolicyDefinitionsOperations>`
           * 2019-12-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ServiceEndpointPolicyDefinitionsOperations>`
           * 2020-03-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ServiceEndpointPolicyDefinitionsOperations>`
           * 2020-04-01: :class:`ServiceEndpointPolicyDefinitionsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ServiceEndpointPolicyDefinitionsOperations>`
        """
        api_version = self._get_api_version('service_endpoint_policy_definitions')
        if api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ServiceEndpointPolicyDefinitionsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def service_tags(self):
        """Instance depends on the API version:

           * 2019-04-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.ServiceTagsOperations>`
           * 2019-06-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.ServiceTagsOperations>`
           * 2019-07-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.ServiceTagsOperations>`
           * 2019-08-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.ServiceTagsOperations>`
           * 2019-09-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.ServiceTagsOperations>`
           * 2019-11-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.ServiceTagsOperations>`
           * 2019-12-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.ServiceTagsOperations>`
           * 2020-03-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.ServiceTagsOperations>`
           * 2020-04-01: :class:`ServiceTagsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.ServiceTagsOperations>`
        """
        api_version = self._get_api_version('service_tags')
        if api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import ServiceTagsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import ServiceTagsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import ServiceTagsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import ServiceTagsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import ServiceTagsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import ServiceTagsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import ServiceTagsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import ServiceTagsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import ServiceTagsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def subnets(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`SubnetsOperations<azure.mgmt.network.v2015_06_15.aio.operations_async.SubnetsOperations>`
           * 2016-09-01: :class:`SubnetsOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.SubnetsOperations>`
           * 2016-12-01: :class:`SubnetsOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.SubnetsOperations>`
           * 2017-03-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.SubnetsOperations>`
           * 2017-06-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.SubnetsOperations>`
           * 2017-08-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.SubnetsOperations>`
           * 2017-09-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.SubnetsOperations>`
           * 2017-10-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.SubnetsOperations>`
           * 2017-11-01: :class:`SubnetsOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.SubnetsOperations>`
           * 2018-01-01: :class:`SubnetsOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.SubnetsOperations>`
           * 2018-02-01: :class:`SubnetsOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.SubnetsOperations>`
           * 2018-04-01: :class:`SubnetsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.SubnetsOperations>`
           * 2018-06-01: :class:`SubnetsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.SubnetsOperations>`
           * 2018-07-01: :class:`SubnetsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.SubnetsOperations>`
           * 2018-08-01: :class:`SubnetsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.SubnetsOperations>`
           * 2018-10-01: :class:`SubnetsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.SubnetsOperations>`
           * 2018-11-01: :class:`SubnetsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.SubnetsOperations>`
           * 2018-12-01: :class:`SubnetsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.SubnetsOperations>`
           * 2019-02-01: :class:`SubnetsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.SubnetsOperations>`
           * 2019-04-01: :class:`SubnetsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.SubnetsOperations>`
           * 2019-06-01: :class:`SubnetsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.SubnetsOperations>`
           * 2019-07-01: :class:`SubnetsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.SubnetsOperations>`
           * 2019-08-01: :class:`SubnetsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.SubnetsOperations>`
           * 2019-09-01: :class:`SubnetsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.SubnetsOperations>`
           * 2019-11-01: :class:`SubnetsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.SubnetsOperations>`
           * 2019-12-01: :class:`SubnetsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.SubnetsOperations>`
           * 2020-03-01: :class:`SubnetsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.SubnetsOperations>`
           * 2020-04-01: :class:`SubnetsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.SubnetsOperations>`
        """
        api_version = self._get_api_version('subnets')
        if api_version == '2015-06-15':
            from ..v2015_06_15.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import SubnetsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import SubnetsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def usages(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`UsagesOperations<azure.mgmt.network.v2015_06_15.aio.operations_async.UsagesOperations>`
           * 2016-09-01: :class:`UsagesOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.UsagesOperations>`
           * 2016-12-01: :class:`UsagesOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.UsagesOperations>`
           * 2017-03-01: :class:`UsagesOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.UsagesOperations>`
           * 2017-06-01: :class:`UsagesOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.UsagesOperations>`
           * 2017-08-01: :class:`UsagesOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.UsagesOperations>`
           * 2017-09-01: :class:`UsagesOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.UsagesOperations>`
           * 2017-10-01: :class:`UsagesOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.UsagesOperations>`
           * 2017-11-01: :class:`UsagesOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.UsagesOperations>`
           * 2018-01-01: :class:`UsagesOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.UsagesOperations>`
           * 2018-02-01: :class:`UsagesOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.UsagesOperations>`
           * 2018-04-01: :class:`UsagesOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.UsagesOperations>`
           * 2018-06-01: :class:`UsagesOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.UsagesOperations>`
           * 2018-07-01: :class:`UsagesOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.UsagesOperations>`
           * 2018-08-01: :class:`UsagesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.UsagesOperations>`
           * 2018-10-01: :class:`UsagesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.UsagesOperations>`
           * 2018-11-01: :class:`UsagesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.UsagesOperations>`
           * 2018-12-01: :class:`UsagesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.UsagesOperations>`
           * 2019-02-01: :class:`UsagesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.UsagesOperations>`
           * 2019-04-01: :class:`UsagesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.UsagesOperations>`
           * 2019-06-01: :class:`UsagesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.UsagesOperations>`
           * 2019-07-01: :class:`UsagesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.UsagesOperations>`
           * 2019-08-01: :class:`UsagesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.UsagesOperations>`
           * 2019-09-01: :class:`UsagesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.UsagesOperations>`
           * 2019-11-01: :class:`UsagesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.UsagesOperations>`
           * 2019-12-01: :class:`UsagesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.UsagesOperations>`
           * 2020-03-01: :class:`UsagesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.UsagesOperations>`
           * 2020-04-01: :class:`UsagesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.UsagesOperations>`
        """
        api_version = self._get_api_version('usages')
        if api_version == '2015-06-15':
            from ..v2015_06_15.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import UsagesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import UsagesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_hub_route_table_v2_s(self):
        """Instance depends on the API version:

           * 2019-09-01: :class:`VirtualHubRouteTableV2SOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.VirtualHubRouteTableV2SOperations>`
           * 2019-11-01: :class:`VirtualHubRouteTableV2SOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.VirtualHubRouteTableV2SOperations>`
           * 2019-12-01: :class:`VirtualHubRouteTableV2SOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.VirtualHubRouteTableV2SOperations>`
           * 2020-03-01: :class:`VirtualHubRouteTableV2SOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.VirtualHubRouteTableV2SOperations>`
           * 2020-04-01: :class:`VirtualHubRouteTableV2SOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.VirtualHubRouteTableV2SOperations>`
        """
        api_version = self._get_api_version('virtual_hub_route_table_v2_s')
        if api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import VirtualHubRouteTableV2SOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import VirtualHubRouteTableV2SOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import VirtualHubRouteTableV2SOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import VirtualHubRouteTableV2SOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import VirtualHubRouteTableV2SOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_hubs(self):
        """Instance depends on the API version:

           * 2018-04-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.VirtualHubsOperations>`
           * 2018-06-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.VirtualHubsOperations>`
           * 2018-07-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.VirtualHubsOperations>`
           * 2018-08-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.VirtualHubsOperations>`
           * 2018-10-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.VirtualHubsOperations>`
           * 2018-11-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.VirtualHubsOperations>`
           * 2018-12-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.VirtualHubsOperations>`
           * 2019-02-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.VirtualHubsOperations>`
           * 2019-04-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.VirtualHubsOperations>`
           * 2019-06-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.VirtualHubsOperations>`
           * 2019-07-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.VirtualHubsOperations>`
           * 2019-08-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.VirtualHubsOperations>`
           * 2019-09-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.VirtualHubsOperations>`
           * 2019-11-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.VirtualHubsOperations>`
           * 2019-12-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.VirtualHubsOperations>`
           * 2020-03-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.VirtualHubsOperations>`
           * 2020-04-01: :class:`VirtualHubsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.VirtualHubsOperations>`
        """
        api_version = self._get_api_version('virtual_hubs')
        if api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import VirtualHubsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import VirtualHubsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import VirtualHubsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import VirtualHubsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import VirtualHubsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import VirtualHubsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import VirtualHubsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import VirtualHubsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import VirtualHubsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import VirtualHubsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import VirtualHubsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import VirtualHubsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import VirtualHubsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import VirtualHubsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import VirtualHubsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import VirtualHubsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import VirtualHubsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_network_gateway_connections(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2015_06_15.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2016-09-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2016-12-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-03-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-06-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-08-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-09-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-10-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2017-11-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2018-01-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2018-02-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2018-04-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2018-06-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2018-07-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2018-08-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2018-10-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2018-11-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2018-12-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2019-02-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2019-04-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2019-06-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2019-07-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2019-08-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2019-09-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2019-11-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2019-12-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2020-03-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
           * 2020-04-01: :class:`VirtualNetworkGatewayConnectionsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.VirtualNetworkGatewayConnectionsOperations>`
        """
        api_version = self._get_api_version('virtual_network_gateway_connections')
        if api_version == '2015-06-15':
            from ..v2015_06_15.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import VirtualNetworkGatewayConnectionsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_network_gateways(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2015_06_15.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2016-09-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2016-12-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2017-03-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2017-06-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2017-08-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2017-09-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2017-10-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2017-11-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2018-01-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2018-02-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2018-04-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2018-06-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2018-07-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2018-08-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2018-10-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2018-11-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2018-12-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2019-02-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2019-04-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2019-06-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2019-07-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2019-08-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2019-09-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2019-11-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2019-12-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2020-03-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
           * 2020-04-01: :class:`VirtualNetworkGatewaysOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.VirtualNetworkGatewaysOperations>`
        """
        api_version = self._get_api_version('virtual_network_gateways')
        if api_version == '2015-06-15':
            from ..v2015_06_15.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import VirtualNetworkGatewaysOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_network_peerings(self):
        """Instance depends on the API version:

           * 2016-09-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2016-12-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2017-03-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2017-06-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2017-08-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2017-09-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2017-10-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2017-11-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2018-01-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2018-02-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2018-04-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2018-06-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2018-07-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2018-08-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2018-10-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2018-11-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2018-12-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2019-02-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2019-04-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2019-06-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2019-07-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2019-08-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2019-09-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2019-11-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2019-12-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2020-03-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
           * 2020-04-01: :class:`VirtualNetworkPeeringsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.VirtualNetworkPeeringsOperations>`
        """
        api_version = self._get_api_version('virtual_network_peerings')
        if api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import VirtualNetworkPeeringsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_network_taps(self):
        """Instance depends on the API version:

           * 2018-08-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.VirtualNetworkTapsOperations>`
           * 2018-10-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.VirtualNetworkTapsOperations>`
           * 2018-11-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.VirtualNetworkTapsOperations>`
           * 2018-12-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.VirtualNetworkTapsOperations>`
           * 2019-02-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.VirtualNetworkTapsOperations>`
           * 2019-04-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.VirtualNetworkTapsOperations>`
           * 2019-06-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.VirtualNetworkTapsOperations>`
           * 2019-07-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.VirtualNetworkTapsOperations>`
           * 2019-08-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.VirtualNetworkTapsOperations>`
           * 2019-09-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.VirtualNetworkTapsOperations>`
           * 2019-11-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.VirtualNetworkTapsOperations>`
           * 2019-12-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.VirtualNetworkTapsOperations>`
           * 2020-03-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.VirtualNetworkTapsOperations>`
           * 2020-04-01: :class:`VirtualNetworkTapsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.VirtualNetworkTapsOperations>`
        """
        api_version = self._get_api_version('virtual_network_taps')
        if api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import VirtualNetworkTapsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import VirtualNetworkTapsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_networks(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`VirtualNetworksOperations<azure.mgmt.network.v2015_06_15.aio.operations_async.VirtualNetworksOperations>`
           * 2016-09-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2016_09_01.aio.operations_async.VirtualNetworksOperations>`
           * 2016-12-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2016_12_01.aio.operations_async.VirtualNetworksOperations>`
           * 2017-03-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_03_01.aio.operations_async.VirtualNetworksOperations>`
           * 2017-06-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_06_01.aio.operations_async.VirtualNetworksOperations>`
           * 2017-08-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_08_01.aio.operations_async.VirtualNetworksOperations>`
           * 2017-09-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_09_01.aio.operations_async.VirtualNetworksOperations>`
           * 2017-10-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_10_01.aio.operations_async.VirtualNetworksOperations>`
           * 2017-11-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2017_11_01.aio.operations_async.VirtualNetworksOperations>`
           * 2018-01-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2018_01_01.aio.operations_async.VirtualNetworksOperations>`
           * 2018-02-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2018_02_01.aio.operations_async.VirtualNetworksOperations>`
           * 2018-04-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.VirtualNetworksOperations>`
           * 2018-06-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.VirtualNetworksOperations>`
           * 2018-07-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.VirtualNetworksOperations>`
           * 2018-08-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.VirtualNetworksOperations>`
           * 2018-10-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.VirtualNetworksOperations>`
           * 2018-11-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.VirtualNetworksOperations>`
           * 2018-12-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.VirtualNetworksOperations>`
           * 2019-02-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.VirtualNetworksOperations>`
           * 2019-04-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.VirtualNetworksOperations>`
           * 2019-06-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.VirtualNetworksOperations>`
           * 2019-07-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.VirtualNetworksOperations>`
           * 2019-08-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.VirtualNetworksOperations>`
           * 2019-09-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.VirtualNetworksOperations>`
           * 2019-11-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.VirtualNetworksOperations>`
           * 2019-12-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.VirtualNetworksOperations>`
           * 2020-03-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.VirtualNetworksOperations>`
           * 2020-04-01: :class:`VirtualNetworksOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.VirtualNetworksOperations>`
        """
        api_version = self._get_api_version('virtual_networks')
        if api_version == '2015-06-15':
            from ..v2015_06_15.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2016-09-01':
            from ..v2016_09_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2016-12-01':
            from ..v2016_12_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2017-06-01':
            from ..v2017_06_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2017-08-01':
            from ..v2017_08_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2017-09-01':
            from ..v2017_09_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2017-11-01':
            from ..v2017_11_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2018-01-01':
            from ..v2018_01_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2018-02-01':
            from ..v2018_02_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import VirtualNetworksOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_router_peerings(self):
        """Instance depends on the API version:

           * 2019-07-01: :class:`VirtualRouterPeeringsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.VirtualRouterPeeringsOperations>`
           * 2019-08-01: :class:`VirtualRouterPeeringsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.VirtualRouterPeeringsOperations>`
           * 2019-09-01: :class:`VirtualRouterPeeringsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.VirtualRouterPeeringsOperations>`
           * 2019-11-01: :class:`VirtualRouterPeeringsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.VirtualRouterPeeringsOperations>`
           * 2019-12-01: :class:`VirtualRouterPeeringsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.VirtualRouterPeeringsOperations>`
           * 2020-03-01: :class:`VirtualRouterPeeringsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.VirtualRouterPeeringsOperations>`
           * 2020-04-01: :class:`VirtualRouterPeeringsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.VirtualRouterPeeringsOperations>`
        """
        api_version = self._get_api_version('virtual_router_peerings')
        if api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import VirtualRouterPeeringsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import VirtualRouterPeeringsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import VirtualRouterPeeringsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import VirtualRouterPeeringsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import VirtualRouterPeeringsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import VirtualRouterPeeringsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import VirtualRouterPeeringsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_routers(self):
        """Instance depends on the API version:

           * 2019-07-01: :class:`VirtualRoutersOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.VirtualRoutersOperations>`
           * 2019-08-01: :class:`VirtualRoutersOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.VirtualRoutersOperations>`
           * 2019-09-01: :class:`VirtualRoutersOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.VirtualRoutersOperations>`
           * 2019-11-01: :class:`VirtualRoutersOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.VirtualRoutersOperations>`
           * 2019-12-01: :class:`VirtualRoutersOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.VirtualRoutersOperations>`
           * 2020-03-01: :class:`VirtualRoutersOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.VirtualRoutersOperations>`
           * 2020-04-01: :class:`VirtualRoutersOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.VirtualRoutersOperations>`
        """
        api_version = self._get_api_version('virtual_routers')
        if api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import VirtualRoutersOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import VirtualRoutersOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import VirtualRoutersOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import VirtualRoutersOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import VirtualRoutersOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import VirtualRoutersOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import VirtualRoutersOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_wans(self):
        """Instance depends on the API version:

           * 2018-04-01: :class:`VirtualWANsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.VirtualWANsOperations>`
           * 2018-06-01: :class:`VirtualWANsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.VirtualWANsOperations>`
           * 2018-07-01: :class:`VirtualWANsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.VirtualWANsOperations>`
           * 2018-08-01: :class:`VirtualWansOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.VirtualWansOperations>`
           * 2018-10-01: :class:`VirtualWansOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.VirtualWansOperations>`
           * 2018-11-01: :class:`VirtualWansOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.VirtualWansOperations>`
           * 2018-12-01: :class:`VirtualWansOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.VirtualWansOperations>`
           * 2019-02-01: :class:`VirtualWansOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.VirtualWansOperations>`
           * 2019-04-01: :class:`VirtualWansOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.VirtualWansOperations>`
           * 2019-06-01: :class:`VirtualWansOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.VirtualWansOperations>`
           * 2019-07-01: :class:`VirtualWansOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.VirtualWansOperations>`
           * 2019-08-01: :class:`VirtualWansOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.VirtualWansOperations>`
           * 2019-09-01: :class:`VirtualWansOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.VirtualWansOperations>`
           * 2019-11-01: :class:`VirtualWansOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.VirtualWansOperations>`
           * 2019-12-01: :class:`VirtualWansOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.VirtualWansOperations>`
           * 2020-03-01: :class:`VirtualWansOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.VirtualWansOperations>`
           * 2020-04-01: :class:`VirtualWansOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.VirtualWansOperations>`
        """
        api_version = self._get_api_version('virtual_wans')
        if api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import VirtualWANsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import VirtualWANsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import VirtualWANsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import VirtualWansOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import VirtualWansOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import VirtualWansOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import VirtualWansOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import VirtualWansOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import VirtualWansOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import VirtualWansOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import VirtualWansOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import VirtualWansOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import VirtualWansOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import VirtualWansOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import VirtualWansOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import VirtualWansOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import VirtualWansOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def vpn_connections(self):
        """Instance depends on the API version:

           * 2018-04-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.VpnConnectionsOperations>`
           * 2018-06-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.VpnConnectionsOperations>`
           * 2018-07-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.VpnConnectionsOperations>`
           * 2018-08-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.VpnConnectionsOperations>`
           * 2018-10-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.VpnConnectionsOperations>`
           * 2018-11-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.VpnConnectionsOperations>`
           * 2018-12-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.VpnConnectionsOperations>`
           * 2019-02-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.VpnConnectionsOperations>`
           * 2019-04-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.VpnConnectionsOperations>`
           * 2019-06-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.VpnConnectionsOperations>`
           * 2019-07-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.VpnConnectionsOperations>`
           * 2019-08-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.VpnConnectionsOperations>`
           * 2019-09-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.VpnConnectionsOperations>`
           * 2019-11-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.VpnConnectionsOperations>`
           * 2019-12-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.VpnConnectionsOperations>`
           * 2020-03-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.VpnConnectionsOperations>`
           * 2020-04-01: :class:`VpnConnectionsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.VpnConnectionsOperations>`
        """
        api_version = self._get_api_version('vpn_connections')
        if api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import VpnConnectionsOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import VpnConnectionsOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import VpnConnectionsOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import VpnConnectionsOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import VpnConnectionsOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import VpnConnectionsOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import VpnConnectionsOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import VpnConnectionsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import VpnConnectionsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import VpnConnectionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import VpnConnectionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import VpnConnectionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import VpnConnectionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import VpnConnectionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import VpnConnectionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import VpnConnectionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import VpnConnectionsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def vpn_gateways(self):
        """Instance depends on the API version:

           * 2018-04-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.VpnGatewaysOperations>`
           * 2018-06-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.VpnGatewaysOperations>`
           * 2018-07-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.VpnGatewaysOperations>`
           * 2018-08-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.VpnGatewaysOperations>`
           * 2018-10-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.VpnGatewaysOperations>`
           * 2018-11-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.VpnGatewaysOperations>`
           * 2018-12-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.VpnGatewaysOperations>`
           * 2019-02-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.VpnGatewaysOperations>`
           * 2019-04-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.VpnGatewaysOperations>`
           * 2019-06-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.VpnGatewaysOperations>`
           * 2019-07-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.VpnGatewaysOperations>`
           * 2019-08-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.VpnGatewaysOperations>`
           * 2019-09-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.VpnGatewaysOperations>`
           * 2019-11-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.VpnGatewaysOperations>`
           * 2019-12-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.VpnGatewaysOperations>`
           * 2020-03-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.VpnGatewaysOperations>`
           * 2020-04-01: :class:`VpnGatewaysOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.VpnGatewaysOperations>`
        """
        api_version = self._get_api_version('vpn_gateways')
        if api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import VpnGatewaysOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import VpnGatewaysOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import VpnGatewaysOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import VpnGatewaysOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import VpnGatewaysOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import VpnGatewaysOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import VpnGatewaysOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import VpnGatewaysOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import VpnGatewaysOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import VpnGatewaysOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import VpnGatewaysOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import VpnGatewaysOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import VpnGatewaysOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import VpnGatewaysOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import VpnGatewaysOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import VpnGatewaysOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import VpnGatewaysOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def vpn_link_connections(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.VpnLinkConnectionsOperations>`
           * 2019-07-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.VpnLinkConnectionsOperations>`
           * 2019-08-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.VpnLinkConnectionsOperations>`
           * 2019-09-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.VpnLinkConnectionsOperations>`
           * 2019-11-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.VpnLinkConnectionsOperations>`
           * 2019-12-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.VpnLinkConnectionsOperations>`
           * 2020-03-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.VpnLinkConnectionsOperations>`
           * 2020-04-01: :class:`VpnLinkConnectionsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.VpnLinkConnectionsOperations>`
        """
        api_version = self._get_api_version('vpn_link_connections')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import VpnLinkConnectionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import VpnLinkConnectionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import VpnLinkConnectionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import VpnLinkConnectionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import VpnLinkConnectionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import VpnLinkConnectionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import VpnLinkConnectionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import VpnLinkConnectionsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def vpn_server_configurations(self):
        """Instance depends on the API version:

           * 2019-08-01: :class:`VpnServerConfigurationsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.VpnServerConfigurationsOperations>`
           * 2019-09-01: :class:`VpnServerConfigurationsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.VpnServerConfigurationsOperations>`
           * 2019-11-01: :class:`VpnServerConfigurationsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.VpnServerConfigurationsOperations>`
           * 2019-12-01: :class:`VpnServerConfigurationsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.VpnServerConfigurationsOperations>`
           * 2020-03-01: :class:`VpnServerConfigurationsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.VpnServerConfigurationsOperations>`
           * 2020-04-01: :class:`VpnServerConfigurationsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.VpnServerConfigurationsOperations>`
        """
        api_version = self._get_api_version('vpn_server_configurations')
        if api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import VpnServerConfigurationsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import VpnServerConfigurationsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import VpnServerConfigurationsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import VpnServerConfigurationsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import VpnServerConfigurationsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import VpnServerConfigurationsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def vpn_server_configurations_associated_with_virtual_wan(self):
        """Instance depends on the API version:

           * 2019-08-01: :class:`VpnServerConfigurationsAssociatedWithVirtualWanOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.VpnServerConfigurationsAssociatedWithVirtualWanOperations>`
           * 2019-09-01: :class:`VpnServerConfigurationsAssociatedWithVirtualWanOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.VpnServerConfigurationsAssociatedWithVirtualWanOperations>`
           * 2019-11-01: :class:`VpnServerConfigurationsAssociatedWithVirtualWanOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.VpnServerConfigurationsAssociatedWithVirtualWanOperations>`
           * 2019-12-01: :class:`VpnServerConfigurationsAssociatedWithVirtualWanOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.VpnServerConfigurationsAssociatedWithVirtualWanOperations>`
           * 2020-03-01: :class:`VpnServerConfigurationsAssociatedWithVirtualWanOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.VpnServerConfigurationsAssociatedWithVirtualWanOperations>`
           * 2020-04-01: :class:`VpnServerConfigurationsAssociatedWithVirtualWanOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.VpnServerConfigurationsAssociatedWithVirtualWanOperations>`
        """
        api_version = self._get_api_version('vpn_server_configurations_associated_with_virtual_wan')
        if api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import VpnServerConfigurationsAssociatedWithVirtualWanOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import VpnServerConfigurationsAssociatedWithVirtualWanOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import VpnServerConfigurationsAssociatedWithVirtualWanOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import VpnServerConfigurationsAssociatedWithVirtualWanOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import VpnServerConfigurationsAssociatedWithVirtualWanOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import VpnServerConfigurationsAssociatedWithVirtualWanOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def vpn_site_link_connections(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.VpnSiteLinkConnectionsOperations>`
           * 2019-07-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.VpnSiteLinkConnectionsOperations>`
           * 2019-08-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.VpnSiteLinkConnectionsOperations>`
           * 2019-09-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.VpnSiteLinkConnectionsOperations>`
           * 2019-11-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.VpnSiteLinkConnectionsOperations>`
           * 2019-12-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.VpnSiteLinkConnectionsOperations>`
           * 2020-03-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.VpnSiteLinkConnectionsOperations>`
           * 2020-04-01: :class:`VpnSiteLinkConnectionsOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.VpnSiteLinkConnectionsOperations>`
        """
        api_version = self._get_api_version('vpn_site_link_connections')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import VpnSiteLinkConnectionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import VpnSiteLinkConnectionsOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import VpnSiteLinkConnectionsOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import VpnSiteLinkConnectionsOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import VpnSiteLinkConnectionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import VpnSiteLinkConnectionsOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import VpnSiteLinkConnectionsOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import VpnSiteLinkConnectionsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def vpn_site_links(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.VpnSiteLinksOperations>`
           * 2019-07-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.VpnSiteLinksOperations>`
           * 2019-08-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.VpnSiteLinksOperations>`
           * 2019-09-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.VpnSiteLinksOperations>`
           * 2019-11-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.VpnSiteLinksOperations>`
           * 2019-12-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.VpnSiteLinksOperations>`
           * 2020-03-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.VpnSiteLinksOperations>`
           * 2020-04-01: :class:`VpnSiteLinksOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.VpnSiteLinksOperations>`
        """
        api_version = self._get_api_version('vpn_site_links')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import VpnSiteLinksOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import VpnSiteLinksOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import VpnSiteLinksOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import VpnSiteLinksOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import VpnSiteLinksOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import VpnSiteLinksOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import VpnSiteLinksOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import VpnSiteLinksOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def vpn_sites(self):
        """Instance depends on the API version:

           * 2018-04-01: :class:`VpnSitesOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.VpnSitesOperations>`
           * 2018-06-01: :class:`VpnSitesOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.VpnSitesOperations>`
           * 2018-07-01: :class:`VpnSitesOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.VpnSitesOperations>`
           * 2018-08-01: :class:`VpnSitesOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.VpnSitesOperations>`
           * 2018-10-01: :class:`VpnSitesOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.VpnSitesOperations>`
           * 2018-11-01: :class:`VpnSitesOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.VpnSitesOperations>`
           * 2018-12-01: :class:`VpnSitesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.VpnSitesOperations>`
           * 2019-02-01: :class:`VpnSitesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.VpnSitesOperations>`
           * 2019-04-01: :class:`VpnSitesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.VpnSitesOperations>`
           * 2019-06-01: :class:`VpnSitesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.VpnSitesOperations>`
           * 2019-07-01: :class:`VpnSitesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.VpnSitesOperations>`
           * 2019-08-01: :class:`VpnSitesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.VpnSitesOperations>`
           * 2019-09-01: :class:`VpnSitesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.VpnSitesOperations>`
           * 2019-11-01: :class:`VpnSitesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.VpnSitesOperations>`
           * 2019-12-01: :class:`VpnSitesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.VpnSitesOperations>`
           * 2020-03-01: :class:`VpnSitesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.VpnSitesOperations>`
           * 2020-04-01: :class:`VpnSitesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.VpnSitesOperations>`
        """
        api_version = self._get_api_version('vpn_sites')
        if api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import VpnSitesOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import VpnSitesOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import VpnSitesOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import VpnSitesOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import VpnSitesOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import VpnSitesOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import VpnSitesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import VpnSitesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import VpnSitesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import VpnSitesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import VpnSitesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import VpnSitesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import VpnSitesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import VpnSitesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import VpnSitesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import VpnSitesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import VpnSitesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def vpn_sites_configuration(self):
        """Instance depends on the API version:

           * 2018-04-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2018_04_01.aio.operations_async.VpnSitesConfigurationOperations>`
           * 2018-06-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2018_06_01.aio.operations_async.VpnSitesConfigurationOperations>`
           * 2018-07-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2018_07_01.aio.operations_async.VpnSitesConfigurationOperations>`
           * 2018-08-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2018_08_01.aio.operations_async.VpnSitesConfigurationOperations>`
           * 2018-10-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2018_10_01.aio.operations_async.VpnSitesConfigurationOperations>`
           * 2018-11-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2018_11_01.aio.operations_async.VpnSitesConfigurationOperations>`
           * 2018-12-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.VpnSitesConfigurationOperations>`
           * 2019-02-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.VpnSitesConfigurationOperations>`
           * 2019-04-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.VpnSitesConfigurationOperations>`
           * 2019-06-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.VpnSitesConfigurationOperations>`
           * 2019-07-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.VpnSitesConfigurationOperations>`
           * 2019-08-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.VpnSitesConfigurationOperations>`
           * 2019-09-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.VpnSitesConfigurationOperations>`
           * 2019-11-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.VpnSitesConfigurationOperations>`
           * 2019-12-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.VpnSitesConfigurationOperations>`
           * 2020-03-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.VpnSitesConfigurationOperations>`
           * 2020-04-01: :class:`VpnSitesConfigurationOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.VpnSitesConfigurationOperations>`
        """
        api_version = self._get_api_version('vpn_sites_configuration')
        if api_version == '2018-04-01':
            from ..v2018_04_01.aio.operations_async import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2018-06-01':
            from ..v2018_06_01.aio.operations_async import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2018-07-01':
            from ..v2018_07_01.aio.operations_async import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2018-08-01':
            from ..v2018_08_01.aio.operations_async import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2018-10-01':
            from ..v2018_10_01.aio.operations_async import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2018-11-01':
            from ..v2018_11_01.aio.operations_async import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import VpnSitesConfigurationOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import VpnSitesConfigurationOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def web_application_firewall_policies(self):
        """Instance depends on the API version:

           * 2018-12-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2018_12_01.aio.operations_async.WebApplicationFirewallPoliciesOperations>`
           * 2019-02-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2019_02_01.aio.operations_async.WebApplicationFirewallPoliciesOperations>`
           * 2019-04-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2019_04_01.aio.operations_async.WebApplicationFirewallPoliciesOperations>`
           * 2019-06-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2019_06_01.aio.operations_async.WebApplicationFirewallPoliciesOperations>`
           * 2019-07-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2019_07_01.aio.operations_async.WebApplicationFirewallPoliciesOperations>`
           * 2019-08-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2019_08_01.aio.operations_async.WebApplicationFirewallPoliciesOperations>`
           * 2019-09-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2019_09_01.aio.operations_async.WebApplicationFirewallPoliciesOperations>`
           * 2019-11-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2019_11_01.aio.operations_async.WebApplicationFirewallPoliciesOperations>`
           * 2019-12-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2019_12_01.aio.operations_async.WebApplicationFirewallPoliciesOperations>`
           * 2020-03-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2020_03_01.aio.operations_async.WebApplicationFirewallPoliciesOperations>`
           * 2020-04-01: :class:`WebApplicationFirewallPoliciesOperations<azure.mgmt.network.v2020_04_01.aio.operations_async.WebApplicationFirewallPoliciesOperations>`
        """
        api_version = self._get_api_version('web_application_firewall_policies')
        if api_version == '2018-12-01':
            from ..v2018_12_01.aio.operations_async import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2019-02-01':
            from ..v2019_02_01.aio.operations_async import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations_async import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations_async import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2019-07-01':
            from ..v2019_07_01.aio.operations_async import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2019-08-01':
            from ..v2019_08_01.aio.operations_async import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2019-09-01':
            from ..v2019_09_01.aio.operations_async import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2019-11-01':
            from ..v2019_11_01.aio.operations_async import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2019-12-01':
            from ..v2019_12_01.aio.operations_async import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2020-03-01':
            from ..v2020_03_01.aio.operations_async import WebApplicationFirewallPoliciesOperations as OperationClass
        elif api_version == '2020-04-01':
            from ..v2020_04_01.aio.operations_async import WebApplicationFirewallPoliciesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    async def close(self):
        await self._client.close()
    async def __aenter__(self):
        await self._client.__aenter__()
        return self
    async def __aexit__(self, *exc_details):
        await self._client.__aexit__(*exc_details)
