# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._service_fabric_managed_clusters_management_client_enums import *


class ScalingMechanism(msrest.serialization.Model):
    """Describes the mechanism for performing a scaling operation.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AddRemoveIncrementalNamedPartitionScalingMechanism, PartitionInstanceCountScaleMechanism.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Specifies the mechanism associated with this scaling policy.Constant
     filled by server.  Possible values include: "ScalePartitionInstanceCount",
     "AddRemoveIncrementalNamedPartition".
    :type kind: str or
     ~service_fabric_managed_clusters_management_client.models.ServiceScalingMechanismKind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'AddRemoveIncrementalNamedPartition': 'AddRemoveIncrementalNamedPartitionScalingMechanism', 'ScalePartitionInstanceCount': 'PartitionInstanceCountScaleMechanism'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScalingMechanism, self).__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class AddRemoveIncrementalNamedPartitionScalingMechanism(ScalingMechanism):
    """Represents a scaling mechanism for adding or removing named partitions of a stateless service. Partition names are in the format '0','1'...'N-1'.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Specifies the mechanism associated with this scaling policy.Constant
     filled by server.  Possible values include: "ScalePartitionInstanceCount",
     "AddRemoveIncrementalNamedPartition".
    :type kind: str or
     ~service_fabric_managed_clusters_management_client.models.ServiceScalingMechanismKind
    :param min_partition_count: Required. Minimum number of named partitions of the service.
    :type min_partition_count: int
    :param max_partition_count: Required. Maximum number of named partitions of the service.
    :type max_partition_count: int
    :param scale_increment: Required. The number of instances to add or remove during a scaling
     operation.
    :type scale_increment: int
    """

    _validation = {
        'kind': {'required': True},
        'min_partition_count': {'required': True},
        'max_partition_count': {'required': True},
        'scale_increment': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'min_partition_count': {'key': 'minPartitionCount', 'type': 'int'},
        'max_partition_count': {'key': 'maxPartitionCount', 'type': 'int'},
        'scale_increment': {'key': 'scaleIncrement', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        min_partition_count: int,
        max_partition_count: int,
        scale_increment: int,
        **kwargs
    ):
        super(AddRemoveIncrementalNamedPartitionScalingMechanism, self).__init__(**kwargs)
        self.kind = 'AddRemoveIncrementalNamedPartition'  # type: str
        self.min_partition_count = min_partition_count
        self.max_partition_count = max_partition_count
        self.scale_increment = scale_increment


class ApplicationHealthPolicy(msrest.serialization.Model):
    """Defines a health policy used to evaluate the health of an application or one of its children entities.

    All required parameters must be populated in order to send to Azure.

    :param consider_warning_as_error: Required. Indicates whether warnings are treated with the
     same severity as errors.
    :type consider_warning_as_error: bool
    :param max_percent_unhealthy_deployed_applications: Required. The maximum allowed percentage of
     unhealthy deployed applications. Allowed values are Byte values from zero to 100.
     The percentage represents the maximum tolerated percentage of deployed applications that can
     be unhealthy before the application is considered in error.
     This is calculated by dividing the number of unhealthy deployed applications over the number
     of nodes where the application is currently deployed on in the cluster.
     The computation rounds up to tolerate one failure on small numbers of nodes. Default
     percentage is zero.
    :type max_percent_unhealthy_deployed_applications: int
    :param default_service_type_health_policy: The health policy used by default to evaluate the
     health of a service type.
    :type default_service_type_health_policy:
     ~service_fabric_managed_clusters_management_client.models.ServiceTypeHealthPolicy
    :param service_type_health_policy_map: The map with service type health policy per service type
     name. The map is empty by default.
    :type service_type_health_policy_map: dict[str,
     ~service_fabric_managed_clusters_management_client.models.ServiceTypeHealthPolicy]
    """

    _validation = {
        'consider_warning_as_error': {'required': True},
        'max_percent_unhealthy_deployed_applications': {'required': True},
    }

    _attribute_map = {
        'consider_warning_as_error': {'key': 'considerWarningAsError', 'type': 'bool'},
        'max_percent_unhealthy_deployed_applications': {'key': 'maxPercentUnhealthyDeployedApplications', 'type': 'int'},
        'default_service_type_health_policy': {'key': 'defaultServiceTypeHealthPolicy', 'type': 'ServiceTypeHealthPolicy'},
        'service_type_health_policy_map': {'key': 'serviceTypeHealthPolicyMap', 'type': '{ServiceTypeHealthPolicy}'},
    }

    def __init__(
        self,
        *,
        consider_warning_as_error: bool,
        max_percent_unhealthy_deployed_applications: int,
        default_service_type_health_policy: Optional["ServiceTypeHealthPolicy"] = None,
        service_type_health_policy_map: Optional[Dict[str, "ServiceTypeHealthPolicy"]] = None,
        **kwargs
    ):
        super(ApplicationHealthPolicy, self).__init__(**kwargs)
        self.consider_warning_as_error = consider_warning_as_error
        self.max_percent_unhealthy_deployed_applications = max_percent_unhealthy_deployed_applications
        self.default_service_type_health_policy = default_service_type_health_policy
        self.service_type_health_policy_map = service_type_health_policy_map


class ProxyResource(msrest.serialization.Model):
    """The resource model definition for proxy-only resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Resource location depends on the parent resource.
    :type location: str
    :param tags: A set of tags. Azure resource tags.
    :type tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~service_fabric_managed_clusters_management_client.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.system_data = None


class ApplicationResource(ProxyResource):
    """The application resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Resource location depends on the parent resource.
    :type location: str
    :param tags: A set of tags. Azure resource tags.
    :type tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~service_fabric_managed_clusters_management_client.models.SystemData
    :param identity: Describes the managed identities for an Azure resource.
    :type identity: ~service_fabric_managed_clusters_management_client.models.ManagedIdentity
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param version: The version of the application type as defined in the application manifest.
     This name must be the full Arm Resource ID for the referenced application type version.
    :type version: str
    :param parameters: List of application parameters with overridden values from their default
     values specified in the application manifest.
    :type parameters: dict[str, str]
    :param upgrade_policy: Describes the policy for a monitored application upgrade.
    :type upgrade_policy:
     ~service_fabric_managed_clusters_management_client.models.ApplicationUpgradePolicy
    :param managed_identities: List of user assigned identities for the application, each mapped to
     a friendly name.
    :type managed_identities:
     list[~service_fabric_managed_clusters_management_client.models.ApplicationUserAssignedIdentity]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'identity': {'key': 'identity', 'type': 'ManagedIdentity'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': '{str}'},
        'upgrade_policy': {'key': 'properties.upgradePolicy', 'type': 'ApplicationUpgradePolicy'},
        'managed_identities': {'key': 'properties.managedIdentities', 'type': '[ApplicationUserAssignedIdentity]'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ManagedIdentity"] = None,
        version: Optional[str] = None,
        parameters: Optional[Dict[str, str]] = None,
        upgrade_policy: Optional["ApplicationUpgradePolicy"] = None,
        managed_identities: Optional[List["ApplicationUserAssignedIdentity"]] = None,
        **kwargs
    ):
        super(ApplicationResource, self).__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.provisioning_state = None
        self.version = version
        self.parameters = parameters
        self.upgrade_policy = upgrade_policy
        self.managed_identities = managed_identities


class ApplicationResourceList(msrest.serialization.Model):
    """The list of application resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value:
    :type value:
     list[~service_fabric_managed_clusters_management_client.models.ApplicationResource]
    :ivar next_link: URL to get the next set of application list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ApplicationResource"]] = None,
        **kwargs
    ):
        super(ApplicationResourceList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ApplicationTypeResource(ProxyResource):
    """The application type name resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Resource location depends on the parent resource.
    :type location: str
    :param tags: A set of tags. Azure resource tags.
    :type tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~service_fabric_managed_clusters_management_client.models.SystemData
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ApplicationTypeResource, self).__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None


class ApplicationTypeResourceList(msrest.serialization.Model):
    """The list of application type names.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value:
    :type value:
     list[~service_fabric_managed_clusters_management_client.models.ApplicationTypeResource]
    :ivar next_link: URL to get the next set of application type list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationTypeResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ApplicationTypeResource"]] = None,
        **kwargs
    ):
        super(ApplicationTypeResourceList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ApplicationTypeUpdateParameters(msrest.serialization.Model):
    """Application type update request.

    :param tags: A set of tags. Application type update parameters.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ApplicationTypeUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class ApplicationTypeVersionResource(ProxyResource):
    """An application type version resource for the specified application type name resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Resource location depends on the parent resource.
    :type location: str
    :param tags: A set of tags. Azure resource tags.
    :type tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~service_fabric_managed_clusters_management_client.models.SystemData
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param app_package_url: The URL to the application package.
    :type app_package_url: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'app_package_url': {'key': 'properties.appPackageUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        app_package_url: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationTypeVersionResource, self).__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.app_package_url = app_package_url


class ApplicationTypeVersionResourceList(msrest.serialization.Model):
    """The list of application type version resources for the specified application type name resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value:
    :type value:
     list[~service_fabric_managed_clusters_management_client.models.ApplicationTypeVersionResource]
    :ivar next_link: URL to get the next set of application type version list results if there are
     any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationTypeVersionResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ApplicationTypeVersionResource"]] = None,
        **kwargs
    ):
        super(ApplicationTypeVersionResourceList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ApplicationTypeVersionsCleanupPolicy(msrest.serialization.Model):
    """The policy used to clean up unused versions.

    All required parameters must be populated in order to send to Azure.

    :param max_unused_versions_to_keep: Required. Number of unused versions per application type to
     keep.
    :type max_unused_versions_to_keep: int
    """

    _validation = {
        'max_unused_versions_to_keep': {'required': True, 'minimum': 0},
    }

    _attribute_map = {
        'max_unused_versions_to_keep': {'key': 'maxUnusedVersionsToKeep', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        max_unused_versions_to_keep: int,
        **kwargs
    ):
        super(ApplicationTypeVersionsCleanupPolicy, self).__init__(**kwargs)
        self.max_unused_versions_to_keep = max_unused_versions_to_keep


class ApplicationTypeVersionUpdateParameters(msrest.serialization.Model):
    """Application type version update request.

    :param tags: A set of tags. Application type version update parameters.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ApplicationTypeVersionUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class ApplicationUpdateParameters(msrest.serialization.Model):
    """Application update request.

    :param tags: A set of tags. Application update parameters.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ApplicationUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class ApplicationUpgradePolicy(msrest.serialization.Model):
    """Describes the policy for a monitored application upgrade.

    :param application_health_policy: Defines a health policy used to evaluate the health of an
     application or one of its children entities.
    :type application_health_policy:
     ~service_fabric_managed_clusters_management_client.models.ApplicationHealthPolicy
    :param force_restart: If true, then processes are forcefully restarted during upgrade even when
     the code version has not changed (the upgrade only changes configuration or data).
    :type force_restart: bool
    :param rolling_upgrade_monitoring_policy: The policy used for monitoring the application
     upgrade.
    :type rolling_upgrade_monitoring_policy:
     ~service_fabric_managed_clusters_management_client.models.RollingUpgradeMonitoringPolicy
    :param instance_close_delay_duration: Duration in seconds, to wait before a stateless instance
     is closed, to allow the active requests to drain gracefully. This would be effective when the
     instance is closing during the application/cluster upgrade, only for those instances which have
     a non-zero delay duration configured in the service description. See
     InstanceCloseDelayDurationSeconds property in StatelessServiceDescription for details. Note,
     the default value of InstanceCloseDelayDurationInSeconds is 4294967295, which indicates that
     the behavior will entirely depend on the delay configured in the stateless service description.
    :type instance_close_delay_duration: long
    :param upgrade_mode: The mode used to monitor health during a rolling upgrade. The values are
     Monitored, and UnmonitoredAuto. Possible values include: "Monitored", "UnmonitoredAuto".
    :type upgrade_mode: str or
     ~service_fabric_managed_clusters_management_client.models.RollingUpgradeMode
    :param upgrade_replica_set_check_timeout: The maximum amount of time to block processing of an
     upgrade domain and prevent loss of availability when there are unexpected issues. When this
     timeout expires, processing of the upgrade domain will proceed regardless of availability loss
     issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0
     and 42949672925 inclusive. (unsigned 32-bit integer).
    :type upgrade_replica_set_check_timeout: long
    :param recreate_application: Determines whether the application should be recreated on update.
     If value=true, the rest of the upgrade policy parameters are not allowed.
    :type recreate_application: bool
    """

    _attribute_map = {
        'application_health_policy': {'key': 'applicationHealthPolicy', 'type': 'ApplicationHealthPolicy'},
        'force_restart': {'key': 'forceRestart', 'type': 'bool'},
        'rolling_upgrade_monitoring_policy': {'key': 'rollingUpgradeMonitoringPolicy', 'type': 'RollingUpgradeMonitoringPolicy'},
        'instance_close_delay_duration': {'key': 'instanceCloseDelayDuration', 'type': 'long'},
        'upgrade_mode': {'key': 'upgradeMode', 'type': 'str'},
        'upgrade_replica_set_check_timeout': {'key': 'upgradeReplicaSetCheckTimeout', 'type': 'long'},
        'recreate_application': {'key': 'recreateApplication', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        application_health_policy: Optional["ApplicationHealthPolicy"] = None,
        force_restart: Optional[bool] = False,
        rolling_upgrade_monitoring_policy: Optional["RollingUpgradeMonitoringPolicy"] = None,
        instance_close_delay_duration: Optional[int] = None,
        upgrade_mode: Optional[Union[str, "RollingUpgradeMode"]] = None,
        upgrade_replica_set_check_timeout: Optional[int] = None,
        recreate_application: Optional[bool] = None,
        **kwargs
    ):
        super(ApplicationUpgradePolicy, self).__init__(**kwargs)
        self.application_health_policy = application_health_policy
        self.force_restart = force_restart
        self.rolling_upgrade_monitoring_policy = rolling_upgrade_monitoring_policy
        self.instance_close_delay_duration = instance_close_delay_duration
        self.upgrade_mode = upgrade_mode
        self.upgrade_replica_set_check_timeout = upgrade_replica_set_check_timeout
        self.recreate_application = recreate_application


class ApplicationUserAssignedIdentity(msrest.serialization.Model):
    """ApplicationUserAssignedIdentity.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The friendly name of user assigned identity.
    :type name: str
    :param principal_id: Required. The principal id of user assigned identity.
    :type principal_id: str
    """

    _validation = {
        'name': {'required': True},
        'principal_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        principal_id: str,
        **kwargs
    ):
        super(ApplicationUserAssignedIdentity, self).__init__(**kwargs)
        self.name = name
        self.principal_id = principal_id


class AvailableOperationDisplay(msrest.serialization.Model):
    """Operation supported by the Service Fabric resource provider.

    :param provider: The name of the provider.
    :type provider: str
    :param resource: The resource on which the operation is performed.
    :type resource: str
    :param operation: The operation that can be performed.
    :type operation: str
    :param description: Operation description.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(AvailableOperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ScalingTrigger(msrest.serialization.Model):
    """Describes the trigger for performing a scaling operation.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AveragePartitionLoadScalingTrigger, AverageServiceLoadScalingTrigger.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Specifies the trigger associated with this scaling policy.Constant
     filled by server.  Possible values include: "AveragePartitionLoad", "AverageServiceLoad".
    :type kind: str or
     ~service_fabric_managed_clusters_management_client.models.ServiceScalingTriggerKind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'AveragePartitionLoadTrigger': 'AveragePartitionLoadScalingTrigger', 'AverageServiceLoadTrigger': 'AverageServiceLoadScalingTrigger'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScalingTrigger, self).__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class AveragePartitionLoadScalingTrigger(ScalingTrigger):
    """Represents a scaling trigger related to an average load of a metric/resource of a partition.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Specifies the trigger associated with this scaling policy.Constant
     filled by server.  Possible values include: "AveragePartitionLoad", "AverageServiceLoad".
    :type kind: str or
     ~service_fabric_managed_clusters_management_client.models.ServiceScalingTriggerKind
    :param metric_name: Required. The name of the metric for which usage should be tracked.
    :type metric_name: str
    :param lower_load_threshold: Required. The lower limit of the load below which a scale in
     operation should be performed.
    :type lower_load_threshold: float
    :param upper_load_threshold: Required. The upper limit of the load beyond which a scale out
     operation should be performed.
    :type upper_load_threshold: float
    :param scale_interval: Required. The period in seconds on which a decision is made whether to
     scale or not. This property should come in ISO 8601 format "hh:mm:ss".
    :type scale_interval: str
    """

    _validation = {
        'kind': {'required': True},
        'metric_name': {'required': True},
        'lower_load_threshold': {'required': True},
        'upper_load_threshold': {'required': True},
        'scale_interval': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'metric_name': {'key': 'metricName', 'type': 'str'},
        'lower_load_threshold': {'key': 'lowerLoadThreshold', 'type': 'float'},
        'upper_load_threshold': {'key': 'upperLoadThreshold', 'type': 'float'},
        'scale_interval': {'key': 'scaleInterval', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        metric_name: str,
        lower_load_threshold: float,
        upper_load_threshold: float,
        scale_interval: str,
        **kwargs
    ):
        super(AveragePartitionLoadScalingTrigger, self).__init__(**kwargs)
        self.kind = 'AveragePartitionLoadTrigger'  # type: str
        self.metric_name = metric_name
        self.lower_load_threshold = lower_load_threshold
        self.upper_load_threshold = upper_load_threshold
        self.scale_interval = scale_interval


class AverageServiceLoadScalingTrigger(ScalingTrigger):
    """Represents a scaling policy related to an average load of a metric/resource of a service.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Specifies the trigger associated with this scaling policy.Constant
     filled by server.  Possible values include: "AveragePartitionLoad", "AverageServiceLoad".
    :type kind: str or
     ~service_fabric_managed_clusters_management_client.models.ServiceScalingTriggerKind
    :param metric_name: Required. The name of the metric for which usage should be tracked.
    :type metric_name: str
    :param lower_load_threshold: Required. The lower limit of the load below which a scale in
     operation should be performed.
    :type lower_load_threshold: float
    :param upper_load_threshold: Required. The upper limit of the load beyond which a scale out
     operation should be performed.
    :type upper_load_threshold: float
    :param scale_interval: Required. The period in seconds on which a decision is made whether to
     scale or not. This property should come in ISO 8601 format "hh:mm:ss".
    :type scale_interval: str
    """

    _validation = {
        'kind': {'required': True},
        'metric_name': {'required': True},
        'lower_load_threshold': {'required': True},
        'upper_load_threshold': {'required': True},
        'scale_interval': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'metric_name': {'key': 'metricName', 'type': 'str'},
        'lower_load_threshold': {'key': 'lowerLoadThreshold', 'type': 'float'},
        'upper_load_threshold': {'key': 'upperLoadThreshold', 'type': 'float'},
        'scale_interval': {'key': 'scaleInterval', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        metric_name: str,
        lower_load_threshold: float,
        upper_load_threshold: float,
        scale_interval: str,
        **kwargs
    ):
        super(AverageServiceLoadScalingTrigger, self).__init__(**kwargs)
        self.kind = 'AverageServiceLoadTrigger'  # type: str
        self.metric_name = metric_name
        self.lower_load_threshold = lower_load_threshold
        self.upper_load_threshold = upper_load_threshold
        self.scale_interval = scale_interval


class AzureActiveDirectory(msrest.serialization.Model):
    """The settings to enable AAD authentication on the cluster.

    :param tenant_id: Azure active directory tenant id.
    :type tenant_id: str
    :param cluster_application: Azure active directory cluster application id.
    :type cluster_application: str
    :param client_application: Azure active directory client application id.
    :type client_application: str
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'cluster_application': {'key': 'clusterApplication', 'type': 'str'},
        'client_application': {'key': 'clientApplication', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        cluster_application: Optional[str] = None,
        client_application: Optional[str] = None,
        **kwargs
    ):
        super(AzureActiveDirectory, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.cluster_application = cluster_application
        self.client_application = client_application


class ClientCertificate(msrest.serialization.Model):
    """Client certificate definition.

    All required parameters must be populated in order to send to Azure.

    :param is_admin: Required. Indicates if the client certificate has admin access to the cluster.
     Non admin clients can perform only read only operations on the cluster.
    :type is_admin: bool
    :param thumbprint: Certificate thumbprint.
    :type thumbprint: str
    :param common_name: Certificate common name.
    :type common_name: str
    :param issuer_thumbprint: Issuer thumbprint for the certificate. Only used together with
     CommonName.
    :type issuer_thumbprint: str
    """

    _validation = {
        'is_admin': {'required': True},
    }

    _attribute_map = {
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'common_name': {'key': 'commonName', 'type': 'str'},
        'issuer_thumbprint': {'key': 'issuerThumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        is_admin: bool,
        thumbprint: Optional[str] = None,
        common_name: Optional[str] = None,
        issuer_thumbprint: Optional[str] = None,
        **kwargs
    ):
        super(ClientCertificate, self).__init__(**kwargs)
        self.is_admin = is_admin
        self.thumbprint = thumbprint
        self.common_name = common_name
        self.issuer_thumbprint = issuer_thumbprint


class EndpointRangeDescription(msrest.serialization.Model):
    """Port range details.

    All required parameters must be populated in order to send to Azure.

    :param start_port: Required. Starting port of a range of ports.
    :type start_port: int
    :param end_port: Required. End port of a range of ports.
    :type end_port: int
    """

    _validation = {
        'start_port': {'required': True},
        'end_port': {'required': True},
    }

    _attribute_map = {
        'start_port': {'key': 'startPort', 'type': 'int'},
        'end_port': {'key': 'endPort', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        start_port: int,
        end_port: int,
        **kwargs
    ):
        super(EndpointRangeDescription, self).__init__(**kwargs)
        self.start_port = start_port
        self.end_port = end_port


class ErrorModel(msrest.serialization.Model):
    """The structure of the error.

    :param error: The error details.
    :type error: ~service_fabric_managed_clusters_management_client.models.ErrorModelError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorModelError'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorModelError"] = None,
        **kwargs
    ):
        super(ErrorModel, self).__init__(**kwargs)
        self.error = error


class ErrorModelError(msrest.serialization.Model):
    """The error details.

    :param code: The error code.
    :type code: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ErrorModelError, self).__init__(**kwargs)
        self.code = code
        self.message = message


class LoadBalancingRule(msrest.serialization.Model):
    """Describes a load balancing rule.

    All required parameters must be populated in order to send to Azure.

    :param frontend_port: Required. The port for the external endpoint. Port numbers for each rule
     must be unique within the Load Balancer. Acceptable values are between 1 and 65534.
    :type frontend_port: int
    :param backend_port: Required. The port used for internal connections on the endpoint.
     Acceptable values are between 1 and 65535.
    :type backend_port: int
    :param protocol: Required. The reference to the transport protocol used by the load balancing
     rule. Possible values include: "tcp", "udp".
    :type protocol: str or ~service_fabric_managed_clusters_management_client.models.Protocol
    :param probe_protocol: Required. the reference to the load balancer probe used by the load
     balancing rule. Possible values include: "tcp", "http", "https".
    :type probe_protocol: str or
     ~service_fabric_managed_clusters_management_client.models.ProbeProtocol
    :param probe_request_path: The probe request path. Only supported for HTTP/HTTPS probes.
    :type probe_request_path: str
    """

    _validation = {
        'frontend_port': {'required': True, 'maximum': 65534, 'minimum': 1},
        'backend_port': {'required': True, 'maximum': 65534, 'minimum': 1},
        'protocol': {'required': True},
        'probe_protocol': {'required': True},
    }

    _attribute_map = {
        'frontend_port': {'key': 'frontendPort', 'type': 'int'},
        'backend_port': {'key': 'backendPort', 'type': 'int'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'probe_protocol': {'key': 'probeProtocol', 'type': 'str'},
        'probe_request_path': {'key': 'probeRequestPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        frontend_port: int,
        backend_port: int,
        protocol: Union[str, "Protocol"],
        probe_protocol: Union[str, "ProbeProtocol"],
        probe_request_path: Optional[str] = None,
        **kwargs
    ):
        super(LoadBalancingRule, self).__init__(**kwargs)
        self.frontend_port = frontend_port
        self.backend_port = backend_port
        self.protocol = protocol
        self.probe_protocol = probe_protocol
        self.probe_request_path = probe_request_path


class Resource(msrest.serialization.Model):
    """The resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Azure resource location.
    :type location: str
    :param tags: A set of tags. Azure resource tags.
    :type tags: dict[str, str]
    :ivar etag: Azure resource etag.
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~service_fabric_managed_clusters_management_client.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.etag = None
        self.system_data = None


class ManagedCluster(Resource):
    """The manged cluster resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Azure resource location.
    :type location: str
    :param tags: A set of tags. Azure resource tags.
    :type tags: dict[str, str]
    :ivar etag: Azure resource etag.
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~service_fabric_managed_clusters_management_client.models.SystemData
    :param sku: The sku of the managed cluster.
    :type sku: ~service_fabric_managed_clusters_management_client.models.Sku
    :param dns_name: The cluster dns name.
    :type dns_name: str
    :ivar fqdn: The fully qualified domain name associated with the public load balancer of the
     cluster.
    :vartype fqdn: str
    :ivar ipv4_address: The IPv4 address associated with the public load balancer of the cluster.
    :vartype ipv4_address: str
    :ivar cluster_id: A service generated unique identifier for the cluster resource.
    :vartype cluster_id: str
    :ivar cluster_state: The current state of the cluster. Possible values include:
     "WaitingForNodes", "Deploying", "BaselineUpgrade", "Upgrading", "UpgradeFailed", "Ready".
    :vartype cluster_state: str or
     ~service_fabric_managed_clusters_management_client.models.ClusterState
    :ivar cluster_certificate_thumbprints: List of thumbprints of the cluster certificates.
    :vartype cluster_certificate_thumbprints: list[str]
    :param client_connection_port: The port used for client connections to the cluster.
    :type client_connection_port: int
    :param http_gateway_connection_port: The port used for HTTP connections to the cluster.
    :type http_gateway_connection_port: int
    :param admin_user_name: VM admin user name.
    :type admin_user_name: str
    :param admin_password: VM admin user password.
    :type admin_password: str
    :param load_balancing_rules: Load balancing rules that are applied to the public load balancer
     of the cluster.
    :type load_balancing_rules:
     list[~service_fabric_managed_clusters_management_client.models.LoadBalancingRule]
    :param allow_rdp_access: Setting this to true enables RDP access to the VM. The default NSG
     rule opens RDP port to internet which can be overridden with custom Network Security Rules. The
     default value for this setting is false.
    :type allow_rdp_access: bool
    :param network_security_rules: Custom Network Security Rules that are applied to the virtual
     network of the cluster.
    :type network_security_rules:
     list[~service_fabric_managed_clusters_management_client.models.NetworkSecurityRule]
    :param clients: Client certificates that are allowed to manage the cluster.
    :type clients:
     list[~service_fabric_managed_clusters_management_client.models.ClientCertificate]
    :param azure_active_directory: The AAD authentication settings of the cluster.
    :type azure_active_directory:
     ~service_fabric_managed_clusters_management_client.models.AzureActiveDirectory
    :param fabric_settings: The list of custom fabric settings to configure the cluster.
    :type fabric_settings:
     list[~service_fabric_managed_clusters_management_client.models.SettingsSectionDescription]
    :ivar provisioning_state: The provisioning state of the managed cluster resource. Possible
     values include: "None", "Creating", "Created", "Updating", "Succeeded", "Failed", "Canceled",
     "Deleting", "Deleted", "Other".
    :vartype provisioning_state: str or
     ~service_fabric_managed_clusters_management_client.models.ManagedResourceProvisioningState
    :param cluster_code_version: The Service Fabric runtime version of the cluster. This property
     can only by set the user when **upgradeMode** is set to 'Manual'. To get list of available
     Service Fabric versions for new clusters use `ClusterVersion API <./ClusterVersion.md>`_. To
     get the list of available version for existing clusters use **availableClusterVersions**.
    :type cluster_code_version: str
    :param cluster_upgrade_cadence: Indicates when new cluster runtime version upgrades will be
     applied after they are released. By default is Wave0. Possible values include: "Wave0",
     "Wave1", "Wave2".
    :type cluster_upgrade_cadence: str or
     ~service_fabric_managed_clusters_management_client.models.ClusterUpgradeCadence
    :param addon_features: List of add-on features to enable on the cluster.
    :type addon_features: list[str or
     ~service_fabric_managed_clusters_management_client.models.ManagedClusterAddOnFeature]
    :param enable_auto_os_upgrade: Setting this to true enables automatic OS upgrade for the node
     types that are created using any platform OS image with version 'latest'. The default value for
     this setting is false.
    :type enable_auto_os_upgrade: bool
    :param application_type_versions_cleanup_policy: The policy used to clean up unused versions.
    :type application_type_versions_cleanup_policy:
     ~service_fabric_managed_clusters_management_client.models.ApplicationTypeVersionsCleanupPolicy
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'fqdn': {'readonly': True},
        'ipv4_address': {'readonly': True},
        'cluster_id': {'readonly': True},
        'cluster_state': {'readonly': True},
        'cluster_certificate_thumbprints': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'dns_name': {'key': 'properties.dnsName', 'type': 'str'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'ipv4_address': {'key': 'properties.ipv4Address', 'type': 'str'},
        'cluster_id': {'key': 'properties.clusterId', 'type': 'str'},
        'cluster_state': {'key': 'properties.clusterState', 'type': 'str'},
        'cluster_certificate_thumbprints': {'key': 'properties.clusterCertificateThumbprints', 'type': '[str]'},
        'client_connection_port': {'key': 'properties.clientConnectionPort', 'type': 'int'},
        'http_gateway_connection_port': {'key': 'properties.httpGatewayConnectionPort', 'type': 'int'},
        'admin_user_name': {'key': 'properties.adminUserName', 'type': 'str'},
        'admin_password': {'key': 'properties.adminPassword', 'type': 'str'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[LoadBalancingRule]'},
        'allow_rdp_access': {'key': 'properties.allowRdpAccess', 'type': 'bool'},
        'network_security_rules': {'key': 'properties.networkSecurityRules', 'type': '[NetworkSecurityRule]'},
        'clients': {'key': 'properties.clients', 'type': '[ClientCertificate]'},
        'azure_active_directory': {'key': 'properties.azureActiveDirectory', 'type': 'AzureActiveDirectory'},
        'fabric_settings': {'key': 'properties.fabricSettings', 'type': '[SettingsSectionDescription]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'cluster_code_version': {'key': 'properties.clusterCodeVersion', 'type': 'str'},
        'cluster_upgrade_cadence': {'key': 'properties.clusterUpgradeCadence', 'type': 'str'},
        'addon_features': {'key': 'properties.addonFeatures', 'type': '[str]'},
        'enable_auto_os_upgrade': {'key': 'properties.enableAutoOSUpgrade', 'type': 'bool'},
        'application_type_versions_cleanup_policy': {'key': 'properties.applicationTypeVersionsCleanupPolicy', 'type': 'ApplicationTypeVersionsCleanupPolicy'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        dns_name: Optional[str] = None,
        client_connection_port: Optional[int] = 19000,
        http_gateway_connection_port: Optional[int] = 19080,
        admin_user_name: Optional[str] = None,
        admin_password: Optional[str] = None,
        load_balancing_rules: Optional[List["LoadBalancingRule"]] = None,
        allow_rdp_access: Optional[bool] = None,
        network_security_rules: Optional[List["NetworkSecurityRule"]] = None,
        clients: Optional[List["ClientCertificate"]] = None,
        azure_active_directory: Optional["AzureActiveDirectory"] = None,
        fabric_settings: Optional[List["SettingsSectionDescription"]] = None,
        cluster_code_version: Optional[str] = None,
        cluster_upgrade_cadence: Optional[Union[str, "ClusterUpgradeCadence"]] = None,
        addon_features: Optional[List[Union[str, "ManagedClusterAddOnFeature"]]] = None,
        enable_auto_os_upgrade: Optional[bool] = None,
        application_type_versions_cleanup_policy: Optional["ApplicationTypeVersionsCleanupPolicy"] = None,
        **kwargs
    ):
        super(ManagedCluster, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.dns_name = dns_name
        self.fqdn = None
        self.ipv4_address = None
        self.cluster_id = None
        self.cluster_state = None
        self.cluster_certificate_thumbprints = None
        self.client_connection_port = client_connection_port
        self.http_gateway_connection_port = http_gateway_connection_port
        self.admin_user_name = admin_user_name
        self.admin_password = admin_password
        self.load_balancing_rules = load_balancing_rules
        self.allow_rdp_access = allow_rdp_access
        self.network_security_rules = network_security_rules
        self.clients = clients
        self.azure_active_directory = azure_active_directory
        self.fabric_settings = fabric_settings
        self.provisioning_state = None
        self.cluster_code_version = cluster_code_version
        self.cluster_upgrade_cadence = cluster_upgrade_cadence
        self.addon_features = addon_features
        self.enable_auto_os_upgrade = enable_auto_os_upgrade
        self.application_type_versions_cleanup_policy = application_type_versions_cleanup_policy


class ManagedClusterListResult(msrest.serialization.Model):
    """Managed Cluster list results.

    :param value:
    :type value: list[~service_fabric_managed_clusters_management_client.models.ManagedCluster]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedCluster]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ManagedCluster"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ManagedClusterListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ManagedClusterUpdateParameters(msrest.serialization.Model):
    """Managed cluster update request.

    :param tags: A set of tags. Managed cluster update parameters.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ManagedClusterUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class ManagedIdentity(msrest.serialization.Model):
    """Describes the managed identities for an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of the managed identity. This property will only be
     provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the managed identity. This property will only be provided for
     a system assigned identity.
    :vartype tenant_id: str
    :param type: The type of managed identity for the resource. Possible values include: "None",
     "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned".
    :type type: str or
     ~service_fabric_managed_clusters_management_client.models.ManagedIdentityType
    :param user_assigned_identities: The list of user identities associated with the resource. The
     user identity dictionary key references will be ARM resource ids in the form:
    '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~service_fabric_managed_clusters_management_client.models.UserAssignedIdentity]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentity}'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ManagedIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "UserAssignedIdentity"]] = None,
        **kwargs
    ):
        super(ManagedIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class ManagedProxyResource(msrest.serialization.Model):
    """The resource model definition for proxy-only resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param tags: A set of tags. Azure resource tags.
    :type tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~service_fabric_managed_clusters_management_client.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ManagedProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.system_data = None


class Partition(msrest.serialization.Model):
    """Describes how the service is partitioned.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: NamedPartitionScheme, SingletonPartitionScheme, UniformInt64RangePartitionScheme.

    All required parameters must be populated in order to send to Azure.

    :param partition_scheme: Required. Specifies how the service is partitioned.Constant filled by
     server.  Possible values include: "Singleton", "UniformInt64Range", "Named".
    :type partition_scheme: str or
     ~service_fabric_managed_clusters_management_client.models.PartitionScheme
    """

    _validation = {
        'partition_scheme': {'required': True},
    }

    _attribute_map = {
        'partition_scheme': {'key': 'partitionScheme', 'type': 'str'},
    }

    _subtype_map = {
        'partition_scheme': {'Named': 'NamedPartitionScheme', 'Singleton': 'SingletonPartitionScheme', 'UniformInt64Range': 'UniformInt64RangePartitionScheme'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Partition, self).__init__(**kwargs)
        self.partition_scheme = None  # type: Optional[str]


class NamedPartitionScheme(Partition):
    """Describes the named partition scheme of the service.

    All required parameters must be populated in order to send to Azure.

    :param partition_scheme: Required. Specifies how the service is partitioned.Constant filled by
     server.  Possible values include: "Singleton", "UniformInt64Range", "Named".
    :type partition_scheme: str or
     ~service_fabric_managed_clusters_management_client.models.PartitionScheme
    :param names: Required. Array for the names of the partitions.
    :type names: list[str]
    """

    _validation = {
        'partition_scheme': {'required': True},
        'names': {'required': True},
    }

    _attribute_map = {
        'partition_scheme': {'key': 'partitionScheme', 'type': 'str'},
        'names': {'key': 'names', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        names: List[str],
        **kwargs
    ):
        super(NamedPartitionScheme, self).__init__(**kwargs)
        self.partition_scheme = 'Named'  # type: str
        self.names = names


class NetworkSecurityRule(msrest.serialization.Model):
    """Describes a network security rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Network security rule name.
    :type name: str
    :param description: Network security rule description.
    :type description: str
    :param protocol: Required. Network protocol this rule applies to. Possible values include:
     "http", "https", "tcp", "udp", "icmp", "ah", "esp".
    :type protocol: str or ~service_fabric_managed_clusters_management_client.models.NsgProtocol
    :param source_address_prefixes: The CIDR or source IP ranges.
    :type source_address_prefixes: list[str]
    :param destination_address_prefixes: The destination address prefixes. CIDR or destination IP
     ranges.
    :type destination_address_prefixes: list[str]
    :param source_port_ranges: The source port ranges.
    :type source_port_ranges: list[str]
    :param destination_port_ranges: The destination port ranges.
    :type destination_port_ranges: list[str]
    :param access: Required. The network traffic is allowed or denied. Possible values include:
     "allow", "deny".
    :type access: str or ~service_fabric_managed_clusters_management_client.models.Access
    :param priority: Required. The priority of the rule. The value can be in the range 1000 to
     3000. Values outside this range are reserved for Service Fabric ManagerCluster Resource
     Provider. The priority number must be unique for each rule in the collection. The lower the
     priority number, the higher the priority of the rule.
    :type priority: int
    :param direction: Required. Network security rule direction. Possible values include:
     "inbound", "outbound".
    :type direction: str or ~service_fabric_managed_clusters_management_client.models.Direction
    """

    _validation = {
        'name': {'required': True},
        'protocol': {'required': True},
        'access': {'required': True},
        'priority': {'required': True, 'maximum': 3000, 'minimum': 1000},
        'direction': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'source_address_prefixes': {'key': 'sourceAddressPrefixes', 'type': '[str]'},
        'destination_address_prefixes': {'key': 'destinationAddressPrefixes', 'type': '[str]'},
        'source_port_ranges': {'key': 'sourcePortRanges', 'type': '[str]'},
        'destination_port_ranges': {'key': 'destinationPortRanges', 'type': '[str]'},
        'access': {'key': 'access', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'direction': {'key': 'direction', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        protocol: Union[str, "NsgProtocol"],
        access: Union[str, "Access"],
        priority: int,
        direction: Union[str, "Direction"],
        description: Optional[str] = None,
        source_address_prefixes: Optional[List[str]] = None,
        destination_address_prefixes: Optional[List[str]] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        **kwargs
    ):
        super(NetworkSecurityRule, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.protocol = protocol
        self.source_address_prefixes = source_address_prefixes
        self.destination_address_prefixes = destination_address_prefixes
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.access = access
        self.priority = priority
        self.direction = direction


class NodeType(ManagedProxyResource):
    """Describes a node type in the cluster, each node type represents sub set of nodes in the cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param tags: A set of tags. Azure resource tags.
    :type tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~service_fabric_managed_clusters_management_client.models.SystemData
    :param is_primary: The node type on which system services will run. Only one node type should
     be marked as primary. Primary node type cannot be deleted or changed for existing clusters.
    :type is_primary: bool
    :param vm_instance_count: The number of nodes in the node type.
    :type vm_instance_count: int
    :param data_disk_size_gb: Disk size for each vm in the node type in GBs.
    :type data_disk_size_gb: int
    :param placement_properties: The placement tags applied to nodes in the node type, which can be
     used to indicate where certain services (workload) should run.
    :type placement_properties: dict[str, str]
    :param capacities: The capacity tags applied to the nodes in the node type, the cluster
     resource manager uses these tags to understand how much resource a node has.
    :type capacities: dict[str, str]
    :param application_ports: The range of ports from which cluster assigned port to Service Fabric
     applications.
    :type application_ports:
     ~service_fabric_managed_clusters_management_client.models.EndpointRangeDescription
    :param ephemeral_ports: The range of ephemeral ports that nodes in this node type should be
     configured with.
    :type ephemeral_ports:
     ~service_fabric_managed_clusters_management_client.models.EndpointRangeDescription
    :param vm_size: The size of virtual machines in the pool. All virtual machines in a pool are
     the same size. For example, Standard_D3.
    :type vm_size: str
    :param vm_image_publisher: The publisher of the Azure Virtual Machines Marketplace image. For
     example, Canonical or MicrosoftWindowsServer.
    :type vm_image_publisher: str
    :param vm_image_offer: The offer type of the Azure Virtual Machines Marketplace image. For
     example, UbuntuServer or WindowsServer.
    :type vm_image_offer: str
    :param vm_image_sku: The SKU of the Azure Virtual Machines Marketplace image. For example,
     14.04.0-LTS or 2012-R2-Datacenter.
    :type vm_image_sku: str
    :param vm_image_version: The version of the Azure Virtual Machines Marketplace image. A value
     of 'latest' can be specified to select the latest version of an image. If omitted, the default
     is 'latest'.
    :type vm_image_version: str
    :param vm_secrets: The secrets to install in the virtual machines.
    :type vm_secrets:
     list[~service_fabric_managed_clusters_management_client.models.VaultSecretGroup]
    :param vm_extensions: Set of extensions that should be installed onto the virtual machines.
    :type vm_extensions:
     list[~service_fabric_managed_clusters_management_client.models.VMSSExtension]
    :param vm_managed_identity: Identities for the virtual machine scale set under the node type.
    :type vm_managed_identity:
     ~service_fabric_managed_clusters_management_client.models.VmManagedIdentity
    :ivar provisioning_state: The provisioning state of the managed cluster resource. Possible
     values include: "None", "Creating", "Created", "Updating", "Succeeded", "Failed", "Canceled",
     "Deleting", "Deleted", "Other".
    :vartype provisioning_state: str or
     ~service_fabric_managed_clusters_management_client.models.ManagedResourceProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'vm_instance_count': {'maximum': 2147483647, 'minimum': 1},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'is_primary': {'key': 'properties.isPrimary', 'type': 'bool'},
        'vm_instance_count': {'key': 'properties.vmInstanceCount', 'type': 'int'},
        'data_disk_size_gb': {'key': 'properties.dataDiskSizeGB', 'type': 'int'},
        'placement_properties': {'key': 'properties.placementProperties', 'type': '{str}'},
        'capacities': {'key': 'properties.capacities', 'type': '{str}'},
        'application_ports': {'key': 'properties.applicationPorts', 'type': 'EndpointRangeDescription'},
        'ephemeral_ports': {'key': 'properties.ephemeralPorts', 'type': 'EndpointRangeDescription'},
        'vm_size': {'key': 'properties.vmSize', 'type': 'str'},
        'vm_image_publisher': {'key': 'properties.vmImagePublisher', 'type': 'str'},
        'vm_image_offer': {'key': 'properties.vmImageOffer', 'type': 'str'},
        'vm_image_sku': {'key': 'properties.vmImageSku', 'type': 'str'},
        'vm_image_version': {'key': 'properties.vmImageVersion', 'type': 'str'},
        'vm_secrets': {'key': 'properties.vmSecrets', 'type': '[VaultSecretGroup]'},
        'vm_extensions': {'key': 'properties.vmExtensions', 'type': '[VMSSExtension]'},
        'vm_managed_identity': {'key': 'properties.vmManagedIdentity', 'type': 'VmManagedIdentity'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        is_primary: Optional[bool] = None,
        vm_instance_count: Optional[int] = None,
        data_disk_size_gb: Optional[int] = None,
        placement_properties: Optional[Dict[str, str]] = None,
        capacities: Optional[Dict[str, str]] = None,
        application_ports: Optional["EndpointRangeDescription"] = None,
        ephemeral_ports: Optional["EndpointRangeDescription"] = None,
        vm_size: Optional[str] = None,
        vm_image_publisher: Optional[str] = None,
        vm_image_offer: Optional[str] = None,
        vm_image_sku: Optional[str] = None,
        vm_image_version: Optional[str] = None,
        vm_secrets: Optional[List["VaultSecretGroup"]] = None,
        vm_extensions: Optional[List["VMSSExtension"]] = None,
        vm_managed_identity: Optional["VmManagedIdentity"] = None,
        **kwargs
    ):
        super(NodeType, self).__init__(tags=tags, **kwargs)
        self.is_primary = is_primary
        self.vm_instance_count = vm_instance_count
        self.data_disk_size_gb = data_disk_size_gb
        self.placement_properties = placement_properties
        self.capacities = capacities
        self.application_ports = application_ports
        self.ephemeral_ports = ephemeral_ports
        self.vm_size = vm_size
        self.vm_image_publisher = vm_image_publisher
        self.vm_image_offer = vm_image_offer
        self.vm_image_sku = vm_image_sku
        self.vm_image_version = vm_image_version
        self.vm_secrets = vm_secrets
        self.vm_extensions = vm_extensions
        self.vm_managed_identity = vm_managed_identity
        self.provisioning_state = None


class NodeTypeActionParameters(msrest.serialization.Model):
    """Parameters for Node type action.

    All required parameters must be populated in order to send to Azure.

    :param nodes: Required. List of node names from the node type.
    :type nodes: list[str]
    :param force: Force the action to go through.
    :type force: bool
    """

    _validation = {
        'nodes': {'required': True},
    }

    _attribute_map = {
        'nodes': {'key': 'nodes', 'type': '[str]'},
        'force': {'key': 'force', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        nodes: List[str],
        force: Optional[bool] = None,
        **kwargs
    ):
        super(NodeTypeActionParameters, self).__init__(**kwargs)
        self.nodes = nodes
        self.force = force


class NodeTypeListResult(msrest.serialization.Model):
    """Node type list results.

    :param value: The list of node types.
    :type value: list[~service_fabric_managed_clusters_management_client.models.NodeType]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NodeType]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NodeType"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(NodeTypeListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NodeTypeUpdateParameters(msrest.serialization.Model):
    """Node type update request.

    :param tags: A set of tags. Node type update parameters.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(NodeTypeUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class OperationListResult(msrest.serialization.Model):
    """Describes the result of the request to list Service Fabric resource provider operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of operations supported by the Service Fabric resource provider.
    :type value: list[~service_fabric_managed_clusters_management_client.models.OperationResult]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationResult]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["OperationResult"]] = None,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class OperationResult(msrest.serialization.Model):
    """Available operation list result.

    :param name: The name of the operation.
    :type name: str
    :param is_data_action: Indicates whether the operation is a data action.
    :type is_data_action: bool
    :param display: The object that represents the operation.
    :type display:
     ~service_fabric_managed_clusters_management_client.models.AvailableOperationDisplay
    :param origin: Origin result.
    :type origin: str
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'AvailableOperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["AvailableOperationDisplay"] = None,
        origin: Optional[str] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationResult, self).__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display
        self.origin = origin
        self.next_link = next_link


class PartitionInstanceCountScaleMechanism(ScalingMechanism):
    """Represents a scaling mechanism for adding or removing instances of stateless service partition.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Specifies the mechanism associated with this scaling policy.Constant
     filled by server.  Possible values include: "ScalePartitionInstanceCount",
     "AddRemoveIncrementalNamedPartition".
    :type kind: str or
     ~service_fabric_managed_clusters_management_client.models.ServiceScalingMechanismKind
    :param min_instance_count: Required. Minimum number of instances of the partition.
    :type min_instance_count: int
    :param max_instance_count: Required. Maximum number of instances of the partition.
    :type max_instance_count: int
    :param scale_increment: Required. The number of instances to add or remove during a scaling
     operation.
    :type scale_increment: int
    """

    _validation = {
        'kind': {'required': True},
        'min_instance_count': {'required': True},
        'max_instance_count': {'required': True},
        'scale_increment': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'min_instance_count': {'key': 'minInstanceCount', 'type': 'int'},
        'max_instance_count': {'key': 'maxInstanceCount', 'type': 'int'},
        'scale_increment': {'key': 'scaleIncrement', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        min_instance_count: int,
        max_instance_count: int,
        scale_increment: int,
        **kwargs
    ):
        super(PartitionInstanceCountScaleMechanism, self).__init__(**kwargs)
        self.kind = 'ScalePartitionInstanceCount'  # type: str
        self.min_instance_count = min_instance_count
        self.max_instance_count = max_instance_count
        self.scale_increment = scale_increment


class RollingUpgradeMonitoringPolicy(msrest.serialization.Model):
    """The policy used for monitoring the application upgrade.

    All required parameters must be populated in order to send to Azure.

    :param failure_action: Required. The compensating action to perform when a Monitored upgrade
     encounters monitoring policy or health policy violations. Invalid indicates the failure action
     is invalid. Rollback specifies that the upgrade will start rolling back automatically. Manual
     indicates that the upgrade will switch to UnmonitoredManual upgrade mode. Possible values
     include: "Rollback", "Manual".
    :type failure_action: str or
     ~service_fabric_managed_clusters_management_client.models.FailureAction
    :param health_check_wait_duration: Required. The amount of time to wait after completing an
     upgrade domain before applying health policies. It is interpreted as a string representing an
     ISO 8601 duration with following format "hh:mm:ss.fff".
    :type health_check_wait_duration: str
    :param health_check_stable_duration: Required. The amount of time that the application or
     cluster must remain healthy before the upgrade proceeds to the next upgrade domain. It is
     interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
    :type health_check_stable_duration: str
    :param health_check_retry_timeout: Required. The amount of time to retry health evaluation when
     the application or cluster is unhealthy before FailureAction is executed. It is interpreted as
     a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
    :type health_check_retry_timeout: str
    :param upgrade_timeout: Required. The amount of time the overall upgrade has to complete before
     FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as a string
     representing an ISO 8601 duration with following format "hh:mm:ss.fff".
    :type upgrade_timeout: str
    :param upgrade_domain_timeout: Required. The amount of time each upgrade domain has to complete
     before FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as a string
     representing an ISO 8601 duration with following format "hh:mm:ss.fff".
    :type upgrade_domain_timeout: str
    """

    _validation = {
        'failure_action': {'required': True},
        'health_check_wait_duration': {'required': True},
        'health_check_stable_duration': {'required': True},
        'health_check_retry_timeout': {'required': True},
        'upgrade_timeout': {'required': True},
        'upgrade_domain_timeout': {'required': True},
    }

    _attribute_map = {
        'failure_action': {'key': 'failureAction', 'type': 'str'},
        'health_check_wait_duration': {'key': 'healthCheckWaitDuration', 'type': 'str'},
        'health_check_stable_duration': {'key': 'healthCheckStableDuration', 'type': 'str'},
        'health_check_retry_timeout': {'key': 'healthCheckRetryTimeout', 'type': 'str'},
        'upgrade_timeout': {'key': 'upgradeTimeout', 'type': 'str'},
        'upgrade_domain_timeout': {'key': 'upgradeDomainTimeout', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        failure_action: Union[str, "FailureAction"],
        health_check_wait_duration: str,
        health_check_stable_duration: str,
        health_check_retry_timeout: str,
        upgrade_timeout: str,
        upgrade_domain_timeout: str,
        **kwargs
    ):
        super(RollingUpgradeMonitoringPolicy, self).__init__(**kwargs)
        self.failure_action = failure_action
        self.health_check_wait_duration = health_check_wait_duration
        self.health_check_stable_duration = health_check_stable_duration
        self.health_check_retry_timeout = health_check_retry_timeout
        self.upgrade_timeout = upgrade_timeout
        self.upgrade_domain_timeout = upgrade_domain_timeout


class ScalingPolicy(msrest.serialization.Model):
    """Specifies a metric to load balance a service during runtime.

    All required parameters must be populated in order to send to Azure.

    :param scaling_mechanism: Required. Specifies the mechanism associated with this scaling
     policy.
    :type scaling_mechanism:
     ~service_fabric_managed_clusters_management_client.models.ScalingMechanism
    :param scaling_trigger: Required. Specifies the trigger associated with this scaling policy.
    :type scaling_trigger: ~service_fabric_managed_clusters_management_client.models.ScalingTrigger
    """

    _validation = {
        'scaling_mechanism': {'required': True},
        'scaling_trigger': {'required': True},
    }

    _attribute_map = {
        'scaling_mechanism': {'key': 'scalingMechanism', 'type': 'ScalingMechanism'},
        'scaling_trigger': {'key': 'scalingTrigger', 'type': 'ScalingTrigger'},
    }

    def __init__(
        self,
        *,
        scaling_mechanism: "ScalingMechanism",
        scaling_trigger: "ScalingTrigger",
        **kwargs
    ):
        super(ScalingPolicy, self).__init__(**kwargs)
        self.scaling_mechanism = scaling_mechanism
        self.scaling_trigger = scaling_trigger


class ServiceCorrelation(msrest.serialization.Model):
    """Creates a particular correlation between services.

    All required parameters must be populated in order to send to Azure.

    :param scheme: Required. The ServiceCorrelationScheme which describes the relationship between
     this service and the service specified via ServiceName. Possible values include:
     "AlignedAffinity", "NonAlignedAffinity".
    :type scheme: str or
     ~service_fabric_managed_clusters_management_client.models.ServiceCorrelationScheme
    :param service_name: Required. The Arm Resource ID of the service that the correlation
     relationship is established with.
    :type service_name: str
    """

    _validation = {
        'scheme': {'required': True},
        'service_name': {'required': True},
    }

    _attribute_map = {
        'scheme': {'key': 'scheme', 'type': 'str'},
        'service_name': {'key': 'serviceName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        scheme: Union[str, "ServiceCorrelationScheme"],
        service_name: str,
        **kwargs
    ):
        super(ServiceCorrelation, self).__init__(**kwargs)
        self.scheme = scheme
        self.service_name = service_name


class ServiceLoadMetric(msrest.serialization.Model):
    """Specifies a metric to load balance a service during runtime.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the metric. If the service chooses to report load during
     runtime, the load metric name should match the name that is specified in Name exactly. Note
     that metric names are case sensitive.
    :type name: str
    :param weight: The service load metric relative weight, compared to other metrics configured
     for this service, as a number. Possible values include: "Zero", "Low", "Medium", "High".
    :type weight: str or
     ~service_fabric_managed_clusters_management_client.models.ServiceLoadMetricWeight
    :param primary_default_load: Used only for Stateful services. The default amount of load, as a
     number, that this service creates for this metric when it is a Primary replica.
    :type primary_default_load: int
    :param secondary_default_load: Used only for Stateful services. The default amount of load, as
     a number, that this service creates for this metric when it is a Secondary replica.
    :type secondary_default_load: int
    :param default_load: Used only for Stateless services. The default amount of load, as a number,
     that this service creates for this metric.
    :type default_load: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'weight': {'key': 'weight', 'type': 'str'},
        'primary_default_load': {'key': 'primaryDefaultLoad', 'type': 'int'},
        'secondary_default_load': {'key': 'secondaryDefaultLoad', 'type': 'int'},
        'default_load': {'key': 'defaultLoad', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        weight: Optional[Union[str, "ServiceLoadMetricWeight"]] = None,
        primary_default_load: Optional[int] = None,
        secondary_default_load: Optional[int] = None,
        default_load: Optional[int] = None,
        **kwargs
    ):
        super(ServiceLoadMetric, self).__init__(**kwargs)
        self.name = name
        self.weight = weight
        self.primary_default_load = primary_default_load
        self.secondary_default_load = secondary_default_load
        self.default_load = default_load


class ServicePlacementPolicy(msrest.serialization.Model):
    """Describes the policy to be used for placement of a Service Fabric service.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ServicePlacementInvalidDomainPolicy, ServicePlacementNonPartiallyPlaceServicePolicy, ServicePlacementPreferPrimaryDomainPolicy, ServicePlacementRequiredDomainPolicy, ServicePlacementRequireDomainDistributionPolicy.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of placement policy for a service fabric service. Following are
     the possible values.Constant filled by server.  Possible values include: "InvalidDomain",
     "RequiredDomain", "PreferredPrimaryDomain", "RequiredDomainDistribution",
     "NonPartiallyPlaceService".
    :type type: str or
     ~service_fabric_managed_clusters_management_client.models.ServicePlacementPolicyType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'InvalidDomain': 'ServicePlacementInvalidDomainPolicy', 'NonPartiallyPlaceService': 'ServicePlacementNonPartiallyPlaceServicePolicy', 'PreferredPrimaryDomain': 'ServicePlacementPreferPrimaryDomainPolicy', 'RequiredDomain': 'ServicePlacementRequiredDomainPolicy', 'RequiredDomainDistribution': 'ServicePlacementRequireDomainDistributionPolicy'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServicePlacementPolicy, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class ServicePlacementInvalidDomainPolicy(ServicePlacementPolicy):
    """Describes the policy to be used for placement of a Service Fabric service where a particular fault or upgrade domain should not be used for placement of the instances or replicas of that service.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of placement policy for a service fabric service. Following are
     the possible values.Constant filled by server.  Possible values include: "InvalidDomain",
     "RequiredDomain", "PreferredPrimaryDomain", "RequiredDomainDistribution",
     "NonPartiallyPlaceService".
    :type type: str or
     ~service_fabric_managed_clusters_management_client.models.ServicePlacementPolicyType
    :param domain_name: Required. The name of the domain that should not be used for placement.
    :type domain_name: str
    """

    _validation = {
        'type': {'required': True},
        'domain_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'domain_name': {'key': 'domainName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        domain_name: str,
        **kwargs
    ):
        super(ServicePlacementInvalidDomainPolicy, self).__init__(**kwargs)
        self.type = 'InvalidDomain'  # type: str
        self.domain_name = domain_name


class ServicePlacementNonPartiallyPlaceServicePolicy(ServicePlacementPolicy):
    """ServicePlacementNonPartiallyPlaceServicePolicy.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of placement policy for a service fabric service. Following are
     the possible values.Constant filled by server.  Possible values include: "InvalidDomain",
     "RequiredDomain", "PreferredPrimaryDomain", "RequiredDomainDistribution",
     "NonPartiallyPlaceService".
    :type type: str or
     ~service_fabric_managed_clusters_management_client.models.ServicePlacementPolicyType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServicePlacementNonPartiallyPlaceServicePolicy, self).__init__(**kwargs)
        self.type = 'NonPartiallyPlaceService'  # type: str


class ServicePlacementPreferPrimaryDomainPolicy(ServicePlacementPolicy):
    """Describes the policy to be used for placement of a Service Fabric service where the service's 
Primary replicas should optimally be placed in a particular domain.

This placement policy is usually used with fault domains in scenarios where the Service Fabric
cluster is geographically distributed in order to indicate that a service's primary replica should
be located in a particular fault domain, which in geo-distributed scenarios usually aligns with regional
or datacenter boundaries. Note that since this is an optimization it is possible that the Primary replica
may not end up located in this domain due to failures, capacity limits, or other constraints.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of placement policy for a service fabric service. Following are
     the possible values.Constant filled by server.  Possible values include: "InvalidDomain",
     "RequiredDomain", "PreferredPrimaryDomain", "RequiredDomainDistribution",
     "NonPartiallyPlaceService".
    :type type: str or
     ~service_fabric_managed_clusters_management_client.models.ServicePlacementPolicyType
    :param domain_name: Required. The name of the domain that should used for placement as per this
     policy.
    :type domain_name: str
    """

    _validation = {
        'type': {'required': True},
        'domain_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'domain_name': {'key': 'domainName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        domain_name: str,
        **kwargs
    ):
        super(ServicePlacementPreferPrimaryDomainPolicy, self).__init__(**kwargs)
        self.type = 'PreferredPrimaryDomain'  # type: str
        self.domain_name = domain_name


class ServicePlacementRequiredDomainPolicy(ServicePlacementPolicy):
    """Describes the policy to be used for placement of a Service Fabric service where the instances or replicas of that service must be placed in a particular domain.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of placement policy for a service fabric service. Following are
     the possible values.Constant filled by server.  Possible values include: "InvalidDomain",
     "RequiredDomain", "PreferredPrimaryDomain", "RequiredDomainDistribution",
     "NonPartiallyPlaceService".
    :type type: str or
     ~service_fabric_managed_clusters_management_client.models.ServicePlacementPolicyType
    :param domain_name: Required. The name of the domain that should used for placement as per this
     policy.
    :type domain_name: str
    """

    _validation = {
        'type': {'required': True},
        'domain_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'domain_name': {'key': 'domainName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        domain_name: str,
        **kwargs
    ):
        super(ServicePlacementRequiredDomainPolicy, self).__init__(**kwargs)
        self.type = 'RequiredDomain'  # type: str
        self.domain_name = domain_name


class ServicePlacementRequireDomainDistributionPolicy(ServicePlacementPolicy):
    """Describes the policy to be used for placement of a Service Fabric service where two replicas
from the same partition should never be placed in the same fault or upgrade domain.

While this is not common it can expose the service to an increased risk of concurrent failures
due to unplanned outages or other cases of subsequent/concurrent failures. As an example, consider
a case where replicas are deployed across different data center, with one replica per location.
In the event that one of the datacenters goes offline, normally the replica that was placed in that
datacenter will be packed into one of the remaining datacenters. If this is not desirable then this
policy should be set.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of placement policy for a service fabric service. Following are
     the possible values.Constant filled by server.  Possible values include: "InvalidDomain",
     "RequiredDomain", "PreferredPrimaryDomain", "RequiredDomainDistribution",
     "NonPartiallyPlaceService".
    :type type: str or
     ~service_fabric_managed_clusters_management_client.models.ServicePlacementPolicyType
    :param domain_name: Required. The name of the domain that should used for placement as per this
     policy.
    :type domain_name: str
    """

    _validation = {
        'type': {'required': True},
        'domain_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'domain_name': {'key': 'domainName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        domain_name: str,
        **kwargs
    ):
        super(ServicePlacementRequireDomainDistributionPolicy, self).__init__(**kwargs)
        self.type = 'RequiredDomainDistribution'  # type: str
        self.domain_name = domain_name


class ServiceResource(ProxyResource):
    """The service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource identifier.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Resource location depends on the parent resource.
    :type location: str
    :param tags: A set of tags. Azure resource tags.
    :type tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~service_fabric_managed_clusters_management_client.models.SystemData
    :param properties: The service resource properties.
    :type properties:
     ~service_fabric_managed_clusters_management_client.models.ServiceResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ServiceResourceProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["ServiceResourceProperties"] = None,
        **kwargs
    ):
        super(ServiceResource, self).__init__(location=location, tags=tags, **kwargs)
        self.properties = properties


class ServiceResourceList(msrest.serialization.Model):
    """The list of service resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value:
    :type value: list[~service_fabric_managed_clusters_management_client.models.ServiceResource]
    :ivar next_link: URL to get the next set of service list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServiceResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ServiceResource"]] = None,
        **kwargs
    ):
        super(ServiceResourceList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ServiceResourcePropertiesBase(msrest.serialization.Model):
    """The common service resource properties.

    :param placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: A list that describes the correlation of the service with other
     services.
    :type correlation_scheme:
     list[~service_fabric_managed_clusters_management_client.models.ServiceCorrelation]
    :param service_load_metrics: The service load metrics is given as an array of ServiceLoadMetric
     objects.
    :type service_load_metrics:
     list[~service_fabric_managed_clusters_management_client.models.ServiceLoadMetric]
    :param service_placement_policies: A list that describes the correlation of the service with
     other services.
    :type service_placement_policies:
     list[~service_fabric_managed_clusters_management_client.models.ServicePlacementPolicy]
    :param default_move_cost: Specifies the move cost for the service. Possible values include:
     "Zero", "Low", "Medium", "High".
    :type default_move_cost: str or
     ~service_fabric_managed_clusters_management_client.models.MoveCost
    :param scaling_policies: Scaling policies for this service.
    :type scaling_policies:
     list[~service_fabric_managed_clusters_management_client.models.ScalingPolicy]
    """

    _attribute_map = {
        'placement_constraints': {'key': 'placementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'correlationScheme', 'type': '[ServiceCorrelation]'},
        'service_load_metrics': {'key': 'serviceLoadMetrics', 'type': '[ServiceLoadMetric]'},
        'service_placement_policies': {'key': 'servicePlacementPolicies', 'type': '[ServicePlacementPolicy]'},
        'default_move_cost': {'key': 'defaultMoveCost', 'type': 'str'},
        'scaling_policies': {'key': 'scalingPolicies', 'type': '[ScalingPolicy]'},
    }

    def __init__(
        self,
        *,
        placement_constraints: Optional[str] = None,
        correlation_scheme: Optional[List["ServiceCorrelation"]] = None,
        service_load_metrics: Optional[List["ServiceLoadMetric"]] = None,
        service_placement_policies: Optional[List["ServicePlacementPolicy"]] = None,
        default_move_cost: Optional[Union[str, "MoveCost"]] = None,
        scaling_policies: Optional[List["ScalingPolicy"]] = None,
        **kwargs
    ):
        super(ServiceResourcePropertiesBase, self).__init__(**kwargs)
        self.placement_constraints = placement_constraints
        self.correlation_scheme = correlation_scheme
        self.service_load_metrics = service_load_metrics
        self.service_placement_policies = service_placement_policies
        self.default_move_cost = default_move_cost
        self.scaling_policies = scaling_policies


class ServiceResourceProperties(ServiceResourcePropertiesBase):
    """The service resource properties.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StatefulServiceProperties, StatelessServiceProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: A list that describes the correlation of the service with other
     services.
    :type correlation_scheme:
     list[~service_fabric_managed_clusters_management_client.models.ServiceCorrelation]
    :param service_load_metrics: The service load metrics is given as an array of ServiceLoadMetric
     objects.
    :type service_load_metrics:
     list[~service_fabric_managed_clusters_management_client.models.ServiceLoadMetric]
    :param service_placement_policies: A list that describes the correlation of the service with
     other services.
    :type service_placement_policies:
     list[~service_fabric_managed_clusters_management_client.models.ServicePlacementPolicy]
    :param default_move_cost: Specifies the move cost for the service. Possible values include:
     "Zero", "Low", "Medium", "High".
    :type default_move_cost: str or
     ~service_fabric_managed_clusters_management_client.models.MoveCost
    :param scaling_policies: Scaling policies for this service.
    :type scaling_policies:
     list[~service_fabric_managed_clusters_management_client.models.ScalingPolicy]
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param service_kind: Required. The kind of service (Stateless or Stateful).Constant filled by
     server.  Possible values include: "Stateless", "Stateful".
    :type service_kind: str or
     ~service_fabric_managed_clusters_management_client.models.ServiceKind
    :param service_type_name: Required. The name of the service type.
    :type service_type_name: str
    :param partition_description: Required. Describes how the service is partitioned.
    :type partition_description:
     ~service_fabric_managed_clusters_management_client.models.Partition
    :param service_package_activation_mode: The activation Mode of the service package. Possible
     values include: "SharedProcess", "ExclusiveProcess".
    :type service_package_activation_mode: str or
     ~service_fabric_managed_clusters_management_client.models.ServicePackageActivationMode
    :param service_dns_name: The DNS name of the service. It requires the DNS system service to be
     enabled in Service Fabric cluster.
    :type service_dns_name: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'service_kind': {'required': True},
        'service_type_name': {'required': True},
        'partition_description': {'required': True},
    }

    _attribute_map = {
        'placement_constraints': {'key': 'placementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'correlationScheme', 'type': '[ServiceCorrelation]'},
        'service_load_metrics': {'key': 'serviceLoadMetrics', 'type': '[ServiceLoadMetric]'},
        'service_placement_policies': {'key': 'servicePlacementPolicies', 'type': '[ServicePlacementPolicy]'},
        'default_move_cost': {'key': 'defaultMoveCost', 'type': 'str'},
        'scaling_policies': {'key': 'scalingPolicies', 'type': '[ScalingPolicy]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'service_kind': {'key': 'serviceKind', 'type': 'str'},
        'service_type_name': {'key': 'serviceTypeName', 'type': 'str'},
        'partition_description': {'key': 'partitionDescription', 'type': 'Partition'},
        'service_package_activation_mode': {'key': 'servicePackageActivationMode', 'type': 'str'},
        'service_dns_name': {'key': 'serviceDnsName', 'type': 'str'},
    }

    _subtype_map = {
        'service_kind': {'Stateful': 'StatefulServiceProperties', 'Stateless': 'StatelessServiceProperties'}
    }

    def __init__(
        self,
        *,
        service_type_name: str,
        partition_description: "Partition",
        placement_constraints: Optional[str] = None,
        correlation_scheme: Optional[List["ServiceCorrelation"]] = None,
        service_load_metrics: Optional[List["ServiceLoadMetric"]] = None,
        service_placement_policies: Optional[List["ServicePlacementPolicy"]] = None,
        default_move_cost: Optional[Union[str, "MoveCost"]] = None,
        scaling_policies: Optional[List["ScalingPolicy"]] = None,
        service_package_activation_mode: Optional[Union[str, "ServicePackageActivationMode"]] = None,
        service_dns_name: Optional[str] = None,
        **kwargs
    ):
        super(ServiceResourceProperties, self).__init__(placement_constraints=placement_constraints, correlation_scheme=correlation_scheme, service_load_metrics=service_load_metrics, service_placement_policies=service_placement_policies, default_move_cost=default_move_cost, scaling_policies=scaling_policies, **kwargs)
        self.provisioning_state = None
        self.service_kind = 'ServiceResourceProperties'  # type: str
        self.service_type_name = service_type_name
        self.partition_description = partition_description
        self.service_package_activation_mode = service_package_activation_mode
        self.service_dns_name = service_dns_name


class ServiceTypeHealthPolicy(msrest.serialization.Model):
    """Represents the health policy used to evaluate the health of services belonging to a service type.

    All required parameters must be populated in order to send to Azure.

    :param max_percent_unhealthy_services: Required. The maximum allowed percentage of unhealthy
     services.
    
     The percentage represents the maximum tolerated percentage of services that can be unhealthy
     before the application is considered in error.
     If the percentage is respected but there is at least one unhealthy service, the health is
     evaluated as Warning.
     This is calculated by dividing the number of unhealthy services of the specific service type
     over the total number of services of the specific service type.
     The computation rounds up to tolerate one failure on small numbers of services.
    :type max_percent_unhealthy_services: int
    :param max_percent_unhealthy_partitions_per_service: Required. The maximum allowed percentage
     of unhealthy partitions per service.
    
     The percentage represents the maximum tolerated percentage of partitions that can be unhealthy
     before the service is considered in error.
     If the percentage is respected but there is at least one unhealthy partition, the health is
     evaluated as Warning.
     The percentage is calculated by dividing the number of unhealthy partitions over the total
     number of partitions in the service.
     The computation rounds up to tolerate one failure on small numbers of partitions.
    :type max_percent_unhealthy_partitions_per_service: int
    :param max_percent_unhealthy_replicas_per_partition: Required. The maximum allowed percentage
     of unhealthy replicas per partition.
    
     The percentage represents the maximum tolerated percentage of replicas that can be unhealthy
     before the partition is considered in error.
     If the percentage is respected but there is at least one unhealthy replica, the health is
     evaluated as Warning.
     The percentage is calculated by dividing the number of unhealthy replicas over the total
     number of replicas in the partition.
     The computation rounds up to tolerate one failure on small numbers of replicas.
    :type max_percent_unhealthy_replicas_per_partition: int
    """

    _validation = {
        'max_percent_unhealthy_services': {'required': True, 'maximum': 100, 'minimum': 0},
        'max_percent_unhealthy_partitions_per_service': {'required': True, 'maximum': 100, 'minimum': 0},
        'max_percent_unhealthy_replicas_per_partition': {'required': True, 'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'max_percent_unhealthy_services': {'key': 'maxPercentUnhealthyServices', 'type': 'int'},
        'max_percent_unhealthy_partitions_per_service': {'key': 'maxPercentUnhealthyPartitionsPerService', 'type': 'int'},
        'max_percent_unhealthy_replicas_per_partition': {'key': 'maxPercentUnhealthyReplicasPerPartition', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        max_percent_unhealthy_services: int,
        max_percent_unhealthy_partitions_per_service: int,
        max_percent_unhealthy_replicas_per_partition: int,
        **kwargs
    ):
        super(ServiceTypeHealthPolicy, self).__init__(**kwargs)
        self.max_percent_unhealthy_services = max_percent_unhealthy_services
        self.max_percent_unhealthy_partitions_per_service = max_percent_unhealthy_partitions_per_service
        self.max_percent_unhealthy_replicas_per_partition = max_percent_unhealthy_replicas_per_partition


class ServiceUpdateParameters(msrest.serialization.Model):
    """Service update request.

    :param tags: A set of tags. Service update parameters.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ServiceUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class SettingsParameterDescription(msrest.serialization.Model):
    """Describes a parameter in fabric settings of the cluster.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The parameter name of fabric setting.
    :type name: str
    :param value: Required. The parameter value of fabric setting.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        value: str,
        **kwargs
    ):
        super(SettingsParameterDescription, self).__init__(**kwargs)
        self.name = name
        self.value = value


class SettingsSectionDescription(msrest.serialization.Model):
    """Describes a section in the fabric settings of the cluster.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The section name of the fabric settings.
    :type name: str
    :param parameters: Required. The collection of parameters in the section.
    :type parameters:
     list[~service_fabric_managed_clusters_management_client.models.SettingsParameterDescription]
    """

    _validation = {
        'name': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[SettingsParameterDescription]'},
    }

    def __init__(
        self,
        *,
        name: str,
        parameters: List["SettingsParameterDescription"],
        **kwargs
    ):
        super(SettingsSectionDescription, self).__init__(**kwargs)
        self.name = name
        self.parameters = parameters


class SingletonPartitionScheme(Partition):
    """SingletonPartitionScheme.

    All required parameters must be populated in order to send to Azure.

    :param partition_scheme: Required. Specifies how the service is partitioned.Constant filled by
     server.  Possible values include: "Singleton", "UniformInt64Range", "Named".
    :type partition_scheme: str or
     ~service_fabric_managed_clusters_management_client.models.PartitionScheme
    """

    _validation = {
        'partition_scheme': {'required': True},
    }

    _attribute_map = {
        'partition_scheme': {'key': 'partitionScheme', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SingletonPartitionScheme, self).__init__(**kwargs)
        self.partition_scheme = 'Singleton'  # type: str


class Sku(msrest.serialization.Model):
    """Service Fabric managed cluster Sku definition.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Sku Name. Possible values include: "Basic", "Standard".
    :type name: str or ~service_fabric_managed_clusters_management_client.models.SkuName
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "SkuName"],
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name


class StatefulServiceProperties(ServiceResourceProperties):
    """The properties of a stateful service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: A list that describes the correlation of the service with other
     services.
    :type correlation_scheme:
     list[~service_fabric_managed_clusters_management_client.models.ServiceCorrelation]
    :param service_load_metrics: The service load metrics is given as an array of ServiceLoadMetric
     objects.
    :type service_load_metrics:
     list[~service_fabric_managed_clusters_management_client.models.ServiceLoadMetric]
    :param service_placement_policies: A list that describes the correlation of the service with
     other services.
    :type service_placement_policies:
     list[~service_fabric_managed_clusters_management_client.models.ServicePlacementPolicy]
    :param default_move_cost: Specifies the move cost for the service. Possible values include:
     "Zero", "Low", "Medium", "High".
    :type default_move_cost: str or
     ~service_fabric_managed_clusters_management_client.models.MoveCost
    :param scaling_policies: Scaling policies for this service.
    :type scaling_policies:
     list[~service_fabric_managed_clusters_management_client.models.ScalingPolicy]
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param service_kind: Required. The kind of service (Stateless or Stateful).Constant filled by
     server.  Possible values include: "Stateless", "Stateful".
    :type service_kind: str or
     ~service_fabric_managed_clusters_management_client.models.ServiceKind
    :param service_type_name: Required. The name of the service type.
    :type service_type_name: str
    :param partition_description: Required. Describes how the service is partitioned.
    :type partition_description:
     ~service_fabric_managed_clusters_management_client.models.Partition
    :param service_package_activation_mode: The activation Mode of the service package. Possible
     values include: "SharedProcess", "ExclusiveProcess".
    :type service_package_activation_mode: str or
     ~service_fabric_managed_clusters_management_client.models.ServicePackageActivationMode
    :param service_dns_name: The DNS name of the service. It requires the DNS system service to be
     enabled in Service Fabric cluster.
    :type service_dns_name: str
    :param has_persisted_state: A flag indicating whether this is a persistent service which stores
     states on the local disk. If it is then the value of this property is true, if not it is false.
    :type has_persisted_state: bool
    :param target_replica_set_size: The target replica set size as a number.
    :type target_replica_set_size: int
    :param min_replica_set_size: The minimum replica set size as a number.
    :type min_replica_set_size: int
    :param replica_restart_wait_duration: The duration between when a replica goes down and when a
     new replica is created, represented in ISO 8601 format "hh:mm:ss".
    :type replica_restart_wait_duration: str
    :param quorum_loss_wait_duration: The maximum duration for which a partition is allowed to be
     in a state of quorum loss, represented in ISO 8601 format "hh:mm:ss".
    :type quorum_loss_wait_duration: str
    :param stand_by_replica_keep_duration: The definition on how long StandBy replicas should be
     maintained before being removed, represented in ISO 8601 format "hh:mm:ss".
    :type stand_by_replica_keep_duration: str
    :param service_placement_time_limit: The duration for which replicas can stay InBuild before
     reporting that build is stuck, represented in ISO 8601 format "hh:mm:ss".
    :type service_placement_time_limit: str
    :param drop_source_replica_on_move: Indicates whether to drop source Secondary replica even if
     the target replica has not finished build. If desired behavior is to drop it as soon as
     possible the value of this property is true, if not it is false.
    :type drop_source_replica_on_move: bool
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'service_kind': {'required': True},
        'service_type_name': {'required': True},
        'partition_description': {'required': True},
        'target_replica_set_size': {'minimum': 1},
        'min_replica_set_size': {'minimum': 1},
    }

    _attribute_map = {
        'placement_constraints': {'key': 'placementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'correlationScheme', 'type': '[ServiceCorrelation]'},
        'service_load_metrics': {'key': 'serviceLoadMetrics', 'type': '[ServiceLoadMetric]'},
        'service_placement_policies': {'key': 'servicePlacementPolicies', 'type': '[ServicePlacementPolicy]'},
        'default_move_cost': {'key': 'defaultMoveCost', 'type': 'str'},
        'scaling_policies': {'key': 'scalingPolicies', 'type': '[ScalingPolicy]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'service_kind': {'key': 'serviceKind', 'type': 'str'},
        'service_type_name': {'key': 'serviceTypeName', 'type': 'str'},
        'partition_description': {'key': 'partitionDescription', 'type': 'Partition'},
        'service_package_activation_mode': {'key': 'servicePackageActivationMode', 'type': 'str'},
        'service_dns_name': {'key': 'serviceDnsName', 'type': 'str'},
        'has_persisted_state': {'key': 'hasPersistedState', 'type': 'bool'},
        'target_replica_set_size': {'key': 'targetReplicaSetSize', 'type': 'int'},
        'min_replica_set_size': {'key': 'minReplicaSetSize', 'type': 'int'},
        'replica_restart_wait_duration': {'key': 'replicaRestartWaitDuration', 'type': 'str'},
        'quorum_loss_wait_duration': {'key': 'quorumLossWaitDuration', 'type': 'str'},
        'stand_by_replica_keep_duration': {'key': 'standByReplicaKeepDuration', 'type': 'str'},
        'service_placement_time_limit': {'key': 'servicePlacementTimeLimit', 'type': 'str'},
        'drop_source_replica_on_move': {'key': 'dropSourceReplicaOnMove', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        service_type_name: str,
        partition_description: "Partition",
        placement_constraints: Optional[str] = None,
        correlation_scheme: Optional[List["ServiceCorrelation"]] = None,
        service_load_metrics: Optional[List["ServiceLoadMetric"]] = None,
        service_placement_policies: Optional[List["ServicePlacementPolicy"]] = None,
        default_move_cost: Optional[Union[str, "MoveCost"]] = None,
        scaling_policies: Optional[List["ScalingPolicy"]] = None,
        service_package_activation_mode: Optional[Union[str, "ServicePackageActivationMode"]] = None,
        service_dns_name: Optional[str] = None,
        has_persisted_state: Optional[bool] = None,
        target_replica_set_size: Optional[int] = None,
        min_replica_set_size: Optional[int] = None,
        replica_restart_wait_duration: Optional[str] = None,
        quorum_loss_wait_duration: Optional[str] = None,
        stand_by_replica_keep_duration: Optional[str] = None,
        service_placement_time_limit: Optional[str] = None,
        drop_source_replica_on_move: Optional[bool] = None,
        **kwargs
    ):
        super(StatefulServiceProperties, self).__init__(placement_constraints=placement_constraints, correlation_scheme=correlation_scheme, service_load_metrics=service_load_metrics, service_placement_policies=service_placement_policies, default_move_cost=default_move_cost, scaling_policies=scaling_policies, service_type_name=service_type_name, partition_description=partition_description, service_package_activation_mode=service_package_activation_mode, service_dns_name=service_dns_name, **kwargs)
        self.service_kind = 'Stateful'  # type: str
        self.has_persisted_state = has_persisted_state
        self.target_replica_set_size = target_replica_set_size
        self.min_replica_set_size = min_replica_set_size
        self.replica_restart_wait_duration = replica_restart_wait_duration
        self.quorum_loss_wait_duration = quorum_loss_wait_duration
        self.stand_by_replica_keep_duration = stand_by_replica_keep_duration
        self.service_placement_time_limit = service_placement_time_limit
        self.drop_source_replica_on_move = drop_source_replica_on_move


class StatelessServiceProperties(ServiceResourceProperties):
    """The properties of a stateless service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: A list that describes the correlation of the service with other
     services.
    :type correlation_scheme:
     list[~service_fabric_managed_clusters_management_client.models.ServiceCorrelation]
    :param service_load_metrics: The service load metrics is given as an array of ServiceLoadMetric
     objects.
    :type service_load_metrics:
     list[~service_fabric_managed_clusters_management_client.models.ServiceLoadMetric]
    :param service_placement_policies: A list that describes the correlation of the service with
     other services.
    :type service_placement_policies:
     list[~service_fabric_managed_clusters_management_client.models.ServicePlacementPolicy]
    :param default_move_cost: Specifies the move cost for the service. Possible values include:
     "Zero", "Low", "Medium", "High".
    :type default_move_cost: str or
     ~service_fabric_managed_clusters_management_client.models.MoveCost
    :param scaling_policies: Scaling policies for this service.
    :type scaling_policies:
     list[~service_fabric_managed_clusters_management_client.models.ScalingPolicy]
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param service_kind: Required. The kind of service (Stateless or Stateful).Constant filled by
     server.  Possible values include: "Stateless", "Stateful".
    :type service_kind: str or
     ~service_fabric_managed_clusters_management_client.models.ServiceKind
    :param service_type_name: Required. The name of the service type.
    :type service_type_name: str
    :param partition_description: Required. Describes how the service is partitioned.
    :type partition_description:
     ~service_fabric_managed_clusters_management_client.models.Partition
    :param service_package_activation_mode: The activation Mode of the service package. Possible
     values include: "SharedProcess", "ExclusiveProcess".
    :type service_package_activation_mode: str or
     ~service_fabric_managed_clusters_management_client.models.ServicePackageActivationMode
    :param service_dns_name: The DNS name of the service. It requires the DNS system service to be
     enabled in Service Fabric cluster.
    :type service_dns_name: str
    :param instance_count: Required. The instance count.
    :type instance_count: int
    :param min_instance_count: MinInstanceCount is the minimum number of instances that must be up
     to meet the EnsureAvailability safety check during operations like upgrade or deactivate node.
     The actual number that is used is max( MinInstanceCount, ceil( MinInstancePercentage/100.0 *
     InstanceCount) ). Note, if InstanceCount is set to -1, during MinInstanceCount computation -1
     is first converted into the number of nodes on which the instances are allowed to be placed
     according to the placement constraints on the service.
    :type min_instance_count: int
    :param min_instance_percentage: MinInstancePercentage is the minimum percentage of
     InstanceCount that must be up to meet the EnsureAvailability safety check during operations
     like upgrade or deactivate node. The actual number that is used is max( MinInstanceCount, ceil(
     MinInstancePercentage/100.0 * InstanceCount) ). Note, if InstanceCount is set to -1, during
     MinInstancePercentage computation, -1 is first converted into the number of nodes on which the
     instances are allowed to be placed according to the placement constraints on the service.
    :type min_instance_percentage: int
    :param instance_close_delay_duration: Duration represented in ISO 8601 format "hh:mm:ss", to
     wait before a stateless instance is closed, to allow the active requests to drain gracefully.
     This would be effective when the instance is closing during the application/cluster upgrade and
     disabling node. The endpoint exposed on this instance is removed prior to starting the delay,
     which prevents new connections to this instance. In addition, clients that have subscribed to
     service endpoint change
     events(https://docs.microsoft.com/dotnet/api/system.fabric.fabricclient.servicemanagementclient.registerservicenotificationfilterasync),
     can do the following upon receiving the endpoint removal notification: - Stop sending new
     requests to this instance. - Close existing connections after in-flight requests have
     completed. - Connect to a different instance of the service partition for future requests.
     Note, the default value of InstanceCloseDelayDuration is 0, which indicates that there won't be
     any delay or removal of the endpoint prior to closing the instance.
    :type instance_close_delay_duration: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'service_kind': {'required': True},
        'service_type_name': {'required': True},
        'partition_description': {'required': True},
        'instance_count': {'required': True, 'minimum': -1},
    }

    _attribute_map = {
        'placement_constraints': {'key': 'placementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'correlationScheme', 'type': '[ServiceCorrelation]'},
        'service_load_metrics': {'key': 'serviceLoadMetrics', 'type': '[ServiceLoadMetric]'},
        'service_placement_policies': {'key': 'servicePlacementPolicies', 'type': '[ServicePlacementPolicy]'},
        'default_move_cost': {'key': 'defaultMoveCost', 'type': 'str'},
        'scaling_policies': {'key': 'scalingPolicies', 'type': '[ScalingPolicy]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'service_kind': {'key': 'serviceKind', 'type': 'str'},
        'service_type_name': {'key': 'serviceTypeName', 'type': 'str'},
        'partition_description': {'key': 'partitionDescription', 'type': 'Partition'},
        'service_package_activation_mode': {'key': 'servicePackageActivationMode', 'type': 'str'},
        'service_dns_name': {'key': 'serviceDnsName', 'type': 'str'},
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
        'min_instance_count': {'key': 'minInstanceCount', 'type': 'int'},
        'min_instance_percentage': {'key': 'minInstancePercentage', 'type': 'int'},
        'instance_close_delay_duration': {'key': 'instanceCloseDelayDuration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        service_type_name: str,
        partition_description: "Partition",
        instance_count: int,
        placement_constraints: Optional[str] = None,
        correlation_scheme: Optional[List["ServiceCorrelation"]] = None,
        service_load_metrics: Optional[List["ServiceLoadMetric"]] = None,
        service_placement_policies: Optional[List["ServicePlacementPolicy"]] = None,
        default_move_cost: Optional[Union[str, "MoveCost"]] = None,
        scaling_policies: Optional[List["ScalingPolicy"]] = None,
        service_package_activation_mode: Optional[Union[str, "ServicePackageActivationMode"]] = None,
        service_dns_name: Optional[str] = None,
        min_instance_count: Optional[int] = None,
        min_instance_percentage: Optional[int] = None,
        instance_close_delay_duration: Optional[str] = "0",
        **kwargs
    ):
        super(StatelessServiceProperties, self).__init__(placement_constraints=placement_constraints, correlation_scheme=correlation_scheme, service_load_metrics=service_load_metrics, service_placement_policies=service_placement_policies, default_move_cost=default_move_cost, scaling_policies=scaling_policies, service_type_name=service_type_name, partition_description=partition_description, service_package_activation_mode=service_package_activation_mode, service_dns_name=service_dns_name, **kwargs)
        self.service_kind = 'Stateless'  # type: str
        self.instance_count = instance_count
        self.min_instance_count = min_instance_count
        self.min_instance_percentage = min_instance_percentage
        self.instance_close_delay_duration = instance_close_delay_duration


class SubResource(msrest.serialization.Model):
    """Azure resource identifier.

    :param id: Azure resource identifier.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = id


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource.
    :type created_by_type: str
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource.
    :type last_modified_by_type: str
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UniformInt64RangePartitionScheme(Partition):
    """Describes a partitioning scheme where an integer range is allocated evenly across a number of partitions.

    All required parameters must be populated in order to send to Azure.

    :param partition_scheme: Required. Specifies how the service is partitioned.Constant filled by
     server.  Possible values include: "Singleton", "UniformInt64Range", "Named".
    :type partition_scheme: str or
     ~service_fabric_managed_clusters_management_client.models.PartitionScheme
    :param count: Required. The number of partitions.
    :type count: int
    :param low_key: Required. The lower bound of the partition key range that
     should be split between the partition ‘Count’.
    :type low_key: long
    :param high_key: Required. The upper bound of the partition key range that
     should be split between the partition ‘Count’.
    :type high_key: long
    """

    _validation = {
        'partition_scheme': {'required': True},
        'count': {'required': True},
        'low_key': {'required': True},
        'high_key': {'required': True},
    }

    _attribute_map = {
        'partition_scheme': {'key': 'partitionScheme', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'low_key': {'key': 'lowKey', 'type': 'long'},
        'high_key': {'key': 'highKey', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        count: int,
        low_key: int,
        high_key: int,
        **kwargs
    ):
        super(UniformInt64RangePartitionScheme, self).__init__(**kwargs)
        self.partition_scheme = 'UniformInt64Range'  # type: str
        self.count = count
        self.low_key = low_key
        self.high_key = high_key


class UserAssignedIdentity(msrest.serialization.Model):
    """UserAssignedIdentity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserAssignedIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class VaultCertificate(msrest.serialization.Model):
    """Describes a single certificate reference in a Key Vault, and where the certificate should reside on the VM.

    All required parameters must be populated in order to send to Azure.

    :param certificate_url: Required. This is the URL of a certificate that has been uploaded to
     Key Vault as a secret. For adding a secret to the Key Vault, see `Add a key or secret to the
     key vault <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this
     case, your certificate needs to be It is the Base64 encoding of the following JSON Object which
     is encoded in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`  "data":":code:`<Base64-encoded-
     certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`  "password":":code:`<pfx-file-
     password>`":code:`<br>`}.
    :type certificate_url: str
    :param certificate_store: Required. For Windows VMs, specifies the certificate store on the
     Virtual Machine to which the certificate should be added. The specified certificate store is
     implicitly in the LocalMachine account. :code:`<br>`:code:`<br>`For Linux VMs, the certificate
     file is placed under the /var/lib/waagent directory, with the file name
     :code:`<UppercaseThumbprint>`.crt for the X509 certificate file and
     :code:`<UppercaseThumbprint>`.prv for private key. Both of these files are .pem formatted.
    :type certificate_store: str
    """

    _validation = {
        'certificate_url': {'required': True},
        'certificate_store': {'required': True},
    }

    _attribute_map = {
        'certificate_url': {'key': 'certificateUrl', 'type': 'str'},
        'certificate_store': {'key': 'certificateStore', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        certificate_url: str,
        certificate_store: str,
        **kwargs
    ):
        super(VaultCertificate, self).__init__(**kwargs)
        self.certificate_url = certificate_url
        self.certificate_store = certificate_store


class VaultSecretGroup(msrest.serialization.Model):
    """Specifies set of certificates that should be installed onto the virtual machines.

    All required parameters must be populated in order to send to Azure.

    :param source_vault: Required. The relative URL of the Key Vault containing all of the
     certificates in VaultCertificates.
    :type source_vault: ~service_fabric_managed_clusters_management_client.models.SubResource
    :param vault_certificates: Required. The list of key vault references in SourceVault which
     contain certificates.
    :type vault_certificates:
     list[~service_fabric_managed_clusters_management_client.models.VaultCertificate]
    """

    _validation = {
        'source_vault': {'required': True},
        'vault_certificates': {'required': True},
    }

    _attribute_map = {
        'source_vault': {'key': 'sourceVault', 'type': 'SubResource'},
        'vault_certificates': {'key': 'vaultCertificates', 'type': '[VaultCertificate]'},
    }

    def __init__(
        self,
        *,
        source_vault: "SubResource",
        vault_certificates: List["VaultCertificate"],
        **kwargs
    ):
        super(VaultSecretGroup, self).__init__(**kwargs)
        self.source_vault = source_vault
        self.vault_certificates = vault_certificates


class VmManagedIdentity(msrest.serialization.Model):
    """Identities for the virtual machine scale set under the node type.

    :param user_assigned_identities: The list of user identities associated with the virtual
     machine scale set under the node type. Each entry will be an ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: list[str]
    """

    _attribute_map = {
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        user_assigned_identities: Optional[List[str]] = None,
        **kwargs
    ):
        super(VmManagedIdentity, self).__init__(**kwargs)
        self.user_assigned_identities = user_assigned_identities


class VMSSExtension(msrest.serialization.Model):
    """Specifies set of extensions that should be installed onto the virtual machines.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the extension.
    :type name: str
    :param publisher: Required. The name of the extension handler publisher.
    :type publisher: str
    :param type: Required. Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Required. Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: object
    :param force_update_tag: If a value is provided and is different from the previous value, the
     extension handler will be forced to update even if the extension configuration has not changed.
    :type force_update_tag: str
    :param provision_after_extensions: Collection of extension names after which this extension
     needs to be provisioned.
    :type provision_after_extensions: list[str]
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    """

    _validation = {
        'name': {'required': True},
        'publisher': {'required': True},
        'type': {'required': True},
        'type_handler_version': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'provision_after_extensions': {'key': 'properties.provisionAfterExtensions', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        publisher: str,
        type: str,
        type_handler_version: str,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[object] = None,
        protected_settings: Optional[object] = None,
        force_update_tag: Optional[str] = None,
        provision_after_extensions: Optional[List[str]] = None,
        **kwargs
    ):
        super(VMSSExtension, self).__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings
        self.force_update_tag = force_update_tag
        self.provision_after_extensions = provision_after_extensions
        self.provisioning_state = None
