/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.value.StringValue;

public class ProcInstImpl
extends NodeImpl {
    String content;
    int nameCode;
    String systemId;
    int lineNumber = -1;

    public ProcInstImpl(int nameCode, String content) {
        this.nameCode = nameCode;
        this.content = content;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public String getStringValue() {
        return this.content;
    }

    public AtomicSequence atomize() {
        return new StringValue(this.getStringValue());
    }

    public final int getNodeKind() {
        return 7;
    }

    public void setLocation(String uri, int lineNumber) {
        this.systemId = uri;
        this.lineNumber = lineNumber;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void copy(Receiver out, int copyOptions, int locationId) throws XPathException {
        out.processingInstruction(this.getLocalPart(), this.content, locationId, 0);
    }

    public void rename(NodeName newNameCode) {
        this.nameCode = this.getNamePool().allocate("", "", newNameCode.getLocalPart());
    }

    public void replaceStringValue(CharSequence stringValue) {
        this.content = stringValue.toString();
    }
}

