/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.portfolio.optimizer;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.portfolioeffect.quant.client.portfolio.ArrayCache;
import com.portfolioeffect.quant.client.portfolio.Portfolio;
import com.portfolioeffect.quant.client.result.LazyMetric;
import com.portfolioeffect.quant.client.result.Metric;
import com.portfolioeffect.quant.client.util.SimpleMetricUpdateCallback;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TLongArrayList;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;

public class PortfolioOptimizer {
    private static final String METRIC_PORTFOLIO_OPTIMIZATION = "{\"metric\":\"PORTFOLIO_OPTIMIZATION\"}";
    protected Portfolio portfolio;
    protected Portfolio optimizedPortfolio = null;
    protected volatile Portfolio resultPortfolio = null;
    protected String paramsString = "";
    protected ArrayList<HashMap<String, String>> paramsBuffer = new ArrayList();
    private int constraintNumber = 0;
    private static AtomicLong constrainCount = new AtomicLong();
    private double errorInDecimalPoints;
    private double globalOptimumProbability;
    private int portfolioValue = -1;

    public PortfolioOptimizer(Portfolio portfolio) {
        this(portfolio, 1.0E-12, 0.99);
    }

    public PortfolioOptimizer(Portfolio portfolio, double errorInDecimalPoints, double globalOptimumProbability) {
        this.portfolio = portfolio;
        this.errorInDecimalPoints = errorInDecimalPoints;
        this.globalOptimumProbability = globalOptimumProbability;
    }

    public void setOptimizationGoal(String optimizationMetric, String direction) {
        HashMap<String, String> sb = this.populateRequiredOptimizationGoalParams(optimizationMetric, direction);
        sb.put("confidenceInterval", "0.95");
        this.setOptimizationGoal(sb);
    }

    public void setOptimizationGoal(String optimizationMetric, String direction, double confidenceInterval) {
        HashMap<String, String> sb = this.populateRequiredOptimizationGoalParams(optimizationMetric, direction);
        sb.put("confidenceInterval", "" + confidenceInterval);
        this.setOptimizationGoal(sb);
    }

    private HashMap<String, String> populateRequiredOptimizationGoalParams(String optimizationMetric, String direction) {
        HashMap<String, String> sb = new HashMap<String, String>();
        sb.put("optimizationMetric", optimizationMetric);
        sb.put("direction", direction);
        return sb;
    }

    private void setOptimizationGoal(HashMap<String, String> params) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("section", "GOAL");
        map.putAll(params);
        map.put("localOptimStopStep", "" + this.errorInDecimalPoints);
        map.put("globalOptimProbability", "" + this.globalOptimumProbability);
        this.paramsBuffer.add(map);
    }

    public void addPortfolioConstraint(String constraintName, double expectedValue) {
        HashMap<String, String> sb = new HashMap<String, String>();
        sb.put("constraintName", constraintName);
        sb.put("expectedValue", "" + expectedValue);
        this.addPortfolioConstraint(sb);
    }

    public void addPortfolioConstraint(String constraintName, TDoubleArrayList expectedValues, TLongArrayList timeMilliSec) {
        this.addPortfolioConstraint(constraintName, expectedValues.toArray(), timeMilliSec.toArray());
    }

    public void addPortfolioConstraint(String constraintName, double[] expectedValues, long[] timeMilliSec) {
        HashMap<String, String> sb = new HashMap<String, String>();
        String userDataName = "OptimizationConstraint" + this.portfolio.getNewDataId();
        this.portfolio.addUserData(userDataName, expectedValues, timeMilliSec);
        sb.put("constraintName", constraintName);
        sb.put("expectedValueDataName", userDataName);
        this.addPortfolioConstraint(sb);
    }

    public void addPortfolioConstraint(String constraintName, String[] positions) {
        HashMap<String, String> sb = new HashMap<String, String>();
        sb.put("constraintName", constraintName);
        if (positions.length != 0) {
            String positionList = "";
            String[] stringArray = positions;
            int n = positions.length;
            int n2 = 0;
            while (n2 < n) {
                String e = stringArray[n2];
                positionList = String.valueOf(positionList) + e + "---";
                ++n2;
            }
            sb.put("positions", positionList);
        }
        this.addPortfolioConstraint(sb);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, TDoubleArrayList expectedValues, TLongArrayList timeMilliSec, double confidenceInterval) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValues.toArray(), timeMilliSec.toArray(), confidenceInterval);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double[] expectedValues, long[] timeMilliSec, double confidenceInterval) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValues, timeMilliSec, confidenceInterval, new String[0]);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double expectedValue, double confidenceInterval) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValue, confidenceInterval, new String[0]);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double expectedValue) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValue, 0.95, new String[0]);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, TDoubleArrayList expectedValues, TLongArrayList timeMillisec) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValues.toArray(), timeMillisec.toArray());
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double[] expectedValues, long[] timeMillisec) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValues, timeMillisec, 0.95, new String[0]);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double expectedValue, double confidenceInterval, String position) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValue, confidenceInterval, new String[]{position});
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, TDoubleArrayList expectedValues, TLongArrayList timeMillisec, double confidenceInterval, String position) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValues.toArray(), timeMillisec.toArray(), confidenceInterval, position);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double[] expectedValues, long[] timeMillisec, double confidenceInterval, String position) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValues, timeMillisec, confidenceInterval, new String[]{position});
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double expectedValue, String[] positions) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValue, 0.95, positions);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, TDoubleArrayList expectedValues, TLongArrayList timeMillisec, String[] positions) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValues.toArray(), timeMillisec.toArray(), positions);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double[] expectedValues, long[] timeMillisec, String[] positions) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValues, timeMillisec, 0.95, positions);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double expectedValue, double confidenceInterval, String[] positions) {
        constraintType = this.getConstraintType(constraintType);
        HashMap<String, String> sb = new HashMap<String, String>();
        sb.put("constraintName", constraintName);
        sb.put("constraintType", constraintType);
        sb.put("confidenceInterval", "" + confidenceInterval);
        sb.put("expectedValue", "" + expectedValue);
        sb.put("expectedValueDataName", "expectedValueDataName-" + constrainCount.getAndIncrement());
        if (positions.length != 0) {
            String positionList = "";
            String[] stringArray = positions;
            int n = positions.length;
            int n2 = 0;
            while (n2 < n) {
                String e = stringArray[n2];
                positionList = String.valueOf(positionList) + e + "---";
                ++n2;
            }
            sb.put("positions", positionList);
        }
        this.addPortfolioConstraint(sb);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, TDoubleArrayList expectedValues, TLongArrayList timeMilliSec, double confidenceInterval, String[] positions) {
        this.addPortfolioConstraint(constraintName, constraintType, expectedValues.toArray(), timeMilliSec.toArray(), confidenceInterval, positions);
    }

    public void addPortfolioConstraint(String constraintName, String constraintType, double[] expectedValues, long[] timeMilliSec, double confidenceInterval, String[] positions) {
        constraintType = this.getConstraintType(constraintType);
        HashMap<String, String> sb = new HashMap<String, String>();
        String userDataName = "OptimizationConstraint" + this.portfolio.getNewDataId();
        this.portfolio.addUserData(userDataName, expectedValues, timeMilliSec);
        sb.put("constraintName", constraintName);
        sb.put("constraintType", constraintType);
        sb.put("confidenceInterval", "" + confidenceInterval);
        sb.put("expectedValueDataName", userDataName);
        if (positions.length != 0) {
            String positionList = "";
            String[] stringArray = positions;
            int n = positions.length;
            int n2 = 0;
            while (n2 < n) {
                String e = stringArray[n2];
                positionList = String.valueOf(positionList) + e + "---";
                ++n2;
            }
            sb.put("positions", positionList);
        }
        this.addPortfolioConstraint(sb);
    }

    private void addPortfolioConstraint(HashMap<String, String> params) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("section", "CONSTRAINT_" + this.constraintNumber++);
        map.putAll(params);
        this.paramsBuffer.add(map);
    }

    public String getParamsBuffer() {
        return this.paramsBuffer.toString();
    }

    public void addPositionConstraint(String constraintName, String constraintType, TDoubleArrayList expectedValues, TLongArrayList timeMilliSec, String positionName) {
        this.addPositionConstraint(constraintName, constraintType, expectedValues.toArray(), timeMilliSec.toArray(), positionName);
    }

    public void addPositionConstraint(String constraintName, String constraintType, double[] expectedValues, long[] timeMilliSec, String positionName) {
        constraintType = this.getConstraintType(constraintType);
        String userDataName = "OptimizationConstraint" + this.portfolio.getNewDataId();
        this.portfolio.addUserData(userDataName, expectedValues, timeMilliSec);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("section", "CONSTRAINT_" + this.constraintNumber++);
        map.put("position", positionName);
        map.put("constraintName", constraintName);
        map.put("constraintType", constraintType);
        map.put("expectedValueDataName", userDataName);
        this.paramsBuffer.add(map);
    }

    public void addPositionConstraint(String constraintName, String constraintType, double expectedValue, String positionName) {
        constraintType = this.getConstraintType(constraintType);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("section", "CONSTRAINT_" + this.constraintNumber++);
        map.put("position", positionName);
        map.put("constraintName", constraintName);
        map.put("constraintType", constraintType);
        map.put("expectedValueDataName", "expectedValueDataName-" + constrainCount.getAndIncrement());
        map.put("expectedValue", "" + expectedValue);
        this.paramsBuffer.add(map);
    }

    public void addPositionConstraint(String constraintName, String constraintType, TDoubleArrayList expectedValues, TLongArrayList timeMilliSec) {
        this.addPositionConstraint(constraintName, constraintType, expectedValues.toArray(), timeMilliSec.toArray());
    }

    public void addPositionConstraint(String constraintName, String constraintType, double[] expectedValues, long[] timeMilliSec) {
        constraintType = this.getConstraintType(constraintType);
        String userDataName = "OptimizationConstraint" + this.portfolio.getNewDataId();
        this.portfolio.addUserData(userDataName, expectedValues, timeMilliSec);
        String[] stringArray = this.portfolio.getSymbols();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String positionName = stringArray[n2];
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("section", "CONSTRAINT_" + this.constraintNumber++);
            map.put("position", positionName);
            map.put("constraintName", constraintName);
            map.put("constraintType", constraintType);
            map.put("expectedValueDataName", userDataName);
            this.paramsBuffer.add(map);
            ++n2;
        }
    }

    public void addPositionConstraint(String constraintName, String constraintType, double expectedValue) {
        constraintType = this.getConstraintType(constraintType);
        String[] stringArray = this.portfolio.getSymbols();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String positionName = stringArray[n2];
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("section", "CONSTRAINT_" + this.constraintNumber++);
            map.put("position", positionName);
            map.put("constraintName", constraintName);
            map.put("constraintType", constraintType);
            map.put("expectedValueDataName", "expectedValueDataName-" + constrainCount.getAndIncrement());
            map.put("expectedValue", "" + expectedValue);
            this.paramsBuffer.add(map);
            ++n2;
        }
    }

    public void addPositionConstraint(String constraintName, String constraintType, double expectedValue, String[] symbols) {
        constraintType = this.getConstraintType(constraintType);
        String[] stringArray = symbols;
        int n = symbols.length;
        int n2 = 0;
        while (n2 < n) {
            String positionName = stringArray[n2];
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("section", "CONSTRAINT_" + this.constraintNumber++);
            map.put("position", positionName);
            map.put("constraintName", constraintName);
            map.put("constraintType", constraintType);
            map.put("expectedValueDataName", "expectedValueDataName-" + constrainCount.getAndIncrement());
            map.put("expectedValue", "" + expectedValue);
            this.paramsBuffer.add(map);
            ++n2;
        }
    }

    public void addPositionConstraint(String constraintName, String positionName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("section", "CONSTRAINT_" + this.constraintNumber++);
        map.put("position", positionName);
        map.put("constraintName", constraintName);
        this.paramsBuffer.add(map);
    }

    public LazyMetric getOptimizedPortfolio() throws Exception {
        this.optimizedPortfolio = new Portfolio(this.portfolio);
        this.resultPortfolio = new Portfolio(this.portfolio);
        try {
            this.optimizationInit();
        }
        catch (Exception e1) {
            return new LazyMetric(e1.getMessage());
        }
        return this.makeOptimization();
    }

    public LazyMetric getOptimizedPortfolioStream() throws Exception {
        this.optimizedPortfolio = new Portfolio(this.portfolio);
        this.resultPortfolio = new Portfolio(this.portfolio);
        this.optimizedPortfolio.initStreamSingleMetric(new SimpleMetricUpdateCallback(){

            @Override
            public void onDataRefresh(float[] data, long[] time) {
                int nSymbols = PortfolioOptimizer.this.resultPortfolio.getSymbolNamesList().size();
                int len = 0;
                int i = 0;
                while (i < time.length) {
                    int k = 0;
                    while (k < nSymbols) {
                        PortfolioOptimizer.this.resultPortfolio.setStreamQuantity(PortfolioOptimizer.this.resultPortfolio.getSymbolNamesList().get(k), (int)data[len], time[i]);
                        ++len;
                        ++k;
                    }
                    ++i;
                }
            }
        });
        try {
            this.optimizationInit();
        }
        catch (Exception e1) {
            return new LazyMetric(e1.getMessage());
        }
        return this.makeOptimization();
    }

    public void stopStream() {
        this.optimizedPortfolio.stopStream();
    }

    protected LazyMetric makeOptimization() throws Exception {
        Metric checkResult = this.optimizedPortfolio.addUserData("portfolioValue", new double[]{this.portfolioValue}, new long[]{-1L});
        if (checkResult.hasError()) {
            return new LazyMetric(checkResult.getErrorMessage());
        }
        Metric result = this.optimizedPortfolio.getMetric(METRIC_PORTFOLIO_OPTIMIZATION, this.paramsString);
        if (!result.hasError()) {
            int nSymbols = this.optimizedPortfolio.getSymbolNamesList().size();
            try {
                result.getDataArrayCache("value").lockToRead();
                result.getDataArrayCache("time").lockToRead();
                ArrayCache[] quantity = ArrayCache.splitBatchDoubleMatrixToInt(result.getDataArrayCache("value"), nSymbols);
                int k = 0;
                while (k < nSymbols) {
                    this.resultPortfolio.setPositionQuantity(this.portfolio.getSymbolNamesList().get(k), quantity[k], ArrayCache.copyArrayCacheLong(result.getDataArrayCache("time")));
                    ++k;
                }
                result.getDataArrayCache("value").unlockToRead();
                result.getDataArrayCache("time").unlockToRead();
            }
            catch (IOException e) {
                return this.processException(e);
            }
        } else {
            this.optimizedPortfolio.getClient().createCallGroup(1);
            return new LazyMetric(result.getErrorMessage());
        }
        Metric resultOpt = new Metric();
        resultOpt.setPortfolio("portfolio", this.resultPortfolio);
        resultOpt.setInfoParams(result.getInfoParams());
        return new LazyMetric(resultOpt);
    }

    protected Portfolio optimizationInit(boolean isResultSelfPortfolio) throws Exception {
        if (this.portfolio.getSymbolNamesList().size() == 0) {
            throw new Exception("Empty portfolio");
        }
        Portfolio optimizedPortfolio = !isResultSelfPortfolio ? new Portfolio(this.portfolio) : this.portfolio;
        Gson gson = new Gson();
        this.paramsString = gson.toJson(this.paramsBuffer);
        return optimizedPortfolio;
    }

    protected void optimizationInit() throws Exception {
        if (this.portfolio.getSymbolNamesList().size() == 0) {
            throw new Exception("Empty portfolio");
        }
        Gson gson = new Gson();
        this.paramsString = gson.toJson(this.paramsBuffer);
    }

    protected LazyMetric processException(IOException e) {
        if (e.getMessage() != null) {
            return new LazyMetric(e.getMessage());
        }
        return new LazyMetric("Error while working with the local file system");
    }

    public void resetParams() {
        this.paramsString = "";
        this.constraintNumber = 0;
        this.paramsBuffer = new ArrayList();
    }

    public double getErrorInDecimalPoints() {
        return this.errorInDecimalPoints;
    }

    public void setErrorInDecimalPoints(double errorInDecimalPoints) {
        this.errorInDecimalPoints = errorInDecimalPoints;
    }

    public double getGlobalOptimumProbability() {
        return this.globalOptimumProbability;
    }

    public void setGlobalOptimumProbability(double globalOptimumProbability) {
        this.globalOptimumProbability = globalOptimumProbability;
    }

    public int getPortfolioValue() {
        return this.portfolioValue;
    }

    public void setPortfolioValue(int portfolioValue) {
        this.portfolioValue = portfolioValue;
    }

    private String getMetric(LazyMetric lazy) {
        return lazy.getMetricParams().get("metric").replace("PORTFOLIO_", "");
    }

    private String getSymbol(LazyMetric lazy) {
        return lazy.getMetricParams().get("position");
    }

    private String getConfidenceInterval(LazyMetric lazy) {
        return lazy.getMetricParams().get("confidenceInterval");
    }

    private String getConstraintType(String type) {
        if (type.equals("<=")) {
            return "lessOrEquals";
        }
        if (type.equals("=")) {
            return "equals";
        }
        if (type.equals(">=")) {
            return "greaterOrEquals";
        }
        return type;
    }

    private String getOptimizationMetricT(String goal) {
        if (goal.equals("Variance")) {
            return "VARIANCE";
        }
        if (goal.equals("VaR")) {
            return "VAR";
        }
        if (goal.equals("CVaR")) {
            return "CVAR";
        }
        if (goal.equals("ExpectedReturn")) {
            return "EXPECTED_RETURN";
        }
        if (goal.equals("Return")) {
            return "RETURN";
        }
        if (goal.equals("SharpeRatio")) {
            return "SHARPE_RATIO";
        }
        if (goal.equals("ModifiedSharpeRatio")) {
            return "MODIFIED_SHARPE_RATIO";
        }
        if (goal.equals("StarrRatio")) {
            return "STARR_RATIO";
        }
        if (goal.equals("ContraintsOnly")) {
            return "ZERO";
        }
        if (goal.equals("EquiWeight")) {
            return "NONE";
        }
        return goal;
    }

    public void setOptimizationGoal(LazyMetric lazy, String direction) {
        String optimizationMetric = this.getMetric(lazy);
        String confidenceInterval = this.getConfidenceInterval(lazy);
        HashMap<String, String> sb = this.populateRequiredOptimizationGoalParams(optimizationMetric, direction);
        if (confidenceInterval != null) {
            sb.put("confidenceInterval", confidenceInterval);
        } else {
            sb.put("confidenceInterval", "0,95");
        }
        this.setOptimizationGoal(sb);
    }

    public void addConstraint(LazyMetric lazy, String constraintType, TDoubleArrayList expectedValues, TLongArrayList timeMilliSec) {
        this.addConstraint(lazy, constraintType, expectedValues.toArray(), timeMilliSec.toArray());
    }

    public void addConstraint(LazyMetric lazy, String constraintType, double[] expectedValues, long[] timeMilliSec) {
        Type type;
        String positionsStr;
        Gson gson;
        ArrayList positions;
        String constraintName = this.getMetric(lazy);
        String positionName = this.getSymbol(lazy);
        String confidenceInterval = this.getConfidenceInterval(lazy);
        HashMap<String, String> sb = new HashMap<String, String>();
        constraintType = this.getConstraintType(constraintType);
        String userDataName = "OptimizationConstraint" + this.portfolio.getNewDataId();
        this.portfolio.addUserData(userDataName, expectedValues, timeMilliSec);
        if (positionName != null) {
            sb.put("position", positionName);
        }
        if (confidenceInterval != null) {
            sb.put("confidenceInterval", confidenceInterval);
        }
        sb.put("constraintName", constraintName);
        sb.put("constraintType", constraintType);
        sb.put("expectedValueDataName", userDataName);
        if (constraintName.equals("POSITIONS_SUM_ABS_WEIGHT") && (positions = (ArrayList)(gson = new Gson()).fromJson(positionsStr = lazy.getMetricParams().get("positions"), type = new TypeToken<ArrayList<String>>(){}.getType())).size() != 0) {
            String positionList = "";
            for (String e : positions) {
                positionList = String.valueOf(positionList) + e + "---";
            }
            sb.put("positions", positionList);
        }
        this.addPortfolioConstraint(sb);
    }

    public void addConstraint(LazyMetric lazy, String constraintType, double expectedValue) {
        Type type;
        String positionsStr;
        Gson gson;
        ArrayList positions;
        String constraintName = this.getMetric(lazy);
        if (constraintName.equals("VALUE")) {
            this.setPortfolioValue((int)expectedValue);
            return;
        }
        String positionName = this.getSymbol(lazy);
        String confidenceInterval = this.getConfidenceInterval(lazy);
        constraintType = this.getConstraintType(constraintType);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("section", "CONSTRAINT_" + this.constraintNumber++);
        if (positionName != null) {
            map.put("position", positionName);
        }
        if (confidenceInterval != null) {
            map.put("confidenceInterval", confidenceInterval);
        }
        map.put("constraintName", constraintName);
        map.put("constraintType", constraintType);
        map.put("expectedValueDataName", "expectedValueDataName-" + constrainCount.getAndIncrement());
        map.put("expectedValue", "" + expectedValue);
        if (constraintName.equals("POSITIONS_SUM_ABS_WEIGHT") && (positions = (ArrayList)(gson = new Gson()).fromJson(positionsStr = lazy.getMetricParams().get("positions"), type = new TypeToken<ArrayList<String>>(){}.getType())).size() != 0) {
            String positionList = "";
            for (String e : positions) {
                positionList = String.valueOf(positionList) + e + "---";
            }
            map.put("positions", positionList);
        }
        this.paramsBuffer.add(map);
    }
}

