/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.message.util;

import com.portfolioeffect.quant.client.message.type.EncryptMethodType;
import com.portfolioeffect.quant.client.message.type.EncryptedPasswordMethodType;
import org.openfast.DecimalValue;
import org.openfast.FieldValue;
import org.openfast.IntegerValue;
import org.openfast.Message;
import org.openfast.SequenceValue;
import org.openfast.template.MessageTemplate;
import org.openfast.template.Sequence;
import org.openfast.template.TemplateRegistry;

public class ClientRequestMessageFactory {
    public static Message createLogonRequest(TemplateRegistry templateRegistry, int heartBtInt, EncryptMethodType encryptMethodType, String username, String encryptedPassword, EncryptedPasswordMethodType encryptedPasswordMethodType, int encryptedPasswordLength, int msgSeqNum, long timestamp) {
        MessageTemplate template = templateRegistry.get("Logon");
        Message msg = new Message(template);
        msg.setString("Username", username);
        msg.setString("EncryptedPassword", encryptedPassword);
        msg.setInteger("EncryptedPasswordLen", encryptedPasswordLength);
        msg.setInteger("EncryptedPasswordMethod", encryptedPasswordMethodType.getCode());
        msg.setInteger("MsgSeqNum", msgSeqNum);
        msg.setInteger("EncryptMethod", encryptMethodType.getCode());
        msg.setInteger("HeartBtInt", heartBtInt);
        msg.setLong("SendingTime", timestamp);
        return msg;
    }

    public static Message createLogoutRequest(TemplateRegistry templateRegistry, int msgSeqNum, long timestamp) {
        MessageTemplate template = templateRegistry.get("Logout");
        Message msg = new Message(template);
        msg.setInteger("MsgSeqNum", msgSeqNum);
        msg.setLong("SendingTime", timestamp);
        return msg;
    }

    public static Message createHeartbeat(TemplateRegistry templateRegistry, int msgSeqNum, String testReqId) {
        MessageTemplate template = templateRegistry.get("Heartbeat");
        Message msg = new Message(template);
        msg.setInteger("MsgSeqNum", msgSeqNum);
        msg.setLong("SendingTime", System.currentTimeMillis());
        msg.setString("TestReqID", testReqId);
        return msg;
    }

    public static Message createTestUpdate(TemplateRegistry templateRegistry, double price, long time, long totalCount) {
        MessageTemplate template = templateRegistry.get("TestUpdate");
        Message msg = new Message(template);
        msg.setDecimal("Price", price);
        msg.setLong("Time", time);
        msg.setLong("TotalCount", totalCount);
        return msg;
    }

    public static Message createTestEcho(TemplateRegistry templateRegistry) {
        MessageTemplate template = templateRegistry.get("TestEcho");
        Message msg = new Message(template);
        return msg;
    }

    public static Message createNonparametricComputeRequest(TemplateRegistry templateRegistry, String requestType, String request, double[] price, int[] time, int msgSeqNum, long timestamp) {
        MessageTemplate template = templateRegistry.get("FunctionComputeRequest");
        Message msg = new Message(template);
        msg.setInteger("MsgSeqNum", msgSeqNum);
        msg.setLong("SendingTime", timestamp);
        msg.setString("Request", request);
        msg.setString("RequestType", requestType);
        Sequence sequence = template.getSequence("Data");
        SequenceValue sequenceValue = new SequenceValue(sequence);
        int i = 0;
        while (i < price.length) {
            FieldValue[] fieldValue = new FieldValue[2];
            int priceCent = (int)(price[i] * 100.0);
            fieldValue[0] = new IntegerValue(priceCent);
            fieldValue[1] = new IntegerValue(time[i]);
            sequenceValue.add(fieldValue);
            ++i;
        }
        msg.setFieldValue("Data", (FieldValue)sequenceValue);
        return msg;
    }

    public static Message createValidationRequest(TemplateRegistry templateRegistry, String request, int msgSeqNum, long timestamp) {
        MessageTemplate template = templateRegistry.get("IndicatorValidationRequest");
        Message msg = new Message(template);
        msg.setInteger("MsgSeqNum", msgSeqNum);
        msg.setLong("SendingTime", timestamp);
        msg.setString("Request", request);
        return msg;
    }

    public static Message createLoadDataRequest(TemplateRegistry templateRegistry, String requestType, String request, double[] data, int msgSeqNum, long timestamp) {
        MessageTemplate template = templateRegistry.get("LoadDataRequest");
        Message msg = new Message(template);
        msg.setInteger("MsgSeqNum", msgSeqNum);
        msg.setLong("SendingTime", timestamp);
        msg.setString("Request", request);
        msg.setString("RequestType", requestType);
        Sequence sequence = template.getSequence("Data");
        SequenceValue sequenceValue = new SequenceValue(sequence);
        int i = 0;
        while (i < data.length) {
            FieldValue[] fieldValue = new FieldValue[]{new DecimalValue(data[i])};
            sequenceValue.add(fieldValue);
            ++i;
        }
        msg.setFieldValue("Data", (FieldValue)sequenceValue);
        return msg;
    }

    public static Message createLoadDataRequest(TemplateRegistry templateRegistry, String requestType, String request, int[] data, int msgSeqNum, long timestamp) {
        MessageTemplate template = templateRegistry.get("LoadDataRequest");
        Message msg = new Message(template);
        msg.setInteger("MsgSeqNum", msgSeqNum);
        msg.setLong("SendingTime", timestamp);
        msg.setString("Request", request);
        msg.setString("RequestType", requestType);
        Sequence sequence = template.getSequence("Data");
        SequenceValue sequenceValue = new SequenceValue(sequence);
        int i = 0;
        while (i < data.length) {
            FieldValue[] fieldValue = new FieldValue[]{new DecimalValue(data[i])};
            sequenceValue.add(fieldValue);
            ++i;
        }
        msg.setFieldValue("Data", (FieldValue)sequenceValue);
        return msg;
    }

    public static Message createTransactionalPortfolioComputeRequest(TemplateRegistry templateRegistry, String requestType, String request, String params, int msgSeqNum, long timestamp) {
        MessageTemplate template = templateRegistry.get("TransactionalPortfolioComputeRequest");
        Message msg = new Message(template);
        msg.setInteger("MsgSeqNum", msgSeqNum);
        msg.setLong("SendingTime", timestamp);
        msg.setString("RequestType", requestType);
        msg.setString("Request", request);
        msg.setString("Params", params);
        return msg;
    }
}

