# Copyright 2020 StrongDM Inc
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import workflow_approvers_pb2 as workflow__approvers__pb2


class WorkflowApproversStub(object):
    """WorkflowApprovers is an account or a role with the ability to approve requests bound to a workflow.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Create = channel.unary_unary(
                '/v1.WorkflowApprovers/Create',
                request_serializer=workflow__approvers__pb2.WorkflowApproversCreateRequest.SerializeToString,
                response_deserializer=workflow__approvers__pb2.WorkflowApproversCreateResponse.FromString,
                )
        self.Get = channel.unary_unary(
                '/v1.WorkflowApprovers/Get',
                request_serializer=workflow__approvers__pb2.WorkflowApproverGetRequest.SerializeToString,
                response_deserializer=workflow__approvers__pb2.WorkflowApproverGetResponse.FromString,
                )
        self.Delete = channel.unary_unary(
                '/v1.WorkflowApprovers/Delete',
                request_serializer=workflow__approvers__pb2.WorkflowApproversDeleteRequest.SerializeToString,
                response_deserializer=workflow__approvers__pb2.WorkflowApproversDeleteResponse.FromString,
                )
        self.List = channel.unary_unary(
                '/v1.WorkflowApprovers/List',
                request_serializer=workflow__approvers__pb2.WorkflowApproversListRequest.SerializeToString,
                response_deserializer=workflow__approvers__pb2.WorkflowApproversListResponse.FromString,
                )


class WorkflowApproversServicer(object):
    """WorkflowApprovers is an account or a role with the ability to approve requests bound to a workflow.
    """

    def Create(self, request, context):
        """Create creates a new workflow approver
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Get(self, request, context):
        """Get reads one workflow approver by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Delete(self, request, context):
        """Delete deletes a workflow approver
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def List(self, request, context):
        """Lists existing workflow approvers.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_WorkflowApproversServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Create': grpc.unary_unary_rpc_method_handler(
                    servicer.Create,
                    request_deserializer=workflow__approvers__pb2.WorkflowApproversCreateRequest.FromString,
                    response_serializer=workflow__approvers__pb2.WorkflowApproversCreateResponse.SerializeToString,
            ),
            'Get': grpc.unary_unary_rpc_method_handler(
                    servicer.Get,
                    request_deserializer=workflow__approvers__pb2.WorkflowApproverGetRequest.FromString,
                    response_serializer=workflow__approvers__pb2.WorkflowApproverGetResponse.SerializeToString,
            ),
            'Delete': grpc.unary_unary_rpc_method_handler(
                    servicer.Delete,
                    request_deserializer=workflow__approvers__pb2.WorkflowApproversDeleteRequest.FromString,
                    response_serializer=workflow__approvers__pb2.WorkflowApproversDeleteResponse.SerializeToString,
            ),
            'List': grpc.unary_unary_rpc_method_handler(
                    servicer.List,
                    request_deserializer=workflow__approvers__pb2.WorkflowApproversListRequest.FromString,
                    response_serializer=workflow__approvers__pb2.WorkflowApproversListResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'v1.WorkflowApprovers', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class WorkflowApprovers(object):
    """WorkflowApprovers is an account or a role with the ability to approve requests bound to a workflow.
    """

    @staticmethod
    def Create(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.WorkflowApprovers/Create',
            workflow__approvers__pb2.WorkflowApproversCreateRequest.SerializeToString,
            workflow__approvers__pb2.WorkflowApproversCreateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Get(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.WorkflowApprovers/Get',
            workflow__approvers__pb2.WorkflowApproverGetRequest.SerializeToString,
            workflow__approvers__pb2.WorkflowApproverGetResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Delete(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.WorkflowApprovers/Delete',
            workflow__approvers__pb2.WorkflowApproversDeleteRequest.SerializeToString,
            workflow__approvers__pb2.WorkflowApproversDeleteResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def List(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.WorkflowApprovers/List',
            workflow__approvers__pb2.WorkflowApproversListRequest.SerializeToString,
            workflow__approvers__pb2.WorkflowApproversListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
