# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ExportPolicyRule(Model):
    """Volume Export Policy Rule.

    :param rule_index: Order index
    :type rule_index: int
    :param unix_read_only: Read only access
    :type unix_read_only: bool
    :param unix_read_write: Read and write access
    :type unix_read_write: bool
    :param cifs: Allows CIFS protocol
    :type cifs: bool
    :param nfsv3: Allows NFSv3 protocol
    :type nfsv3: bool
    :param nfsv4: Allows NFSv4 protocol
    :type nfsv4: bool
    :param allowed_clients: Client ingress specification as comma separated
     string with IPv4 CIDRs, IPv4 host addresses and host names
    :type allowed_clients: str
    """

    _attribute_map = {
        'rule_index': {'key': 'ruleIndex', 'type': 'int'},
        'unix_read_only': {'key': 'unixReadOnly', 'type': 'bool'},
        'unix_read_write': {'key': 'unixReadWrite', 'type': 'bool'},
        'cifs': {'key': 'cifs', 'type': 'bool'},
        'nfsv3': {'key': 'nfsv3', 'type': 'bool'},
        'nfsv4': {'key': 'nfsv4', 'type': 'bool'},
        'allowed_clients': {'key': 'allowedClients', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExportPolicyRule, self).__init__(**kwargs)
        self.rule_index = kwargs.get('rule_index', None)
        self.unix_read_only = kwargs.get('unix_read_only', None)
        self.unix_read_write = kwargs.get('unix_read_write', None)
        self.cifs = kwargs.get('cifs', None)
        self.nfsv3 = kwargs.get('nfsv3', None)
        self.nfsv4 = kwargs.get('nfsv4', None)
        self.allowed_clients = kwargs.get('allowed_clients', None)
