# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum

class AccountStatus(str, Enum):
    """The status indicating whether the primary location of the storage account is available or
    unavailable.
    """

    available = "Available"
    unavailable = "Unavailable"

class AccountType(str, Enum):
    """The sku name. Required for account creation; optional for update. Note that in older versions,
    sku name was called accountType.
    """

    standard_lrs = "Standard_LRS"
    standard_zrs = "Standard_ZRS"
    standard_grs = "Standard_GRS"
    standard_ragrs = "Standard_RAGRS"
    premium_lrs = "Premium_LRS"

class ProvisioningState(str, Enum):
    """The status of the storage account at the time the operation was called.
    """

    creating = "Creating"
    resolving_dns = "ResolvingDNS"
    succeeded = "Succeeded"

class Reason(str, Enum):
    """The reason that a storage account name could not be used. The Reason element is only returned
    if NameAvailable is false.
    """

    account_name_invalid = "AccountNameInvalid"
    already_exists = "AlreadyExists"

class UsageUnit(str, Enum):
    """The unit of measurement.
    """

    count = "Count"
    bytes = "Bytes"
    seconds = "Seconds"
    percent = "Percent"
    counts_per_second = "CountsPerSecond"
    bytes_per_second = "BytesPerSecond"
