# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._resource_management_client_enums import *


class AliasPathType(msrest.serialization.Model):
    """AliasPathType.

    :param path: The path of an alias.
    :type path: str
    :param api_versions: The api versions.
    :type api_versions: list[str]
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'api_versions': {'key': 'apiVersions', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        api_versions: Optional[List[str]] = None,
        **kwargs
    ):
        super(AliasPathType, self).__init__(**kwargs)
        self.path = path
        self.api_versions = api_versions


class AliasType(msrest.serialization.Model):
    """AliasType.

    :param name: The alias name.
    :type name: str
    :param paths: The paths for an alias.
    :type paths: list[~azure.mgmt.resource.resources.v2016_02_01.models.AliasPathType]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'paths': {'key': 'paths', 'type': '[AliasPathType]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        paths: Optional[List["AliasPathType"]] = None,
        **kwargs
    ):
        super(AliasType, self).__init__(**kwargs)
        self.name = name
        self.paths = paths


class BasicDependency(msrest.serialization.Model):
    """Deployment dependency information.

    :param id: The ID of the dependency.
    :type id: str
    :param resource_type: The dependency resource type.
    :type resource_type: str
    :param resource_name: The dependency resource name.
    :type resource_name: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        resource_type: Optional[str] = None,
        resource_name: Optional[str] = None,
        **kwargs
    ):
        super(BasicDependency, self).__init__(**kwargs)
        self.id = id
        self.resource_type = resource_type
        self.resource_name = resource_name


class DebugSetting(msrest.serialization.Model):
    """DebugSetting.

    :param detail_level: The debug detail level.
    :type detail_level: str
    """

    _attribute_map = {
        'detail_level': {'key': 'detailLevel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        detail_level: Optional[str] = None,
        **kwargs
    ):
        super(DebugSetting, self).__init__(**kwargs)
        self.detail_level = detail_level


class Dependency(msrest.serialization.Model):
    """Deployment dependency information.

    :param depends_on: The list of dependencies.
    :type depends_on: list[~azure.mgmt.resource.resources.v2016_02_01.models.BasicDependency]
    :param id: The ID of the dependency.
    :type id: str
    :param resource_type: The dependency resource type.
    :type resource_type: str
    :param resource_name: The dependency resource name.
    :type resource_name: str
    """

    _attribute_map = {
        'depends_on': {'key': 'dependsOn', 'type': '[BasicDependency]'},
        'id': {'key': 'id', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        depends_on: Optional[List["BasicDependency"]] = None,
        id: Optional[str] = None,
        resource_type: Optional[str] = None,
        resource_name: Optional[str] = None,
        **kwargs
    ):
        super(Dependency, self).__init__(**kwargs)
        self.depends_on = depends_on
        self.id = id
        self.resource_type = resource_type
        self.resource_name = resource_name


class Deployment(msrest.serialization.Model):
    """Deployment operation parameters.

    :param properties: The deployment properties.
    :type properties: ~azure.mgmt.resource.resources.v2016_02_01.models.DeploymentProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'DeploymentProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["DeploymentProperties"] = None,
        **kwargs
    ):
        super(Deployment, self).__init__(**kwargs)
        self.properties = properties


class DeploymentExportResult(msrest.serialization.Model):
    """DeploymentExportResult.

    :param template: The template content.
    :type template: object
    """

    _attribute_map = {
        'template': {'key': 'template', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        template: Optional[object] = None,
        **kwargs
    ):
        super(DeploymentExportResult, self).__init__(**kwargs)
        self.template = template


class DeploymentExtended(msrest.serialization.Model):
    """Deployment information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The ID of the deployment.
    :vartype id: str
    :param name: Required. The name of the deployment.
    :type name: str
    :param properties: Deployment properties.
    :type properties:
     ~azure.mgmt.resource.resources.v2016_02_01.models.DeploymentPropertiesExtended
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DeploymentPropertiesExtended'},
    }

    def __init__(
        self,
        *,
        name: str,
        properties: Optional["DeploymentPropertiesExtended"] = None,
        **kwargs
    ):
        super(DeploymentExtended, self).__init__(**kwargs)
        self.id = None
        self.name = name
        self.properties = properties


class DeploymentExtendedFilter(msrest.serialization.Model):
    """Deployment filter.

    :param provisioning_state: The provisioning state.
    :type provisioning_state: str
    """

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(DeploymentExtendedFilter, self).__init__(**kwargs)
        self.provisioning_state = provisioning_state


class DeploymentListResult(msrest.serialization.Model):
    """List of deployments.

    :param value: The list of deployments.
    :type value: list[~azure.mgmt.resource.resources.v2016_02_01.models.DeploymentExtended]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeploymentExtended]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DeploymentExtended"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DeploymentListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DeploymentOperation(msrest.serialization.Model):
    """Deployment operation information.

    :param id: Full deployment operation id.
    :type id: str
    :param operation_id: Deployment operation id.
    :type operation_id: str
    :param properties: Deployment properties.
    :type properties:
     ~azure.mgmt.resource.resources.v2016_02_01.models.DeploymentOperationProperties
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DeploymentOperationProperties'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        operation_id: Optional[str] = None,
        properties: Optional["DeploymentOperationProperties"] = None,
        **kwargs
    ):
        super(DeploymentOperation, self).__init__(**kwargs)
        self.id = id
        self.operation_id = operation_id
        self.properties = properties


class DeploymentOperationProperties(msrest.serialization.Model):
    """Deployment operation properties.

    :param provisioning_state: The state of the provisioning.
    :type provisioning_state: str
    :param timestamp: The date and time of the operation.
    :type timestamp: ~datetime.datetime
    :param service_request_id: Deployment operation service request id.
    :type service_request_id: str
    :param status_code: Operation status code.
    :type status_code: str
    :param status_message: Operation status message.
    :type status_message: object
    :param target_resource: The target resource.
    :type target_resource: ~azure.mgmt.resource.resources.v2016_02_01.models.TargetResource
    :param request: The HTTP request message.
    :type request: ~azure.mgmt.resource.resources.v2016_02_01.models.HttpMessage
    :param response: The HTTP response message.
    :type response: ~azure.mgmt.resource.resources.v2016_02_01.models.HttpMessage
    """

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'service_request_id': {'key': 'serviceRequestId', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'status_message': {'key': 'statusMessage', 'type': 'object'},
        'target_resource': {'key': 'targetResource', 'type': 'TargetResource'},
        'request': {'key': 'request', 'type': 'HttpMessage'},
        'response': {'key': 'response', 'type': 'HttpMessage'},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        service_request_id: Optional[str] = None,
        status_code: Optional[str] = None,
        status_message: Optional[object] = None,
        target_resource: Optional["TargetResource"] = None,
        request: Optional["HttpMessage"] = None,
        response: Optional["HttpMessage"] = None,
        **kwargs
    ):
        super(DeploymentOperationProperties, self).__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.timestamp = timestamp
        self.service_request_id = service_request_id
        self.status_code = status_code
        self.status_message = status_message
        self.target_resource = target_resource
        self.request = request
        self.response = response


class DeploymentOperationsListResult(msrest.serialization.Model):
    """List of deployment operations.

    :param value: The list of deployments.
    :type value: list[~azure.mgmt.resource.resources.v2016_02_01.models.DeploymentOperation]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeploymentOperation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DeploymentOperation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DeploymentOperationsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DeploymentProperties(msrest.serialization.Model):
    """Deployment properties.

    All required parameters must be populated in order to send to Azure.

    :param template: The template content. It can be a JObject or a well formed JSON string. Use
     only one of Template or TemplateLink.
    :type template: object
    :param template_link: The template URI. Use only one of Template or TemplateLink.
    :type template_link: ~azure.mgmt.resource.resources.v2016_02_01.models.TemplateLink
    :param parameters: Deployment parameters. It can be a JObject or a well formed JSON string. Use
     only one of Parameters or ParametersLink.
    :type parameters: object
    :param parameters_link: The parameters URI. Use only one of Parameters or ParametersLink.
    :type parameters_link: ~azure.mgmt.resource.resources.v2016_02_01.models.ParametersLink
    :param mode: Required. The deployment mode. Possible values include: "Incremental", "Complete".
    :type mode: str or ~azure.mgmt.resource.resources.v2016_02_01.models.DeploymentMode
    :param debug_setting: The debug setting of the deployment.
    :type debug_setting: ~azure.mgmt.resource.resources.v2016_02_01.models.DebugSetting
    """

    _validation = {
        'mode': {'required': True},
    }

    _attribute_map = {
        'template': {'key': 'template', 'type': 'object'},
        'template_link': {'key': 'templateLink', 'type': 'TemplateLink'},
        'parameters': {'key': 'parameters', 'type': 'object'},
        'parameters_link': {'key': 'parametersLink', 'type': 'ParametersLink'},
        'mode': {'key': 'mode', 'type': 'str'},
        'debug_setting': {'key': 'debugSetting', 'type': 'DebugSetting'},
    }

    def __init__(
        self,
        *,
        mode: Union[str, "DeploymentMode"],
        template: Optional[object] = None,
        template_link: Optional["TemplateLink"] = None,
        parameters: Optional[object] = None,
        parameters_link: Optional["ParametersLink"] = None,
        debug_setting: Optional["DebugSetting"] = None,
        **kwargs
    ):
        super(DeploymentProperties, self).__init__(**kwargs)
        self.template = template
        self.template_link = template_link
        self.parameters = parameters
        self.parameters_link = parameters_link
        self.mode = mode
        self.debug_setting = debug_setting


class DeploymentPropertiesExtended(msrest.serialization.Model):
    """Deployment properties with additional details.

    :param provisioning_state: The state of the provisioning.
    :type provisioning_state: str
    :param correlation_id: The correlation ID of the deployment.
    :type correlation_id: str
    :param timestamp: The timestamp of the template deployment.
    :type timestamp: ~datetime.datetime
    :param outputs: Key/value pairs that represent deployment output.
    :type outputs: object
    :param providers: The list of resource providers needed for the deployment.
    :type providers: list[~azure.mgmt.resource.resources.v2016_02_01.models.Provider]
    :param dependencies: The list of deployment dependencies.
    :type dependencies: list[~azure.mgmt.resource.resources.v2016_02_01.models.Dependency]
    :param template: The template content. Use only one of Template or TemplateLink.
    :type template: object
    :param template_link: The URI referencing the template. Use only one of Template or
     TemplateLink.
    :type template_link: ~azure.mgmt.resource.resources.v2016_02_01.models.TemplateLink
    :param parameters: Deployment parameters. Use only one of Parameters or ParametersLink.
    :type parameters: object
    :param parameters_link: The URI referencing the parameters. Use only one of Parameters or
     ParametersLink.
    :type parameters_link: ~azure.mgmt.resource.resources.v2016_02_01.models.ParametersLink
    :param mode: The deployment mode. Possible values include: "Incremental", "Complete".
    :type mode: str or ~azure.mgmt.resource.resources.v2016_02_01.models.DeploymentMode
    :param debug_setting: The debug setting of the deployment.
    :type debug_setting: ~azure.mgmt.resource.resources.v2016_02_01.models.DebugSetting
    """

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'outputs': {'key': 'outputs', 'type': 'object'},
        'providers': {'key': 'providers', 'type': '[Provider]'},
        'dependencies': {'key': 'dependencies', 'type': '[Dependency]'},
        'template': {'key': 'template', 'type': 'object'},
        'template_link': {'key': 'templateLink', 'type': 'TemplateLink'},
        'parameters': {'key': 'parameters', 'type': 'object'},
        'parameters_link': {'key': 'parametersLink', 'type': 'ParametersLink'},
        'mode': {'key': 'mode', 'type': 'str'},
        'debug_setting': {'key': 'debugSetting', 'type': 'DebugSetting'},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[str] = None,
        correlation_id: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        outputs: Optional[object] = None,
        providers: Optional[List["Provider"]] = None,
        dependencies: Optional[List["Dependency"]] = None,
        template: Optional[object] = None,
        template_link: Optional["TemplateLink"] = None,
        parameters: Optional[object] = None,
        parameters_link: Optional["ParametersLink"] = None,
        mode: Optional[Union[str, "DeploymentMode"]] = None,
        debug_setting: Optional["DebugSetting"] = None,
        **kwargs
    ):
        super(DeploymentPropertiesExtended, self).__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.correlation_id = correlation_id
        self.timestamp = timestamp
        self.outputs = outputs
        self.providers = providers
        self.dependencies = dependencies
        self.template = template
        self.template_link = template_link
        self.parameters = parameters
        self.parameters_link = parameters_link
        self.mode = mode
        self.debug_setting = debug_setting


class DeploymentValidateResult(msrest.serialization.Model):
    """Information from validate template deployment response.

    :param error: Validation error.
    :type error:
     ~azure.mgmt.resource.resources.v2016_02_01.models.ResourceManagementErrorWithDetails
    :param properties: The template deployment properties.
    :type properties:
     ~azure.mgmt.resource.resources.v2016_02_01.models.DeploymentPropertiesExtended
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ResourceManagementErrorWithDetails'},
        'properties': {'key': 'properties', 'type': 'DeploymentPropertiesExtended'},
    }

    def __init__(
        self,
        *,
        error: Optional["ResourceManagementErrorWithDetails"] = None,
        properties: Optional["DeploymentPropertiesExtended"] = None,
        **kwargs
    ):
        super(DeploymentValidateResult, self).__init__(**kwargs)
        self.error = error
        self.properties = properties


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: object
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.resource.resources.v2016_02_01.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.resource.resources.v2016_02_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ExportTemplateRequest(msrest.serialization.Model):
    """Export resource group template request parameters.

    :param resources: The IDs of the resources to filter the export by. To export all resources,
     supply an array with single entry '*'.
    :type resources: list[str]
    :param options: The export template options. A CSV-formatted list containing zero or more of
     the following: 'IncludeParameterDefaultValue', 'IncludeComments',
     'SkipResourceNameParameterization', 'SkipAllParameterization'.
    :type options: str
    """

    _attribute_map = {
        'resources': {'key': 'resources', 'type': '[str]'},
        'options': {'key': 'options', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resources: Optional[List[str]] = None,
        options: Optional[str] = None,
        **kwargs
    ):
        super(ExportTemplateRequest, self).__init__(**kwargs)
        self.resources = resources
        self.options = options


class Resource(msrest.serialization.Model):
    """Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class GenericResource(Resource):
    """Resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param plan: The plan of the resource.
    :type plan: ~azure.mgmt.resource.resources.v2016_02_01.models.Plan
    :param properties: The resource properties.
    :type properties: object
    :param kind: The kind of the resource.
    :type kind: str
    :param managed_by: Id of the resource that manages this resource.
    :type managed_by: str
    :param sku: The sku of the resource.
    :type sku: ~azure.mgmt.resource.resources.v2016_02_01.models.Sku
    :param identity: The identity of the resource.
    :type identity: ~azure.mgmt.resource.resources.v2016_02_01.models.Identity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'properties': {'key': 'properties', 'type': 'object'},
        'kind': {'key': 'kind', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'identity': {'key': 'identity', 'type': 'Identity'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["Plan"] = None,
        properties: Optional[object] = None,
        kind: Optional[str] = None,
        managed_by: Optional[str] = None,
        sku: Optional["Sku"] = None,
        identity: Optional["Identity"] = None,
        **kwargs
    ):
        super(GenericResource, self).__init__(location=location, tags=tags, **kwargs)
        self.plan = plan
        self.properties = properties
        self.kind = kind
        self.managed_by = managed_by
        self.sku = sku
        self.identity = identity


class GenericResourceExpanded(GenericResource):
    """Resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param plan: The plan of the resource.
    :type plan: ~azure.mgmt.resource.resources.v2016_02_01.models.Plan
    :param properties: The resource properties.
    :type properties: object
    :param kind: The kind of the resource.
    :type kind: str
    :param managed_by: Id of the resource that manages this resource.
    :type managed_by: str
    :param sku: The sku of the resource.
    :type sku: ~azure.mgmt.resource.resources.v2016_02_01.models.Sku
    :param identity: The identity of the resource.
    :type identity: ~azure.mgmt.resource.resources.v2016_02_01.models.Identity
    :ivar created_time: The created time of the resource. This is only present if requested via the
     $expand query parameter.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: The changed time of the resource. This is only present if requested via the
     $expand query parameter.
    :vartype changed_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the resource. This is only present if
     requested via the $expand query parameter.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'properties': {'key': 'properties', 'type': 'object'},
        'kind': {'key': 'kind', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'changedTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["Plan"] = None,
        properties: Optional[object] = None,
        kind: Optional[str] = None,
        managed_by: Optional[str] = None,
        sku: Optional["Sku"] = None,
        identity: Optional["Identity"] = None,
        **kwargs
    ):
        super(GenericResourceExpanded, self).__init__(location=location, tags=tags, plan=plan, properties=properties, kind=kind, managed_by=managed_by, sku=sku, identity=identity, **kwargs)
        self.created_time = None
        self.changed_time = None
        self.provisioning_state = None


class GenericResourceFilter(msrest.serialization.Model):
    """Resource filter.

    :param resource_type: The resource type.
    :type resource_type: str
    :param tagname: The tag name.
    :type tagname: str
    :param tagvalue: The tag value.
    :type tagvalue: str
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'tagname': {'key': 'tagname', 'type': 'str'},
        'tagvalue': {'key': 'tagvalue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        tagname: Optional[str] = None,
        tagvalue: Optional[str] = None,
        **kwargs
    ):
        super(GenericResourceFilter, self).__init__(**kwargs)
        self.resource_type = resource_type
        self.tagname = tagname
        self.tagvalue = tagvalue


class HttpMessage(msrest.serialization.Model):
    """HttpMessage.

    :param content: HTTP message content.
    :type content: object
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        content: Optional[object] = None,
        **kwargs
    ):
        super(HttpMessage, self).__init__(**kwargs)
        self.content = content


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Default value: "SystemAssigned".
    :vartype type: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'constant': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "SystemAssigned"

    def __init__(
        self,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None


class ParametersLink(msrest.serialization.Model):
    """Entity representing the reference to the deployment parameters.

    All required parameters must be populated in order to send to Azure.

    :param uri: Required. URI referencing the template.
    :type uri: str
    :param content_version: If included it must match the ContentVersion in the template.
    :type content_version: str
    """

    _validation = {
        'uri': {'required': True},
    }

    _attribute_map = {
        'uri': {'key': 'uri', 'type': 'str'},
        'content_version': {'key': 'contentVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: str,
        content_version: Optional[str] = None,
        **kwargs
    ):
        super(ParametersLink, self).__init__(**kwargs)
        self.uri = uri
        self.content_version = content_version


class Plan(msrest.serialization.Model):
    """Plan for the resource.

    :param name: The plan ID.
    :type name: str
    :param publisher: The publisher ID.
    :type publisher: str
    :param product: The offer ID.
    :type product: str
    :param promotion_code: The promotion code.
    :type promotion_code: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
        'promotion_code': {'key': 'promotionCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        promotion_code: Optional[str] = None,
        **kwargs
    ):
        super(Plan, self).__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code


class Provider(msrest.serialization.Model):
    """Resource provider information.

    :param id: The provider id.
    :type id: str
    :param namespace: The namespace of the provider.
    :type namespace: str
    :param registration_state: The registration state of the provider.
    :type registration_state: str
    :param resource_types: The collection of provider resource types.
    :type resource_types:
     list[~azure.mgmt.resource.resources.v2016_02_01.models.ProviderResourceType]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
        'registration_state': {'key': 'registrationState', 'type': 'str'},
        'resource_types': {'key': 'resourceTypes', 'type': '[ProviderResourceType]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        namespace: Optional[str] = None,
        registration_state: Optional[str] = None,
        resource_types: Optional[List["ProviderResourceType"]] = None,
        **kwargs
    ):
        super(Provider, self).__init__(**kwargs)
        self.id = id
        self.namespace = namespace
        self.registration_state = registration_state
        self.resource_types = resource_types


class ProviderListResult(msrest.serialization.Model):
    """List of resource providers.

    :param value: The list of resource providers.
    :type value: list[~azure.mgmt.resource.resources.v2016_02_01.models.Provider]
    :param next_link: The URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Provider]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Provider"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ProviderListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProviderResourceType(msrest.serialization.Model):
    """Resource type managed by the resource provider.

    :param resource_type: The resource type.
    :type resource_type: str
    :param locations: The collection of locations where this resource type can be created in.
    :type locations: list[str]
    :param aliases: The aliases that are supported by this resource type.
    :type aliases: list[~azure.mgmt.resource.resources.v2016_02_01.models.AliasType]
    :param api_versions: The api version.
    :type api_versions: list[str]
    :param properties: The properties.
    :type properties: dict[str, str]
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'aliases': {'key': 'aliases', 'type': '[AliasType]'},
        'api_versions': {'key': 'apiVersions', 'type': '[str]'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        locations: Optional[List[str]] = None,
        aliases: Optional[List["AliasType"]] = None,
        api_versions: Optional[List[str]] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ProviderResourceType, self).__init__(**kwargs)
        self.resource_type = resource_type
        self.locations = locations
        self.aliases = aliases
        self.api_versions = api_versions
        self.properties = properties


class ResourceGroup(msrest.serialization.Model):
    """Resource group information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The ID of the resource group.
    :vartype id: str
    :param name: The Name of the resource group.
    :type name: str
    :param properties: The resource group properties.
    :type properties: ~azure.mgmt.resource.resources.v2016_02_01.models.ResourceGroupProperties
    :param location: Required. The location of the resource group. It cannot be changed after the
     resource group has been created. Has to be one of the supported Azure Locations, such as West
     US, East US, West Europe, East Asia, etc.
    :type location: str
    :param tags: A set of tags. The tags attached to the resource group.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ResourceGroupProperties'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        name: Optional[str] = None,
        properties: Optional["ResourceGroupProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ResourceGroup, self).__init__(**kwargs)
        self.id = None
        self.name = name
        self.properties = properties
        self.location = location
        self.tags = tags


class ResourceGroupExportResult(msrest.serialization.Model):
    """ResourceGroupExportResult.

    :param template: The template content.
    :type template: object
    :param error: The error.
    :type error:
     ~azure.mgmt.resource.resources.v2016_02_01.models.ResourceManagementErrorWithDetails
    """

    _attribute_map = {
        'template': {'key': 'template', 'type': 'object'},
        'error': {'key': 'error', 'type': 'ResourceManagementErrorWithDetails'},
    }

    def __init__(
        self,
        *,
        template: Optional[object] = None,
        error: Optional["ResourceManagementErrorWithDetails"] = None,
        **kwargs
    ):
        super(ResourceGroupExportResult, self).__init__(**kwargs)
        self.template = template
        self.error = error


class ResourceGroupFilter(msrest.serialization.Model):
    """Resource group filter.

    :param tag_name: The tag name.
    :type tag_name: str
    :param tag_value: The tag value.
    :type tag_value: str
    """

    _attribute_map = {
        'tag_name': {'key': 'tagName', 'type': 'str'},
        'tag_value': {'key': 'tagValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tag_name: Optional[str] = None,
        tag_value: Optional[str] = None,
        **kwargs
    ):
        super(ResourceGroupFilter, self).__init__(**kwargs)
        self.tag_name = tag_name
        self.tag_value = tag_value


class ResourceGroupListResult(msrest.serialization.Model):
    """List of resource groups.

    All required parameters must be populated in order to send to Azure.

    :param value: The list of resource groups.
    :type value: list[~azure.mgmt.resource.resources.v2016_02_01.models.ResourceGroup]
    :param next_link: Required. The URL to get the next set of results.
    :type next_link: str
    """

    _validation = {
        'next_link': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: str,
        value: Optional[List["ResourceGroup"]] = None,
        **kwargs
    ):
        super(ResourceGroupListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ResourceGroupProperties(msrest.serialization.Model):
    """The resource group properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceGroupProperties, self).__init__(**kwargs)
        self.provisioning_state = None


class ResourceListResult(msrest.serialization.Model):
    """List of resource groups.

    All required parameters must be populated in order to send to Azure.

    :param value: The list of resources.
    :type value: list[~azure.mgmt.resource.resources.v2016_02_01.models.GenericResourceExpanded]
    :param next_link: Required. The URL to get the next set of results.
    :type next_link: str
    """

    _validation = {
        'next_link': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GenericResourceExpanded]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: str,
        value: Optional[List["GenericResourceExpanded"]] = None,
        **kwargs
    ):
        super(ResourceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ResourceManagementErrorWithDetails(msrest.serialization.Model):
    """ResourceManagementErrorWithDetails.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. The error code returned from the server.
    :type code: str
    :param message: Required. The error message returned from the server.
    :type message: str
    :param target: The target of the error.
    :type target: str
    :param details: Validation error.
    :type details:
     list[~azure.mgmt.resource.resources.v2016_02_01.models.ResourceManagementErrorWithDetails]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ResourceManagementErrorWithDetails]'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        details: Optional[List["ResourceManagementErrorWithDetails"]] = None,
        **kwargs
    ):
        super(ResourceManagementErrorWithDetails, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ResourceProviderOperationDisplayProperties(msrest.serialization.Model):
    """Resource provider operation's display properties.

    :param publisher: Operation description.
    :type publisher: str
    :param provider: Operation provider.
    :type provider: str
    :param resource: Operation resource.
    :type resource: str
    :param operation: Operation.
    :type operation: str
    :param description: Operation description.
    :type description: str
    """

    _attribute_map = {
        'publisher': {'key': 'publisher', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(ResourceProviderOperationDisplayProperties, self).__init__(**kwargs)
        self.publisher = publisher
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ResourcesMoveInfo(msrest.serialization.Model):
    """Parameters of move resources.

    :param resources: The ids of the resources.
    :type resources: list[str]
    :param target_resource_group: The target resource group.
    :type target_resource_group: str
    """

    _attribute_map = {
        'resources': {'key': 'resources', 'type': '[str]'},
        'target_resource_group': {'key': 'targetResourceGroup', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resources: Optional[List[str]] = None,
        target_resource_group: Optional[str] = None,
        **kwargs
    ):
        super(ResourcesMoveInfo, self).__init__(**kwargs)
        self.resources = resources
        self.target_resource_group = target_resource_group


class Sku(msrest.serialization.Model):
    """Sku for the resource.

    :param name: The sku name.
    :type name: str
    :param tier: The sku tier.
    :type tier: str
    :param size: The sku size.
    :type size: str
    :param family: The sku family.
    :type family: str
    :param model: The sku model.
    :type model: str
    :param capacity: The sku capacity.
    :type capacity: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'model': {'key': 'model', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        model: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.model = model
        self.capacity = capacity


class SubResource(msrest.serialization.Model):
    """SubResource.

    :param id: Resource Id.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = id


class TagCount(msrest.serialization.Model):
    """Tag count.

    :param type: Type of count.
    :type type: str
    :param value: Value of count.
    :type value: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(TagCount, self).__init__(**kwargs)
        self.type = type
        self.value = value


class TagDetails(msrest.serialization.Model):
    """Tag details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The tag ID.
    :vartype id: str
    :param tag_name: The tag name.
    :type tag_name: str
    :param count: The tag count.
    :type count: ~azure.mgmt.resource.resources.v2016_02_01.models.TagCount
    :param values: The list of tag values.
    :type values: list[~azure.mgmt.resource.resources.v2016_02_01.models.TagValue]
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'tag_name': {'key': 'tagName', 'type': 'str'},
        'count': {'key': 'count', 'type': 'TagCount'},
        'values': {'key': 'values', 'type': '[TagValue]'},
    }

    def __init__(
        self,
        *,
        tag_name: Optional[str] = None,
        count: Optional["TagCount"] = None,
        values: Optional[List["TagValue"]] = None,
        **kwargs
    ):
        super(TagDetails, self).__init__(**kwargs)
        self.id = None
        self.tag_name = tag_name
        self.count = count
        self.values = values


class TagsListResult(msrest.serialization.Model):
    """List of subscription tags.

    All required parameters must be populated in order to send to Azure.

    :param value: The list of tags.
    :type value: list[~azure.mgmt.resource.resources.v2016_02_01.models.TagDetails]
    :param next_link: Required. The URL to get the next set of results.
    :type next_link: str
    """

    _validation = {
        'next_link': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TagDetails]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: str,
        value: Optional[List["TagDetails"]] = None,
        **kwargs
    ):
        super(TagsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TagValue(msrest.serialization.Model):
    """Tag information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The tag ID.
    :vartype id: str
    :param tag_value: The tag value.
    :type tag_value: str
    :param count: The tag value count.
    :type count: ~azure.mgmt.resource.resources.v2016_02_01.models.TagCount
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'tag_value': {'key': 'tagValue', 'type': 'str'},
        'count': {'key': 'count', 'type': 'TagCount'},
    }

    def __init__(
        self,
        *,
        tag_value: Optional[str] = None,
        count: Optional["TagCount"] = None,
        **kwargs
    ):
        super(TagValue, self).__init__(**kwargs)
        self.id = None
        self.tag_value = tag_value
        self.count = count


class TargetResource(msrest.serialization.Model):
    """Target resource.

    :param id: The ID of the resource.
    :type id: str
    :param resource_name: The name of the resource.
    :type resource_name: str
    :param resource_type: The type of the resource.
    :type resource_type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        resource_name: Optional[str] = None,
        resource_type: Optional[str] = None,
        **kwargs
    ):
        super(TargetResource, self).__init__(**kwargs)
        self.id = id
        self.resource_name = resource_name
        self.resource_type = resource_type


class TemplateHashResult(msrest.serialization.Model):
    """Result of the request to calculate template hash. It contains a string of minified template and its hash.

    :param minified_template: The minified template string.
    :type minified_template: str
    :param template_hash: The template hash.
    :type template_hash: str
    """

    _attribute_map = {
        'minified_template': {'key': 'minifiedTemplate', 'type': 'str'},
        'template_hash': {'key': 'templateHash', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        minified_template: Optional[str] = None,
        template_hash: Optional[str] = None,
        **kwargs
    ):
        super(TemplateHashResult, self).__init__(**kwargs)
        self.minified_template = minified_template
        self.template_hash = template_hash


class TemplateLink(msrest.serialization.Model):
    """Entity representing the reference to the template.

    All required parameters must be populated in order to send to Azure.

    :param uri: Required. URI referencing the template.
    :type uri: str
    :param content_version: If included it must match the ContentVersion in the template.
    :type content_version: str
    """

    _validation = {
        'uri': {'required': True},
    }

    _attribute_map = {
        'uri': {'key': 'uri', 'type': 'str'},
        'content_version': {'key': 'contentVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: str,
        content_version: Optional[str] = None,
        **kwargs
    ):
        super(TemplateLink, self).__init__(**kwargs)
        self.uri = uri
        self.content_version = content_version
