# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .tracked_resource_py3 import TrackedResource


class Zone(TrackedResource):
    """Describes a DNS zone.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :param etag: The etag of the zone.
    :type etag: str
    :param max_number_of_record_sets: The maximum number of record sets that
     can be created in this DNS zone.  This is a read-only property and any
     attempt to set this value will be ignored.
    :type max_number_of_record_sets: long
    :param number_of_record_sets: The current number of record sets in this
     DNS zone.  This is a read-only property and any attempt to set this value
     will be ignored.
    :type number_of_record_sets: long
    :ivar name_servers: The name servers for this DNS zone. This is a
     read-only property and any attempt to set this value will be ignored.
    :vartype name_servers: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'name_servers': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'max_number_of_record_sets': {'key': 'properties.maxNumberOfRecordSets', 'type': 'long'},
        'number_of_record_sets': {'key': 'properties.numberOfRecordSets', 'type': 'long'},
        'name_servers': {'key': 'properties.nameServers', 'type': '[str]'},
    }

    def __init__(self, *, location: str, tags=None, etag: str=None, max_number_of_record_sets: int=None, number_of_record_sets: int=None, **kwargs) -> None:
        super(Zone, self).__init__(tags=tags, location=location, **kwargs)
        self.etag = etag
        self.max_number_of_record_sets = max_number_of_record_sets
        self.number_of_record_sets = number_of_record_sets
        self.name_servers = None
