/* Copyright 2017 - 2021 R. Thomas
 * Copyright 2017 - 2021 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_PE_KERNEL32_DLL_LOOKUP_H_
#define LIEF_PE_KERNEL32_DLL_LOOKUP_H_

#include <map>

namespace LIEF {
namespace PE {

static const std::map<uint32_t, const char*> kernel32_dll_lookup {
    { 0x0001, "ActivateActCtx"                      },
    { 0x0002, "AddAtomA"                            },
    { 0x0003, "AddAtomW"                            },
    { 0x0004, "AddConsoleAliasA"                    },
    { 0x0005, "AddConsoleAliasW"                    },
    { 0x0006, "AddLocalAlternateComputerNameA"      },
    { 0x0007, "AddLocalAlternateComputerNameW"      },
    { 0x0008, "AddRefActCtx"                        },
    { 0x0009, "AddVectoredExceptionHandler"         },
    { 0x000a, "AllocConsole"                        },
    { 0x000b, "AllocateUserPhysicalPages"           },
    { 0x000c, "AreFileApisANSI"                     },
    { 0x000d, "AssignProcessToJobObject"            },
    { 0x000e, "AttachConsole"                       },
    { 0x000f, "BackupRead"                          },
    { 0x0010, "BackupSeek"                          },
    { 0x0011, "BackupWrite"                         },
    { 0x0012, "BaseCheckAppcompatCache"             },
    { 0x0013, "BaseCleanupAppcompatCache"           },
    { 0x0014, "BaseCleanupAppcompatCacheSupport"    },
    { 0x0015, "BaseDumpAppcompatCache"              },
    { 0x0016, "BaseFlushAppcompatCache"             },
    { 0x0017, "BaseInitAppcompatCache"              },
    { 0x0018, "BaseInitAppcompatCacheSupport"       },
    { 0x0019, "BaseProcessInitPostImport"           },
    { 0x001a, "BaseQueryModuleData"                 },
    { 0x001b, "BaseUpdateAppcompatCache"            },
    { 0x001c, "BasepCheckWinSaferRestrictions"      },
    { 0x001d, "Beep"                                },
    { 0x001e, "BeginUpdateResourceA"                },
    { 0x001f, "BeginUpdateResourceW"                },
    { 0x0020, "BindIoCompletionCallback"            },
    { 0x0021, "BuildCommDCBA"                       },
    { 0x0022, "BuildCommDCBAndTimeoutsA"            },
    { 0x0023, "BuildCommDCBAndTimeoutsW"            },
    { 0x0024, "BuildCommDCBW"                       },
    { 0x0025, "CallNamedPipeA"                      },
    { 0x0026, "CallNamedPipeW"                      },
    { 0x0027, "CancelDeviceWakeupRequest"           },
    { 0x0028, "CancelIo"                            },
    { 0x0029, "CancelTimerQueueTimer"               },
    { 0x002a, "CancelWaitableTimer"                 },
    { 0x002b, "ChangeTimerQueueTimer"               },
    { 0x002c, "CheckNameLegalDOS8Dot3A"             },
    { 0x002d, "CheckNameLegalDOS8Dot3W"             },
    { 0x002e, "CheckRemoteDebuggerPresent"          },
    { 0x002f, "ClearCommBreak"                      },
    { 0x0030, "ClearCommError"                      },
    { 0x0031, "CloseConsoleHandle"                  },
    { 0x0032, "CloseHandle"                         },
    { 0x0033, "CloseProfileUserMapping"             },
    { 0x0034, "CmdBatNotification"                  },
    { 0x0035, "CommConfigDialogA"                   },
    { 0x0036, "CommConfigDialogW"                   },
    { 0x0037, "CompareFileTime"                     },
    { 0x0038, "CompareStringA"                      },
    { 0x0039, "CompareStringW"                      },
    { 0x003a, "ConnectNamedPipe"                    },
    { 0x003b, "ConsoleMenuControl"                  },
    { 0x003c, "ContinueDebugEvent"                  },
    { 0x003d, "ConvertDefaultLocale"                },
    { 0x003e, "ConvertFiberToThread"                },
    { 0x003f, "ConvertThreadToFiber"                },
    { 0x0040, "CopyFileA"                           },
    { 0x0041, "CopyFileExA"                         },
    { 0x0042, "CopyFileExW"                         },
    { 0x0043, "CopyFileW"                           },
    { 0x0044, "CopyLZFile"                          },
    { 0x0045, "CreateActCtxA"                       },
    { 0x0046, "CreateActCtxW"                       },
    { 0x0047, "CreateConsoleScreenBuffer"           },
    { 0x0048, "CreateDirectoryA"                    },
    { 0x0049, "CreateDirectoryExA"                  },
    { 0x004a, "CreateDirectoryExW"                  },
    { 0x004b, "CreateDirectoryW"                    },
    { 0x004c, "CreateEventA"                        },
    { 0x004d, "CreateEventW"                        },
    { 0x004e, "CreateFiber"                         },
    { 0x004f, "CreateFiberEx"                       },
    { 0x0050, "CreateFileA"                         },
    { 0x0051, "CreateFileMappingA"                  },
    { 0x0052, "CreateFileMappingW"                  },
    { 0x0053, "CreateFileW"                         },
    { 0x0054, "CreateHardLinkA"                     },
    { 0x0055, "CreateHardLinkW"                     },
    { 0x0056, "CreateIoCompletionPort"              },
    { 0x0057, "CreateJobObjectA"                    },
    { 0x0058, "CreateJobObjectW"                    },
    { 0x0059, "CreateJobSet"                        },
    { 0x005a, "CreateMailslotA"                     },
    { 0x005b, "CreateMailslotW"                     },
    { 0x005c, "CreateMemoryResourceNotification"    },
    { 0x005d, "CreateMutexA"                        },
    { 0x005e, "CreateMutexW"                        },
    { 0x005f, "CreateNamedPipeA"                    },
    { 0x0060, "CreateNamedPipeW"                    },
    { 0x0061, "CreateNlsSecurityDescriptor"         },
    { 0x0062, "CreatePipe"                          },
    { 0x0063, "CreateProcessA"                      },
    { 0x0064, "CreateProcessInternalA"              },
    { 0x0065, "CreateProcessInternalW"              },
    { 0x0066, "CreateProcessInternalWSecure"        },
    { 0x0067, "CreateProcessW"                      },
    { 0x0068, "CreateRemoteThread"                  },
    { 0x0069, "CreateSemaphoreA"                    },
    { 0x006a, "CreateSemaphoreW"                    },
    { 0x006b, "CreateSocketHandle"                  },
    { 0x006c, "CreateTapePartition"                 },
    { 0x006d, "CreateThread"                        },
    { 0x006e, "CreateTimerQueue"                    },
    { 0x006f, "CreateTimerQueueTimer"               },
    { 0x0070, "CreateToolhelp32Snapshot"            },
    { 0x0071, "CreateVirtualBuffer"                 },
    { 0x0072, "CreateWaitableTimerA"                },
    { 0x0073, "CreateWaitableTimerW"                },
    { 0x0074, "DeactivateActCtx"                    },
    { 0x0075, "DebugActiveProcess"                  },
    { 0x0076, "DebugActiveProcessStop"              },
    { 0x0077, "DebugBreak"                          },
    { 0x0078, "DebugBreakProcess"                   },
    { 0x0079, "DebugSetProcessKillOnExit"           },
    { 0x007a, "DecodePointer"                       },
    { 0x007b, "DecodeSystemPointer"                 },
    { 0x007c, "DefineDosDeviceA"                    },
    { 0x007d, "DefineDosDeviceW"                    },
    { 0x007e, "DelayLoadFailureHook"                },
    { 0x007f, "DeleteAtom"                          },
    { 0x0080, "DeleteCriticalSection"               },
    { 0x0081, "DeleteFiber"                         },
    { 0x0082, "DeleteFileA"                         },
    { 0x0083, "DeleteFileW"                         },
    { 0x0084, "DeleteTimerQueue"                    },
    { 0x0085, "DeleteTimerQueueEx"                  },
    { 0x0086, "DeleteTimerQueueTimer"               },
    { 0x0087, "DeleteVolumeMountPointA"             },
    { 0x0088, "DeleteVolumeMountPointW"             },
    { 0x0089, "DeviceIoControl"                     },
    { 0x008a, "DisableThreadLibraryCalls"           },
    { 0x008b, "DisconnectNamedPipe"                 },
    { 0x008c, "DnsHostnameToComputerNameA"          },
    { 0x008d, "DnsHostnameToComputerNameW"          },
    { 0x008e, "DosDateTimeToFileTime"               },
    { 0x008f, "DosPathToSessionPathA"               },
    { 0x0090, "DosPathToSessionPathW"               },
    { 0x0091, "DuplicateConsoleHandle"              },
    { 0x0092, "DuplicateHandle"                     },
    { 0x0093, "EncodePointer"                       },
    { 0x0094, "EncodeSystemPointer"                 },
    { 0x0095, "EndUpdateResourceA"                  },
    { 0x0096, "EndUpdateResourceW"                  },
    { 0x0097, "EnterCriticalSection"                },
    { 0x0098, "EnumCalendarInfoA"                   },
    { 0x0099, "EnumCalendarInfoExA"                 },
    { 0x009a, "EnumCalendarInfoExW"                 },
    { 0x009b, "EnumCalendarInfoW"                   },
    { 0x009c, "EnumDateFormatsA"                    },
    { 0x009d, "EnumDateFormatsExA"                  },
    { 0x009e, "EnumDateFormatsExW"                  },
    { 0x009f, "EnumDateFormatsW"                    },
    { 0x00a0, "EnumLanguageGroupLocalesA"           },
    { 0x00a1, "EnumLanguageGroupLocalesW"           },
    { 0x00a2, "EnumResourceLanguagesA"              },
    { 0x00a3, "EnumResourceLanguagesW"              },
    { 0x00a4, "EnumResourceNamesA"                  },
    { 0x00a5, "EnumResourceNamesW"                  },
    { 0x00a6, "EnumResourceTypesA"                  },
    { 0x00a7, "EnumResourceTypesW"                  },
    { 0x00a8, "EnumSystemCodePagesA"                },
    { 0x00a9, "EnumSystemCodePagesW"                },
    { 0x00aa, "EnumSystemGeoID"                     },
    { 0x00ab, "EnumSystemLanguageGroupsA"           },
    { 0x00ac, "EnumSystemLanguageGroupsW"           },
    { 0x00ad, "EnumSystemLocalesA"                  },
    { 0x00ae, "EnumSystemLocalesW"                  },
    { 0x00af, "EnumTimeFormatsA"                    },
    { 0x00b0, "EnumTimeFormatsW"                    },
    { 0x00b1, "EnumUILanguagesA"                    },
    { 0x00b2, "EnumUILanguagesW"                    },
    { 0x00b3, "EnumerateLocalComputerNamesA"        },
    { 0x00b4, "EnumerateLocalComputerNamesW"        },
    { 0x00b5, "EraseTape"                           },
    { 0x00b6, "EscapeCommFunction"                  },
    { 0x00b7, "ExitProcess"                         },
    { 0x00b8, "ExitThread"                          },
    { 0x00b9, "ExitVDM"                             },
    { 0x00ba, "ExpandEnvironmentStringsA"           },
    { 0x00bb, "ExpandEnvironmentStringsW"           },
    { 0x00bc, "ExpungeConsoleCommandHistoryA"       },
    { 0x00bd, "ExpungeConsoleCommandHistoryW"       },
    { 0x00be, "ExtendVirtualBuffer"                 },
    { 0x00bf, "FatalAppExitA"                       },
    { 0x00c0, "FatalAppExitW"                       },
    { 0x00c1, "FatalExit"                           },
    { 0x00c2, "FileTimeToDosDateTime"               },
    { 0x00c3, "FileTimeToLocalFileTime"             },
    { 0x00c4, "FileTimeToSystemTime"                },
    { 0x00c5, "FillConsoleOutputAttribute"          },
    { 0x00c6, "FillConsoleOutputCharacterA"         },
    { 0x00c7, "FillConsoleOutputCharacterW"         },
    { 0x00c8, "FindActCtxSectionGuid"               },
    { 0x00c9, "FindActCtxSectionStringA"            },
    { 0x00ca, "FindActCtxSectionStringW"            },
    { 0x00cb, "FindAtomA"                           },
    { 0x00cc, "FindAtomW"                           },
    { 0x00cd, "FindClose"                           },
    { 0x00ce, "FindCloseChangeNotification"         },
    { 0x00cf, "FindFirstChangeNotificationA"        },
    { 0x00d0, "FindFirstChangeNotificationW"        },
    { 0x00d1, "FindFirstFileA"                      },
    { 0x00d2, "FindFirstFileExA"                    },
    { 0x00d3, "FindFirstFileExW"                    },
    { 0x00d4, "FindFirstFileW"                      },
    { 0x00d5, "FindFirstVolumeA"                    },
    { 0x00d6, "FindFirstVolumeMountPointA"          },
    { 0x00d7, "FindFirstVolumeMountPointW"          },
    { 0x00d8, "FindFirstVolumeW"                    },
    { 0x00d9, "FindNextChangeNotification"          },
    { 0x00da, "FindNextFileA"                       },
    { 0x00db, "FindNextFileW"                       },
    { 0x00dc, "FindNextVolumeA"                     },
    { 0x00dd, "FindNextVolumeMountPointA"           },
    { 0x00de, "FindNextVolumeMountPointW"           },
    { 0x00df, "FindNextVolumeW"                     },
    { 0x00e0, "FindResourceA"                       },
    { 0x00e1, "FindResourceExA"                     },
    { 0x00e2, "FindResourceExW"                     },
    { 0x00e3, "FindResourceW"                       },
    { 0x00e4, "FindVolumeClose"                     },
    { 0x00e5, "FindVolumeMountPointClose"           },
    { 0x00e6, "FlushConsoleInputBuffer"             },
    { 0x00e7, "FlushFileBuffers"                    },
    { 0x00e8, "FlushInstructionCache"               },
    { 0x00e9, "FlushViewOfFile"                     },
    { 0x00ea, "FoldStringA"                         },
    { 0x00eb, "FoldStringW"                         },
    { 0x00ec, "FormatMessageA"                      },
    { 0x00ed, "FormatMessageW"                      },
    { 0x00ee, "FreeConsole"                         },
    { 0x00ef, "FreeEnvironmentStringsA"             },
    { 0x00f0, "FreeEnvironmentStringsW"             },
    { 0x00f1, "FreeLibrary"                         },
    { 0x00f2, "FreeLibraryAndExitThread"            },
    { 0x00f3, "FreeResource"                        },
    { 0x00f4, "FreeUserPhysicalPages"               },
    { 0x00f5, "FreeVirtualBuffer"                   },
    { 0x00f6, "GenerateConsoleCtrlEvent"            },
    { 0x00f7, "GetACP"                              },
    { 0x00f8, "GetAtomNameA"                        },
    { 0x00f9, "GetAtomNameW"                        },
    { 0x00fa, "GetBinaryType"                       },
    { 0x00fb, "GetBinaryTypeA"                      },
    { 0x00fc, "GetBinaryTypeW"                      },
    { 0x00fd, "GetCPFileNameFromRegistry"           },
    { 0x00fe, "GetCPInfo"                           },
    { 0x00ff, "GetCPInfoExA"                        },
    { 0x0100, "GetCPInfoExW"                        },
    { 0x0101, "GetCalendarInfoA"                    },
    { 0x0102, "GetCalendarInfoW"                    },
    { 0x0103, "GetComPlusPackageInstallStatus"      },
    { 0x0104, "GetCommConfig"                       },
    { 0x0105, "GetCommMask"                         },
    { 0x0106, "GetCommModemStatus"                  },
    { 0x0107, "GetCommProperties"                   },
    { 0x0108, "GetCommState"                        },
    { 0x0109, "GetCommTimeouts"                     },
    { 0x010a, "GetCommandLineA"                     },
    { 0x010b, "GetCommandLineW"                     },
    { 0x010c, "GetCompressedFileSizeA"              },
    { 0x010d, "GetCompressedFileSizeW"              },
    { 0x010e, "GetComputerNameA"                    },
    { 0x010f, "GetComputerNameExA"                  },
    { 0x0110, "GetComputerNameExW"                  },
    { 0x0111, "GetComputerNameW"                    },
    { 0x0112, "GetConsoleAliasA"                    },
    { 0x0113, "GetConsoleAliasExesA"                },
    { 0x0114, "GetConsoleAliasExesLengthA"          },
    { 0x0115, "GetConsoleAliasExesLengthW"          },
    { 0x0116, "GetConsoleAliasExesW"                },
    { 0x0117, "GetConsoleAliasW"                    },
    { 0x0118, "GetConsoleAliasesA"                  },
    { 0x0119, "GetConsoleAliasesLengthA"            },
    { 0x011a, "GetConsoleAliasesLengthW"            },
    { 0x011b, "GetConsoleAliasesW"                  },
    { 0x011c, "GetConsoleCP"                        },
    { 0x011d, "GetConsoleCharType"                  },
    { 0x011e, "GetConsoleCommandHistoryA"           },
    { 0x011f, "GetConsoleCommandHistoryLengthA"     },
    { 0x0120, "GetConsoleCommandHistoryLengthW"     },
    { 0x0121, "GetConsoleCommandHistoryW"           },
    { 0x0122, "GetConsoleCursorInfo"                },
    { 0x0123, "GetConsoleCursorMode"                },
    { 0x0124, "GetConsoleDisplayMode"               },
    { 0x0125, "GetConsoleFontInfo"                  },
    { 0x0126, "GetConsoleFontSize"                  },
    { 0x0127, "GetConsoleHardwareState"             },
    { 0x0128, "GetConsoleInputExeNameA"             },
    { 0x0129, "GetConsoleInputExeNameW"             },
    { 0x012a, "GetConsoleInputWaitHandle"           },
    { 0x012b, "GetConsoleKeyboardLayoutNameA"       },
    { 0x012c, "GetConsoleKeyboardLayoutNameW"       },
    { 0x012d, "GetConsoleMode"                      },
    { 0x012e, "GetConsoleNlsMode"                   },
    { 0x012f, "GetConsoleOutputCP"                  },
    { 0x0130, "GetConsoleProcessList"               },
    { 0x0131, "GetConsoleScreenBufferInfo"          },
    { 0x0132, "GetConsoleSelectionInfo"             },
    { 0x0133, "GetConsoleTitleA"                    },
    { 0x0134, "GetConsoleTitleW"                    },
    { 0x0135, "GetConsoleWindow"                    },
    { 0x0136, "GetCurrencyFormatA"                  },
    { 0x0137, "GetCurrencyFormatW"                  },
    { 0x0138, "GetCurrentActCtx"                    },
    { 0x0139, "GetCurrentConsoleFont"               },
    { 0x013a, "GetCurrentDirectoryA"                },
    { 0x013b, "GetCurrentDirectoryW"                },
    { 0x013c, "GetCurrentProcess"                   },
    { 0x013d, "GetCurrentProcessId"                 },
    { 0x013e, "GetCurrentThread"                    },
    { 0x013f, "GetCurrentThreadId"                  },
    { 0x0140, "GetDateFormatA"                      },
    { 0x0141, "GetDateFormatW"                      },
    { 0x0142, "GetDefaultCommConfigA"               },
    { 0x0143, "GetDefaultCommConfigW"               },
    { 0x0144, "GetDefaultSortkeySize"               },
    { 0x0145, "GetDevicePowerState"                 },
    { 0x0146, "GetDiskFreeSpaceA"                   },
    { 0x0147, "GetDiskFreeSpaceExA"                 },
    { 0x0148, "GetDiskFreeSpaceExW"                 },
    { 0x0149, "GetDiskFreeSpaceW"                   },
    { 0x014a, "GetDllDirectoryA"                    },
    { 0x014b, "GetDllDirectoryW"                    },
    { 0x014c, "GetDriveTypeA"                       },
    { 0x014d, "GetDriveTypeW"                       },
    { 0x014e, "GetEnvironmentStrings"               },
    { 0x014f, "GetEnvironmentStringsA"              },
    { 0x0150, "GetEnvironmentStringsW"              },
    { 0x0151, "GetEnvironmentVariableA"             },
    { 0x0152, "GetEnvironmentVariableW"             },
    { 0x0153, "GetExitCodeProcess"                  },
    { 0x0154, "GetExitCodeThread"                   },
    { 0x0155, "GetExpandedNameA"                    },
    { 0x0156, "GetExpandedNameW"                    },
    { 0x0157, "GetFileAttributesA"                  },
    { 0x0158, "GetFileAttributesExA"                },
    { 0x0159, "GetFileAttributesExW"                },
    { 0x015a, "GetFileAttributesW"                  },
    { 0x015b, "GetFileInformationByHandle"          },
    { 0x015c, "GetFileSize"                         },
    { 0x015d, "GetFileSizeEx"                       },
    { 0x015e, "GetFileTime"                         },
    { 0x015f, "GetFileType"                         },
    { 0x0160, "GetFirmwareEnvironmentVariableA"     },
    { 0x0161, "GetFirmwareEnvironmentVariableW"     },
    { 0x0162, "GetFullPathNameA"                    },
    { 0x0163, "GetFullPathNameW"                    },
    { 0x0164, "GetGeoInfoA"                         },
    { 0x0165, "GetGeoInfoW"                         },
    { 0x0166, "GetHandleContext"                    },
    { 0x0167, "GetHandleInformation"                },
    { 0x0168, "GetLargestConsoleWindowSize"         },
    { 0x0169, "GetLastError"                        },
    { 0x016a, "GetLinguistLangSize"                 },
    { 0x016b, "GetLocalTime"                        },
    { 0x016c, "GetLocaleInfoA"                      },
    { 0x016d, "GetLocaleInfoW"                      },
    { 0x016e, "GetLogicalDriveStringsA"             },
    { 0x016f, "GetLogicalDriveStringsW"             },
    { 0x0170, "GetLogicalDrives"                    },
    { 0x0171, "GetLongPathNameA"                    },
    { 0x0172, "GetLongPathNameW"                    },
    { 0x0173, "GetMailslotInfo"                     },
    { 0x0174, "GetModuleFileNameA"                  },
    { 0x0175, "GetModuleFileNameW"                  },
    { 0x0176, "GetModuleHandleA"                    },
    { 0x0177, "GetModuleHandleExA"                  },
    { 0x0178, "GetModuleHandleExW"                  },
    { 0x0179, "GetModuleHandleW"                    },
    { 0x017a, "GetNamedPipeHandleStateA"            },
    { 0x017b, "GetNamedPipeHandleStateW"            },
    { 0x017c, "GetNamedPipeInfo"                    },
    { 0x017d, "GetNativeSystemInfo"                 },
    { 0x017e, "GetNextVDMCommand"                   },
    { 0x017f, "GetNlsSectionName"                   },
    { 0x0180, "GetNumaAvailableMemory"              },
    { 0x0181, "GetNumaAvailableMemoryNode"          },
    { 0x0182, "GetNumaHighestNodeNumber"            },
    { 0x0183, "GetNumaNodeProcessorMask"            },
    { 0x0184, "GetNumaProcessorMap"                 },
    { 0x0185, "GetNumaProcessorNode"                },
    { 0x0186, "GetNumberFormatA"                    },
    { 0x0187, "GetNumberFormatW"                    },
    { 0x0188, "GetNumberOfConsoleFonts"             },
    { 0x0189, "GetNumberOfConsoleInputEvents"       },
    { 0x018a, "GetNumberOfConsoleMouseButtons"      },
    { 0x018b, "GetOEMCP"                            },
    { 0x018c, "GetOverlappedResult"                 },
    { 0x018d, "GetPriorityClass"                    },
    { 0x018e, "GetPrivateProfileIntA"               },
    { 0x018f, "GetPrivateProfileIntW"               },
    { 0x0190, "GetPrivateProfileSectionA"           },
    { 0x0191, "GetPrivateProfileSectionNamesA"      },
    { 0x0192, "GetPrivateProfileSectionNamesW"      },
    { 0x0193, "GetPrivateProfileSectionW"           },
    { 0x0194, "GetPrivateProfileStringA"            },
    { 0x0195, "GetPrivateProfileStringW"            },
    { 0x0196, "GetPrivateProfileStructA"            },
    { 0x0197, "GetPrivateProfileStructW"            },
    { 0x0198, "GetProcAddress"                      },
    { 0x0199, "GetProcessAffinityMask"              },
    { 0x019a, "GetProcessHandleCount"               },
    { 0x019b, "GetProcessHeap"                      },
    { 0x019c, "GetProcessHeaps"                     },
    { 0x019d, "GetProcessId"                        },
    { 0x019e, "GetProcessIoCounters"                },
    { 0x019f, "GetProcessPriorityBoost"             },
    { 0x01a0, "GetProcessShutdownParameters"        },
    { 0x01a1, "GetProcessTimes"                     },
    { 0x01a2, "GetProcessVersion"                   },
    { 0x01a3, "GetProcessWorkingSetSize"            },
    { 0x01a4, "GetProfileIntA"                      },
    { 0x01a5, "GetProfileIntW"                      },
    { 0x01a6, "GetProfileSectionA"                  },
    { 0x01a7, "GetProfileSectionW"                  },
    { 0x01a8, "GetProfileStringA"                   },
    { 0x01a9, "GetProfileStringW"                   },
    { 0x01aa, "GetQueuedCompletionStatus"           },
    { 0x01ab, "GetShortPathNameA"                   },
    { 0x01ac, "GetShortPathNameW"                   },
    { 0x01ad, "GetStartupInfoA"                     },
    { 0x01ae, "GetStartupInfoW"                     },
    { 0x01af, "GetStdHandle"                        },
    { 0x01b0, "GetStringTypeA"                      },
    { 0x01b1, "GetStringTypeExA"                    },
    { 0x01b2, "GetStringTypeExW"                    },
    { 0x01b3, "GetStringTypeW"                      },
    { 0x01b4, "GetSystemDefaultLCID"                },
    { 0x01b5, "GetSystemDefaultLangID"              },
    { 0x01b6, "GetSystemDefaultUILanguage"          },
    { 0x01b7, "GetSystemDirectoryA"                 },
    { 0x01b8, "GetSystemDirectoryW"                 },
    { 0x01b9, "GetSystemInfo"                       },
    { 0x01ba, "GetSystemPowerStatus"                },
    { 0x01bb, "GetSystemRegistryQuota"              },
    { 0x01bc, "GetSystemTime"                       },
    { 0x01bd, "GetSystemTimeAdjustment"             },
    { 0x01be, "GetSystemTimeAsFileTime"             },
    { 0x01bf, "GetSystemTimes"                      },
    { 0x01c0, "GetSystemWindowsDirectoryA"          },
    { 0x01c1, "GetSystemWindowsDirectoryW"          },
    { 0x01c2, "GetSystemWow64DirectoryA"            },
    { 0x01c3, "GetSystemWow64DirectoryW"            },
    { 0x01c4, "GetTapeParameters"                   },
    { 0x01c5, "GetTapePosition"                     },
    { 0x01c6, "GetTapeStatus"                       },
    { 0x01c7, "GetTempFileNameA"                    },
    { 0x01c8, "GetTempFileNameW"                    },
    { 0x01c9, "GetTempPathA"                        },
    { 0x01ca, "GetTempPathW"                        },
    { 0x01cb, "GetThreadContext"                    },
    { 0x01cc, "GetThreadIOPendingFlag"              },
    { 0x01cd, "GetThreadLocale"                     },
    { 0x01ce, "GetThreadPriority"                   },
    { 0x01cf, "GetThreadPriorityBoost"              },
    { 0x01d0, "GetThreadSelectorEntry"              },
    { 0x01d1, "GetThreadTimes"                      },
    { 0x01d2, "GetTickCount"                        },
    { 0x01d3, "GetTimeFormatA"                      },
    { 0x01d4, "GetTimeFormatW"                      },
    { 0x01d5, "GetTimeZoneInformation"              },
    { 0x01d6, "GetUserDefaultLCID"                  },
    { 0x01d7, "GetUserDefaultLangID"                },
    { 0x01d8, "GetUserDefaultUILanguage"            },
    { 0x01d9, "GetUserGeoID"                        },
    { 0x01da, "GetVDMCurrentDirectories"            },
    { 0x01db, "GetVersion"                          },
    { 0x01dc, "GetVersionExA"                       },
    { 0x01dd, "GetVersionExW"                       },
    { 0x01de, "GetVolumeInformationA"               },
    { 0x01df, "GetVolumeInformationW"               },
    { 0x01e0, "GetVolumeNameForVolumeMountPointA"   },
    { 0x01e1, "GetVolumeNameForVolumeMountPointW"   },
    { 0x01e2, "GetVolumePathNameA"                  },
    { 0x01e3, "GetVolumePathNameW"                  },
    { 0x01e4, "GetVolumePathNamesForVolumeNameA"    },
    { 0x01e5, "GetVolumePathNamesForVolumeNameW"    },
    { 0x01e6, "GetWindowsDirectoryA"                },
    { 0x01e7, "GetWindowsDirectoryW"                },
    { 0x01e8, "GetWriteWatch"                       },
    { 0x01e9, "GlobalAddAtomA"                      },
    { 0x01ea, "GlobalAddAtomW"                      },
    { 0x01eb, "GlobalAlloc"                         },
    { 0x01ec, "GlobalCompact"                       },
    { 0x01ed, "GlobalDeleteAtom"                    },
    { 0x01ee, "GlobalFindAtomA"                     },
    { 0x01ef, "GlobalFindAtomW"                     },
    { 0x01f0, "GlobalFix"                           },
    { 0x01f1, "GlobalFlags"                         },
    { 0x01f2, "GlobalFree"                          },
    { 0x01f3, "GlobalGetAtomNameA"                  },
    { 0x01f4, "GlobalGetAtomNameW"                  },
    { 0x01f5, "GlobalHandle"                        },
    { 0x01f6, "GlobalLock"                          },
    { 0x01f7, "GlobalMemoryStatus"                  },
    { 0x01f8, "GlobalMemoryStatusEx"                },
    { 0x01f9, "GlobalReAlloc"                       },
    { 0x01fa, "GlobalSize"                          },
    { 0x01fb, "GlobalUnWire"                        },
    { 0x01fc, "GlobalUnfix"                         },
    { 0x01fd, "GlobalUnlock"                        },
    { 0x01fe, "GlobalWire"                          },
    { 0x01ff, "Heap32First"                         },
    { 0x0200, "Heap32ListFirst"                     },
    { 0x0201, "Heap32ListNext"                      },
    { 0x0202, "Heap32Next"                          },
    { 0x0203, "HeapAlloc"                           },
    { 0x0204, "HeapCompact"                         },
    { 0x0205, "HeapCreate"                          },
    { 0x0206, "HeapCreateTagsW"                     },
    { 0x0207, "HeapDestroy"                         },
    { 0x0208, "HeapExtend"                          },
    { 0x0209, "HeapFree"                            },
    { 0x020a, "HeapLock"                            },
    { 0x020b, "HeapQueryInformation"                },
    { 0x020c, "HeapQueryTagW"                       },
    { 0x020d, "HeapReAlloc"                         },
    { 0x020e, "HeapSetInformation"                  },
    { 0x020f, "HeapSize"                            },
    { 0x0210, "HeapSummary"                         },
    { 0x0211, "HeapUnlock"                          },
    { 0x0212, "HeapUsage"                           },
    { 0x0213, "HeapValidate"                        },
    { 0x0214, "HeapWalk"                            },
    { 0x0215, "InitAtomTable"                       },
    { 0x0216, "InitializeCriticalSection"           },
    { 0x0217, "InitializeCriticalSectionAndSpinCount" },
    { 0x0218, "InitializeSListHead"                 },
    { 0x0219, "InterlockedCompareExchange"          },
    { 0x021a, "InterlockedDecrement"                },
    { 0x021b, "InterlockedExchange"                 },
    { 0x021c, "InterlockedExchangeAdd"              },
    { 0x021d, "InterlockedFlushSList"               },
    { 0x021e, "InterlockedIncrement"                },
    { 0x021f, "InterlockedPopEntrySList"            },
    { 0x0220, "InterlockedPushEntrySList"           },
    { 0x0221, "InvalidateConsoleDIBits"             },
    { 0x0222, "IsBadCodePtr"                        },
    { 0x0223, "IsBadHugeReadPtr"                    },
    { 0x0224, "IsBadHugeWritePtr"                   },
    { 0x0225, "IsBadReadPtr"                        },
    { 0x0226, "IsBadStringPtrA"                     },
    { 0x0227, "IsBadStringPtrW"                     },
    { 0x0228, "IsBadWritePtr"                       },
    { 0x0229, "IsDBCSLeadByte"                      },
    { 0x022a, "IsDBCSLeadByteEx"                    },
    { 0x022b, "IsDebuggerPresent"                   },
    { 0x022c, "IsProcessInJob"                      },
    { 0x022d, "IsProcessorFeaturePresent"           },
    { 0x022e, "IsSystemResumeAutomatic"             },
    { 0x022f, "IsValidCodePage"                     },
    { 0x0230, "IsValidLanguageGroup"                },
    { 0x0231, "IsValidLocale"                       },
    { 0x0232, "IsValidUILanguage"                   },
    { 0x0233, "IsWow64Process"                      },
    { 0x0234, "LCMapStringA"                        },
    { 0x0235, "LCMapStringW"                        },
    { 0x0236, "LZClose"                             },
    { 0x0237, "LZCloseFile"                         },
    { 0x0238, "LZCopy"                              },
    { 0x0239, "LZCreateFileW"                       },
    { 0x023a, "LZDone"                              },
    { 0x023b, "LZInit"                              },
    { 0x023c, "LZOpenFileA"                         },
    { 0x023d, "LZOpenFileW"                         },
    { 0x023e, "LZRead"                              },
    { 0x023f, "LZSeek"                              },
    { 0x0240, "LZStart"                             },
    { 0x0241, "LeaveCriticalSection"                },
    { 0x0242, "LoadLibraryA"                        },
    { 0x0243, "LoadLibraryExA"                      },
    { 0x0244, "LoadLibraryExW"                      },
    { 0x0245, "LoadLibraryW"                        },
    { 0x0246, "LoadModule"                          },
    { 0x0247, "LoadResource"                        },
    { 0x0248, "LocalAlloc"                          },
    { 0x0249, "LocalCompact"                        },
    { 0x024a, "LocalFileTimeToFileTime"             },
    { 0x024b, "LocalFlags"                          },
    { 0x024c, "LocalFree"                           },
    { 0x024d, "LocalHandle"                         },
    { 0x024e, "LocalLock"                           },
    { 0x024f, "LocalReAlloc"                        },
    { 0x0250, "LocalShrink"                         },
    { 0x0251, "LocalSize"                           },
    { 0x0252, "LocalUnlock"                         },
    { 0x0253, "LockFile"                            },
    { 0x0254, "LockFileEx"                          },
    { 0x0255, "LockResource"                        },
    { 0x0256, "MapUserPhysicalPages"                },
    { 0x0257, "MapUserPhysicalPagesScatter"         },
    { 0x0258, "MapViewOfFile"                       },
    { 0x0259, "MapViewOfFileEx"                     },
    { 0x025a, "Module32First"                       },
    { 0x025b, "Module32FirstW"                      },
    { 0x025c, "Module32Next"                        },
    { 0x025d, "Module32NextW"                       },
    { 0x025e, "MoveFileA"                           },
    { 0x025f, "MoveFileExA"                         },
    { 0x0260, "MoveFileExW"                         },
    { 0x0261, "MoveFileW"                           },
    { 0x0262, "MoveFileWithProgressA"               },
    { 0x0263, "MoveFileWithProgressW"               },
    { 0x0264, "MulDiv"                              },
    { 0x0265, "MultiByteToWideChar"                 },
    { 0x0266, "NlsConvertIntegerToString"           },
    { 0x0267, "NlsGetCacheUpdateCount"              },
    { 0x0268, "NlsResetProcessLocale"               },
    { 0x0269, "NumaVirtualQueryNode"                },
    { 0x026a, "OpenConsoleW"                        },
    { 0x026b, "OpenDataFile"                        },
    { 0x026c, "OpenEventA"                          },
    { 0x026d, "OpenEventW"                          },
    { 0x026e, "OpenFile"                            },
    { 0x026f, "OpenFileMappingA"                    },
    { 0x0270, "OpenFileMappingW"                    },
    { 0x0271, "OpenJobObjectA"                      },
    { 0x0272, "OpenJobObjectW"                      },
    { 0x0273, "OpenMutexA"                          },
    { 0x0274, "OpenMutexW"                          },
    { 0x0275, "OpenProcess"                         },
    { 0x0276, "OpenProfileUserMapping"              },
    { 0x0277, "OpenSemaphoreA"                      },
    { 0x0278, "OpenSemaphoreW"                      },
    { 0x0279, "OpenThread"                          },
    { 0x027a, "OpenWaitableTimerA"                  },
    { 0x027b, "OpenWaitableTimerW"                  },
    { 0x027c, "OutputDebugStringA"                  },
    { 0x027d, "OutputDebugStringW"                  },
    { 0x027e, "PeekConsoleInputA"                   },
    { 0x027f, "PeekConsoleInputW"                   },
    { 0x0280, "PeekNamedPipe"                       },
    { 0x0281, "PostQueuedCompletionStatus"          },
    { 0x0282, "PrepareTape"                         },
    { 0x0283, "PrivCopyFileExW"                     },
    { 0x0284, "PrivMoveFileIdentityW"               },
    { 0x0285, "Process32First"                      },
    { 0x0286, "Process32FirstW"                     },
    { 0x0287, "Process32Next"                       },
    { 0x0288, "Process32NextW"                      },
    { 0x0289, "ProcessIdToSessionId"                },
    { 0x028a, "PulseEvent"                          },
    { 0x028b, "PurgeComm"                           },
    { 0x028c, "QueryActCtxW"                        },
    { 0x028d, "QueryDepthSList"                     },
    { 0x028e, "QueryDosDeviceA"                     },
    { 0x028f, "QueryDosDeviceW"                     },
    { 0x0290, "QueryInformationJobObject"           },
    { 0x0291, "QueryMemoryResourceNotification"     },
    { 0x0292, "QueryPerformanceCounter"             },
    { 0x0293, "QueryPerformanceFrequency"           },
    { 0x0294, "QueryWin31IniFilesMappedToRegistry"  },
    { 0x0295, "QueueUserAPC"                        },
    { 0x0296, "QueueUserWorkItem"                   },
    { 0x0297, "RaiseException"                      },
    { 0x0298, "ReadConsoleA"                        },
    { 0x0299, "ReadConsoleInputA"                   },
    { 0x029a, "ReadConsoleInputExA"                 },
    { 0x029b, "ReadConsoleInputExW"                 },
    { 0x029c, "ReadConsoleInputW"                   },
    { 0x029d, "ReadConsoleOutputA"                  },
    { 0x029e, "ReadConsoleOutputAttribute"          },
    { 0x029f, "ReadConsoleOutputCharacterA"         },
    { 0x02a0, "ReadConsoleOutputCharacterW"         },
    { 0x02a1, "ReadConsoleOutputW"                  },
    { 0x02a2, "ReadConsoleW"                        },
    { 0x02a3, "ReadDirectoryChangesW"               },
    { 0x02a4, "ReadFile"                            },
    { 0x02a5, "ReadFileEx"                          },
    { 0x02a6, "ReadFileScatter"                     },
    { 0x02a7, "ReadProcessMemory"                   },
    { 0x02a8, "RegisterConsoleIME"                  },
    { 0x02a9, "RegisterConsoleOS2"                  },
    { 0x02aa, "RegisterConsoleVDM"                  },
    { 0x02ab, "RegisterWaitForInputIdle"            },
    { 0x02ac, "RegisterWaitForSingleObject"         },
    { 0x02ad, "RegisterWaitForSingleObjectEx"       },
    { 0x02ae, "RegisterWowBaseHandlers"             },
    { 0x02af, "RegisterWowExec"                     },
    { 0x02b0, "ReleaseActCtx"                       },
    { 0x02b1, "ReleaseMutex"                        },
    { 0x02b2, "ReleaseSemaphore"                    },
    { 0x02b3, "RemoveDirectoryA"                    },
    { 0x02b4, "RemoveDirectoryW"                    },
    { 0x02b5, "RemoveLocalAlternateComputerNameA"   },
    { 0x02b6, "RemoveLocalAlternateComputerNameW"   },
    { 0x02b7, "RemoveVectoredExceptionHandler"      },
    { 0x02b8, "ReplaceFile"                         },
    { 0x02b9, "ReplaceFileA"                        },
    { 0x02ba, "ReplaceFileW"                        },
    { 0x02bb, "RequestDeviceWakeup"                 },
    { 0x02bc, "RequestWakeupLatency"                },
    { 0x02bd, "ResetEvent"                          },
    { 0x02be, "ResetWriteWatch"                     },
    { 0x02bf, "RestoreLastError"                    },
    { 0x02c0, "ResumeThread"                        },
    { 0x02c1, "RtlCaptureContext"                   },
    { 0x02c2, "RtlCaptureStackBackTrace"            },
    { 0x02c3, "RtlFillMemory"                       },
    { 0x02c4, "RtlMoveMemory"                       },
    { 0x02c5, "RtlUnwind"                           },
    { 0x02c6, "RtlZeroMemory"                       },
    { 0x02c7, "ScrollConsoleScreenBufferA"          },
    { 0x02c8, "ScrollConsoleScreenBufferW"          },
    { 0x02c9, "SearchPathA"                         },
    { 0x02ca, "SearchPathW"                         },
    { 0x02cb, "SetCPGlobal"                         },
    { 0x02cc, "SetCalendarInfoA"                    },
    { 0x02cd, "SetCalendarInfoW"                    },
    { 0x02ce, "SetClientTimeZoneInformation"        },
    { 0x02cf, "SetComPlusPackageInstallStatus"      },
    { 0x02d0, "SetCommBreak"                        },
    { 0x02d1, "SetCommConfig"                       },
    { 0x02d2, "SetCommMask"                         },
    { 0x02d3, "SetCommState"                        },
    { 0x02d4, "SetCommTimeouts"                     },
    { 0x02d5, "SetComputerNameA"                    },
    { 0x02d6, "SetComputerNameExA"                  },
    { 0x02d7, "SetComputerNameExW"                  },
    { 0x02d8, "SetComputerNameW"                    },
    { 0x02d9, "SetConsoleActiveScreenBuffer"        },
    { 0x02da, "SetConsoleCP"                        },
    { 0x02db, "SetConsoleCommandHistoryMode"        },
    { 0x02dc, "SetConsoleCtrlHandler"               },
    { 0x02dd, "SetConsoleCursor"                    },
    { 0x02de, "SetConsoleCursorInfo"                },
    { 0x02df, "SetConsoleCursorMode"                },
    { 0x02e0, "SetConsoleCursorPosition"            },
    { 0x02e1, "SetConsoleDisplayMode"               },
    { 0x02e2, "SetConsoleFont"                      },
    { 0x02e3, "SetConsoleHardwareState"             },
    { 0x02e4, "SetConsoleIcon"                      },
    { 0x02e5, "SetConsoleInputExeNameA"             },
    { 0x02e6, "SetConsoleInputExeNameW"             },
    { 0x02e7, "SetConsoleKeyShortcuts"              },
    { 0x02e8, "SetConsoleLocalEUDC"                 },
    { 0x02e9, "SetConsoleMaximumWindowSize"         },
    { 0x02ea, "SetConsoleMenuClose"                 },
    { 0x02eb, "SetConsoleMode"                      },
    { 0x02ec, "SetConsoleNlsMode"                   },
    { 0x02ed, "SetConsoleNumberOfCommandsA"         },
    { 0x02ee, "SetConsoleNumberOfCommandsW"         },
    { 0x02ef, "SetConsoleOS2OemFormat"              },
    { 0x02f0, "SetConsoleOutputCP"                  },
    { 0x02f1, "SetConsolePalette"                   },
    { 0x02f2, "SetConsoleScreenBufferSize"          },
    { 0x02f3, "SetConsoleTextAttribute"             },
    { 0x02f4, "SetConsoleTitleA"                    },
    { 0x02f5, "SetConsoleTitleW"                    },
    { 0x02f6, "SetConsoleWindowInfo"                },
    { 0x02f7, "SetCriticalSectionSpinCount"         },
    { 0x02f8, "SetCurrentDirectoryA"                },
    { 0x02f9, "SetCurrentDirectoryW"                },
    { 0x02fa, "SetDefaultCommConfigA"               },
    { 0x02fb, "SetDefaultCommConfigW"               },
    { 0x02fc, "SetDllDirectoryA"                    },
    { 0x02fd, "SetDllDirectoryW"                    },
    { 0x02fe, "SetEndOfFile"                        },
    { 0x02ff, "SetEnvironmentVariableA"             },
    { 0x0300, "SetEnvironmentVariableW"             },
    { 0x0301, "SetErrorMode"                        },
    { 0x0302, "SetEvent"                            },
    { 0x0303, "SetFileApisToANSI"                   },
    { 0x0304, "SetFileApisToOEM"                    },
    { 0x0305, "SetFileAttributesA"                  },
    { 0x0306, "SetFileAttributesW"                  },
    { 0x0307, "SetFilePointer"                      },
    { 0x0308, "SetFilePointerEx"                    },
    { 0x0309, "SetFileShortNameA"                   },
    { 0x030a, "SetFileShortNameW"                   },
    { 0x030b, "SetFileTime"                         },
    { 0x030c, "SetFileValidData"                    },
    { 0x030d, "SetFirmwareEnvironmentVariableA"     },
    { 0x030e, "SetFirmwareEnvironmentVariableW"     },
    { 0x030f, "SetHandleContext"                    },
    { 0x0310, "SetHandleCount"                      },
    { 0x0311, "SetHandleInformation"                },
    { 0x0312, "SetInformationJobObject"             },
    { 0x0313, "SetLastConsoleEventActive"           },
    { 0x0314, "SetLastError"                        },
    { 0x0315, "SetLocalPrimaryComputerNameA"        },
    { 0x0316, "SetLocalPrimaryComputerNameW"        },
    { 0x0317, "SetLocalTime"                        },
    { 0x0318, "SetLocaleInfoA"                      },
    { 0x0319, "SetLocaleInfoW"                      },
    { 0x031a, "SetMailslotInfo"                     },
    { 0x031b, "SetMessageWaitingIndicator"          },
    { 0x031c, "SetNamedPipeHandleState"             },
    { 0x031d, "SetPriorityClass"                    },
    { 0x031e, "SetProcessAffinityMask"              },
    { 0x031f, "SetProcessPriorityBoost"             },
    { 0x0320, "SetProcessShutdownParameters"        },
    { 0x0321, "SetProcessWorkingSetSize"            },
    { 0x0322, "SetStdHandle"                        },
    { 0x0323, "SetSystemPowerState"                 },
    { 0x0324, "SetSystemTime"                       },
    { 0x0325, "SetSystemTimeAdjustment"             },
    { 0x0326, "SetTapeParameters"                   },
    { 0x0327, "SetTapePosition"                     },
    { 0x0328, "SetTermsrvAppInstallMode"            },
    { 0x0329, "SetThreadAffinityMask"               },
    { 0x032a, "SetThreadContext"                    },
    { 0x032b, "SetThreadExecutionState"             },
    { 0x032c, "SetThreadIdealProcessor"             },
    { 0x032d, "SetThreadLocale"                     },
    { 0x032e, "SetThreadPriority"                   },
    { 0x032f, "SetThreadPriorityBoost"              },
    { 0x0330, "SetThreadUILanguage"                 },
    { 0x0331, "SetTimeZoneInformation"              },
    { 0x0332, "SetTimerQueueTimer"                  },
    { 0x0333, "SetUnhandledExceptionFilter"         },
    { 0x0334, "SetUserGeoID"                        },
    { 0x0335, "SetVDMCurrentDirectories"            },
    { 0x0336, "SetVolumeLabelA"                     },
    { 0x0337, "SetVolumeLabelW"                     },
    { 0x0338, "SetVolumeMountPointA"                },
    { 0x0339, "SetVolumeMountPointW"                },
    { 0x033a, "SetWaitableTimer"                    },
    { 0x033b, "SetupComm"                           },
    { 0x033c, "ShowConsoleCursor"                   },
    { 0x033d, "SignalObjectAndWait"                 },
    { 0x033e, "SizeofResource"                      },
    { 0x033f, "Sleep"                               },
    { 0x0340, "SleepEx"                             },
    { 0x0341, "SuspendThread"                       },
    { 0x0342, "SwitchToFiber"                       },
    { 0x0343, "SwitchToThread"                      },
    { 0x0344, "SystemTimeToFileTime"                },
    { 0x0345, "SystemTimeToTzSpecificLocalTime"     },
    { 0x0346, "TerminateJobObject"                  },
    { 0x0347, "TerminateProcess"                    },
    { 0x0348, "TerminateThread"                     },
    { 0x0349, "TermsrvAppInstallMode"               },
    { 0x034a, "Thread32First"                       },
    { 0x034b, "Thread32Next"                        },
    { 0x034c, "TlsAlloc"                            },
    { 0x034d, "TlsFree"                             },
    { 0x034e, "TlsGetValue"                         },
    { 0x034f, "TlsSetValue"                         },
    { 0x0350, "Toolhelp32ReadProcessMemory"         },
    { 0x0351, "TransactNamedPipe"                   },
    { 0x0352, "TransmitCommChar"                    },
    { 0x0353, "TrimVirtualBuffer"                   },
    { 0x0354, "TryEnterCriticalSection"             },
    { 0x0355, "TzSpecificLocalTimeToSystemTime"     },
    { 0x0356, "UTRegister"                          },
    { 0x0357, "UTUnRegister"                        },
    { 0x0358, "UnhandledExceptionFilter"            },
    { 0x0359, "UnlockFile"                          },
    { 0x035a, "UnlockFileEx"                        },
    { 0x035b, "UnmapViewOfFile"                     },
    { 0x035c, "UnregisterConsoleIME"                },
    { 0x035d, "UnregisterWait"                      },
    { 0x035e, "UnregisterWaitEx"                    },
    { 0x035f, "UpdateResourceA"                     },
    { 0x0360, "UpdateResourceW"                     },
    { 0x0361, "VDMConsoleOperation"                 },
    { 0x0362, "VDMOperationStarted"                 },
    { 0x0363, "ValidateLCType"                      },
    { 0x0364, "ValidateLocale"                      },
    { 0x0365, "VerLanguageNameA"                    },
    { 0x0366, "VerLanguageNameW"                    },
    { 0x0367, "VerSetConditionMask"                 },
    { 0x0368, "VerifyConsoleIoHandle"               },
    { 0x0369, "VerifyVersionInfoA"                  },
    { 0x036a, "VerifyVersionInfoW"                  },
    { 0x036b, "VirtualAlloc"                        },
    { 0x036c, "VirtualAllocEx"                      },
    { 0x036d, "VirtualBufferExceptionHandler"       },
    { 0x036e, "VirtualFree"                         },
    { 0x036f, "VirtualFreeEx"                       },
    { 0x0370, "VirtualLock"                         },
    { 0x0371, "VirtualProtect"                      },
    { 0x0372, "VirtualProtectEx"                    },
    { 0x0373, "VirtualQuery"                        },
    { 0x0374, "VirtualQueryEx"                      },
    { 0x0375, "VirtualUnlock"                       },
    { 0x0376, "WTSGetActiveConsoleSessionId"        },
    { 0x0377, "WaitCommEvent"                       },
    { 0x0378, "WaitForDebugEvent"                   },
    { 0x0379, "WaitForMultipleObjects"              },
    { 0x037a, "WaitForMultipleObjectsEx"            },
    { 0x037b, "WaitForSingleObject"                 },
    { 0x037c, "WaitForSingleObjectEx"               },
    { 0x037d, "WaitNamedPipeA"                      },
    { 0x037e, "WaitNamedPipeW"                      },
    { 0x037f, "WideCharToMultiByte"                 },
    { 0x0380, "WinExec"                             },
    { 0x0381, "WriteConsoleA"                       },
    { 0x0382, "WriteConsoleInputA"                  },
    { 0x0383, "WriteConsoleInputVDMA"               },
    { 0x0384, "WriteConsoleInputVDMW"               },
    { 0x0385, "WriteConsoleInputW"                  },
    { 0x0386, "WriteConsoleOutputA"                 },
    { 0x0387, "WriteConsoleOutputAttribute"         },
    { 0x0388, "WriteConsoleOutputCharacterA"        },
    { 0x0389, "WriteConsoleOutputCharacterW"        },
    { 0x038a, "WriteConsoleOutputW"                 },
    { 0x038b, "WriteConsoleW"                       },
    { 0x038c, "WriteFile"                           },
    { 0x038d, "WriteFileEx"                         },
    { 0x038e, "WriteFileGather"                     },
    { 0x038f, "WritePrivateProfileSectionA"         },
    { 0x0390, "WritePrivateProfileSectionW"         },
    { 0x0391, "WritePrivateProfileStringA"          },
    { 0x0392, "WritePrivateProfileStringW"          },
    { 0x0393, "WritePrivateProfileStructA"          },
    { 0x0394, "WritePrivateProfileStructW"          },
    { 0x0395, "WriteProcessMemory"                  },
    { 0x0396, "WriteProfileSectionA"                },
    { 0x0397, "WriteProfileSectionW"                },
    { 0x0398, "WriteProfileStringA"                 },
    { 0x0399, "WriteProfileStringW"                 },
    { 0x039a, "WriteTapemark"                       },
    { 0x039b, "ZombifyActCtx"                       },
    { 0x039c, "_hread"                              },
    { 0x039d, "_hwrite"                             },
    { 0x039e, "_lclose"                             },
    { 0x039f, "_lcreat"                             },
    { 0x03a0, "_llseek"                             },
    { 0x03a1, "_lopen"                              },
    { 0x03a2, "_lread"                              },
    { 0x03a3, "_lwrite"                             },
    { 0x03a4, "lstrcat"                             },
    { 0x03a5, "lstrcatA"                            },
    { 0x03a6, "lstrcatW"                            },
    { 0x03a7, "lstrcmp"                             },
    { 0x03a8, "lstrcmpA"                            },
    { 0x03a9, "lstrcmpW"                            },
    { 0x03aa, "lstrcmpi"                            },
    { 0x03ab, "lstrcmpiA"                           },
    { 0x03ac, "lstrcmpiW"                           },
    { 0x03ad, "lstrcpy"                             },
    { 0x03ae, "lstrcpyA"                            },
    { 0x03af, "lstrcpyW"                            },
    { 0x03b0, "lstrcpyn"                            },
    { 0x03b1, "lstrcpynA"                           },
    { 0x03b2, "lstrcpynW"                           },
    { 0x03b3, "lstrlen"                             },
    { 0x03b4, "lstrlenA"                            },
    { 0x03b5, "lstrlenW"                            },
};


}
}

#endif

