# -*- coding: utf-8 -*-
# Generated by Django 1.9.2 on 2016-03-20 19:21
from __future__ import unicode_literals

from django.db import migrations, models
import django.utils.timezone
import shark.models


class Migration(migrations.Migration):

    replaces = [('shark', '0001_initial'), ('shark', '0002_auto_20160312_0243'), ('shark', '0003_staticpage'), ('shark', '0004_auto_20160312_1648'), ('shark', '0005_auto_20160312_1651'), ('shark', '0006_log')]

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='EditableText',
            fields=[
                ('name', models.CharField(max_length=128, primary_key=True, serialize=False, unique=True)),
                ('content', models.TextField()),
                ('handler_name', models.CharField(max_length=512)),
                ('last_used', models.DateTimeField(default=django.utils.timezone.now)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='StaticPage',
            fields=[
                ('url_name', models.CharField(max_length=128, primary_key=True, serialize=False, unique=True, verbose_name='URL name')),
                ('title', models.CharField(max_length=512, null=True, verbose_name='Page Title')),
                ('description', models.CharField(max_length=512, null=True, verbose_name='Meta description')),
                ('body', shark.models.MarkdownField(null=True, verbose_name='Page Markdown Content')),
                ('robots_follow', models.BooleanField(default=True, verbose_name='robots.txt follow?')),
                ('robots_index', models.BooleanField(default=True, verbose_name='robots.txt index?')),
                ('sitemap', models.BooleanField(default=True, verbose_name='Include in SiteMap?')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Log',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(default=django.utils.timezone.now)),
                ('url', models.CharField(max_length=1024)),
                ('referrer', models.CharField(blank=True, max_length=1024)),
                ('user_agent', models.CharField(blank=True, max_length=1024)),
                ('ip_address', models.GenericIPAddressField()),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
