'''
Copyright 2012 Upverter Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
'''

# Beanstream response codes taken from 'Response Codes and Messages' document
# last updated 2011/11/22
# pylint: disable=C0301
response_codes = {
  '1': {'type': 'NDC', 'approved': True, 'cardholder_message': 'Approved', 'merchant_message': 'Approved'},
  '2': {'type': 'NDC', 'approved': True, 'cardholder_message': 'Debit approved', 'merchant_message': 'Debit approved'},
  '3': {'type': 'NDC', 'approved': False, 'cardholder_message': 'DECLINE', 'merchant_message': 'Declined - Please call credit agency'},
  '4': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Issuer unavailable', 'merchant_message': 'Issuer unavailable'},
  '5': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Invalid banking merchant ID', 'merchant_message': 'Invalid banking merchant ID'},
  '6': {'type': 'NDC', 'approved': False, 'cardholder_message': 'PIC UP', 'merchant_message': 'PIC UP'},
  '7': {'type': 'NDC', 'approved': False, 'cardholder_message': 'DECLINE', 'merchant_message': 'Transaction Declined'},
  '8': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Transaction reversed', 'merchant_message': 'Transaction reversed'},
  '9': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Approved with ID', 'merchant_message': 'Approved with ID'},
  '10': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Invalid serv ID', 'merchant_message': 'Invalid serv ID'},
  '11': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Invalid transaction amount', 'merchant_message': 'Invalid transaction amount'},
  '12': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Invalid account', 'merchant_message': 'Invalid account'},
  '13': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Please retry transaction', 'merchant_message': 'Please retry transaction'},
  '14': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Invalid expiration date', 'merchant_message': 'Invalid expiration date'},
  '15': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Unauthorized transaction', 'merchant_message': 'Unauthorized transaction'},
  '16': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Duplicate Transaction - This transaction has already been approved', 'merchant_message': 'Duplicate Transaction - This transaction has already been approved'},
  '17': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Current batch must be settled', 'merchant_message': 'Current batch must be settled'},
  '18': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Electronic Draft Capture unavailable', 'merchant_message': 'Electronic Draft Capture unavailable'},
  '19': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Unexpected error', 'merchant_message': 'Unexpected error'},
  '20': {'type': 'NDC', 'approved': False, 'cardholder_message': 'License has expired - Unable to authorize', 'merchant_message': 'License has expired - Unable to authorize'},
  '21': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Validation is less than the minimum amount', 'merchant_message': 'Validation is less than the minimum amount'},
  '22': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Validation greater than maximum amount', 'merchant_message': 'Validation greater than maximum amount'},
  '23': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Validation - Bad data', 'merchant_message': 'Validation - Bad data'},
  '24': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Bad card number', 'merchant_message': 'Bad card number'},
  '25': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Bad card', 'merchant_message': 'Bad card'},
  '26': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Invalid expiry date', 'merchant_message': 'Invalid expiry date'},
  '27': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Timer Exceeded', 'merchant_message': 'Timer Exceeded'},
  '28': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Bad logical merchant number', 'merchant_message': 'Bad logical merchant number'},
  '29': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Security Violation', 'merchant_message': 'Security Violation'},
  '30': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Com Port Open Error', 'merchant_message': 'Com Port Open Error'},
  '31': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Max Com Reties', 'merchant_message': 'Max Com Reties'},
  '32': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Open File Error', 'merchant_message': 'Open File Error'},
  '33': {'type': 'NDC', 'approved': False, 'cardholder_message': 'User or Remote Abort', 'merchant_message': 'User or Remote Abort'},
  '34': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Com Error', 'merchant_message': 'Com Error'},
  '35': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Error expired license', 'merchant_message': 'Error expired license'},
  '36': {'type': 'NDC', 'approved': False, 'cardholder_message': 'No Pickup', 'merchant_message': 'No Pickup'},
  '37': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Incomplete', 'merchant_message': 'Incomplete'},
  '38': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Communication error', 'merchant_message': 'Communication error'},
  '39': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Error Tranaction Type', 'merchant_message': 'Error Tranaction Type'},
  '40': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Error Data Dictionary', 'merchant_message': 'Error Data Dictionary'},
  '41': {'type': 'NDC', 'approved': False, 'cardholder_message': 'ErrorGetSc', 'merchant_message': 'ErrorGetSc'},
  '42': {'type': 'NDC', 'approved': False, 'cardholder_message': 'ErrorExeSc', 'merchant_message': 'ErrorExeSc'},
  '43': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Error Velocity', 'merchant_message': 'Error Velocity'},
  '44': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Error Stale Dated Input File', 'merchant_message': 'Error Stale Dated Input File'},
  '45': {'type': 'NDC', 'approved': False, 'cardholder_message': 'ForcdCmplt', 'merchant_message': 'ForcdCmplt'},
  '46': {'type': 'NDC', 'approved': False, 'cardholder_message': 'ErrorSrvNr', 'merchant_message': 'ErrorSrvNr'},
  '47': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Printer configuration error', 'merchant_message': 'Printer configuration error'},
  '48': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Card reader configuration error', 'merchant_message': 'Card reader configuration error'},
  '49': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Invalid transaction request string', 'merchant_message': 'Invalid transaction request string'},
  '50': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Invalid transaction type', 'merchant_message': 'Invalid transaction type'},
  '51': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'DECLINE', 'merchant_message': 'Restricted Card or IP'},
  '52': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Invalid Card Number', 'merchant_message': 'Invalid Card Number'},
  '53': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Application Error - Sending Request', 'merchant_message': 'Application Error - Sending Request'},
  '54': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Transaction timeout - No available device', 'merchant_message': 'Transaction timeout - No available device'},
  '55': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Transaction timeout - No transaction Response', 'merchant_message': 'Transaction timeout - No transaction Response'},
  '56': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Aplication Error - Retrieving Response', 'merchant_message': 'Aplication Error - Retrieving Response'},
  '57': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Transaction Amount greater than processing limit.', 'merchant_message': 'Transaction Amount greater than processing limit.'},
  '58': {'type': 'NDC', 'approved': False, 'cardholder_message': 'DECLINE', 'merchant_message': 'Declined'},
  '59': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Declined - Operation must be performed by Master Merchant', 'merchant_message': 'Declined - Operation must be performed by Master Merchant'},
  '60': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Declined - Operation restricted through Master Merchant', 'merchant_message': 'Declined - Operation restricted through Master Merchant'},
  '61': {'type': 'TD Bank', 'approved': True, 'cardholder_message': 'Approved', 'merchant_message': 'Approved'},
  '62': {'type': 'TD Bank', 'approved': True, 'cardholder_message': 'Approved', 'merchant_message': 'Approved'},
  '63': {'type': 'TD Bank', 'approved': True, 'cardholder_message': 'Approved', 'merchant_message': 'Approved'},
  '64': {'type': 'TD Bank', 'approved': True, 'cardholder_message': 'Approved', 'merchant_message': 'Approved'},
  '65': {'type': 'TD Bank', 'approved': True, 'cardholder_message': 'Approved', 'merchant_message': 'Approved'},
  '66': {'type': 'TD Bank', 'approved': True, 'cardholder_message': 'Approved', 'merchant_message': 'Approved'},
  '67': {'type': 'TD Bank', 'approved': True, 'cardholder_message': 'Approved', 'merchant_message': 'Approved'},
  '68': {'type': 'TD Bank', 'approved': True, 'cardholder_message': 'Approved', 'merchant_message': 'Approved'},
  '69': {'type': 'TD Bank', 'approved': True, 'cardholder_message': 'Approved', 'merchant_message': 'Approved'},
  '70': {'type': 'TD Bank', 'approved': True, 'cardholder_message': 'Approved', 'merchant_message': 'Approved'},
  '71': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '72': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined EXPIRED CARD', 'merchant_message': 'Declined EXPIRED CARD'},
  '73': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '74': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '75': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '76': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'PLEASE TRY AGAIN', 'merchant_message': 'PLEASE TRY AGAIN'},
  '77': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '78': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '79': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '80': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '81': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '82': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '83': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '84': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '85': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '86': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'PLEASE TRY AGAIN', 'merchant_message': 'Declined'},
  '87': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined ADJ NOT ALLOWED'},
  '88': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '89': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined INVALID TRAN DATE'},
  '90': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '91': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'PLEASE TRY AGAIN', 'merchant_message': 'Declined'},
  '92': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '93': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '94': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '95': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '96': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '97': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '98': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '99': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '100': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined DUPLICATE TRAN'},
  '101': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '102': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '103': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined MAX PER REFUND'},
  '104': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined NUM TIMES USED'},
  '105': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined MAX REFUND TOTAL'},
  '106': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '107': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '108': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '109': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined MAX REFUND NUMBER'},
  '110': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '111': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '112': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '113': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '114': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '115': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '116': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '117': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '118': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '119': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '120': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '121': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '122': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '123': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Call for Auth', 'merchant_message': 'Call for Auth'},
  '124': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '125': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '126': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '127': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined CARD NOT SUPPORTED'},
  '128': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '129': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '130': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '131': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '132': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '133': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '134': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '135': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '136': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '137': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '138': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '139': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined SERVICE MERCHANT NOT ON FILE'},
  '140': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '141': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '142': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '143': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '144': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '145': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '146': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '147': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined INVALID TRAN DATE'},
  '148': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined INVALID EXP DATE'},
  '149': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined INVALID TRANCODE'},
  '150': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '151': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '152': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '153': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '154': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined BAD FORMAT'},
  '155': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined BAD DATA'},
  '156': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '157': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '158': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'PLEASE TRY AGAIN', 'merchant_message': 'Declined - TIMEOUT'},
  '159': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '160': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined TERMINAL DEACTIVATED'},
  '161': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined BAD RESPONSE LENGTH'},
  '162': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '163': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '164': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '165': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '166': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined BAD SEQUENCE NUMBER'},
  '167': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '168': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined EXPIRED CARD'},
  '169': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '170': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '171': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '172': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '173': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '174': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '175': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '176': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '177': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined ADMIN CARD NOT FOUND'},
  '178': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined ADMIN CARD NOT ALLOWED'},
  '179': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '180': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '181': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '182': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '183': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '184': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '185': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '186': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '187': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '188': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '189': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '190': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Unknown transaction response', 'merchant_message': 'Unknown transaction response'},
  '191': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Invalid Transaction Amount', 'merchant_message': 'Invalid Transaction Amount'},
  '192': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Transaction cannot be voided after being returned', 'merchant_message': 'Transaction cannot be voided after being returned'},
  '193': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Amount does not match the transaction you are modifying.', 'merchant_message': 'Amount does not match the transaction you are modifying.'},
  '194': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Transaction exceeds return limit.', 'merchant_message': 'Transaction exceeds return limit.'},
  '195': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Invalid adjustment amount.', 'merchant_message': 'Invalid adjustment amount.'},
  '196': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Original purchase transaction has been voided', 'merchant_message': 'Original purchase transaction has been voided'},
  '197': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Transactions cannot be adjusted to a zero or negative value', 'merchant_message': 'Transactions cannot be adjusted to a zero or negative value'},
  '198': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Zero value transactions cannot be voided', 'merchant_message': 'Zero value transactions cannot be voided'},
  '199': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Credit card does not match original purchase.', 'merchant_message': 'Credit card does not match original purchase.'},
  '200': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Transaction cannot be adjusted', 'merchant_message': 'Transaction cannot be adjusted'},
  '201': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Invalid transaction adjustment ID', 'merchant_message': 'Invalid transaction adjustment ID'},
  '202': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Invalid order number', 'merchant_message': 'Invalid order number'},
  '203': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Pre-Authorization already completed', 'merchant_message': 'Pre-Authorization already completed'},
  '204': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Declined: Use Pre-Auth Completion', 'merchant_message': 'Declined: Use Pre-Auth Completion'},
  '205': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Transaction only voidable on the date processed', 'merchant_message': 'Transaction only voidable on the date processed'},
  '206': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Account missing terminal id', 'merchant_message': 'Account missing terminal id'},
  '207': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Invalid merchant id', 'merchant_message': 'Invalid merchant id'},
  '208': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Completion greater than remaining reserve amount.', 'merchant_message': 'Completion greater than remaining reserve amount.'},
  '209': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Merchant Account Disabled', 'merchant_message': 'Merchant Account Disabled'},
  '210': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Merchant Account Closed', 'merchant_message': 'Merchant Account Closed'},
  '211': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Service Unavailable - Please try again later', 'merchant_message': 'Service Unavailable - Please try again later'},
  '212': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Service Unavailable - Please try again later', 'merchant_message': 'Service Unavailable - Please try again later'},
  '213': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Invalid or missing AVS address', 'merchant_message': 'Invalid or missing AVS address'},
  '214': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Transaction reversed', 'merchant_message': 'Transaction reversed'},
  '215': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Address Validation Failed', 'merchant_message': 'Address Validation Failed'},
  '216': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Validation greater than maximum amount', 'merchant_message': 'Validation greater than maximum amount'},
  '217': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'DECLINE', 'merchant_message': 'Transaction Declined TR'},
  '218': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'DECLINE', 'merchant_message': 'Transaction Declined AC'},
  '219': {'type': 'NDC', 'approved': False, 'cardholder_message': 'PIN INVLD', 'merchant_message': 'PIN INVLD'},
  '220': {'type': 'NDC', 'approved': False, 'cardholder_message': 'MAX PIN RETRIES', 'merchant_message': 'MAX PIN RETRIES'},
  '221': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INV ACCT MATCH', 'merchant_message': 'INV ACCT MATCH'},
  '222': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INV AMT MATCH', 'merchant_message': 'INV AMT MATCH'},
  '223': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INV ITEM NUM', 'merchant_message': 'INV ITEM NUM'},
  '224': {'type': 'NDC', 'approved': False, 'cardholder_message': 'ITEM REV-VOIDED', 'merchant_message': 'ITEM REV-VOIDED'},
  '225': {'type': 'NDC', 'approved': False, 'cardholder_message': 'USE DUP THEN BALANCE NOW', 'merchant_message': 'USE DUP THEN BALANCE NOW'},
  '226': {'type': 'NDC', 'approved': False, 'cardholder_message': 'NO DUPE FOUND', 'merchant_message': 'NO DUPE FOUND'},
  '227': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INVALID DATA', 'merchant_message': 'INVALID DATA'},
  '228': {'type': 'NDC', 'approved': False, 'cardholder_message': 'NO TRANS FOUND', 'merchant_message': 'NO TRANS FOUND'},
  '229': {'type': 'NDC', 'approved': False, 'cardholder_message': 'AP NOT CAPTURED', 'merchant_message': 'AP NOT CAPTURED'},
  '230': {'type': 'NDC', 'approved': False, 'cardholder_message': 'AP AUTH ONLY', 'merchant_message': 'AP AUTH ONLY'},
  '231': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INV BANK', 'merchant_message': 'INV BANK'},
  '232': {'type': 'NDC', 'approved': False, 'cardholder_message': 'TRAN TYPE INVLD', 'merchant_message': 'TRAN TYPE INVLD'},
  '233': {'type': 'NDC', 'approved': False, 'cardholder_message': 'DB UNAVAIL 02', 'merchant_message': 'DB UNAVAIL 02'},
  '234': {'type': 'NDC', 'approved': False, 'cardholder_message': 'DB UNAVAIL 03', 'merchant_message': 'DB UNAVAIL 03'},
  '235': {'type': 'NDC', 'approved': False, 'cardholder_message': 'DB UNAVAIL 04', 'merchant_message': 'DB UNAVAIL 04'},
  '236': {'type': 'NDC', 'approved': False, 'cardholder_message': 'UNAUTH USER', 'merchant_message': 'UNAUTH USER'},
  '237': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INVALID CARD', 'merchant_message': 'INVALID CARD'},
  '238': {'type': 'NDC', 'approved': False, 'cardholder_message': 'DB ISSUER UNAVAIL', 'merchant_message': 'DB ISSUER UNAVAIL'},
  '239': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INVALID POS CARD', 'merchant_message': 'INVALID POS CARD'},
  '240': {'type': 'NDC', 'approved': False, 'cardholder_message': 'ACCT TYPE INVLD', 'merchant_message': 'ACCT TYPE INVLD'},
  '241': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INVALID PREFIX', 'merchant_message': 'INVALID PREFIX'},
  '242': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INVALID FIID', 'merchant_message': 'INVALID FIID'},
  '243': {'type': 'NDC', 'approved': False, 'cardholder_message': 'VERIFY', 'merchant_message': 'VERIFY'},
  '244': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INVALID LIC', 'merchant_message': 'INVALID LIC'},
  '245': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INVALID STATE CD', 'merchant_message': 'INVALID STATE CD'},
  '246': {'type': 'NDC', 'approved': False, 'cardholder_message': 'DB UNAVAIL 01', 'merchant_message': 'DB UNAVAIL 01'},
  '247': {'type': 'NDC', 'approved': False, 'cardholder_message': 'SCAN UNAVAILABLE', 'merchant_message': 'SCAN UNAVAILABLE'},
  '248': {'type': 'NDC', 'approved': False, 'cardholder_message': 'EXCEEDS MAX AMT', 'merchant_message': 'EXCEEDS MAX AMT'},
  '249': {'type': 'NDC', 'approved': False, 'cardholder_message': 'EXCEEDS MAX USERS', 'merchant_message': 'EXCEEDS MAX USERS'},
  '250': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INVALID USER ID/PIN', 'merchant_message': 'INVALID USER ID/PIN'},
  '251': {'type': 'NDC', 'approved': False, 'cardholder_message': 'AMOUNT BELOW MINIMUM', 'merchant_message': 'AMOUNT BELOW MINIMUM'},
  '252': {'type': 'NDC', 'approved': False, 'cardholder_message': 'AMOUNT OVER MAXIMUM', 'merchant_message': 'AMOUNT OVER MAXIMUM'},
  '253': {'type': 'NDC', 'approved': False, 'cardholder_message': 'AMOUNT BADLY FORMED', 'merchant_message': 'AMOUNT BADLY FORMED'},
  '254': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INVALID USER ID/PIN', 'merchant_message': 'INVALID USER ID/PIN'},
  '255': {'type': 'NDC', 'approved': False, 'cardholder_message': 'CERT. DOES NOT EXIST', 'merchant_message': 'CERT. DOES NOT EXIST'},
  '256': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INV. CERT. FOR STORE', 'merchant_message': 'INV. CERT. FOR STORE'},
  '257': {'type': 'NDC', 'approved': False, 'cardholder_message': 'CERTIFICATE CLOSED', 'merchant_message': 'CERTIFICATE CLOSED'},
  '258': {'type': 'NDC', 'approved': False, 'cardholder_message': 'CERTIFICATE EXPIRED', 'merchant_message': 'CERTIFICATE EXPIRED'},
  '259': {'type': 'NDC', 'approved': False, 'cardholder_message': 'AMOUNT BELOW MINIMUM', 'merchant_message': 'AMOUNT BELOW MINIMUM'},
  '260': {'type': 'NDC', 'approved': False, 'cardholder_message': 'AMOUNT OVER MAXIMUM', 'merchant_message': 'AMOUNT OVER MAXIMUM'},
  '261': {'type': 'NDC', 'approved': False, 'cardholder_message': 'AMOUNT BADLY FORMED', 'merchant_message': 'AMOUNT BADLY FORMED'},
  '262': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INVALID USER ID/PIN', 'merchant_message': 'INVALID USER ID/PIN'},
  '263': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INVALID AMOUNT', 'merchant_message': 'INVALID AMOUNT'},
  '264': {'type': 'NDC', 'approved': False, 'cardholder_message': 'CERT. ALREADY ACTIVE', 'merchant_message': 'CERT. ALREADY ACTIVE'},
  '265': {'type': 'NDC', 'approved': False, 'cardholder_message': 'CERT. DOES NOT EXIST', 'merchant_message': 'CERT. DOES NOT EXIST'},
  '266': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INVALID USER ID/PIN', 'merchant_message': 'INVALID USER ID/PIN'},
  '267': {'type': 'NDC', 'approved': False, 'cardholder_message': 'CERT. DOES NOT EXIST', 'merchant_message': 'CERT. DOES NOT EXIST'},
  '268': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INV. CERT. FOR STORE', 'merchant_message': 'INV. CERT. FOR STORE'},
  '269': {'type': 'NDC', 'approved': False, 'cardholder_message': 'CERTIFICATE REDEEMED', 'merchant_message': 'CERTIFICATE REDEEMED'},
  '270': {'type': 'NDC', 'approved': False, 'cardholder_message': 'CERTIFICATE EXPIRED', 'merchant_message': 'CERTIFICATE EXPIRED'},
  '271': {'type': 'NDC', 'approved': False, 'cardholder_message': 'VALIDATION NO MATCH', 'merchant_message': 'VALIDATION NO MATCH'},
  '272': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INCORRECT AMOUNT', 'merchant_message': 'INCORRECT AMOUNT'},
  '273': {'type': 'NDC', 'approved': False, 'cardholder_message': 'VALIDATION NO MATCH', 'merchant_message': 'VALIDATION NO MATCH'},
  '274': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INVALID USER ID/PIN', 'merchant_message': 'INVALID USER ID/PIN'},
  '275': {'type': 'NDC', 'approved': False, 'cardholder_message': 'CERT. DOES NOT EXIST', 'merchant_message': 'CERT. DOES NOT EXIST'},
  '276': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INV. TRAN. FOR STORE', 'merchant_message': 'INV. TRAN. FOR STORE'},
  '277': {'type': 'NDC', 'approved': False, 'cardholder_message': 'CERTIFICATE TOO OLD', 'merchant_message': 'CERTIFICATE TOO OLD'},
  '278': {'type': 'NDC', 'approved': False, 'cardholder_message': 'INCORRECT AMOUNT', 'merchant_message': 'INCORRECT AMOUNT'},
  '279': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Velocity >$Daily Max', 'merchant_message': 'Velocity >$Daily Max'},
  '280': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Velocity >%Daily Max', 'merchant_message': 'Velocity >%Daily Max'},
  '281': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Velocity >Bad Daily Max', 'merchant_message': 'Velocity >Bad Daily Max'},
  '282': {'type': 'NDC', 'approved': False, 'cardholder_message': 'AP DUPE', 'merchant_message': 'AP DUPE'},
  '283': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Msg Error', 'merchant_message': 'Msg Error'},
  '284': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Velocity <$Min', 'merchant_message': 'Velocity <$Min'},
  '285': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Velocity <>Avg', 'merchant_message': 'Velocity <>Avg'},
  '286': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Velocity Neg File', 'merchant_message': 'Velocity Neg File'},
  '287': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Err PinPad Config PPxxxxx', 'merchant_message': 'Err PinPad Config PPxxxxx'},
  '288': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Err Settle File Sharing', 'merchant_message': 'Err Settle File Sharing'},
  '289': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Engine Aborted By Request', 'merchant_message': 'Engine Aborted By Request'},
  '290': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Engine Aborted By Request', 'merchant_message': 'Engine Aborted By Request'},
  '291': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Service Unavailable - Please try again later', 'merchant_message': 'Service Unavailable - Please try again later'},
  '292': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Err Bad Password', 'merchant_message': 'Err Bad Password'},
  '293': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Err Operation Not Permitted', 'merchant_message': 'Err Operation Not Permitted'},
  '294': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Err Archived Batch Not Found', 'merchant_message': 'Err Archived Batch Not Found'},
  '295': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Err Ext.Data Config EDxxxxx', 'merchant_message': 'Err Ext.Data Config EDxxxxx'},
  '296': {'type': 'NDC', 'approved': False, 'cardholder_message': 'Err Ext.Data Failure EDxxxxx', 'merchant_message': 'Err Ext.Data Failure EDxxxxx'},
  '297': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Service Unavailable - Please try again later', 'merchant_message': 'Service Unavailable - Please try again later'},
  '298': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Service Unavailable - Please try again later', 'merchant_message': 'Service Unavailable - Please try again later'},
  '299': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Service Unavailable - Please try again later', 'merchant_message': 'Service Unavailable - Please try again later'},
  '300': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Service Unavailable - Please try again later', 'merchant_message': 'Service Unavailable - Please try again later'},
  '301': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Service Unavailable - Please try again later', 'merchant_message': 'Service Unavailable - Please try again later'},
  '302': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Service Unavailable - Please try again later', 'merchant_message': 'Service Unavailable - Please try again later'},
  '303': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Service Unavailable - Please try again later', 'merchant_message': 'Service Unavailable - Please try again later'},
  '304': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Service Unavailable - Please try again later', 'merchant_message': 'Service Unavailable - Please try again later'},
  '305': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Service Unavailable - Please try again later', 'merchant_message': 'Service Unavailable - Please try again later'},
  '306': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Service Unavailable - Please try again later', 'merchant_message': 'Service Unavailable - Please try again later'},
  '307': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Service Unavailable - Please try again later', 'merchant_message': 'Service Unavailable - Please try again later'},
  '308': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Service Unavailable - Please try again later', 'merchant_message': 'Service Unavailable - Please try again later'},
  '309': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Service Unavailable - Please try again later', 'merchant_message': 'Service Unavailable - Please try again later'},
  '310': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Service Unavailable - Please try again later', 'merchant_message': 'Service Unavailable - Please try again later'},
  '311': {'type': 'Beanstream', 'approved': False, 'cardholder_message': '3D Secure Failed', 'merchant_message': '3D Secure Failed'},
  '312': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Card type not accepted', 'merchant_message': 'Card type not accepted'},
  '313': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'DECLINE', 'merchant_message': 'Over sales limit'},
  '314': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Missing or invalid payment information - Please validate all required payment information.', 'merchant_message': 'Missing or invalid consumer payment information'},
  '315': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'CALL HELP DESK', 'merchant_message': 'HTTPS Connection Required'},
  '316': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'CALL HELP DESK', 'merchant_message': 'Invalid transaction validation type'},
  '317': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'CALL HELP DESK', 'merchant_message': 'Authentication Failed'},
  '318': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'CALL HELP DESK', 'merchant_message': 'No transaction request data received'},
  '319': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'CALL HELP DESK', 'merchant_message': 'Transaction Declined - Restricted transaction type'},
  '320': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'CALL HELP DESK', 'merchant_message': 'Missing errorPage URL'},
  '321': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'CALL HELP DESK', 'merchant_message': 'Missing or invalid return URL'},
  '322': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'CALL HELP DESK', 'merchant_message': 'Transaction amount does not match inventory calculation'},
  '323': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'CALL HELP DESK', 'merchant_message': 'One or more products not found in inventory'},
  '324': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'CALL HELP DESK', 'merchant_message': 'Invalid product quantity'},
  '325': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'File Transfer Approved', 'merchant_message': 'File Transfer Approved'},
  '326': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Declined - Invalid bank account', 'merchant_message': 'Declined - Invalid bank account'},
  '327': {'type': 'NDC', 'approved': False, 'cardholder_message': 'DECLINE', 'merchant_message': 'Declined - Invalid CVD'},
  '328': {'type': 'Beanstream', 'approved': True, 'cardholder_message': 'Non sufficient Funds', 'merchant_message': 'Non sufficient Funds'},
  '329': {'type': 'Beanstream', 'approved': True, 'cardholder_message': 'Account Closed', 'merchant_message': 'Account Closed'},
  '330': {'type': 'Beanstream', 'approved': True, 'cardholder_message': 'Invalid Account', 'merchant_message': 'Invalid Account'},
  '331': {'type': 'Beanstream', 'approved': True, 'cardholder_message': 'Payment Stoped', 'merchant_message': 'Payment Stoped'},
  '332': {'type': 'Beanstream', 'approved': True, 'cardholder_message': 'Cannot trace account', 'merchant_message': 'Cannot trace account'},
  '334': {'type': 'Beanstream', 'approved': True, 'cardholder_message': 'No chequing privleges', 'merchant_message': 'No chequing privleges'},
  '335': {'type': 'Beanstream', 'approved': True, 'cardholder_message': 'Funds not cleared', 'merchant_message': 'Funds not cleared'},
  '336': {'type': 'Beanstream', 'approved': True, 'cardholder_message': 'Payor/Payee Deceased', 'merchant_message': 'Payor/Payee Deceased'},
  '337': {'type': 'Beanstream', 'approved': True, 'cardholder_message': 'Account frozen', 'merchant_message': 'Account frozen'},
  '338': {'type': 'Beanstream', 'approved': True, 'cardholder_message': 'Incorrect payor/payee name', 'merchant_message': 'Incorrect payor/payee name'},
  '339': {'type': 'Beanstream', 'approved': True, 'cardholder_message': 'Refused by payor/payee', 'merchant_message': 'Refused by payor/payee'},
  '340': {'type': 'Beanstream', 'approved': True, 'cardholder_message': 'Payment recalled', 'merchant_message': 'Payment recalled'},
  '341': {'type': 'Beanstream', 'approved': True, 'cardholder_message': 'Interbank reject - Invalid due date', 'merchant_message': 'Interbank reject - Invalid due date'},
  '342': {'type': 'Beanstream', 'approved': True, 'cardholder_message': 'Interbank reject - Invalid institution number', 'merchant_message': 'Interbank reject - Invalid institution number'},
  '343': {'type': 'Beanstream', 'approved': True, 'cardholder_message': 'Interbank reject - Invalid account number', 'merchant_message': 'Interbank reject - Invalid account number'},
  '344': {'type': 'Beanstream', 'approved': True, 'cardholder_message': 'Interbank reject - Invalid institution and account number', 'merchant_message': 'Interbank reject - Invalid institution and account number'},
  '345': {'type': 'Beanstream', 'approved': True, 'cardholder_message': 'Interbank reject - Other', 'merchant_message': 'Interbank reject - Other'},
  '346': {'type': 'Paymentech', 'approved': True, 'cardholder_message': 'Approved', 'merchant_message': 'Approved'},
  '347': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Auth Declined', 'merchant_message': 'Auth Declined'},
  '348': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Call Voice Oper', 'merchant_message': 'Call Voice Oper'},
  '349': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Hold - Call', 'merchant_message': 'Hold - Call'},
  '350': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Call Voice Oper', 'merchant_message': 'Call Voice Oper'},
  '351': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Card No', 'merchant_message': 'Invalid Card No'},
  '352': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Exp. Date', 'merchant_message': 'Invalid Exp. Date'},
  '353': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid ICA No', 'merchant_message': 'Invalid ICA No'},
  '354': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid ABA No', 'merchant_message': 'Invalid ABA No'},
  '355': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid PIN No', 'merchant_message': 'Invalid PIN No'},
  '356': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Bank MID', 'merchant_message': 'Invalid Bank MID'},
  '357': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Term No', 'merchant_message': 'Invalid Term No'},
  '358': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Amount', 'merchant_message': 'Invalid Amount'},
  '359': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Tran Fmt', 'merchant_message': 'Invalid Tran Fmt'},
  '360': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Call Voice Oper', 'merchant_message': 'Call Voice Oper'},
  '361': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Lost/Stolen Card', 'merchant_message': 'Lost/Stolen Card'},
  '362': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid PIN', 'merchant_message': 'Invalid PIN'},
  '363': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Over Credit Flr', 'merchant_message': 'Over Credit Flr'},
  '364': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Request Denied', 'merchant_message': 'Request Denied'},
  '365': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Not Online to XX', 'merchant_message': 'Not Online to XX'},
  '366': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Auth Down-Retry', 'merchant_message': 'Auth Down-Retry'},
  '367': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Auth Declined', 'merchant_message': 'Auth Declined'},
  '368': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Pin No', 'merchant_message': 'Invalid Pin No'},
  '369': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Auth Declined', 'merchant_message': 'Auth Declined'},
  '370': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Card Not Allowed', 'merchant_message': 'Card Not Allowed'},
  '371': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'PL Setup Reqd', 'merchant_message': 'PL Setup Reqd'},
  '372': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'BIN Not Allowed', 'merchant_message': 'BIN Not Allowed'},
  '373': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Card Not Allowed', 'merchant_message': 'Card Not Allowed'},
  '374': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Inv Merc Rstrct Code', 'merchant_message': 'Inv Merc Rstrct Code'},
  '375': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Prod Restricted', 'merchant_message': 'Prod Restricted'},
  '376': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Prod Not On File', 'merchant_message': 'Prod Not On File'},
  '377': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Auth Declined', 'merchant_message': 'Auth Declined'},
  '378': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Auth Declined', 'merchant_message': 'Auth Declined'},
  '379': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Auth Declined', 'merchant_message': 'Auth Declined'},
  '380': {'type': 'Paymentech', 'approved': False, 'cardholder_message': '*Request Denied*', 'merchant_message': '*Request Denied*'},
  '381': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Driver Number', 'merchant_message': 'Invalid Driver Number'},
  '382': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'PIN Not Selected', 'merchant_message': 'PIN Not Selected'},
  '383': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Unmatch Vch Info', 'merchant_message': 'Unmatch Vch Info'},
  '384': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'CVC2/CID ERROR', 'merchant_message': 'CVC2/CID ERROR'},
  '385': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Tran Not Defined', 'merchant_message': 'Tran Not Defined'},
  '386': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Block Act Not Alwd', 'merchant_message': 'Block Act Not Alwd'},
  '387': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Incorrect Act Amt', 'merchant_message': 'Incorrect Act Amt'},
  '388': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Auth Down - Retry', 'merchant_message': 'Auth Down - Retry'},
  '389': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Auth Busy - Retry', 'merchant_message': 'Auth Busy - Retry'},
  '390': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Auth Busy - Retry', 'merchant_message': 'Auth Busy - Retry'},
  '391': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Auth Error - Retry', 'merchant_message': 'Auth Error - Retry'},
  '392': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Err - Pls Retry', 'merchant_message': 'Err - Pls Retry'},
  '393': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Err - Pls Retry', 'merchant_message': 'Err - Pls Retry'},
  '394': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Term ID', 'merchant_message': 'Invalid Term ID'},
  '395': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Function', 'merchant_message': 'Invalid Function'},
  '396': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Card', 'merchant_message': 'Invalid Card'},
  '397': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Exp. Date', 'merchant_message': 'Invalid Exp. Date'},
  '398': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Action Code', 'merchant_message': 'Invalid Action Code'},
  '399': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Amt Entry Error', 'merchant_message': 'Amt Entry Error'},
  '400': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid PIN', 'merchant_message': 'Invalid PIN'},
  '401': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Card', 'merchant_message': 'Invalid Card'},
  '402': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Auth # Not Entered', 'merchant_message': 'Auth # Not Entered'},
  '403': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Down Pay Ind', 'merchant_message': 'Invalid Down Pay Ind'},
  '404': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Policy # Wrong Len', 'merchant_message': 'Policy # Wrong Len'},
  '405': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Ind Code', 'merchant_message': 'Invalid Ind Code'},
  '406': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Function', 'merchant_message': 'Invalid Function'},
  '407': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Entry Mode Invalid', 'merchant_message': 'Entry Mode Invalid'},
  '408': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Industry Data', 'merchant_message': 'Invalid Industry Data'},
  '409': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Inv Fleet Data', 'merchant_message': 'Inv Fleet Data'},
  '410': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Sys Info', 'merchant_message': 'Invalid Sys Info'},
  '411': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Format', 'merchant_message': 'Invalid Format'},
  '412': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Inv Transaction Class', 'merchant_message': 'Inv Transaction Class'},
  '413': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Inv PIN Capability', 'merchant_message': 'Inv PIN Capability'},
  '414': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Inv/Missing Retr Ref', 'merchant_message': 'Inv/Missing Retr Ref'},
  '415': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Inv MSDI', 'merchant_message': 'Inv MSDI'},
  '416': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Duration', 'merchant_message': 'Invalid Duration'},
  '417': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Inv Pref Cust Ind', 'merchant_message': 'Inv Pref Cust Ind'},
  '418': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Inv MO/TO Number', 'merchant_message': 'Inv MO/TO Number'},
  '419': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Inv Sale/Chg Des/Folio', 'merchant_message': 'Inv Sale/Chg Des/Folio'},
  '420': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Inv Mult Clr Seq No', 'merchant_message': 'Inv Mult Clr Seq No'},
  '421': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Inv Purch Card Data', 'merchant_message': 'Inv Purch Card Data'},
  '422': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Inv Input/Use VRU', 'merchant_message': 'Inv Input/Use VRU'},
  '423': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid EC Data 329', 'merchant_message': 'Invalid EC Data 329'},
  '424': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'INV Function or Multiple FS or Unknown TKN', 'merchant_message': 'INV Function or Multiple FS or Unknown TKN'},
  '425': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'INV TKN Value', 'merchant_message': 'INV TKN Value'},
  '426': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'CVD Data Error', 'merchant_message': 'CVD Data Error'},
  '427': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'TKN Data Error', 'merchant_message': 'TKN Data Error'},
  '428': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Term ID', 'merchant_message': 'Invalid Term ID'},
  '429': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Term ID', 'merchant_message': 'Invalid Term ID'},
  '430': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Term Not Active', 'merchant_message': 'Term Not Active'},
  '431': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Act Code', 'merchant_message': 'Invalid Act Code'},
  '432': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Void Not Allowed', 'merchant_message': 'Void Not Allowed'},
  '433': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Ref Num Not Found', 'merchant_message': 'Ref Num Not Found'},
  '434': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Proc Error 7', 'merchant_message': 'Proc Error 7'},
  '435': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Too Many Batches', 'merchant_message': 'Too Many Batches'},
  '436': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Release Batch', 'merchant_message': 'Release Batch'},
  '437': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Function', 'merchant_message': 'Invalid Function'},
  '438': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Term ID', 'merchant_message': 'Invalid Term ID'},
  '439': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Term ID', 'merchant_message': 'Invalid Term ID'},
  '440': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Proc Error 13', 'merchant_message': 'Proc Error 13'},
  '441': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Proc Error 14', 'merchant_message': 'Proc Error 14'},
  '442': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Proc Error 15', 'merchant_message': 'Proc Error 15'},
  '443': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Function', 'merchant_message': 'Invalid Function'},
  '444': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Function', 'merchant_message': 'Invalid Function'},
  '445': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Function', 'merchant_message': 'Invalid Function'},
  '446': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Please Try Again', 'merchant_message': 'Please Try Again'},
  '447': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Function', 'merchant_message': 'Invalid Function'},
  '448': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Amount Too Large', 'merchant_message': 'Amount Too Large'},
  '449': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Amount Too Large', 'merchant_message': 'Amount Too Large'},
  '450': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Term ID', 'merchant_message': 'Invalid Term ID'},
  '451': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Proc Error 24', 'merchant_message': 'Proc Error 24'},
  '452': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Term ID', 'merchant_message': 'Invalid Term ID'},
  '453': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Function', 'merchant_message': 'Invalid Function'},
  '454': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Rev Not Allowed', 'merchant_message': 'Rev Not Allowed'},
  '455': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Rev Not Allowed', 'merchant_message': 'Rev Not Allowed'},
  '456': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Dscv Not Allowed', 'merchant_message': 'Dscv Not Allowed'},
  '457': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Rev Not Allowed', 'merchant_message': 'Rev Not Allowed'},
  '458': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Dscv Not Allowed', 'merchant_message': 'Dscv Not Allowed'},
  '459': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'DC Not Allowed', 'merchant_message': 'DC Not Allowed'},
  '460': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'CB Not Allowed', 'merchant_message': 'CB Not Allowed'},
  '461': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Key', 'merchant_message': 'Invalid Key'},
  '462': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Key', 'merchant_message': 'Invalid Key'},
  '463': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Failed-Plz Call', 'merchant_message': 'Failed-Plz Call'},
  '464': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Failed-Plz Call', 'merchant_message': 'Failed-Plz Call'},
  '465': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Failed-Plz Call', 'merchant_message': 'Failed-Plz Call'},
  '466': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Failed-Plz Call', 'merchant_message': 'Failed-Plz Call'},
  '467': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Failed-Plz Call', 'merchant_message': 'Failed-Plz Call'},
  '468': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Failed-Plz Call', 'merchant_message': 'Failed-Plz Call'},
  '469': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Failed-Plz Call', 'merchant_message': 'Failed-Plz Call'},
  '470': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'JCB Not Allowed', 'merchant_message': 'JCB Not Allowed'},
  '471': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'JCB Not Allowed', 'merchant_message': 'JCB Not Allowed'},
  '472': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Bank Not On File', 'merchant_message': 'Bank Not On File'},
  '473': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'No Sponsor Inst', 'merchant_message': 'No Sponsor Inst'},
  '474': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Failed Plz Call', 'merchant_message': 'Failed Plz Call'},
  '475': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'WX Not Allowed', 'merchant_message': 'WX Not Allowed'},
  '476': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Amount Too Large', 'merchant_message': 'Amount Too Large'},
  '477': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Reenter Odometer ', 'merchant_message': 'Reenter Odometer'},
  # XXX: This line appears with blank cardholder and merchant messages in the gateway response messages document
  '478': {'type': 'Paymentech',	'approved': False, 'cardholder_message': '', 'merchant_message': ''},
  '479': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Tran Not Allowed', 'merchant_message': 'Tran Not Allowed'},
  '480': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Bat Already Rels', 'merchant_message': 'Bat Already Rels'},
  '481': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Rtng Ind', 'merchant_message': 'Invalid Rtng Ind'},
  '482': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'AX Not Allowed', 'merchant_message': 'AX Not Allowed'},
  '483': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Merchant', 'merchant_message': 'Invalid Merchant'},
  '484': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Call Voice Op', 'merchant_message': 'Call Voice Op'},
  '485': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Auth Down-Retry', 'merchant_message': 'Auth Down-Retry'},
  '486': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Auth Busy-Retry', 'merchant_message': 'Auth Busy-Retry'},
  '487': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Auth Busy-Retry', 'merchant_message': 'Auth Busy-Retry'},
  '488': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Invalid Term ID', 'merchant_message': 'Invalid Term ID'},
  '489': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Term Not Active', 'merchant_message': 'Term Not Active'},
  '490': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'No Transactions', 'merchant_message': 'No Transactions'},
  '491': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Bat Already Rels', 'merchant_message': 'Bat Already Rels'},
  '492': {'type': 'Paymentech', 'approved': False, 'cardholder_message': 'Batch Not Found', 'merchant_message': 'Batch Not Found'},
  '494': {'type': 'Vital', 'approved': True, 'cardholder_message': 'Approval', 'merchant_message': 'Approval'},
  '495': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Card OK', 'merchant_message': 'Card OK'},
  '496': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Call', 'merchant_message': 'Call'},
  '497': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Call', 'merchant_message': 'Call'},
  '498': {'type': 'Vital', 'approved': False, 'cardholder_message': 'No Reply', 'merchant_message': 'No Reply'},
  '499': {'type': 'Vital', 'approved': False, 'cardholder_message': 'No Reply', 'merchant_message': 'No Reply'},
  '500': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Hold-call or Pick Up Card', 'merchant_message': 'Hold-call or Pick Up Card'},
  '501': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Hold-call or Pick Up Card', 'merchant_message': 'Hold-call or Pick Up Card'},
  '502': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Hold-call or Pick Up Card', 'merchant_message': 'Hold-call or Pick Up Card'},
  '503': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Hold-call or Pick Up Card', 'merchant_message': 'Hold-call or Pick Up Card'},
  '504': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Acct Length Err', 'merchant_message': 'Acct Length Err'},
  '505': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Already Reversed', 'merchant_message': 'Already Reversed'},
  '506': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Amount Error', 'merchant_message': 'Amount Error'},
  '507': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Cant Verify PIN', 'merchant_message': 'Cant Verify PIN'},
  '508': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Cant Verify PIN', 'merchant_message': 'Cant Verify PIN'},
  '509': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Card No. Error', 'merchant_message': 'Card No. Error'},
  '510': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Cashback Not App', 'merchant_message': 'Cashback Not App'},
  '511': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Cashback Not Avl', 'merchant_message': 'Cashback Not Avl'},
  '512': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Check Digit Err', 'merchant_message': 'Check Digit Err'},
  '513': {'type': 'Vital', 'approved': False, 'cardholder_message': 'CID Format Error', 'merchant_message': 'CID Format Error'},
  '514': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Date Error', 'merchant_message': 'Date Error'},
  '515': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Decline', 'merchant_message': 'Decline'},
  '516': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Decline', 'merchant_message': 'Decline'},
  '517': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Decline', 'merchant_message': 'Decline'},
  '518': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Decline', 'merchant_message': 'Decline'},
  '519': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Decline', 'merchant_message': 'Decline'},
  '520': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Decline', 'merchant_message': 'Decline'},
  '521': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Decline', 'merchant_message': 'Decline'},
  '522': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Encryption Error', 'merchant_message': 'Encryption Error'},
  '523': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Error', 'merchant_message': 'Error'},
  '524': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Expired Card', 'merchant_message': 'Expired Card'},
  '525': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Failure HV', 'merchant_message': 'Failure HV'},
  '526': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Failure CV', 'merchant_message': 'Failure CV'},
  '527': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Invalid Routing', 'merchant_message': 'Invalid Routing'},
  '528': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Invalid Trans', 'merchant_message': 'Invalid Trans'},
  '529': {'type': 'Vital', 'approved': False, 'cardholder_message': 'No Account', 'merchant_message': 'No Account'},
  '530': {'type': 'Vital', 'approved': False, 'cardholder_message': 'No Action Taken', 'merchant_message': 'No Action Taken'},
  '531': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Unsolic Reversal', 'merchant_message': 'Unsolic Reversal'},
  '532': {'type': 'Vital', 'approved': False, 'cardholder_message': 'No Action Taken', 'merchant_message': 'No Action Taken'},
  '533': {'type': 'Vital', 'approved': False, 'cardholder_message': 'No Check Account', 'merchant_message': 'No Check Account'},
  '534': {'type': 'Vital', 'approved': False, 'cardholder_message': 'No Credit Acct', 'merchant_message': 'No Credit Acct'},
  '535': {'type': 'Vital', 'approved': False, 'cardholder_message': 'No Save Account', 'merchant_message': 'No Save Account'},
  '536': {'type': 'Vital', 'approved': False, 'cardholder_message': 'No Such Issuer', 'merchant_message': 'No Such Issuer'},
  '537': {'type': 'Vital', 'approved': False, 'cardholder_message': 'PIN Exceeded', 'merchant_message': 'PIN Exceeded'},
  '538': {'type': 'Vital', 'approved': False, 'cardholder_message': 'RE Enter', 'merchant_message': 'RE Enter'},
  '539': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Sec Violation', 'merchant_message': 'Sec Violation'},
  '540': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Serv Not Allowed', 'merchant_message': 'Serv Not Allowed'},
  '541': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Serv NOt Allowed', 'merchant_message': 'Serv NOt Allowed'},
  '542': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Stop Recurring', 'merchant_message': 'Stop Recurring'},
  '543': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Stop Recurring', 'merchant_message': 'Stop Recurring'},
  '544': {'type': 'Vital', 'approved': False, 'cardholder_message': 'System Error', 'merchant_message': 'System Error'},
  '545': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Term Id Error', 'merchant_message': 'Term Id Error'},
  '546': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Wrong Pin', 'merchant_message': 'Wrong Pin'},
  '547': {'type': 'Vital', 'approved': False, 'cardholder_message': 'CVV2 Mismatch', 'merchant_message': 'CVV2 Mismatch'},
  '548': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Duplicate Trans', 'merchant_message': 'Duplicate Trans'},
  '549': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Approval', 'merchant_message': 'Approval'},
  '550': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Cannot Convert', 'merchant_message': 'Cannot Convert'},
  '551': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Invalid ABA', 'merchant_message': 'Invalid ABA'},
  '552': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Amount Error', 'merchant_message': 'Amount Error'},
  '553': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Unpaid Items', 'merchant_message': 'Unpaid Items'},
  '554': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Duplicate Number', 'merchant_message': 'Duplicate Number'},
  '555': {'type': 'Vital', 'approved': False, 'cardholder_message': 'MICR Error', 'merchant_message': 'MICR Error'},
  '556': {'type': 'Vital', 'approved': False, 'cardholder_message': 'Too Many Checks', 'merchant_message': 'Too Many Checks'},
  '558': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Decline', 'merchant_message': 'Decline'},
  '559': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'No Transaction Found', 'merchant_message': 'No Transaction Found'},
  '560': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Transaction In Process', 'merchant_message': 'Transaction In Process'},
  '561': {'type': 'Global', 'approved': True, 'cardholder_message': 'APPROVED', 'merchant_message': 'APPROVED'},
  '562': {'type': 'Global', 'approved': False, 'cardholder_message': 'CALL CARD ISSUER', 'merchant_message': 'CALL CARD ISSUER'},
  '563': {'type': 'Global', 'approved': False, 'cardholder_message': 'CALL', 'merchant_message': 'CALL'},
  '564': {'type': 'Global', 'approved': False, 'cardholder_message': 'INVLD MERCH ID', 'merchant_message': 'INVLD MERCH ID'},
  '565': {'type': 'Global', 'approved': False, 'cardholder_message': 'PIC UP', 'merchant_message': 'PIC UP'},
  '566': {'type': 'Global', 'approved': False, 'cardholder_message': 'DECLINE', 'merchant_message': 'DECLINE'},
  '567': {'type': 'Global', 'approved': False, 'cardholder_message': 'REVERSED', 'merchant_message': 'REVERSED'},
  '568': {'type': 'Global', 'approved': False, 'cardholder_message': 'Decline-CV2 FAIL', 'merchant_message': 'Decline-CV2 FAIL'},
  '569': {'type': 'Global', 'approved': False, 'cardholder_message': 'AP WITH ID', 'merchant_message': 'AP WITH ID'},
  '570': {'type': 'Global', 'approved': False, 'cardholder_message': 'INVLD', 'merchant_message': 'INVLD'},
  '571': {'type': 'Global', 'approved': False, 'cardholder_message': 'INVLD AMOUNT', 'merchant_message': 'INVLD AMOUNT'},
  '572': {'type': 'Global', 'approved': False, 'cardholder_message': 'INVLD ACCT', 'merchant_message': 'INVLD ACCT'},
  '573': {'type': 'Global', 'approved': False, 'cardholder_message': 'PLEASE RETRY', 'merchant_message': 'PLEASE RETRY'},
  '574': {'type': 'Global', 'approved': False, 'cardholder_message': 'INVLD EXP DATE', 'merchant_message': 'INVLD EXP DATE'},
  '575': {'type': 'Global', 'approved': False, 'cardholder_message': 'PIN INVALID', 'merchant_message': 'PIN INVALID'},
  '576': {'type': 'Global', 'approved': False, 'cardholder_message': 'UNAUTH TRANS', 'merchant_message': 'UNAUTH TRANS'},
  '577': {'type': 'Global', 'approved': False, 'cardholder_message': 'MAX PIN RETRIES', 'merchant_message': 'MAX PIN RETRIES'},
  '578': {'type': 'Global', 'approved': False, 'cardholder_message': 'AP DUPE', 'merchant_message': 'AP DUPE'},
  '579': {'type': 'Global', 'approved': False, 'cardholder_message': 'SYSTEM UNAVAILABLE', 'merchant_message': 'SYSTEM UNAVAILABLE'},
  '580': {'type': 'Global', 'approved': False, 'cardholder_message': 'INV ACCT MATCH', 'merchant_message': 'INV ACCT MATCH'},
  '581': {'type': 'Global', 'approved': False, 'cardholder_message': 'INV AMT MATCH', 'merchant_message': 'INV AMT MATCH'},
  '582': {'type': 'Global', 'approved': False, 'cardholder_message': 'INV ITEM NUM', 'merchant_message': 'INV ITEM NUM'},
  '583': {'type': 'Global', 'approved': False, 'cardholder_message': 'ITEM ADJ', 'merchant_message': 'ITEM ADJ'},
  '584': {'type': 'Global', 'approved': False, 'cardholder_message': 'MUST BALANCE NOW', 'merchant_message': 'MUST BALANCE NOW'},
  '585': {'type': 'Global', 'approved': False, 'cardholder_message': 'USE DUP THEN BAL', 'merchant_message': 'USE DUP THEN BAL'},
  '586': {'type': 'Global', 'approved': False, 'cardholder_message': 'NO DUP FOUND', 'merchant_message': 'NO DUP FOUND'},
  '587': {'type': 'Global', 'approved': False, 'cardholder_message': 'INVALID DATA', 'merchant_message': 'INVALID DATA'},
  '588': {'type': 'Global', 'approved': False, 'cardholder_message': 'NO TRANS FOUND', 'merchant_message': 'NO TRANS FOUND'},
  '589': {'type': 'Global', 'approved': False, 'cardholder_message': 'AP NOT CAPTURED', 'merchant_message': 'AP NOT CAPTURED'},
  '590': {'type': 'Global', 'approved': False, 'cardholder_message': 'AP AUTH-ONLY', 'merchant_message': 'AP AUTH-ONLY'},
  '591': {'type': 'Global', 'approved': False, 'cardholder_message': 'INV BANK', 'merchant_message': 'INV BANK'},
  '592': {'type': 'Global', 'approved': False, 'cardholder_message': 'TRAN TYPE INVLD', 'merchant_message': 'TRAN TYPE INVLD'},
  '593': {'type': 'Global', 'approved': False, 'cardholder_message': 'APPROVED', 'merchant_message': 'APPROVED'},
  '594': {'type': 'Global', 'approved': False, 'cardholder_message': 'DB UNAVAIL 02', 'merchant_message': 'DB UNAVAIL 02'},
  '595': {'type': 'Global', 'approved': False, 'cardholder_message': 'DB UNAVAIL 03', 'merchant_message': 'DB UNAVAIL 03'},
  '596': {'type': 'Global', 'approved': False, 'cardholder_message': 'DB UNAVAIL 04', 'merchant_message': 'DB UNAVAIL 04'},
  '597': {'type': 'Global', 'approved': False, 'cardholder_message': 'UNAUTH USER', 'merchant_message': 'UNAUTH USER'},
  '598': {'type': 'Global', 'approved': False, 'cardholder_message': 'INVALID CARD', 'merchant_message': 'INVALID CARD'},
  '599': {'type': 'Global', 'approved': False, 'cardholder_message': 'DB ISSUER UNAVAIL', 'merchant_message': 'DB ISSUER UNAVAIL'},
  '600': {'type': 'Global', 'approved': False, 'cardholder_message': 'INVALID POS CARD', 'merchant_message': 'INVALID POS CARD'},
  '601': {'type': 'Global', 'approved': False, 'cardholder_message': 'ACCT TYPE INVLD', 'merchant_message': 'ACCT TYPE INVLD'},
  '602': {'type': 'Global', 'approved': False, 'cardholder_message': 'INVALID PREFIX', 'merchant_message': 'INVALID PREFIX'},
  '603': {'type': 'Global', 'approved': False, 'cardholder_message': 'INVALID FIID', 'merchant_message': 'INVALID FIID'},
  '604': {'type': 'Global', 'approved': False, 'cardholder_message': 'VERIFY', 'merchant_message': 'VERIFY'},
  '605': {'type': 'Global', 'approved': False, 'cardholder_message': 'INVALID LIC', 'merchant_message': 'INVALID LIC'},
  '606': {'type': 'Global', 'approved': False, 'cardholder_message': 'INVALID STATE CD', 'merchant_message': 'INVALID STATE CD'},
  '607': {'type': 'Global', 'approved': False, 'cardholder_message': 'EDC UNAVAILABLE', 'merchant_message': 'EDC UNAVAILABLE'},
  '608': {'type': 'Global', 'approved': False, 'cardholder_message': 'DB UNAVAIL 01', 'merchant_message': 'DB UNAVAIL 01'},
  '609': {'type': 'Global', 'approved': False, 'cardholder_message': 'SCAN UNAVAILABLE', 'merchant_message': 'SCAN UNAVAILABLE'},
  '610': {'type': 'Global', 'approved': False, 'cardholder_message': 'EXCEEDS MAX AMT', 'merchant_message': 'EXCEEDS MAX AMT'},
  '611': {'type': 'Global', 'approved': False, 'cardholder_message': 'EXCEEDS MAX USES', 'merchant_message': 'EXCEEDS MAX USES'},
  '627': {'type': 'EFT', 'approved': True, 'cardholder_message': 'Edit Reject', 'merchant_message': 'Edit Reject'},
  '629': {'type': 'EFT', 'approved': True, 'cardholder_message': 'Currency/Account Mismatch', 'merchant_message': 'Currency/Account Mismatch'},
  '630': {'type': 'EFT', 'approved': True, 'cardholder_message': 'Payment Recalled', 'merchant_message': 'Payment Recalled'},
  '632': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Decline', 'merchant_message': 'Max number of recurring billing accounts reached'},
  '633': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Invalid XML message', 'merchant_message': 'Invalid XML message'},
  '634': {'type': 'Interac Online', 'approved': True, 'cardholder_message': 'APPROVED THANKS', 'merchant_message': 'APPROVED'},
  '635': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CARD USE LIMITED REFER TO BRANCH', 'merchant_message': 'CARD USE LIMITED REFER TO BRANCH'},
  '636': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'FUNDS NOT AVAIL REFER TO BRANCH', 'merchant_message': 'INSUFFICIENT FUNDS REFER TO BRANCH'},
  '637': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'EXPIRED CARD REFER TO BRANCH', 'merchant_message': 'EXPIRED CARD REFER TO BRANCH'},
  '638': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'PIN ERROR PLEASE RE-TRY', 'merchant_message': 'RE-TRY PIN ERROR'},
  '639': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RE-TRY', 'merchant_message': 'RE-TRY INVALID TRANSACTION'},
  '640': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RE-TRY', 'merchant_message': 'RE-TRY INVALID TRANSACTION'},
  '641': {'type': 'Interac Online', 'approved': False, 'cardholder_message': '$ LIMIT EXCEEDED REFER TO BRANCH', 'merchant_message': '$ LIMIT EXCEEDED REFER TO BRANCH'},
  '642': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CARD USE LIMITED REFER TO BRANCH', 'merchant_message': 'CARD USE LIMITED REFER TO BRANCH'},
  '643': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'USAGE EXCEEDED REFER TO BRANCH', 'merchant_message': 'USAGE EXCEEDED REFER TO BRANCH'},
  '644': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'EXCESS PIN RETRY REFER TO BRANCH', 'merchant_message': 'EXCESS PIN RETRY REFER TO BRANCH'},
  '645': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'PIN ERROR PLEASE RE-TRY', 'merchant_message': 'RE-TRY EDIT ERROR'},
  '646': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'INVALID CARD REFER TO BRANCH', 'merchant_message': 'INVALID CARD REFER TO BRANCH'},
  '647': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RE-TRY', 'merchant_message': 'RE-TRY EDIT ERROR'},
  '648': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RE-TRY', 'merchant_message': 'RE-TRY EDIT ERROR'},
  '649': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RE-TRY', 'merchant_message': 'RE-TRY EDIT ERROR'},
  '650': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RE-TRY', 'merchant_message': 'RE-TRY INVALID CARD'},
  '651': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RE-TRY', 'merchant_message': 'RE-TRY SYSTEM PROBLEM'},
  '652': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'INVALID CARD REFER TO BRANCH', 'merchant_message': 'CARD NOT SUPPORTED REFER TO BRANCH'},
  '653': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'ACCT NOT SET UP REFER TO BRANCH', 'merchant_message': 'ACCT NOT SET UP REFER TO BRANCH'},
  '654': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'ACCT NOT SET UP REFER TO BRANCH', 'merchant_message': 'ACCT NOT SET UP REFER TO BRANCH'},
  '655': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CARD IS NOT SETUP REFER TO BRANCH', 'merchant_message': 'CARD IS NOT SETUP REFER TO BRANCH'},
  '656': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RETRY', 'merchant_message': 'RE-TRY EDIT ERROR'},
  '657': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RETRY', 'merchant_message': 'RETRY SYSTEM TIMEOUT'},
  '658': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RE-TRY', 'merchant_message': 'RE-TRY EDIT ERROR'},
  '659': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RE-TRY', 'merchant_message': 'RE-TRY SYSTEM PROBLEM'},
  '660': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'Bad sequence number: resend transaction', 'merchant_message': 'Bad sequence number: resend transaction'},
  '661': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RE-TRY', 'merchant_message': 'RE-TRY SYSTEM PROBLEM'},
  '662': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RETRY', 'merchant_message': 'RE-TRY EDIT ERROR'},
  '663': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RETRY', 'merchant_message': 'RE-TRY EDIT ERROR'},
  '664': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RETRY', 'merchant_message': 'RE-TRY EDIT ERROR'},
  '665': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RE-TRY', 'merchant_message': 'RETRY SYSTEM PROBLEM'},
  '666': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RE-TRY', 'merchant_message': 'RETRY SYSTEM PROBLEM'},
  '667': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RE-TRY', 'merchant_message': 'RETRY SYSTEM PROBLEM'},
  '668': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RE-TRY', 'merchant_message': 'RETRY SYSTEM PROBLEM'},
  '669': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS OVER STORE LIMIT', 'merchant_message': 'OVER RETAILER LIMIT'},
  '670': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS PLEASE RE-TRY', 'merchant_message': 'RE-TRY INVALID TRANSACTION'},
  '671': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS', 'merchant_message': 'CANNOT PROCESS'},
  '672': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS OVER CORR LIMIT', 'merchant_message': 'EXCEEDS CORRECTION LIMIT'},
  '673': {'type': 'Interac Online', 'approved': False, 'cardholder_message': 'CANNOT PROCESS', 'merchant_message': 'CANNOT PROCESS'},
  '674': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Payment declined', 'merchant_message': 'Payment declined'},
  '681': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Payment method not accepted on this account.', 'merchant_message': 'Payment method not accepted on this account.'},
  '682': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Decline', 'merchant_message': 'Decline'},
  '683': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Declined. Missing or invalid merchant data.', 'merchant_message': 'Declined. Missing or invalid merchant data.'},
  '684': {'type': 'First Data', 'approved': True, 'cardholder_message': 'APPROVAL', 'merchant_message': 'APPROVAL'},
  '685': {'type': 'First Data', 'approved': False, 'cardholder_message': 'REFERRAL', 'merchant_message': 'REFERRAL'},
  '686': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INVLD MER ID', 'merchant_message': 'INVLD MER ID'},
  '687': {'type': 'First Data', 'approved': True, 'cardholder_message': 'APPRV LESSER AMT', 'merchant_message': 'APPRV LESSER AMT'},
  '688': {'type': 'First Data', 'approved': False, 'cardholder_message': 'BAD PROCESSING CODE', 'merchant_message': 'BAD PROCESSING CODE'},
  '689': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INV AMT', 'merchant_message': 'INV AMT'},
  '690': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INV ACCT NUM', 'merchant_message': 'INV ACCT NUM'},
  '691': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INV TERMINAL', 'merchant_message': 'INV TERMINAL'},
  '692': {'type': 'First Data', 'approved': False, 'cardholder_message': 'PLEASE RETRY', 'merchant_message': 'PLEASE RETRY'},
  '693': {'type': 'First Data', 'approved': False, 'cardholder_message': 'DECLINED', 'merchant_message': 'DECLINED'},
  '694': {'type': 'First Data', 'approved': False, 'cardholder_message': 'EXPIRED CARD', 'merchant_message': 'EXPIRED CARD'},
  '695': {'type': 'First Data', 'approved': False, 'cardholder_message': 'DECLINED', 'merchant_message': 'DECLINED'},
  '696': {'type': 'First Data', 'approved': False, 'cardholder_message': 'HOLD - CALL CTR', 'merchant_message': 'HOLD - CALL CTR'},
  '697': {'type': 'First Data', 'approved': False, 'cardholder_message': 'SERV NOT ALLOWED', 'merchant_message': 'SERV NOT ALLOWED'},
  '698': {'type': 'First Data', 'approved': True, 'cardholder_message': 'APPROVAL', 'merchant_message': 'APPROVAL'},
  '699': {'type': 'First Data', 'approved': True, 'cardholder_message': 'AVS ACCEPTED', 'merchant_message': 'AVS ACCEPTED'},
  '700': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INVALID TERM ID', 'merchant_message': 'INVALID TERM ID'},
  '701': {'type': 'First Data', 'approved': False, 'cardholder_message': 'PLEASE RETRY', 'merchant_message': 'PLEASE RETRY'},
  '702': {'type': 'First Data', 'approved': False, 'cardholder_message': 'RESEND BATCH', 'merchant_message': 'RESEND BATCH'},
  '703': {'type': 'First Data', 'approved': False, 'cardholder_message': 'SYSTEM PROBLEM', 'merchant_message': 'SYSTEM PROBLEM'},
  '704': {'type': 'First Data', 'approved': False, 'cardholder_message': 'CVV2 DECLINED', 'merchant_message': 'CVV2 DECLINED'},
  '705': {'type': 'First Data', 'approved': False, 'cardholder_message': 'DOWNLOAD FAILED', 'merchant_message': 'DOWNLOAD FAILED'},
  '706': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INVLID MAC', 'merchant_message': 'INVLID MAC'},
  '707': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INVALID ID NBR', 'merchant_message': 'INVALID ID NBR'},
  '708': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INV DRIVER NBR', 'merchant_message': 'INV DRIVER NBR'},
  '709': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INV VEHICLE NBR', 'merchant_message': 'INV VEHICLE NBR'},
  '710': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INV EXP DATE', 'merchant_message': 'INV EXP DATE'},
  '711': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INVLD AMT 3', 'merchant_message': 'INVLD AMT 3'},
  '712': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INVLD ACCT 2', 'merchant_message': 'INVLD ACCT 2'},
  '713': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INV EXP DATE', 'merchant_message': 'INV EXP DATE'},
  '714': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INV ACCT', 'merchant_message': 'INV ACCT'},
  '715': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INVLD ACCT 1', 'merchant_message': 'INVLD ACCT 1'},
  '716': {'type': 'First Data', 'approved': False, 'cardholder_message': 'CAPT. NOT ALLOWED', 'merchant_message': 'CAPT. NOT ALLOWED'},
  '717': {'type': 'First Data', 'approved': False, 'cardholder_message': 'COMM ERR RESEND', 'merchant_message': 'COMM ERR RESEND'},
  '718': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INVL TERMINAL ID', 'merchant_message': 'INVL TERMINAL ID'},
  '719': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INVL ARRIVAL-DT', 'merchant_message': 'INVL ARRIVAL-DT'},
  '720': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INVL CHECKOUT DT', 'merchant_message': 'INVL CHECKOUT DT'},
  '721': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INVL ROOM RATE', 'merchant_message': 'INVL ROOM RATE'},
  '722': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INVL FOLIO NBR', 'merchant_message': 'INVL FOLIO NBR'},
  '723': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INV TRN TYPE', 'merchant_message': 'INV TRN TYPE'},
  '724': {'type': 'First Data', 'approved': False, 'cardholder_message': 'MAX TIP $999', 'merchant_message': 'MAX TIP $999'},
  '725': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INCORRECT PIN', 'merchant_message': 'INCORRECT PIN'},
  '726': {'type': 'First Data', 'approved': False, 'cardholder_message': 'AMT EXCEEDED LIMIT', 'merchant_message': 'AMT EXCEEDED LIMIT'},
  '727': {'type': 'First Data', 'approved': False, 'cardholder_message': 'HOST KEY ERROR', 'merchant_message': 'HOST KEY ERROR'},
  '728': {'type': 'First Data', 'approved': False, 'cardholder_message': 'PIN RETRY EXCEEDED', 'merchant_message': 'PIN RETRY EXCEEDED'},
  '729': {'type': 'First Data', 'approved': False, 'cardholder_message': 'DUPLICATE TRAN', 'merchant_message': 'DUPLICATE TRAN'},
  '730': {'type': 'First Data', 'approved': False, 'cardholder_message': 'REV REJECTED', 'merchant_message': 'REV REJECTED'},
  '731': {'type': 'First Data', 'approved': False, 'cardholder_message': 'ENTER LESSER AMOUNT', 'merchant_message': 'ENTER LESSER AMOUNT'},
  '732': {'type': 'First Data', 'approved': False, 'cardholder_message': 'PIN XLATE ERROR', 'merchant_message': 'PIN XLATE ERROR'},
  '733': {'type': 'First Data', 'approved': False, 'cardholder_message': 'INV CASHBACK AMT', 'merchant_message': 'INV CASHBACK AMT'},
  '734': {'type': 'First Data', 'approved': False, 'cardholder_message': 'CRYPTO BOX UNAV', 'merchant_message': 'CRYPTO BOX UNAV'},
  '735': {'type': 'First Data', 'approved': False, 'cardholder_message': 'DBT SWITCH UNAVL', 'merchant_message': 'DBT SWITCH UNAVL'},
  '736': {'type': 'First Data', 'approved': False, 'cardholder_message': 'ISSUER UNAV', 'merchant_message': 'ISSUER UNAV'},
  '737': {'type': 'First Data', 'approved': False, 'cardholder_message': 'UNDEFINED CARD', 'merchant_message': 'UNDEFINED CARD'},
  '738': {'type': 'First Data', 'approved': False, 'cardholder_message': 'DBTSW INV MERID', 'merchant_message': 'DBTSW INV MERID'},
  '739': {'type': 'First Data', 'approved': False, 'cardholder_message': 'TRAN CT EXCD LMT', 'merchant_message': 'TRAN CT EXCD LMT'},
  '740': {'type': 'First Data', 'approved': False, 'cardholder_message': 'RESUB EXCDS LMT', 'merchant_message': 'RESUB EXCDS LMT'},
  '741': {'type': 'First Data', 'approved': False, 'cardholder_message': 'DBTSW PIN XL ERR', 'merchant_message': 'DBTSW PIN XL ERR'},
  '742': {'type': 'First Data', 'approved': False, 'cardholder_message': 'DECLINE', 'merchant_message': 'DECLINE'},
  '743': {'type': 'Elavon', 'approved': True, 'cardholder_message': 'APPROVAL', 'merchant_message': 'APPROVAL'},
  '744': {'type': 'Elavon', 'approved': False, 'cardholder_message': 'DECLINED-HELP 9999 (Gift Card - Host Busy)', 'merchant_message': 'DECLINED-HELP 9999 (Gift Card - Host Busy)'},
  '745': {'type': 'Elavon', 'approved': False, 'cardholder_message': 'INVALID CARD (Gift Card)', 'merchant_message': 'INVALID CARD (Gift Card)'},
  '746': {'type': 'Elavon', 'approved': False, 'cardholder_message': 'INVALID TERM ID (Gift Card)', 'merchant_message': 'INVALID TERM ID (Gift Card)'},
  '747': {'type': 'Elavon', 'approved': False, 'cardholder_message': 'AMOUNT ERROR (Gift Card)', 'merchant_message': 'AMOUNT ERROR (Gift Card)'},
  '748': {'type': 'Elavon', 'approved': False, 'cardholder_message': 'ALREADY ACTIVE (Gift Card)', 'merchant_message': 'ALREADY ACTIVE (Gift Card)'},
  '749': {'type': 'Elavon', 'approved': False, 'cardholder_message': 'REQ. EXCEEDS BAL. (Gift Card)', 'merchant_message': 'REQ. EXCEEDS BAL. (Gift Card)'},
  '750': {'type': 'Elavon', 'approved': False, 'cardholder_message': 'MAX REACHED (Gift Card)', 'merchant_message': 'MAX REACHED (Gift Card)'},
  '751': {'type': 'Elavon', 'approved': False, 'cardholder_message': 'NON RELOADABLE (Gift Card)', 'merchant_message': 'NON RELOADABLE (Gift Card)'},
  '752': {'type': 'Elavon', 'approved': False, 'cardholder_message': 'CARD NOT ACTIVE (Gift Card)', 'merchant_message': 'CARD NOT ACTIVE (Gift Card)'},
  '753': {'type': 'Elavon', 'approved': False, 'cardholder_message': 'SEQ ERR PLS CALL (Gift Card)', 'merchant_message': 'SEQ ERR PLS CALL (Gift Card)'},
  '754': {'type': 'Elavon', 'approved': False, 'cardholder_message': 'DECLINED-HELP 9999 (Gift Card - System Error)', 'merchant_message': 'DECLINED-HELP 9999 (Gift Card - System Error)'},
  '755': {'type': 'Elavon', 'approved': False, 'cardholder_message': 'DECLINE CVV2', 'merchant_message': 'DECLINE CVV2'},
  '756': {'type': 'Elavon', 'approved': False, 'cardholder_message': 'PICK UP CARD', 'merchant_message': 'PICK UP CARD'},
  '757': {'type': 'Elavon', 'approved': False, 'cardholder_message': 'DECLINED', 'merchant_message': 'DECLINED'},
  '758': {'type': 'Elavon', 'approved': False, 'cardholder_message': 'CALL AUTH. CENTER', 'merchant_message': 'CALL AUTH. CENTER'},
  '759': {'type': 'Elavon', 'approved': False, 'cardholder_message': 'ELAVON PROCESSING ERROR', 'merchant_message': 'ELAVON PROCESSING ERROR'},
  '760': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Multiple Transaction Matches Found', 'merchant_message': 'Multiple Transaction Matches Found'},
  '761': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Payment Canceled', 'merchant_message': 'Payment Canceled'},
  '762': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Expired session. Transaction not completed in allocated time.', 'merchant_message': 'Expired session. Transaction not completed in allocated time.'},
  '763': {'type': 'EFT', 'approved': True, 'cardholder_message': 'Not in accordance with agreement - Personal', 'merchant_message': 'Not in accordance with agreement - Personal'},
  '764': {'type': 'EFT', 'approved': True, 'cardholder_message': 'Agreement revoked - Personal', 'merchant_message': 'Agreement revoked - Personal'},
  '765': {'type': 'EFT', 'approved': True, 'cardholder_message': 'No pre-notification - Personal', 'merchant_message': 'No pre-notification - Personal'},
  '766': {'type': 'EFT', 'approved': True, 'cardholder_message': 'Not in accordance with agreement - Business', 'merchant_message': 'Not in accordance with agreement - Business'},
  '767': {'type': 'EFT', 'approved': True, 'cardholder_message': 'Agreement revoked - Business', 'merchant_message': 'Agreement revoked - Business'},
  '768': {'type': 'EFT', 'approved': True, 'cardholder_message': 'No pre-notification - Business', 'merchant_message': 'No pre-notification - Business'},
  '769': {'type': 'EFT', 'approved': True, 'cardholder_message': 'Customer Initiated Return Credit Only', 'merchant_message': 'Customer Initiated Return Credit Only'},
  '770': {'type': 'Global', 'approved': False, 'cardholder_message': 'INVALID CID', 'merchant_message': 'INVALID CID'},
  '771': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '772': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '773': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '774': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '775': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '776': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '777': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '778': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '779': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '780': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '781': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '782': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '783': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '784': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '785': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '786': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '787': {'type': 'TD Bank', 'approved': False, 'cardholder_message': 'Declined', 'merchant_message': 'Declined'},
  '788': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Duplicate Order Number - This order number has already been processed', 'merchant_message': 'Duplicate Order Number - This order number has already been processed'},
  '789': {'type': 'Beanstream', 'approved': False, 'cardholder_message': 'Card Number Mismatch', 'merchant_message': 'Card Number Mismatch'},
}


avs_response_codes = {
  '0': {'result': '0', 'processed': '0', 'address': '0', 'postal': '0', 'message': 'Address Verification not performed for this transaction.'},
  '5': {'result': '0', 'processed': '0', 'address': '0', 'postal': '0', 'message': 'Invalid AVS Response.'},
  '9': {'result': '0', 'processed': '0', 'address': '0', 'postal': '0', 'message': 'Address Verification Data contains edit error.'},
  'A': {'result': '0', 'processed': '1', 'address': '1', 'postal': '0', 'message': 'Street address matches, Postal/ZIP does not match.'},
  'B': {'result': '0', 'processed': '1', 'address': '1', 'postal': '0', 'message': 'Street address matches, Postal/ZIP not verified.'},
  'C': {'result': '0', 'processed': '1', 'address': '0', 'postal': '0', 'message': 'Street address and Postal/ZIP not verified.'},
  'D': {'result': '1', 'processed': '1', 'address': '1', 'postal': '1', 'message': 'Street address and Postal/ZIP match.'},
  'E': {'result': '0', 'processed': '0', 'address': '0', 'postal': '0', 'message': 'Transaction ineligible.'},
  'G': {'result': '0', 'processed': '0', 'address': '0', 'postal': '0', 'message': 'Non AVS participant. Information not verified.'},
  'I': {'result': '0', 'processed': '0', 'address': '0', 'postal': '0', 'message': 'Address information not verified for international transaction.'},
  'M': {'result': '1', 'processed': '1', 'address': '1', 'postal': '1', 'message': 'Street address and Postal/ZIP match.'},
  'N': {'result': '0', 'processed': '1', 'address': '0', 'postal': '0', 'message': 'Street address and Postal/ZIP do not match.'},
  'P': {'result': '0', 'processed': '1', 'address': '0', 'postal': '1', 'message': 'Postal/ZIP matches. Street address not verified.'},
  'R': {'result': '0', 'processed': '0', 'address': '0', 'postal': '0', 'message': 'System unavailable or timeout.'},
  'S': {'result': '0', 'processed': '0', 'address': '0', 'postal': '0', 'message': 'AVS not supported at this time.'},
  'U': {'result': '0', 'processed': '0', 'address': '0', 'postal': '0', 'message': 'Address information is unavailable.'},
  'W': {'result': '0', 'processed': '1', 'address': '0', 'postal': '1', 'message': 'Postal/ZIP matches, street address does not match.'},
  'X': {'result': '1', 'processed': '1', 'address': '1', 'postal': '1', 'message': 'Street address and Postal/ZIP match.'},
  'Y': {'result': '1', 'processed': '1', 'address': '1', 'postal': '1', 'message': 'Street address and Postal/ZIP match.'},
  'Z': {'result': '0', 'processed': '1', 'address': '0', 'postal': '1', 'message': 'Postal/ZIP matches, street address does not match.'},
}
