# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class VerificationCodeResponse(Model):
    """Description of the response of the verification code.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Name of certificate.
    :vartype name: str
    :ivar etag: Request etag.
    :vartype etag: str
    :ivar id: The resource identifier.
    :vartype id: str
    :ivar type: The resource type.
    :vartype type: str
    :param properties:
    :type properties:
     ~azure.mgmt.iothubprovisioningservices.models.VerificationCodeResponseProperties
    """

    _validation = {
        'name': {'readonly': True},
        'etag': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'VerificationCodeResponseProperties'},
    }

    def __init__(self, properties=None):
        super(VerificationCodeResponse, self).__init__()
        self.name = None
        self.etag = None
        self.id = None
        self.type = None
        self.properties = properties
