/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xqj;

import com.saxonica.xqj.Closable;
import com.saxonica.xqj.SaxonXQConnection;
import com.saxonica.xqj.SaxonXQDataFactory;
import com.saxonica.xqj.SaxonXQForwardSequence;
import com.saxonica.xqj.SaxonXQItem;
import com.saxonica.xqj.SaxonXQItemType;
import com.saxonica.xqj.SaxonXQSequence;
import java.io.InputStream;
import java.io.Reader;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.xquery.XQConstants;
import javax.xml.xquery.XQDynamicContext;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQSequence;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.SequenceExtent;
import org.w3c.dom.Node;

public abstract class SaxonXQDynamicContext
extends Closable
implements XQDynamicContext {
    protected SaxonXQConnection connection;
    private TimeZone implicitTimeZone = null;

    protected abstract DynamicQueryContext getDynamicContext();

    protected final Configuration getConfiguration() {
        return this.connection.getConfiguration();
    }

    protected abstract SaxonXQDataFactory getDataFactory() throws XQException;

    protected abstract boolean externalVariableExists(QName var1);

    public void bindAtomicValue(QName varname, String value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDynamicContext.checkNotNull(varname);
        SaxonXQDynamicContext.checkNotNull(value);
        SaxonXQDynamicContext.checkNotNull(type);
        SaxonXQItem item = (SaxonXQItem)this.getDataFactory().createItemFromAtomicValue(value, type);
        this.bindExternalVariable(varname, (Sequence)item.getSaxonItem());
    }

    public void bindBoolean(QName varname, boolean value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDynamicContext.checkNotNull(varname);
        BooleanValue target = BooleanValue.get((boolean)value);
        this.checkAtomic(type, (AtomicValue)target);
        this.bindExternalVariable(varname, (Sequence)target);
    }

    public void bindByte(QName varname, byte value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDynamicContext.checkNotNull(varname);
        SaxonXQItem item = (SaxonXQItem)this.getDataFactory().createItemFromByte(value, type);
        AtomicValue target = (AtomicValue)item.getSaxonItem();
        this.checkAtomic(type, target);
        this.bindExternalVariable(varname, (Sequence)target);
    }

    public void bindDocument(QName varname, InputStream value, String baseURI, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDynamicContext.checkNotNull(varname);
        SaxonXQItem item = (SaxonXQItem)this.connection.createItemFromDocument(value, baseURI, type);
        this.bindExternalVariable(varname, (Sequence)item.getSaxonItem());
    }

    public void bindDocument(QName varname, Reader value, String baseURI, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDynamicContext.checkNotNull(varname);
        SaxonXQItem item = (SaxonXQItem)this.connection.createItemFromDocument(value, baseURI, type);
        this.bindExternalVariable(varname, (Sequence)item.getSaxonItem());
    }

    public void bindDocument(QName varname, Source value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDynamicContext.checkNotNull(varname);
        SaxonXQItem item = (SaxonXQItem)this.connection.createItemFromDocument(value, type);
        this.bindExternalVariable(varname, (Sequence)item.getSaxonItem());
    }

    public void bindDocument(QName varname, String value, String baseURI, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDynamicContext.checkNotNull(varname);
        SaxonXQItem item = (SaxonXQItem)this.connection.createItemFromDocument(value, baseURI, type);
        this.bindExternalVariable(varname, (Sequence)item.getSaxonItem());
    }

    public void bindDocument(QName varname, XMLStreamReader value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDynamicContext.checkNotNull(varname);
        SaxonXQItem item = (SaxonXQItem)this.connection.createItemFromDocument(value, type);
        this.bindExternalVariable(varname, (Sequence)item.getSaxonItem());
    }

    public void bindDouble(QName varname, double value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDynamicContext.checkNotNull(varname);
        DoubleValue target = new DoubleValue(value);
        this.checkAtomic(type, (AtomicValue)target);
        this.bindExternalVariable(varname, (Sequence)target);
    }

    public void bindFloat(QName varname, float value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDynamicContext.checkNotNull(varname);
        FloatValue target = new FloatValue(value);
        this.checkAtomic(type, (AtomicValue)target);
        this.bindExternalVariable(varname, (Sequence)target);
    }

    public void bindInt(QName varname, int value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDynamicContext.checkNotNull(varname);
        SaxonXQItem item = (SaxonXQItem)this.getDataFactory().createItemFromInt(value, type);
        AtomicValue target = (AtomicValue)item.getSaxonItem();
        this.checkAtomic(type, target);
        this.bindExternalVariable(varname, (Sequence)target);
    }

    public void bindItem(QName varname, XQItem value) throws XQException {
        this.checkNotClosed();
        ((SaxonXQItem)value).checkNotClosed();
        SaxonXQDynamicContext.checkNotNull(varname);
        this.bindExternalVariable(varname, (Sequence)((SaxonXQItem)value).getSaxonItem());
    }

    public void bindLong(QName varname, long value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDynamicContext.checkNotNull(varname);
        SaxonXQItem item = (SaxonXQItem)this.getDataFactory().createItemFromLong(value, type);
        AtomicValue target = (AtomicValue)item.getSaxonItem();
        this.checkAtomic(type, target);
        this.bindExternalVariable(varname, (Sequence)target);
    }

    public void bindNode(QName varname, Node value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDynamicContext.checkNotNull(varname);
        SaxonXQItem item = (SaxonXQItem)this.getDataFactory().createItemFromNode(value, type);
        this.bindExternalVariable(varname, (Sequence)item.getSaxonItem());
    }

    public void bindObject(QName varname, Object value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDynamicContext.checkNotNull(varname);
        SaxonXQItem item = (SaxonXQItem)this.getDataFactory().createItemFromObject(value, type);
        this.bindExternalVariable(varname, (Sequence)item.getSaxonItem());
    }

    public void bindSequence(QName varname, XQSequence value) throws XQException {
        block4: {
            this.checkNotClosed();
            ((Closable)((Object)value)).checkNotClosed();
            SaxonXQDynamicContext.checkNotNull(varname);
            try {
                if (value instanceof SaxonXQForwardSequence) {
                    this.getDynamicContext().setParameter(SaxonXQDynamicContext.getStructuredQName(varname), (Sequence)SequenceExtent.makeSequenceExtent((SequenceIterator)((SaxonXQForwardSequence)value).getCleanIterator()));
                    break block4;
                }
                if (value instanceof SaxonXQSequence) {
                    this.bindExternalVariable(varname, (Sequence)((SaxonXQSequence)value).getValue());
                    break block4;
                }
                throw new XQException("XQSequence value is not a Saxon sequence");
            }
            catch (XPathException de) {
                XQException err = new XQException(de.getMessage());
                err.initCause(de);
                throw err;
            }
        }
    }

    public void bindShort(QName varname, short value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDynamicContext.checkNotNull(varname);
        SaxonXQItem item = (SaxonXQItem)this.getDataFactory().createItemFromShort(value, type);
        AtomicValue target = (AtomicValue)item.getSaxonItem();
        this.checkAtomic(type, target);
        this.bindExternalVariable(varname, (Sequence)target);
    }

    public void bindString(QName varname, String value, XQItemType type) throws XQException {
        this.checkNotClosed();
        SaxonXQDynamicContext.checkNotNull(varname);
        SaxonXQItem item = (SaxonXQItem)this.getDataFactory().createItemFromString(value, type);
        AtomicValue target = (AtomicValue)item.getSaxonItem();
        this.checkAtomic(type, target);
        this.bindExternalVariable(varname, (Sequence)target);
    }

    public TimeZone getImplicitTimeZone() throws XQException {
        this.checkNotClosed();
        if (this.implicitTimeZone != null) {
            return this.implicitTimeZone;
        }
        return new GregorianCalendar().getTimeZone();
    }

    public void setImplicitTimeZone(TimeZone implicitTimeZone) throws XQException {
        this.checkNotClosed();
        GregorianCalendar now = new GregorianCalendar(implicitTimeZone);
        try {
            this.getDynamicContext().setCurrentDateTime(new DateTimeValue((Calendar)now, true));
        }
        catch (XPathException e) {
            throw new XQException(e.getMessage());
        }
        this.implicitTimeZone = implicitTimeZone;
    }

    private void bindExternalVariable(QName varName, Sequence value) throws XQException {
        SaxonXQDynamicContext.checkNotNull(varName);
        SaxonXQDynamicContext.checkNotNull(value);
        try {
            if (varName.equals(XQConstants.CONTEXT_ITEM)) {
                this.getDynamicContext().setContextItem(SequenceTool.asItem((Sequence)value));
            } else {
                if (!this.externalVariableExists(varName)) {
                    throw new XQException("No external variable named " + varName + " exists in the query");
                }
                this.getDynamicContext().setParameter(SaxonXQDynamicContext.getStructuredQName(varName), value);
            }
        }
        catch (XPathException e) {
            XQException err = new XQException(e.getMessage());
            err.initCause(e);
            throw err;
        }
    }

    private void checkAtomic(XQItemType type, AtomicValue value) throws XQException {
        if (type == null) {
            return;
        }
        ItemType itemType = ((SaxonXQItemType)type).getSaxonItemType();
        if (!itemType.isPlainType()) {
            throw new XQException("Target type is not atomic");
        }
        AtomicType at = (AtomicType)itemType;
        if (!at.matchesItem((Item)value, true, this.getConfiguration())) {
            throw new XQException("value is invalid for specified type");
        }
    }

    private static StructuredQName getStructuredQName(QName qname) {
        return new StructuredQName(qname.getPrefix(), qname.getNamespaceURI(), qname.getLocalPart());
    }

    private static void checkNotNull(Object arg) throws XQException {
        if (arg == null) {
            throw new XQException("Argument is null");
        }
    }
}

