/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.util.logforwarder;

import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.RootLogger;
import org.ow2.proactive.scheduler.common.util.logforwarder.Log4JRemover;

public class LoggingEventProcessor {
    NoWarningHierarchy h = new NoWarningHierarchy();

    public void addAppender(String loggerName, Appender appender) {
        this.h.getLogger(loggerName).addAppender(appender);
    }

    public void removeAllAppenders(String loggerName) {
        this.h.getLogger(loggerName).removeAllAppenders();
    }

    public void removeLogger(String loggerName) {
        this.h.removeLogger(loggerName);
    }

    public void removeAllAppenders() {
        this.h.getRootLogger().removeAllAppenders();
    }

    public void shutdown() {
        this.h.shutdown();
        this.h.clear();
    }

    public void processEvent(LoggingEvent event) {
        this.h.getLogger(event.getLoggerName()).callAppenders(event);
    }

    private static class NoWarningHierarchy
    extends Hierarchy {
        public NoWarningHierarchy() {
            super((Logger)new RootLogger(Level.ALL));
        }

        public void removeLogger(String loggerName) {
            Log4JRemover.removeLogger(loggerName, this);
        }

        public void emitNoAppenderWarning(Category cat) {
        }
    }
}

