/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.task;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.objectweb.proactive.annotation.PublicAPI;

@PublicAPI
@XmlRootElement(name="restartmode")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestartMode
implements Serializable {
    public static final RestartMode ANYWHERE = new RestartMode(1, "Anywhere");
    public static final RestartMode ELSEWHERE = new RestartMode(2, "Elsewhere");
    @XmlAttribute
    private int index;
    @XmlAttribute
    private String description;
    private static final long serialVersionUID = 142L;

    public RestartMode() {
    }

    @VisibleForTesting
    protected RestartMode(int index, String description) {
        this.index = index;
        this.description = description;
    }

    public static RestartMode getMode(String description) {
        if (RestartMode.ELSEWHERE.description.equalsIgnoreCase(description)) {
            return ELSEWHERE;
        }
        return ANYWHERE;
    }

    public static RestartMode getMode(int restartModeId) {
        switch (restartModeId) {
            case 1: {
                return ANYWHERE;
            }
            case 2: {
                return ELSEWHERE;
            }
        }
        throw new IllegalArgumentException("Unknown restart mode: " + restartModeId);
    }

    public String getDescription() {
        return this.description;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestartMode that = (RestartMode)o;
        return this.index == that.index;
    }

    public int hashCode() {
        return this.index;
    }

    public String toString() {
        return this.description;
    }
}

