/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.factory;

import java.util.List;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.Converter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.IdentityConverter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.BaseParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.ModelType;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.SpelValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;
import org.springframework.expression.ParseException;

public class SPEL2ParserValidator
extends BaseParserValidator<String> {
    public static final String LEFT_DELIMITER = "(";
    public static final String RIGHT_DELIMITER = ")";
    protected static final String SPEL2_TYPE_REGEXP = "^" + SPEL2ParserValidator.ignoreCaseRegexp(ModelType.SPEL2.name()) + "\\" + "(" + "([^,]+),(.+)\\" + ")" + "$";

    public SPEL2ParserValidator(String model) throws ModelSyntaxException {
        super(model, ModelType.SPEL2, SPEL2_TYPE_REGEXP);
    }

    @Override
    protected Converter<String> createConverter(String model) throws ModelSyntaxException {
        return new IdentityConverter();
    }

    @Override
    protected Validator<String> createValidator(String model, Converter<String> converter) throws ModelSyntaxException {
        List<String> groups = SPEL2ParserValidator.parseAndGetRegexGroups(model, SPEL2_TYPE_REGEXP);
        if (groups.size() != 2) {
            throw new ModelSyntaxException("Internal error, regular expression " + SPEL2_TYPE_REGEXP + " did not return 2 groups in model '" + model + "'");
        }
        try {
            return new SpelValidator(groups.get(0), groups.get(1));
        }
        catch (ParseException e) {
            throw new ModelSyntaxException(e.getMessage(), e);
        }
    }
}

