# LR(1) parser, autogenerated on 2016-01-17 17:13:22
# generator: wisent 0.6.2, http://seehuhn.de/pages/wisent
# source: grammar/binmapper.wi

# All parts of this file which are not taken verbatim from the input grammar
# are covered by the following notice:
#
# Copyright (C) 2008, 2009  Jochen Voss <voss@seehuhn.de>
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
#   1. Redistributions of source code must retain the above copyright
#      notice, this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above
#      copyright notice, this list of conditions and the following
#      disclaimer in the documentation and/or other materials provided
#      with the distribution.
#
#   3. The name of the author may not be used to endorse or promote
#      products derived from this software without specific prior
#      written permission.
#
# This software is provided by the author "as is" and any express or
# implied warranties, including, but not limited to, the implied
# warranties of merchantability and fitness for a particular purpose
# are disclaimed.  In no event shall the author be liable for any
# direct, indirect, incidental, special, exemplary, or consequential
# damages (including, but not limited to, procurement of substitute
# goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether
# in contract, strict liability, or tort (including negligence or
# otherwise) arising in any way out of the use of this software, even
# if advised of the possibility of such damage.

from itertools import chain

class Unique(object):

    """Unique objects for use as markers.

    These objects are internally used to represent the start symbol
    and the end-of-input marker of the grammar.
    """

    def __init__(self, label):
        """Create a new unique object.

        `label` is a string which is used as a textual representation
        of the object.
        """
        self.label = label

    def __repr__(self):
        """Return the `label` given at object construction."""
        return self.label

class Parser(object):

    """LR(1) parser class.

    terminal symbols:
      '!=', '$', '%', '&', '(', ')', '*', '**', '+', '-', '/', '//', ':', '<',
      '<<', '<=', '<>', '=', '==', '>', '>=', '>>', 'T_ALIGN', 'T_AND',
      'T_BIGENDIAN', 'T_BINTYPE', 'T_BYTEORDER', 'T_DEDENT', 'T_FLOAT',
      'T_INDENT', 'T_INPUT', 'T_INT', 'T_LET', 'T_LITTLEENDIAN', 'T_NAME',
      'T_NEWLINE', 'T_NOT', 'T_NUMBER', 'T_OR', 'T_PADDING', 'T_RESTOFDATA',
      'T_SINT16', 'T_SINT32', 'T_SINT8', 'T_STR', 'T_STRING', 'T_UINT16',
      'T_UINT32', 'T_UINT8', 'T_UNTIL', '[', ']', '^', '|', '~'

    nonterminal symbols:
      'and_expr', 'and_test', 'arith_expr', 'array_type', 'atom', 'basic_type',
      'class', 'class_attribute', 'class_attribute_byteorder',
      'class_attribute_spec', 'class_field', 'class_let_field', 'class_scope',
      'classdef', 'comp_op', 'comparison', 'complex_type', 'compound_stmt',
      'expr', 'factor', 'field_byteorder_attribute', 'field_type', 'func',
      'func_expr', 'keyid', 'langid', 'name', 'newline', 'not_test', 'number',
      'or_test', 'pad_type', 'power', 'rest_attribute', 'shift_expr',
      'single_input', 'str', 'term', 'test', 'until_attribute', 'user_type',
      'xor_expr'

    production rules:
      'single_input' -> 'compound_stmt'
      'compound_stmt' -> '_1*'
      '_1*' ->
      '_1*' -> '_1*' 'class'
      'class' -> 'classdef' 'T_INDENT' 'class_scope' 'T_DEDENT'
      'classdef' -> 'langid' 'name' ':' '_3+'
      '_3+' -> 'newline'
      '_3+' -> '_3+' 'newline'
      'class_scope' -> '_5*' '_7*'
      '_5*' ->
      '_5*' -> '_5*' 'class_field'
      '_7*' ->
      '_7*' -> '_7*' 'class_attribute'
      'class_attribute' -> '&' 'class_attribute_spec' '_3+'
      'class_attribute_spec' -> 'class_attribute_byteorder'
      'class_attribute_spec' -> 'class_let_field'
      'class_attribute_byteorder' -> 'T_BYTEORDER' ':' '_(11)'
      '_(11)' -> 'T_LITTLEENDIAN'
      '_(11)' -> 'T_BIGENDIAN'
      'class_field' -> 'name' ':' 'field_type' '_3+'
      'class_let_field' -> 'T_LET' 'name' ':' 'field_type' '=' 'expr'
      'field_type' -> '_(14)'
      'field_type' -> '_(14)' 'field_byteorder_attribute'
      '_(14)' -> 'basic_type'
      '_(14)' -> 'complex_type'
      'field_byteorder_attribute' -> 'T_BYTEORDER' '=' '_(11)'
      'complex_type' -> 'user_type'
      'complex_type' -> 'pad_type'
      'complex_type' -> 'array_type'
      'user_type' -> 'T_NAME'
      'pad_type' -> 'T_PADDING' 'T_ALIGN' 'name' 'number'
      'array_type' -> '_(18)' '[' '_19?' ']' '_21?'
      '_(18)' -> 'basic_type'
      '_(18)' -> 'user_type'
      '_19?' ->
      '_19?' -> 'expr'
      '_21?' ->
      '_21?' -> 'rest_attribute'
      '_21?' -> 'until_attribute'
      'until_attribute' -> '&' 'T_UNTIL' '(' 'test' ')'
      'rest_attribute' -> '&' 'T_RESTOFDATA'
      'basic_type' -> 'T_UINT8'
      'basic_type' -> 'T_UINT16'
      'basic_type' -> 'T_UINT32'
      'basic_type' -> 'T_SINT8'
      'basic_type' -> 'T_SINT16'
      'basic_type' -> 'T_SINT32'
      'basic_type' -> 'T_FLOAT'
      'basic_type' -> 'T_STRING'
      'test' -> 'or_test'
      'or_test' -> 'and_test' '_23*'
      '_23*' ->
      '_23*' -> '_23*' 'T_OR' 'and_test'
      'and_test' -> 'not_test' '_25*'
      '_25*' ->
      '_25*' -> '_25*' 'T_AND' 'not_test'
      'not_test' -> 'T_NOT' 'not_test'
      'not_test' -> 'comparison'
      'comparison' -> 'expr' '_27*'
      '_27*' ->
      '_27*' -> '_27*' 'comp_op' 'expr'
      'comp_op' -> '<'
      'comp_op' -> '>'
      'comp_op' -> '=='
      'comp_op' -> '>='
      'comp_op' -> '<='
      'comp_op' -> '<>'
      'comp_op' -> '!='
      'expr' -> 'xor_expr' '_29*'
      '_29*' ->
      '_29*' -> '_29*' '|' 'xor_expr'
      'xor_expr' -> 'and_expr' '_31*'
      '_31*' ->
      '_31*' -> '_31*' '^' 'and_expr'
      'and_expr' -> 'shift_expr' '_33*'
      '_33*' ->
      '_33*' -> '_33*' '&' 'shift_expr'
      'shift_expr' -> 'func_expr' '_35*'
      '_(36)' -> '<<'
      '_(36)' -> '>>'
      '_35*' ->
      '_35*' -> '_35*' '_(36)' 'func_expr'
      'func_expr' -> 'arith_expr'
      'func_expr' -> 'func' '(' 'arith_expr' ')'
      'arith_expr' -> 'term' '_38*'
      '_(39)' -> '+'
      '_(39)' -> '-'
      '_38*' ->
      '_38*' -> '_38*' '_(39)' 'term'
      'term' -> 'factor' '_41*'
      '_(42)' -> '*'
      '_(42)' -> '/'
      '_(42)' -> '%'
      '_(42)' -> '//'
      '_41*' ->
      '_41*' -> '_41*' '_(42)' 'factor'
      'factor' -> '_(43)' 'factor'
      '_(43)' -> '+'
      '_(43)' -> '-'
      '_(43)' -> '~'
      'factor' -> 'power'
      'factor' -> '(' 'test' ')'
      'power' -> 'atom'
      'power' -> 'atom' '**' 'factor'
      'atom' -> 'number'
      'atom' -> 'str'
      'atom' -> 'name'
      'atom' -> 'keyid'
      'keyid' -> '$' 'T_INPUT'
      'func' -> 'T_INT'
      'name' -> 'T_NAME'
      'newline' -> 'T_NEWLINE'
      'str' -> 'T_STR'
      'langid' -> 'T_BINTYPE'
      'number' -> 'T_NUMBER'
    """

    class ParseErrors(Exception):

        """Exception class to represent a collection of parse errors.

        Instances of this class have two attributes, `errors` and `tree`.
        `errors` is a list of tuples, each describing one error.
        Each tuple consists of the first input token which could not
        be processed and the list of grammar symbols which were allowed
        at this point.
        `tree` is a "repaired" parse tree which might be used for further
        error checking, or `None` if no repair was possible.
        """

        def __init__(self, errors, tree):
            msg = "%d parse errors"%len(errors)
            Exception.__init__(self, msg)
            self.errors = errors
            self.tree = tree

    terminals = [ '!=', '$', '%', '&', '(', ')', '*', '**', '+', '-', '/',
                  '//', ':', '<', '<<', '<=', '<>', '=', '==', '>', '>=', '>>',
                  'T_ALIGN', 'T_AND', 'T_BIGENDIAN', 'T_BINTYPE',
                  'T_BYTEORDER', 'T_DEDENT', 'T_FLOAT', 'T_INDENT', 'T_INPUT',
                  'T_INT', 'T_LET', 'T_LITTLEENDIAN', 'T_NAME', 'T_NEWLINE',
                  'T_NOT', 'T_NUMBER', 'T_OR', 'T_PADDING', 'T_RESTOFDATA',
                  'T_SINT16', 'T_SINT32', 'T_SINT8', 'T_STR', 'T_STRING',
                  'T_UINT16', 'T_UINT32', 'T_UINT8', 'T_UNTIL', '[', ']', '^',
                  '|', '~' ]
    _transparent = [ '_(11)', '_(14)', '_(18)', '_(36)', '_(39)', '_(42)',
                     '_(43)', '_1*', '_19?', '_21?', '_23*', '_25*', '_27*',
                     '_29*', '_3+', '_31*', '_33*', '_35*', '_38*', '_41*',
                     '_5*', '_7*' ]
    EOF = Unique('EOF')
    S = Unique('S')

    _halting_state = 160
    _reduce = {
        (0, EOF): ('_1*', 0), (0, 'T_BINTYPE'): ('_1*', 0),
        (2, EOF): ('single_input', 1), (3, EOF): ('compound_stmt', 1),
        (4, EOF): ('_1*', 2), (4, 'T_BINTYPE'): ('_1*', 2),
        (6, '&'): ('_5*', 0), (6, 'T_DEDENT'): ('_5*', 0),
        (6, 'T_NAME'): ('_5*', 0), (8, EOF): ('class', 4),
        (8, 'T_BINTYPE'): ('class', 4), (12, 'T_INDENT'): ('classdef', 4),
        (13, '&'): ('_3+', 1), (13, 'T_DEDENT'): ('_3+', 1),
        (13, 'T_INDENT'): ('_3+', 1), (13, 'T_NAME'): ('_3+', 1),
        (13, 'T_NEWLINE'): ('_3+', 1), (14, '&'): ('class_field', 4),
        (14, 'T_DEDENT'): ('class_field', 4),
        (14, 'T_NAME'): ('class_field', 4), (15, '&'): ('class_attribute', 3),
        (15, 'T_DEDENT'): ('class_attribute', 3), (16, '&'): ('_3+', 2),
        (16, 'T_DEDENT'): ('_3+', 2), (16, 'T_INDENT'): ('_3+', 2),
        (16, 'T_NAME'): ('_3+', 2), (16, 'T_NEWLINE'): ('_3+', 2),
        (17, '&'): ('_7*', 0), (17, 'T_DEDENT'): ('_7*', 0),
        (18, 'T_DEDENT'): ('class_scope', 2), (19, '&'): ('_5*', 2),
        (19, 'T_DEDENT'): ('_5*', 2), (19, 'T_NAME'): ('_5*', 2),
        (20, '&'): ('_7*', 2), (20, 'T_DEDENT'): ('_7*', 2),
        (23, 'T_NEWLINE'): ('class_attribute_spec', 1),
        (24, 'T_NEWLINE'): ('class_attribute_spec', 1),
        (27, 'T_NEWLINE'): ('class_attribute_byteorder', 3),
        (28, '='): ('_(11)', 1), (28, 'T_NEWLINE'): ('_(11)', 1),
        (29, '='): ('_(11)', 1), (29, 'T_NEWLINE'): ('_(11)', 1),
        (38, 'T_NEWLINE'): ('class_let_field', 6),
        (39, '='): ('field_type', 1), (39, 'T_NEWLINE'): ('field_type', 1),
        (40, '='): ('field_type', 2), (40, 'T_NEWLINE'): ('field_type', 2),
        (41, '='): ('_(14)', 1), (41, 'T_BYTEORDER'): ('_(14)', 1),
        (41, 'T_NEWLINE'): ('_(14)', 1), (41, '['): ('_(18)', 1),
        (42, '='): ('_(14)', 1), (42, 'T_BYTEORDER'): ('_(14)', 1),
        (42, 'T_NEWLINE'): ('_(14)', 1),
        (45, '='): ('field_byteorder_attribute', 3),
        (45, 'T_NEWLINE'): ('field_byteorder_attribute', 3),
        (46, '='): ('complex_type', 1),
        (46, 'T_BYTEORDER'): ('complex_type', 1),
        (46, 'T_NEWLINE'): ('complex_type', 1), (46, '['): ('_(18)', 1),
        (47, '='): ('complex_type', 1),
        (47, 'T_BYTEORDER'): ('complex_type', 1),
        (47, 'T_NEWLINE'): ('complex_type', 1), (48, '='): ('complex_type', 1),
        (48, 'T_BYTEORDER'): ('complex_type', 1),
        (48, 'T_NEWLINE'): ('complex_type', 1), (49, '='): ('user_type', 1),
        (49, 'T_BYTEORDER'): ('user_type', 1),
        (49, 'T_NEWLINE'): ('user_type', 1), (49, '['): ('user_type', 1),
        (53, '='): ('pad_type', 4), (53, 'T_BYTEORDER'): ('pad_type', 4),
        (53, 'T_NEWLINE'): ('pad_type', 4), (55, ']'): ('_19?', 0),
        (57, '='): ('_21?', 0), (57, 'T_BYTEORDER'): ('_21?', 0),
        (57, 'T_NEWLINE'): ('_21?', 0), (58, '='): ('array_type', 5),
        (58, 'T_BYTEORDER'): ('array_type', 5),
        (58, 'T_NEWLINE'): ('array_type', 5), (59, ']'): ('_19?', 1),
        (60, '='): ('_21?', 1), (60, 'T_BYTEORDER'): ('_21?', 1),
        (60, 'T_NEWLINE'): ('_21?', 1), (61, '='): ('_21?', 1),
        (61, 'T_BYTEORDER'): ('_21?', 1), (61, 'T_NEWLINE'): ('_21?', 1),
        (66, '='): ('until_attribute', 5),
        (66, 'T_BYTEORDER'): ('until_attribute', 5),
        (66, 'T_NEWLINE'): ('until_attribute', 5),
        (67, '='): ('rest_attribute', 2),
        (67, 'T_BYTEORDER'): ('rest_attribute', 2),
        (67, 'T_NEWLINE'): ('rest_attribute', 2), (68, '='): ('basic_type', 1),
        (68, 'T_BYTEORDER'): ('basic_type', 1),
        (68, 'T_NEWLINE'): ('basic_type', 1), (68, '['): ('basic_type', 1),
        (69, '='): ('basic_type', 1), (69, 'T_BYTEORDER'): ('basic_type', 1),
        (69, 'T_NEWLINE'): ('basic_type', 1), (69, '['): ('basic_type', 1),
        (70, '='): ('basic_type', 1), (70, 'T_BYTEORDER'): ('basic_type', 1),
        (70, 'T_NEWLINE'): ('basic_type', 1), (70, '['): ('basic_type', 1),
        (71, '='): ('basic_type', 1), (71, 'T_BYTEORDER'): ('basic_type', 1),
        (71, 'T_NEWLINE'): ('basic_type', 1), (71, '['): ('basic_type', 1),
        (72, '='): ('basic_type', 1), (72, 'T_BYTEORDER'): ('basic_type', 1),
        (72, 'T_NEWLINE'): ('basic_type', 1), (72, '['): ('basic_type', 1),
        (73, '='): ('basic_type', 1), (73, 'T_BYTEORDER'): ('basic_type', 1),
        (73, 'T_NEWLINE'): ('basic_type', 1), (73, '['): ('basic_type', 1),
        (74, '='): ('basic_type', 1), (74, 'T_BYTEORDER'): ('basic_type', 1),
        (74, 'T_NEWLINE'): ('basic_type', 1), (74, '['): ('basic_type', 1),
        (75, '='): ('basic_type', 1), (75, 'T_BYTEORDER'): ('basic_type', 1),
        (75, 'T_NEWLINE'): ('basic_type', 1), (75, '['): ('basic_type', 1),
        (76, ')'): ('test', 1), (77, ')'): ('_23*', 0),
        (77, 'T_OR'): ('_23*', 0), (78, ')'): ('or_test', 2),
        (80, ')'): ('_23*', 3), (80, 'T_OR'): ('_23*', 3),
        (81, ')'): ('_25*', 0), (81, 'T_AND'): ('_25*', 0),
        (81, 'T_OR'): ('_25*', 0), (82, ')'): ('and_test', 2),
        (82, 'T_OR'): ('and_test', 2), (84, ')'): ('_25*', 3),
        (84, 'T_AND'): ('_25*', 3), (84, 'T_OR'): ('_25*', 3),
        (86, ')'): ('not_test', 2), (86, 'T_AND'): ('not_test', 2),
        (86, 'T_OR'): ('not_test', 2), (87, ')'): ('not_test', 1),
        (87, 'T_AND'): ('not_test', 1), (87, 'T_OR'): ('not_test', 1),
        (88, '!='): ('_27*', 0), (88, ')'): ('_27*', 0),
        (88, '<'): ('_27*', 0), (88, '<='): ('_27*', 0),
        (88, '<>'): ('_27*', 0), (88, '=='): ('_27*', 0),
        (88, '>'): ('_27*', 0), (88, '>='): ('_27*', 0),
        (88, 'T_AND'): ('_27*', 0), (88, 'T_OR'): ('_27*', 0),
        (89, ')'): ('comparison', 2), (89, 'T_AND'): ('comparison', 2),
        (89, 'T_OR'): ('comparison', 2), (91, '!='): ('_27*', 3),
        (91, ')'): ('_27*', 3), (91, '<'): ('_27*', 3),
        (91, '<='): ('_27*', 3), (91, '<>'): ('_27*', 3),
        (91, '=='): ('_27*', 3), (91, '>'): ('_27*', 3),
        (91, '>='): ('_27*', 3), (91, 'T_AND'): ('_27*', 3),
        (91, 'T_OR'): ('_27*', 3), (92, '$'): ('comp_op', 1),
        (92, '('): ('comp_op', 1), (92, '+'): ('comp_op', 1),
        (92, '-'): ('comp_op', 1), (92, 'T_INT'): ('comp_op', 1),
        (92, 'T_NAME'): ('comp_op', 1), (92, 'T_NUMBER'): ('comp_op', 1),
        (92, 'T_STR'): ('comp_op', 1), (92, '~'): ('comp_op', 1),
        (93, '$'): ('comp_op', 1), (93, '('): ('comp_op', 1),
        (93, '+'): ('comp_op', 1), (93, '-'): ('comp_op', 1),
        (93, 'T_INT'): ('comp_op', 1), (93, 'T_NAME'): ('comp_op', 1),
        (93, 'T_NUMBER'): ('comp_op', 1), (93, 'T_STR'): ('comp_op', 1),
        (93, '~'): ('comp_op', 1), (94, '$'): ('comp_op', 1),
        (94, '('): ('comp_op', 1), (94, '+'): ('comp_op', 1),
        (94, '-'): ('comp_op', 1), (94, 'T_INT'): ('comp_op', 1),
        (94, 'T_NAME'): ('comp_op', 1), (94, 'T_NUMBER'): ('comp_op', 1),
        (94, 'T_STR'): ('comp_op', 1), (94, '~'): ('comp_op', 1),
        (95, '$'): ('comp_op', 1), (95, '('): ('comp_op', 1),
        (95, '+'): ('comp_op', 1), (95, '-'): ('comp_op', 1),
        (95, 'T_INT'): ('comp_op', 1), (95, 'T_NAME'): ('comp_op', 1),
        (95, 'T_NUMBER'): ('comp_op', 1), (95, 'T_STR'): ('comp_op', 1),
        (95, '~'): ('comp_op', 1), (96, '$'): ('comp_op', 1),
        (96, '('): ('comp_op', 1), (96, '+'): ('comp_op', 1),
        (96, '-'): ('comp_op', 1), (96, 'T_INT'): ('comp_op', 1),
        (96, 'T_NAME'): ('comp_op', 1), (96, 'T_NUMBER'): ('comp_op', 1),
        (96, 'T_STR'): ('comp_op', 1), (96, '~'): ('comp_op', 1),
        (97, '$'): ('comp_op', 1), (97, '('): ('comp_op', 1),
        (97, '+'): ('comp_op', 1), (97, '-'): ('comp_op', 1),
        (97, 'T_INT'): ('comp_op', 1), (97, 'T_NAME'): ('comp_op', 1),
        (97, 'T_NUMBER'): ('comp_op', 1), (97, 'T_STR'): ('comp_op', 1),
        (97, '~'): ('comp_op', 1), (98, '$'): ('comp_op', 1),
        (98, '('): ('comp_op', 1), (98, '+'): ('comp_op', 1),
        (98, '-'): ('comp_op', 1), (98, 'T_INT'): ('comp_op', 1),
        (98, 'T_NAME'): ('comp_op', 1), (98, 'T_NUMBER'): ('comp_op', 1),
        (98, 'T_STR'): ('comp_op', 1), (98, '~'): ('comp_op', 1),
        (99, '!='): ('_29*', 0), (99, ')'): ('_29*', 0),
        (99, '<'): ('_29*', 0), (99, '<='): ('_29*', 0),
        (99, '<>'): ('_29*', 0), (99, '=='): ('_29*', 0),
        (99, '>'): ('_29*', 0), (99, '>='): ('_29*', 0),
        (99, 'T_AND'): ('_29*', 0), (99, 'T_NEWLINE'): ('_29*', 0),
        (99, 'T_OR'): ('_29*', 0), (99, ']'): ('_29*', 0),
        (99, '|'): ('_29*', 0), (100, '!='): ('expr', 2),
        (100, ')'): ('expr', 2), (100, '<'): ('expr', 2),
        (100, '<='): ('expr', 2), (100, '<>'): ('expr', 2),
        (100, '=='): ('expr', 2), (100, '>'): ('expr', 2),
        (100, '>='): ('expr', 2), (100, 'T_AND'): ('expr', 2),
        (100, 'T_NEWLINE'): ('expr', 2), (100, 'T_OR'): ('expr', 2),
        (100, ']'): ('expr', 2), (102, '!='): ('_29*', 3),
        (102, ')'): ('_29*', 3), (102, '<'): ('_29*', 3),
        (102, '<='): ('_29*', 3), (102, '<>'): ('_29*', 3),
        (102, '=='): ('_29*', 3), (102, '>'): ('_29*', 3),
        (102, '>='): ('_29*', 3), (102, 'T_AND'): ('_29*', 3),
        (102, 'T_NEWLINE'): ('_29*', 3), (102, 'T_OR'): ('_29*', 3),
        (102, ']'): ('_29*', 3), (102, '|'): ('_29*', 3),
        (103, '!='): ('_31*', 0), (103, ')'): ('_31*', 0),
        (103, '<'): ('_31*', 0), (103, '<='): ('_31*', 0),
        (103, '<>'): ('_31*', 0), (103, '=='): ('_31*', 0),
        (103, '>'): ('_31*', 0), (103, '>='): ('_31*', 0),
        (103, 'T_AND'): ('_31*', 0), (103, 'T_NEWLINE'): ('_31*', 0),
        (103, 'T_OR'): ('_31*', 0), (103, ']'): ('_31*', 0),
        (103, '^'): ('_31*', 0), (103, '|'): ('_31*', 0),
        (104, '!='): ('xor_expr', 2), (104, ')'): ('xor_expr', 2),
        (104, '<'): ('xor_expr', 2), (104, '<='): ('xor_expr', 2),
        (104, '<>'): ('xor_expr', 2), (104, '=='): ('xor_expr', 2),
        (104, '>'): ('xor_expr', 2), (104, '>='): ('xor_expr', 2),
        (104, 'T_AND'): ('xor_expr', 2), (104, 'T_NEWLINE'): ('xor_expr', 2),
        (104, 'T_OR'): ('xor_expr', 2), (104, ']'): ('xor_expr', 2),
        (104, '|'): ('xor_expr', 2), (106, '!='): ('_31*', 3),
        (106, ')'): ('_31*', 3), (106, '<'): ('_31*', 3),
        (106, '<='): ('_31*', 3), (106, '<>'): ('_31*', 3),
        (106, '=='): ('_31*', 3), (106, '>'): ('_31*', 3),
        (106, '>='): ('_31*', 3), (106, 'T_AND'): ('_31*', 3),
        (106, 'T_NEWLINE'): ('_31*', 3), (106, 'T_OR'): ('_31*', 3),
        (106, ']'): ('_31*', 3), (106, '^'): ('_31*', 3),
        (106, '|'): ('_31*', 3), (107, '!='): ('_33*', 0),
        (107, '&'): ('_33*', 0), (107, ')'): ('_33*', 0),
        (107, '<'): ('_33*', 0), (107, '<='): ('_33*', 0),
        (107, '<>'): ('_33*', 0), (107, '=='): ('_33*', 0),
        (107, '>'): ('_33*', 0), (107, '>='): ('_33*', 0),
        (107, 'T_AND'): ('_33*', 0), (107, 'T_NEWLINE'): ('_33*', 0),
        (107, 'T_OR'): ('_33*', 0), (107, ']'): ('_33*', 0),
        (107, '^'): ('_33*', 0), (107, '|'): ('_33*', 0),
        (108, '!='): ('and_expr', 2), (108, ')'): ('and_expr', 2),
        (108, '<'): ('and_expr', 2), (108, '<='): ('and_expr', 2),
        (108, '<>'): ('and_expr', 2), (108, '=='): ('and_expr', 2),
        (108, '>'): ('and_expr', 2), (108, '>='): ('and_expr', 2),
        (108, 'T_AND'): ('and_expr', 2), (108, 'T_NEWLINE'): ('and_expr', 2),
        (108, 'T_OR'): ('and_expr', 2), (108, ']'): ('and_expr', 2),
        (108, '^'): ('and_expr', 2), (108, '|'): ('and_expr', 2),
        (110, '!='): ('_33*', 3), (110, '&'): ('_33*', 3),
        (110, ')'): ('_33*', 3), (110, '<'): ('_33*', 3),
        (110, '<='): ('_33*', 3), (110, '<>'): ('_33*', 3),
        (110, '=='): ('_33*', 3), (110, '>'): ('_33*', 3),
        (110, '>='): ('_33*', 3), (110, 'T_AND'): ('_33*', 3),
        (110, 'T_NEWLINE'): ('_33*', 3), (110, 'T_OR'): ('_33*', 3),
        (110, ']'): ('_33*', 3), (110, '^'): ('_33*', 3),
        (110, '|'): ('_33*', 3), (111, '!='): ('_35*', 0),
        (111, '&'): ('_35*', 0), (111, ')'): ('_35*', 0),
        (111, '<'): ('_35*', 0), (111, '<<'): ('_35*', 0),
        (111, '<='): ('_35*', 0), (111, '<>'): ('_35*', 0),
        (111, '=='): ('_35*', 0), (111, '>'): ('_35*', 0),
        (111, '>='): ('_35*', 0), (111, '>>'): ('_35*', 0),
        (111, 'T_AND'): ('_35*', 0), (111, 'T_NEWLINE'): ('_35*', 0),
        (111, 'T_OR'): ('_35*', 0), (111, ']'): ('_35*', 0),
        (111, '^'): ('_35*', 0), (111, '|'): ('_35*', 0),
        (112, '!='): ('shift_expr', 2), (112, '&'): ('shift_expr', 2),
        (112, ')'): ('shift_expr', 2), (112, '<'): ('shift_expr', 2),
        (112, '<='): ('shift_expr', 2), (112, '<>'): ('shift_expr', 2),
        (112, '=='): ('shift_expr', 2), (112, '>'): ('shift_expr', 2),
        (112, '>='): ('shift_expr', 2), (112, 'T_AND'): ('shift_expr', 2),
        (112, 'T_NEWLINE'): ('shift_expr', 2),
        (112, 'T_OR'): ('shift_expr', 2), (112, ']'): ('shift_expr', 2),
        (112, '^'): ('shift_expr', 2), (112, '|'): ('shift_expr', 2),
        (113, '$'): ('_(36)', 1), (113, '('): ('_(36)', 1),
        (113, '+'): ('_(36)', 1), (113, '-'): ('_(36)', 1),
        (113, 'T_INT'): ('_(36)', 1), (113, 'T_NAME'): ('_(36)', 1),
        (113, 'T_NUMBER'): ('_(36)', 1), (113, 'T_STR'): ('_(36)', 1),
        (113, '~'): ('_(36)', 1), (114, '$'): ('_(36)', 1),
        (114, '('): ('_(36)', 1), (114, '+'): ('_(36)', 1),
        (114, '-'): ('_(36)', 1), (114, 'T_INT'): ('_(36)', 1),
        (114, 'T_NAME'): ('_(36)', 1), (114, 'T_NUMBER'): ('_(36)', 1),
        (114, 'T_STR'): ('_(36)', 1), (114, '~'): ('_(36)', 1),
        (116, '!='): ('_35*', 3), (116, '&'): ('_35*', 3),
        (116, ')'): ('_35*', 3), (116, '<'): ('_35*', 3),
        (116, '<<'): ('_35*', 3), (116, '<='): ('_35*', 3),
        (116, '<>'): ('_35*', 3), (116, '=='): ('_35*', 3),
        (116, '>'): ('_35*', 3), (116, '>='): ('_35*', 3),
        (116, '>>'): ('_35*', 3), (116, 'T_AND'): ('_35*', 3),
        (116, 'T_NEWLINE'): ('_35*', 3), (116, 'T_OR'): ('_35*', 3),
        (116, ']'): ('_35*', 3), (116, '^'): ('_35*', 3),
        (116, '|'): ('_35*', 3), (117, '!='): ('func_expr', 1),
        (117, '&'): ('func_expr', 1), (117, ')'): ('func_expr', 1),
        (117, '<'): ('func_expr', 1), (117, '<<'): ('func_expr', 1),
        (117, '<='): ('func_expr', 1), (117, '<>'): ('func_expr', 1),
        (117, '=='): ('func_expr', 1), (117, '>'): ('func_expr', 1),
        (117, '>='): ('func_expr', 1), (117, '>>'): ('func_expr', 1),
        (117, 'T_AND'): ('func_expr', 1), (117, 'T_NEWLINE'): ('func_expr', 1),
        (117, 'T_OR'): ('func_expr', 1), (117, ']'): ('func_expr', 1),
        (117, '^'): ('func_expr', 1), (117, '|'): ('func_expr', 1),
        (121, '!='): ('func_expr', 4), (121, '&'): ('func_expr', 4),
        (121, ')'): ('func_expr', 4), (121, '<'): ('func_expr', 4),
        (121, '<<'): ('func_expr', 4), (121, '<='): ('func_expr', 4),
        (121, '<>'): ('func_expr', 4), (121, '=='): ('func_expr', 4),
        (121, '>'): ('func_expr', 4), (121, '>='): ('func_expr', 4),
        (121, '>>'): ('func_expr', 4), (121, 'T_AND'): ('func_expr', 4),
        (121, 'T_NEWLINE'): ('func_expr', 4), (121, 'T_OR'): ('func_expr', 4),
        (121, ']'): ('func_expr', 4), (121, '^'): ('func_expr', 4),
        (121, '|'): ('func_expr', 4), (122, '!='): ('_38*', 0),
        (122, '&'): ('_38*', 0), (122, ')'): ('_38*', 0),
        (122, '+'): ('_38*', 0), (122, '-'): ('_38*', 0),
        (122, '<'): ('_38*', 0), (122, '<<'): ('_38*', 0),
        (122, '<='): ('_38*', 0), (122, '<>'): ('_38*', 0),
        (122, '=='): ('_38*', 0), (122, '>'): ('_38*', 0),
        (122, '>='): ('_38*', 0), (122, '>>'): ('_38*', 0),
        (122, 'T_AND'): ('_38*', 0), (122, 'T_NEWLINE'): ('_38*', 0),
        (122, 'T_OR'): ('_38*', 0), (122, ']'): ('_38*', 0),
        (122, '^'): ('_38*', 0), (122, '|'): ('_38*', 0),
        (123, '!='): ('arith_expr', 2), (123, '&'): ('arith_expr', 2),
        (123, ')'): ('arith_expr', 2), (123, '<'): ('arith_expr', 2),
        (123, '<<'): ('arith_expr', 2), (123, '<='): ('arith_expr', 2),
        (123, '<>'): ('arith_expr', 2), (123, '=='): ('arith_expr', 2),
        (123, '>'): ('arith_expr', 2), (123, '>='): ('arith_expr', 2),
        (123, '>>'): ('arith_expr', 2), (123, 'T_AND'): ('arith_expr', 2),
        (123, 'T_NEWLINE'): ('arith_expr', 2),
        (123, 'T_OR'): ('arith_expr', 2), (123, ']'): ('arith_expr', 2),
        (123, '^'): ('arith_expr', 2), (123, '|'): ('arith_expr', 2),
        (124, '$'): ('_(39)', 1), (124, '('): ('_(39)', 1),
        (124, '+'): ('_(39)', 1), (124, '-'): ('_(39)', 1),
        (124, 'T_NAME'): ('_(39)', 1), (124, 'T_NUMBER'): ('_(39)', 1),
        (124, 'T_STR'): ('_(39)', 1), (124, '~'): ('_(39)', 1),
        (125, '$'): ('_(39)', 1), (125, '('): ('_(39)', 1),
        (125, '+'): ('_(39)', 1), (125, '-'): ('_(39)', 1),
        (125, 'T_NAME'): ('_(39)', 1), (125, 'T_NUMBER'): ('_(39)', 1),
        (125, 'T_STR'): ('_(39)', 1), (125, '~'): ('_(39)', 1),
        (127, '!='): ('_38*', 3), (127, '&'): ('_38*', 3),
        (127, ')'): ('_38*', 3), (127, '+'): ('_38*', 3),
        (127, '-'): ('_38*', 3), (127, '<'): ('_38*', 3),
        (127, '<<'): ('_38*', 3), (127, '<='): ('_38*', 3),
        (127, '<>'): ('_38*', 3), (127, '=='): ('_38*', 3),
        (127, '>'): ('_38*', 3), (127, '>='): ('_38*', 3),
        (127, '>>'): ('_38*', 3), (127, 'T_AND'): ('_38*', 3),
        (127, 'T_NEWLINE'): ('_38*', 3), (127, 'T_OR'): ('_38*', 3),
        (127, ']'): ('_38*', 3), (127, '^'): ('_38*', 3),
        (127, '|'): ('_38*', 3), (128, '!='): ('_41*', 0),
        (128, '%'): ('_41*', 0), (128, '&'): ('_41*', 0),
        (128, ')'): ('_41*', 0), (128, '*'): ('_41*', 0),
        (128, '+'): ('_41*', 0), (128, '-'): ('_41*', 0),
        (128, '/'): ('_41*', 0), (128, '//'): ('_41*', 0),
        (128, '<'): ('_41*', 0), (128, '<<'): ('_41*', 0),
        (128, '<='): ('_41*', 0), (128, '<>'): ('_41*', 0),
        (128, '=='): ('_41*', 0), (128, '>'): ('_41*', 0),
        (128, '>='): ('_41*', 0), (128, '>>'): ('_41*', 0),
        (128, 'T_AND'): ('_41*', 0), (128, 'T_NEWLINE'): ('_41*', 0),
        (128, 'T_OR'): ('_41*', 0), (128, ']'): ('_41*', 0),
        (128, '^'): ('_41*', 0), (128, '|'): ('_41*', 0),
        (129, '!='): ('term', 2), (129, '&'): ('term', 2),
        (129, ')'): ('term', 2), (129, '+'): ('term', 2),
        (129, '-'): ('term', 2), (129, '<'): ('term', 2),
        (129, '<<'): ('term', 2), (129, '<='): ('term', 2),
        (129, '<>'): ('term', 2), (129, '=='): ('term', 2),
        (129, '>'): ('term', 2), (129, '>='): ('term', 2),
        (129, '>>'): ('term', 2), (129, 'T_AND'): ('term', 2),
        (129, 'T_NEWLINE'): ('term', 2), (129, 'T_OR'): ('term', 2),
        (129, ']'): ('term', 2), (129, '^'): ('term', 2),
        (129, '|'): ('term', 2), (130, '$'): ('_(42)', 1),
        (130, '('): ('_(42)', 1), (130, '+'): ('_(42)', 1),
        (130, '-'): ('_(42)', 1), (130, 'T_NAME'): ('_(42)', 1),
        (130, 'T_NUMBER'): ('_(42)', 1), (130, 'T_STR'): ('_(42)', 1),
        (130, '~'): ('_(42)', 1), (131, '$'): ('_(42)', 1),
        (131, '('): ('_(42)', 1), (131, '+'): ('_(42)', 1),
        (131, '-'): ('_(42)', 1), (131, 'T_NAME'): ('_(42)', 1),
        (131, 'T_NUMBER'): ('_(42)', 1), (131, 'T_STR'): ('_(42)', 1),
        (131, '~'): ('_(42)', 1), (132, '$'): ('_(42)', 1),
        (132, '('): ('_(42)', 1), (132, '+'): ('_(42)', 1),
        (132, '-'): ('_(42)', 1), (132, 'T_NAME'): ('_(42)', 1),
        (132, 'T_NUMBER'): ('_(42)', 1), (132, 'T_STR'): ('_(42)', 1),
        (132, '~'): ('_(42)', 1), (133, '$'): ('_(42)', 1),
        (133, '('): ('_(42)', 1), (133, '+'): ('_(42)', 1),
        (133, '-'): ('_(42)', 1), (133, 'T_NAME'): ('_(42)', 1),
        (133, 'T_NUMBER'): ('_(42)', 1), (133, 'T_STR'): ('_(42)', 1),
        (133, '~'): ('_(42)', 1), (135, '!='): ('_41*', 3),
        (135, '%'): ('_41*', 3), (135, '&'): ('_41*', 3),
        (135, ')'): ('_41*', 3), (135, '*'): ('_41*', 3),
        (135, '+'): ('_41*', 3), (135, '-'): ('_41*', 3),
        (135, '/'): ('_41*', 3), (135, '//'): ('_41*', 3),
        (135, '<'): ('_41*', 3), (135, '<<'): ('_41*', 3),
        (135, '<='): ('_41*', 3), (135, '<>'): ('_41*', 3),
        (135, '=='): ('_41*', 3), (135, '>'): ('_41*', 3),
        (135, '>='): ('_41*', 3), (135, '>>'): ('_41*', 3),
        (135, 'T_AND'): ('_41*', 3), (135, 'T_NEWLINE'): ('_41*', 3),
        (135, 'T_OR'): ('_41*', 3), (135, ']'): ('_41*', 3),
        (135, '^'): ('_41*', 3), (135, '|'): ('_41*', 3),
        (137, '!='): ('factor', 2), (137, '%'): ('factor', 2),
        (137, '&'): ('factor', 2), (137, ')'): ('factor', 2),
        (137, '*'): ('factor', 2), (137, '+'): ('factor', 2),
        (137, '-'): ('factor', 2), (137, '/'): ('factor', 2),
        (137, '//'): ('factor', 2), (137, '<'): ('factor', 2),
        (137, '<<'): ('factor', 2), (137, '<='): ('factor', 2),
        (137, '<>'): ('factor', 2), (137, '=='): ('factor', 2),
        (137, '>'): ('factor', 2), (137, '>='): ('factor', 2),
        (137, '>>'): ('factor', 2), (137, 'T_AND'): ('factor', 2),
        (137, 'T_NEWLINE'): ('factor', 2), (137, 'T_OR'): ('factor', 2),
        (137, ']'): ('factor', 2), (137, '^'): ('factor', 2),
        (137, '|'): ('factor', 2), (138, '$'): ('_(43)', 1),
        (138, '('): ('_(43)', 1), (138, '+'): ('_(43)', 1),
        (138, '-'): ('_(43)', 1), (138, 'T_NAME'): ('_(43)', 1),
        (138, 'T_NUMBER'): ('_(43)', 1), (138, 'T_STR'): ('_(43)', 1),
        (138, '~'): ('_(43)', 1), (139, '$'): ('_(43)', 1),
        (139, '('): ('_(43)', 1), (139, '+'): ('_(43)', 1),
        (139, '-'): ('_(43)', 1), (139, 'T_NAME'): ('_(43)', 1),
        (139, 'T_NUMBER'): ('_(43)', 1), (139, 'T_STR'): ('_(43)', 1),
        (139, '~'): ('_(43)', 1), (140, '$'): ('_(43)', 1),
        (140, '('): ('_(43)', 1), (140, '+'): ('_(43)', 1),
        (140, '-'): ('_(43)', 1), (140, 'T_NAME'): ('_(43)', 1),
        (140, 'T_NUMBER'): ('_(43)', 1), (140, 'T_STR'): ('_(43)', 1),
        (140, '~'): ('_(43)', 1), (141, '!='): ('factor', 1),
        (141, '%'): ('factor', 1), (141, '&'): ('factor', 1),
        (141, ')'): ('factor', 1), (141, '*'): ('factor', 1),
        (141, '+'): ('factor', 1), (141, '-'): ('factor', 1),
        (141, '/'): ('factor', 1), (141, '//'): ('factor', 1),
        (141, '<'): ('factor', 1), (141, '<<'): ('factor', 1),
        (141, '<='): ('factor', 1), (141, '<>'): ('factor', 1),
        (141, '=='): ('factor', 1), (141, '>'): ('factor', 1),
        (141, '>='): ('factor', 1), (141, '>>'): ('factor', 1),
        (141, 'T_AND'): ('factor', 1), (141, 'T_NEWLINE'): ('factor', 1),
        (141, 'T_OR'): ('factor', 1), (141, ']'): ('factor', 1),
        (141, '^'): ('factor', 1), (141, '|'): ('factor', 1),
        (144, '!='): ('factor', 3), (144, '%'): ('factor', 3),
        (144, '&'): ('factor', 3), (144, ')'): ('factor', 3),
        (144, '*'): ('factor', 3), (144, '+'): ('factor', 3),
        (144, '-'): ('factor', 3), (144, '/'): ('factor', 3),
        (144, '//'): ('factor', 3), (144, '<'): ('factor', 3),
        (144, '<<'): ('factor', 3), (144, '<='): ('factor', 3),
        (144, '<>'): ('factor', 3), (144, '=='): ('factor', 3),
        (144, '>'): ('factor', 3), (144, '>='): ('factor', 3),
        (144, '>>'): ('factor', 3), (144, 'T_AND'): ('factor', 3),
        (144, 'T_NEWLINE'): ('factor', 3), (144, 'T_OR'): ('factor', 3),
        (144, ']'): ('factor', 3), (144, '^'): ('factor', 3),
        (144, '|'): ('factor', 3), (145, '!='): ('power', 1),
        (145, '%'): ('power', 1), (145, '&'): ('power', 1),
        (145, ')'): ('power', 1), (145, '*'): ('power', 1),
        (145, '+'): ('power', 1), (145, '-'): ('power', 1),
        (145, '/'): ('power', 1), (145, '//'): ('power', 1),
        (145, '<'): ('power', 1), (145, '<<'): ('power', 1),
        (145, '<='): ('power', 1), (145, '<>'): ('power', 1),
        (145, '=='): ('power', 1), (145, '>'): ('power', 1),
        (145, '>='): ('power', 1), (145, '>>'): ('power', 1),
        (145, 'T_AND'): ('power', 1), (145, 'T_NEWLINE'): ('power', 1),
        (145, 'T_OR'): ('power', 1), (145, ']'): ('power', 1),
        (145, '^'): ('power', 1), (145, '|'): ('power', 1),
        (147, '!='): ('power', 3), (147, '%'): ('power', 3),
        (147, '&'): ('power', 3), (147, ')'): ('power', 3),
        (147, '*'): ('power', 3), (147, '+'): ('power', 3),
        (147, '-'): ('power', 3), (147, '/'): ('power', 3),
        (147, '//'): ('power', 3), (147, '<'): ('power', 3),
        (147, '<<'): ('power', 3), (147, '<='): ('power', 3),
        (147, '<>'): ('power', 3), (147, '=='): ('power', 3),
        (147, '>'): ('power', 3), (147, '>='): ('power', 3),
        (147, '>>'): ('power', 3), (147, 'T_AND'): ('power', 3),
        (147, 'T_NEWLINE'): ('power', 3), (147, 'T_OR'): ('power', 3),
        (147, ']'): ('power', 3), (147, '^'): ('power', 3),
        (147, '|'): ('power', 3), (148, '!='): ('atom', 1),
        (148, '%'): ('atom', 1), (148, '&'): ('atom', 1),
        (148, ')'): ('atom', 1), (148, '*'): ('atom', 1),
        (148, '**'): ('atom', 1), (148, '+'): ('atom', 1),
        (148, '-'): ('atom', 1), (148, '/'): ('atom', 1),
        (148, '//'): ('atom', 1), (148, '<'): ('atom', 1),
        (148, '<<'): ('atom', 1), (148, '<='): ('atom', 1),
        (148, '<>'): ('atom', 1), (148, '=='): ('atom', 1),
        (148, '>'): ('atom', 1), (148, '>='): ('atom', 1),
        (148, '>>'): ('atom', 1), (148, 'T_AND'): ('atom', 1),
        (148, 'T_NEWLINE'): ('atom', 1), (148, 'T_OR'): ('atom', 1),
        (148, ']'): ('atom', 1), (148, '^'): ('atom', 1),
        (148, '|'): ('atom', 1), (149, '!='): ('atom', 1),
        (149, '%'): ('atom', 1), (149, '&'): ('atom', 1),
        (149, ')'): ('atom', 1), (149, '*'): ('atom', 1),
        (149, '**'): ('atom', 1), (149, '+'): ('atom', 1),
        (149, '-'): ('atom', 1), (149, '/'): ('atom', 1),
        (149, '//'): ('atom', 1), (149, '<'): ('atom', 1),
        (149, '<<'): ('atom', 1), (149, '<='): ('atom', 1),
        (149, '<>'): ('atom', 1), (149, '=='): ('atom', 1),
        (149, '>'): ('atom', 1), (149, '>='): ('atom', 1),
        (149, '>>'): ('atom', 1), (149, 'T_AND'): ('atom', 1),
        (149, 'T_NEWLINE'): ('atom', 1), (149, 'T_OR'): ('atom', 1),
        (149, ']'): ('atom', 1), (149, '^'): ('atom', 1),
        (149, '|'): ('atom', 1), (150, '!='): ('atom', 1),
        (150, '%'): ('atom', 1), (150, '&'): ('atom', 1),
        (150, ')'): ('atom', 1), (150, '*'): ('atom', 1),
        (150, '**'): ('atom', 1), (150, '+'): ('atom', 1),
        (150, '-'): ('atom', 1), (150, '/'): ('atom', 1),
        (150, '//'): ('atom', 1), (150, '<'): ('atom', 1),
        (150, '<<'): ('atom', 1), (150, '<='): ('atom', 1),
        (150, '<>'): ('atom', 1), (150, '=='): ('atom', 1),
        (150, '>'): ('atom', 1), (150, '>='): ('atom', 1),
        (150, '>>'): ('atom', 1), (150, 'T_AND'): ('atom', 1),
        (150, 'T_NEWLINE'): ('atom', 1), (150, 'T_OR'): ('atom', 1),
        (150, ']'): ('atom', 1), (150, '^'): ('atom', 1),
        (150, '|'): ('atom', 1), (151, '!='): ('atom', 1),
        (151, '%'): ('atom', 1), (151, '&'): ('atom', 1),
        (151, ')'): ('atom', 1), (151, '*'): ('atom', 1),
        (151, '**'): ('atom', 1), (151, '+'): ('atom', 1),
        (151, '-'): ('atom', 1), (151, '/'): ('atom', 1),
        (151, '//'): ('atom', 1), (151, '<'): ('atom', 1),
        (151, '<<'): ('atom', 1), (151, '<='): ('atom', 1),
        (151, '<>'): ('atom', 1), (151, '=='): ('atom', 1),
        (151, '>'): ('atom', 1), (151, '>='): ('atom', 1),
        (151, '>>'): ('atom', 1), (151, 'T_AND'): ('atom', 1),
        (151, 'T_NEWLINE'): ('atom', 1), (151, 'T_OR'): ('atom', 1),
        (151, ']'): ('atom', 1), (151, '^'): ('atom', 1),
        (151, '|'): ('atom', 1), (153, '!='): ('keyid', 2),
        (153, '%'): ('keyid', 2), (153, '&'): ('keyid', 2),
        (153, ')'): ('keyid', 2), (153, '*'): ('keyid', 2),
        (153, '**'): ('keyid', 2), (153, '+'): ('keyid', 2),
        (153, '-'): ('keyid', 2), (153, '/'): ('keyid', 2),
        (153, '//'): ('keyid', 2), (153, '<'): ('keyid', 2),
        (153, '<<'): ('keyid', 2), (153, '<='): ('keyid', 2),
        (153, '<>'): ('keyid', 2), (153, '=='): ('keyid', 2),
        (153, '>'): ('keyid', 2), (153, '>='): ('keyid', 2),
        (153, '>>'): ('keyid', 2), (153, 'T_AND'): ('keyid', 2),
        (153, 'T_NEWLINE'): ('keyid', 2), (153, 'T_OR'): ('keyid', 2),
        (153, ']'): ('keyid', 2), (153, '^'): ('keyid', 2),
        (153, '|'): ('keyid', 2), (154, '('): ('func', 1),
        (155, '!='): ('name', 1), (155, '%'): ('name', 1),
        (155, '&'): ('name', 1), (155, ')'): ('name', 1),
        (155, '*'): ('name', 1), (155, '**'): ('name', 1),
        (155, '+'): ('name', 1), (155, '-'): ('name', 1),
        (155, '/'): ('name', 1), (155, '//'): ('name', 1),
        (155, ':'): ('name', 1), (155, '<'): ('name', 1),
        (155, '<<'): ('name', 1), (155, '<='): ('name', 1),
        (155, '<>'): ('name', 1), (155, '=='): ('name', 1),
        (155, '>'): ('name', 1), (155, '>='): ('name', 1),
        (155, '>>'): ('name', 1), (155, 'T_AND'): ('name', 1),
        (155, 'T_NEWLINE'): ('name', 1), (155, 'T_NUMBER'): ('name', 1),
        (155, 'T_OR'): ('name', 1), (155, ']'): ('name', 1),
        (155, '^'): ('name', 1), (155, '|'): ('name', 1),
        (156, '&'): ('newline', 1), (156, 'T_DEDENT'): ('newline', 1),
        (156, 'T_INDENT'): ('newline', 1), (156, 'T_NAME'): ('newline', 1),
        (156, 'T_NEWLINE'): ('newline', 1), (157, '!='): ('str', 1),
        (157, '%'): ('str', 1), (157, '&'): ('str', 1), (157, ')'): ('str', 1),
        (157, '*'): ('str', 1), (157, '**'): ('str', 1),
        (157, '+'): ('str', 1), (157, '-'): ('str', 1), (157, '/'): ('str', 1),
        (157, '//'): ('str', 1), (157, '<'): ('str', 1),
        (157, '<<'): ('str', 1), (157, '<='): ('str', 1),
        (157, '<>'): ('str', 1), (157, '=='): ('str', 1),
        (157, '>'): ('str', 1), (157, '>='): ('str', 1),
        (157, '>>'): ('str', 1), (157, 'T_AND'): ('str', 1),
        (157, 'T_NEWLINE'): ('str', 1), (157, 'T_OR'): ('str', 1),
        (157, ']'): ('str', 1), (157, '^'): ('str', 1), (157, '|'): ('str', 1),
        (158, 'T_NAME'): ('langid', 1), (159, '!='): ('number', 1),
        (159, '%'): ('number', 1), (159, '&'): ('number', 1),
        (159, ')'): ('number', 1), (159, '*'): ('number', 1),
        (159, '**'): ('number', 1), (159, '+'): ('number', 1),
        (159, '-'): ('number', 1), (159, '/'): ('number', 1),
        (159, '//'): ('number', 1), (159, '<'): ('number', 1),
        (159, '<<'): ('number', 1), (159, '<='): ('number', 1),
        (159, '<>'): ('number', 1), (159, '='): ('number', 1),
        (159, '=='): ('number', 1), (159, '>'): ('number', 1),
        (159, '>='): ('number', 1), (159, '>>'): ('number', 1),
        (159, 'T_AND'): ('number', 1), (159, 'T_BYTEORDER'): ('number', 1),
        (159, 'T_NEWLINE'): ('number', 1), (159, 'T_OR'): ('number', 1),
        (159, ']'): ('number', 1), (159, '^'): ('number', 1),
        (159, '|'): ('number', 1)
    }
    _goto = {
        (0, '_1*'): 3, (0, 'compound_stmt'): 2, (0, 'single_input'): 1,
        (3, 'class'): 4, (3, 'classdef'): 5, (3, 'langid'): 9, (6, '_5*'): 17,
        (6, 'class_scope'): 7, (9, 'name'): 10, (11, '_3+'): 12,
        (11, 'newline'): 13, (12, 'newline'): 16, (14, 'newline'): 16,
        (15, 'newline'): 16, (17, '_7*'): 18, (17, 'class_field'): 19,
        (17, 'name'): 30, (18, 'class_attribute'): 20,
        (21, 'class_attribute_byteorder'): 23,
        (21, 'class_attribute_spec'): 22, (21, 'class_let_field'): 24,
        (22, '_3+'): 15, (22, 'newline'): 13, (26, '_(11)'): 27,
        (31, '_(14)'): 39, (31, '_(18)'): 54, (31, 'array_type'): 48,
        (31, 'basic_type'): 41, (31, 'complex_type'): 42,
        (31, 'field_type'): 32, (31, 'pad_type'): 47, (31, 'user_type'): 46,
        (32, '_3+'): 14, (32, 'newline'): 13, (33, 'name'): 34,
        (35, '_(14)'): 39, (35, '_(18)'): 54, (35, 'array_type'): 48,
        (35, 'basic_type'): 41, (35, 'complex_type'): 42,
        (35, 'field_type'): 36, (35, 'pad_type'): 47, (35, 'user_type'): 46,
        (37, '_(43)'): 136, (37, 'and_expr'): 103, (37, 'arith_expr'): 117,
        (37, 'atom'): 145, (37, 'expr'): 38, (37, 'factor'): 128,
        (37, 'func'): 118, (37, 'func_expr'): 111, (37, 'keyid'): 151,
        (37, 'name'): 150, (37, 'number'): 148, (37, 'power'): 141,
        (37, 'shift_expr'): 107, (37, 'str'): 149, (37, 'term'): 122,
        (37, 'xor_expr'): 99, (39, 'field_byteorder_attribute'): 40,
        (44, '_(11)'): 45, (51, 'name'): 52, (52, 'number'): 53,
        (55, '_(43)'): 136, (55, '_19?'): 56, (55, 'and_expr'): 103,
        (55, 'arith_expr'): 117, (55, 'atom'): 145, (55, 'expr'): 59,
        (55, 'factor'): 128, (55, 'func'): 118, (55, 'func_expr'): 111,
        (55, 'keyid'): 151, (55, 'name'): 150, (55, 'number'): 148,
        (55, 'power'): 141, (55, 'shift_expr'): 107, (55, 'str'): 149,
        (55, 'term'): 122, (55, 'xor_expr'): 99, (57, '_21?'): 58,
        (57, 'rest_attribute'): 60, (57, 'until_attribute'): 61,
        (64, '_(43)'): 136, (64, 'and_expr'): 103, (64, 'and_test'): 77,
        (64, 'arith_expr'): 117, (64, 'atom'): 145, (64, 'comparison'): 87,
        (64, 'expr'): 88, (64, 'factor'): 128, (64, 'func'): 118,
        (64, 'func_expr'): 111, (64, 'keyid'): 151, (64, 'name'): 150,
        (64, 'not_test'): 81, (64, 'number'): 148, (64, 'or_test'): 76,
        (64, 'power'): 141, (64, 'shift_expr'): 107, (64, 'str'): 149,
        (64, 'term'): 122, (64, 'test'): 65, (64, 'xor_expr'): 99,
        (77, '_23*'): 78, (79, '_(43)'): 136, (79, 'and_expr'): 103,
        (79, 'and_test'): 80, (79, 'arith_expr'): 117, (79, 'atom'): 145,
        (79, 'comparison'): 87, (79, 'expr'): 88, (79, 'factor'): 128,
        (79, 'func'): 118, (79, 'func_expr'): 111, (79, 'keyid'): 151,
        (79, 'name'): 150, (79, 'not_test'): 81, (79, 'number'): 148,
        (79, 'power'): 141, (79, 'shift_expr'): 107, (79, 'str'): 149,
        (79, 'term'): 122, (79, 'xor_expr'): 99, (81, '_25*'): 82,
        (83, '_(43)'): 136, (83, 'and_expr'): 103, (83, 'arith_expr'): 117,
        (83, 'atom'): 145, (83, 'comparison'): 87, (83, 'expr'): 88,
        (83, 'factor'): 128, (83, 'func'): 118, (83, 'func_expr'): 111,
        (83, 'keyid'): 151, (83, 'name'): 150, (83, 'not_test'): 84,
        (83, 'number'): 148, (83, 'power'): 141, (83, 'shift_expr'): 107,
        (83, 'str'): 149, (83, 'term'): 122, (83, 'xor_expr'): 99,
        (85, '_(43)'): 136, (85, 'and_expr'): 103, (85, 'arith_expr'): 117,
        (85, 'atom'): 145, (85, 'comparison'): 87, (85, 'expr'): 88,
        (85, 'factor'): 128, (85, 'func'): 118, (85, 'func_expr'): 111,
        (85, 'keyid'): 151, (85, 'name'): 150, (85, 'not_test'): 86,
        (85, 'number'): 148, (85, 'power'): 141, (85, 'shift_expr'): 107,
        (85, 'str'): 149, (85, 'term'): 122, (85, 'xor_expr'): 99,
        (88, '_27*'): 89, (89, 'comp_op'): 90, (90, '_(43)'): 136,
        (90, 'and_expr'): 103, (90, 'arith_expr'): 117, (90, 'atom'): 145,
        (90, 'expr'): 91, (90, 'factor'): 128, (90, 'func'): 118,
        (90, 'func_expr'): 111, (90, 'keyid'): 151, (90, 'name'): 150,
        (90, 'number'): 148, (90, 'power'): 141, (90, 'shift_expr'): 107,
        (90, 'str'): 149, (90, 'term'): 122, (90, 'xor_expr'): 99,
        (99, '_29*'): 100, (101, '_(43)'): 136, (101, 'and_expr'): 103,
        (101, 'arith_expr'): 117, (101, 'atom'): 145, (101, 'factor'): 128,
        (101, 'func'): 118, (101, 'func_expr'): 111, (101, 'keyid'): 151,
        (101, 'name'): 150, (101, 'number'): 148, (101, 'power'): 141,
        (101, 'shift_expr'): 107, (101, 'str'): 149, (101, 'term'): 122,
        (101, 'xor_expr'): 102, (103, '_31*'): 104, (105, '_(43)'): 136,
        (105, 'and_expr'): 106, (105, 'arith_expr'): 117, (105, 'atom'): 145,
        (105, 'factor'): 128, (105, 'func'): 118, (105, 'func_expr'): 111,
        (105, 'keyid'): 151, (105, 'name'): 150, (105, 'number'): 148,
        (105, 'power'): 141, (105, 'shift_expr'): 107, (105, 'str'): 149,
        (105, 'term'): 122, (107, '_33*'): 108, (109, '_(43)'): 136,
        (109, 'arith_expr'): 117, (109, 'atom'): 145, (109, 'factor'): 128,
        (109, 'func'): 118, (109, 'func_expr'): 111, (109, 'keyid'): 151,
        (109, 'name'): 150, (109, 'number'): 148, (109, 'power'): 141,
        (109, 'shift_expr'): 110, (109, 'str'): 149, (109, 'term'): 122,
        (111, '_35*'): 112, (112, '_(36)'): 115, (115, '_(43)'): 136,
        (115, 'arith_expr'): 117, (115, 'atom'): 145, (115, 'factor'): 128,
        (115, 'func'): 118, (115, 'func_expr'): 116, (115, 'keyid'): 151,
        (115, 'name'): 150, (115, 'number'): 148, (115, 'power'): 141,
        (115, 'str'): 149, (115, 'term'): 122, (119, '_(43)'): 136,
        (119, 'arith_expr'): 120, (119, 'atom'): 145, (119, 'factor'): 128,
        (119, 'keyid'): 151, (119, 'name'): 150, (119, 'number'): 148,
        (119, 'power'): 141, (119, 'str'): 149, (119, 'term'): 122,
        (122, '_38*'): 123, (123, '_(39)'): 126, (126, '_(43)'): 136,
        (126, 'atom'): 145, (126, 'factor'): 128, (126, 'keyid'): 151,
        (126, 'name'): 150, (126, 'number'): 148, (126, 'power'): 141,
        (126, 'str'): 149, (126, 'term'): 127, (128, '_41*'): 129,
        (129, '_(42)'): 134, (134, '_(43)'): 136, (134, 'atom'): 145,
        (134, 'factor'): 135, (134, 'keyid'): 151, (134, 'name'): 150,
        (134, 'number'): 148, (134, 'power'): 141, (134, 'str'): 149,
        (136, '_(43)'): 136, (136, 'atom'): 145, (136, 'factor'): 137,
        (136, 'keyid'): 151, (136, 'name'): 150, (136, 'number'): 148,
        (136, 'power'): 141, (136, 'str'): 149, (142, '_(43)'): 136,
        (142, 'and_expr'): 103, (142, 'and_test'): 77,
        (142, 'arith_expr'): 117, (142, 'atom'): 145, (142, 'comparison'): 87,
        (142, 'expr'): 88, (142, 'factor'): 128, (142, 'func'): 118,
        (142, 'func_expr'): 111, (142, 'keyid'): 151, (142, 'name'): 150,
        (142, 'not_test'): 81, (142, 'number'): 148, (142, 'or_test'): 76,
        (142, 'power'): 141, (142, 'shift_expr'): 107, (142, 'str'): 149,
        (142, 'term'): 122, (142, 'test'): 143, (142, 'xor_expr'): 99,
        (146, '_(43)'): 136, (146, 'atom'): 145, (146, 'factor'): 147,
        (146, 'keyid'): 151, (146, 'name'): 150, (146, 'number'): 148,
        (146, 'power'): 141, (146, 'str'): 149
    }
    _shift = {
        (1, EOF): 160, (3, 'T_BINTYPE'): 158, (5, 'T_INDENT'): 6,
        (7, 'T_DEDENT'): 8, (9, 'T_NAME'): 155, (10, ':'): 11,
        (11, 'T_NEWLINE'): 156, (12, 'T_NEWLINE'): 156, (14, 'T_NEWLINE'): 156,
        (15, 'T_NEWLINE'): 156, (17, 'T_NAME'): 155, (18, '&'): 21,
        (21, 'T_BYTEORDER'): 25, (21, 'T_LET'): 33, (22, 'T_NEWLINE'): 156,
        (25, ':'): 26, (26, 'T_BIGENDIAN'): 29, (26, 'T_LITTLEENDIAN'): 28,
        (30, ':'): 31, (31, 'T_FLOAT'): 74, (31, 'T_NAME'): 49,
        (31, 'T_PADDING'): 50, (31, 'T_SINT16'): 72, (31, 'T_SINT32'): 73,
        (31, 'T_SINT8'): 71, (31, 'T_STRING'): 75, (31, 'T_UINT16'): 69,
        (31, 'T_UINT32'): 70, (31, 'T_UINT8'): 68, (32, 'T_NEWLINE'): 156,
        (33, 'T_NAME'): 155, (34, ':'): 35, (35, 'T_FLOAT'): 74,
        (35, 'T_NAME'): 49, (35, 'T_PADDING'): 50, (35, 'T_SINT16'): 72,
        (35, 'T_SINT32'): 73, (35, 'T_SINT8'): 71, (35, 'T_STRING'): 75,
        (35, 'T_UINT16'): 69, (35, 'T_UINT32'): 70, (35, 'T_UINT8'): 68,
        (36, '='): 37, (37, '$'): 152, (37, '('): 142, (37, '+'): 138,
        (37, '-'): 139, (37, 'T_INT'): 154, (37, 'T_NAME'): 155,
        (37, 'T_NUMBER'): 159, (37, 'T_STR'): 157, (37, '~'): 140,
        (39, 'T_BYTEORDER'): 43, (43, '='): 44, (44, 'T_BIGENDIAN'): 29,
        (44, 'T_LITTLEENDIAN'): 28, (50, 'T_ALIGN'): 51, (51, 'T_NAME'): 155,
        (52, 'T_NUMBER'): 159, (54, '['): 55, (55, '$'): 152, (55, '('): 142,
        (55, '+'): 138, (55, '-'): 139, (55, 'T_INT'): 154,
        (55, 'T_NAME'): 155, (55, 'T_NUMBER'): 159, (55, 'T_STR'): 157,
        (55, '~'): 140, (56, ']'): 57, (57, '&'): 62, (62, 'T_RESTOFDATA'): 67,
        (62, 'T_UNTIL'): 63, (63, '('): 64, (64, '$'): 152, (64, '('): 142,
        (64, '+'): 138, (64, '-'): 139, (64, 'T_INT'): 154,
        (64, 'T_NAME'): 155, (64, 'T_NOT'): 85, (64, 'T_NUMBER'): 159,
        (64, 'T_STR'): 157, (64, '~'): 140, (65, ')'): 66, (78, 'T_OR'): 79,
        (79, '$'): 152, (79, '('): 142, (79, '+'): 138, (79, '-'): 139,
        (79, 'T_INT'): 154, (79, 'T_NAME'): 155, (79, 'T_NOT'): 85,
        (79, 'T_NUMBER'): 159, (79, 'T_STR'): 157, (79, '~'): 140,
        (82, 'T_AND'): 83, (83, '$'): 152, (83, '('): 142, (83, '+'): 138,
        (83, '-'): 139, (83, 'T_INT'): 154, (83, 'T_NAME'): 155,
        (83, 'T_NOT'): 85, (83, 'T_NUMBER'): 159, (83, 'T_STR'): 157,
        (83, '~'): 140, (85, '$'): 152, (85, '('): 142, (85, '+'): 138,
        (85, '-'): 139, (85, 'T_INT'): 154, (85, 'T_NAME'): 155,
        (85, 'T_NOT'): 85, (85, 'T_NUMBER'): 159, (85, 'T_STR'): 157,
        (85, '~'): 140, (89, '!='): 98, (89, '<'): 92, (89, '<='): 96,
        (89, '<>'): 97, (89, '=='): 94, (89, '>'): 93, (89, '>='): 95,
        (90, '$'): 152, (90, '('): 142, (90, '+'): 138, (90, '-'): 139,
        (90, 'T_INT'): 154, (90, 'T_NAME'): 155, (90, 'T_NUMBER'): 159,
        (90, 'T_STR'): 157, (90, '~'): 140, (100, '|'): 101, (101, '$'): 152,
        (101, '('): 142, (101, '+'): 138, (101, '-'): 139, (101, 'T_INT'): 154,
        (101, 'T_NAME'): 155, (101, 'T_NUMBER'): 159, (101, 'T_STR'): 157,
        (101, '~'): 140, (104, '^'): 105, (105, '$'): 152, (105, '('): 142,
        (105, '+'): 138, (105, '-'): 139, (105, 'T_INT'): 154,
        (105, 'T_NAME'): 155, (105, 'T_NUMBER'): 159, (105, 'T_STR'): 157,
        (105, '~'): 140, (108, '&'): 109, (109, '$'): 152, (109, '('): 142,
        (109, '+'): 138, (109, '-'): 139, (109, 'T_INT'): 154,
        (109, 'T_NAME'): 155, (109, 'T_NUMBER'): 159, (109, 'T_STR'): 157,
        (109, '~'): 140, (112, '<<'): 113, (112, '>>'): 114, (115, '$'): 152,
        (115, '('): 142, (115, '+'): 138, (115, '-'): 139, (115, 'T_INT'): 154,
        (115, 'T_NAME'): 155, (115, 'T_NUMBER'): 159, (115, 'T_STR'): 157,
        (115, '~'): 140, (118, '('): 119, (119, '$'): 152, (119, '('): 142,
        (119, '+'): 138, (119, '-'): 139, (119, 'T_NAME'): 155,
        (119, 'T_NUMBER'): 159, (119, 'T_STR'): 157, (119, '~'): 140,
        (120, ')'): 121, (123, '+'): 124, (123, '-'): 125, (126, '$'): 152,
        (126, '('): 142, (126, '+'): 138, (126, '-'): 139,
        (126, 'T_NAME'): 155, (126, 'T_NUMBER'): 159, (126, 'T_STR'): 157,
        (126, '~'): 140, (129, '%'): 132, (129, '*'): 130, (129, '/'): 131,
        (129, '//'): 133, (134, '$'): 152, (134, '('): 142, (134, '+'): 138,
        (134, '-'): 139, (134, 'T_NAME'): 155, (134, 'T_NUMBER'): 159,
        (134, 'T_STR'): 157, (134, '~'): 140, (136, '$'): 152, (136, '('): 142,
        (136, '+'): 138, (136, '-'): 139, (136, 'T_NAME'): 155,
        (136, 'T_NUMBER'): 159, (136, 'T_STR'): 157, (136, '~'): 140,
        (142, '$'): 152, (142, '('): 142, (142, '+'): 138, (142, '-'): 139,
        (142, 'T_INT'): 154, (142, 'T_NAME'): 155, (142, 'T_NOT'): 85,
        (142, 'T_NUMBER'): 159, (142, 'T_STR'): 157, (142, '~'): 140,
        (143, ')'): 144, (145, '**'): 146, (146, '$'): 152, (146, '('): 142,
        (146, '+'): 138, (146, '-'): 139, (146, 'T_NAME'): 155,
        (146, 'T_NUMBER'): 159, (146, 'T_STR'): 157, (146, '~'): 140,
        (152, 'T_INPUT'): 153
    }

    def __init__(self, max_err=None, errcorr_pre=4, errcorr_post=4):
        """Create a new parser instance.

        The constructor arguments are all optional, they control the
        handling of parse errors: `max_err` can be given to bound the
        number of errors reported during one run of the parser.
        `errcorr_pre` controls how many tokens before an invalid token
        the parser considers when trying to repair the input.
        `errcorr_post` controls how far beyond an invalid token the
        parser reads when evaluating the quality of an attempted
        repair.
        """
        self.max_err = max_err
        self.m = errcorr_pre
        self.n = errcorr_post

    @staticmethod
    def leaves(tree):
        """Iterate over the leaves of a parse tree.

        This function can be used to reconstruct the input from a
        parse tree.
        """
        if tree[0] in Parser.terminals:
            yield tree
        else:
            for x in tree[1:]:
                for t in Parser.leaves(x):
                    yield t

    def _parse(self, input, stack, state):
        """Internal function to construct a parse tree.

        'Input' is the input token stream, 'stack' is the inital stack
        and 'state' is the inital state of the automaton.

        Returns a 4-tuple (done, count, state, error).  'done' is a
        boolean indicationg whether parsing is completed, 'count' is
        number of successfully shifted tokens, and 'error' is None on
        success or else the first token which could not be parsed.
        """
        read_next = True
        count = 0
        while state != self._halting_state:
            if read_next:
                try:
                    lookahead = input.next()
                except StopIteration:
                    return (False,count,state,None)
                read_next = False
            token = lookahead[0]

            if (state,token) in self._shift:
                stack.append((state,lookahead))
                state = self._shift[(state,token)]
                read_next = True
                count += 1
            elif (state,token) in self._reduce:
                X,n = self._reduce[(state,token)]
                if n > 0:
                    state = stack[-n][0]
                    tree = [ X ]
                    for s in stack[-n:]:
                        if s[1][0] in self._transparent:
                            tree.extend(s[1][1:])
                        else:
                            tree.append(s[1])
                    tree = tuple(tree)
                    del stack[-n:]
                else:
                    tree = (X,)
                stack.append((state,tree))
                state = self._goto[(state,X)]
            else:
                return (False,count,state,lookahead)
        return (True,count,state,None)

    def _try_parse(self, input, stack, state):
        count = 0
        while state != self._halting_state and count < len(input):
            token = input[count][0]

            if (state,token) in self._shift:
                stack.append(state)
                state = self._shift[(state,token)]
                count += 1
            elif (state,token) in self._reduce:
                X,n = self._reduce[(state,token)]
                if n > 0:
                    state = stack[-n]
                    del stack[-n:]
                stack.append(state)
                state = self._goto[(state,X)]
            else:
                break
        return count

    def parse(self, input):
        """Parse the tokens from `input` and construct a parse tree.

        `input` must be an interable over tuples.  The first element
        of each tuple must be a terminal symbol of the grammar which
        is used for parsing.  All other element of the tuple are just
        copied into the constructed parse tree.

        If `input` is invalid, a ParseErrors exception is raised.
        Otherwise the function returns the parse tree.
        """
        errors = []
        input = chain(input, [(self.EOF,)])
        stack = []
        state = 0
        while True:
            done,_,state,lookahead = self._parse(input, stack, state)
            if done:
                break

            expect = [ t for s,t in self._reduce.keys()+self._shift.keys()
                       if s == state ]
            errors.append((lookahead, expect))
            if self.max_err is not None and len(errors) >= self.max_err:
                raise self.ParseErrors(errors, None)

            queue = []
            def split_input(m, stack, lookahead, input, queue):
                for s in stack:
                    for t in self.leaves(s[1]):
                        queue.append(t)
                        if len(queue) > m:
                            yield queue.pop(0)
                queue.append(lookahead)
            in2 = split_input(self.m, stack, lookahead, input, queue)
            stack = []
            done,_,state,lookahead = self._parse(in2, stack, 0)
            m = len(queue)
            for i in range(0, self.n):
                try:
                    queue.append(input.next())
                except StopIteration:
                    break

            def vary_queue(queue, m):
                for i in range(m-1, -1, -1):
                    for t in self.terminals:
                        yield queue[:i]+[(t,)]+queue[i:]
                    if queue[i][0] == self.EOF:
                        continue
                    for t in self.terminals:
                        if t == queue[i]:
                            continue
                        yield queue[:i]+[(t,)]+queue[i+1:]
                    yield queue[:i]+queue[i+1:]
            best_val = len(queue)-m+1
            best_queue = queue
            for q2 in vary_queue(queue, m):
                pos = self._try_parse(q2, [ s[0] for s in stack ], state)
                val = len(q2) - pos
                if val < best_val:
                    best_val = val
                    best_queue = q2
                    if val == len(q2):
                        break
            if best_val >= len(queue)-m+1:
                raise self.ParseErrors(errors, None)
            input = chain(best_queue, input)

        tree = stack[0][1]
        if errors:
            raise self.ParseErrors(errors, tree)
        return tree
