# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class AccountEncryption(msrest.serialization.Model):
    """Encryption settings.

    :param key_source: Encryption Key Source. Possible values are: 'Microsoft.NetApp'.
    :type key_source: str
    """

    _attribute_map = {
        'key_source': {'key': 'keySource', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccountEncryption, self).__init__(**kwargs)
        self.key_source = kwargs.get('key_source', None)


class ActiveDirectory(msrest.serialization.Model):
    """Active Directory.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param active_directory_id: Id of the Active Directory.
    :type active_directory_id: str
    :param username: Username of Active Directory domain administrator.
    :type username: str
    :param password: Plain text password of Active Directory domain administrator, value is masked
     in the response.
    :type password: str
    :param domain: Name of the Active Directory domain.
    :type domain: str
    :param dns: Comma separated list of DNS server IP addresses (IPv4 only) for the Active
     Directory domain.
    :type dns: str
    :ivar status: Status of the Active Directory. Possible values include: "Created", "InUse",
     "Deleted", "Error", "Updating".
    :vartype status: str or ~azure.mgmt.netapp.models.ActiveDirectoryStatus
    :ivar status_details: Any details in regards to the Status of the Active Directory.
    :vartype status_details: str
    :param smb_server_name: NetBIOS name of the SMB server. This name will be registered as a
     computer account in the AD and used to mount volumes.
    :type smb_server_name: str
    :param organizational_unit: The Organizational Unit (OU) within the Windows Active Directory.
    :type organizational_unit: str
    :param site: The Active Directory site the service will limit Domain Controller discovery to.
    :type site: str
    :param backup_operators: Users to be added to the Built-in Backup Operator active directory
     group. A list of unique usernames without domain specifier.
    :type backup_operators: list[str]
    :param kdc_ip: kdc server IP addresses for the active directory machine. This optional
     parameter is used only while creating kerberos volume.
    :type kdc_ip: str
    :param ad_name: Name of the active directory machine. This optional parameter is used only
     while creating kerberos volume.
    :type ad_name: str
    :param server_root_ca_certificate: When LDAP over SSL/TLS is enabled, the LDAP client is
     required to have base64 encoded Active Directory Certificate Service's self-signed root CA
     certificate, this optional parameter is used only for dual protocol with LDAP user-mapping
     volumes.
    :type server_root_ca_certificate: str
    :param aes_encryption: If enabled, AES encryption will be enabled for SMB communication.
    :type aes_encryption: bool
    :param ldap_signing: Specifies whether or not the LDAP traffic needs to be signed.
    :type ldap_signing: bool
    :param security_operators: Domain Users in the Active directory to be given SeSecurityPrivilege
     privilege (Needed for SMB Continuously available shares for SQL). A list of unique usernames
     without domain specifier.
    :type security_operators: list[str]
    :param ldap_over_tls: Specifies whether or not the LDAP traffic needs to be secured via TLS.
    :type ldap_over_tls: bool
    :param allow_local_nfs_users_with_ldap: If enabled, NFS client local users can also (in
     addition to LDAP users) access the NFS volumes.
    :type allow_local_nfs_users_with_ldap: bool
    """

    _validation = {
        'dns': {'pattern': r'^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)((, ?)(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))*$'},
        'status': {'readonly': True},
        'status_details': {'readonly': True},
        'kdc_ip': {'pattern': r'^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)((, ?)(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))*$'},
        'ad_name': {'max_length': 64, 'min_length': 1},
        'server_root_ca_certificate': {'max_length': 10240, 'min_length': 1},
    }

    _attribute_map = {
        'active_directory_id': {'key': 'activeDirectoryId', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'domain': {'key': 'domain', 'type': 'str'},
        'dns': {'key': 'dns', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'status_details': {'key': 'statusDetails', 'type': 'str'},
        'smb_server_name': {'key': 'smbServerName', 'type': 'str'},
        'organizational_unit': {'key': 'organizationalUnit', 'type': 'str'},
        'site': {'key': 'site', 'type': 'str'},
        'backup_operators': {'key': 'backupOperators', 'type': '[str]'},
        'kdc_ip': {'key': 'kdcIP', 'type': 'str'},
        'ad_name': {'key': 'adName', 'type': 'str'},
        'server_root_ca_certificate': {'key': 'serverRootCACertificate', 'type': 'str'},
        'aes_encryption': {'key': 'aesEncryption', 'type': 'bool'},
        'ldap_signing': {'key': 'ldapSigning', 'type': 'bool'},
        'security_operators': {'key': 'securityOperators', 'type': '[str]'},
        'ldap_over_tls': {'key': 'ldapOverTLS', 'type': 'bool'},
        'allow_local_nfs_users_with_ldap': {'key': 'allowLocalNfsUsersWithLdap', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ActiveDirectory, self).__init__(**kwargs)
        self.active_directory_id = kwargs.get('active_directory_id', None)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.domain = kwargs.get('domain', None)
        self.dns = kwargs.get('dns', None)
        self.status = None
        self.status_details = None
        self.smb_server_name = kwargs.get('smb_server_name', None)
        self.organizational_unit = kwargs.get('organizational_unit', "CN=Computers")
        self.site = kwargs.get('site', None)
        self.backup_operators = kwargs.get('backup_operators', None)
        self.kdc_ip = kwargs.get('kdc_ip', None)
        self.ad_name = kwargs.get('ad_name', None)
        self.server_root_ca_certificate = kwargs.get('server_root_ca_certificate', None)
        self.aes_encryption = kwargs.get('aes_encryption', None)
        self.ldap_signing = kwargs.get('ldap_signing', None)
        self.security_operators = kwargs.get('security_operators', None)
        self.ldap_over_tls = kwargs.get('ldap_over_tls', None)
        self.allow_local_nfs_users_with_ldap = kwargs.get('allow_local_nfs_users_with_ldap', None)


class AuthorizeRequest(msrest.serialization.Model):
    """Authorize request.

    :param remote_volume_resource_id: Resource id of the remote volume.
    :type remote_volume_resource_id: str
    """

    _attribute_map = {
        'remote_volume_resource_id': {'key': 'remoteVolumeResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthorizeRequest, self).__init__(**kwargs)
        self.remote_volume_resource_id = kwargs.get('remote_volume_resource_id', None)


class Backup(msrest.serialization.Model):
    """Backup of a Volume.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Resource location.
    :type location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar backup_id: UUID v4 used to identify the Backup.
    :vartype backup_id: str
    :ivar creation_date: The creation date of the backup.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar size: Size of backup.
    :vartype size: long
    :param label: Label for backup.
    :type label: str
    :ivar backup_type: Type of backup Manual or Scheduled. Possible values include: "Manual",
     "Scheduled".
    :vartype backup_type: str or ~azure.mgmt.netapp.models.BackupType
    :ivar failure_reason: Failure reason.
    :vartype failure_reason: str
    :ivar volume_name: Volume name.
    :vartype volume_name: str
    :param use_existing_snapshot: Manual backup an already existing snapshot. This will always be
     false for scheduled backups and true/false for manual backups.
    :type use_existing_snapshot: bool
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'backup_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'size': {'readonly': True},
        'backup_type': {'readonly': True},
        'failure_reason': {'readonly': True},
        'volume_name': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'backup_id': {'key': 'properties.backupId', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'long'},
        'label': {'key': 'properties.label', 'type': 'str'},
        'backup_type': {'key': 'properties.backupType', 'type': 'str'},
        'failure_reason': {'key': 'properties.failureReason', 'type': 'str'},
        'volume_name': {'key': 'properties.volumeName', 'type': 'str'},
        'use_existing_snapshot': {'key': 'properties.useExistingSnapshot', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Backup, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.id = None
        self.name = None
        self.type = None
        self.backup_id = None
        self.creation_date = None
        self.provisioning_state = None
        self.size = None
        self.label = kwargs.get('label', None)
        self.backup_type = None
        self.failure_reason = None
        self.volume_name = None
        self.use_existing_snapshot = kwargs.get('use_existing_snapshot', False)


class BackupPatch(msrest.serialization.Model):
    """Backup patch.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar backup_id: UUID v4 used to identify the Backup.
    :vartype backup_id: str
    :ivar creation_date: The creation date of the backup.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar size: Size of backup.
    :vartype size: long
    :param label: Label for backup.
    :type label: str
    :ivar backup_type: Type of backup Manual or Scheduled. Possible values include: "Manual",
     "Scheduled".
    :vartype backup_type: str or ~azure.mgmt.netapp.models.BackupType
    :ivar failure_reason: Failure reason.
    :vartype failure_reason: str
    :ivar volume_name: Volume name.
    :vartype volume_name: str
    :param use_existing_snapshot: Manual backup an already existing snapshot. This will always be
     false for scheduled backups and true/false for manual backups.
    :type use_existing_snapshot: bool
    """

    _validation = {
        'backup_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'size': {'readonly': True},
        'backup_type': {'readonly': True},
        'failure_reason': {'readonly': True},
        'volume_name': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'backup_id': {'key': 'properties.backupId', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'long'},
        'label': {'key': 'properties.label', 'type': 'str'},
        'backup_type': {'key': 'properties.backupType', 'type': 'str'},
        'failure_reason': {'key': 'properties.failureReason', 'type': 'str'},
        'volume_name': {'key': 'properties.volumeName', 'type': 'str'},
        'use_existing_snapshot': {'key': 'properties.useExistingSnapshot', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupPatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.backup_id = None
        self.creation_date = None
        self.provisioning_state = None
        self.size = None
        self.label = kwargs.get('label', None)
        self.backup_type = None
        self.failure_reason = None
        self.volume_name = None
        self.use_existing_snapshot = kwargs.get('use_existing_snapshot', False)


class BackupPoliciesList(msrest.serialization.Model):
    """List of Backup Policies.

    :param value: A list of backup policies.
    :type value: list[~azure.mgmt.netapp.models.BackupPolicy]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BackupPolicy]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupPoliciesList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class BackupPolicy(msrest.serialization.Model):
    """Backup policy information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Resource location.
    :type location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar name_properties_name: Name of backup policy.
    :vartype name_properties_name: str
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :param daily_backups_to_keep: Daily backups count to keep.
    :type daily_backups_to_keep: int
    :param weekly_backups_to_keep: Weekly backups count to keep.
    :type weekly_backups_to_keep: int
    :param monthly_backups_to_keep: Monthly backups count to keep.
    :type monthly_backups_to_keep: int
    :param yearly_backups_to_keep: Yearly backups count to keep.
    :type yearly_backups_to_keep: int
    :param volumes_assigned: Volumes using current backup policy.
    :type volumes_assigned: int
    :param enabled: The property to decide policy is enabled or not.
    :type enabled: bool
    :param volume_backups: A list of volumes assigned to this policy.
    :type volume_backups: list[~azure.mgmt.netapp.models.VolumeBackups]
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'daily_backups_to_keep': {'key': 'properties.dailyBackupsToKeep', 'type': 'int'},
        'weekly_backups_to_keep': {'key': 'properties.weeklyBackupsToKeep', 'type': 'int'},
        'monthly_backups_to_keep': {'key': 'properties.monthlyBackupsToKeep', 'type': 'int'},
        'yearly_backups_to_keep': {'key': 'properties.yearlyBackupsToKeep', 'type': 'int'},
        'volumes_assigned': {'key': 'properties.volumesAssigned', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'volume_backups': {'key': 'properties.volumeBackups', 'type': '[VolumeBackups]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupPolicy, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.id = None
        self.name = None
        self.type = None
        self.tags = kwargs.get('tags', None)
        self.name_properties_name = None
        self.provisioning_state = None
        self.daily_backups_to_keep = kwargs.get('daily_backups_to_keep', None)
        self.weekly_backups_to_keep = kwargs.get('weekly_backups_to_keep', None)
        self.monthly_backups_to_keep = kwargs.get('monthly_backups_to_keep', None)
        self.yearly_backups_to_keep = kwargs.get('yearly_backups_to_keep', None)
        self.volumes_assigned = kwargs.get('volumes_assigned', None)
        self.enabled = kwargs.get('enabled', None)
        self.volume_backups = kwargs.get('volume_backups', None)


class BackupPolicyDetails(msrest.serialization.Model):
    """Backup policy properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param location: Resource location.
    :type location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar name_properties_name: Name of backup policy.
    :vartype name_properties_name: str
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :param daily_backups_to_keep: Daily backups count to keep.
    :type daily_backups_to_keep: int
    :param weekly_backups_to_keep: Weekly backups count to keep.
    :type weekly_backups_to_keep: int
    :param monthly_backups_to_keep: Monthly backups count to keep.
    :type monthly_backups_to_keep: int
    :param yearly_backups_to_keep: Yearly backups count to keep.
    :type yearly_backups_to_keep: int
    :param volumes_assigned: Volumes using current backup policy.
    :type volumes_assigned: int
    :param enabled: The property to decide policy is enabled or not.
    :type enabled: bool
    :param volume_backups: A list of volumes assigned to this policy.
    :type volume_backups: list[~azure.mgmt.netapp.models.VolumeBackups]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'daily_backups_to_keep': {'key': 'properties.dailyBackupsToKeep', 'type': 'int'},
        'weekly_backups_to_keep': {'key': 'properties.weeklyBackupsToKeep', 'type': 'int'},
        'monthly_backups_to_keep': {'key': 'properties.monthlyBackupsToKeep', 'type': 'int'},
        'yearly_backups_to_keep': {'key': 'properties.yearlyBackupsToKeep', 'type': 'int'},
        'volumes_assigned': {'key': 'properties.volumesAssigned', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'volume_backups': {'key': 'properties.volumeBackups', 'type': '[VolumeBackups]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupPolicyDetails, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.id = None
        self.name = None
        self.type = None
        self.tags = kwargs.get('tags', None)
        self.name_properties_name = None
        self.provisioning_state = None
        self.daily_backups_to_keep = kwargs.get('daily_backups_to_keep', None)
        self.weekly_backups_to_keep = kwargs.get('weekly_backups_to_keep', None)
        self.monthly_backups_to_keep = kwargs.get('monthly_backups_to_keep', None)
        self.yearly_backups_to_keep = kwargs.get('yearly_backups_to_keep', None)
        self.volumes_assigned = kwargs.get('volumes_assigned', None)
        self.enabled = kwargs.get('enabled', None)
        self.volume_backups = kwargs.get('volume_backups', None)


class BackupPolicyPatch(msrest.serialization.Model):
    """Backup policy Details for create and update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param location: Resource location.
    :type location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar name_properties_name: Name of backup policy.
    :vartype name_properties_name: str
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :param daily_backups_to_keep: Daily backups count to keep.
    :type daily_backups_to_keep: int
    :param weekly_backups_to_keep: Weekly backups count to keep.
    :type weekly_backups_to_keep: int
    :param monthly_backups_to_keep: Monthly backups count to keep.
    :type monthly_backups_to_keep: int
    :param yearly_backups_to_keep: Yearly backups count to keep.
    :type yearly_backups_to_keep: int
    :param volumes_assigned: Volumes using current backup policy.
    :type volumes_assigned: int
    :param enabled: The property to decide policy is enabled or not.
    :type enabled: bool
    :param volume_backups: A list of volumes assigned to this policy.
    :type volume_backups: list[~azure.mgmt.netapp.models.VolumeBackups]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'daily_backups_to_keep': {'key': 'properties.dailyBackupsToKeep', 'type': 'int'},
        'weekly_backups_to_keep': {'key': 'properties.weeklyBackupsToKeep', 'type': 'int'},
        'monthly_backups_to_keep': {'key': 'properties.monthlyBackupsToKeep', 'type': 'int'},
        'yearly_backups_to_keep': {'key': 'properties.yearlyBackupsToKeep', 'type': 'int'},
        'volumes_assigned': {'key': 'properties.volumesAssigned', 'type': 'int'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'volume_backups': {'key': 'properties.volumeBackups', 'type': '[VolumeBackups]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupPolicyPatch, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.id = None
        self.name = None
        self.type = None
        self.tags = kwargs.get('tags', None)
        self.name_properties_name = None
        self.provisioning_state = None
        self.daily_backups_to_keep = kwargs.get('daily_backups_to_keep', None)
        self.weekly_backups_to_keep = kwargs.get('weekly_backups_to_keep', None)
        self.monthly_backups_to_keep = kwargs.get('monthly_backups_to_keep', None)
        self.yearly_backups_to_keep = kwargs.get('yearly_backups_to_keep', None)
        self.volumes_assigned = kwargs.get('volumes_assigned', None)
        self.enabled = kwargs.get('enabled', None)
        self.volume_backups = kwargs.get('volume_backups', None)


class BackupsList(msrest.serialization.Model):
    """List of Backups.

    :param value: A list of Backups.
    :type value: list[~azure.mgmt.netapp.models.Backup]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Backup]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupsList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class BackupStatus(msrest.serialization.Model):
    """Backup status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar healthy: Backup health status.
    :vartype healthy: bool
    :ivar relationship_status: Status of the backup mirror relationship. Possible values include:
     "Idle", "Transferring".
    :vartype relationship_status: str or ~azure.mgmt.netapp.models.RelationshipStatus
    :ivar mirror_state: The status of the backup. Possible values include: "Uninitialized",
     "Mirrored", "Broken".
    :vartype mirror_state: str or ~azure.mgmt.netapp.models.MirrorState
    :ivar unhealthy_reason: Reason for the unhealthy backup relationship.
    :vartype unhealthy_reason: str
    :ivar error_message: Displays error message if the backup is in an error state.
    :vartype error_message: str
    """

    _validation = {
        'healthy': {'readonly': True},
        'relationship_status': {'readonly': True},
        'mirror_state': {'readonly': True},
        'unhealthy_reason': {'readonly': True},
        'error_message': {'readonly': True},
    }

    _attribute_map = {
        'healthy': {'key': 'healthy', 'type': 'bool'},
        'relationship_status': {'key': 'relationshipStatus', 'type': 'str'},
        'mirror_state': {'key': 'mirrorState', 'type': 'str'},
        'unhealthy_reason': {'key': 'unhealthyReason', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupStatus, self).__init__(**kwargs)
        self.healthy = None
        self.relationship_status = None
        self.mirror_state = None
        self.unhealthy_reason = None
        self.error_message = None


class BreakReplicationRequest(msrest.serialization.Model):
    """Break replication request.

    :param force_break_replication: If replication is in status transferring and you want to force
     break the replication, set to true.
    :type force_break_replication: bool
    """

    _attribute_map = {
        'force_break_replication': {'key': 'forceBreakReplication', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BreakReplicationRequest, self).__init__(**kwargs)
        self.force_break_replication = kwargs.get('force_break_replication', None)


class CapacityPool(msrest.serialization.Model):
    """Capacity pool resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Resource location.
    :type location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar pool_id: UUID v4 used to identify the Pool.
    :vartype pool_id: str
    :param size: Required. Provisioned size of the pool (in bytes). Allowed values are in 4TiB
     chunks (value must be multiply of 4398046511104).
    :type size: long
    :param service_level: Required. The service level of the file system. Possible values include:
     "Standard", "Premium", "Ultra".
    :type service_level: str or ~azure.mgmt.netapp.models.ServiceLevel
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :ivar total_throughput_mibps: Total throughput of pool in Mibps.
    :vartype total_throughput_mibps: float
    :ivar utilized_throughput_mibps: Utilized throughput of pool in Mibps.
    :vartype utilized_throughput_mibps: float
    :param qos_type: The qos type of the pool. Possible values include: "Auto", "Manual".
    :type qos_type: str or ~azure.mgmt.netapp.models.QosType
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'pool_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'size': {'required': True, 'maximum': 549755813888000, 'minimum': 4398046511104},
        'service_level': {'required': True},
        'provisioning_state': {'readonly': True},
        'total_throughput_mibps': {'readonly': True},
        'utilized_throughput_mibps': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'pool_id': {'key': 'properties.poolId', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'long'},
        'service_level': {'key': 'properties.serviceLevel', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'total_throughput_mibps': {'key': 'properties.totalThroughputMibps', 'type': 'float'},
        'utilized_throughput_mibps': {'key': 'properties.utilizedThroughputMibps', 'type': 'float'},
        'qos_type': {'key': 'properties.qosType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CapacityPool, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.id = None
        self.name = None
        self.type = None
        self.tags = kwargs.get('tags', None)
        self.pool_id = None
        self.size = kwargs['size']
        self.service_level = kwargs['service_level']
        self.provisioning_state = None
        self.total_throughput_mibps = None
        self.utilized_throughput_mibps = None
        self.qos_type = kwargs.get('qos_type', None)


class CapacityPoolList(msrest.serialization.Model):
    """List of capacity pool resources.

    :param value: List of Capacity pools.
    :type value: list[~azure.mgmt.netapp.models.CapacityPool]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CapacityPool]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CapacityPoolList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class CapacityPoolPatch(msrest.serialization.Model):
    """Capacity pool patch resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param location: Resource location.
    :type location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param size: Provisioned size of the pool (in bytes). Allowed values are in 4TiB chunks (value
     must be multiply of 4398046511104).
    :type size: long
    :param qos_type: The qos type of the pool. Possible values include: "Auto", "Manual".
    :type qos_type: str or ~azure.mgmt.netapp.models.QosType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'size': {'maximum': 549755813888000, 'minimum': 4398046511104},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'size': {'key': 'properties.size', 'type': 'long'},
        'qos_type': {'key': 'properties.qosType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CapacityPoolPatch, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.id = None
        self.name = None
        self.type = None
        self.tags = kwargs.get('tags', None)
        self.size = kwargs.get('size', 4398046511104)
        self.qos_type = kwargs.get('qos_type', None)


class CheckAvailabilityResponse(msrest.serialization.Model):
    """Information regarding availability of a resource.

    :param is_available: :code:`<code>true</code>` indicates name is valid and available.
     :code:`<code>false</code>` indicates the name is invalid, unavailable, or both.
    :type is_available: bool
    :param reason: :code:`<code>Invalid</code>` indicates the name provided does not match Azure
     App Service naming requirements. :code:`<code>AlreadyExists</code>` indicates that the name is
     already in use and is therefore unavailable. Possible values include: "Invalid",
     "AlreadyExists".
    :type reason: str or ~azure.mgmt.netapp.models.InAvailabilityReasonType
    :param message: If reason == invalid, provide the user with the reason why the given name is
     invalid, and provide the resource naming requirements so that the user can select a valid name.
     If reason == AlreadyExists, explain that resource name is already in use, and direct them to
     select a different name.
    :type message: str
    """

    _attribute_map = {
        'is_available': {'key': 'isAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckAvailabilityResponse, self).__init__(**kwargs)
        self.is_available = kwargs.get('is_available', None)
        self.reason = kwargs.get('reason', None)
        self.message = kwargs.get('message', None)


class CloudErrorBody(msrest.serialization.Model):
    """An error response from the service.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class DailySchedule(msrest.serialization.Model):
    """Daily Schedule properties.

    :param snapshots_to_keep: Daily snapshot count to keep.
    :type snapshots_to_keep: int
    :param hour: Indicates which hour in UTC timezone a snapshot should be taken.
    :type hour: int
    :param minute: Indicates which minute snapshot should be taken.
    :type minute: int
    :param used_bytes: Resource size in bytes, current storage usage for the volume in bytes.
    :type used_bytes: long
    """

    _attribute_map = {
        'snapshots_to_keep': {'key': 'snapshotsToKeep', 'type': 'int'},
        'hour': {'key': 'hour', 'type': 'int'},
        'minute': {'key': 'minute', 'type': 'int'},
        'used_bytes': {'key': 'usedBytes', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DailySchedule, self).__init__(**kwargs)
        self.snapshots_to_keep = kwargs.get('snapshots_to_keep', None)
        self.hour = kwargs.get('hour', None)
        self.minute = kwargs.get('minute', None)
        self.used_bytes = kwargs.get('used_bytes', None)


class Dimension(msrest.serialization.Model):
    """Dimension of blobs, possibly be blob type or access tier.

    :param name: Display name of dimension.
    :type name: str
    :param display_name: Display name of dimension.
    :type display_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Dimension, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)


class ExportPolicyRule(msrest.serialization.Model):
    """Volume Export Policy Rule.

    :param rule_index: Order index.
    :type rule_index: int
    :param unix_read_only: Read only access.
    :type unix_read_only: bool
    :param unix_read_write: Read and write access.
    :type unix_read_write: bool
    :param kerberos5_read_only: Kerberos5 Read only access. To be use with swagger version
     2020-05-01 or later.
    :type kerberos5_read_only: bool
    :param kerberos5_read_write: Kerberos5 Read and write access. To be use with swagger version
     2020-05-01 or later.
    :type kerberos5_read_write: bool
    :param kerberos5_i_read_only: Kerberos5i Read only access. To be use with swagger version
     2020-05-01 or later.
    :type kerberos5_i_read_only: bool
    :param kerberos5_i_read_write: Kerberos5i Read and write access. To be use with swagger version
     2020-05-01 or later.
    :type kerberos5_i_read_write: bool
    :param kerberos5_p_read_only: Kerberos5p Read only access. To be use with swagger version
     2020-05-01 or later.
    :type kerberos5_p_read_only: bool
    :param kerberos5_p_read_write: Kerberos5p Read and write access. To be use with swagger version
     2020-05-01 or later.
    :type kerberos5_p_read_write: bool
    :param cifs: Allows CIFS protocol.
    :type cifs: bool
    :param nfsv3: Allows NFSv3 protocol. Enable only for NFSv3 type volumes.
    :type nfsv3: bool
    :param nfsv41: Allows NFSv4.1 protocol. Enable only for NFSv4.1 type volumes.
    :type nfsv41: bool
    :param allowed_clients: Client ingress specification as comma separated string with IPv4 CIDRs,
     IPv4 host addresses and host names.
    :type allowed_clients: str
    :param has_root_access: Has root access to volume.
    :type has_root_access: bool
    """

    _attribute_map = {
        'rule_index': {'key': 'ruleIndex', 'type': 'int'},
        'unix_read_only': {'key': 'unixReadOnly', 'type': 'bool'},
        'unix_read_write': {'key': 'unixReadWrite', 'type': 'bool'},
        'kerberos5_read_only': {'key': 'kerberos5ReadOnly', 'type': 'bool'},
        'kerberos5_read_write': {'key': 'kerberos5ReadWrite', 'type': 'bool'},
        'kerberos5_i_read_only': {'key': 'kerberos5iReadOnly', 'type': 'bool'},
        'kerberos5_i_read_write': {'key': 'kerberos5iReadWrite', 'type': 'bool'},
        'kerberos5_p_read_only': {'key': 'kerberos5pReadOnly', 'type': 'bool'},
        'kerberos5_p_read_write': {'key': 'kerberos5pReadWrite', 'type': 'bool'},
        'cifs': {'key': 'cifs', 'type': 'bool'},
        'nfsv3': {'key': 'nfsv3', 'type': 'bool'},
        'nfsv41': {'key': 'nfsv41', 'type': 'bool'},
        'allowed_clients': {'key': 'allowedClients', 'type': 'str'},
        'has_root_access': {'key': 'hasRootAccess', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExportPolicyRule, self).__init__(**kwargs)
        self.rule_index = kwargs.get('rule_index', None)
        self.unix_read_only = kwargs.get('unix_read_only', None)
        self.unix_read_write = kwargs.get('unix_read_write', None)
        self.kerberos5_read_only = kwargs.get('kerberos5_read_only', False)
        self.kerberos5_read_write = kwargs.get('kerberos5_read_write', False)
        self.kerberos5_i_read_only = kwargs.get('kerberos5_i_read_only', False)
        self.kerberos5_i_read_write = kwargs.get('kerberos5_i_read_write', False)
        self.kerberos5_p_read_only = kwargs.get('kerberos5_p_read_only', False)
        self.kerberos5_p_read_write = kwargs.get('kerberos5_p_read_write', False)
        self.cifs = kwargs.get('cifs', None)
        self.nfsv3 = kwargs.get('nfsv3', None)
        self.nfsv41 = kwargs.get('nfsv41', None)
        self.allowed_clients = kwargs.get('allowed_clients', None)
        self.has_root_access = kwargs.get('has_root_access', True)


class HourlySchedule(msrest.serialization.Model):
    """Hourly Schedule properties.

    :param snapshots_to_keep: Hourly snapshot count to keep.
    :type snapshots_to_keep: int
    :param minute: Indicates which minute snapshot should be taken.
    :type minute: int
    :param used_bytes: Resource size in bytes, current storage usage for the volume in bytes.
    :type used_bytes: long
    """

    _attribute_map = {
        'snapshots_to_keep': {'key': 'snapshotsToKeep', 'type': 'int'},
        'minute': {'key': 'minute', 'type': 'int'},
        'used_bytes': {'key': 'usedBytes', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HourlySchedule, self).__init__(**kwargs)
        self.snapshots_to_keep = kwargs.get('snapshots_to_keep', None)
        self.minute = kwargs.get('minute', None)
        self.used_bytes = kwargs.get('used_bytes', None)


class MetricSpecification(msrest.serialization.Model):
    """Metric specification of operation.

    :param name: Name of metric specification.
    :type name: str
    :param display_name: Display name of metric specification.
    :type display_name: str
    :param display_description: Display description of metric specification.
    :type display_description: str
    :param unit: Unit could be Bytes or Count.
    :type unit: str
    :param dimensions: Dimensions of blobs, including blob type and access tier.
    :type dimensions: list[~azure.mgmt.netapp.models.Dimension]
    :param aggregation_type: Aggregation type could be Average.
    :type aggregation_type: str
    :param fill_gap_with_zero: The property to decide fill gap with zero or not.
    :type fill_gap_with_zero: bool
    :param category: The category this metric specification belong to, could be Capacity.
    :type category: str
    :param resource_id_dimension_name_override: Account Resource Id.
    :type resource_id_dimension_name_override: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'category': {'key': 'category', 'type': 'str'},
        'resource_id_dimension_name_override': {'key': 'resourceIdDimensionNameOverride', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.display_description = kwargs.get('display_description', None)
        self.unit = kwargs.get('unit', None)
        self.dimensions = kwargs.get('dimensions', None)
        self.aggregation_type = kwargs.get('aggregation_type', None)
        self.fill_gap_with_zero = kwargs.get('fill_gap_with_zero', None)
        self.category = kwargs.get('category', None)
        self.resource_id_dimension_name_override = kwargs.get('resource_id_dimension_name_override', None)


class MonthlySchedule(msrest.serialization.Model):
    """Monthly Schedule properties.

    :param snapshots_to_keep: Monthly snapshot count to keep.
    :type snapshots_to_keep: int
    :param days_of_month: Indicates which days of the month snapshot should be taken. A comma
     delimited string.
    :type days_of_month: str
    :param hour: Indicates which hour in UTC timezone a snapshot should be taken.
    :type hour: int
    :param minute: Indicates which minute snapshot should be taken.
    :type minute: int
    :param used_bytes: Resource size in bytes, current storage usage for the volume in bytes.
    :type used_bytes: long
    """

    _attribute_map = {
        'snapshots_to_keep': {'key': 'snapshotsToKeep', 'type': 'int'},
        'days_of_month': {'key': 'daysOfMonth', 'type': 'str'},
        'hour': {'key': 'hour', 'type': 'int'},
        'minute': {'key': 'minute', 'type': 'int'},
        'used_bytes': {'key': 'usedBytes', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MonthlySchedule, self).__init__(**kwargs)
        self.snapshots_to_keep = kwargs.get('snapshots_to_keep', None)
        self.days_of_month = kwargs.get('days_of_month', None)
        self.hour = kwargs.get('hour', None)
        self.minute = kwargs.get('minute', None)
        self.used_bytes = kwargs.get('used_bytes', None)


class MountTarget(msrest.serialization.Model):
    """Mount Target.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Resource location.
    :type location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar mount_target_id: UUID v4 used to identify the MountTarget.
    :vartype mount_target_id: str
    :param file_system_id: Required. UUID v4 used to identify the MountTarget.
    :type file_system_id: str
    :ivar ip_address: The mount target's IPv4 address.
    :vartype ip_address: str
    :param smb_server_fqdn: The SMB server's Fully Qualified Domain Name, FQDN.
    :type smb_server_fqdn: str
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'mount_target_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'file_system_id': {'required': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'ip_address': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'mount_target_id': {'key': 'properties.mountTargetId', 'type': 'str'},
        'file_system_id': {'key': 'properties.fileSystemId', 'type': 'str'},
        'ip_address': {'key': 'properties.ipAddress', 'type': 'str'},
        'smb_server_fqdn': {'key': 'properties.smbServerFqdn', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MountTarget, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.id = None
        self.name = None
        self.type = None
        self.tags = kwargs.get('tags', None)
        self.mount_target_id = None
        self.file_system_id = kwargs['file_system_id']
        self.ip_address = None
        self.smb_server_fqdn = kwargs.get('smb_server_fqdn', None)


class MountTargetProperties(msrest.serialization.Model):
    """Mount target properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar mount_target_id: UUID v4 used to identify the MountTarget.
    :vartype mount_target_id: str
    :param file_system_id: Required. UUID v4 used to identify the MountTarget.
    :type file_system_id: str
    :ivar ip_address: The mount target's IPv4 address.
    :vartype ip_address: str
    :param smb_server_fqdn: The SMB server's Fully Qualified Domain Name, FQDN.
    :type smb_server_fqdn: str
    """

    _validation = {
        'mount_target_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'file_system_id': {'required': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'ip_address': {'readonly': True},
    }

    _attribute_map = {
        'mount_target_id': {'key': 'mountTargetId', 'type': 'str'},
        'file_system_id': {'key': 'fileSystemId', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'smb_server_fqdn': {'key': 'smbServerFqdn', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MountTargetProperties, self).__init__(**kwargs)
        self.mount_target_id = None
        self.file_system_id = kwargs['file_system_id']
        self.ip_address = None
        self.smb_server_fqdn = kwargs.get('smb_server_fqdn', None)


class NetAppAccount(msrest.serialization.Model):
    """NetApp account resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Resource location.
    :type location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.netapp.models.SystemData
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :param active_directories: Active Directories.
    :type active_directories: list[~azure.mgmt.netapp.models.ActiveDirectory]
    :param encryption: Encryption settings.
    :type encryption: ~azure.mgmt.netapp.models.AccountEncryption
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'active_directories': {'key': 'properties.activeDirectories', 'type': '[ActiveDirectory]'},
        'encryption': {'key': 'properties.encryption', 'type': 'AccountEncryption'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetAppAccount, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.id = None
        self.name = None
        self.type = None
        self.tags = kwargs.get('tags', None)
        self.system_data = None
        self.provisioning_state = None
        self.active_directories = kwargs.get('active_directories', None)
        self.encryption = kwargs.get('encryption', None)


class NetAppAccountList(msrest.serialization.Model):
    """List of NetApp account resources.

    :param value: Multiple NetApp accounts.
    :type value: list[~azure.mgmt.netapp.models.NetAppAccount]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetAppAccount]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetAppAccountList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class NetAppAccountPatch(msrest.serialization.Model):
    """NetApp account patch resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param location: Resource location.
    :type location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :param active_directories: Active Directories.
    :type active_directories: list[~azure.mgmt.netapp.models.ActiveDirectory]
    :param encryption: Encryption settings.
    :type encryption: ~azure.mgmt.netapp.models.AccountEncryption
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'active_directories': {'key': 'properties.activeDirectories', 'type': '[ActiveDirectory]'},
        'encryption': {'key': 'properties.encryption', 'type': 'AccountEncryption'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetAppAccountPatch, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.id = None
        self.name = None
        self.type = None
        self.tags = kwargs.get('tags', None)
        self.provisioning_state = None
        self.active_directories = kwargs.get('active_directories', None)
        self.encryption = kwargs.get('encryption', None)


class Operation(msrest.serialization.Model):
    """Microsoft.NetApp REST API operation definition.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: Display metadata associated with the operation.
    :type display: ~azure.mgmt.netapp.models.OperationDisplay
    :param origin: The origin of operations.
    :type origin: str
    :param service_specification: One property of operation, include metric specifications.
    :type service_specification: ~azure.mgmt.netapp.models.ServiceSpecification
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)
        self.service_specification = kwargs.get('service_specification', None)


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :param provider: Service provider: Microsoft NetApp.
    :type provider: str
    :param resource: Resource on which the operation is performed etc.
    :type resource: str
    :param operation: Type of operation: get, read, delete, etc.
    :type operation: str
    :param description: Operation description.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Cloud Volume operations. It contains a list of operations and a URL link to get the next set of results.

    :param value: List of Storage operations supported by the Storage resource provider.
    :type value: list[~azure.mgmt.netapp.models.Operation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PoolChangeRequest(msrest.serialization.Model):
    """Pool change request.

    All required parameters must be populated in order to send to Azure.

    :param new_pool_resource_id: Required. Resource id of the pool to move volume to.
    :type new_pool_resource_id: str
    """

    _validation = {
        'new_pool_resource_id': {'required': True},
    }

    _attribute_map = {
        'new_pool_resource_id': {'key': 'newPoolResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PoolChangeRequest, self).__init__(**kwargs)
        self.new_pool_resource_id = kwargs['new_pool_resource_id']


class QuotaAvailabilityRequest(msrest.serialization.Model):
    """Quota availability request content.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the resource to verify.
    :type name: str
    :param type: Required. Resource type used for verification. Possible values include:
     "Microsoft.NetApp/netAppAccounts", "Microsoft.NetApp/netAppAccounts/capacityPools",
     "Microsoft.NetApp/netAppAccounts/capacityPools/volumes",
     "Microsoft.NetApp/netAppAccounts/capacityPools/volumes/snapshots".
    :type type: str or ~azure.mgmt.netapp.models.CheckQuotaNameResourceTypes
    :param resource_group: Required. Resource group name.
    :type resource_group: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'resource_group': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaAvailabilityRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.type = kwargs['type']
        self.resource_group = kwargs['resource_group']


class ReplicationObject(msrest.serialization.Model):
    """Replication properties.

    All required parameters must be populated in order to send to Azure.

    :param replication_id: Id.
    :type replication_id: str
    :param endpoint_type: Indicates whether the local volume is the source or destination for the
     Volume Replication. Possible values include: "src", "dst".
    :type endpoint_type: str or ~azure.mgmt.netapp.models.EndpointType
    :param replication_schedule: Required. Schedule. Possible values include: "_10minutely",
     "hourly", "daily".
    :type replication_schedule: str or ~azure.mgmt.netapp.models.ReplicationSchedule
    :param remote_volume_resource_id: Required. The resource ID of the remote volume.
    :type remote_volume_resource_id: str
    :param remote_volume_region: The remote region for the other end of the Volume Replication.
    :type remote_volume_region: str
    """

    _validation = {
        'replication_schedule': {'required': True},
        'remote_volume_resource_id': {'required': True},
    }

    _attribute_map = {
        'replication_id': {'key': 'replicationId', 'type': 'str'},
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'replication_schedule': {'key': 'replicationSchedule', 'type': 'str'},
        'remote_volume_resource_id': {'key': 'remoteVolumeResourceId', 'type': 'str'},
        'remote_volume_region': {'key': 'remoteVolumeRegion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationObject, self).__init__(**kwargs)
        self.replication_id = kwargs.get('replication_id', None)
        self.endpoint_type = kwargs.get('endpoint_type', None)
        self.replication_schedule = kwargs['replication_schedule']
        self.remote_volume_resource_id = kwargs['remote_volume_resource_id']
        self.remote_volume_region = kwargs.get('remote_volume_region', None)


class ReplicationStatus(msrest.serialization.Model):
    """Replication status.

    :param healthy: Replication health check.
    :type healthy: bool
    :param relationship_status: Status of the mirror relationship. Possible values include: "Idle",
     "Transferring".
    :type relationship_status: str or ~azure.mgmt.netapp.models.RelationshipStatus
    :param mirror_state: The status of the replication. Possible values include: "Uninitialized",
     "Mirrored", "Broken".
    :type mirror_state: str or ~azure.mgmt.netapp.models.MirrorState
    :param total_progress: The progress of the replication.
    :type total_progress: str
    :param error_message: Displays error message if the replication is in an error state.
    :type error_message: str
    """

    _attribute_map = {
        'healthy': {'key': 'healthy', 'type': 'bool'},
        'relationship_status': {'key': 'relationshipStatus', 'type': 'str'},
        'mirror_state': {'key': 'mirrorState', 'type': 'str'},
        'total_progress': {'key': 'totalProgress', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationStatus, self).__init__(**kwargs)
        self.healthy = kwargs.get('healthy', None)
        self.relationship_status = kwargs.get('relationship_status', None)
        self.mirror_state = kwargs.get('mirror_state', None)
        self.total_progress = kwargs.get('total_progress', None)
        self.error_message = kwargs.get('error_message', None)


class ResourceIdentity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: Object id of the identity resource.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the resource.
    :vartype tenant_id: str
    :param type: Type of Identity. Supported values are: 'None', 'SystemAssigned'.
    :type type: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)


class ResourceNameAvailabilityRequest(msrest.serialization.Model):
    """Resource name availability request content.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Resource name to verify.
    :type name: str
    :param type: Required. Resource type used for verification. Possible values include:
     "Microsoft.NetApp/netAppAccounts", "Microsoft.NetApp/netAppAccounts/capacityPools",
     "Microsoft.NetApp/netAppAccounts/capacityPools/volumes",
     "Microsoft.NetApp/netAppAccounts/capacityPools/volumes/snapshots".
    :type type: str or ~azure.mgmt.netapp.models.CheckNameResourceTypes
    :param resource_group: Required. Resource group name.
    :type resource_group: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'resource_group': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceNameAvailabilityRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.type = kwargs['type']
        self.resource_group = kwargs['resource_group']


class ServiceSpecification(msrest.serialization.Model):
    """One property of operation, include metric specifications.

    :param metric_specifications: Metric specifications of operation.
    :type metric_specifications: list[~azure.mgmt.netapp.models.MetricSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = kwargs.get('metric_specifications', None)


class Snapshot(msrest.serialization.Model):
    """Snapshot of a Volume.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Resource location.
    :type location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar snapshot_id: UUID v4 used to identify the Snapshot.
    :vartype snapshot_id: str
    :ivar created: The creation date of the snapshot.
    :vartype created: ~datetime.datetime
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'snapshot_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'created': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'snapshot_id': {'key': 'properties.snapshotId', 'type': 'str'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Snapshot, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.id = None
        self.name = None
        self.type = None
        self.snapshot_id = None
        self.created = None
        self.provisioning_state = None


class SnapshotPoliciesList(msrest.serialization.Model):
    """List of Snapshot Policies.

    :param value: A list of snapshot policies.
    :type value: list[~azure.mgmt.netapp.models.SnapshotPolicy]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SnapshotPolicy]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SnapshotPoliciesList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class SnapshotPolicy(msrest.serialization.Model):
    """Snapshot policy information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Resource location.
    :type location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param hourly_schedule: Schedule for hourly snapshots.
    :type hourly_schedule: ~azure.mgmt.netapp.models.HourlySchedule
    :param daily_schedule: Schedule for daily snapshots.
    :type daily_schedule: ~azure.mgmt.netapp.models.DailySchedule
    :param weekly_schedule: Schedule for weekly snapshots.
    :type weekly_schedule: ~azure.mgmt.netapp.models.WeeklySchedule
    :param monthly_schedule: Schedule for monthly snapshots.
    :type monthly_schedule: ~azure.mgmt.netapp.models.MonthlySchedule
    :param enabled: The property to decide policy is enabled or not.
    :type enabled: bool
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'hourly_schedule': {'key': 'properties.hourlySchedule', 'type': 'HourlySchedule'},
        'daily_schedule': {'key': 'properties.dailySchedule', 'type': 'DailySchedule'},
        'weekly_schedule': {'key': 'properties.weeklySchedule', 'type': 'WeeklySchedule'},
        'monthly_schedule': {'key': 'properties.monthlySchedule', 'type': 'MonthlySchedule'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SnapshotPolicy, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.id = None
        self.name = None
        self.type = None
        self.tags = kwargs.get('tags', None)
        self.hourly_schedule = kwargs.get('hourly_schedule', None)
        self.daily_schedule = kwargs.get('daily_schedule', None)
        self.weekly_schedule = kwargs.get('weekly_schedule', None)
        self.monthly_schedule = kwargs.get('monthly_schedule', None)
        self.enabled = kwargs.get('enabled', None)
        self.provisioning_state = None


class SnapshotPolicyDetails(msrest.serialization.Model):
    """Snapshot policy properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param location: Resource location.
    :type location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param hourly_schedule: Schedule for hourly snapshots.
    :type hourly_schedule: ~azure.mgmt.netapp.models.HourlySchedule
    :param daily_schedule: Schedule for daily snapshots.
    :type daily_schedule: ~azure.mgmt.netapp.models.DailySchedule
    :param weekly_schedule: Schedule for weekly snapshots.
    :type weekly_schedule: ~azure.mgmt.netapp.models.WeeklySchedule
    :param monthly_schedule: Schedule for monthly snapshots.
    :type monthly_schedule: ~azure.mgmt.netapp.models.MonthlySchedule
    :param enabled: The property to decide policy is enabled or not.
    :type enabled: bool
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'hourly_schedule': {'key': 'properties.hourlySchedule', 'type': 'HourlySchedule'},
        'daily_schedule': {'key': 'properties.dailySchedule', 'type': 'DailySchedule'},
        'weekly_schedule': {'key': 'properties.weeklySchedule', 'type': 'WeeklySchedule'},
        'monthly_schedule': {'key': 'properties.monthlySchedule', 'type': 'MonthlySchedule'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SnapshotPolicyDetails, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.id = None
        self.name = None
        self.type = None
        self.tags = kwargs.get('tags', None)
        self.hourly_schedule = kwargs.get('hourly_schedule', None)
        self.daily_schedule = kwargs.get('daily_schedule', None)
        self.weekly_schedule = kwargs.get('weekly_schedule', None)
        self.monthly_schedule = kwargs.get('monthly_schedule', None)
        self.enabled = kwargs.get('enabled', None)
        self.provisioning_state = None


class SnapshotPolicyPatch(msrest.serialization.Model):
    """Snapshot policy Details for create and update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param location: Resource location.
    :type location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param hourly_schedule: Schedule for hourly snapshots.
    :type hourly_schedule: ~azure.mgmt.netapp.models.HourlySchedule
    :param daily_schedule: Schedule for daily snapshots.
    :type daily_schedule: ~azure.mgmt.netapp.models.DailySchedule
    :param weekly_schedule: Schedule for weekly snapshots.
    :type weekly_schedule: ~azure.mgmt.netapp.models.WeeklySchedule
    :param monthly_schedule: Schedule for monthly snapshots.
    :type monthly_schedule: ~azure.mgmt.netapp.models.MonthlySchedule
    :param enabled: The property to decide policy is enabled or not.
    :type enabled: bool
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'hourly_schedule': {'key': 'properties.hourlySchedule', 'type': 'HourlySchedule'},
        'daily_schedule': {'key': 'properties.dailySchedule', 'type': 'DailySchedule'},
        'weekly_schedule': {'key': 'properties.weeklySchedule', 'type': 'WeeklySchedule'},
        'monthly_schedule': {'key': 'properties.monthlySchedule', 'type': 'MonthlySchedule'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SnapshotPolicyPatch, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.id = None
        self.name = None
        self.type = None
        self.tags = kwargs.get('tags', None)
        self.hourly_schedule = kwargs.get('hourly_schedule', None)
        self.daily_schedule = kwargs.get('daily_schedule', None)
        self.weekly_schedule = kwargs.get('weekly_schedule', None)
        self.monthly_schedule = kwargs.get('monthly_schedule', None)
        self.enabled = kwargs.get('enabled', None)
        self.provisioning_state = None


class SnapshotPolicyVolumeList(msrest.serialization.Model):
    """Volumes associated with snapshot policy.

    :param value: List of volumes.
    :type value: list[any]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[object]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SnapshotPolicyVolumeList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class SnapshotsList(msrest.serialization.Model):
    """List of Snapshots.

    :param value: A list of Snapshots.
    :type value: list[~azure.mgmt.netapp.models.Snapshot]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Snapshot]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SnapshotsList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure.mgmt.netapp.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~azure.mgmt.netapp.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class Vault(msrest.serialization.Model):
    """Vault information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Resource location.
    :type location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param vault_name: Vault Name.
    :type vault_name: str
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vault_name': {'key': 'properties.vaultName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Vault, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.id = None
        self.name = None
        self.type = None
        self.vault_name = kwargs.get('vault_name', None)


class VaultList(msrest.serialization.Model):
    """List of Vaults.

    :param value: A list of vaults.
    :type value: list[~azure.mgmt.netapp.models.Vault]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Vault]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VaultList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class Volume(msrest.serialization.Model):
    """Volume resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Resource location.
    :type location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar file_system_id: Unique FileSystem Identifier.
    :vartype file_system_id: str
    :param creation_token: Required. A unique file path for the volume. Used when creating mount
     targets.
    :type creation_token: str
    :param service_level: The service level of the file system. Possible values include:
     "Standard", "Premium", "Ultra".
    :type service_level: str or ~azure.mgmt.netapp.models.ServiceLevel
    :param usage_threshold: Required. Maximum storage quota allowed for a file system in bytes.
     This is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB.
     Specified in bytes.
    :type usage_threshold: long
    :param export_policy: Set of export policy rules.
    :type export_policy: ~azure.mgmt.netapp.models.VolumePropertiesExportPolicy
    :param protocol_types: Set of protocol types, default NFSv3, CIFS for SMB protocol.
    :type protocol_types: list[str]
    :ivar provisioning_state: Azure lifecycle management.
    :vartype provisioning_state: str
    :param snapshot_id: UUID v4 or resource identifier used to identify the Snapshot.
    :type snapshot_id: str
    :param backup_id: UUID v4 or resource identifier used to identify the Backup.
    :type backup_id: str
    :ivar baremetal_tenant_id: Unique Baremetal Tenant Identifier.
    :vartype baremetal_tenant_id: str
    :param subnet_id: Required. The Azure Resource URI for a delegated subnet. Must have the
     delegation Microsoft.NetApp/volumes.
    :type subnet_id: str
    :ivar mount_targets: List of mount targets.
    :vartype mount_targets: list[~azure.mgmt.netapp.models.MountTargetProperties]
    :param volume_type: What type of volume is this.
    :type volume_type: str
    :param data_protection: DataProtection type volumes include an object containing details of the
     replication.
    :type data_protection: ~azure.mgmt.netapp.models.VolumePropertiesDataProtection
    :param is_restoring: Restoring.
    :type is_restoring: bool
    :param snapshot_directory_visible: If enabled (true) the volume will contain a read-only
     snapshot directory which provides access to each of the volume's snapshots (default to true).
    :type snapshot_directory_visible: bool
    :param kerberos_enabled: Describe if a volume is KerberosEnabled. To be use with swagger
     version 2020-05-01 or later.
    :type kerberos_enabled: bool
    :param security_style: The security style of volume, default unix, defaults to ntfs for dual
     protocol or CIFS protocol. Possible values include: "ntfs", "unix". Default value: "unix".
    :type security_style: str or ~azure.mgmt.netapp.models.SecurityStyle
    :param smb_encryption: Enables encryption for in-flight smb3 data. Only applicable for
     SMB/DualProtocol volume. To be used with swagger version 2020-08-01 or later.
    :type smb_encryption: bool
    :param smb_continuously_available: Enables continuously available share property for smb
     volume. Only applicable for SMB volume.
    :type smb_continuously_available: bool
    :param throughput_mibps: Maximum throughput in Mibps that can be achieved by this volume.
    :type throughput_mibps: float
    :param encryption_key_source: Encryption Key Source. Possible values are: 'Microsoft.NetApp'.
    :type encryption_key_source: str
    :param ldap_enabled: Specifies whether LDAP is enabled or not for a given NFS volume.
    :type ldap_enabled: bool
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'file_system_id': {'readonly': True, 'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$'},
        'creation_token': {'required': True, 'max_length': 80, 'min_length': 1, 'pattern': r'^[a-zA-Z][a-zA-Z0-9\-]{0,79}$'},
        'usage_threshold': {'required': True, 'maximum': 109951162777600, 'minimum': 107374182400},
        'provisioning_state': {'readonly': True},
        'snapshot_id': {'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}|(\\?([^\/]*[\/])*)([^\/]+)$'},
        'backup_id': {'max_length': 36, 'min_length': 36, 'pattern': r'^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}|(\\?([^\/]*[\/])*)([^\/]+)$'},
        'baremetal_tenant_id': {'readonly': True},
        'subnet_id': {'required': True},
        'mount_targets': {'readonly': True},
        'throughput_mibps': {'maximum': 4500, 'minimum': 0},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'file_system_id': {'key': 'properties.fileSystemId', 'type': 'str'},
        'creation_token': {'key': 'properties.creationToken', 'type': 'str'},
        'service_level': {'key': 'properties.serviceLevel', 'type': 'str'},
        'usage_threshold': {'key': 'properties.usageThreshold', 'type': 'long'},
        'export_policy': {'key': 'properties.exportPolicy', 'type': 'VolumePropertiesExportPolicy'},
        'protocol_types': {'key': 'properties.protocolTypes', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'snapshot_id': {'key': 'properties.snapshotId', 'type': 'str'},
        'backup_id': {'key': 'properties.backupId', 'type': 'str'},
        'baremetal_tenant_id': {'key': 'properties.baremetalTenantId', 'type': 'str'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'mount_targets': {'key': 'properties.mountTargets', 'type': '[MountTargetProperties]'},
        'volume_type': {'key': 'properties.volumeType', 'type': 'str'},
        'data_protection': {'key': 'properties.dataProtection', 'type': 'VolumePropertiesDataProtection'},
        'is_restoring': {'key': 'properties.isRestoring', 'type': 'bool'},
        'snapshot_directory_visible': {'key': 'properties.snapshotDirectoryVisible', 'type': 'bool'},
        'kerberos_enabled': {'key': 'properties.kerberosEnabled', 'type': 'bool'},
        'security_style': {'key': 'properties.securityStyle', 'type': 'str'},
        'smb_encryption': {'key': 'properties.smbEncryption', 'type': 'bool'},
        'smb_continuously_available': {'key': 'properties.smbContinuouslyAvailable', 'type': 'bool'},
        'throughput_mibps': {'key': 'properties.throughputMibps', 'type': 'float'},
        'encryption_key_source': {'key': 'properties.encryptionKeySource', 'type': 'str'},
        'ldap_enabled': {'key': 'properties.ldapEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Volume, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.id = None
        self.name = None
        self.type = None
        self.tags = kwargs.get('tags', None)
        self.file_system_id = None
        self.creation_token = kwargs['creation_token']
        self.service_level = kwargs.get('service_level', None)
        self.usage_threshold = kwargs.get('usage_threshold', 107374182400)
        self.export_policy = kwargs.get('export_policy', None)
        self.protocol_types = kwargs.get('protocol_types', None)
        self.provisioning_state = None
        self.snapshot_id = kwargs.get('snapshot_id', None)
        self.backup_id = kwargs.get('backup_id', None)
        self.baremetal_tenant_id = None
        self.subnet_id = kwargs['subnet_id']
        self.mount_targets = None
        self.volume_type = kwargs.get('volume_type', None)
        self.data_protection = kwargs.get('data_protection', None)
        self.is_restoring = kwargs.get('is_restoring', None)
        self.snapshot_directory_visible = kwargs.get('snapshot_directory_visible', True)
        self.kerberos_enabled = kwargs.get('kerberos_enabled', False)
        self.security_style = kwargs.get('security_style', "unix")
        self.smb_encryption = kwargs.get('smb_encryption', False)
        self.smb_continuously_available = kwargs.get('smb_continuously_available', False)
        self.throughput_mibps = kwargs.get('throughput_mibps', 0)
        self.encryption_key_source = kwargs.get('encryption_key_source', None)
        self.ldap_enabled = kwargs.get('ldap_enabled', False)


class VolumeBackupProperties(msrest.serialization.Model):
    """Volume Backup Properties.

    :param backup_policy_id: Backup Policy Resource ID.
    :type backup_policy_id: str
    :param policy_enforced: Policy Enforced.
    :type policy_enforced: bool
    :param vault_id: Vault Resource ID.
    :type vault_id: str
    :param backup_enabled: Backup Enabled.
    :type backup_enabled: bool
    """

    _attribute_map = {
        'backup_policy_id': {'key': 'backupPolicyId', 'type': 'str'},
        'policy_enforced': {'key': 'policyEnforced', 'type': 'bool'},
        'vault_id': {'key': 'vaultId', 'type': 'str'},
        'backup_enabled': {'key': 'backupEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VolumeBackupProperties, self).__init__(**kwargs)
        self.backup_policy_id = kwargs.get('backup_policy_id', None)
        self.policy_enforced = kwargs.get('policy_enforced', None)
        self.vault_id = kwargs.get('vault_id', None)
        self.backup_enabled = kwargs.get('backup_enabled', None)


class VolumeBackups(msrest.serialization.Model):
    """Volume details using the backup policy.

    :param volume_name: Volume name.
    :type volume_name: str
    :param backups_count: Total count of backups for volume.
    :type backups_count: int
    :param policy_enabled: Policy enabled.
    :type policy_enabled: bool
    """

    _attribute_map = {
        'volume_name': {'key': 'volumeName', 'type': 'str'},
        'backups_count': {'key': 'backupsCount', 'type': 'int'},
        'policy_enabled': {'key': 'policyEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VolumeBackups, self).__init__(**kwargs)
        self.volume_name = kwargs.get('volume_name', None)
        self.backups_count = kwargs.get('backups_count', None)
        self.policy_enabled = kwargs.get('policy_enabled', None)


class VolumeList(msrest.serialization.Model):
    """List of volume resources.

    :param value: List of volumes.
    :type value: list[~azure.mgmt.netapp.models.Volume]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Volume]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VolumeList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class VolumePatch(msrest.serialization.Model):
    """Volume patch resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param location: Resource location.
    :type location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param service_level: The service level of the file system. Possible values include:
     "Standard", "Premium", "Ultra".
    :type service_level: str or ~azure.mgmt.netapp.models.ServiceLevel
    :param usage_threshold: Maximum storage quota allowed for a file system in bytes. This is a
     soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB. Specified in
     bytes.
    :type usage_threshold: long
    :param export_policy: Set of export policy rules.
    :type export_policy: ~azure.mgmt.netapp.models.VolumePatchPropertiesExportPolicy
    :param throughput_mibps: Maximum throughput in Mibps that can be achieved by this volume.
    :type throughput_mibps: float
    :param data_protection: DataProtection type volumes include an object containing details of the
     replication.
    :type data_protection: ~azure.mgmt.netapp.models.VolumePatchPropertiesDataProtection
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'usage_threshold': {'maximum': 109951162777600, 'minimum': 107374182400},
        'throughput_mibps': {'maximum': 4500, 'minimum': 1},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'service_level': {'key': 'properties.serviceLevel', 'type': 'str'},
        'usage_threshold': {'key': 'properties.usageThreshold', 'type': 'long'},
        'export_policy': {'key': 'properties.exportPolicy', 'type': 'VolumePatchPropertiesExportPolicy'},
        'throughput_mibps': {'key': 'properties.throughputMibps', 'type': 'float'},
        'data_protection': {'key': 'properties.dataProtection', 'type': 'VolumePatchPropertiesDataProtection'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VolumePatch, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.id = None
        self.name = None
        self.type = None
        self.tags = kwargs.get('tags', None)
        self.service_level = kwargs.get('service_level', None)
        self.usage_threshold = kwargs.get('usage_threshold', 107374182400)
        self.export_policy = kwargs.get('export_policy', None)
        self.throughput_mibps = kwargs.get('throughput_mibps', None)
        self.data_protection = kwargs.get('data_protection', None)


class VolumePatchPropertiesDataProtection(msrest.serialization.Model):
    """DataProtection type volumes include an object containing details of the replication.

    :param backup: Backup Properties.
    :type backup: ~azure.mgmt.netapp.models.VolumeBackupProperties
    :param snapshot: Snapshot properties.
    :type snapshot: ~azure.mgmt.netapp.models.VolumeSnapshotProperties
    """

    _attribute_map = {
        'backup': {'key': 'backup', 'type': 'VolumeBackupProperties'},
        'snapshot': {'key': 'snapshot', 'type': 'VolumeSnapshotProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VolumePatchPropertiesDataProtection, self).__init__(**kwargs)
        self.backup = kwargs.get('backup', None)
        self.snapshot = kwargs.get('snapshot', None)


class VolumePatchPropertiesExportPolicy(msrest.serialization.Model):
    """Set of export policy rules.

    :param rules: Export policy rule.
    :type rules: list[~azure.mgmt.netapp.models.ExportPolicyRule]
    """

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[ExportPolicyRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VolumePatchPropertiesExportPolicy, self).__init__(**kwargs)
        self.rules = kwargs.get('rules', None)


class VolumePropertiesDataProtection(msrest.serialization.Model):
    """DataProtection type volumes include an object containing details of the replication.

    :param backup: Backup Properties.
    :type backup: ~azure.mgmt.netapp.models.VolumeBackupProperties
    :param replication: Replication properties.
    :type replication: ~azure.mgmt.netapp.models.ReplicationObject
    :param snapshot: Snapshot properties.
    :type snapshot: ~azure.mgmt.netapp.models.VolumeSnapshotProperties
    """

    _attribute_map = {
        'backup': {'key': 'backup', 'type': 'VolumeBackupProperties'},
        'replication': {'key': 'replication', 'type': 'ReplicationObject'},
        'snapshot': {'key': 'snapshot', 'type': 'VolumeSnapshotProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VolumePropertiesDataProtection, self).__init__(**kwargs)
        self.backup = kwargs.get('backup', None)
        self.replication = kwargs.get('replication', None)
        self.snapshot = kwargs.get('snapshot', None)


class VolumePropertiesExportPolicy(msrest.serialization.Model):
    """Set of export policy rules.

    :param rules: Export policy rule.
    :type rules: list[~azure.mgmt.netapp.models.ExportPolicyRule]
    """

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[ExportPolicyRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VolumePropertiesExportPolicy, self).__init__(**kwargs)
        self.rules = kwargs.get('rules', None)


class VolumeRevert(msrest.serialization.Model):
    """revert a volume to the snapshot.

    :param snapshot_id: Resource id of the snapshot.
    :type snapshot_id: str
    """

    _attribute_map = {
        'snapshot_id': {'key': 'snapshotId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VolumeRevert, self).__init__(**kwargs)
        self.snapshot_id = kwargs.get('snapshot_id', None)


class VolumeSnapshotProperties(msrest.serialization.Model):
    """Volume Snapshot Properties.

    :param snapshot_policy_id: Snapshot Policy ResourceId.
    :type snapshot_policy_id: str
    """

    _attribute_map = {
        'snapshot_policy_id': {'key': 'snapshotPolicyId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VolumeSnapshotProperties, self).__init__(**kwargs)
        self.snapshot_policy_id = kwargs.get('snapshot_policy_id', None)


class WeeklySchedule(msrest.serialization.Model):
    """Weekly Schedule properties, make a snapshot every week at a specific day or days.

    :param snapshots_to_keep: Weekly snapshot count to keep.
    :type snapshots_to_keep: int
    :param day: Indicates which weekdays snapshot should be taken, accepts a comma separated list
     of week day names in english.
    :type day: str
    :param hour: Indicates which hour in UTC timezone a snapshot should be taken.
    :type hour: int
    :param minute: Indicates which minute snapshot should be taken.
    :type minute: int
    :param used_bytes: Resource size in bytes, current storage usage for the volume in bytes.
    :type used_bytes: long
    """

    _attribute_map = {
        'snapshots_to_keep': {'key': 'snapshotsToKeep', 'type': 'int'},
        'day': {'key': 'day', 'type': 'str'},
        'hour': {'key': 'hour', 'type': 'int'},
        'minute': {'key': 'minute', 'type': 'int'},
        'used_bytes': {'key': 'usedBytes', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WeeklySchedule, self).__init__(**kwargs)
        self.snapshots_to_keep = kwargs.get('snapshots_to_keep', None)
        self.day = kwargs.get('day', None)
        self.hour = kwargs.get('hour', None)
        self.minute = kwargs.get('minute', None)
        self.used_bytes = kwargs.get('used_bytes', None)
