# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

    from azure.core.credentials import TokenCredential
    from azure.core.pipeline.transport import HttpRequest, HttpResponse

from ._configuration import NetAppManagementClientConfiguration
from .operations import Operations
from .operations import NetAppResourceOperations
from .operations import AccountsOperations
from .operations import PoolsOperations
from .operations import VolumesOperations
from .operations import SnapshotsOperations
from .operations import SnapshotPoliciesOperations
from .operations import BackupsOperations
from .operations import AccountBackupsOperations
from .operations import BackupPoliciesOperations
from .operations import VaultsOperations
from . import models


class NetAppManagementClient(object):
    """Microsoft NetApp Files Azure Resource Provider specification.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.netapp.operations.Operations
    :ivar net_app_resource: NetAppResourceOperations operations
    :vartype net_app_resource: azure.mgmt.netapp.operations.NetAppResourceOperations
    :ivar accounts: AccountsOperations operations
    :vartype accounts: azure.mgmt.netapp.operations.AccountsOperations
    :ivar pools: PoolsOperations operations
    :vartype pools: azure.mgmt.netapp.operations.PoolsOperations
    :ivar volumes: VolumesOperations operations
    :vartype volumes: azure.mgmt.netapp.operations.VolumesOperations
    :ivar snapshots: SnapshotsOperations operations
    :vartype snapshots: azure.mgmt.netapp.operations.SnapshotsOperations
    :ivar snapshot_policies: SnapshotPoliciesOperations operations
    :vartype snapshot_policies: azure.mgmt.netapp.operations.SnapshotPoliciesOperations
    :ivar backups: BackupsOperations operations
    :vartype backups: azure.mgmt.netapp.operations.BackupsOperations
    :ivar account_backups: AccountBackupsOperations operations
    :vartype account_backups: azure.mgmt.netapp.operations.AccountBackupsOperations
    :ivar backup_policies: BackupPoliciesOperations operations
    :vartype backup_policies: azure.mgmt.netapp.operations.BackupPoliciesOperations
    :ivar vaults: VaultsOperations operations
    :vartype vaults: azure.mgmt.netapp.operations.VaultsOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: Subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID forms part of the URI for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        subscription_id,  # type: str
        base_url=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = NetAppManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.net_app_resource = NetAppResourceOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.accounts = AccountsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.pools = PoolsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.volumes = VolumesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.snapshots = SnapshotsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.snapshot_policies = SnapshotPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backups = BackupsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.account_backups = AccountBackupsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.backup_policies = BackupPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.vaults = VaultsOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, http_request, **kwargs):
        # type: (HttpRequest, Any) -> HttpResponse
        """Runs the network request through the client's chained policies.

        :param http_request: The network request you want to make. Required.
        :type http_request: ~azure.core.pipeline.transport.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to True.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.pipeline.transport.HttpResponse
        """
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
        }
        http_request.url = self._client.format_url(http_request.url, **path_format_arguments)
        stream = kwargs.pop("stream", True)
        pipeline_response = self._client._pipeline.run(http_request, stream=stream, **kwargs)
        return pipeline_response.http_response

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> NetAppManagementClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
