# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AppliedReservationList(Model):
    """AppliedReservationList.

    :param value:
    :type value: list[str]
    :param next_link: Url to get the next page of reservations
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[str]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AppliedReservationList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class AppliedReservations(Model):
    """AppliedReservations.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Identifier of the applied reservations
    :vartype id: str
    :ivar name: Name of resource
    :vartype name: str
    :ivar type: Type of resource. "Microsoft.Capacity/AppliedReservations"
    :vartype type: str
    :param reservation_order_ids:
    :type reservation_order_ids:
     ~azure.mgmt.reservations.models.AppliedReservationList
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'reservation_order_ids': {'key': 'properties.reservationOrderIds', 'type': 'AppliedReservationList'},
    }

    def __init__(self, **kwargs):
        super(AppliedReservations, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.reservation_order_ids = kwargs.get('reservation_order_ids', None)


class CalculatePriceResponse(Model):
    """CalculatePriceResponse.

    :param properties:
    :type properties:
     ~azure.mgmt.reservations.models.CalculatePriceResponseProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CalculatePriceResponseProperties'},
    }

    def __init__(self, **kwargs):
        super(CalculatePriceResponse, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class CalculatePriceResponseProperties(Model):
    """CalculatePriceResponseProperties.

    :param billing_currency_total: Currency and amount that customer will be
     charged in customer's local currency. Tax is not included.
    :type billing_currency_total:
     ~azure.mgmt.reservations.models.CalculatePriceResponsePropertiesBillingCurrencyTotal
    :param is_billing_partner_managed: True if billing is managed by Microsoft
     Partner. Used only for CSP accounts.
    :type is_billing_partner_managed: bool
    :param reservation_order_id: GUID that represents reservation order that
     can be placed after calculating price.
    :type reservation_order_id: str
    :param sku_title: Title of SKU that is being purchased.
    :type sku_title: str
    :param sku_description: Description of SKU that is being purchased.
    :type sku_description: str
    :param pricing_currency_total: Amount that Microsoft uses for record. Used
     during refund for calculating refund limit. Tax is not included.
    :type pricing_currency_total:
     ~azure.mgmt.reservations.models.CalculatePriceResponsePropertiesPricingCurrencyTotal
    :param payment_schedule:
    :type payment_schedule:
     list[~azure.mgmt.reservations.models.PaymentDetail]
    """

    _attribute_map = {
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'CalculatePriceResponsePropertiesBillingCurrencyTotal'},
        'is_billing_partner_managed': {'key': 'isBillingPartnerManaged', 'type': 'bool'},
        'reservation_order_id': {'key': 'reservationOrderId', 'type': 'str'},
        'sku_title': {'key': 'skuTitle', 'type': 'str'},
        'sku_description': {'key': 'skuDescription', 'type': 'str'},
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'CalculatePriceResponsePropertiesPricingCurrencyTotal'},
        'payment_schedule': {'key': 'paymentSchedule', 'type': '[PaymentDetail]'},
    }

    def __init__(self, **kwargs):
        super(CalculatePriceResponseProperties, self).__init__(**kwargs)
        self.billing_currency_total = kwargs.get('billing_currency_total', None)
        self.is_billing_partner_managed = kwargs.get('is_billing_partner_managed', None)
        self.reservation_order_id = kwargs.get('reservation_order_id', None)
        self.sku_title = kwargs.get('sku_title', None)
        self.sku_description = kwargs.get('sku_description', None)
        self.pricing_currency_total = kwargs.get('pricing_currency_total', None)
        self.payment_schedule = kwargs.get('payment_schedule', None)


class CalculatePriceResponsePropertiesBillingCurrencyTotal(Model):
    """Currency and amount that customer will be charged in customer's local
    currency. Tax is not included.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(CalculatePriceResponsePropertiesBillingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = kwargs.get('currency_code', None)
        self.amount = kwargs.get('amount', None)


class CalculatePriceResponsePropertiesPricingCurrencyTotal(Model):
    """Amount that Microsoft uses for record. Used during refund for calculating
    refund limit. Tax is not included.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(CalculatePriceResponsePropertiesPricingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = kwargs.get('currency_code', None)
        self.amount = kwargs.get('amount', None)


class Catalog(Model):
    """Catalog.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar resource_type: The type of resource the SKU applies to.
    :vartype resource_type: str
    :ivar name: The name of SKU
    :vartype name: str
    :param billing_plans: The billing plan options available for this SKU.
    :type billing_plans: dict[str, list[str or
     ~azure.mgmt.reservations.models.ReservationBillingPlan]]
    :ivar terms: Available reservation terms for this resource
    :vartype terms: list[str or
     ~azure.mgmt.reservations.models.ReservationTerm]
    :ivar locations:
    :vartype locations: list[str]
    :ivar sku_properties:
    :vartype sku_properties: list[~azure.mgmt.reservations.models.SkuProperty]
    :ivar restrictions:
    :vartype restrictions:
     list[~azure.mgmt.reservations.models.SkuRestriction]
    """

    _validation = {
        'resource_type': {'readonly': True},
        'name': {'readonly': True},
        'terms': {'readonly': True},
        'locations': {'readonly': True},
        'sku_properties': {'readonly': True},
        'restrictions': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'billing_plans': {'key': 'billingPlans', 'type': '{[str]}'},
        'terms': {'key': 'terms', 'type': '[str]'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'sku_properties': {'key': 'skuProperties', 'type': '[SkuProperty]'},
        'restrictions': {'key': 'restrictions', 'type': '[SkuRestriction]'},
    }

    def __init__(self, **kwargs):
        super(Catalog, self).__init__(**kwargs)
        self.resource_type = None
        self.name = None
        self.billing_plans = kwargs.get('billing_plans', None)
        self.terms = None
        self.locations = None
        self.sku_properties = None
        self.restrictions = None


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class Error(Model):
    """Error.

    :param error:
    :type error: ~azure.mgmt.reservations.models.ExtendedErrorInfo
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ExtendedErrorInfo'},
    }

    def __init__(self, **kwargs):
        super(Error, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorException(HttpOperationError):
    """Server responsed with exception of type: 'Error'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorException, self).__init__(deserialize, response, 'Error', *args)


class ExtendedErrorInfo(Model):
    """ExtendedErrorInfo.

    :param code: Possible values include: 'NotSpecified',
     'InternalServerError', 'ServerTimeout', 'AuthorizationFailed',
     'BadRequest', 'ClientCertificateThumbprintNotSet',
     'InvalidRequestContent', 'OperationFailed', 'HttpMethodNotSupported',
     'InvalidRequestUri', 'MissingTenantId', 'InvalidTenantId',
     'InvalidReservationOrderId', 'InvalidReservationId',
     'ReservationIdNotInReservationOrder', 'ReservationOrderNotFound',
     'InvalidSubscriptionId', 'InvalidAccessToken', 'InvalidLocationId',
     'UnauthenticatedRequestsThrottled', 'InvalidHealthCheckType', 'Forbidden',
     'BillingScopeIdCannotBeChanged',
     'AppliedScopesNotAssociatedWithCommerceAccount',
     'PatchValuesSameAsExisting', 'RoleAssignmentCreationFailed',
     'ReservationOrderCreationFailed', 'ReservationOrderNotEnabled',
     'CapacityUpdateScopesFailed', 'UnsupportedReservationTerm',
     'ReservationOrderIdAlreadyExists', 'RiskCheckFailed', 'CreateQuoteFailed',
     'ActivateQuoteFailed', 'NonsupportedAccountId',
     'PaymentInstrumentNotFound', 'MissingAppliedScopesForSingle',
     'NoValidReservationsToReRate', 'ReRateOnlyAllowedForEA',
     'OperationCannotBePerformedInCurrentState',
     'InvalidSingleAppliedScopesCount', 'InvalidFulfillmentRequestParameters',
     'NotSupportedCountry', 'InvalidRefundQuantity', 'PurchaseError',
     'BillingCustomerInputError', 'BillingPaymentInstrumentSoftError',
     'BillingPaymentInstrumentHardError', 'BillingTransientError',
     'BillingError', 'FulfillmentConfigurationError',
     'FulfillmentOutOfStockError', 'FulfillmentTransientError',
     'FulfillmentError', 'CalculatePriceFailed'
    :type code: str or ~azure.mgmt.reservations.models.ErrorResponseCode
    :param message:
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExtendedErrorInfo, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class ExtendedStatusInfo(Model):
    """ExtendedStatusInfo.

    :param status_code: Possible values include: 'None', 'Pending', 'Active',
     'PurchaseError', 'PaymentInstrumentError', 'Split', 'Merged', 'Expired',
     'Succeeded'
    :type status_code: str or
     ~azure.mgmt.reservations.models.ReservationStatusCode
    :param message: The message giving detailed information about the status
     code.
    :type message: str
    """

    _attribute_map = {
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ExtendedStatusInfo, self).__init__(**kwargs)
        self.status_code = kwargs.get('status_code', None)
        self.message = kwargs.get('message', None)


class MergeRequest(Model):
    """MergeRequest.

    :param sources: Format of the resource id should be
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
    :type sources: list[str]
    """

    _attribute_map = {
        'sources': {'key': 'properties.sources', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(MergeRequest, self).__init__(**kwargs)
        self.sources = kwargs.get('sources', None)


class OperationDisplay(Model):
    """OperationDisplay.

    :param provider:
    :type provider: str
    :param resource:
    :type resource: str
    :param operation:
    :type operation: str
    :param description:
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationResponse(Model):
    """OperationResponse.

    :param name:
    :type name: str
    :param display:
    :type display: ~azure.mgmt.reservations.models.OperationDisplay
    :param origin:
    :type origin: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationResponse, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)


class Patch(Model):
    """Patch.

    :param applied_scope_type: Possible values include: 'Single', 'Shared'
    :type applied_scope_type: str or
     ~azure.mgmt.reservations.models.AppliedScopeType
    :param applied_scopes:
    :type applied_scopes: list[str]
    :param instance_flexibility: Possible values include: 'On', 'Off'
    :type instance_flexibility: str or
     ~azure.mgmt.reservations.models.InstanceFlexibility
    :param name: Name of the Reservation
    :type name: str
    :param renew:
    :type renew: bool
    :param renew_properties:
    :type renew_properties:
     ~azure.mgmt.reservations.models.PatchPropertiesRenewProperties
    """

    _attribute_map = {
        'applied_scope_type': {'key': 'properties.appliedScopeType', 'type': 'str'},
        'applied_scopes': {'key': 'properties.appliedScopes', 'type': '[str]'},
        'instance_flexibility': {'key': 'properties.instanceFlexibility', 'type': 'str'},
        'name': {'key': 'properties.name', 'type': 'str'},
        'renew': {'key': 'properties.renew', 'type': 'bool'},
        'renew_properties': {'key': 'properties.renewProperties', 'type': 'PatchPropertiesRenewProperties'},
    }

    def __init__(self, **kwargs):
        super(Patch, self).__init__(**kwargs)
        self.applied_scope_type = kwargs.get('applied_scope_type', None)
        self.applied_scopes = kwargs.get('applied_scopes', None)
        self.instance_flexibility = kwargs.get('instance_flexibility', None)
        self.name = kwargs.get('name', None)
        self.renew = kwargs.get('renew', None)
        self.renew_properties = kwargs.get('renew_properties', None)


class PatchPropertiesRenewProperties(Model):
    """PatchPropertiesRenewProperties.

    :param purchase_properties:
    :type purchase_properties: ~azure.mgmt.reservations.models.PurchaseRequest
    """

    _attribute_map = {
        'purchase_properties': {'key': 'purchaseProperties', 'type': 'PurchaseRequest'},
    }

    def __init__(self, **kwargs):
        super(PatchPropertiesRenewProperties, self).__init__(**kwargs)
        self.purchase_properties = kwargs.get('purchase_properties', None)


class PaymentDetail(Model):
    """Information about payment related to a reservation order.

    :param due_date: Date when the payment needs to be done.
    :type due_date: date
    :param payment_date: Date when the transaction is completed. Is null when
     it is scheduled.
    :type payment_date: date
    :param pricing_currency_total: Amount in pricing currency. Tax not
     included.
    :type pricing_currency_total: ~azure.mgmt.reservations.models.Price
    :param billing_currency_total: Amount charged in Billing currency. Tax not
     included. Is null for future payments
    :type billing_currency_total: ~azure.mgmt.reservations.models.Price
    :param billing_account: Shows the Account that is charged for this
     payment.
    :type billing_account: str
    :param status: Possible values include: 'Succeeded', 'Failed',
     'Scheduled', 'Cancelled'
    :type status: str or ~azure.mgmt.reservations.models.PaymentStatus
    :param extended_status_info:
    :type extended_status_info:
     ~azure.mgmt.reservations.models.ExtendedStatusInfo
    """

    _attribute_map = {
        'due_date': {'key': 'dueDate', 'type': 'date'},
        'payment_date': {'key': 'paymentDate', 'type': 'date'},
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'Price'},
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'Price'},
        'billing_account': {'key': 'billingAccount', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'extended_status_info': {'key': 'extendedStatusInfo', 'type': 'ExtendedStatusInfo'},
    }

    def __init__(self, **kwargs):
        super(PaymentDetail, self).__init__(**kwargs)
        self.due_date = kwargs.get('due_date', None)
        self.payment_date = kwargs.get('payment_date', None)
        self.pricing_currency_total = kwargs.get('pricing_currency_total', None)
        self.billing_currency_total = kwargs.get('billing_currency_total', None)
        self.billing_account = kwargs.get('billing_account', None)
        self.status = kwargs.get('status', None)
        self.extended_status_info = kwargs.get('extended_status_info', None)


class Price(Model):
    """Price.

    :param currency_code: The ISO 4217 3-letter currency code for the currency
     used by this purchase record.
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(Price, self).__init__(**kwargs)
        self.currency_code = kwargs.get('currency_code', None)
        self.amount = kwargs.get('amount', None)


class Properties(Model):
    """Properties.

    :param properties:
    :type properties:
     ~azure.mgmt.reservations.models.SubscriptionScopeProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'SubscriptionScopeProperties'},
    }

    def __init__(self, **kwargs):
        super(Properties, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class PurchaseRequest(Model):
    """PurchaseRequest.

    :param sku:
    :type sku: ~azure.mgmt.reservations.models.SkuName
    :param location: The Azure Region where the reserved resource lives.
    :type location: str
    :param reserved_resource_type: Possible values include: 'VirtualMachines',
     'SqlDatabases', 'SuseLinux', 'CosmosDb', 'RedHat', 'SqlDataWarehouse',
     'VMwareCloudSimple', 'RedHatOsa'
    :type reserved_resource_type: str or
     ~azure.mgmt.reservations.models.ReservedResourceType
    :param billing_scope_id:
    :type billing_scope_id: str
    :param term: Possible values include: 'P1Y', 'P3Y'
    :type term: str or ~azure.mgmt.reservations.models.ReservationTerm
    :param billing_plan: Possible values include: 'Upfront', 'Monthly'
    :type billing_plan: str or
     ~azure.mgmt.reservations.models.ReservationBillingPlan
    :param quantity:
    :type quantity: int
    :param display_name: Friendly name of the Reservation
    :type display_name: str
    :param applied_scope_type: Possible values include: 'Single', 'Shared'
    :type applied_scope_type: str or
     ~azure.mgmt.reservations.models.AppliedScopeType
    :param applied_scopes:
    :type applied_scopes: list[str]
    :param renew:
    :type renew: bool
    :param reserved_resource_properties: Properties specific to each reserved
     resource type. Not required if not applicable.
    :type reserved_resource_properties:
     ~azure.mgmt.reservations.models.PurchaseRequestPropertiesReservedResourceProperties
    """

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'SkuName'},
        'location': {'key': 'location', 'type': 'str'},
        'reserved_resource_type': {'key': 'properties.reservedResourceType', 'type': 'str'},
        'billing_scope_id': {'key': 'properties.billingScopeId', 'type': 'str'},
        'term': {'key': 'properties.term', 'type': 'str'},
        'billing_plan': {'key': 'properties.billingPlan', 'type': 'str'},
        'quantity': {'key': 'properties.quantity', 'type': 'int'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'applied_scope_type': {'key': 'properties.appliedScopeType', 'type': 'str'},
        'applied_scopes': {'key': 'properties.appliedScopes', 'type': '[str]'},
        'renew': {'key': 'properties.renew', 'type': 'bool'},
        'reserved_resource_properties': {'key': 'properties.reservedResourceProperties', 'type': 'PurchaseRequestPropertiesReservedResourceProperties'},
    }

    def __init__(self, **kwargs):
        super(PurchaseRequest, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.location = kwargs.get('location', None)
        self.reserved_resource_type = kwargs.get('reserved_resource_type', None)
        self.billing_scope_id = kwargs.get('billing_scope_id', None)
        self.term = kwargs.get('term', None)
        self.billing_plan = kwargs.get('billing_plan', None)
        self.quantity = kwargs.get('quantity', None)
        self.display_name = kwargs.get('display_name', None)
        self.applied_scope_type = kwargs.get('applied_scope_type', None)
        self.applied_scopes = kwargs.get('applied_scopes', None)
        self.renew = kwargs.get('renew', None)
        self.reserved_resource_properties = kwargs.get('reserved_resource_properties', None)


class PurchaseRequestPropertiesReservedResourceProperties(Model):
    """Properties specific to each reserved resource type. Not required if not
    applicable.

    :param instance_flexibility: Possible values include: 'On', 'Off'
    :type instance_flexibility: str or
     ~azure.mgmt.reservations.models.InstanceFlexibility
    """

    _attribute_map = {
        'instance_flexibility': {'key': 'instanceFlexibility', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PurchaseRequestPropertiesReservedResourceProperties, self).__init__(**kwargs)
        self.instance_flexibility = kwargs.get('instance_flexibility', None)


class RenewPropertiesResponse(Model):
    """RenewPropertiesResponse.

    :param purchase_properties:
    :type purchase_properties: ~azure.mgmt.reservations.models.PurchaseRequest
    :param pricing_currency_total: Amount that Microsoft uses for record. Used
     during refund for calculating refund limit. Tax is not included. This is
     locked price 30 days before expiry.
    :type pricing_currency_total:
     ~azure.mgmt.reservations.models.RenewPropertiesResponsePricingCurrencyTotal
    :param billing_currency_total: Currency and amount that customer will be
     charged in customer's local currency for renewal purchase. Tax is not
     included.
    :type billing_currency_total:
     ~azure.mgmt.reservations.models.RenewPropertiesResponseBillingCurrencyTotal
    """

    _attribute_map = {
        'purchase_properties': {'key': 'purchaseProperties', 'type': 'PurchaseRequest'},
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'RenewPropertiesResponsePricingCurrencyTotal'},
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'RenewPropertiesResponseBillingCurrencyTotal'},
    }

    def __init__(self, **kwargs):
        super(RenewPropertiesResponse, self).__init__(**kwargs)
        self.purchase_properties = kwargs.get('purchase_properties', None)
        self.pricing_currency_total = kwargs.get('pricing_currency_total', None)
        self.billing_currency_total = kwargs.get('billing_currency_total', None)


class RenewPropertiesResponseBillingCurrencyTotal(Model):
    """Currency and amount that customer will be charged in customer's local
    currency for renewal purchase. Tax is not included.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(RenewPropertiesResponseBillingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = kwargs.get('currency_code', None)
        self.amount = kwargs.get('amount', None)


class RenewPropertiesResponsePricingCurrencyTotal(Model):
    """Amount that Microsoft uses for record. Used during refund for calculating
    refund limit. Tax is not included. This is locked price 30 days before
    expiry.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(RenewPropertiesResponsePricingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = kwargs.get('currency_code', None)
        self.amount = kwargs.get('amount', None)


class ReservationMergeProperties(Model):
    """ReservationMergeProperties.

    :param merge_destination: Reservation Resource Id Created due to the
     merge. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
    :type merge_destination: str
    :param merge_sources: Resource Ids of the Source Reservation's merged to
     form this Reservation. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
    :type merge_sources: list[str]
    """

    _attribute_map = {
        'merge_destination': {'key': 'mergeDestination', 'type': 'str'},
        'merge_sources': {'key': 'mergeSources', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(ReservationMergeProperties, self).__init__(**kwargs)
        self.merge_destination = kwargs.get('merge_destination', None)
        self.merge_sources = kwargs.get('merge_sources', None)


class ReservationOrderBillingPlanInformation(Model):
    """Information describing the type of billing plan for this reservation.

    :param pricing_currency_total: Amount of money to be paid for the Order.
     Tax is not included.
    :type pricing_currency_total: ~azure.mgmt.reservations.models.Price
    :param start_date: Date when the billing plan has started.
    :type start_date: date
    :param next_payment_due_date: For recurring billing plans, indicates the
     date when next payment will be processed. Null when total is paid off.
    :type next_payment_due_date: date
    :param transactions:
    :type transactions: list[~azure.mgmt.reservations.models.PaymentDetail]
    """

    _attribute_map = {
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'Price'},
        'start_date': {'key': 'startDate', 'type': 'date'},
        'next_payment_due_date': {'key': 'nextPaymentDueDate', 'type': 'date'},
        'transactions': {'key': 'transactions', 'type': '[PaymentDetail]'},
    }

    def __init__(self, **kwargs):
        super(ReservationOrderBillingPlanInformation, self).__init__(**kwargs)
        self.pricing_currency_total = kwargs.get('pricing_currency_total', None)
        self.start_date = kwargs.get('start_date', None)
        self.next_payment_due_date = kwargs.get('next_payment_due_date', None)
        self.transactions = kwargs.get('transactions', None)


class ReservationOrderResponse(Model):
    """ReservationOrderResponse.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param etag:
    :type etag: int
    :ivar id: Identifier of the reservation
    :vartype id: str
    :ivar name: Name of the reservation
    :vartype name: str
    :param display_name: Friendly name for user to easily identified the
     reservation.
    :type display_name: str
    :param request_date_time: This is the DateTime when the reservation was
     initially requested for purchase.
    :type request_date_time: datetime
    :param created_date_time: This is the DateTime when the reservation was
     created.
    :type created_date_time: datetime
    :param expiry_date: This is the date when the Reservation will expire.
    :type expiry_date: date
    :param original_quantity:
    :type original_quantity: int
    :param term: Possible values include: 'P1Y', 'P3Y'
    :type term: str or ~azure.mgmt.reservations.models.ReservationTerm
    :param provisioning_state: Current state of the reservation.
    :type provisioning_state: str
    :param billing_plan: Possible values include: 'Upfront', 'Monthly'
    :type billing_plan: str or
     ~azure.mgmt.reservations.models.ReservationBillingPlan
    :param plan_information:
    :type plan_information:
     ~azure.mgmt.reservations.models.ReservationOrderBillingPlanInformation
    :param reservations:
    :type reservations:
     list[~azure.mgmt.reservations.models.ReservationResponse]
    :ivar type: Type of resource. "Microsoft.Capacity/reservations"
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'etag': {'key': 'etag', 'type': 'int'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'request_date_time': {'key': 'properties.requestDateTime', 'type': 'iso-8601'},
        'created_date_time': {'key': 'properties.createdDateTime', 'type': 'iso-8601'},
        'expiry_date': {'key': 'properties.expiryDate', 'type': 'date'},
        'original_quantity': {'key': 'properties.originalQuantity', 'type': 'int'},
        'term': {'key': 'properties.term', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'billing_plan': {'key': 'properties.billingPlan', 'type': 'str'},
        'plan_information': {'key': 'properties.planInformation', 'type': 'ReservationOrderBillingPlanInformation'},
        'reservations': {'key': 'properties.reservations', 'type': '[ReservationResponse]'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReservationOrderResponse, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.id = None
        self.name = None
        self.display_name = kwargs.get('display_name', None)
        self.request_date_time = kwargs.get('request_date_time', None)
        self.created_date_time = kwargs.get('created_date_time', None)
        self.expiry_date = kwargs.get('expiry_date', None)
        self.original_quantity = kwargs.get('original_quantity', None)
        self.term = kwargs.get('term', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.billing_plan = kwargs.get('billing_plan', None)
        self.plan_information = kwargs.get('plan_information', None)
        self.reservations = kwargs.get('reservations', None)
        self.type = None


class ReservationProperties(Model):
    """ReservationProperties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param reserved_resource_type: Possible values include: 'VirtualMachines',
     'SqlDatabases', 'SuseLinux', 'CosmosDb', 'RedHat', 'SqlDataWarehouse',
     'VMwareCloudSimple', 'RedHatOsa'
    :type reserved_resource_type: str or
     ~azure.mgmt.reservations.models.ReservedResourceType
    :param instance_flexibility: Possible values include: 'On', 'Off'
    :type instance_flexibility: str or
     ~azure.mgmt.reservations.models.InstanceFlexibility
    :param display_name: Friendly name for user to easily identify the
     reservation
    :type display_name: str
    :param applied_scopes:
    :type applied_scopes: list[str]
    :param applied_scope_type: Possible values include: 'Single', 'Shared'
    :type applied_scope_type: str or
     ~azure.mgmt.reservations.models.AppliedScopeType
    :param quantity:
    :type quantity: int
    :param provisioning_state: Current state of the reservation.
    :type provisioning_state: str
    :param effective_date_time: DateTime of the Reservation starting when this
     version is effective from.
    :type effective_date_time: datetime
    :ivar last_updated_date_time: DateTime of the last time the Reservation
     was updated.
    :vartype last_updated_date_time: datetime
    :param expiry_date: This is the date when the Reservation will expire.
    :type expiry_date: date
    :param sku_description: Description of the SKU in english.
    :type sku_description: str
    :param extended_status_info:
    :type extended_status_info:
     ~azure.mgmt.reservations.models.ExtendedStatusInfo
    :param billing_plan: Possible values include: 'Upfront', 'Monthly'
    :type billing_plan: str or
     ~azure.mgmt.reservations.models.ReservationBillingPlan
    :param split_properties:
    :type split_properties:
     ~azure.mgmt.reservations.models.ReservationSplitProperties
    :param merge_properties:
    :type merge_properties:
     ~azure.mgmt.reservations.models.ReservationMergeProperties
    :param billing_scope_id:
    :type billing_scope_id: str
    :param renew:
    :type renew: bool
    :param renew_source: Reservation Id of the reservation from which this
     reservation is renewed. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type renew_source: str
    :param renew_destination: Reservation Id of the reservation which is
     purchased because of renew. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type renew_destination: str
    :param renew_properties:
    :type renew_properties:
     ~azure.mgmt.reservations.models.RenewPropertiesResponse
    :param term: Possible values include: 'P1Y', 'P3Y'
    :type term: str or ~azure.mgmt.reservations.models.ReservationTerm
    """

    _validation = {
        'last_updated_date_time': {'readonly': True},
    }

    _attribute_map = {
        'reserved_resource_type': {'key': 'reservedResourceType', 'type': 'str'},
        'instance_flexibility': {'key': 'instanceFlexibility', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'applied_scopes': {'key': 'appliedScopes', 'type': '[str]'},
        'applied_scope_type': {'key': 'appliedScopeType', 'type': 'str'},
        'quantity': {'key': 'quantity', 'type': 'int'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'effective_date_time': {'key': 'effectiveDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'expiry_date': {'key': 'expiryDate', 'type': 'date'},
        'sku_description': {'key': 'skuDescription', 'type': 'str'},
        'extended_status_info': {'key': 'extendedStatusInfo', 'type': 'ExtendedStatusInfo'},
        'billing_plan': {'key': 'billingPlan', 'type': 'str'},
        'split_properties': {'key': 'splitProperties', 'type': 'ReservationSplitProperties'},
        'merge_properties': {'key': 'mergeProperties', 'type': 'ReservationMergeProperties'},
        'billing_scope_id': {'key': 'billingScopeId', 'type': 'str'},
        'renew': {'key': 'renew', 'type': 'bool'},
        'renew_source': {'key': 'renewSource', 'type': 'str'},
        'renew_destination': {'key': 'renewDestination', 'type': 'str'},
        'renew_properties': {'key': 'renewProperties', 'type': 'RenewPropertiesResponse'},
        'term': {'key': 'term', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReservationProperties, self).__init__(**kwargs)
        self.reserved_resource_type = kwargs.get('reserved_resource_type', None)
        self.instance_flexibility = kwargs.get('instance_flexibility', None)
        self.display_name = kwargs.get('display_name', None)
        self.applied_scopes = kwargs.get('applied_scopes', None)
        self.applied_scope_type = kwargs.get('applied_scope_type', None)
        self.quantity = kwargs.get('quantity', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.effective_date_time = kwargs.get('effective_date_time', None)
        self.last_updated_date_time = None
        self.expiry_date = kwargs.get('expiry_date', None)
        self.sku_description = kwargs.get('sku_description', None)
        self.extended_status_info = kwargs.get('extended_status_info', None)
        self.billing_plan = kwargs.get('billing_plan', None)
        self.split_properties = kwargs.get('split_properties', None)
        self.merge_properties = kwargs.get('merge_properties', None)
        self.billing_scope_id = kwargs.get('billing_scope_id', None)
        self.renew = kwargs.get('renew', None)
        self.renew_source = kwargs.get('renew_source', None)
        self.renew_destination = kwargs.get('renew_destination', None)
        self.renew_properties = kwargs.get('renew_properties', None)
        self.term = kwargs.get('term', None)


class ReservationResponse(Model):
    """ReservationResponse.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar location: The Azure Region where the reserved resource lives.
    :vartype location: str
    :param etag:
    :type etag: int
    :ivar id: Identifier of the reservation
    :vartype id: str
    :ivar name: Name of the reservation
    :vartype name: str
    :param sku:
    :type sku: ~azure.mgmt.reservations.models.SkuName
    :param properties:
    :type properties: ~azure.mgmt.reservations.models.ReservationProperties
    :ivar type: Type of resource.
     "Microsoft.Capacity/reservationOrders/reservations"
    :vartype type: str
    """

    _validation = {
        'location': {'readonly': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'int'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SkuName'},
        'properties': {'key': 'properties', 'type': 'ReservationProperties'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReservationResponse, self).__init__(**kwargs)
        self.location = None
        self.etag = kwargs.get('etag', None)
        self.id = None
        self.name = None
        self.sku = kwargs.get('sku', None)
        self.properties = kwargs.get('properties', None)
        self.type = None


class ReservationSplitProperties(Model):
    """ReservationSplitProperties.

    :param split_destinations: List of destination Resource Id that are
     created due to split. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
    :type split_destinations: list[str]
    :param split_source: Resource Id of the Reservation from which this is
     split. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
    :type split_source: str
    """

    _attribute_map = {
        'split_destinations': {'key': 'splitDestinations', 'type': '[str]'},
        'split_source': {'key': 'splitSource', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReservationSplitProperties, self).__init__(**kwargs)
        self.split_destinations = kwargs.get('split_destinations', None)
        self.split_source = kwargs.get('split_source', None)


class ScopeProperties(Model):
    """ScopeProperties.

    :param scope:
    :type scope: str
    :param valid:
    :type valid: bool
    """

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'str'},
        'valid': {'key': 'valid', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ScopeProperties, self).__init__(**kwargs)
        self.scope = kwargs.get('scope', None)
        self.valid = kwargs.get('valid', None)


class SkuName(Model):
    """SkuName.

    :param name:
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SkuName, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class SkuProperty(Model):
    """SkuProperty.

    :param name: An invariant to describe the feature.
    :type name: str
    :param value: An invariant if the feature is measured by quantity.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SkuProperty, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class SkuRestriction(Model):
    """SkuRestriction.

    :param type: The type of restrictions.
    :type type: str
    :param values: The value of restrictions. If the restriction type is set
     to location. This would be different locations where the SKU is
     restricted.
    :type values: list[str]
    :param reason_code: The reason for restriction.
    :type reason_code: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
        'reason_code': {'key': 'reasonCode', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SkuRestriction, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.values = kwargs.get('values', None)
        self.reason_code = kwargs.get('reason_code', None)


class SplitRequest(Model):
    """SplitRequest.

    :param quantities: List of the quantities in the new reservations to
     create.
    :type quantities: list[int]
    :param reservation_id: Resource id of the reservation to be split. Format
     of the resource id should be
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
    :type reservation_id: str
    """

    _attribute_map = {
        'quantities': {'key': 'properties.quantities', 'type': '[int]'},
        'reservation_id': {'key': 'properties.reservationId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SplitRequest, self).__init__(**kwargs)
        self.quantities = kwargs.get('quantities', None)
        self.reservation_id = kwargs.get('reservation_id', None)


class SubscriptionScopeProperties(Model):
    """SubscriptionScopeProperties.

    :param scopes:
    :type scopes: list[~azure.mgmt.reservations.models.ScopeProperties]
    """

    _attribute_map = {
        'scopes': {'key': 'scopes', 'type': '[ScopeProperties]'},
    }

    def __init__(self, **kwargs):
        super(SubscriptionScopeProperties, self).__init__(**kwargs)
        self.scopes = kwargs.get('scopes', None)
