#!/usr/bin/env python
# Generated by jaraco.develop (https://bitbucket.org/jaraco/jaraco.develop)
import sys
import setuptools

with open('README.txt') as readme:
	long_description = readme.read()
with open('CHANGES.txt') as changes:
	long_description += '\n\n' + changes.read()

argparse_req = ['argparse'] if sys.version_info < (2,7) else []

setup_params = dict(
	name='jaraco.packaging',
	use_hg_version=True,
	author="Jason R. Coombs",
	author_email="jaraco@jaraco.com",
	description="tools to supplement packaging Python releases",
	long_description=long_description,
	url="https://bitbucket.org/jaraco/jaraco.packaging",
	packages=setuptools.find_packages(),
	namespace_packages=['jaraco'],
	entry_points={
		'console_scripts': [
			'dependency-tree=jaraco.packaging.depends:tree_cmd',
			'upload-package=jaraco.packaging.cheese:do_upload',
		],
		'distutils.commands': [
			'dependency_tree=jaraco.packaging.depends:DependencyTree',
		],
	},
	zip_safe=False,
	install_requires=[
		'requests',
		'six>=1.4,<2dev',
	] + argparse_req,
	setup_requires=[
		'hgtools',
		'pytest-runner',
	],
	tests_require=[
		'pytest',
	],
)
if __name__ == '__main__':
	setuptools.setup(**setup_params)
