# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models
from .tipos_basico_v4_00 import (
    TAMB,
    TCODUFIBGE,
)

__NAMESPACE__ = "http://www.portalfiscal.inf.br/nfe"

"Serviço Solicitado"
TCONSSTATSERV_XSERV = [
    ("STATUS", "STATUS"),
]


class TconsStatServ(models.AbstractModel):
    "Tipo Pedido de Consulta do Status do Serviço"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tconsstatserv"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TconsStatServ"

    nfe40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    nfe40_cUF = fields.Selection(
        TCODUFIBGE,
        string="Sigla da UF consultada",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    nfe40_xServ = fields.Selection(
        TCONSSTATSERV_XSERV, string="Serviço Solicitado", xsd_required=True
    )

    nfe40_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerConsStatServ"
    )


class TretConsStatServ(models.AbstractModel):
    "Tipo Resultado da Consulta do Status do Serviço"

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "nfe.40.tretconsstatserv"
    _inherit = "spec.mixin.nfe"
    _binding_type = "TretConsStatServ"

    nfe40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    nfe40_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que processou a NF-e",
    )

    nfe40_cStat = fields.Char(
        string="Código do status da mensagem enviada",
        xsd_required=True,
        xsd_type="TStat",
    )

    nfe40_xMotivo = fields.Char(
        string="Descrição literal do status",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do serviço solicitado.",
    )

    nfe40_cUF = fields.Selection(
        TCODUFIBGE,
        string="Código da UF responsável pelo serviço",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    nfe40_dhRecbto = fields.Datetime(
        string="Data e hora do recebimento da consulta",
        xsd_required=True,
        xsd_type="TDateTimeUTC",
        help=(
            "Data e hora do recebimento da consulta no formato AAAA-MM-"
            "DDTHH:MM:SSTZD"
        ),
    )

    nfe40_tMed = fields.Char(
        string="Tempo médio de resposta do serviço",
        xsd_type="TMed",
        help=(
            "Tempo médio de resposta do serviço (em segundos) dos últimos 5 "
            "minutos"
        ),
    )

    nfe40_dhRetorno = fields.Datetime(
        string="AAAA-MM-DDTHH:MM:SSDeve ser preenchida",
        xsd_type="TDateTimeUTC",
        help=(
            "AAAA-MM-DDTHH:MM:SSDeve ser preenchida com data e hora previstas "
            "para o retorno dos serviços prestados."
        ),
    )

    nfe40_xObs = fields.Char(
        string="Campo observação utilizado",
        xsd_type="TMotivo",
        help=(
            "Campo observação utilizado para incluir informações ao "
            "contribuinte"
        ),
    )

    nfe40_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerConsStatServ"
    )
