# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

__NAMESPACE__ = "http://www.portalfiscal.inf.br/mdfe"

"Tipo de Navegação"
AQUAV_TPNAV = [
    ("0", "Interior"),
    ("1", "Cabotagem"),
]

"Tipo da unidade de carga vazia"
INFUNIDCARGAVAZIA_TPUNIDCARGAVAZIA = [
    ("1", "Container"),
    ("2", "ULD"),
    ("3", "Pallet"),
    ("4", "Outros"),
]

"""Tipo da unidade de transporte vazia
    Deve ser preenchido com “1” para Rodoviário Tração do tipo caminhão ou “2” para
    Rodoviário reboque do tipo carreta"""
INFUNIDTRANSPVAZIA_TPUNIDTRANSPVAZIA = [
    ("1", "1"),
    ("2", "2"),
]


class Aquav(models.AbstractModel):
    "Informações do modal Aquaviário"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.aquav"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Aquav"

    mdfe30_irin = fields.Char(
        string="Irin do navio sempre deverá",
        xsd_required=True,
        help="Irin do navio sempre deverá ser informado",
    )

    mdfe30_tpEmb = fields.Char(
        string="Código do tipo de embarcação",
        xsd_required=True,
        help=(
            "Código do tipo de embarcação\nPreencher com código da Tabela de "
            "Tipo de Embarcação definida no Ministério dos Transportes"
        ),
    )

    mdfe30_cEmbar = fields.Char(string="Código da embarcação", xsd_required=True)

    mdfe30_xEmbar = fields.Char(string="Nome da embarcação", xsd_required=True)

    mdfe30_nViag = fields.Char(string="Número da Viagem", xsd_required=True)

    mdfe30_cPrtEmb = fields.Char(
        string="Código do Porto de Embarque",
        xsd_required=True,
        help=(
            "Código do Porto de Embarque\nPreencher de acordo com Tabela de "
            "Portos definida no Ministério dos Transportes"
        ),
    )

    mdfe30_cPrtDest = fields.Char(
        string="Código do Porto de Destino",
        xsd_required=True,
        help=(
            "Código do Porto de Destino\nPreencher de acordo com Tabela de "
            "Portos definida no Ministério dos Transportes"
        ),
    )

    mdfe30_prtTrans = fields.Char(string="Porto de Transbordo")

    mdfe30_tpNav = fields.Selection(
        AQUAV_TPNAV,
        string="Tipo de Navegação",
        help=(
            "Tipo de Navegação\nPreencher com: \n\t\t\t\t\t\t0 - "
            "Interior;\n\t\t\t\t\t\t1 - Cabotagem"
        ),
    )

    mdfe30_infTermCarreg = fields.One2many(
        "mdfe.30.inftermcarreg",
        "mdfe30_infTermCarreg_aquav_id",
        string="Grupo de informações dos terminais",
        help="Grupo de informações dos terminais de carregamento.",
    )

    mdfe30_infTermDescarreg = fields.One2many(
        "mdfe.30.inftermdescarreg",
        "mdfe30_infTermDescarreg_aquav_id",
        string="infTermDescarreg",
        help="Grupo de informações dos terminais de descarregamento.",
    )

    mdfe30_infEmbComb = fields.One2many(
        "mdfe.30.infembcomb",
        "mdfe30_infEmbComb_aquav_id",
        string="Informações das Embarcações do Comboio",
    )

    mdfe30_infUnidCargaVazia = fields.One2many(
        "mdfe.30.infunidcargavazia",
        "mdfe30_infUnidCargaVazia_aquav_id",
        string="Informações das Undades de Carga vazias",
    )

    mdfe30_infUnidTranspVazia = fields.One2many(
        "mdfe.30.infunidtranspvazia",
        "mdfe30_infUnidTranspVazia_aquav_id",
        string="Informações das Undades",
        help="Informações das Undades de Transporte vazias",
    )


class InfTermCarreg(models.AbstractModel):
    "Grupo de informações dos terminais de carregamento."
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.inftermcarreg"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Aquav.InfTermCarreg"

    mdfe30_infTermCarreg_aquav_id = fields.Many2one(
        comodel_name="mdfe.30.aquav", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_cTermCarreg = fields.Char(
        string="Código do Terminal de Carregamento",
        xsd_required=True,
        help=(
            "Código do Terminal de Carregamento\nPreencher de acordo com a "
            "Tabela de Terminais de Carregamento. O código de cada Porto está "
            "definido no Ministério de Transportes."
        ),
    )

    mdfe30_xTermCarreg = fields.Char(
        string="Nome do Terminal de Carregamento", xsd_required=True
    )


class InfTermDescarreg(models.AbstractModel):
    "Grupo de informações dos terminais de descarregamento."
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.inftermdescarreg"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Aquav.InfTermDescarreg"

    mdfe30_infTermDescarreg_aquav_id = fields.Many2one(
        comodel_name="mdfe.30.aquav", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_cTermDescarreg = fields.Char(
        string="Código do Terminal de Descarregamento",
        xsd_required=True,
        help=(
            "Código do Terminal de Descarregamento\nPreencher de acordo com a "
            "Tabela de Terminais de Descarregamento. O código de cada Porto "
            "está definido no Ministério de Transportes."
        ),
    )

    mdfe30_xTermDescarreg = fields.Char(
        string="Nome do Terminal de Descarregamento", xsd_required=True
    )


class InfEmbComb(models.AbstractModel):
    "Informações das Embarcações do Comboio"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infembcomb"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Aquav.InfEmbComb"

    mdfe30_infEmbComb_aquav_id = fields.Many2one(
        comodel_name="mdfe.30.aquav", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_cEmbComb = fields.Char(
        string="Código da embarcação do comboio", xsd_required=True
    )

    mdfe30_xBalsa = fields.Char(string="Identificador da Balsa", xsd_required=True)


class InfUnidCargaVazia(models.AbstractModel):
    "Informações das Undades de Carga vazias"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infunidcargavazia"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Aquav.InfUnidCargaVazia"

    mdfe30_infUnidCargaVazia_aquav_id = fields.Many2one(
        comodel_name="mdfe.30.aquav", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_idUnidCargaVazia = fields.Char(
        string="Identificação da unidades de carga vazia",
        xsd_required=True,
        xsd_type="TContainer",
    )

    mdfe30_tpUnidCargaVazia = fields.Selection(
        INFUNIDCARGAVAZIA_TPUNIDCARGAVAZIA,
        string="Tipo da unidade de carga vazia",
        xsd_required=True,
        help=(
            "Tipo da unidade de carga vazia\n1 - Container; 2 - ULD;3 - "
            "Pallet;4 - Outros;"
        ),
    )


class InfUnidTranspVazia(models.AbstractModel):
    "Informações das Undades de Transporte vazias"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.infunidtranspvazia"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "Aquav.InfUnidTranspVazia"

    mdfe30_infUnidTranspVazia_aquav_id = fields.Many2one(
        comodel_name="mdfe.30.aquav", xsd_implicit=True, ondelete="cascade"
    )
    mdfe30_idUnidTranspVazia = fields.Char(
        string="Identificação da unidades",
        xsd_required=True,
        xsd_type="TContainer",
        help="Identificação da unidades de transporte vazia",
    )

    mdfe30_tpUnidTranspVazia = fields.Selection(
        INFUNIDTRANSPVAZIA_TPUNIDTRANSPVAZIA,
        string="Tipo da unidade de transporte vazia",
        xsd_required=True,
        help=(
            "Tipo da unidade de transporte vazia\nDeve ser preenchido com “1” "
            "para Rodoviário Tração do tipo caminhão ou “2” para Rodoviário "
            "reboque do tipo carreta"
        ),
    )
