# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

from .tipos_geral_mdfe_v3_00 import TAMB

__NAMESPACE__ = "http://www.portalfiscal.inf.br/mdfe"

"Indicador de Compactação da Mensagem de retorno"
TDISTDFE_INDCOMPRET = [
    ("0", "sem compactação"),
    ("1", "compactação padrão gZip"),
]

"Indicador de DF-e solicitados"
TDISTDFE_INDDFE = [
    ("0", "DF-e autorizados pela UF"),
    ("1", "DF-e com carregamento na UF"),
    ("2", "DF-e com descarregamento na UF"),
    ("3", "DF-e com percurso pela UF"),
    ("8", "DF-e carregados  (1), descarregados (2)  e que tiveram percurso na UF (3)"),
    ("9", "Todos DF-e que fazem referência a UF."),
]


class TloteDistDfe(models.AbstractModel):
    "Schema XML de validação da área de dados descompactada"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tlotedistdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TloteDistDfe"

    mdfe30_proc = fields.One2many(
        "mdfe.30.proc", "mdfe30_proc_TLoteDistDFe_id", string="proc"
    )

    mdfe30_versao = fields.Char(string="versao", xsd_required=True, xsd_type="TVerDFe")


class Proc(models.AbstractModel):
    _description = "proc"
    _name = "mdfe.30.proc"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TloteDistDfe.Proc"

    mdfe30_proc_TLoteDistDFe_id = fields.Many2one(
        comodel_name="mdfe.30.tlotedistdfe", xsd_implicit=True, ondelete="cascade"
    )

    mdfe30_schema = fields.Char(
        string="Identificação do Schema XML de validação",
        xsd_required=True,
        xsd_type="xs:string",
        help=(
            "Identificação do Schema XML de validação do proc, Ex. "
            "procMDFe_v1.00.xsd."
        ),
    )

    mdfe30_NSU = fields.Char(
        string="número sequencial único",
        xsd_required=True,
        xsd_type="TNSU",
        help="número sequencial único do Ambiente Autorizador",
    )

    mdfe30_ipTransmissor = fields.Char(string="ipTransmissor", xsd_type="TIPv4")


class TdistDfe(models.AbstractModel):
    """Schema XML de validação da área de dados da mensagem da solicitação de
    distribuição de DF-e"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tdistdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TdistDfe"

    mdfe30_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente: 1",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:  1 - Produção  2 - Homologação",
    )

    mdfe30_verAplic = fields.Char(
        string="Versão do Aplicativo que solicitou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que solicitou a distribuição de DF-e",
    )

    mdfe30_indDFe = fields.Selection(
        TDISTDFE_INDDFE,
        string="Indicador de DF-e solicitados",
        xsd_required=True,
        help=(
            "Indicador de DF-e solicitados: \n0 - DF-e autorizados pela UF; "
            "\n1 - DF-e com carregamento na UF; \n2 – DF-e com descarregamento"
            " na UF;\n3 – DF-e com percurso pela UF; \n8 – DF-e carregados  "
            "(1), descarregados (2)  e que tiveram percurso na UF (3);\n9 - "
            "Todos DF-e que fazem referência a UF."
        ),
    )

    mdfe30_indCompRet = fields.Selection(
        TDISTDFE_INDCOMPRET,
        string="Indicador de Compactação da Mensagem",
        xsd_required=True,
        help=(
            "Indicador de Compactação da Mensagem de retorno:  0 - sem "
            "compactação;  1 - compactação padrão gZip"
        ),
    )

    mdfe30_ultNSU = fields.Char(
        string="último NSU recebido",
        xsd_required=True,
        xsd_type="TNSU",
        help=(
            "último NSU recebido, caso seja informado com zero, o Ambiente "
            "Autorizador tentará localizar o primeiro DF-e existente."
        ),
    )

    mdfe30_versao = fields.Char(string="versao", xsd_required=True, xsd_type="TVerDFe")


class TretDistDfe(models.AbstractModel):
    """Schema XML de validação do lote de retorno de documentos ficais
    eletronicos"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tretdistdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TretDistDfe"

    mdfe30_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente: 1",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:  1 - Produção  2 - Homologação",
    )

    mdfe30_verAplic = fields.Char(
        string="Versão do Aplicativo que atendeu",
        xsd_required=True,
        xsd_type="TVerAplic",
        help=("Versão do Aplicativo que atendeu a pedido de distribuição de DF-e"),
    )

    mdfe30_cStat = fields.Char(
        string="código do status de resultado",
        xsd_required=True,
        xsd_type="TStat",
        help="código do status de resultado da pesquisa",
    )

    mdfe30_xMotivo = fields.Char(
        string="descrição do resultado do pesquisa",
        xsd_required=True,
        xsd_type="TMotivo",
    )

    mdfe30_ultNSU = fields.Char(string="último NSU", xsd_type="TNSU")

    mdfe30_loteDistMDFeComp = fields.Char(
        string="loteDistMDFeComp", choice="tretdistdfe", xsd_type="xs:base64Binary"
    )

    mdfe30_loteDistMDFe = fields.Many2one(
        comodel_name="mdfe.30.tlotedistdfe",
        string="loteDistMDFe",
        choice="tretdistdfe",
        xsd_type="TLoteDistDFe",
    )

    mdfe30_versao = fields.Char(string="versao", xsd_required=True, xsd_type="TVerDFe")
