# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

__NAMESPACE__ = "http://www.portalfiscal.inf.br/mdfe"

"Descrição do Evento - “Inclusao Condutor”"
EVINCCONDUTORMDFE_DESCEVENTO = [
    ("Inclusao Condutor", "Inclusao Condutor"),
]


class EvIncCondutorMdfe(models.AbstractModel):
    "Schema XML de validação do evento de inclusao de condutor 110114"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.evinccondutormdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "EvIncCondutorMdfe"

    mdfe30_descEvento = fields.Selection(
        EVINCCONDUTORMDFE_DESCEVENTO,
        string="Descrição do Evento",
        xsd_required=True,
        help="Descrição do Evento - “Inclusao Condutor”",
    )

    mdfe30_condutor = fields.Many2one(
        comodel_name="mdfe.30.evinccondutormdfe_condutor",
        string="Informações do(s) Condutor(s) do veículo",
        xsd_required=True,
    )


class EvIncCondutorMdfeCondutor(models.AbstractModel):
    "Informações do(s) Condutor(s) do veículo"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.evinccondutormdfe_condutor"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "EvIncCondutorMdfe.Condutor"

    mdfe30_xNome = fields.Char(string="Nome do Condutor", xsd_required=True)

    mdfe30_CPF = fields.Char(
        string="CPF do Condutor", xsd_required=True, xsd_type="TCpf"
    )
