# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models
from .tipos_geral_mdfe_v3_00 import (
    TAMB,
    TCODUFIBGE,
)

__NAMESPACE__ = "http://www.portalfiscal.inf.br/mdfe"


class TconsStatServ(models.AbstractModel):
    "Tipo Pedido de Consulta do Status do Serviço MDFe"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tconsstatserv"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TconsStatServ"

    mdfe30_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    mdfe30_xServ = fields.Char(
        string="Serviço Solicitado", xsd_required=True, xsd_type="TServ"
    )

    mdfe30_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerConsStat"
    )


class TretConsStatServ(models.AbstractModel):
    "Tipo Resultado da Consulta do Status do Serviço MDFe"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tretconsstatserv"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TretConsStatServ"

    mdfe30_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    mdfe30_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        help="Versão do Aplicativo que processou o CT-e",
    )

    mdfe30_cStat = fields.Char(
        string="Código do status da mensagem enviada",
        xsd_required=True,
        xsd_type="TStat",
    )

    mdfe30_xMotivo = fields.Char(
        string="Descrição literal do status",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do serviço solicitado.",
    )

    mdfe30_cUF = fields.Selection(
        TCODUFIBGE,
        string="Código da UF responsável pelo serviço",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    mdfe30_dhRecbto = fields.Datetime(
        string="AAAA-MM-DDTHH:MM:SS TZD", xsd_required=True, xsd_type="TDateTimeUTC"
    )

    mdfe30_tMed = fields.Char(
        string="Tempo médio de resposta do serviço",
        help=(
            "Tempo médio de resposta do serviço (em segundos) dos últimos 5 " "minutos"
        ),
    )

    mdfe30_dhRetorno = fields.Datetime(
        string="AAAA-MM-DDTHH:MM:SS TZD (dhRetorno)",
        xsd_type="TDateTimeUTC",
        help=(
            "AAAA-MM-DDTHH:MM:SS TZD. Deve ser preenchida com data e hora "
            "previstas para o retorno dos serviços prestados."
        ),
    )

    mdfe30_xObs = fields.Char(
        string="Campo observação utilizado",
        help=("Campo observação utilizado para incluir informações ao " "contribuinte"),
    )

    mdfe30_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerConsStat"
    )
