# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

from .mdfe_tipos_basico_v3_00 import TprotMdfe
from .tipos_geral_mdfe_v3_00 import (
    TAMB,
    TCODUFIBGE,
)

__NAMESPACE__ = "http://www.portalfiscal.inf.br/mdfe"


class TconsReciMdfe(models.AbstractModel):
    "Tipo Pedido de Consulta do Recibo do MDF-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tconsrecimdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TconsReciMdfe"

    mdfe30_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    mdfe30_nRec = fields.Char(
        string="Número do Recibo do arquivo",
        xsd_required=True,
        xsd_type="TRec",
        help="Número do Recibo do arquivo a ser consultado",
    )

    mdfe30_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerConsReciMDFe"
    )


class TretConsReciMdfe(models.AbstractModel):
    "Tipo Retorno do Pedido de Consulta do Recibo do MDF-e"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "mdfe.30.tretconsrecimdfe"
    _inherit = "spec.mixin.mdfe"
    _binding_type = "TretConsReciMdfe"

    mdfe30_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    mdfe30_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que processou o MDF-e",
    )

    mdfe30_nRec = fields.Char(
        string="Número do Recibo Consultado", xsd_required=True, xsd_type="TRec"
    )

    mdfe30_cStat = fields.Char(
        string="código do status do retorno da consulta",
        xsd_required=True,
        xsd_type="TStat",
    )

    mdfe30_xMotivo = fields.Char(
        string="Descrição literal do status",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do do retorno da consulta.",
    )

    mdfe30_cUF = fields.Selection(
        TCODUFIBGE,
        string="Idntificação da UF",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    mdfe30_protMDFe = fields.Many2one(
        comodel_name="mdfe.30.tprotmdfe",
        string="Resultado do processamento do MDF-e",
        xsd_type="TProtMDFe",
    )

    mdfe30_versao = fields.Char(
        string="versao", xsd_required=True, xsd_type="TVerConsReciMDFe"
    )
