# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models

from .tipos_geral_cte_v4_00 import TUF

__NAMESPACE__ = "http://www.portalfiscal.inf.br/cte"

"Tipo de Tráfego"
FERROV_TPTRAF = [
    ("0", "Próprio"),
    ("1", "Mútuo"),
    ("2", "Rodoferroviário"),
    ("3", "Rodoviário."),
]

"Ferrovia Emitente do CTe"
TRAFMUT_FERREMI = [
    ("1", "Ferrovia de origem"),
    ("2", "Ferrovia de destino"),
]

"Responsável pelo Faturamento"
TRAFMUT_RESPFAT = [
    ("1", "Ferrovia de origem"),
    ("2", "Ferrovia de destino"),
]


class TenderFer(models.AbstractModel):
    "Tipo Dados do Endereço"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tenderfer"
    _inherit = "spec.mixin.cte"
    _binding_type = "TenderFer"

    cte40_xLgr = fields.Char(string="Logradouro", xsd_required=True)

    cte40_nro = fields.Char(string="Número")

    cte40_xCpl = fields.Char(string="Complemento")

    cte40_xBairro = fields.Char(string="Bairro")

    cte40_cMun = fields.Char(
        string="Código do município",
        xsd_required=True,
        xsd_type="TCodMunIBGE",
        help=(
            "Código do município\nUtilizar a tabela do "
            "IBGE\n\t\t\t\t\tInformar 9999999 para operações com o exterior."
        ),
    )

    cte40_xMun = fields.Char(
        string="Nome do município",
        xsd_required=True,
        help=("Nome do município\nInformar EXTERIOR para operações com o " "exterior."),
    )

    cte40_CEP = fields.Char(string="CEP", xsd_required=True)

    cte40_UF = fields.Selection(
        TUF,
        string="Sigla da UF",
        xsd_required=True,
        xsd_type="TUf",
        help="Sigla da UF\nInformar EX para operações com o exterior.",
    )


class Ferrov(models.AbstractModel):
    "Informações do modal Ferroviário"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.ferrov"
    _inherit = "spec.mixin.cte"
    _binding_type = "Ferrov"

    cte40_tpTraf = fields.Selection(
        FERROV_TPTRAF,
        string="Tipo de Tráfego",
        xsd_required=True,
        help=(
            "Tipo de Tráfego\nPreencher com:\n\t\t\t\t\t\t0-"
            "Próprio;\n\t\t\t\t\t\t1-Mútuo;\n\t\t\t\t\t\t2-"
            "Rodoferroviário;\n\t\t\t\t\t\t3-Rodoviário."
        ),
    )

    cte40_trafMut = fields.Many2one(
        comodel_name="cte.40.trafmut",
        string="Detalhamento de informações",
        help="Detalhamento de informações para o tráfego mútuo",
    )

    cte40_fluxo = fields.Char(
        string="Fluxo Ferroviário",
        xsd_required=True,
        help=(
            "Fluxo Ferroviário\nTrata-se de um número identificador do "
            "contrato firmado com o cliente"
        ),
    )


class TrafMut(models.AbstractModel):
    "Detalhamento de informações para o tráfego mútuo"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.trafmut"
    _inherit = "spec.mixin.cte"
    _binding_type = "Ferrov.TrafMut"

    cte40_respFat = fields.Selection(
        TRAFMUT_RESPFAT,
        string="Responsável pelo Faturamento",
        xsd_required=True,
        help=(
            "Responsável pelo Faturamento\nPreencher com: "
            "\n\t\t\t\t\t\t\t\t\t1-Ferrovia de origem; "
            "\n\t\t\t\t\t\t\t\t\t2-Ferrovia de destino"
        ),
    )

    cte40_ferrEmi = fields.Selection(
        TRAFMUT_FERREMI,
        string="Ferrovia Emitente do CTe",
        xsd_required=True,
        help=(
            "Ferrovia Emitente do CTe\nPreencher com: "
            "\n\t\t\t\t\t\t\t\t\t1-Ferrovia de origem; "
            "\n\t\t\t\t\t\t\t\t\t2-Ferrovia de destino"
        ),
    )

    cte40_vFrete = fields.Monetary(
        string="Valor do Frete do Tráfego Mútuo",
        xsd_required=True,
        xsd_type="TDec_1302",
        currency_field="brl_currency_id",
    )

    cte40_chCTeFerroOrigem = fields.Char(
        string="Chave de acesso do CT-e emitido",
        xsd_type="TChDFe",
        help="Chave de acesso do CT-e emitido pelo ferrovia de origem",
    )

    cte40_ferroEnv = fields.One2many(
        "cte.40.ferroenv",
        "cte40_ferroEnv_trafMut_id",
        string="Informações das Ferrovias Envolvidas",
    )


class FerroEnv(models.AbstractModel):
    "Informações das Ferrovias Envolvidas"
    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.ferroenv"
    _inherit = "spec.mixin.cte"
    _binding_type = "Ferrov.TrafMut.FerroEnv"

    cte40_ferroEnv_trafMut_id = fields.Many2one(
        comodel_name="cte.40.trafmut", xsd_implicit=True, ondelete="cascade"
    )
    cte40_CNPJ = fields.Char(
        string="Número do CNPJ",
        xsd_required=True,
        xsd_type="TCnpj",
        help=(
            "Número do CNPJ\nInformar o CNPJ da Ferrovia Envolvida. Caso a "
            "Ferrovia envolvida não seja inscrita no CNPJ o campo deverá "
            "preenchido com zeros.\nInformar os zeros não significativos."
        ),
    )

    cte40_cInt = fields.Char(
        string="Código interno da Ferrovia envolvida",
        help="Código interno da Ferrovia envolvida\nUso da transportadora",
    )

    cte40_IE = fields.Char(string="Inscrição Estadual", xsd_type="TIe")

    cte40_xNome = fields.Char(string="Razão Social ou Nome", xsd_required=True)

    cte40_enderFerro = fields.Many2one(
        comodel_name="cte.40.tenderfer",
        string="Dados do endereço da ferrovia envolvida",
        xsd_required=True,
        xsd_type="TEnderFer",
    )
