# Copyright 2023 Akretion - Raphaël Valyi <raphael.valyi@akretion.com>
# License LGPL-3.0 or later (https://www.gnu.org/licenses/lgpl-3.0.en.html).
# Generated by https://github.com/akretion/xsdata-odoo
#
import textwrap
from odoo import fields, models
from .tipos_geral_cte_v4_00 import (
    TAMB,
    TCODUFIBGE,
)

__NAMESPACE__ = "http://www.portalfiscal.inf.br/cte"

PROCEVENTOCTE_VERSAO = [
    ("1.04", "1.04"),
    ("2.00", "2.00"),
    ("3.00", "3.00"),
    ("4.00", "4.00"),
]

PROTCTE_VERSAO = [
    ("1.03", "1.03"),
    ("1.04", "1.04"),
    ("2.00", "2.00"),
    ("3.00", "3.00"),
    ("4.00", "4.00"),
]


class TconsSitCte(models.AbstractModel):
    """Tipo Pedido de Consulta da Situação Atual do Conhecimento de Transporte
    eletrônico"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tconssitcte"
    _inherit = "spec.mixin.cte"
    _binding_type = "TconsSitCte"

    cte40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    cte40_xServ = fields.Char(
        string="Serviço Solicitado", xsd_required=True, xsd_type="TServ"
    )

    cte40_chCTe = fields.Char(
        string="Chaves de acesso da CT-e", xsd_required=True, xsd_type="TChDFe"
    )

    cte40_versao = fields.Char(string="versao", xsd_required=True)


class TretConsSitCte(models.AbstractModel):
    """Tipo Retorno de Pedido de Consulta da Situação Atual do Conhecimento de
    Transporte eletrônico"""

    _description = textwrap.dedent("    %s" % (__doc__,))
    _name = "cte.40.tretconssitcte"
    _inherit = "spec.mixin.cte"
    _binding_type = "TretConsSitCte"

    cte40_tpAmb = fields.Selection(
        TAMB,
        string="Identificação do Ambiente",
        xsd_required=True,
        xsd_type="TAmb",
        help="Identificação do Ambiente:\n1 - Produção\n2 - Homologação",
    )

    cte40_verAplic = fields.Char(
        string="Versão do Aplicativo que processou",
        xsd_required=True,
        xsd_type="TVerAplic",
        help="Versão do Aplicativo que processou o CT-e",
    )

    cte40_cStat = fields.Char(
        string="Código do status da mensagem enviada",
        xsd_required=True,
        xsd_type="TStat",
    )

    cte40_xMotivo = fields.Char(
        string="Descrição literal do status",
        xsd_required=True,
        xsd_type="TMotivo",
        help="Descrição literal do status do serviço solicitado.",
    )

    cte40_cUF = fields.Selection(
        TCODUFIBGE,
        string="código da UF de atendimento",
        xsd_required=True,
        xsd_type="TCodUfIBGE",
    )

    cte40_protCTe = fields.Many2one(comodel_name="cte.40.protcte", string="protCTe")

    cte40_procEventoCTe = fields.One2many(
        "cte.40.proceventocte",
        "cte40_procEventoCTe_TRetConsSitCTe_id",
        string="procEventoCTe",
    )

    cte40_versao = fields.Char(string="versao", xsd_required=True)


class ProtCte(models.AbstractModel):
    _description = "protCTe"
    _name = "cte.40.protcte"
    _inherit = "spec.mixin.cte"
    _binding_type = "TretConsSitCte.ProtCte"

    cte40_versao = fields.Selection(PROTCTE_VERSAO, string="versao", xsd_required=True)


class ProcEventoCte(models.AbstractModel):
    _description = "procEventoCTe"
    _name = "cte.40.proceventocte"
    _inherit = "spec.mixin.cte"
    _binding_type = "TretConsSitCte.ProcEventoCte"

    cte40_procEventoCTe_TRetConsSitCTe_id = fields.Many2one(
        comodel_name="cte.40.tretconssitcte", xsd_implicit=True, ondelete="cascade"
    )

    cte40_versao = fields.Selection(
        PROCEVENTOCTE_VERSAO, string="versao", xsd_required=True
    )
