# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class ArmIdentity(msrest.serialization.Model):
    """ArmIdentity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: Principal Id.
    :vartype principal_id: str
    :ivar tenant_id: Tenant Id.
    :vartype tenant_id: str
    :param type: The type of identity used for the resource. The type 'SystemAssigned,UserAssigned'
     includes both an implicitly created identity and a set of user assigned identities. The type
     'None' will remove any identities from the service. Possible values include: "SystemAssigned",
     "UserAssigned", "SystemAssigned, UserAssigned", "None".
    :type type: str or ~azure.mgmt.iothub.v2021_03_03_preview.models.ResourceIdentityType
    :param user_assigned_identities: Dictionary of :code:`<ArmUserIdentity>`.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.iothub.v2021_03_03_preview.models.ArmUserIdentity]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{ArmUserIdentity}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArmIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class ArmUserIdentity(msrest.serialization.Model):
    """ArmUserIdentity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id:
    :vartype principal_id: str
    :ivar client_id:
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArmUserIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class CertificateBodyDescription(msrest.serialization.Model):
    """The JSON-serialized X509 Certificate.

    :param certificate: base-64 representation of the X509 leaf certificate .cer file or just .pem
     file content.
    :type certificate: str
    """

    _attribute_map = {
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateBodyDescription, self).__init__(**kwargs)
        self.certificate = kwargs.get('certificate', None)


class CertificateDescription(msrest.serialization.Model):
    """The X509 Certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param properties: The description of an X509 CA Certificate.
    :type properties: ~azure.mgmt.iothub.v2021_03_03_preview.models.CertificateProperties
    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The name of the certificate.
    :vartype name: str
    :ivar etag: The entity tag.
    :vartype etag: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CertificateProperties'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateDescription, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.id = None
        self.name = None
        self.etag = None
        self.type = None


class CertificateListDescription(msrest.serialization.Model):
    """The JSON-serialized array of Certificate objects.

    :param value: The array of Certificate objects.
    :type value: list[~azure.mgmt.iothub.v2021_03_03_preview.models.CertificateDescription]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CertificateDescription]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateListDescription, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class CertificateProperties(msrest.serialization.Model):
    """The description of an X509 CA Certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subject: The certificate's subject name.
    :vartype subject: str
    :ivar expiry: The certificate's expiration date and time.
    :vartype expiry: ~datetime.datetime
    :ivar thumbprint: The certificate's thumbprint.
    :vartype thumbprint: str
    :ivar is_verified: Determines whether certificate has been verified.
    :vartype is_verified: bool
    :ivar created: The certificate's create date and time.
    :vartype created: ~datetime.datetime
    :ivar updated: The certificate's last update date and time.
    :vartype updated: ~datetime.datetime
    :param certificate: The certificate content.
    :type certificate: str
    """

    _validation = {
        'subject': {'readonly': True},
        'expiry': {'readonly': True},
        'thumbprint': {'readonly': True},
        'is_verified': {'readonly': True},
        'created': {'readonly': True},
        'updated': {'readonly': True},
    }

    _attribute_map = {
        'subject': {'key': 'subject', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'rfc-1123'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'is_verified': {'key': 'isVerified', 'type': 'bool'},
        'created': {'key': 'created', 'type': 'rfc-1123'},
        'updated': {'key': 'updated', 'type': 'rfc-1123'},
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateProperties, self).__init__(**kwargs)
        self.subject = None
        self.expiry = None
        self.thumbprint = None
        self.is_verified = None
        self.created = None
        self.updated = None
        self.certificate = kwargs.get('certificate', None)


class CertificatePropertiesWithNonce(msrest.serialization.Model):
    """The description of an X509 CA Certificate including the challenge nonce issued for the Proof-Of-Possession flow.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subject: The certificate's subject name.
    :vartype subject: str
    :ivar expiry: The certificate's expiration date and time.
    :vartype expiry: ~datetime.datetime
    :ivar thumbprint: The certificate's thumbprint.
    :vartype thumbprint: str
    :ivar is_verified: Determines whether certificate has been verified.
    :vartype is_verified: bool
    :ivar created: The certificate's create date and time.
    :vartype created: ~datetime.datetime
    :ivar updated: The certificate's last update date and time.
    :vartype updated: ~datetime.datetime
    :ivar verification_code: The certificate's verification code that will be used for proof of
     possession.
    :vartype verification_code: str
    :ivar certificate: The certificate content.
    :vartype certificate: str
    """

    _validation = {
        'subject': {'readonly': True},
        'expiry': {'readonly': True},
        'thumbprint': {'readonly': True},
        'is_verified': {'readonly': True},
        'created': {'readonly': True},
        'updated': {'readonly': True},
        'verification_code': {'readonly': True},
        'certificate': {'readonly': True},
    }

    _attribute_map = {
        'subject': {'key': 'subject', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'rfc-1123'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'is_verified': {'key': 'isVerified', 'type': 'bool'},
        'created': {'key': 'created', 'type': 'rfc-1123'},
        'updated': {'key': 'updated', 'type': 'rfc-1123'},
        'verification_code': {'key': 'verificationCode', 'type': 'str'},
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificatePropertiesWithNonce, self).__init__(**kwargs)
        self.subject = None
        self.expiry = None
        self.thumbprint = None
        self.is_verified = None
        self.created = None
        self.updated = None
        self.verification_code = None
        self.certificate = None


class CertificateVerificationDescription(msrest.serialization.Model):
    """The JSON-serialized leaf certificate.

    :param certificate: base-64 representation of X509 certificate .cer file or just .pem file
     content.
    :type certificate: str
    """

    _attribute_map = {
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateVerificationDescription, self).__init__(**kwargs)
        self.certificate = kwargs.get('certificate', None)


class CertificateWithNonceDescription(msrest.serialization.Model):
    """The X509 Certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param properties: The description of an X509 CA Certificate including the challenge nonce
     issued for the Proof-Of-Possession flow.
    :type properties: ~azure.mgmt.iothub.v2021_03_03_preview.models.CertificatePropertiesWithNonce
    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The name of the certificate.
    :vartype name: str
    :ivar etag: The entity tag.
    :vartype etag: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CertificatePropertiesWithNonce'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateWithNonceDescription, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.id = None
        self.name = None
        self.etag = None
        self.type = None


class CloudToDeviceProperties(msrest.serialization.Model):
    """The IoT hub cloud-to-device messaging properties.

    :param max_delivery_count: The max delivery count for cloud-to-device messages in the device
     queue. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :type max_delivery_count: int
    :param default_ttl_as_iso8601: The default time to live for cloud-to-device messages in the
     device queue. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :type default_ttl_as_iso8601: ~datetime.timedelta
    :param feedback: The properties of the feedback queue for cloud-to-device messages.
    :type feedback: ~azure.mgmt.iothub.v2021_03_03_preview.models.FeedbackProperties
    """

    _validation = {
        'max_delivery_count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'max_delivery_count': {'key': 'maxDeliveryCount', 'type': 'int'},
        'default_ttl_as_iso8601': {'key': 'defaultTtlAsIso8601', 'type': 'duration'},
        'feedback': {'key': 'feedback', 'type': 'FeedbackProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudToDeviceProperties, self).__init__(**kwargs)
        self.max_delivery_count = kwargs.get('max_delivery_count', None)
        self.default_ttl_as_iso8601 = kwargs.get('default_ttl_as_iso8601', None)
        self.feedback = kwargs.get('feedback', None)


class EncryptionPropertiesDescription(msrest.serialization.Model):
    """The encryption properties for the IoT hub.

    :param key_source: The source of the key.
    :type key_source: str
    :param key_vault_properties: The properties of the KeyVault key.
    :type key_vault_properties:
     list[~azure.mgmt.iothub.v2021_03_03_preview.models.KeyVaultKeyProperties]
    """

    _attribute_map = {
        'key_source': {'key': 'keySource', 'type': 'str'},
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': '[KeyVaultKeyProperties]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncryptionPropertiesDescription, self).__init__(**kwargs)
        self.key_source = kwargs.get('key_source', None)
        self.key_vault_properties = kwargs.get('key_vault_properties', None)


class EndpointHealthData(msrest.serialization.Model):
    """The health data for an endpoint.

    :param endpoint_id: Id of the endpoint.
    :type endpoint_id: str
    :param health_status: Health statuses have following meanings. The 'healthy' status shows that
     the endpoint is accepting messages as expected. The 'unhealthy' status shows that the endpoint
     is not accepting messages as expected and IoT Hub is retrying to send data to this endpoint.
     The status of an unhealthy endpoint will be updated to healthy when IoT Hub has established an
     eventually consistent state of health. The 'dead' status shows that the endpoint is not
     accepting messages, after IoT Hub retried sending messages for the retrial period. See IoT Hub
     metrics to identify errors and monitor issues with endpoints. The 'unknown' status shows that
     the IoT Hub has not established a connection with the endpoint. No messages have been delivered
     to or rejected from this endpoint. Possible values include: "unknown", "healthy", "degraded",
     "unhealthy", "dead".
    :type health_status: str or ~azure.mgmt.iothub.v2021_03_03_preview.models.EndpointHealthStatus
    :param last_known_error: Last error obtained when a message failed to be delivered to iot hub.
    :type last_known_error: str
    :param last_known_error_time: Time at which the last known error occurred.
    :type last_known_error_time: ~datetime.datetime
    :param last_successful_send_attempt_time: Last time iot hub successfully sent a message to the
     endpoint.
    :type last_successful_send_attempt_time: ~datetime.datetime
    :param last_send_attempt_time: Last time iot hub tried to send a message to the endpoint.
    :type last_send_attempt_time: ~datetime.datetime
    """

    _attribute_map = {
        'endpoint_id': {'key': 'endpointId', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
        'last_known_error': {'key': 'lastKnownError', 'type': 'str'},
        'last_known_error_time': {'key': 'lastKnownErrorTime', 'type': 'rfc-1123'},
        'last_successful_send_attempt_time': {'key': 'lastSuccessfulSendAttemptTime', 'type': 'rfc-1123'},
        'last_send_attempt_time': {'key': 'lastSendAttemptTime', 'type': 'rfc-1123'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EndpointHealthData, self).__init__(**kwargs)
        self.endpoint_id = kwargs.get('endpoint_id', None)
        self.health_status = kwargs.get('health_status', None)
        self.last_known_error = kwargs.get('last_known_error', None)
        self.last_known_error_time = kwargs.get('last_known_error_time', None)
        self.last_successful_send_attempt_time = kwargs.get('last_successful_send_attempt_time', None)
        self.last_send_attempt_time = kwargs.get('last_send_attempt_time', None)


class EndpointHealthDataListResult(msrest.serialization.Model):
    """The JSON-serialized array of EndpointHealthData objects with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: JSON-serialized array of Endpoint health data.
    :type value: list[~azure.mgmt.iothub.v2021_03_03_preview.models.EndpointHealthData]
    :ivar next_link: Link to more results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EndpointHealthData]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EndpointHealthDataListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class EnrichmentProperties(msrest.serialization.Model):
    """The properties of an enrichment that your IoT hub applies to messages delivered to endpoints.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. The key or name for the enrichment property.
    :type key: str
    :param value: Required. The value for the enrichment property.
    :type value: str
    :param endpoint_names: Required. The list of endpoints for which the enrichment is applied to
     the message.
    :type endpoint_names: list[str]
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
        'endpoint_names': {'required': True, 'min_items': 1},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'endpoint_names': {'key': 'endpointNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnrichmentProperties, self).__init__(**kwargs)
        self.key = kwargs['key']
        self.value = kwargs['value']
        self.endpoint_names = kwargs['endpoint_names']


class ErrorDetails(msrest.serialization.Model):
    """Error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar http_status_code: The HTTP status code.
    :vartype http_status_code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar details: The error details.
    :vartype details: str
    """

    _validation = {
        'code': {'readonly': True},
        'http_status_code': {'readonly': True},
        'message': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'http_status_code': {'key': 'httpStatusCode', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = None
        self.http_status_code = None
        self.message = None
        self.details = None


class EventHubConsumerGroupBodyDescription(msrest.serialization.Model):
    """The EventHub consumer group.

    :param properties: The EventHub consumer group name.
    :type properties: ~azure.mgmt.iothub.v2021_03_03_preview.models.EventHubConsumerGroupName
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'EventHubConsumerGroupName'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventHubConsumerGroupBodyDescription, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class EventHubConsumerGroupInfo(msrest.serialization.Model):
    """The properties of the EventHubConsumerGroupInfo object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param properties: The tags.
    :type properties: dict[str, str]
    :ivar id: The Event Hub-compatible consumer group identifier.
    :vartype id: str
    :ivar name: The Event Hub-compatible consumer group name.
    :vartype name: str
    :ivar type: the resource type.
    :vartype type: str
    :ivar etag: The etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': '{str}'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventHubConsumerGroupInfo, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.id = None
        self.name = None
        self.type = None
        self.etag = None


class EventHubConsumerGroupName(msrest.serialization.Model):
    """The EventHub consumer group name.

    :param name: EventHub consumer group name.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventHubConsumerGroupName, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class EventHubConsumerGroupsListResult(msrest.serialization.Model):
    """The JSON-serialized array of Event Hub-compatible consumer group names with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of consumer groups objects.
    :type value: list[~azure.mgmt.iothub.v2021_03_03_preview.models.EventHubConsumerGroupInfo]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EventHubConsumerGroupInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventHubConsumerGroupsListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class EventHubProperties(msrest.serialization.Model):
    """The properties of the provisioned Event Hub-compatible endpoint used by the IoT hub.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param retention_time_in_days: The retention time for device-to-cloud messages in days. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
    :type retention_time_in_days: long
    :param partition_count: The number of partitions for receiving device-to-cloud messages in the
     Event Hub-compatible endpoint. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
    :type partition_count: int
    :ivar partition_ids: The partition ids in the Event Hub-compatible endpoint.
    :vartype partition_ids: list[str]
    :ivar path: The Event Hub-compatible name.
    :vartype path: str
    :ivar endpoint: The Event Hub-compatible endpoint.
    :vartype endpoint: str
    """

    _validation = {
        'partition_ids': {'readonly': True},
        'path': {'readonly': True},
        'endpoint': {'readonly': True},
    }

    _attribute_map = {
        'retention_time_in_days': {'key': 'retentionTimeInDays', 'type': 'long'},
        'partition_count': {'key': 'partitionCount', 'type': 'int'},
        'partition_ids': {'key': 'partitionIds', 'type': '[str]'},
        'path': {'key': 'path', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventHubProperties, self).__init__(**kwargs)
        self.retention_time_in_days = kwargs.get('retention_time_in_days', None)
        self.partition_count = kwargs.get('partition_count', None)
        self.partition_ids = None
        self.path = None
        self.endpoint = None


class ExportDevicesRequest(msrest.serialization.Model):
    """Use to provide parameters when requesting an export of all devices in the IoT hub.

    All required parameters must be populated in order to send to Azure.

    :param export_blob_container_uri: Required. The export blob container URI.
    :type export_blob_container_uri: str
    :param exclude_keys: Required. The value indicating whether keys should be excluded during
     export.
    :type exclude_keys: bool
    :param export_blob_name: The name of the blob that will be created in the provided output blob
     container. This blob will contain the exported device registry information for the IoT Hub.
    :type export_blob_name: str
    :param authentication_type: Specifies authentication type being used for connecting to the
     storage account. Possible values include: "keyBased", "identityBased".
    :type authentication_type: str or
     ~azure.mgmt.iothub.v2021_03_03_preview.models.AuthenticationType
    :param identity: Managed identity properties of storage endpoint for export devices.
    :type identity: ~azure.mgmt.iothub.v2021_03_03_preview.models.ManagedIdentity
    """

    _validation = {
        'export_blob_container_uri': {'required': True},
        'exclude_keys': {'required': True},
    }

    _attribute_map = {
        'export_blob_container_uri': {'key': 'exportBlobContainerUri', 'type': 'str'},
        'exclude_keys': {'key': 'excludeKeys', 'type': 'bool'},
        'export_blob_name': {'key': 'exportBlobName', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedIdentity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExportDevicesRequest, self).__init__(**kwargs)
        self.export_blob_container_uri = kwargs['export_blob_container_uri']
        self.exclude_keys = kwargs['exclude_keys']
        self.export_blob_name = kwargs.get('export_blob_name', None)
        self.authentication_type = kwargs.get('authentication_type', None)
        self.identity = kwargs.get('identity', None)


class FailoverInput(msrest.serialization.Model):
    """Use to provide failover region when requesting manual Failover for a hub.

    All required parameters must be populated in order to send to Azure.

    :param failover_region: Required. Region the hub will be failed over to.
    :type failover_region: str
    """

    _validation = {
        'failover_region': {'required': True},
    }

    _attribute_map = {
        'failover_region': {'key': 'failoverRegion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FailoverInput, self).__init__(**kwargs)
        self.failover_region = kwargs['failover_region']


class FallbackRouteProperties(msrest.serialization.Model):
    """The properties of the fallback route. IoT Hub uses these properties when it routes messages to the fallback endpoint.

    All required parameters must be populated in order to send to Azure.

    :param name: The name of the route. The name can only include alphanumeric characters, periods,
     underscores, hyphens, has a maximum length of 64 characters, and must be unique.
    :type name: str
    :param source: Required. The source to which the routing rule is to be applied to. For example,
     DeviceMessages. Possible values include: "Invalid", "DeviceMessages", "TwinChangeEvents",
     "DeviceLifecycleEvents", "DeviceJobLifecycleEvents", "DigitalTwinChangeEvents",
     "DeviceConnectionStateEvents".
    :type source: str or ~azure.mgmt.iothub.v2021_03_03_preview.models.RoutingSource
    :param condition: The condition which is evaluated in order to apply the fallback route. If the
     condition is not provided it will evaluate to true by default. For grammar, See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language.
    :type condition: str
    :param endpoint_names: Required. The list of endpoints to which the messages that satisfy the
     condition are routed to. Currently only 1 endpoint is allowed.
    :type endpoint_names: list[str]
    :param is_enabled: Required. Used to specify whether the fallback route is enabled.
    :type is_enabled: bool
    """

    _validation = {
        'source': {'required': True},
        'endpoint_names': {'required': True, 'max_items': 1, 'min_items': 1},
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'condition': {'key': 'condition', 'type': 'str'},
        'endpoint_names': {'key': 'endpointNames', 'type': '[str]'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FallbackRouteProperties, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.source = kwargs['source']
        self.condition = kwargs.get('condition', None)
        self.endpoint_names = kwargs['endpoint_names']
        self.is_enabled = kwargs['is_enabled']


class FeedbackProperties(msrest.serialization.Model):
    """The properties of the feedback queue for cloud-to-device messages.

    :param lock_duration_as_iso8601: The lock duration for the feedback queue. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :type lock_duration_as_iso8601: ~datetime.timedelta
    :param ttl_as_iso8601: The period of time for which a message is available to consume before it
     is expired by the IoT hub. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :type ttl_as_iso8601: ~datetime.timedelta
    :param max_delivery_count: The number of times the IoT hub attempts to deliver a message on the
     feedback queue. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :type max_delivery_count: int
    """

    _validation = {
        'max_delivery_count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'lock_duration_as_iso8601': {'key': 'lockDurationAsIso8601', 'type': 'duration'},
        'ttl_as_iso8601': {'key': 'ttlAsIso8601', 'type': 'duration'},
        'max_delivery_count': {'key': 'maxDeliveryCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FeedbackProperties, self).__init__(**kwargs)
        self.lock_duration_as_iso8601 = kwargs.get('lock_duration_as_iso8601', None)
        self.ttl_as_iso8601 = kwargs.get('ttl_as_iso8601', None)
        self.max_delivery_count = kwargs.get('max_delivery_count', None)


class GroupIdInformation(msrest.serialization.Model):
    """The group information for creating a private endpoint on an IotHub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param properties: Required. The properties for a group information object.
    :type properties: ~azure.mgmt.iothub.v2021_03_03_preview.models.GroupIdInformationProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'GroupIdInformationProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GroupIdInformation, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = kwargs['properties']


class GroupIdInformationProperties(msrest.serialization.Model):
    """The properties for a group information object.

    :param group_id: The group id.
    :type group_id: str
    :param required_members: The required members for a specific group id.
    :type required_members: list[str]
    :param required_zone_names: The required DNS zones for a specific group id.
    :type required_zone_names: list[str]
    """

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GroupIdInformationProperties, self).__init__(**kwargs)
        self.group_id = kwargs.get('group_id', None)
        self.required_members = kwargs.get('required_members', None)
        self.required_zone_names = kwargs.get('required_zone_names', None)


class ImportDevicesRequest(msrest.serialization.Model):
    """Use to provide parameters when requesting an import of all devices in the hub.

    All required parameters must be populated in order to send to Azure.

    :param input_blob_container_uri: Required. The input blob container URI.
    :type input_blob_container_uri: str
    :param output_blob_container_uri: Required. The output blob container URI.
    :type output_blob_container_uri: str
    :param input_blob_name: The blob name to be used when importing from the provided input blob
     container.
    :type input_blob_name: str
    :param output_blob_name: The blob name to use for storing the status of the import job.
    :type output_blob_name: str
    :param authentication_type: Specifies authentication type being used for connecting to the
     storage account. Possible values include: "keyBased", "identityBased".
    :type authentication_type: str or
     ~azure.mgmt.iothub.v2021_03_03_preview.models.AuthenticationType
    :param identity: Managed identity properties of storage endpoint for import devices.
    :type identity: ~azure.mgmt.iothub.v2021_03_03_preview.models.ManagedIdentity
    """

    _validation = {
        'input_blob_container_uri': {'required': True},
        'output_blob_container_uri': {'required': True},
    }

    _attribute_map = {
        'input_blob_container_uri': {'key': 'inputBlobContainerUri', 'type': 'str'},
        'output_blob_container_uri': {'key': 'outputBlobContainerUri', 'type': 'str'},
        'input_blob_name': {'key': 'inputBlobName', 'type': 'str'},
        'output_blob_name': {'key': 'outputBlobName', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedIdentity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportDevicesRequest, self).__init__(**kwargs)
        self.input_blob_container_uri = kwargs['input_blob_container_uri']
        self.output_blob_container_uri = kwargs['output_blob_container_uri']
        self.input_blob_name = kwargs.get('input_blob_name', None)
        self.output_blob_name = kwargs.get('output_blob_name', None)
        self.authentication_type = kwargs.get('authentication_type', None)
        self.identity = kwargs.get('identity', None)


class IotHubCapacity(msrest.serialization.Model):
    """IoT Hub capacity information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The minimum number of units.
    :vartype minimum: long
    :ivar maximum: The maximum number of units.
    :vartype maximum: long
    :ivar default: The default number of units.
    :vartype default: long
    :ivar scale_type: The type of the scaling enabled. Possible values include: "Automatic",
     "Manual", "None".
    :vartype scale_type: str or ~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubScaleType
    """

    _validation = {
        'minimum': {'readonly': True, 'maximum': 1, 'minimum': 1},
        'maximum': {'readonly': True},
        'default': {'readonly': True},
        'scale_type': {'readonly': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'long'},
        'maximum': {'key': 'maximum', 'type': 'long'},
        'default': {'key': 'default', 'type': 'long'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubCapacity, self).__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default = None
        self.scale_type = None


class Resource(msrest.serialization.Model):
    """The common properties of an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param location: Required. The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class IotHubDescription(Resource):
    """The description of the IoT hub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param location: Required. The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param etag: The Etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal ETag convention.
    :type etag: str
    :param properties: IotHub properties.
    :type properties: ~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubProperties
    :param sku: Required. IotHub SKU info.
    :type sku: ~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubSkuInfo
    :param identity: The managed identities for the IotHub.
    :type identity: ~azure.mgmt.iothub.v2021_03_03_preview.models.ArmIdentity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'IotHubProperties'},
        'sku': {'key': 'sku', 'type': 'IotHubSkuInfo'},
        'identity': {'key': 'identity', 'type': 'ArmIdentity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubDescription, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.properties = kwargs.get('properties', None)
        self.sku = kwargs['sku']
        self.identity = kwargs.get('identity', None)


class IotHubDescriptionListResult(msrest.serialization.Model):
    """The JSON-serialized array of IotHubDescription objects with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The array of IotHubDescription objects.
    :type value: list[~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubDescription]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IotHubDescription]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubDescriptionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class IotHubLocationDescription(msrest.serialization.Model):
    """Public representation of one of the locations where a resource is provisioned.

    :param location: The name of the Azure region.
    :type location: str
    :param role: The role of the region, can be either primary or secondary. The primary region is
     where the IoT hub is currently provisioned. The secondary region is the Azure disaster recovery
     (DR) paired region and also the region where the IoT hub can failover to. Possible values
     include: "primary", "secondary".
    :type role: str or ~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubReplicaRoleType
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'role': {'key': 'role', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubLocationDescription, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.role = kwargs.get('role', None)


class IotHubNameAvailabilityInfo(msrest.serialization.Model):
    """The properties indicating whether a given IoT hub name is available.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: The value which indicates whether the provided name is available.
    :vartype name_available: bool
    :ivar reason: The reason for unavailability. Possible values include: "Invalid",
     "AlreadyExists".
    :vartype reason: str or
     ~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubNameUnavailabilityReason
    :param message: The detailed reason message.
    :type message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubNameAvailabilityInfo, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = kwargs.get('message', None)


class IotHubProperties(msrest.serialization.Model):
    """The properties of an IoT hub.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param authorization_policies: The shared access policies you can use to secure a connection to
     the IoT hub.
    :type authorization_policies:
     list[~azure.mgmt.iothub.v2021_03_03_preview.models.SharedAccessSignatureAuthorizationRule]
    :param public_network_access: Whether requests from Public Network are allowed. Possible values
     include: "Enabled", "Disabled".
    :type public_network_access: str or
     ~azure.mgmt.iothub.v2021_03_03_preview.models.PublicNetworkAccess
    :param ip_filter_rules: The IP filter rules.
    :type ip_filter_rules: list[~azure.mgmt.iothub.v2021_03_03_preview.models.IpFilterRule]
    :param network_rule_sets: Network Rule Set Properties of IotHub.
    :type network_rule_sets: ~azure.mgmt.iothub.v2021_03_03_preview.models.NetworkRuleSetProperties
    :param min_tls_version: Specifies the minimum TLS version to support for this hub. Can be set
     to "1.2" to have clients that use a TLS version below 1.2 to be rejected.
    :type min_tls_version: str
    :param private_endpoint_connections: Private endpoint connections created on this IotHub.
    :type private_endpoint_connections:
     list[~azure.mgmt.iothub.v2021_03_03_preview.models.PrivateEndpointConnection]
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :ivar state: The hub state.
    :vartype state: str
    :ivar host_name: The name of the host.
    :vartype host_name: str
    :param event_hub_endpoints: The Event Hub-compatible endpoint properties. The only possible
     keys to this dictionary is events. This key has to be present in the dictionary while making
     create or update calls for the IoT hub.
    :type event_hub_endpoints: dict[str,
     ~azure.mgmt.iothub.v2021_03_03_preview.models.EventHubProperties]
    :param routing: The routing related properties of the IoT hub. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging.
    :type routing: ~azure.mgmt.iothub.v2021_03_03_preview.models.RoutingProperties
    :param storage_endpoints: The list of Azure Storage endpoints where you can upload files.
     Currently you can configure only one Azure Storage account and that MUST have its key as
     $default. Specifying more than one storage account causes an error to be thrown. Not specifying
     a value for this property when the enableFileUploadNotifications property is set to True,
     causes an error to be thrown.
    :type storage_endpoints: dict[str,
     ~azure.mgmt.iothub.v2021_03_03_preview.models.StorageEndpointProperties]
    :param messaging_endpoints: The messaging endpoint properties for the file upload notification
     queue.
    :type messaging_endpoints: dict[str,
     ~azure.mgmt.iothub.v2021_03_03_preview.models.MessagingEndpointProperties]
    :param enable_file_upload_notifications: If True, file upload notifications are enabled.
    :type enable_file_upload_notifications: bool
    :param cloud_to_device: The IoT hub cloud-to-device messaging properties.
    :type cloud_to_device: ~azure.mgmt.iothub.v2021_03_03_preview.models.CloudToDeviceProperties
    :param comments: IoT hub comments.
    :type comments: str
    :param device_streams: The device streams properties of iothub.
    :type device_streams:
     ~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubPropertiesDeviceStreams
    :param features: The capabilities and features enabled for the IoT hub. Possible values
     include: "None", "DeviceManagement".
    :type features: str or ~azure.mgmt.iothub.v2021_03_03_preview.models.Capabilities
    :param encryption: The encryption properties for the IoT hub.
    :type encryption: ~azure.mgmt.iothub.v2021_03_03_preview.models.EncryptionPropertiesDescription
    :ivar locations: Primary and secondary location for iot hub.
    :vartype locations:
     list[~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubLocationDescription]
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'state': {'readonly': True},
        'host_name': {'readonly': True},
        'locations': {'readonly': True},
    }

    _attribute_map = {
        'authorization_policies': {'key': 'authorizationPolicies', 'type': '[SharedAccessSignatureAuthorizationRule]'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'ip_filter_rules': {'key': 'ipFilterRules', 'type': '[IpFilterRule]'},
        'network_rule_sets': {'key': 'networkRuleSets', 'type': 'NetworkRuleSetProperties'},
        'min_tls_version': {'key': 'minTlsVersion', 'type': 'str'},
        'private_endpoint_connections': {'key': 'privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'event_hub_endpoints': {'key': 'eventHubEndpoints', 'type': '{EventHubProperties}'},
        'routing': {'key': 'routing', 'type': 'RoutingProperties'},
        'storage_endpoints': {'key': 'storageEndpoints', 'type': '{StorageEndpointProperties}'},
        'messaging_endpoints': {'key': 'messagingEndpoints', 'type': '{MessagingEndpointProperties}'},
        'enable_file_upload_notifications': {'key': 'enableFileUploadNotifications', 'type': 'bool'},
        'cloud_to_device': {'key': 'cloudToDevice', 'type': 'CloudToDeviceProperties'},
        'comments': {'key': 'comments', 'type': 'str'},
        'device_streams': {'key': 'deviceStreams', 'type': 'IotHubPropertiesDeviceStreams'},
        'features': {'key': 'features', 'type': 'str'},
        'encryption': {'key': 'encryption', 'type': 'EncryptionPropertiesDescription'},
        'locations': {'key': 'locations', 'type': '[IotHubLocationDescription]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubProperties, self).__init__(**kwargs)
        self.authorization_policies = kwargs.get('authorization_policies', None)
        self.public_network_access = kwargs.get('public_network_access', None)
        self.ip_filter_rules = kwargs.get('ip_filter_rules', None)
        self.network_rule_sets = kwargs.get('network_rule_sets', None)
        self.min_tls_version = kwargs.get('min_tls_version', None)
        self.private_endpoint_connections = kwargs.get('private_endpoint_connections', None)
        self.provisioning_state = None
        self.state = None
        self.host_name = None
        self.event_hub_endpoints = kwargs.get('event_hub_endpoints', None)
        self.routing = kwargs.get('routing', None)
        self.storage_endpoints = kwargs.get('storage_endpoints', None)
        self.messaging_endpoints = kwargs.get('messaging_endpoints', None)
        self.enable_file_upload_notifications = kwargs.get('enable_file_upload_notifications', None)
        self.cloud_to_device = kwargs.get('cloud_to_device', None)
        self.comments = kwargs.get('comments', None)
        self.device_streams = kwargs.get('device_streams', None)
        self.features = kwargs.get('features', None)
        self.encryption = kwargs.get('encryption', None)
        self.locations = None


class IotHubPropertiesDeviceStreams(msrest.serialization.Model):
    """The device streams properties of iothub.

    :param streaming_endpoints: List of Device Streams Endpoints.
    :type streaming_endpoints: list[str]
    """

    _attribute_map = {
        'streaming_endpoints': {'key': 'streamingEndpoints', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubPropertiesDeviceStreams, self).__init__(**kwargs)
        self.streaming_endpoints = kwargs.get('streaming_endpoints', None)


class IotHubQuotaMetricInfo(msrest.serialization.Model):
    """Quota metrics properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the quota metric.
    :vartype name: str
    :ivar current_value: The current value for the quota metric.
    :vartype current_value: long
    :ivar max_value: The maximum value of the quota metric.
    :vartype max_value: long
    """

    _validation = {
        'name': {'readonly': True},
        'current_value': {'readonly': True},
        'max_value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'max_value': {'key': 'maxValue', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubQuotaMetricInfo, self).__init__(**kwargs)
        self.name = None
        self.current_value = None
        self.max_value = None


class IotHubQuotaMetricInfoListResult(msrest.serialization.Model):
    """The JSON-serialized array of IotHubQuotaMetricInfo objects with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The array of quota metrics objects.
    :type value: list[~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubQuotaMetricInfo]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IotHubQuotaMetricInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubQuotaMetricInfoListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class IotHubSkuDescription(msrest.serialization.Model):
    """SKU properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The type of the resource.
    :vartype resource_type: str
    :param sku: Required. The type of the resource.
    :type sku: ~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubSkuInfo
    :param capacity: Required. IotHub capacity.
    :type capacity: ~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubCapacity
    """

    _validation = {
        'resource_type': {'readonly': True},
        'sku': {'required': True},
        'capacity': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'IotHubSkuInfo'},
        'capacity': {'key': 'capacity', 'type': 'IotHubCapacity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubSkuDescription, self).__init__(**kwargs)
        self.resource_type = None
        self.sku = kwargs['sku']
        self.capacity = kwargs['capacity']


class IotHubSkuDescriptionListResult(msrest.serialization.Model):
    """The JSON-serialized array of IotHubSkuDescription objects with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The array of IotHubSkuDescription.
    :type value: list[~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubSkuDescription]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IotHubSkuDescription]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubSkuDescriptionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class IotHubSkuInfo(msrest.serialization.Model):
    """Information about the SKU of the IoT hub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the SKU. Possible values include: "F1", "S1", "S2", "S3",
     "B1", "B2", "B3".
    :type name: str or ~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubSku
    :ivar tier: The billing tier for the IoT hub. Possible values include: "Free", "Standard",
     "Basic".
    :vartype tier: str or ~azure.mgmt.iothub.v2021_03_03_preview.models.IotHubSkuTier
    :param capacity: The number of provisioned IoT Hub units. See:
     https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
    :type capacity: long
    """

    _validation = {
        'name': {'required': True},
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubSkuInfo, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = None
        self.capacity = kwargs.get('capacity', None)


class IpFilterRule(msrest.serialization.Model):
    """The IP filter rules for the IoT hub.

    All required parameters must be populated in order to send to Azure.

    :param filter_name: Required. The name of the IP filter rule.
    :type filter_name: str
    :param action: Required. The desired action for requests captured by this rule. Possible values
     include: "Accept", "Reject".
    :type action: str or ~azure.mgmt.iothub.v2021_03_03_preview.models.IpFilterActionType
    :param ip_mask: Required. A string that contains the IP address range in CIDR notation for the
     rule.
    :type ip_mask: str
    """

    _validation = {
        'filter_name': {'required': True},
        'action': {'required': True},
        'ip_mask': {'required': True},
    }

    _attribute_map = {
        'filter_name': {'key': 'filterName', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'ip_mask': {'key': 'ipMask', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IpFilterRule, self).__init__(**kwargs)
        self.filter_name = kwargs['filter_name']
        self.action = kwargs['action']
        self.ip_mask = kwargs['ip_mask']


class JobResponse(msrest.serialization.Model):
    """The properties of the Job Response object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar job_id: The job identifier.
    :vartype job_id: str
    :ivar start_time_utc: The start time of the job.
    :vartype start_time_utc: ~datetime.datetime
    :ivar end_time_utc: The time the job stopped processing.
    :vartype end_time_utc: ~datetime.datetime
    :ivar type: The type of the job. Possible values include: "unknown", "export", "import",
     "backup", "readDeviceProperties", "writeDeviceProperties", "updateDeviceConfiguration",
     "rebootDevice", "factoryResetDevice", "firmwareUpdate".
    :vartype type: str or ~azure.mgmt.iothub.v2021_03_03_preview.models.JobType
    :ivar status: The status of the job. Possible values include: "unknown", "enqueued", "running",
     "completed", "failed", "cancelled".
    :vartype status: str or ~azure.mgmt.iothub.v2021_03_03_preview.models.JobStatus
    :ivar failure_reason: If status == failed, this string containing the reason for the failure.
    :vartype failure_reason: str
    :ivar status_message: The status message for the job.
    :vartype status_message: str
    :ivar parent_job_id: The job identifier of the parent job, if any.
    :vartype parent_job_id: str
    """

    _validation = {
        'job_id': {'readonly': True},
        'start_time_utc': {'readonly': True},
        'end_time_utc': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'failure_reason': {'readonly': True},
        'status_message': {'readonly': True},
        'parent_job_id': {'readonly': True},
    }

    _attribute_map = {
        'job_id': {'key': 'jobId', 'type': 'str'},
        'start_time_utc': {'key': 'startTimeUtc', 'type': 'rfc-1123'},
        'end_time_utc': {'key': 'endTimeUtc', 'type': 'rfc-1123'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'failure_reason': {'key': 'failureReason', 'type': 'str'},
        'status_message': {'key': 'statusMessage', 'type': 'str'},
        'parent_job_id': {'key': 'parentJobId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobResponse, self).__init__(**kwargs)
        self.job_id = None
        self.start_time_utc = None
        self.end_time_utc = None
        self.type = None
        self.status = None
        self.failure_reason = None
        self.status_message = None
        self.parent_job_id = None


class JobResponseListResult(msrest.serialization.Model):
    """The JSON-serialized array of JobResponse objects with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The array of JobResponse objects.
    :type value: list[~azure.mgmt.iothub.v2021_03_03_preview.models.JobResponse]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[JobResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobResponseListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class KeyVaultKeyProperties(msrest.serialization.Model):
    """The properties of the KeyVault key.

    :param key_identifier: The identifier of the key.
    :type key_identifier: str
    :param identity: Managed identity properties of KeyVault Key.
    :type identity: ~azure.mgmt.iothub.v2021_03_03_preview.models.ManagedIdentity
    """

    _attribute_map = {
        'key_identifier': {'key': 'keyIdentifier', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedIdentity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyVaultKeyProperties, self).__init__(**kwargs)
        self.key_identifier = kwargs.get('key_identifier', None)
        self.identity = kwargs.get('identity', None)


class ManagedIdentity(msrest.serialization.Model):
    """The properties of the Managed identity.

    :param user_assigned_identity: The user assigned identity.
    :type user_assigned_identity: str
    """

    _attribute_map = {
        'user_assigned_identity': {'key': 'userAssignedIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedIdentity, self).__init__(**kwargs)
        self.user_assigned_identity = kwargs.get('user_assigned_identity', None)


class MatchedRoute(msrest.serialization.Model):
    """Routes that matched.

    :param properties: Properties of routes that matched.
    :type properties: ~azure.mgmt.iothub.v2021_03_03_preview.models.RouteProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'RouteProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MatchedRoute, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class MessagingEndpointProperties(msrest.serialization.Model):
    """The properties of the messaging endpoints used by this IoT hub.

    :param lock_duration_as_iso8601: The lock duration. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
    :type lock_duration_as_iso8601: ~datetime.timedelta
    :param ttl_as_iso8601: The period of time for which a message is available to consume before it
     is expired by the IoT hub. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
    :type ttl_as_iso8601: ~datetime.timedelta
    :param max_delivery_count: The number of times the IoT hub attempts to deliver a message. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
    :type max_delivery_count: int
    """

    _validation = {
        'max_delivery_count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'lock_duration_as_iso8601': {'key': 'lockDurationAsIso8601', 'type': 'duration'},
        'ttl_as_iso8601': {'key': 'ttlAsIso8601', 'type': 'duration'},
        'max_delivery_count': {'key': 'maxDeliveryCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MessagingEndpointProperties, self).__init__(**kwargs)
        self.lock_duration_as_iso8601 = kwargs.get('lock_duration_as_iso8601', None)
        self.ttl_as_iso8601 = kwargs.get('ttl_as_iso8601', None)
        self.max_delivery_count = kwargs.get('max_delivery_count', None)


class Name(msrest.serialization.Model):
    """Name of Iot Hub type.

    :param value: IotHub type.
    :type value: str
    :param localized_value: Localized value of name.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Name, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.localized_value = kwargs.get('localized_value', None)


class NetworkRuleSetIpRule(msrest.serialization.Model):
    """IP Rule to be applied as part of Network Rule Set.

    All required parameters must be populated in order to send to Azure.

    :param filter_name: Required. Name of the IP filter rule.
    :type filter_name: str
    :param action: IP Filter Action. Possible values include: "Allow". Default value: "Allow".
    :type action: str or ~azure.mgmt.iothub.v2021_03_03_preview.models.NetworkRuleIPAction
    :param ip_mask: Required. A string that contains the IP address range in CIDR notation for the
     rule.
    :type ip_mask: str
    """

    _validation = {
        'filter_name': {'required': True},
        'ip_mask': {'required': True},
    }

    _attribute_map = {
        'filter_name': {'key': 'filterName', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'ip_mask': {'key': 'ipMask', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkRuleSetIpRule, self).__init__(**kwargs)
        self.filter_name = kwargs['filter_name']
        self.action = kwargs.get('action', "Allow")
        self.ip_mask = kwargs['ip_mask']


class NetworkRuleSetProperties(msrest.serialization.Model):
    """Network Rule Set Properties of IotHub.

    All required parameters must be populated in order to send to Azure.

    :param default_action: Default Action for Network Rule Set. Possible values include: "Deny",
     "Allow". Default value: "Deny".
    :type default_action: str or ~azure.mgmt.iothub.v2021_03_03_preview.models.DefaultAction
    :param apply_to_built_in_event_hub_endpoint: Required. If True, then Network Rule Set is also
     applied to BuiltIn EventHub EndPoint of IotHub.
    :type apply_to_built_in_event_hub_endpoint: bool
    :param ip_rules: Required. List of IP Rules.
    :type ip_rules: list[~azure.mgmt.iothub.v2021_03_03_preview.models.NetworkRuleSetIpRule]
    """

    _validation = {
        'apply_to_built_in_event_hub_endpoint': {'required': True},
        'ip_rules': {'required': True},
    }

    _attribute_map = {
        'default_action': {'key': 'defaultAction', 'type': 'str'},
        'apply_to_built_in_event_hub_endpoint': {'key': 'applyToBuiltInEventHubEndpoint', 'type': 'bool'},
        'ip_rules': {'key': 'ipRules', 'type': '[NetworkRuleSetIpRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkRuleSetProperties, self).__init__(**kwargs)
        self.default_action = kwargs.get('default_action', "Deny")
        self.apply_to_built_in_event_hub_endpoint = kwargs['apply_to_built_in_event_hub_endpoint']
        self.ip_rules = kwargs['ip_rules']


class Operation(msrest.serialization.Model):
    """IoT Hub REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{read | write | action | delete}.
    :vartype name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.iothub.v2021_03_03_preview.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = kwargs.get('display', None)


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft Devices.
    :vartype provider: str
    :ivar resource: Resource Type: IotHubs.
    :vartype resource: str
    :ivar operation: Name of the operation.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationInputs(msrest.serialization.Model):
    """Input values.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the IoT hub to check.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationInputs, self).__init__(**kwargs)
        self.name = kwargs['name']


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list IoT Hub operations. It contains a list of operations and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of IoT Hub operations supported by the Microsoft.Devices resource provider.
    :vartype value: list[~azure.mgmt.iothub.v2021_03_03_preview.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateEndpoint(msrest.serialization.Model):
    """The private endpoint property of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(msrest.serialization.Model):
    """The private endpoint connection of an IotHub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param properties: Required. The properties of a private endpoint connection.
    :type properties:
     ~azure.mgmt.iothub.v2021_03_03_preview.models.PrivateEndpointConnectionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateEndpointConnectionProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = kwargs['properties']


class PrivateEndpointConnectionProperties(msrest.serialization.Model):
    """The properties of a private endpoint connection.

    All required parameters must be populated in order to send to Azure.

    :param private_endpoint: The private endpoint property of a private endpoint connection.
    :type private_endpoint: ~azure.mgmt.iothub.v2021_03_03_preview.models.PrivateEndpoint
    :param private_link_service_connection_state: Required. The current state of a private endpoint
     connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.iothub.v2021_03_03_preview.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        'private_link_service_connection_state': {'required': True},
    }

    _attribute_map = {
        'private_endpoint': {'key': 'privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionProperties, self).__init__(**kwargs)
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs['private_link_service_connection_state']


class PrivateLinkResources(msrest.serialization.Model):
    """The available private link resources for an IotHub.

    :param value: The list of available private link resources for an IotHub.
    :type value: list[~azure.mgmt.iothub.v2021_03_03_preview.models.GroupIdInformation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GroupIdInformation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResources, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """The current state of a private endpoint connection.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The status of a private endpoint connection. Possible values include:
     "Pending", "Approved", "Rejected", "Disconnected".
    :type status: str or
     ~azure.mgmt.iothub.v2021_03_03_preview.models.PrivateLinkServiceConnectionStatus
    :param description: Required. The description for the current state of a private endpoint
     connection.
    :type description: str
    :param actions_required: Actions required for a private endpoint connection.
    :type actions_required: str
    """

    _validation = {
        'status': {'required': True},
        'description': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = kwargs['status']
        self.description = kwargs['description']
        self.actions_required = kwargs.get('actions_required', None)


class RegistryStatistics(msrest.serialization.Model):
    """Identity registry statistics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar total_device_count: The total count of devices in the identity registry.
    :vartype total_device_count: long
    :ivar enabled_device_count: The count of enabled devices in the identity registry.
    :vartype enabled_device_count: long
    :ivar disabled_device_count: The count of disabled devices in the identity registry.
    :vartype disabled_device_count: long
    """

    _validation = {
        'total_device_count': {'readonly': True},
        'enabled_device_count': {'readonly': True},
        'disabled_device_count': {'readonly': True},
    }

    _attribute_map = {
        'total_device_count': {'key': 'totalDeviceCount', 'type': 'long'},
        'enabled_device_count': {'key': 'enabledDeviceCount', 'type': 'long'},
        'disabled_device_count': {'key': 'disabledDeviceCount', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryStatistics, self).__init__(**kwargs)
        self.total_device_count = None
        self.enabled_device_count = None
        self.disabled_device_count = None


class RouteCompilationError(msrest.serialization.Model):
    """Compilation error when evaluating route.

    :param message: Route error message.
    :type message: str
    :param severity: Severity of the route error. Possible values include: "error", "warning".
    :type severity: str or ~azure.mgmt.iothub.v2021_03_03_preview.models.RouteErrorSeverity
    :param location: Location where the route error happened.
    :type location: ~azure.mgmt.iothub.v2021_03_03_preview.models.RouteErrorRange
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'location': {'key': 'location', 'type': 'RouteErrorRange'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RouteCompilationError, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)
        self.severity = kwargs.get('severity', None)
        self.location = kwargs.get('location', None)


class RouteErrorPosition(msrest.serialization.Model):
    """Position where the route error happened.

    :param line: Line where the route error happened.
    :type line: int
    :param column: Column where the route error happened.
    :type column: int
    """

    _attribute_map = {
        'line': {'key': 'line', 'type': 'int'},
        'column': {'key': 'column', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RouteErrorPosition, self).__init__(**kwargs)
        self.line = kwargs.get('line', None)
        self.column = kwargs.get('column', None)


class RouteErrorRange(msrest.serialization.Model):
    """Range of route errors.

    :param start: Start where the route error happened.
    :type start: ~azure.mgmt.iothub.v2021_03_03_preview.models.RouteErrorPosition
    :param end: End where the route error happened.
    :type end: ~azure.mgmt.iothub.v2021_03_03_preview.models.RouteErrorPosition
    """

    _attribute_map = {
        'start': {'key': 'start', 'type': 'RouteErrorPosition'},
        'end': {'key': 'end', 'type': 'RouteErrorPosition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RouteErrorRange, self).__init__(**kwargs)
        self.start = kwargs.get('start', None)
        self.end = kwargs.get('end', None)


class RouteProperties(msrest.serialization.Model):
    """The properties of a routing rule that your IoT hub uses to route messages to endpoints.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the route. The name can only include alphanumeric
     characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be
     unique.
    :type name: str
    :param source: Required. The source that the routing rule is to be applied to, such as
     DeviceMessages. Possible values include: "Invalid", "DeviceMessages", "TwinChangeEvents",
     "DeviceLifecycleEvents", "DeviceJobLifecycleEvents", "DigitalTwinChangeEvents",
     "DeviceConnectionStateEvents".
    :type source: str or ~azure.mgmt.iothub.v2021_03_03_preview.models.RoutingSource
    :param condition: The condition that is evaluated to apply the routing rule. If no condition is
     provided, it evaluates to true by default. For grammar, see:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language.
    :type condition: str
    :param endpoint_names: Required. The list of endpoints to which messages that satisfy the
     condition are routed. Currently only one endpoint is allowed.
    :type endpoint_names: list[str]
    :param is_enabled: Required. Used to specify whether a route is enabled.
    :type is_enabled: bool
    """

    _validation = {
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
        'source': {'required': True},
        'endpoint_names': {'required': True, 'max_items': 1, 'min_items': 1},
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'condition': {'key': 'condition', 'type': 'str'},
        'endpoint_names': {'key': 'endpointNames', 'type': '[str]'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RouteProperties, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.source = kwargs['source']
        self.condition = kwargs.get('condition', None)
        self.endpoint_names = kwargs['endpoint_names']
        self.is_enabled = kwargs['is_enabled']


class RoutingEndpoints(msrest.serialization.Model):
    """The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.

    :param service_bus_queues: The list of Service Bus queue endpoints that IoT hub routes the
     messages to, based on the routing rules.
    :type service_bus_queues:
     list[~azure.mgmt.iothub.v2021_03_03_preview.models.RoutingServiceBusQueueEndpointProperties]
    :param service_bus_topics: The list of Service Bus topic endpoints that the IoT hub routes the
     messages to, based on the routing rules.
    :type service_bus_topics:
     list[~azure.mgmt.iothub.v2021_03_03_preview.models.RoutingServiceBusTopicEndpointProperties]
    :param event_hubs: The list of Event Hubs endpoints that IoT hub routes messages to, based on
     the routing rules. This list does not include the built-in Event Hubs endpoint.
    :type event_hubs: list[~azure.mgmt.iothub.v2021_03_03_preview.models.RoutingEventHubProperties]
    :param storage_containers: The list of storage container endpoints that IoT hub routes messages
     to, based on the routing rules.
    :type storage_containers:
     list[~azure.mgmt.iothub.v2021_03_03_preview.models.RoutingStorageContainerProperties]
    """

    _attribute_map = {
        'service_bus_queues': {'key': 'serviceBusQueues', 'type': '[RoutingServiceBusQueueEndpointProperties]'},
        'service_bus_topics': {'key': 'serviceBusTopics', 'type': '[RoutingServiceBusTopicEndpointProperties]'},
        'event_hubs': {'key': 'eventHubs', 'type': '[RoutingEventHubProperties]'},
        'storage_containers': {'key': 'storageContainers', 'type': '[RoutingStorageContainerProperties]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingEndpoints, self).__init__(**kwargs)
        self.service_bus_queues = kwargs.get('service_bus_queues', None)
        self.service_bus_topics = kwargs.get('service_bus_topics', None)
        self.event_hubs = kwargs.get('event_hubs', None)
        self.storage_containers = kwargs.get('storage_containers', None)


class RoutingEventHubProperties(msrest.serialization.Model):
    """The properties related to an event hub endpoint.

    All required parameters must be populated in order to send to Azure.

    :param id: Id of the event hub endpoint.
    :type id: str
    :param connection_string: The connection string of the event hub endpoint.
    :type connection_string: str
    :param endpoint_uri: The url of the event hub endpoint. It must include the protocol sb://.
    :type endpoint_uri: str
    :param entity_path: Event hub name on the event hub namespace.
    :type entity_path: str
    :param authentication_type: Method used to authenticate against the event hub endpoint.
     Possible values include: "keyBased", "identityBased".
    :type authentication_type: str or
     ~azure.mgmt.iothub.v2021_03_03_preview.models.AuthenticationType
    :param identity: Managed identity properties of routing event hub endpoint.
    :type identity: ~azure.mgmt.iothub.v2021_03_03_preview.models.ManagedIdentity
    :param name: Required. The name that identifies this endpoint. The name can only include
     alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64
     characters. The following names are reserved:  events, fileNotifications, $default. Endpoint
     names must be unique across endpoint types.
    :type name: str
    :param subscription_id: The subscription identifier of the event hub endpoint.
    :type subscription_id: str
    :param resource_group: The name of the resource group of the event hub endpoint.
    :type resource_group: str
    """

    _validation = {
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'endpoint_uri': {'key': 'endpointUri', 'type': 'str'},
        'entity_path': {'key': 'entityPath', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedIdentity'},
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingEventHubProperties, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.connection_string = kwargs.get('connection_string', None)
        self.endpoint_uri = kwargs.get('endpoint_uri', None)
        self.entity_path = kwargs.get('entity_path', None)
        self.authentication_type = kwargs.get('authentication_type', None)
        self.identity = kwargs.get('identity', None)
        self.name = kwargs['name']
        self.subscription_id = kwargs.get('subscription_id', None)
        self.resource_group = kwargs.get('resource_group', None)


class RoutingMessage(msrest.serialization.Model):
    """Routing message.

    :param body: Body of routing message.
    :type body: str
    :param app_properties: App properties.
    :type app_properties: dict[str, str]
    :param system_properties: System properties.
    :type system_properties: dict[str, str]
    """

    _attribute_map = {
        'body': {'key': 'body', 'type': 'str'},
        'app_properties': {'key': 'appProperties', 'type': '{str}'},
        'system_properties': {'key': 'systemProperties', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingMessage, self).__init__(**kwargs)
        self.body = kwargs.get('body', None)
        self.app_properties = kwargs.get('app_properties', None)
        self.system_properties = kwargs.get('system_properties', None)


class RoutingProperties(msrest.serialization.Model):
    """The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging.

    :param endpoints: The properties related to the custom endpoints to which your IoT hub routes
     messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all
     endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types
     for free hubs.
    :type endpoints: ~azure.mgmt.iothub.v2021_03_03_preview.models.RoutingEndpoints
    :param routes: The list of user-provided routing rules that the IoT hub uses to route messages
     to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and
     a maximum of 5 routing rules are allowed for free hubs.
    :type routes: list[~azure.mgmt.iothub.v2021_03_03_preview.models.RouteProperties]
    :param fallback_route: The properties of the route that is used as a fall-back route when none
     of the conditions specified in the 'routes' section are met. This is an optional parameter.
     When this property is not set, the messages which do not meet any of the conditions specified
     in the 'routes' section get routed to the built-in eventhub endpoint.
    :type fallback_route: ~azure.mgmt.iothub.v2021_03_03_preview.models.FallbackRouteProperties
    :param enrichments: The list of user-provided enrichments that the IoT hub applies to messages
     to be delivered to built-in and custom endpoints. See: https://aka.ms/telemetryoneventgrid.
    :type enrichments: list[~azure.mgmt.iothub.v2021_03_03_preview.models.EnrichmentProperties]
    """

    _attribute_map = {
        'endpoints': {'key': 'endpoints', 'type': 'RoutingEndpoints'},
        'routes': {'key': 'routes', 'type': '[RouteProperties]'},
        'fallback_route': {'key': 'fallbackRoute', 'type': 'FallbackRouteProperties'},
        'enrichments': {'key': 'enrichments', 'type': '[EnrichmentProperties]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingProperties, self).__init__(**kwargs)
        self.endpoints = kwargs.get('endpoints', None)
        self.routes = kwargs.get('routes', None)
        self.fallback_route = kwargs.get('fallback_route', None)
        self.enrichments = kwargs.get('enrichments', None)


class RoutingServiceBusQueueEndpointProperties(msrest.serialization.Model):
    """The properties related to service bus queue endpoint types.

    All required parameters must be populated in order to send to Azure.

    :param id: Id of the service bus queue endpoint.
    :type id: str
    :param connection_string: The connection string of the service bus queue endpoint.
    :type connection_string: str
    :param endpoint_uri: The url of the service bus queue endpoint. It must include the protocol
     sb://.
    :type endpoint_uri: str
    :param entity_path: Queue name on the service bus namespace.
    :type entity_path: str
    :param authentication_type: Method used to authenticate against the service bus queue endpoint.
     Possible values include: "keyBased", "identityBased".
    :type authentication_type: str or
     ~azure.mgmt.iothub.v2021_03_03_preview.models.AuthenticationType
    :param identity: Managed identity properties of routing service bus queue endpoint.
    :type identity: ~azure.mgmt.iothub.v2021_03_03_preview.models.ManagedIdentity
    :param name: Required. The name that identifies this endpoint. The name can only include
     alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64
     characters. The following names are reserved:  events, fileNotifications, $default. Endpoint
     names must be unique across endpoint types. The name need not be the same as the actual queue
     name.
    :type name: str
    :param subscription_id: The subscription identifier of the service bus queue endpoint.
    :type subscription_id: str
    :param resource_group: The name of the resource group of the service bus queue endpoint.
    :type resource_group: str
    """

    _validation = {
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'endpoint_uri': {'key': 'endpointUri', 'type': 'str'},
        'entity_path': {'key': 'entityPath', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedIdentity'},
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingServiceBusQueueEndpointProperties, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.connection_string = kwargs.get('connection_string', None)
        self.endpoint_uri = kwargs.get('endpoint_uri', None)
        self.entity_path = kwargs.get('entity_path', None)
        self.authentication_type = kwargs.get('authentication_type', None)
        self.identity = kwargs.get('identity', None)
        self.name = kwargs['name']
        self.subscription_id = kwargs.get('subscription_id', None)
        self.resource_group = kwargs.get('resource_group', None)


class RoutingServiceBusTopicEndpointProperties(msrest.serialization.Model):
    """The properties related to service bus topic endpoint types.

    All required parameters must be populated in order to send to Azure.

    :param id: Id of the service bus topic endpoint.
    :type id: str
    :param connection_string: The connection string of the service bus topic endpoint.
    :type connection_string: str
    :param endpoint_uri: The url of the service bus topic endpoint. It must include the protocol
     sb://.
    :type endpoint_uri: str
    :param entity_path: Queue name on the service bus topic.
    :type entity_path: str
    :param authentication_type: Method used to authenticate against the service bus topic endpoint.
     Possible values include: "keyBased", "identityBased".
    :type authentication_type: str or
     ~azure.mgmt.iothub.v2021_03_03_preview.models.AuthenticationType
    :param identity: Managed identity properties of routing service bus topic endpoint.
    :type identity: ~azure.mgmt.iothub.v2021_03_03_preview.models.ManagedIdentity
    :param name: Required. The name that identifies this endpoint. The name can only include
     alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64
     characters. The following names are reserved:  events, fileNotifications, $default. Endpoint
     names must be unique across endpoint types.  The name need not be the same as the actual topic
     name.
    :type name: str
    :param subscription_id: The subscription identifier of the service bus topic endpoint.
    :type subscription_id: str
    :param resource_group: The name of the resource group of the service bus topic endpoint.
    :type resource_group: str
    """

    _validation = {
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'endpoint_uri': {'key': 'endpointUri', 'type': 'str'},
        'entity_path': {'key': 'entityPath', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedIdentity'},
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingServiceBusTopicEndpointProperties, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.connection_string = kwargs.get('connection_string', None)
        self.endpoint_uri = kwargs.get('endpoint_uri', None)
        self.entity_path = kwargs.get('entity_path', None)
        self.authentication_type = kwargs.get('authentication_type', None)
        self.identity = kwargs.get('identity', None)
        self.name = kwargs['name']
        self.subscription_id = kwargs.get('subscription_id', None)
        self.resource_group = kwargs.get('resource_group', None)


class RoutingStorageContainerProperties(msrest.serialization.Model):
    """The properties related to a storage container endpoint.

    All required parameters must be populated in order to send to Azure.

    :param id: Id of the storage container endpoint.
    :type id: str
    :param connection_string: The connection string of the storage account.
    :type connection_string: str
    :param endpoint_uri: The url of the storage endpoint. It must include the protocol https://.
    :type endpoint_uri: str
    :param authentication_type: Method used to authenticate against the storage endpoint. Possible
     values include: "keyBased", "identityBased".
    :type authentication_type: str or
     ~azure.mgmt.iothub.v2021_03_03_preview.models.AuthenticationType
    :param identity: Managed identity properties of routing storage endpoint.
    :type identity: ~azure.mgmt.iothub.v2021_03_03_preview.models.ManagedIdentity
    :param name: Required. The name that identifies this endpoint. The name can only include
     alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64
     characters. The following names are reserved:  events, fileNotifications, $default. Endpoint
     names must be unique across endpoint types.
    :type name: str
    :param subscription_id: The subscription identifier of the storage account.
    :type subscription_id: str
    :param resource_group: The name of the resource group of the storage account.
    :type resource_group: str
    :param container_name: Required. The name of storage container in the storage account.
    :type container_name: str
    :param file_name_format: File name format for the blob. Default format is
     {iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}. All parameters are mandatory but can be
     reordered.
    :type file_name_format: str
    :param batch_frequency_in_seconds: Time interval at which blobs are written to storage. Value
     should be between 60 and 720 seconds. Default value is 300 seconds.
    :type batch_frequency_in_seconds: int
    :param max_chunk_size_in_bytes: Maximum number of bytes for each blob written to storage. Value
     should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
    :type max_chunk_size_in_bytes: int
    :param encoding: Encoding that is used to serialize messages to blobs. Supported values are
     'avro', 'avrodeflate', and 'JSON'. Default value is 'avro'. Possible values include: "Avro",
     "AvroDeflate", "JSON".
    :type encoding: str or
     ~azure.mgmt.iothub.v2021_03_03_preview.models.RoutingStorageContainerPropertiesEncoding
    """

    _validation = {
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
        'container_name': {'required': True},
        'batch_frequency_in_seconds': {'maximum': 720, 'minimum': 60},
        'max_chunk_size_in_bytes': {'maximum': 524288000, 'minimum': 10485760},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'endpoint_uri': {'key': 'endpointUri', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedIdentity'},
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'file_name_format': {'key': 'fileNameFormat', 'type': 'str'},
        'batch_frequency_in_seconds': {'key': 'batchFrequencyInSeconds', 'type': 'int'},
        'max_chunk_size_in_bytes': {'key': 'maxChunkSizeInBytes', 'type': 'int'},
        'encoding': {'key': 'encoding', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingStorageContainerProperties, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.connection_string = kwargs.get('connection_string', None)
        self.endpoint_uri = kwargs.get('endpoint_uri', None)
        self.authentication_type = kwargs.get('authentication_type', None)
        self.identity = kwargs.get('identity', None)
        self.name = kwargs['name']
        self.subscription_id = kwargs.get('subscription_id', None)
        self.resource_group = kwargs.get('resource_group', None)
        self.container_name = kwargs['container_name']
        self.file_name_format = kwargs.get('file_name_format', None)
        self.batch_frequency_in_seconds = kwargs.get('batch_frequency_in_seconds', None)
        self.max_chunk_size_in_bytes = kwargs.get('max_chunk_size_in_bytes', None)
        self.encoding = kwargs.get('encoding', None)


class RoutingTwin(msrest.serialization.Model):
    """Twin reference input parameter. This is an optional parameter.

    :param tags: A set of tags. Twin Tags.
    :type tags: str
    :param properties:
    :type properties: ~azure.mgmt.iothub.v2021_03_03_preview.models.RoutingTwinProperties
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'RoutingTwinProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingTwin, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.properties = kwargs.get('properties', None)


class RoutingTwinProperties(msrest.serialization.Model):
    """RoutingTwinProperties.

    :param desired: Twin desired properties.
    :type desired: str
    :param reported: Twin desired properties.
    :type reported: str
    """

    _attribute_map = {
        'desired': {'key': 'desired', 'type': 'str'},
        'reported': {'key': 'reported', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingTwinProperties, self).__init__(**kwargs)
        self.desired = kwargs.get('desired', None)
        self.reported = kwargs.get('reported', None)


class SharedAccessSignatureAuthorizationRule(msrest.serialization.Model):
    """The properties of an IoT hub shared access policy.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. The name of the shared access policy.
    :type key_name: str
    :param primary_key: The primary key.
    :type primary_key: str
    :param secondary_key: The secondary key.
    :type secondary_key: str
    :param rights: Required. The permissions assigned to the shared access policy. Possible values
     include: "RegistryRead", "RegistryWrite", "ServiceConnect", "DeviceConnect", "RegistryRead,
     RegistryWrite", "RegistryRead, ServiceConnect", "RegistryRead, DeviceConnect", "RegistryWrite,
     ServiceConnect", "RegistryWrite, DeviceConnect", "ServiceConnect, DeviceConnect",
     "RegistryRead, RegistryWrite, ServiceConnect", "RegistryRead, RegistryWrite, DeviceConnect",
     "RegistryRead, ServiceConnect, DeviceConnect", "RegistryWrite, ServiceConnect, DeviceConnect",
     "RegistryRead, RegistryWrite, ServiceConnect, DeviceConnect".
    :type rights: str or ~azure.mgmt.iothub.v2021_03_03_preview.models.AccessRights
    """

    _validation = {
        'key_name': {'required': True},
        'rights': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
        'rights': {'key': 'rights', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SharedAccessSignatureAuthorizationRule, self).__init__(**kwargs)
        self.key_name = kwargs['key_name']
        self.primary_key = kwargs.get('primary_key', None)
        self.secondary_key = kwargs.get('secondary_key', None)
        self.rights = kwargs['rights']


class SharedAccessSignatureAuthorizationRuleListResult(msrest.serialization.Model):
    """The list of shared access policies with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of shared access policies.
    :type value:
     list[~azure.mgmt.iothub.v2021_03_03_preview.models.SharedAccessSignatureAuthorizationRule]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SharedAccessSignatureAuthorizationRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SharedAccessSignatureAuthorizationRuleListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class StorageEndpointProperties(msrest.serialization.Model):
    """The properties of the Azure Storage endpoint for file upload.

    All required parameters must be populated in order to send to Azure.

    :param sas_ttl_as_iso8601: The period of time for which the SAS URI generated by IoT Hub for
     file upload is valid. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options.
    :type sas_ttl_as_iso8601: ~datetime.timedelta
    :param connection_string: Required. The connection string for the Azure Storage account to
     which files are uploaded.
    :type connection_string: str
    :param container_name: Required. The name of the root container where you upload files. The
     container need not exist but should be creatable using the connectionString specified.
    :type container_name: str
    :param authentication_type: Specifies authentication type being used for connecting to the
     storage account. Possible values include: "keyBased", "identityBased".
    :type authentication_type: str or
     ~azure.mgmt.iothub.v2021_03_03_preview.models.AuthenticationType
    :param identity: Managed identity properties of storage endpoint for file upload.
    :type identity: ~azure.mgmt.iothub.v2021_03_03_preview.models.ManagedIdentity
    """

    _validation = {
        'connection_string': {'required': True},
        'container_name': {'required': True},
    }

    _attribute_map = {
        'sas_ttl_as_iso8601': {'key': 'sasTtlAsIso8601', 'type': 'duration'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedIdentity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageEndpointProperties, self).__init__(**kwargs)
        self.sas_ttl_as_iso8601 = kwargs.get('sas_ttl_as_iso8601', None)
        self.connection_string = kwargs['connection_string']
        self.container_name = kwargs['container_name']
        self.authentication_type = kwargs.get('authentication_type', None)
        self.identity = kwargs.get('identity', None)


class TagsResource(msrest.serialization.Model):
    """A container holding only the Tags for a resource, allowing the user to update the tags on an IoT Hub instance.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagsResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class TestAllRoutesInput(msrest.serialization.Model):
    """Input for testing all routes.

    :param routing_source: Routing source. Possible values include: "Invalid", "DeviceMessages",
     "TwinChangeEvents", "DeviceLifecycleEvents", "DeviceJobLifecycleEvents",
     "DigitalTwinChangeEvents", "DeviceConnectionStateEvents".
    :type routing_source: str or ~azure.mgmt.iothub.v2021_03_03_preview.models.RoutingSource
    :param message: Routing message.
    :type message: ~azure.mgmt.iothub.v2021_03_03_preview.models.RoutingMessage
    :param twin: Routing Twin Reference.
    :type twin: ~azure.mgmt.iothub.v2021_03_03_preview.models.RoutingTwin
    """

    _attribute_map = {
        'routing_source': {'key': 'routingSource', 'type': 'str'},
        'message': {'key': 'message', 'type': 'RoutingMessage'},
        'twin': {'key': 'twin', 'type': 'RoutingTwin'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TestAllRoutesInput, self).__init__(**kwargs)
        self.routing_source = kwargs.get('routing_source', None)
        self.message = kwargs.get('message', None)
        self.twin = kwargs.get('twin', None)


class TestAllRoutesResult(msrest.serialization.Model):
    """Result of testing all routes.

    :param routes: JSON-serialized array of matched routes.
    :type routes: list[~azure.mgmt.iothub.v2021_03_03_preview.models.MatchedRoute]
    """

    _attribute_map = {
        'routes': {'key': 'routes', 'type': '[MatchedRoute]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TestAllRoutesResult, self).__init__(**kwargs)
        self.routes = kwargs.get('routes', None)


class TestRouteInput(msrest.serialization.Model):
    """Input for testing route.

    All required parameters must be populated in order to send to Azure.

    :param message: Routing message.
    :type message: ~azure.mgmt.iothub.v2021_03_03_preview.models.RoutingMessage
    :param route: Required. Route properties.
    :type route: ~azure.mgmt.iothub.v2021_03_03_preview.models.RouteProperties
    :param twin: Routing Twin Reference.
    :type twin: ~azure.mgmt.iothub.v2021_03_03_preview.models.RoutingTwin
    """

    _validation = {
        'route': {'required': True},
    }

    _attribute_map = {
        'message': {'key': 'message', 'type': 'RoutingMessage'},
        'route': {'key': 'route', 'type': 'RouteProperties'},
        'twin': {'key': 'twin', 'type': 'RoutingTwin'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TestRouteInput, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)
        self.route = kwargs['route']
        self.twin = kwargs.get('twin', None)


class TestRouteResult(msrest.serialization.Model):
    """Result of testing one route.

    :param result: Result of testing route. Possible values include: "undefined", "false", "true".
    :type result: str or ~azure.mgmt.iothub.v2021_03_03_preview.models.TestResultStatus
    :param details: Detailed result of testing route.
    :type details: ~azure.mgmt.iothub.v2021_03_03_preview.models.TestRouteResultDetails
    """

    _attribute_map = {
        'result': {'key': 'result', 'type': 'str'},
        'details': {'key': 'details', 'type': 'TestRouteResultDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TestRouteResult, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.details = kwargs.get('details', None)


class TestRouteResultDetails(msrest.serialization.Model):
    """Detailed result of testing a route.

    :param compilation_errors: JSON-serialized list of route compilation errors.
    :type compilation_errors:
     list[~azure.mgmt.iothub.v2021_03_03_preview.models.RouteCompilationError]
    """

    _attribute_map = {
        'compilation_errors': {'key': 'compilationErrors', 'type': '[RouteCompilationError]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TestRouteResultDetails, self).__init__(**kwargs)
        self.compilation_errors = kwargs.get('compilation_errors', None)


class UserSubscriptionQuota(msrest.serialization.Model):
    """User subscription quota response.

    :param id: IotHub type id.
    :type id: str
    :param type: Response type.
    :type type: str
    :param unit: Unit of IotHub type.
    :type unit: str
    :param current_value: Current number of IotHub type.
    :type current_value: int
    :param limit: Numerical limit on IotHub type.
    :type limit: int
    :param name: IotHub type.
    :type name: ~azure.mgmt.iothub.v2021_03_03_preview.models.Name
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
        'name': {'key': 'name', 'type': 'Name'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserSubscriptionQuota, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.type = kwargs.get('type', None)
        self.unit = kwargs.get('unit', None)
        self.current_value = kwargs.get('current_value', None)
        self.limit = kwargs.get('limit', None)
        self.name = kwargs.get('name', None)


class UserSubscriptionQuotaListResult(msrest.serialization.Model):
    """Json-serialized array of User subscription quota response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value:
    :type value: list[~azure.mgmt.iothub.v2021_03_03_preview.models.UserSubscriptionQuota]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UserSubscriptionQuota]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserSubscriptionQuotaListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None
