# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class ElectricVehicleConnector(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    STANDARD_HOUSEHOLD_COUNTRY_SPECIFIC = "StandardHouseholdCountrySpecific"  #: These are the standard household connectors for a certain region. They are all AC single phase and the standard Voltage and standard Amperage.
    #See also: `Plug & socket types - World Standards <https://www.worldstandards.eu/electricity/plugs-and-sockets>`_.
    IEC62196_TYPE1 = "IEC62196Type1"  #: Type 1 connector as defined in the IEC 62196-2 standard. Also called Yazaki after the original manufacturer or SAE J1772 after the standard that first published it. Mostly used in combination with 120V single phase or up to 240V single phase infrastructure.
    IEC62196_TYPE1_CCS = "IEC62196Type1CCS"  #: Type 1 based combo connector as defined in the IEC 62196-3 standard. The connector is based on the Type 1 connector – as defined in the IEC 62196-2 standard – with two additional direct current (DC) contacts to allow DC fast charging.
    IEC62196_TYPE2_CABLE_ATTACHED = "IEC62196Type2CableAttached"  #: Type 2 connector as defined in the IEC 62196-2 standard. Provided as a cable and plug attached to the charging point.
    IEC62196_TYPE2_OUTLET = "IEC62196Type2Outlet"  #: Type 2 connector as defined in the IEC 62196-2 standard. Provided as a socket set into the charging point.
    IEC62196_TYPE2_CCS = "IEC62196Type2CCS"  #: Type 2 based combo connector as defined in the IEC 62196-3 standard. The connector is based on the Type 2 connector – as defined in the IEC 62196-2 standard – with two additional direct current (DC) contacts to allow DC fast charging.
    IEC62196_TYPE3 = "IEC62196Type3"  #: Type 3 connector as defined in the IEC 62196-2 standard. Also called Scame after the original manufacturer. Mostly used in combination with up to 240V single phase or up to 420V three phase infrastructure.
    CHADEMO = "Chademo"  #: CHAdeMO connector named after an association formed by the Tokyo Electric Power Company and industrial partners. Because of this is is also known as the TEPCO's connector. It supports fast DC charging.
    IEC60309_AC1_PHASE_BLUE = "IEC60309AC1PhaseBlue"  #: Industrial Blue connector is a connector defined in the IEC 60309 standard. It is sometime referred to as by some combination of the standard, the color and the fact that is a single phase connector. The connector usually has the "P+N+E, 6h" configuration.
    IEC60309_DC_WHITE = "IEC60309DCWhite"  #: Industrial White connector is a DC connector defined in the IEC 60309 standard.
    TESLA = "Tesla"  #: The Tesla connector is the regionally specific Tesla Supercharger connector. I.e. it refers to either Tesla's proprietary connector, sometimes referred to as Tesla Port mostly limited to North America or the modified Type 2 (DC over Type 2) in Europe.

class EntryPointType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of entry point. Value can be either *main* or *minor*.
    """

    MAIN = "main"
    MINOR = "minor"

class GeographicEntityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    COUNTRY = "Country"
    COUNTRY_SUBDIVISION = "CountrySubdivision"
    COUNTRY_SECONDARY_SUBDIVISION = "CountrySecondarySubdivision"
    COUNTRY_TERTIARY_SUBDIVISION = "CountryTertiarySubdivision"
    MUNICIPALITY = "Municipality"
    MUNICIPALITY_SUBDIVISION = "MunicipalitySubdivision"
    NEIGHBOURHOOD = "Neighbourhood"
    POSTAL_CODE_AREA = "PostalCodeArea"

class GeoJsonObjectType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the ``GeoJSON`` type. Must be one of the nine valid GeoJSON object types - Point,
    MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon, GeometryCollection, Feature and
    FeatureCollection.
    """

    GEO_JSON_POINT = "Point"  #: ``GeoJSON Point`` geometry.
    GEO_JSON_MULTI_POINT = "MultiPoint"  #: ``GeoJSON MultiPoint`` geometry.
    GEO_JSON_LINE_STRING = "LineString"  #: ``GeoJSON LineString`` geometry.
    GEO_JSON_MULTI_LINE_STRING = "MultiLineString"  #: ``GeoJSON MultiLineString`` geometry.
    GEO_JSON_POLYGON = "Polygon"  #: ``GeoJSON Polygon`` geometry.
    GEO_JSON_MULTI_POLYGON = "MultiPolygon"  #: ``GeoJSON MultiPolygon`` geometry.
    GEO_JSON_GEOMETRY_COLLECTION = "GeometryCollection"  #: ``GeoJSON GeometryCollection`` geometry.
    GEO_JSON_FEATURE = "Feature"  #: ``GeoJSON Feature`` object.
    GEO_JSON_FEATURE_COLLECTION = "FeatureCollection"  #: ``GeoJSON FeatureCollection`` object.

class JsonFormat(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    JSON = "json"  #: `The JavaScript Object Notation Data Interchange Format <https://tools.ietf.org/html/rfc8259>`_.

class LocalizedMapView(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    AE = "AE"  #: United Arab Emirates (Arabic View).
    AR = "AR"  #: Argentina (Argentinian View).
    BH = "BH"  #: Bahrain (Arabic View).
    IN_ENUM = "IN"  #: India (Indian View).
    IQ = "IQ"  #: Iraq (Arabic View).
    JO = "JO"  #: Jordan (Arabic View).
    KW = "KW"  #: Kuwait (Arabic View).
    LB = "LB"  #: Lebanon (Arabic View).
    MA = "MA"  #: Morocco (Moroccan View).
    OM = "OM"  #: Oman (Arabic View).
    PK = "PK"  #: Pakistan (Pakistani View).
    PS = "PS"  #: Palestinian Authority (Arabic View).
    QA = "QA"  #: Qatar (Arabic View).
    SA = "SA"  #: Saudi Arabia (Arabic View).
    SY = "SY"  #: Syria (Arabic View).
    YE = "YE"  #: Yemen (Arabic View).
    AUTO = "Auto"  #: Return the map data based on the IP address of the request.
    UNIFIED = "Unified"  #: Unified View (Others).

class MatchType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Types of match for a reverse address search operation.
    """

    ADDRESS_POINT = "AddressPoint"
    HOUSE_NUMBER_RANGE = "HouseNumberRange"
    STREET = "Street"

class OperatingHoursRange(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    NEXT_SEVEN_DAYS = "nextSevenDays"  #: Shows the hours of operation for the next week, starting with the current day in the local time of the POI.

class PointOfInterestExtendedPostalCodes(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    POI = "POI"
    NONE = "None"

class QueryType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of query being returned: NEARBY or NON_NEAR.
    """

    NEARBY = "NEARBY"  #: Search was performed around a certain latitude and longitude with a defined radius.
    GLOBAL_ENUM = "NON_NEAR"  #: Search was performed globally, without biasing to a certain latitude and longitude, and no defined radius.

class ResponseFormat(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    JSON = "json"  #: `The JavaScript Object Notation Data Interchange Format <https://tools.ietf.org/html/rfc8259>`_.
    XML = "xml"  #: `The Extensible Markup Language <https://www.w3.org/TR/xml/>`_.

class RoadUseType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes the possible uses of a road.
    """

    LIMITED_ACCESS = "LimitedAccess"
    ARTERIAL = "Arterial"
    TERMINAL = "Terminal"
    RAMP = "Ramp"
    ROTARY = "Rotary"
    LOCAL_STREET = "LocalStreet"

class SearchAddressResultType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """One of:
    
    
    * POI
    * Street
    * Geography
    * Point Address
    * Address Range
    * Cross Street
    """

    POI = "POI"
    STREET = "Street"
    GEOGRAPHY = "Geography"
    POINT_ADDRESS = "Point Address"
    ADDRESS_RANGE = "Address Range"
    CROSS_STREET = "Cross Street"

class SearchIndexes(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    ADDRESS = "Addr"  #: Address range interpolation.
    GEOGRAPHIES = "Geo"  #: Geographies.
    POINT_ADDRESSES = "PAD"  #: Point Addresses.
    POINTS_OF_INTEREST = "POI"  #: Points of interest.
    STREETS = "Str"  #: Streets.
    CROSS_STREETS = "Xstr"  #: Cross Streets (Intersections).
