/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.event.LocationProvider;
import org.xml.sax.Locator;

public class ExpressionLocation
implements SourceLocator,
Locator {
    private String systemId;
    private int lineNumber;
    private int columnNumber = -1;

    public ExpressionLocation() {
    }

    public ExpressionLocation(SourceLocator loc) {
        this.systemId = loc.getSystemId();
        this.lineNumber = loc.getLineNumber();
        this.columnNumber = loc.getColumnNumber();
    }

    public static ExpressionLocation makeFromSax(Locator loc) {
        return new ExpressionLocation(loc.getSystemId(), loc.getLineNumber(), loc.getColumnNumber());
    }

    public ExpressionLocation(LocationProvider provider, int locationId) {
        this.systemId = provider.getSystemId(locationId);
        this.lineNumber = provider.getLineNumber(locationId);
        this.columnNumber = provider.getColumnNumber(locationId);
    }

    public ExpressionLocation(String systemId, int lineNumber, int columnNumber) {
        this.systemId = systemId;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getPublicId() {
        return null;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public static SourceLocator getSourceLocator(int locationId, LocationProvider locationProvider) {
        if (locationProvider instanceof SourceLocator) {
            return (SourceLocator)((Object)locationProvider);
        }
        if (locationId == -1) {
            return null;
        }
        ExpressionLocation loc = new ExpressionLocation();
        loc.setLineNumber(locationProvider.getLineNumber(locationId));
        loc.setColumnNumber(locationProvider.getColumnNumber(locationId));
        loc.setSystemId(locationProvider.getSystemId(locationId));
        return loc;
    }
}

