/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.z.IntPredicate;

public class StreamWriterToReceiver
implements XMLStreamWriter {
    private StartTag pendingTag = null;
    private Receiver receiver;
    private NamePool namePool;
    private IntPredicate charChecker;
    private boolean isChecking = false;
    private int depth = -1;
    private boolean isEmptyElement;
    private boolean inventPrefixes = true;
    private NamespaceReducer inScopeNamespaces;
    private Map<String, String> declaredNamespaces = new HashMap<String, String>(10);
    private NamespaceContext rootNamespaceContext = null;

    public StreamWriterToReceiver(Receiver receiver) {
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        this.inScopeNamespaces = new NamespaceReducer(receiver);
        this.receiver = this.inScopeNamespaces;
        this.charChecker = pipe.getConfiguration().getValidCharacterChecker();
        this.namePool = pipe.getConfiguration().getNamePool();
    }

    public void setInventPrefixes(boolean invent) {
        this.inventPrefixes = invent;
    }

    public boolean isInventPrefixes() {
        return this.inventPrefixes;
    }

    public void setCheckValues(boolean check) {
        this.isChecking = check;
    }

    public boolean isCheckValues() {
        return this.isChecking;
    }

    public void flushStartTag() throws XMLStreamException {
        if (this.depth == -1) {
            this.writeStartDocument();
        }
        if (this.pendingTag != null) {
            try {
                this.completeTriple(this.pendingTag.elementName, false);
                for (Triple t : this.pendingTag.attributes) {
                    this.completeTriple(t, true);
                }
                NodeName nc = this.pendingTag.elementName.uri.isEmpty() ? new NoNamespaceName(this.pendingTag.elementName.local) : new FingerprintedQName(this.pendingTag.elementName.prefix, this.pendingTag.elementName.uri, this.pendingTag.elementName.local);
                this.receiver.startElement(nc, Untyped.getInstance(), 0, 0);
                for (Triple t : this.pendingTag.namespaces) {
                    if (t.prefix == null) {
                        t.prefix = "";
                    }
                    if (t.uri == null) {
                        t.uri = "";
                    }
                    this.receiver.namespace(new NamespaceBinding(t.prefix, t.uri), 0);
                }
                for (Triple t : this.pendingTag.attributes) {
                    nc = t.uri.isEmpty() ? new NoNamespaceName(t.local) : new FingerprintedQName(t.prefix, t.uri, t.local);
                    this.receiver.attribute(nc, BuiltInAtomicType.UNTYPED_ATOMIC, t.value, 0, 0);
                }
                this.pendingTag = null;
                this.receiver.startContent();
                if (this.isEmptyElement) {
                    this.isEmptyElement = false;
                    --this.depth;
                    this.receiver.endElement();
                }
            }
            catch (XPathException e) {
                throw new XMLStreamException(e);
            }
        }
    }

    public void completeTriple(Triple t, boolean isAttribute) throws XMLStreamException {
        if (t.local == null) {
            throw new XMLStreamException("Local name of " + (isAttribute ? "Attribute" : "Element") + " is missing");
        }
        if (this.isChecking && !this.isValidNCName(t.local)) {
            throw new XMLStreamException("Local name of " + (isAttribute ? "Attribute" : "Element") + Err.wrap(t.local) + " is invalid");
        }
        if (t.prefix == null) {
            t.prefix = "";
        }
        if (t.uri == null) {
            t.uri = "";
        }
        if (this.isChecking && !t.uri.isEmpty() && !this.isValidURI(t.uri)) {
            throw new XMLStreamException("Namespace URI " + Err.wrap(t.local) + " is invalid");
        }
        if (t.prefix.isEmpty()) {
            if (t.uri.isEmpty()) {
                if (!isAttribute) {
                    String ns = this.getDefaultNamespace();
                    t.uri = ns == null ? "" : ns;
                }
            } else {
                t.prefix = this.getPrefixForUri(t.uri);
                if (t.prefix.isEmpty() && isAttribute) {
                    t.prefix = this.inventPrefix(t.uri);
                }
            }
        } else {
            if (this.isChecking && !this.isValidNCName(t.prefix)) {
                throw new XMLStreamException("Prefix of " + (isAttribute ? "Attribute" : "Element") + Err.wrap(t.local) + " is invalid");
            }
            if (t.uri.isEmpty()) {
                t.uri = this.getUriForPrefix(t.prefix);
            } else {
                String u = this.getUriForPrefix(t.prefix);
                if (!t.uri.equals(u)) {
                    throw new XMLStreamException("Prefix " + Err.wrap(t.local) + " is bound to a different URI");
                }
            }
        }
    }

    private String getDefaultNamespace() {
        for (Triple t : this.pendingTag.namespaces) {
            if (t.prefix != null && !t.prefix.isEmpty()) continue;
            return t.uri;
        }
        return this.inScopeNamespaces.getURIForPrefix("", true);
    }

    private String getUriForPrefix(String prefix) {
        for (Triple t : this.pendingTag.namespaces) {
            if (!prefix.equals(t.prefix)) continue;
            return t.uri;
        }
        return this.inScopeNamespaces.getURIForPrefix(prefix, false);
    }

    private String getPrefixForUri(String uri) {
        for (Triple t : this.pendingTag.namespaces) {
            if (!uri.equals(t.uri)) continue;
            return t.prefix == null ? "" : t.prefix;
        }
        Iterator<String> prefixes = this.inScopeNamespaces.iteratePrefixes();
        while (prefixes.hasNext()) {
            String p = prefixes.next();
            if (!this.inScopeNamespaces.getURIForPrefix(p, false).equals(uri)) continue;
            return p;
        }
        return "";
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.flushStartTag();
        ++this.depth;
        this.pendingTag = new StartTag();
        this.pendingTag.elementName.local = localName;
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.flushStartTag();
        ++this.depth;
        this.pendingTag = new StartTag();
        this.pendingTag.elementName.local = localName;
        this.pendingTag.elementName.uri = namespaceURI;
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.flushStartTag();
        ++this.depth;
        this.pendingTag = new StartTag();
        this.pendingTag.elementName.local = localName;
        this.pendingTag.elementName.uri = namespaceURI;
        this.pendingTag.elementName.prefix = prefix;
    }

    private String inventPrefix(String uri) {
        String prefix = this.getPrefix(uri);
        if (prefix != null) {
            return prefix;
        }
        prefix = this.namePool.suggestPrefixForURI(uri);
        if (prefix != null) {
            return prefix;
        }
        int count = 0;
        while (true) {
            if (this.inScopeNamespaces.getURIForPrefix(prefix = "ns" + count, false) == null) {
                this.setPrefix(prefix, uri);
                return prefix;
            }
            ++count;
        }
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.flushStartTag();
        this.writeStartElement(namespaceURI, localName);
        this.isEmptyElement = true;
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.flushStartTag();
        this.writeStartElement(prefix, localName, namespaceURI);
        this.isEmptyElement = true;
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.flushStartTag();
        this.writeStartElement(localName);
        this.isEmptyElement = true;
    }

    public void writeEndElement() throws XMLStreamException {
        if (this.depth <= 0) {
            throw new IllegalStateException("writeEndElement with no matching writeStartElement");
        }
        try {
            this.flushStartTag();
            this.receiver.endElement();
            --this.depth;
        }
        catch (XPathException err) {
            throw new XMLStreamException(err);
        }
    }

    public void writeEndDocument() throws XMLStreamException {
        if (this.depth == -1) {
            throw new IllegalStateException("writeEndDocument with no matching writeStartDocument");
        }
        try {
            this.flushStartTag();
            while (this.depth > 0) {
                this.writeEndElement();
            }
            this.receiver.endDocument();
            this.depth = -1;
        }
        catch (XPathException err) {
            throw new XMLStreamException(err);
        }
    }

    public void close() throws XMLStreamException {
        if (this.depth >= 0) {
            this.writeEndDocument();
        }
        try {
            this.receiver.close();
        }
        catch (XPathException err) {
            throw new XMLStreamException(err);
        }
    }

    public void flush() throws XMLStreamException {
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if (this.pendingTag == null) {
            throw new IllegalStateException("Cannot write attribute when not in a start tag");
        }
        Triple t = new Triple();
        t.local = localName;
        t.value = value;
        this.pendingTag.attributes.add(t);
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if (this.pendingTag == null) {
            throw new IllegalStateException("Cannot write attribute when not in a start tag");
        }
        Triple t = new Triple();
        t.prefix = prefix;
        t.uri = namespaceURI;
        t.local = localName;
        t.value = value;
        this.pendingTag.attributes.add(t);
        try {
            FingerprintedQName nn = new FingerprintedQName(prefix, namespaceURI, localName);
            this.receiver.attribute(nn, BuiltInAtomicType.UNTYPED_ATOMIC, value, -1, 0);
        }
        catch (XPathException err) {
            throw new XMLStreamException(err);
        }
    }

    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        Triple t = new Triple();
        t.uri = namespaceURI;
        t.local = localName;
        t.value = value;
        this.pendingTag.attributes.add(t);
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (this.pendingTag == null) {
            throw new IllegalStateException("Cannot write namespace when not in a start tag");
        }
        Triple t = new Triple();
        t.uri = namespaceURI;
        t.prefix = prefix;
        this.pendingTag.namespaces.add(t);
    }

    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        if (this.pendingTag == null) {
            throw new IllegalStateException("Cannot write namespace when not in a start tag");
        }
        Triple t = new Triple();
        t.uri = namespaceURI;
        this.pendingTag.namespaces.add(t);
    }

    public void writeComment(String data) throws XMLStreamException {
        this.flushStartTag();
        if (data == null) {
            data = "";
        }
        try {
            if (!this.isValidChars(data)) {
                throw new IllegalArgumentException("Invalid XML character in comment: " + data);
            }
            if (this.isChecking && data.contains("--")) {
                throw new IllegalArgumentException("Comment contains '--'");
            }
            this.receiver.comment(data, 0, 0);
        }
        catch (XPathException err) {
            throw new XMLStreamException(err);
        }
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writeProcessingInstruction(target, "");
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.flushStartTag();
        try {
            if (this.isChecking) {
                if (!this.isValidNCName(target) || "xml".equalsIgnoreCase(target)) {
                    throw new IllegalArgumentException("Invalid PITarget: " + target);
                }
                if (!this.isValidChars(data)) {
                    throw new IllegalArgumentException("Invalid character in PI data: " + data);
                }
            }
            this.receiver.processingInstruction(target, data, 0, 0);
        }
        catch (XPathException err) {
            throw new XMLStreamException(err);
        }
    }

    public void writeCData(String data) throws XMLStreamException {
        this.flushStartTag();
        this.writeCharacters(data);
    }

    public void writeDTD(String dtd) throws XMLStreamException {
    }

    public void writeEntityRef(String name) throws XMLStreamException {
        throw new UnsupportedOperationException("writeEntityRef");
    }

    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument(null, null);
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        this.writeStartDocument(null, version);
    }

    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        if (this.depth != -1) {
            throw new IllegalStateException("writeStartDocument must be the first call");
        }
        try {
            this.receiver.startDocument(0);
        }
        catch (XPathException err) {
            throw new XMLStreamException(err);
        }
        this.depth = 0;
    }

    public void writeCharacters(String text) throws XMLStreamException {
        this.flushStartTag();
        if (text != null) {
            if (!this.isValidChars(text)) {
                throw new IllegalArgumentException("illegal XML character: " + text);
            }
            try {
                this.receiver.characters(text, 0, 0);
            }
            catch (XPathException err) {
                throw new XMLStreamException(err);
            }
        }
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.writeCharacters(new String(text, start, len));
    }

    public String getPrefix(String uri) {
        String prefix = this.declaredNamespaces.get(uri);
        if (prefix == null && this.rootNamespaceContext != null) {
            prefix = this.rootNamespaceContext.getPrefix(uri);
        }
        return prefix;
    }

    public void setPrefix(String prefix, String uri) {
        if (!this.isValidURI(uri)) {
            throw new IllegalArgumentException("Invalid namespace URI: " + uri);
        }
        if (!"".equals(prefix) && !this.isValidNCName(prefix)) {
            throw new IllegalArgumentException("Invalid namespace prefix: " + prefix);
        }
        this.declaredNamespaces.put(uri, prefix);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.setPrefix("", uri);
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        if (this.depth > 0) {
            throw new IllegalStateException("setNamespaceContext may only be called at the start of the document");
        }
        this.rootNamespaceContext = context;
    }

    public NamespaceContext getNamespaceContext() {
        return this.rootNamespaceContext;
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        if (name.equals("javax.xml.stream.isRepairingNamespaces")) {
            return this.inventPrefixes;
        }
        throw new IllegalArgumentException(name);
    }

    private boolean isValidNCName(String name) {
        return !this.isChecking || NameChecker.isValidNCName(name);
    }

    private boolean isValidChars(String text) {
        return !this.isChecking || UTF16CharacterSet.firstInvalidChar(text, this.charChecker) == -1;
    }

    private boolean isValidURI(String uri) {
        return !this.isChecking || StandardURIChecker.getInstance().isValidURI(uri);
    }

    private static class StartTag {
        public Triple elementName = new Triple();
        public List<Triple> attributes = new ArrayList<Triple>();
        public List<Triple> namespaces = new ArrayList<Triple>();
    }

    private static class Triple {
        public String prefix;
        public String uri;
        public String local;
        public String value;

        private Triple() {
        }
    }
}

