# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class CertificateBodyDescription(Model):
    """The JSON-serialized X509 Certificate.

    :param certificate: base-64 representation of the X509 leaf certificate
     .cer file or just .pem file content.
    :type certificate: str
    """

    _attribute_map = {
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(self, *, certificate: str=None, **kwargs) -> None:
        super(CertificateBodyDescription, self).__init__(**kwargs)
        self.certificate = certificate


class CertificateDescription(Model):
    """The X509 Certificate.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param properties:
    :type properties: ~azure.mgmt.iothub.models.CertificateProperties
    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The name of the certificate.
    :vartype name: str
    :ivar etag: The entity tag.
    :vartype etag: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CertificateProperties'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(CertificateDescription, self).__init__(**kwargs)
        self.properties = properties
        self.id = None
        self.name = None
        self.etag = None
        self.type = None


class CertificateListDescription(Model):
    """The JSON-serialized array of Certificate objects.

    :param value: The array of Certificate objects.
    :type value: list[~azure.mgmt.iothub.models.CertificateDescription]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CertificateDescription]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(CertificateListDescription, self).__init__(**kwargs)
        self.value = value


class CertificateProperties(Model):
    """The description of an X509 CA Certificate.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar subject: The certificate's subject name.
    :vartype subject: str
    :ivar expiry: The certificate's expiration date and time.
    :vartype expiry: datetime
    :ivar thumbprint: The certificate's thumbprint.
    :vartype thumbprint: str
    :ivar is_verified: Determines whether certificate has been verified.
    :vartype is_verified: bool
    :ivar created: The certificate's create date and time.
    :vartype created: datetime
    :ivar updated: The certificate's last update date and time.
    :vartype updated: datetime
    :param certificate: The certificate content
    :type certificate: str
    """

    _validation = {
        'subject': {'readonly': True},
        'expiry': {'readonly': True},
        'thumbprint': {'readonly': True},
        'is_verified': {'readonly': True},
        'created': {'readonly': True},
        'updated': {'readonly': True},
    }

    _attribute_map = {
        'subject': {'key': 'subject', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'rfc-1123'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'is_verified': {'key': 'isVerified', 'type': 'bool'},
        'created': {'key': 'created', 'type': 'rfc-1123'},
        'updated': {'key': 'updated', 'type': 'rfc-1123'},
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(self, *, certificate: str=None, **kwargs) -> None:
        super(CertificateProperties, self).__init__(**kwargs)
        self.subject = None
        self.expiry = None
        self.thumbprint = None
        self.is_verified = None
        self.created = None
        self.updated = None
        self.certificate = certificate


class CertificatePropertiesWithNonce(Model):
    """The description of an X509 CA Certificate including the challenge nonce
    issued for the Proof-Of-Possession flow.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar subject: The certificate's subject name.
    :vartype subject: str
    :ivar expiry: The certificate's expiration date and time.
    :vartype expiry: datetime
    :ivar thumbprint: The certificate's thumbprint.
    :vartype thumbprint: str
    :ivar is_verified: Determines whether certificate has been verified.
    :vartype is_verified: bool
    :ivar created: The certificate's create date and time.
    :vartype created: datetime
    :ivar updated: The certificate's last update date and time.
    :vartype updated: datetime
    :ivar verification_code: The certificate's verification code that will be
     used for proof of possession.
    :vartype verification_code: str
    :ivar certificate: The certificate content
    :vartype certificate: str
    """

    _validation = {
        'subject': {'readonly': True},
        'expiry': {'readonly': True},
        'thumbprint': {'readonly': True},
        'is_verified': {'readonly': True},
        'created': {'readonly': True},
        'updated': {'readonly': True},
        'verification_code': {'readonly': True},
        'certificate': {'readonly': True},
    }

    _attribute_map = {
        'subject': {'key': 'subject', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'rfc-1123'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'is_verified': {'key': 'isVerified', 'type': 'bool'},
        'created': {'key': 'created', 'type': 'rfc-1123'},
        'updated': {'key': 'updated', 'type': 'rfc-1123'},
        'verification_code': {'key': 'verificationCode', 'type': 'str'},
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(CertificatePropertiesWithNonce, self).__init__(**kwargs)
        self.subject = None
        self.expiry = None
        self.thumbprint = None
        self.is_verified = None
        self.created = None
        self.updated = None
        self.verification_code = None
        self.certificate = None


class CertificateVerificationDescription(Model):
    """The JSON-serialized leaf certificate.

    :param certificate: base-64 representation of X509 certificate .cer file
     or just .pem file content.
    :type certificate: str
    """

    _attribute_map = {
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(self, *, certificate: str=None, **kwargs) -> None:
        super(CertificateVerificationDescription, self).__init__(**kwargs)
        self.certificate = certificate


class CertificateWithNonceDescription(Model):
    """The X509 Certificate.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param properties:
    :type properties: ~azure.mgmt.iothub.models.CertificatePropertiesWithNonce
    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The name of the certificate.
    :vartype name: str
    :ivar etag: The entity tag.
    :vartype etag: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CertificatePropertiesWithNonce'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(CertificateWithNonceDescription, self).__init__(**kwargs)
        self.properties = properties
        self.id = None
        self.name = None
        self.etag = None
        self.type = None


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class CloudToDeviceProperties(Model):
    """The IoT hub cloud-to-device messaging properties.

    :param max_delivery_count: The max delivery count for cloud-to-device
     messages in the device queue. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :type max_delivery_count: int
    :param default_ttl_as_iso8601: The default time to live for
     cloud-to-device messages in the device queue. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :type default_ttl_as_iso8601: timedelta
    :param feedback:
    :type feedback: ~azure.mgmt.iothub.models.FeedbackProperties
    """

    _validation = {
        'max_delivery_count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'max_delivery_count': {'key': 'maxDeliveryCount', 'type': 'int'},
        'default_ttl_as_iso8601': {'key': 'defaultTtlAsIso8601', 'type': 'duration'},
        'feedback': {'key': 'feedback', 'type': 'FeedbackProperties'},
    }

    def __init__(self, *, max_delivery_count: int=None, default_ttl_as_iso8601=None, feedback=None, **kwargs) -> None:
        super(CloudToDeviceProperties, self).__init__(**kwargs)
        self.max_delivery_count = max_delivery_count
        self.default_ttl_as_iso8601 = default_ttl_as_iso8601
        self.feedback = feedback


class EndpointHealthData(Model):
    """The health data for an endpoint.

    :param endpoint_id: Id of the endpoint
    :type endpoint_id: str
    :param health_status: Health statuses have following meanings. The
     'healthy' status shows that the endpoint is accepting messages as
     expected. The 'unhealthy' status shows that the endpoint is not accepting
     messages as expected and IoT Hub is retrying to send data to this
     endpoint. The status of an unhealthy endpoint will be updated to healthy
     when IoT Hub has established an eventually consistent state of health. The
     'dead' status shows that the endpoint is not accepting messages, after IoT
     Hub retried sending messages for the retrial period. See IoT Hub metrics
     to identify errors and monitor issues with endpoints. The 'unknown' status
     shows that the IoT Hub has not established a connection with the endpoint.
     No messages have been delivered to or rejected from this endpoint.
     Possible values include: 'unknown', 'healthy', 'unhealthy', 'dead'
    :type health_status: str or ~azure.mgmt.iothub.models.EndpointHealthStatus
    """

    _attribute_map = {
        'endpoint_id': {'key': 'endpointId', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
    }

    def __init__(self, *, endpoint_id: str=None, health_status=None, **kwargs) -> None:
        super(EndpointHealthData, self).__init__(**kwargs)
        self.endpoint_id = endpoint_id
        self.health_status = health_status


class EnrichmentProperties(Model):
    """The properties of an enrichment that your IoT hub applies to messages
    delivered to endpoints.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. The key or name for the enrichment property.
    :type key: str
    :param value: Required. The value for the enrichment property.
    :type value: str
    :param endpoint_names: Required. The list of endpoints for which the
     enrichment is applied to the message.
    :type endpoint_names: list[str]
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
        'endpoint_names': {'required': True, 'min_items': 1},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'endpoint_names': {'key': 'endpointNames', 'type': '[str]'},
    }

    def __init__(self, *, key: str, value: str, endpoint_names, **kwargs) -> None:
        super(EnrichmentProperties, self).__init__(**kwargs)
        self.key = key
        self.value = value
        self.endpoint_names = endpoint_names


class ErrorDetails(Model):
    """Error details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar http_status_code: The HTTP status code.
    :vartype http_status_code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar details: The error details.
    :vartype details: str
    """

    _validation = {
        'code': {'readonly': True},
        'http_status_code': {'readonly': True},
        'message': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'http_status_code': {'key': 'httpStatusCode', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = None
        self.http_status_code = None
        self.message = None
        self.details = None


class ErrorDetailsException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorDetails'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorDetailsException, self).__init__(deserialize, response, 'ErrorDetails', *args)


class EventHubConsumerGroupInfo(Model):
    """The properties of the EventHubConsumerGroupInfo object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param properties: The tags.
    :type properties: dict[str, str]
    :ivar id: The Event Hub-compatible consumer group identifier.
    :vartype id: str
    :ivar name: The Event Hub-compatible consumer group name.
    :vartype name: str
    :ivar type: the resource type.
    :vartype type: str
    :ivar etag: The etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': '{str}'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(EventHubConsumerGroupInfo, self).__init__(**kwargs)
        self.properties = properties
        self.id = None
        self.name = None
        self.type = None
        self.etag = None


class EventHubProperties(Model):
    """The properties of the provisioned Event Hub-compatible endpoint used by the
    IoT hub.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param retention_time_in_days: The retention time for device-to-cloud
     messages in days. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages
    :type retention_time_in_days: long
    :param partition_count: The number of partitions for receiving
     device-to-cloud messages in the Event Hub-compatible endpoint. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
    :type partition_count: int
    :ivar partition_ids: The partition ids in the Event Hub-compatible
     endpoint.
    :vartype partition_ids: list[str]
    :ivar path: The Event Hub-compatible name.
    :vartype path: str
    :ivar endpoint: The Event Hub-compatible endpoint.
    :vartype endpoint: str
    """

    _validation = {
        'partition_ids': {'readonly': True},
        'path': {'readonly': True},
        'endpoint': {'readonly': True},
    }

    _attribute_map = {
        'retention_time_in_days': {'key': 'retentionTimeInDays', 'type': 'long'},
        'partition_count': {'key': 'partitionCount', 'type': 'int'},
        'partition_ids': {'key': 'partitionIds', 'type': '[str]'},
        'path': {'key': 'path', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
    }

    def __init__(self, *, retention_time_in_days: int=None, partition_count: int=None, **kwargs) -> None:
        super(EventHubProperties, self).__init__(**kwargs)
        self.retention_time_in_days = retention_time_in_days
        self.partition_count = partition_count
        self.partition_ids = None
        self.path = None
        self.endpoint = None


class ExportDevicesRequest(Model):
    """Use to provide parameters when requesting an export of all devices in the
    IoT hub.

    All required parameters must be populated in order to send to Azure.

    :param export_blob_container_uri: Required. The export blob container URI.
    :type export_blob_container_uri: str
    :param exclude_keys: Required. The value indicating whether keys should be
     excluded during export.
    :type exclude_keys: bool
    :param export_blob_name: The name of the blob that will be created in the
     provided output blob container. This blob will contain the exported device
     registry information for the IoT Hub.
    :type export_blob_name: str
    :param authentication_type: Specifies authentication type being used for
     connecting to the storage account. Possible values include: 'keyBased',
     'identityBased'
    :type authentication_type: str or
     ~azure.mgmt.iothub.models.AuthenticationType
    """

    _validation = {
        'export_blob_container_uri': {'required': True},
        'exclude_keys': {'required': True},
    }

    _attribute_map = {
        'export_blob_container_uri': {'key': 'exportBlobContainerUri', 'type': 'str'},
        'exclude_keys': {'key': 'excludeKeys', 'type': 'bool'},
        'export_blob_name': {'key': 'exportBlobName', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
    }

    def __init__(self, *, export_blob_container_uri: str, exclude_keys: bool, export_blob_name: str=None, authentication_type=None, **kwargs) -> None:
        super(ExportDevicesRequest, self).__init__(**kwargs)
        self.export_blob_container_uri = export_blob_container_uri
        self.exclude_keys = exclude_keys
        self.export_blob_name = export_blob_name
        self.authentication_type = authentication_type


class FailoverInput(Model):
    """Use to provide failover region when requesting manual Failover for a hub.

    All required parameters must be populated in order to send to Azure.

    :param failover_region: Required. Region the hub will be failed over to
    :type failover_region: str
    """

    _validation = {
        'failover_region': {'required': True},
    }

    _attribute_map = {
        'failover_region': {'key': 'failoverRegion', 'type': 'str'},
    }

    def __init__(self, *, failover_region: str, **kwargs) -> None:
        super(FailoverInput, self).__init__(**kwargs)
        self.failover_region = failover_region


class FallbackRouteProperties(Model):
    """The properties of the fallback route. IoT Hub uses these properties when it
    routes messages to the fallback endpoint.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: The name of the route. The name can only include alphanumeric
     characters, periods, underscores, hyphens, has a maximum length of 64
     characters, and must be unique.
    :type name: str
    :ivar source: Required. The source to which the routing rule is to be
     applied to. For example, DeviceMessages. Default value: "DeviceMessages" .
    :vartype source: str
    :param condition: The condition which is evaluated in order to apply the
     fallback route. If the condition is not provided it will evaluate to true
     by default. For grammar, See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
    :type condition: str
    :param endpoint_names: Required. The list of endpoints to which the
     messages that satisfy the condition are routed to. Currently only 1
     endpoint is allowed.
    :type endpoint_names: list[str]
    :param is_enabled: Required. Used to specify whether the fallback route is
     enabled.
    :type is_enabled: bool
    """

    _validation = {
        'source': {'required': True, 'constant': True},
        'endpoint_names': {'required': True, 'max_items': 1, 'min_items': 1},
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'condition': {'key': 'condition', 'type': 'str'},
        'endpoint_names': {'key': 'endpointNames', 'type': '[str]'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    source = "DeviceMessages"

    def __init__(self, *, endpoint_names, is_enabled: bool, name: str=None, condition: str=None, **kwargs) -> None:
        super(FallbackRouteProperties, self).__init__(**kwargs)
        self.name = name
        self.condition = condition
        self.endpoint_names = endpoint_names
        self.is_enabled = is_enabled


class FeedbackProperties(Model):
    """The properties of the feedback queue for cloud-to-device messages.

    :param lock_duration_as_iso8601: The lock duration for the feedback queue.
     See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :type lock_duration_as_iso8601: timedelta
    :param ttl_as_iso8601: The period of time for which a message is available
     to consume before it is expired by the IoT hub. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :type ttl_as_iso8601: timedelta
    :param max_delivery_count: The number of times the IoT hub attempts to
     deliver a message on the feedback queue. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :type max_delivery_count: int
    """

    _validation = {
        'max_delivery_count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'lock_duration_as_iso8601': {'key': 'lockDurationAsIso8601', 'type': 'duration'},
        'ttl_as_iso8601': {'key': 'ttlAsIso8601', 'type': 'duration'},
        'max_delivery_count': {'key': 'maxDeliveryCount', 'type': 'int'},
    }

    def __init__(self, *, lock_duration_as_iso8601=None, ttl_as_iso8601=None, max_delivery_count: int=None, **kwargs) -> None:
        super(FeedbackProperties, self).__init__(**kwargs)
        self.lock_duration_as_iso8601 = lock_duration_as_iso8601
        self.ttl_as_iso8601 = ttl_as_iso8601
        self.max_delivery_count = max_delivery_count


class GroupIdInformation(Model):
    """The group information for creating a private endpoint on an IotHub.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param properties: Required.
    :type properties: ~azure.mgmt.iothub.models.GroupIdInformationProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'GroupIdInformationProperties'},
    }

    def __init__(self, *, properties, **kwargs) -> None:
        super(GroupIdInformation, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class GroupIdInformationProperties(Model):
    """The properties for a group information object.

    :param group_id: The group id
    :type group_id: str
    :param required_members: The required members for a specific group id
    :type required_members: list[str]
    :param required_zone_names: The required DNS zones for a specific group id
    :type required_zone_names: list[str]
    """

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'requiredZoneNames', 'type': '[str]'},
    }

    def __init__(self, *, group_id: str=None, required_members=None, required_zone_names=None, **kwargs) -> None:
        super(GroupIdInformationProperties, self).__init__(**kwargs)
        self.group_id = group_id
        self.required_members = required_members
        self.required_zone_names = required_zone_names


class ImportDevicesRequest(Model):
    """Use to provide parameters when requesting an import of all devices in the
    hub.

    All required parameters must be populated in order to send to Azure.

    :param input_blob_container_uri: Required. The input blob container URI.
    :type input_blob_container_uri: str
    :param output_blob_container_uri: Required. The output blob container URI.
    :type output_blob_container_uri: str
    :param input_blob_name: The blob name to be used when importing from the
     provided input blob container.
    :type input_blob_name: str
    :param output_blob_name: The blob name to use for storing the status of
     the import job.
    :type output_blob_name: str
    :param authentication_type: Specifies authentication type being used for
     connecting to the storage account. Possible values include: 'keyBased',
     'identityBased'
    :type authentication_type: str or
     ~azure.mgmt.iothub.models.AuthenticationType
    """

    _validation = {
        'input_blob_container_uri': {'required': True},
        'output_blob_container_uri': {'required': True},
    }

    _attribute_map = {
        'input_blob_container_uri': {'key': 'inputBlobContainerUri', 'type': 'str'},
        'output_blob_container_uri': {'key': 'outputBlobContainerUri', 'type': 'str'},
        'input_blob_name': {'key': 'inputBlobName', 'type': 'str'},
        'output_blob_name': {'key': 'outputBlobName', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
    }

    def __init__(self, *, input_blob_container_uri: str, output_blob_container_uri: str, input_blob_name: str=None, output_blob_name: str=None, authentication_type=None, **kwargs) -> None:
        super(ImportDevicesRequest, self).__init__(**kwargs)
        self.input_blob_container_uri = input_blob_container_uri
        self.output_blob_container_uri = output_blob_container_uri
        self.input_blob_name = input_blob_name
        self.output_blob_name = output_blob_name
        self.authentication_type = authentication_type


class IotHubCapacity(Model):
    """IoT Hub capacity information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar minimum: The minimum number of units.
    :vartype minimum: long
    :ivar maximum: The maximum number of units.
    :vartype maximum: long
    :ivar default: The default number of units.
    :vartype default: long
    :ivar scale_type: The type of the scaling enabled. Possible values
     include: 'Automatic', 'Manual', 'None'
    :vartype scale_type: str or ~azure.mgmt.iothub.models.IotHubScaleType
    """

    _validation = {
        'minimum': {'readonly': True, 'maximum': 1, 'minimum': 1},
        'maximum': {'readonly': True},
        'default': {'readonly': True},
        'scale_type': {'readonly': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'long'},
        'maximum': {'key': 'maximum', 'type': 'long'},
        'default': {'key': 'default', 'type': 'long'},
        'scale_type': {'key': 'scaleType', 'type': 'IotHubScaleType'},
    }

    def __init__(self, **kwargs) -> None:
        super(IotHubCapacity, self).__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default = None
        self.scale_type = None


class Resource(Model):
    """The common properties of an Azure resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param location: Required. The resource location.
    :type location: str
    :param tags: The resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class IotHubDescription(Resource):
    """The description of the IoT hub.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param location: Required. The resource location.
    :type location: str
    :param tags: The resource tags.
    :type tags: dict[str, str]
    :param etag: The Etag field is *not* required. If it is provided in the
     response body, it must also be provided as a header per the normal ETag
     convention.
    :type etag: str
    :param properties: IotHub properties
    :type properties: ~azure.mgmt.iothub.models.IotHubProperties
    :param sku: Required. IotHub SKU info
    :type sku: ~azure.mgmt.iothub.models.IotHubSkuInfo
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'IotHubProperties'},
        'sku': {'key': 'sku', 'type': 'IotHubSkuInfo'},
    }

    def __init__(self, *, location: str, sku, tags=None, etag: str=None, properties=None, **kwargs) -> None:
        super(IotHubDescription, self).__init__(location=location, tags=tags, **kwargs)
        self.etag = etag
        self.properties = properties
        self.sku = sku


class IotHubLocationDescription(Model):
    """Public representation of one of the locations where a resource is
    provisioned.

    :param location: The name of the Azure region
    :type location: str
    :param role: The role of the region, can be either primary or secondary.
     The primary region is where the IoT hub is currently provisioned. The
     secondary region is the Azure disaster recovery (DR) paired region and
     also the region where the IoT hub can failover to. Possible values
     include: 'primary', 'secondary'
    :type role: str or ~azure.mgmt.iothub.models.IotHubReplicaRoleType
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'role': {'key': 'role', 'type': 'str'},
    }

    def __init__(self, *, location: str=None, role=None, **kwargs) -> None:
        super(IotHubLocationDescription, self).__init__(**kwargs)
        self.location = location
        self.role = role


class IotHubNameAvailabilityInfo(Model):
    """The properties indicating whether a given IoT hub name is available.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name_available: The value which indicates whether the provided name
     is available.
    :vartype name_available: bool
    :ivar reason: The reason for unavailability. Possible values include:
     'Invalid', 'AlreadyExists'
    :vartype reason: str or
     ~azure.mgmt.iothub.models.IotHubNameUnavailabilityReason
    :param message: The detailed reason message.
    :type message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'IotHubNameUnavailabilityReason'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, message: str=None, **kwargs) -> None:
        super(IotHubNameAvailabilityInfo, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = message


class IotHubProperties(Model):
    """The properties of an IoT hub.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param authorization_policies: The shared access policies you can use to
     secure a connection to the IoT hub.
    :type authorization_policies:
     list[~azure.mgmt.iothub.models.SharedAccessSignatureAuthorizationRule]
    :param public_network_access: Whether requests from Public Network are
     allowed. Possible values include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.iothub.models.PublicNetworkAccess
    :param ip_filter_rules: The IP filter rules.
    :type ip_filter_rules: list[~azure.mgmt.iothub.models.IpFilterRule]
    :param min_tls_version: Specifies the minimum TLS version to support for
     this hub. Can be set to "1.2" to have clients that use a TLS version below
     1.2 to be rejected.
    :type min_tls_version: str
    :param private_endpoint_connections: Private endpoint connections created
     on this IotHub
    :type private_endpoint_connections:
     list[~azure.mgmt.iothub.models.PrivateEndpointConnection]
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :ivar state: The hub state.
    :vartype state: str
    :ivar host_name: The name of the host.
    :vartype host_name: str
    :param event_hub_endpoints: The Event Hub-compatible endpoint properties.
     The only possible keys to this dictionary is events. This key has to be
     present in the dictionary while making create or update calls for the IoT
     hub.
    :type event_hub_endpoints: dict[str,
     ~azure.mgmt.iothub.models.EventHubProperties]
    :param routing:
    :type routing: ~azure.mgmt.iothub.models.RoutingProperties
    :param storage_endpoints: The list of Azure Storage endpoints where you
     can upload files. Currently you can configure only one Azure Storage
     account and that MUST have its key as $default. Specifying more than one
     storage account causes an error to be thrown. Not specifying a value for
     this property when the enableFileUploadNotifications property is set to
     True, causes an error to be thrown.
    :type storage_endpoints: dict[str,
     ~azure.mgmt.iothub.models.StorageEndpointProperties]
    :param messaging_endpoints: The messaging endpoint properties for the file
     upload notification queue.
    :type messaging_endpoints: dict[str,
     ~azure.mgmt.iothub.models.MessagingEndpointProperties]
    :param enable_file_upload_notifications: If True, file upload
     notifications are enabled.
    :type enable_file_upload_notifications: bool
    :param cloud_to_device:
    :type cloud_to_device: ~azure.mgmt.iothub.models.CloudToDeviceProperties
    :param comments: IoT hub comments.
    :type comments: str
    :param features: The capabilities and features enabled for the IoT hub.
     Possible values include: 'None', 'DeviceManagement'
    :type features: str or ~azure.mgmt.iothub.models.Capabilities
    :ivar locations: Primary and secondary location for iot hub
    :vartype locations:
     list[~azure.mgmt.iothub.models.IotHubLocationDescription]
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'state': {'readonly': True},
        'host_name': {'readonly': True},
        'locations': {'readonly': True},
    }

    _attribute_map = {
        'authorization_policies': {'key': 'authorizationPolicies', 'type': '[SharedAccessSignatureAuthorizationRule]'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'ip_filter_rules': {'key': 'ipFilterRules', 'type': '[IpFilterRule]'},
        'min_tls_version': {'key': 'minTlsVersion', 'type': 'str'},
        'private_endpoint_connections': {'key': 'privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'event_hub_endpoints': {'key': 'eventHubEndpoints', 'type': '{EventHubProperties}'},
        'routing': {'key': 'routing', 'type': 'RoutingProperties'},
        'storage_endpoints': {'key': 'storageEndpoints', 'type': '{StorageEndpointProperties}'},
        'messaging_endpoints': {'key': 'messagingEndpoints', 'type': '{MessagingEndpointProperties}'},
        'enable_file_upload_notifications': {'key': 'enableFileUploadNotifications', 'type': 'bool'},
        'cloud_to_device': {'key': 'cloudToDevice', 'type': 'CloudToDeviceProperties'},
        'comments': {'key': 'comments', 'type': 'str'},
        'features': {'key': 'features', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[IotHubLocationDescription]'},
    }

    def __init__(self, *, authorization_policies=None, public_network_access=None, ip_filter_rules=None, min_tls_version: str=None, private_endpoint_connections=None, event_hub_endpoints=None, routing=None, storage_endpoints=None, messaging_endpoints=None, enable_file_upload_notifications: bool=None, cloud_to_device=None, comments: str=None, features=None, **kwargs) -> None:
        super(IotHubProperties, self).__init__(**kwargs)
        self.authorization_policies = authorization_policies
        self.public_network_access = public_network_access
        self.ip_filter_rules = ip_filter_rules
        self.min_tls_version = min_tls_version
        self.private_endpoint_connections = private_endpoint_connections
        self.provisioning_state = None
        self.state = None
        self.host_name = None
        self.event_hub_endpoints = event_hub_endpoints
        self.routing = routing
        self.storage_endpoints = storage_endpoints
        self.messaging_endpoints = messaging_endpoints
        self.enable_file_upload_notifications = enable_file_upload_notifications
        self.cloud_to_device = cloud_to_device
        self.comments = comments
        self.features = features
        self.locations = None


class IotHubQuotaMetricInfo(Model):
    """Quota metrics properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name of the quota metric.
    :vartype name: str
    :ivar current_value: The current value for the quota metric.
    :vartype current_value: long
    :ivar max_value: The maximum value of the quota metric.
    :vartype max_value: long
    """

    _validation = {
        'name': {'readonly': True},
        'current_value': {'readonly': True},
        'max_value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'max_value': {'key': 'maxValue', 'type': 'long'},
    }

    def __init__(self, **kwargs) -> None:
        super(IotHubQuotaMetricInfo, self).__init__(**kwargs)
        self.name = None
        self.current_value = None
        self.max_value = None


class IotHubSkuDescription(Model):
    """SKU properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The type of the resource.
    :vartype resource_type: str
    :param sku: Required. The type of the resource.
    :type sku: ~azure.mgmt.iothub.models.IotHubSkuInfo
    :param capacity: Required. IotHub capacity
    :type capacity: ~azure.mgmt.iothub.models.IotHubCapacity
    """

    _validation = {
        'resource_type': {'readonly': True},
        'sku': {'required': True},
        'capacity': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'IotHubSkuInfo'},
        'capacity': {'key': 'capacity', 'type': 'IotHubCapacity'},
    }

    def __init__(self, *, sku, capacity, **kwargs) -> None:
        super(IotHubSkuDescription, self).__init__(**kwargs)
        self.resource_type = None
        self.sku = sku
        self.capacity = capacity


class IotHubSkuInfo(Model):
    """Information about the SKU of the IoT hub.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the SKU. Possible values include: 'F1',
     'S1', 'S2', 'S3', 'B1', 'B2', 'B3'
    :type name: str or ~azure.mgmt.iothub.models.IotHubSku
    :ivar tier: The billing tier for the IoT hub. Possible values include:
     'Free', 'Standard', 'Basic'
    :vartype tier: str or ~azure.mgmt.iothub.models.IotHubSkuTier
    :param capacity: The number of provisioned IoT Hub units. See:
     https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
    :type capacity: long
    """

    _validation = {
        'name': {'required': True},
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'IotHubSkuTier'},
        'capacity': {'key': 'capacity', 'type': 'long'},
    }

    def __init__(self, *, name, capacity: int=None, **kwargs) -> None:
        super(IotHubSkuInfo, self).__init__(**kwargs)
        self.name = name
        self.tier = None
        self.capacity = capacity


class IpFilterRule(Model):
    """The IP filter rules for the IoT hub.

    All required parameters must be populated in order to send to Azure.

    :param filter_name: Required. The name of the IP filter rule.
    :type filter_name: str
    :param action: Required. The desired action for requests captured by this
     rule. Possible values include: 'Accept', 'Reject'
    :type action: str or ~azure.mgmt.iothub.models.IpFilterActionType
    :param ip_mask: Required. A string that contains the IP address range in
     CIDR notation for the rule.
    :type ip_mask: str
    """

    _validation = {
        'filter_name': {'required': True},
        'action': {'required': True},
        'ip_mask': {'required': True},
    }

    _attribute_map = {
        'filter_name': {'key': 'filterName', 'type': 'str'},
        'action': {'key': 'action', 'type': 'IpFilterActionType'},
        'ip_mask': {'key': 'ipMask', 'type': 'str'},
    }

    def __init__(self, *, filter_name: str, action, ip_mask: str, **kwargs) -> None:
        super(IpFilterRule, self).__init__(**kwargs)
        self.filter_name = filter_name
        self.action = action
        self.ip_mask = ip_mask


class JobResponse(Model):
    """The properties of the Job Response object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar job_id: The job identifier.
    :vartype job_id: str
    :ivar start_time_utc: The start time of the job.
    :vartype start_time_utc: datetime
    :ivar end_time_utc: The time the job stopped processing.
    :vartype end_time_utc: datetime
    :ivar type: The type of the job. Possible values include: 'unknown',
     'export', 'import', 'backup', 'readDeviceProperties',
     'writeDeviceProperties', 'updateDeviceConfiguration', 'rebootDevice',
     'factoryResetDevice', 'firmwareUpdate'
    :vartype type: str or ~azure.mgmt.iothub.models.JobType
    :ivar status: The status of the job. Possible values include: 'unknown',
     'enqueued', 'running', 'completed', 'failed', 'cancelled'
    :vartype status: str or ~azure.mgmt.iothub.models.JobStatus
    :ivar failure_reason: If status == failed, this string containing the
     reason for the failure.
    :vartype failure_reason: str
    :ivar status_message: The status message for the job.
    :vartype status_message: str
    :ivar parent_job_id: The job identifier of the parent job, if any.
    :vartype parent_job_id: str
    """

    _validation = {
        'job_id': {'readonly': True},
        'start_time_utc': {'readonly': True},
        'end_time_utc': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'failure_reason': {'readonly': True},
        'status_message': {'readonly': True},
        'parent_job_id': {'readonly': True},
    }

    _attribute_map = {
        'job_id': {'key': 'jobId', 'type': 'str'},
        'start_time_utc': {'key': 'startTimeUtc', 'type': 'rfc-1123'},
        'end_time_utc': {'key': 'endTimeUtc', 'type': 'rfc-1123'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'status', 'type': 'JobStatus'},
        'failure_reason': {'key': 'failureReason', 'type': 'str'},
        'status_message': {'key': 'statusMessage', 'type': 'str'},
        'parent_job_id': {'key': 'parentJobId', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(JobResponse, self).__init__(**kwargs)
        self.job_id = None
        self.start_time_utc = None
        self.end_time_utc = None
        self.type = None
        self.status = None
        self.failure_reason = None
        self.status_message = None
        self.parent_job_id = None


class MatchedRoute(Model):
    """Routes that matched.

    :param properties: Properties of routes that matched
    :type properties: ~azure.mgmt.iothub.models.RouteProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'RouteProperties'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(MatchedRoute, self).__init__(**kwargs)
        self.properties = properties


class MessagingEndpointProperties(Model):
    """The properties of the messaging endpoints used by this IoT hub.

    :param lock_duration_as_iso8601: The lock duration. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
    :type lock_duration_as_iso8601: timedelta
    :param ttl_as_iso8601: The period of time for which a message is available
     to consume before it is expired by the IoT hub. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
    :type ttl_as_iso8601: timedelta
    :param max_delivery_count: The number of times the IoT hub attempts to
     deliver a message. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
    :type max_delivery_count: int
    """

    _validation = {
        'max_delivery_count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'lock_duration_as_iso8601': {'key': 'lockDurationAsIso8601', 'type': 'duration'},
        'ttl_as_iso8601': {'key': 'ttlAsIso8601', 'type': 'duration'},
        'max_delivery_count': {'key': 'maxDeliveryCount', 'type': 'int'},
    }

    def __init__(self, *, lock_duration_as_iso8601=None, ttl_as_iso8601=None, max_delivery_count: int=None, **kwargs) -> None:
        super(MessagingEndpointProperties, self).__init__(**kwargs)
        self.lock_duration_as_iso8601 = lock_duration_as_iso8601
        self.ttl_as_iso8601 = ttl_as_iso8601
        self.max_delivery_count = max_delivery_count


class Name(Model):
    """Name of Iot Hub type.

    :param value: IotHub type
    :type value: str
    :param localized_value: Localized value of name
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, *, value: str=None, localized_value: str=None, **kwargs) -> None:
        super(Name, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class Operation(Model):
    """IoT Hub REST API operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Operation name: {provider}/{resource}/{read | write | action |
     delete}
    :vartype name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.iothub.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(self, *, display=None, **kwargs) -> None:
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = display


class OperationDisplay(Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar provider: Service provider: Microsoft Devices
    :vartype provider: str
    :ivar resource: Resource Type: IotHubs
    :vartype resource: str
    :ivar operation: Name of the operation
    :vartype operation: str
    :ivar description: Description of the operation
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationInputs(Model):
    """Input values.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the IoT hub to check.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name: str, **kwargs) -> None:
        super(OperationInputs, self).__init__(**kwargs)
        self.name = name


class PrivateEndpoint(Model):
    """The private endpoint property of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Model):
    """The private endpoint connection of an IotHub.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param properties: Required.
    :type properties:
     ~azure.mgmt.iothub.models.PrivateEndpointConnectionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateEndpointConnectionProperties'},
    }

    def __init__(self, *, properties, **kwargs) -> None:
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class PrivateEndpointConnectionProperties(Model):
    """The properties of a private endpoint connection.

    All required parameters must be populated in order to send to Azure.

    :param private_endpoint:
    :type private_endpoint: ~azure.mgmt.iothub.models.PrivateEndpoint
    :param private_link_service_connection_state: Required.
    :type private_link_service_connection_state:
     ~azure.mgmt.iothub.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        'private_link_service_connection_state': {'required': True},
    }

    _attribute_map = {
        'private_endpoint': {'key': 'privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
    }

    def __init__(self, *, private_link_service_connection_state, private_endpoint=None, **kwargs) -> None:
        super(PrivateEndpointConnectionProperties, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateLinkResources(Model):
    """The available private link resources for an IotHub.

    :param value: The list of available private link resources for an IotHub
    :type value: list[~azure.mgmt.iothub.models.GroupIdInformation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GroupIdInformation]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(PrivateLinkResources, self).__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(Model):
    """The current state of a private endpoint connection.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The status of a private endpoint connection.
     Possible values include: 'Pending', 'Approved', 'Rejected', 'Disconnected'
    :type status: str or
     ~azure.mgmt.iothub.models.PrivateLinkServiceConnectionStatus
    :param description: Required. The description for the current state of a
     private endpoint connection
    :type description: str
    :param actions_required: Actions required for a private endpoint
     connection
    :type actions_required: str
    """

    _validation = {
        'status': {'required': True},
        'description': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(self, *, status, description: str, actions_required: str=None, **kwargs) -> None:
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class RegistryStatistics(Model):
    """Identity registry statistics.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar total_device_count: The total count of devices in the identity
     registry.
    :vartype total_device_count: long
    :ivar enabled_device_count: The count of enabled devices in the identity
     registry.
    :vartype enabled_device_count: long
    :ivar disabled_device_count: The count of disabled devices in the identity
     registry.
    :vartype disabled_device_count: long
    """

    _validation = {
        'total_device_count': {'readonly': True},
        'enabled_device_count': {'readonly': True},
        'disabled_device_count': {'readonly': True},
    }

    _attribute_map = {
        'total_device_count': {'key': 'totalDeviceCount', 'type': 'long'},
        'enabled_device_count': {'key': 'enabledDeviceCount', 'type': 'long'},
        'disabled_device_count': {'key': 'disabledDeviceCount', 'type': 'long'},
    }

    def __init__(self, **kwargs) -> None:
        super(RegistryStatistics, self).__init__(**kwargs)
        self.total_device_count = None
        self.enabled_device_count = None
        self.disabled_device_count = None


class RouteCompilationError(Model):
    """Compilation error when evaluating route.

    :param message: Route error message
    :type message: str
    :param severity: Severity of the route error. Possible values include:
     'error', 'warning'
    :type severity: str or ~azure.mgmt.iothub.models.RouteErrorSeverity
    :param location: Location where the route error happened
    :type location: ~azure.mgmt.iothub.models.RouteErrorRange
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'location': {'key': 'location', 'type': 'RouteErrorRange'},
    }

    def __init__(self, *, message: str=None, severity=None, location=None, **kwargs) -> None:
        super(RouteCompilationError, self).__init__(**kwargs)
        self.message = message
        self.severity = severity
        self.location = location


class RouteErrorPosition(Model):
    """Position where the route error happened.

    :param line: Line where the route error happened
    :type line: int
    :param column: Column where the route error happened
    :type column: int
    """

    _attribute_map = {
        'line': {'key': 'line', 'type': 'int'},
        'column': {'key': 'column', 'type': 'int'},
    }

    def __init__(self, *, line: int=None, column: int=None, **kwargs) -> None:
        super(RouteErrorPosition, self).__init__(**kwargs)
        self.line = line
        self.column = column


class RouteErrorRange(Model):
    """Range of route errors.

    :param start: Start where the route error happened
    :type start: ~azure.mgmt.iothub.models.RouteErrorPosition
    :param end: End where the route error happened
    :type end: ~azure.mgmt.iothub.models.RouteErrorPosition
    """

    _attribute_map = {
        'start': {'key': 'start', 'type': 'RouteErrorPosition'},
        'end': {'key': 'end', 'type': 'RouteErrorPosition'},
    }

    def __init__(self, *, start=None, end=None, **kwargs) -> None:
        super(RouteErrorRange, self).__init__(**kwargs)
        self.start = start
        self.end = end


class RouteProperties(Model):
    """The properties of a routing rule that your IoT hub uses to route messages
    to endpoints.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the route. The name can only include
     alphanumeric characters, periods, underscores, hyphens, has a maximum
     length of 64 characters, and must be unique.
    :type name: str
    :param source: Required. The source that the routing rule is to be applied
     to, such as DeviceMessages. Possible values include: 'Invalid',
     'DeviceMessages', 'TwinChangeEvents', 'DeviceLifecycleEvents',
     'DeviceJobLifecycleEvents'
    :type source: str or ~azure.mgmt.iothub.models.RoutingSource
    :param condition: The condition that is evaluated to apply the routing
     rule. If no condition is provided, it evaluates to true by default. For
     grammar, see:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
    :type condition: str
    :param endpoint_names: Required. The list of endpoints to which messages
     that satisfy the condition are routed. Currently only one endpoint is
     allowed.
    :type endpoint_names: list[str]
    :param is_enabled: Required. Used to specify whether a route is enabled.
    :type is_enabled: bool
    """

    _validation = {
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
        'source': {'required': True},
        'endpoint_names': {'required': True, 'max_items': 1, 'min_items': 1},
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'condition': {'key': 'condition', 'type': 'str'},
        'endpoint_names': {'key': 'endpointNames', 'type': '[str]'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(self, *, name: str, source, endpoint_names, is_enabled: bool, condition: str=None, **kwargs) -> None:
        super(RouteProperties, self).__init__(**kwargs)
        self.name = name
        self.source = source
        self.condition = condition
        self.endpoint_names = endpoint_names
        self.is_enabled = is_enabled


class RoutingEndpoints(Model):
    """The properties related to the custom endpoints to which your IoT hub routes
    messages based on the routing rules. A maximum of 10 custom endpoints are
    allowed across all endpoint types for paid hubs and only 1 custom endpoint
    is allowed across all endpoint types for free hubs.

    :param service_bus_queues: The list of Service Bus queue endpoints that
     IoT hub routes the messages to, based on the routing rules.
    :type service_bus_queues:
     list[~azure.mgmt.iothub.models.RoutingServiceBusQueueEndpointProperties]
    :param service_bus_topics: The list of Service Bus topic endpoints that
     the IoT hub routes the messages to, based on the routing rules.
    :type service_bus_topics:
     list[~azure.mgmt.iothub.models.RoutingServiceBusTopicEndpointProperties]
    :param event_hubs: The list of Event Hubs endpoints that IoT hub routes
     messages to, based on the routing rules. This list does not include the
     built-in Event Hubs endpoint.
    :type event_hubs:
     list[~azure.mgmt.iothub.models.RoutingEventHubProperties]
    :param storage_containers: The list of storage container endpoints that
     IoT hub routes messages to, based on the routing rules.
    :type storage_containers:
     list[~azure.mgmt.iothub.models.RoutingStorageContainerProperties]
    """

    _attribute_map = {
        'service_bus_queues': {'key': 'serviceBusQueues', 'type': '[RoutingServiceBusQueueEndpointProperties]'},
        'service_bus_topics': {'key': 'serviceBusTopics', 'type': '[RoutingServiceBusTopicEndpointProperties]'},
        'event_hubs': {'key': 'eventHubs', 'type': '[RoutingEventHubProperties]'},
        'storage_containers': {'key': 'storageContainers', 'type': '[RoutingStorageContainerProperties]'},
    }

    def __init__(self, *, service_bus_queues=None, service_bus_topics=None, event_hubs=None, storage_containers=None, **kwargs) -> None:
        super(RoutingEndpoints, self).__init__(**kwargs)
        self.service_bus_queues = service_bus_queues
        self.service_bus_topics = service_bus_topics
        self.event_hubs = event_hubs
        self.storage_containers = storage_containers


class RoutingEventHubProperties(Model):
    """The properties related to an event hub endpoint.

    All required parameters must be populated in order to send to Azure.

    :param id: Id of the event hub endpoint
    :type id: str
    :param connection_string: The connection string of the event hub endpoint.
    :type connection_string: str
    :param endpoint_uri: The url of the event hub endpoint. It must include
     the protocol sb://
    :type endpoint_uri: str
    :param entity_path: Event hub name on the event hub namespace
    :type entity_path: str
    :param authentication_type: Method used to authenticate against the event
     hub endpoint. Possible values include: 'keyBased', 'identityBased'
    :type authentication_type: str or
     ~azure.mgmt.iothub.models.AuthenticationType
    :param name: Required. The name that identifies this endpoint. The name
     can only include alphanumeric characters, periods, underscores, hyphens
     and has a maximum length of 64 characters. The following names are
     reserved:  events, fileNotifications, $default. Endpoint names must be
     unique across endpoint types.
    :type name: str
    :param subscription_id: The subscription identifier of the event hub
     endpoint.
    :type subscription_id: str
    :param resource_group: The name of the resource group of the event hub
     endpoint.
    :type resource_group: str
    """

    _validation = {
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'endpoint_uri': {'key': 'endpointUri', 'type': 'str'},
        'entity_path': {'key': 'entityPath', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(self, *, name: str, id: str=None, connection_string: str=None, endpoint_uri: str=None, entity_path: str=None, authentication_type=None, subscription_id: str=None, resource_group: str=None, **kwargs) -> None:
        super(RoutingEventHubProperties, self).__init__(**kwargs)
        self.id = id
        self.connection_string = connection_string
        self.endpoint_uri = endpoint_uri
        self.entity_path = entity_path
        self.authentication_type = authentication_type
        self.name = name
        self.subscription_id = subscription_id
        self.resource_group = resource_group


class RoutingMessage(Model):
    """Routing message.

    :param body: Body of routing message
    :type body: str
    :param app_properties: App properties
    :type app_properties: dict[str, str]
    :param system_properties: System properties
    :type system_properties: dict[str, str]
    """

    _attribute_map = {
        'body': {'key': 'body', 'type': 'str'},
        'app_properties': {'key': 'appProperties', 'type': '{str}'},
        'system_properties': {'key': 'systemProperties', 'type': '{str}'},
    }

    def __init__(self, *, body: str=None, app_properties=None, system_properties=None, **kwargs) -> None:
        super(RoutingMessage, self).__init__(**kwargs)
        self.body = body
        self.app_properties = app_properties
        self.system_properties = system_properties


class RoutingProperties(Model):
    """The routing related properties of the IoT hub. See:
    https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging.

    :param endpoints:
    :type endpoints: ~azure.mgmt.iothub.models.RoutingEndpoints
    :param routes: The list of user-provided routing rules that the IoT hub
     uses to route messages to built-in and custom endpoints. A maximum of 100
     routing rules are allowed for paid hubs and a maximum of 5 routing rules
     are allowed for free hubs.
    :type routes: list[~azure.mgmt.iothub.models.RouteProperties]
    :param fallback_route: The properties of the route that is used as a
     fall-back route when none of the conditions specified in the 'routes'
     section are met. This is an optional parameter. When this property is not
     set, the messages which do not meet any of the conditions specified in the
     'routes' section get routed to the built-in eventhub endpoint.
    :type fallback_route: ~azure.mgmt.iothub.models.FallbackRouteProperties
    :param enrichments: The list of user-provided enrichments that the IoT hub
     applies to messages to be delivered to built-in and custom endpoints. See:
     https://aka.ms/telemetryoneventgrid
    :type enrichments: list[~azure.mgmt.iothub.models.EnrichmentProperties]
    """

    _attribute_map = {
        'endpoints': {'key': 'endpoints', 'type': 'RoutingEndpoints'},
        'routes': {'key': 'routes', 'type': '[RouteProperties]'},
        'fallback_route': {'key': 'fallbackRoute', 'type': 'FallbackRouteProperties'},
        'enrichments': {'key': 'enrichments', 'type': '[EnrichmentProperties]'},
    }

    def __init__(self, *, endpoints=None, routes=None, fallback_route=None, enrichments=None, **kwargs) -> None:
        super(RoutingProperties, self).__init__(**kwargs)
        self.endpoints = endpoints
        self.routes = routes
        self.fallback_route = fallback_route
        self.enrichments = enrichments


class RoutingServiceBusQueueEndpointProperties(Model):
    """The properties related to service bus queue endpoint types.

    All required parameters must be populated in order to send to Azure.

    :param id: Id of the service bus queue endpoint
    :type id: str
    :param connection_string: The connection string of the service bus queue
     endpoint.
    :type connection_string: str
    :param endpoint_uri: The url of the service bus queue endpoint. It must
     include the protocol sb://
    :type endpoint_uri: str
    :param entity_path: Queue name on the service bus namespace
    :type entity_path: str
    :param authentication_type: Method used to authenticate against the
     service bus queue endpoint. Possible values include: 'keyBased',
     'identityBased'
    :type authentication_type: str or
     ~azure.mgmt.iothub.models.AuthenticationType
    :param name: Required. The name that identifies this endpoint. The name
     can only include alphanumeric characters, periods, underscores, hyphens
     and has a maximum length of 64 characters. The following names are
     reserved:  events, fileNotifications, $default. Endpoint names must be
     unique across endpoint types. The name need not be the same as the actual
     queue name.
    :type name: str
    :param subscription_id: The subscription identifier of the service bus
     queue endpoint.
    :type subscription_id: str
    :param resource_group: The name of the resource group of the service bus
     queue endpoint.
    :type resource_group: str
    """

    _validation = {
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'endpoint_uri': {'key': 'endpointUri', 'type': 'str'},
        'entity_path': {'key': 'entityPath', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(self, *, name: str, id: str=None, connection_string: str=None, endpoint_uri: str=None, entity_path: str=None, authentication_type=None, subscription_id: str=None, resource_group: str=None, **kwargs) -> None:
        super(RoutingServiceBusQueueEndpointProperties, self).__init__(**kwargs)
        self.id = id
        self.connection_string = connection_string
        self.endpoint_uri = endpoint_uri
        self.entity_path = entity_path
        self.authentication_type = authentication_type
        self.name = name
        self.subscription_id = subscription_id
        self.resource_group = resource_group


class RoutingServiceBusTopicEndpointProperties(Model):
    """The properties related to service bus topic endpoint types.

    All required parameters must be populated in order to send to Azure.

    :param id: Id of the service bus topic endpoint
    :type id: str
    :param connection_string: The connection string of the service bus topic
     endpoint.
    :type connection_string: str
    :param endpoint_uri: The url of the service bus topic endpoint. It must
     include the protocol sb://
    :type endpoint_uri: str
    :param entity_path: Queue name on the service bus topic
    :type entity_path: str
    :param authentication_type: Method used to authenticate against the
     service bus topic endpoint. Possible values include: 'keyBased',
     'identityBased'
    :type authentication_type: str or
     ~azure.mgmt.iothub.models.AuthenticationType
    :param name: Required. The name that identifies this endpoint. The name
     can only include alphanumeric characters, periods, underscores, hyphens
     and has a maximum length of 64 characters. The following names are
     reserved:  events, fileNotifications, $default. Endpoint names must be
     unique across endpoint types.  The name need not be the same as the actual
     topic name.
    :type name: str
    :param subscription_id: The subscription identifier of the service bus
     topic endpoint.
    :type subscription_id: str
    :param resource_group: The name of the resource group of the service bus
     topic endpoint.
    :type resource_group: str
    """

    _validation = {
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'endpoint_uri': {'key': 'endpointUri', 'type': 'str'},
        'entity_path': {'key': 'entityPath', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(self, *, name: str, id: str=None, connection_string: str=None, endpoint_uri: str=None, entity_path: str=None, authentication_type=None, subscription_id: str=None, resource_group: str=None, **kwargs) -> None:
        super(RoutingServiceBusTopicEndpointProperties, self).__init__(**kwargs)
        self.id = id
        self.connection_string = connection_string
        self.endpoint_uri = endpoint_uri
        self.entity_path = entity_path
        self.authentication_type = authentication_type
        self.name = name
        self.subscription_id = subscription_id
        self.resource_group = resource_group


class RoutingStorageContainerProperties(Model):
    """The properties related to a storage container endpoint.

    All required parameters must be populated in order to send to Azure.

    :param id: Id of the storage container endpoint
    :type id: str
    :param connection_string: The connection string of the storage account.
    :type connection_string: str
    :param endpoint_uri: The url of the storage endpoint. It must include the
     protocol https://
    :type endpoint_uri: str
    :param authentication_type: Method used to authenticate against the
     storage endpoint. Possible values include: 'keyBased', 'identityBased'
    :type authentication_type: str or
     ~azure.mgmt.iothub.models.AuthenticationType
    :param name: Required. The name that identifies this endpoint. The name
     can only include alphanumeric characters, periods, underscores, hyphens
     and has a maximum length of 64 characters. The following names are
     reserved:  events, fileNotifications, $default. Endpoint names must be
     unique across endpoint types.
    :type name: str
    :param subscription_id: The subscription identifier of the storage
     account.
    :type subscription_id: str
    :param resource_group: The name of the resource group of the storage
     account.
    :type resource_group: str
    :param container_name: Required. The name of storage container in the
     storage account.
    :type container_name: str
    :param file_name_format: File name format for the blob. Default format is
     {iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}. All parameters are
     mandatory but can be reordered.
    :type file_name_format: str
    :param batch_frequency_in_seconds: Time interval at which blobs are
     written to storage. Value should be between 60 and 720 seconds. Default
     value is 300 seconds.
    :type batch_frequency_in_seconds: int
    :param max_chunk_size_in_bytes: Maximum number of bytes for each blob
     written to storage. Value should be between 10485760(10MB) and
     524288000(500MB). Default value is 314572800(300MB).
    :type max_chunk_size_in_bytes: int
    :param encoding: Encoding that is used to serialize messages to blobs.
     Supported values are 'avro', 'avrodeflate', and 'JSON'. Default value is
     'avro'. Possible values include: 'Avro', 'AvroDeflate', 'JSON'
    :type encoding: str or ~azure.mgmt.iothub.models.enum
    """

    _validation = {
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
        'container_name': {'required': True},
        'batch_frequency_in_seconds': {'maximum': 720, 'minimum': 60},
        'max_chunk_size_in_bytes': {'maximum': 524288000, 'minimum': 10485760},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'endpoint_uri': {'key': 'endpointUri', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'file_name_format': {'key': 'fileNameFormat', 'type': 'str'},
        'batch_frequency_in_seconds': {'key': 'batchFrequencyInSeconds', 'type': 'int'},
        'max_chunk_size_in_bytes': {'key': 'maxChunkSizeInBytes', 'type': 'int'},
        'encoding': {'key': 'encoding', 'type': 'str'},
    }

    def __init__(self, *, name: str, container_name: str, id: str=None, connection_string: str=None, endpoint_uri: str=None, authentication_type=None, subscription_id: str=None, resource_group: str=None, file_name_format: str=None, batch_frequency_in_seconds: int=None, max_chunk_size_in_bytes: int=None, encoding=None, **kwargs) -> None:
        super(RoutingStorageContainerProperties, self).__init__(**kwargs)
        self.id = id
        self.connection_string = connection_string
        self.endpoint_uri = endpoint_uri
        self.authentication_type = authentication_type
        self.name = name
        self.subscription_id = subscription_id
        self.resource_group = resource_group
        self.container_name = container_name
        self.file_name_format = file_name_format
        self.batch_frequency_in_seconds = batch_frequency_in_seconds
        self.max_chunk_size_in_bytes = max_chunk_size_in_bytes
        self.encoding = encoding


class RoutingTwin(Model):
    """Twin reference input parameter. This is an optional parameter.

    :param tags: Twin Tags
    :type tags: object
    :param properties:
    :type properties: ~azure.mgmt.iothub.models.RoutingTwinProperties
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': 'object'},
        'properties': {'key': 'properties', 'type': 'RoutingTwinProperties'},
    }

    def __init__(self, *, tags=None, properties=None, **kwargs) -> None:
        super(RoutingTwin, self).__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class RoutingTwinProperties(Model):
    """RoutingTwinProperties.

    :param desired: Twin desired properties
    :type desired: object
    :param reported: Twin desired properties
    :type reported: object
    """

    _attribute_map = {
        'desired': {'key': 'desired', 'type': 'object'},
        'reported': {'key': 'reported', 'type': 'object'},
    }

    def __init__(self, *, desired=None, reported=None, **kwargs) -> None:
        super(RoutingTwinProperties, self).__init__(**kwargs)
        self.desired = desired
        self.reported = reported


class SharedAccessSignatureAuthorizationRule(Model):
    """The properties of an IoT hub shared access policy.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. The name of the shared access policy.
    :type key_name: str
    :param primary_key: The primary key.
    :type primary_key: str
    :param secondary_key: The secondary key.
    :type secondary_key: str
    :param rights: Required. The permissions assigned to the shared access
     policy. Possible values include: 'RegistryRead', 'RegistryWrite',
     'ServiceConnect', 'DeviceConnect', 'RegistryRead, RegistryWrite',
     'RegistryRead, ServiceConnect', 'RegistryRead, DeviceConnect',
     'RegistryWrite, ServiceConnect', 'RegistryWrite, DeviceConnect',
     'ServiceConnect, DeviceConnect', 'RegistryRead, RegistryWrite,
     ServiceConnect', 'RegistryRead, RegistryWrite, DeviceConnect',
     'RegistryRead, ServiceConnect, DeviceConnect', 'RegistryWrite,
     ServiceConnect, DeviceConnect', 'RegistryRead, RegistryWrite,
     ServiceConnect, DeviceConnect'
    :type rights: str or ~azure.mgmt.iothub.models.AccessRights
    """

    _validation = {
        'key_name': {'required': True},
        'rights': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
        'rights': {'key': 'rights', 'type': 'AccessRights'},
    }

    def __init__(self, *, key_name: str, rights, primary_key: str=None, secondary_key: str=None, **kwargs) -> None:
        super(SharedAccessSignatureAuthorizationRule, self).__init__(**kwargs)
        self.key_name = key_name
        self.primary_key = primary_key
        self.secondary_key = secondary_key
        self.rights = rights


class StorageEndpointProperties(Model):
    """The properties of the Azure Storage endpoint for file upload.

    All required parameters must be populated in order to send to Azure.

    :param sas_ttl_as_iso8601: The period of time for which the SAS URI
     generated by IoT Hub for file upload is valid. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options.
    :type sas_ttl_as_iso8601: timedelta
    :param connection_string: Required. The connection string for the Azure
     Storage account to which files are uploaded.
    :type connection_string: str
    :param container_name: Required. The name of the root container where you
     upload files. The container need not exist but should be creatable using
     the connectionString specified.
    :type container_name: str
    :param authentication_type: Specifies authentication type being used for
     connecting to the storage account. Possible values include: 'keyBased',
     'identityBased'
    :type authentication_type: str or
     ~azure.mgmt.iothub.models.AuthenticationType
    """

    _validation = {
        'connection_string': {'required': True},
        'container_name': {'required': True},
    }

    _attribute_map = {
        'sas_ttl_as_iso8601': {'key': 'sasTtlAsIso8601', 'type': 'duration'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
    }

    def __init__(self, *, connection_string: str, container_name: str, sas_ttl_as_iso8601=None, authentication_type=None, **kwargs) -> None:
        super(StorageEndpointProperties, self).__init__(**kwargs)
        self.sas_ttl_as_iso8601 = sas_ttl_as_iso8601
        self.connection_string = connection_string
        self.container_name = container_name
        self.authentication_type = authentication_type


class TagsResource(Model):
    """A container holding only the Tags for a resource, allowing the user to
    update the tags on an IoT Hub instance.

    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, tags=None, **kwargs) -> None:
        super(TagsResource, self).__init__(**kwargs)
        self.tags = tags


class TestAllRoutesInput(Model):
    """Input for testing all routes.

    :param routing_source: Routing source. Possible values include: 'Invalid',
     'DeviceMessages', 'TwinChangeEvents', 'DeviceLifecycleEvents',
     'DeviceJobLifecycleEvents'
    :type routing_source: str or ~azure.mgmt.iothub.models.RoutingSource
    :param message: Routing message
    :type message: ~azure.mgmt.iothub.models.RoutingMessage
    :param twin: Routing Twin Reference
    :type twin: ~azure.mgmt.iothub.models.RoutingTwin
    """

    _attribute_map = {
        'routing_source': {'key': 'routingSource', 'type': 'str'},
        'message': {'key': 'message', 'type': 'RoutingMessage'},
        'twin': {'key': 'twin', 'type': 'RoutingTwin'},
    }

    def __init__(self, *, routing_source=None, message=None, twin=None, **kwargs) -> None:
        super(TestAllRoutesInput, self).__init__(**kwargs)
        self.routing_source = routing_source
        self.message = message
        self.twin = twin


class TestAllRoutesResult(Model):
    """Result of testing all routes.

    :param routes: JSON-serialized array of matched routes
    :type routes: list[~azure.mgmt.iothub.models.MatchedRoute]
    """

    _attribute_map = {
        'routes': {'key': 'routes', 'type': '[MatchedRoute]'},
    }

    def __init__(self, *, routes=None, **kwargs) -> None:
        super(TestAllRoutesResult, self).__init__(**kwargs)
        self.routes = routes


class TestRouteInput(Model):
    """Input for testing route.

    All required parameters must be populated in order to send to Azure.

    :param message: Routing message
    :type message: ~azure.mgmt.iothub.models.RoutingMessage
    :param route: Required. Route properties
    :type route: ~azure.mgmt.iothub.models.RouteProperties
    :param twin: Routing Twin Reference
    :type twin: ~azure.mgmt.iothub.models.RoutingTwin
    """

    _validation = {
        'route': {'required': True},
    }

    _attribute_map = {
        'message': {'key': 'message', 'type': 'RoutingMessage'},
        'route': {'key': 'route', 'type': 'RouteProperties'},
        'twin': {'key': 'twin', 'type': 'RoutingTwin'},
    }

    def __init__(self, *, route, message=None, twin=None, **kwargs) -> None:
        super(TestRouteInput, self).__init__(**kwargs)
        self.message = message
        self.route = route
        self.twin = twin


class TestRouteResult(Model):
    """Result of testing one route.

    :param result: Result of testing route. Possible values include:
     'undefined', 'false', 'true'
    :type result: str or ~azure.mgmt.iothub.models.TestResultStatus
    :param details: Detailed result of testing route
    :type details: ~azure.mgmt.iothub.models.TestRouteResultDetails
    """

    _attribute_map = {
        'result': {'key': 'result', 'type': 'str'},
        'details': {'key': 'details', 'type': 'TestRouteResultDetails'},
    }

    def __init__(self, *, result=None, details=None, **kwargs) -> None:
        super(TestRouteResult, self).__init__(**kwargs)
        self.result = result
        self.details = details


class TestRouteResultDetails(Model):
    """Detailed result of testing a route.

    :param compilation_errors: JSON-serialized list of route compilation
     errors
    :type compilation_errors:
     list[~azure.mgmt.iothub.models.RouteCompilationError]
    """

    _attribute_map = {
        'compilation_errors': {'key': 'compilationErrors', 'type': '[RouteCompilationError]'},
    }

    def __init__(self, *, compilation_errors=None, **kwargs) -> None:
        super(TestRouteResultDetails, self).__init__(**kwargs)
        self.compilation_errors = compilation_errors


class UserSubscriptionQuota(Model):
    """User subscription quota response.

    :param id: IotHub type id
    :type id: str
    :param type: Response type
    :type type: str
    :param unit: Unit of IotHub type
    :type unit: str
    :param current_value: Current number of IotHub type
    :type current_value: int
    :param limit: Numerical limit on IotHub type
    :type limit: int
    :param name: IotHub type
    :type name: ~azure.mgmt.iothub.models.Name
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
        'name': {'key': 'name', 'type': 'Name'},
    }

    def __init__(self, *, id: str=None, type: str=None, unit: str=None, current_value: int=None, limit: int=None, name=None, **kwargs) -> None:
        super(UserSubscriptionQuota, self).__init__(**kwargs)
        self.id = id
        self.type = type
        self.unit = unit
        self.current_value = current_value
        self.limit = limit
        self.name = name


class UserSubscriptionQuotaListResult(Model):
    """Json-serialized array of User subscription quota response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param value:
    :type value: list[~azure.mgmt.iothub.models.UserSubscriptionQuota]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UserSubscriptionQuota]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(UserSubscriptionQuotaListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None
