# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class Resource(Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have
    everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ProxyResource, self).__init__(**kwargs)


class Application(ProxyResource):
    """The HDInsight cluster application.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param etag: The ETag for the application
    :type etag: str
    :param tags: The tags for the application.
    :type tags: dict[str, str]
    :param properties: The properties of the application.
    :type properties: ~azure.mgmt.hdinsight.models.ApplicationProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'ApplicationProperties'},
    }

    def __init__(self, **kwargs):
        super(Application, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.tags = kwargs.get('tags', None)
        self.properties = kwargs.get('properties', None)


class ApplicationGetEndpoint(Model):
    """Gets the application SSH endpoint.

    :param location: The location of the endpoint.
    :type location: str
    :param destination_port: The destination port to connect to.
    :type destination_port: int
    :param public_port: The public port to connect to.
    :type public_port: int
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'destination_port': {'key': 'destinationPort', 'type': 'int'},
        'public_port': {'key': 'publicPort', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGetEndpoint, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.destination_port = kwargs.get('destination_port', None)
        self.public_port = kwargs.get('public_port', None)


class ApplicationGetHttpsEndpoint(Model):
    """Gets the application HTTP endpoints.

    :param access_modes: The list of access modes for the application.
    :type access_modes: list[str]
    :param location: The location of the endpoint.
    :type location: str
    :param destination_port: The destination port to connect to.
    :type destination_port: int
    :param public_port: The public port to connect to.
    :type public_port: int
    :param sub_domain_suffix: The subDomainSuffix of the application.
    :type sub_domain_suffix: str
    :param disable_gateway_auth: The value indicates whether to disable
     GatewayAuth.
    :type disable_gateway_auth: bool
    """

    _attribute_map = {
        'access_modes': {'key': 'accessModes', 'type': '[str]'},
        'location': {'key': 'location', 'type': 'str'},
        'destination_port': {'key': 'destinationPort', 'type': 'int'},
        'public_port': {'key': 'publicPort', 'type': 'int'},
        'sub_domain_suffix': {'key': 'subDomainSuffix', 'type': 'str'},
        'disable_gateway_auth': {'key': 'disableGatewayAuth', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGetHttpsEndpoint, self).__init__(**kwargs)
        self.access_modes = kwargs.get('access_modes', None)
        self.location = kwargs.get('location', None)
        self.destination_port = kwargs.get('destination_port', None)
        self.public_port = kwargs.get('public_port', None)
        self.sub_domain_suffix = kwargs.get('sub_domain_suffix', None)
        self.disable_gateway_auth = kwargs.get('disable_gateway_auth', None)


class ApplicationProperties(Model):
    """The HDInsight cluster application GET response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param compute_profile: The list of roles in the cluster.
    :type compute_profile: ~azure.mgmt.hdinsight.models.ComputeProfile
    :param install_script_actions: The list of install script actions.
    :type install_script_actions:
     list[~azure.mgmt.hdinsight.models.RuntimeScriptAction]
    :param uninstall_script_actions: The list of uninstall script actions.
    :type uninstall_script_actions:
     list[~azure.mgmt.hdinsight.models.RuntimeScriptAction]
    :param https_endpoints: The list of application HTTPS endpoints.
    :type https_endpoints:
     list[~azure.mgmt.hdinsight.models.ApplicationGetHttpsEndpoint]
    :param ssh_endpoints: The list of application SSH endpoints.
    :type ssh_endpoints:
     list[~azure.mgmt.hdinsight.models.ApplicationGetEndpoint]
    :ivar provisioning_state: The provisioning state of the application.
    :vartype provisioning_state: str
    :param application_type: The application type.
    :type application_type: str
    :ivar application_state: The application state.
    :vartype application_state: str
    :param errors: The list of errors.
    :type errors: list[~azure.mgmt.hdinsight.models.Errors]
    :ivar created_date: The application create date time.
    :vartype created_date: str
    :ivar marketplace_identifier: The marketplace identifier.
    :vartype marketplace_identifier: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'application_state': {'readonly': True},
        'created_date': {'readonly': True},
        'marketplace_identifier': {'readonly': True},
    }

    _attribute_map = {
        'compute_profile': {'key': 'computeProfile', 'type': 'ComputeProfile'},
        'install_script_actions': {'key': 'installScriptActions', 'type': '[RuntimeScriptAction]'},
        'uninstall_script_actions': {'key': 'uninstallScriptActions', 'type': '[RuntimeScriptAction]'},
        'https_endpoints': {'key': 'httpsEndpoints', 'type': '[ApplicationGetHttpsEndpoint]'},
        'ssh_endpoints': {'key': 'sshEndpoints', 'type': '[ApplicationGetEndpoint]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'application_type': {'key': 'applicationType', 'type': 'str'},
        'application_state': {'key': 'applicationState', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[Errors]'},
        'created_date': {'key': 'createdDate', 'type': 'str'},
        'marketplace_identifier': {'key': 'marketplaceIdentifier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationProperties, self).__init__(**kwargs)
        self.compute_profile = kwargs.get('compute_profile', None)
        self.install_script_actions = kwargs.get('install_script_actions', None)
        self.uninstall_script_actions = kwargs.get('uninstall_script_actions', None)
        self.https_endpoints = kwargs.get('https_endpoints', None)
        self.ssh_endpoints = kwargs.get('ssh_endpoints', None)
        self.provisioning_state = None
        self.application_type = kwargs.get('application_type', None)
        self.application_state = None
        self.errors = kwargs.get('errors', None)
        self.created_date = None
        self.marketplace_identifier = None


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The Azure Region where the resource lives
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class Cluster(TrackedResource):
    """The HDInsight cluster.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The Azure Region where the resource lives
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param etag: The ETag for the resource
    :type etag: str
    :param properties: The properties of the cluster.
    :type properties: ~azure.mgmt.hdinsight.models.ClusterGetProperties
    :param identity: The identity of the cluster, if configured.
    :type identity: ~azure.mgmt.hdinsight.models.ClusterIdentity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ClusterGetProperties'},
        'identity': {'key': 'identity', 'type': 'ClusterIdentity'},
    }

    def __init__(self, **kwargs):
        super(Cluster, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.properties = kwargs.get('properties', None)
        self.identity = kwargs.get('identity', None)


class ClusterConfigurations(Model):
    """The configuration object for the specified cluster.

    :param configurations: The configuration object for the specified
     configuration for the specified cluster.
    :type configurations: dict[str, dict[str, str]]
    """

    _attribute_map = {
        'configurations': {'key': 'configurations', 'type': '{{str}}'},
    }

    def __init__(self, **kwargs):
        super(ClusterConfigurations, self).__init__(**kwargs)
        self.configurations = kwargs.get('configurations', None)


class ClusterCreateParametersExtended(Model):
    """The CreateCluster request parameters.

    :param location: The location of the cluster.
    :type location: str
    :param tags: The resource tags.
    :type tags: dict[str, str]
    :param properties: The cluster create parameters.
    :type properties: ~azure.mgmt.hdinsight.models.ClusterCreateProperties
    :param identity: The identity of the cluster, if configured.
    :type identity: ~azure.mgmt.hdinsight.models.ClusterIdentity
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'ClusterCreateProperties'},
        'identity': {'key': 'identity', 'type': 'ClusterIdentity'},
    }

    def __init__(self, **kwargs):
        super(ClusterCreateParametersExtended, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)
        self.properties = kwargs.get('properties', None)
        self.identity = kwargs.get('identity', None)


class ClusterCreateProperties(Model):
    """The cluster create parameters.

    :param cluster_version: The version of the cluster.
    :type cluster_version: str
    :param os_type: The type of operating system. Possible values include:
     'Windows', 'Linux'
    :type os_type: str or ~azure.mgmt.hdinsight.models.OSType
    :param tier: The cluster tier. Possible values include: 'Standard',
     'Premium'
    :type tier: str or ~azure.mgmt.hdinsight.models.Tier
    :param cluster_definition: The cluster definition.
    :type cluster_definition: ~azure.mgmt.hdinsight.models.ClusterDefinition
    :param security_profile: The security profile.
    :type security_profile: ~azure.mgmt.hdinsight.models.SecurityProfile
    :param compute_profile: The compute profile.
    :type compute_profile: ~azure.mgmt.hdinsight.models.ComputeProfile
    :param storage_profile: The storage profile.
    :type storage_profile: ~azure.mgmt.hdinsight.models.StorageProfile
    :param disk_encryption_properties: The disk encryption properties.
    :type disk_encryption_properties:
     ~azure.mgmt.hdinsight.models.DiskEncryptionProperties
    """

    _attribute_map = {
        'cluster_version': {'key': 'clusterVersion', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'OSType'},
        'tier': {'key': 'tier', 'type': 'Tier'},
        'cluster_definition': {'key': 'clusterDefinition', 'type': 'ClusterDefinition'},
        'security_profile': {'key': 'securityProfile', 'type': 'SecurityProfile'},
        'compute_profile': {'key': 'computeProfile', 'type': 'ComputeProfile'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'disk_encryption_properties': {'key': 'diskEncryptionProperties', 'type': 'DiskEncryptionProperties'},
    }

    def __init__(self, **kwargs):
        super(ClusterCreateProperties, self).__init__(**kwargs)
        self.cluster_version = kwargs.get('cluster_version', None)
        self.os_type = kwargs.get('os_type', None)
        self.tier = kwargs.get('tier', None)
        self.cluster_definition = kwargs.get('cluster_definition', None)
        self.security_profile = kwargs.get('security_profile', None)
        self.compute_profile = kwargs.get('compute_profile', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.disk_encryption_properties = kwargs.get('disk_encryption_properties', None)


class ClusterDefinition(Model):
    """The cluster definition.

    :param blueprint: The link to the blueprint.
    :type blueprint: str
    :param kind: The type of cluster.
    :type kind: str
    :param component_version: The versions of different services in the
     cluster.
    :type component_version: dict[str, str]
    :param configurations: The cluster configurations.
    :type configurations: object
    """

    _attribute_map = {
        'blueprint': {'key': 'blueprint', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'component_version': {'key': 'componentVersion', 'type': '{str}'},
        'configurations': {'key': 'configurations', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(ClusterDefinition, self).__init__(**kwargs)
        self.blueprint = kwargs.get('blueprint', None)
        self.kind = kwargs.get('kind', None)
        self.component_version = kwargs.get('component_version', None)
        self.configurations = kwargs.get('configurations', None)


class ClusterDiskEncryptionParameters(Model):
    """The Disk Encryption Cluster request parameters.

    :param vault_uri: Base key vault URI where the customers key is located
     eg. https://myvault.vault.azure.net
    :type vault_uri: str
    :param key_name: Key name that is used for enabling disk encryption.
    :type key_name: str
    :param key_version: Specific key version that is used for enabling disk
     encryption.
    :type key_version: str
    """

    _attribute_map = {
        'vault_uri': {'key': 'vaultUri', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
        'key_version': {'key': 'keyVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClusterDiskEncryptionParameters, self).__init__(**kwargs)
        self.vault_uri = kwargs.get('vault_uri', None)
        self.key_name = kwargs.get('key_name', None)
        self.key_version = kwargs.get('key_version', None)


class ClusterGetProperties(Model):
    """The properties of cluster.

    All required parameters must be populated in order to send to Azure.

    :param cluster_version: The version of the cluster.
    :type cluster_version: str
    :param os_type: The type of operating system. Possible values include:
     'Windows', 'Linux'
    :type os_type: str or ~azure.mgmt.hdinsight.models.OSType
    :param tier: The cluster tier. Possible values include: 'Standard',
     'Premium'
    :type tier: str or ~azure.mgmt.hdinsight.models.Tier
    :param cluster_definition: Required. The cluster definition.
    :type cluster_definition: ~azure.mgmt.hdinsight.models.ClusterDefinition
    :param security_profile: The security profile.
    :type security_profile: ~azure.mgmt.hdinsight.models.SecurityProfile
    :param compute_profile: The compute profile.
    :type compute_profile: ~azure.mgmt.hdinsight.models.ComputeProfile
    :param provisioning_state: The provisioning state, which only appears in
     the response. Possible values include: 'InProgress', 'Failed',
     'Succeeded', 'Canceled', 'Deleting'
    :type provisioning_state: str or
     ~azure.mgmt.hdinsight.models.HDInsightClusterProvisioningState
    :param created_date: The date on which the cluster was created.
    :type created_date: str
    :param cluster_state: The state of the cluster.
    :type cluster_state: str
    :param quota_info: The quota information.
    :type quota_info: ~azure.mgmt.hdinsight.models.QuotaInfo
    :param errors: The list of errors.
    :type errors: list[~azure.mgmt.hdinsight.models.Errors]
    :param connectivity_endpoints: The list of connectivity endpoints.
    :type connectivity_endpoints:
     list[~azure.mgmt.hdinsight.models.ConnectivityEndpoint]
    :param disk_encryption_properties: The disk encryption properties.
    :type disk_encryption_properties:
     ~azure.mgmt.hdinsight.models.DiskEncryptionProperties
    """

    _validation = {
        'cluster_definition': {'required': True},
    }

    _attribute_map = {
        'cluster_version': {'key': 'clusterVersion', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'OSType'},
        'tier': {'key': 'tier', 'type': 'Tier'},
        'cluster_definition': {'key': 'clusterDefinition', 'type': 'ClusterDefinition'},
        'security_profile': {'key': 'securityProfile', 'type': 'SecurityProfile'},
        'compute_profile': {'key': 'computeProfile', 'type': 'ComputeProfile'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'HDInsightClusterProvisioningState'},
        'created_date': {'key': 'createdDate', 'type': 'str'},
        'cluster_state': {'key': 'clusterState', 'type': 'str'},
        'quota_info': {'key': 'quotaInfo', 'type': 'QuotaInfo'},
        'errors': {'key': 'errors', 'type': '[Errors]'},
        'connectivity_endpoints': {'key': 'connectivityEndpoints', 'type': '[ConnectivityEndpoint]'},
        'disk_encryption_properties': {'key': 'diskEncryptionProperties', 'type': 'DiskEncryptionProperties'},
    }

    def __init__(self, **kwargs):
        super(ClusterGetProperties, self).__init__(**kwargs)
        self.cluster_version = kwargs.get('cluster_version', None)
        self.os_type = kwargs.get('os_type', None)
        self.tier = kwargs.get('tier', None)
        self.cluster_definition = kwargs.get('cluster_definition', None)
        self.security_profile = kwargs.get('security_profile', None)
        self.compute_profile = kwargs.get('compute_profile', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.created_date = kwargs.get('created_date', None)
        self.cluster_state = kwargs.get('cluster_state', None)
        self.quota_info = kwargs.get('quota_info', None)
        self.errors = kwargs.get('errors', None)
        self.connectivity_endpoints = kwargs.get('connectivity_endpoints', None)
        self.disk_encryption_properties = kwargs.get('disk_encryption_properties', None)


class ClusterIdentity(Model):
    """Identity for the cluster.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: The principal id of cluster identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the cluster. This property
     will only be provided for a system assigned identity.
    :vartype tenant_id: str
    :param type: The type of identity used for the cluster. The type
     'SystemAssigned, UserAssigned' includes both an implicitly created
     identity and a set of user assigned identities. Possible values include:
     'SystemAssigned', 'UserAssigned', 'SystemAssigned, UserAssigned', 'None'
    :type type: str or ~azure.mgmt.hdinsight.models.ResourceIdentityType
    :param user_assigned_identities: The list of user identities associated
     with the cluster. The user identity dictionary key references will be ARM
     resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.hdinsight.models.ClusterIdentityUserAssignedIdentitiesValue]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'ResourceIdentityType'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{ClusterIdentityUserAssignedIdentitiesValue}'},
    }

    def __init__(self, **kwargs):
        super(ClusterIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class ClusterIdentityUserAssignedIdentitiesValue(Model):
    """ClusterIdentityUserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClusterIdentityUserAssignedIdentitiesValue, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class ClusterListPersistedScriptActionsResult(Model):
    """The ListPersistedScriptActions operation response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param value: The list of Persisted Script Actions.
    :type value: list[~azure.mgmt.hdinsight.models.RuntimeScriptAction]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RuntimeScriptAction]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClusterListPersistedScriptActionsResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ClusterListRuntimeScriptActionDetailResult(Model):
    """The list runtime script action detail response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: The list of persisted script action details for the cluster.
    :vartype value:
     list[~azure.mgmt.hdinsight.models.RuntimeScriptActionDetail]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RuntimeScriptActionDetail]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClusterListRuntimeScriptActionDetailResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ClusterMonitoringRequest(Model):
    """The Operations Management Suite (OMS) parameters.

    :param workspace_id: The Operations Management Suite (OMS) workspace ID.
    :type workspace_id: str
    :param primary_key: The Operations Management Suite (OMS) workspace key.
    :type primary_key: str
    """

    _attribute_map = {
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClusterMonitoringRequest, self).__init__(**kwargs)
        self.workspace_id = kwargs.get('workspace_id', None)
        self.primary_key = kwargs.get('primary_key', None)


class ClusterMonitoringResponse(Model):
    """The Operations Management Suite (OMS) status response.

    :param cluster_monitoring_enabled: The status of the Operations Management
     Suite (OMS) on the HDInsight cluster.
    :type cluster_monitoring_enabled: bool
    :param workspace_id: The workspace ID of the Operations Management Suite
     (OMS) on the HDInsight cluster.
    :type workspace_id: str
    """

    _attribute_map = {
        'cluster_monitoring_enabled': {'key': 'clusterMonitoringEnabled', 'type': 'bool'},
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ClusterMonitoringResponse, self).__init__(**kwargs)
        self.cluster_monitoring_enabled = kwargs.get('cluster_monitoring_enabled', None)
        self.workspace_id = kwargs.get('workspace_id', None)


class ClusterPatchParameters(Model):
    """The PatchCluster request parameters.

    :param tags: The resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(ClusterPatchParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class ClusterResizeParameters(Model):
    """The Resize Cluster request parameters.

    :param target_instance_count: The target instance count for the operation.
    :type target_instance_count: int
    """

    _attribute_map = {
        'target_instance_count': {'key': 'targetInstanceCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ClusterResizeParameters, self).__init__(**kwargs)
        self.target_instance_count = kwargs.get('target_instance_count', None)


class ComputeProfile(Model):
    """Describes the compute profile.

    :param roles: The list of roles in the cluster.
    :type roles: list[~azure.mgmt.hdinsight.models.Role]
    """

    _attribute_map = {
        'roles': {'key': 'roles', 'type': '[Role]'},
    }

    def __init__(self, **kwargs):
        super(ComputeProfile, self).__init__(**kwargs)
        self.roles = kwargs.get('roles', None)


class ConnectivityEndpoint(Model):
    """The connectivity properties.

    :param name: The name of the endpoint.
    :type name: str
    :param protocol: The protocol of the endpoint.
    :type protocol: str
    :param location: The location of the endpoint.
    :type location: str
    :param port: The port to connect to.
    :type port: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ConnectivityEndpoint, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.protocol = kwargs.get('protocol', None)
        self.location = kwargs.get('location', None)
        self.port = kwargs.get('port', None)


class DataDisksGroups(Model):
    """The data disks groups for the role.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param disks_per_node: The number of disks per node.
    :type disks_per_node: int
    :ivar storage_account_type: ReadOnly. The storage account type. Do not set
     this value.
    :vartype storage_account_type: str
    :ivar disk_size_gb: ReadOnly. The DiskSize in GB. Do not set this value.
    :vartype disk_size_gb: int
    """

    _validation = {
        'storage_account_type': {'readonly': True},
        'disk_size_gb': {'readonly': True},
    }

    _attribute_map = {
        'disks_per_node': {'key': 'disksPerNode', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(DataDisksGroups, self).__init__(**kwargs)
        self.disks_per_node = kwargs.get('disks_per_node', None)
        self.storage_account_type = None
        self.disk_size_gb = None


class DiskEncryptionProperties(Model):
    """The disk encryption properties.

    :param vault_uri: Base key vault URI where the customers key is located
     eg. https://myvault.vault.azure.net
    :type vault_uri: str
    :param key_name: Key name that is used for enabling disk encryption.
    :type key_name: str
    :param key_version: Specific key version that is used for enabling disk
     encryption.
    :type key_version: str
    :param encryption_algorithm: Algorithm identifier for encryption, default
     RSA-OAEP. Possible values include: 'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
    :type encryption_algorithm: str or
     ~azure.mgmt.hdinsight.models.JsonWebKeyEncryptionAlgorithm
    :param msi_resource_id: Resource ID of Managed Identity that is used to
     access the key vault.
    :type msi_resource_id: str
    """

    _attribute_map = {
        'vault_uri': {'key': 'vaultUri', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
        'key_version': {'key': 'keyVersion', 'type': 'str'},
        'encryption_algorithm': {'key': 'encryptionAlgorithm', 'type': 'str'},
        'msi_resource_id': {'key': 'msiResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DiskEncryptionProperties, self).__init__(**kwargs)
        self.vault_uri = kwargs.get('vault_uri', None)
        self.key_name = kwargs.get('key_name', None)
        self.key_version = kwargs.get('key_version', None)
        self.encryption_algorithm = kwargs.get('encryption_algorithm', None)
        self.msi_resource_id = kwargs.get('msi_resource_id', None)


class ErrorResponse(Model):
    """Describes the format of Error response.

    :param code: Error code
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class Errors(Model):
    """The error message associated with the cluster creation.

    :param code: The error code.
    :type code: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Errors, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class ExecuteScriptActionParameters(Model):
    """The parameters for the script actions to execute on a running cluster.

    All required parameters must be populated in order to send to Azure.

    :param script_actions: The list of run time script actions.
    :type script_actions:
     list[~azure.mgmt.hdinsight.models.RuntimeScriptAction]
    :param persist_on_success: Required. Gets or sets if the scripts needs to
     be persisted.
    :type persist_on_success: bool
    """

    _validation = {
        'persist_on_success': {'required': True},
    }

    _attribute_map = {
        'script_actions': {'key': 'scriptActions', 'type': '[RuntimeScriptAction]'},
        'persist_on_success': {'key': 'persistOnSuccess', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ExecuteScriptActionParameters, self).__init__(**kwargs)
        self.script_actions = kwargs.get('script_actions', None)
        self.persist_on_success = kwargs.get('persist_on_success', None)


class Extension(Model):
    """Cluster monitoring extensions.

    :param workspace_id: The workspace ID for the cluster monitoring
     extension.
    :type workspace_id: str
    :param primary_key: The certificate for the cluster monitoring extensions.
    :type primary_key: str
    """

    _attribute_map = {
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Extension, self).__init__(**kwargs)
        self.workspace_id = kwargs.get('workspace_id', None)
        self.primary_key = kwargs.get('primary_key', None)


class GatewaySettings(Model):
    """Gateway settings.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar is_credential_enabled: Indicates whether or not the gateway settings
     based authorization is enabled.
    :vartype is_credential_enabled: str
    :ivar user_name: The gateway settings user name.
    :vartype user_name: str
    :ivar password: The gateway settings user password.
    :vartype password: str
    """

    _validation = {
        'is_credential_enabled': {'readonly': True},
        'user_name': {'readonly': True},
        'password': {'readonly': True},
    }

    _attribute_map = {
        'is_credential_enabled': {'key': 'restAuthCredential\\.isEnabled', 'type': 'str'},
        'user_name': {'key': 'restAuthCredential\\.username', 'type': 'str'},
        'password': {'key': 'restAuthCredential\\.password', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GatewaySettings, self).__init__(**kwargs)
        self.is_credential_enabled = None
        self.user_name = None
        self.password = None


class HardwareProfile(Model):
    """The hardware profile.

    :param vm_size: The size of the VM
    :type vm_size: str
    """

    _attribute_map = {
        'vm_size': {'key': 'vmSize', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(HardwareProfile, self).__init__(**kwargs)
        self.vm_size = kwargs.get('vm_size', None)


class LinuxOperatingSystemProfile(Model):
    """The ssh username, password, and ssh public key.

    :param username: The username.
    :type username: str
    :param password: The password.
    :type password: str
    :param ssh_profile: The SSH profile.
    :type ssh_profile: ~azure.mgmt.hdinsight.models.SshProfile
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'ssh_profile': {'key': 'sshProfile', 'type': 'SshProfile'},
    }

    def __init__(self, **kwargs):
        super(LinuxOperatingSystemProfile, self).__init__(**kwargs)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.ssh_profile = kwargs.get('ssh_profile', None)


class LocalizedName(Model):
    """The details about the localizable name of a type of usage.

    :param value: The name of the used resource.
    :type value: str
    :param localized_value: The localized name of the used resource.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LocalizedName, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.localized_value = kwargs.get('localized_value', None)


class Operation(Model):
    """The HDInsight REST API operation.

    :param name: The operation name: {provider}/{resource}/{operation}
    :type name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.hdinsight.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)


class OperationDisplay(Model):
    """The object that represents the operation.

    :param provider: The service provider: Microsoft.HDInsight
    :type provider: str
    :param resource: The resource on which the operation is performed:
     Cluster, Applications, etc.
    :type resource: str
    :param operation: The operation type: read, write, delete, etc.
    :type operation: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)


class OperationResource(Model):
    """The azure async operation response.

    :param status: The async operation state. Possible values include:
     'InProgress', 'Succeeded', 'Failed'
    :type status: str or ~azure.mgmt.hdinsight.models.AsyncOperationState
    :param error: The operation error information.
    :type error: ~azure.mgmt.hdinsight.models.Errors
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'AsyncOperationState'},
        'error': {'key': 'error', 'type': 'Errors'},
    }

    def __init__(self, **kwargs):
        super(OperationResource, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.error = kwargs.get('error', None)


class OsProfile(Model):
    """The Linux operation systems profile.

    :param linux_operating_system_profile: The Linux OS profile.
    :type linux_operating_system_profile:
     ~azure.mgmt.hdinsight.models.LinuxOperatingSystemProfile
    """

    _attribute_map = {
        'linux_operating_system_profile': {'key': 'linuxOperatingSystemProfile', 'type': 'LinuxOperatingSystemProfile'},
    }

    def __init__(self, **kwargs):
        super(OsProfile, self).__init__(**kwargs)
        self.linux_operating_system_profile = kwargs.get('linux_operating_system_profile', None)


class QuotaInfo(Model):
    """The quota properties for the cluster.

    :param cores_used: The cores used by the cluster.
    :type cores_used: int
    """

    _attribute_map = {
        'cores_used': {'key': 'coresUsed', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(QuotaInfo, self).__init__(**kwargs)
        self.cores_used = kwargs.get('cores_used', None)


class Role(Model):
    """Describes a role on the cluster.

    :param name: The name of the role.
    :type name: str
    :param min_instance_count: The minimum instance count of the cluster.
    :type min_instance_count: int
    :param target_instance_count: The instance count of the cluster.
    :type target_instance_count: int
    :param hardware_profile: The hardware profile.
    :type hardware_profile: ~azure.mgmt.hdinsight.models.HardwareProfile
    :param os_profile: The operating system profile.
    :type os_profile: ~azure.mgmt.hdinsight.models.OsProfile
    :param virtual_network_profile: The virtual network profile.
    :type virtual_network_profile:
     ~azure.mgmt.hdinsight.models.VirtualNetworkProfile
    :param data_disks_groups: The data disks groups for the role.
    :type data_disks_groups:
     list[~azure.mgmt.hdinsight.models.DataDisksGroups]
    :param script_actions: The list of script actions on the role.
    :type script_actions: list[~azure.mgmt.hdinsight.models.ScriptAction]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'min_instance_count': {'key': 'minInstanceCount', 'type': 'int'},
        'target_instance_count': {'key': 'targetInstanceCount', 'type': 'int'},
        'hardware_profile': {'key': 'hardwareProfile', 'type': 'HardwareProfile'},
        'os_profile': {'key': 'osProfile', 'type': 'OsProfile'},
        'virtual_network_profile': {'key': 'virtualNetworkProfile', 'type': 'VirtualNetworkProfile'},
        'data_disks_groups': {'key': 'dataDisksGroups', 'type': '[DataDisksGroups]'},
        'script_actions': {'key': 'scriptActions', 'type': '[ScriptAction]'},
    }

    def __init__(self, **kwargs):
        super(Role, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.min_instance_count = kwargs.get('min_instance_count', None)
        self.target_instance_count = kwargs.get('target_instance_count', None)
        self.hardware_profile = kwargs.get('hardware_profile', None)
        self.os_profile = kwargs.get('os_profile', None)
        self.virtual_network_profile = kwargs.get('virtual_network_profile', None)
        self.data_disks_groups = kwargs.get('data_disks_groups', None)
        self.script_actions = kwargs.get('script_actions', None)


class RuntimeScriptAction(Model):
    """Describes a script action on a running cluster.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the script action.
    :type name: str
    :param uri: Required. The URI to the script.
    :type uri: str
    :param parameters: The parameters for the script
    :type parameters: str
    :param roles: Required. The list of roles where script will be executed.
    :type roles: list[str]
    :ivar application_name: The application name of the script action, if any.
    :vartype application_name: str
    """

    _validation = {
        'name': {'required': True},
        'uri': {'required': True},
        'roles': {'required': True},
        'application_name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'str'},
        'roles': {'key': 'roles', 'type': '[str]'},
        'application_name': {'key': 'applicationName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RuntimeScriptAction, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.uri = kwargs.get('uri', None)
        self.parameters = kwargs.get('parameters', None)
        self.roles = kwargs.get('roles', None)
        self.application_name = None


class RuntimeScriptActionDetail(RuntimeScriptAction):
    """The execution details of a script action.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the script action.
    :type name: str
    :param uri: Required. The URI to the script.
    :type uri: str
    :param parameters: The parameters for the script
    :type parameters: str
    :param roles: Required. The list of roles where script will be executed.
    :type roles: list[str]
    :ivar application_name: The application name of the script action, if any.
    :vartype application_name: str
    :ivar script_execution_id: The execution id of the script action.
    :vartype script_execution_id: long
    :ivar start_time: The start time of script action execution.
    :vartype start_time: str
    :ivar end_time: The end time of script action execution.
    :vartype end_time: str
    :ivar status: The current execution status of the script action.
    :vartype status: str
    :ivar operation: The reason why the script action was executed.
    :vartype operation: str
    :ivar execution_summary: The summary of script action execution result.
    :vartype execution_summary:
     list[~azure.mgmt.hdinsight.models.ScriptActionExecutionSummary]
    :ivar debug_information: The script action execution debug information.
    :vartype debug_information: str
    """

    _validation = {
        'name': {'required': True},
        'uri': {'required': True},
        'roles': {'required': True},
        'application_name': {'readonly': True},
        'script_execution_id': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'status': {'readonly': True},
        'operation': {'readonly': True},
        'execution_summary': {'readonly': True},
        'debug_information': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'str'},
        'roles': {'key': 'roles', 'type': '[str]'},
        'application_name': {'key': 'applicationName', 'type': 'str'},
        'script_execution_id': {'key': 'scriptExecutionId', 'type': 'long'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'execution_summary': {'key': 'executionSummary', 'type': '[ScriptActionExecutionSummary]'},
        'debug_information': {'key': 'debugInformation', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RuntimeScriptActionDetail, self).__init__(**kwargs)
        self.script_execution_id = None
        self.start_time = None
        self.end_time = None
        self.status = None
        self.operation = None
        self.execution_summary = None
        self.debug_information = None


class ScriptAction(Model):
    """Describes a script action on role on the cluster.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the script action.
    :type name: str
    :param uri: Required. The URI to the script.
    :type uri: str
    :param parameters: Required. The parameters for the script provided.
    :type parameters: str
    """

    _validation = {
        'name': {'required': True},
        'uri': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ScriptAction, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.uri = kwargs.get('uri', None)
        self.parameters = kwargs.get('parameters', None)


class ScriptActionExecutionSummary(Model):
    """The execution summary of a script action.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar status: The status of script action execution.
    :vartype status: str
    :ivar instance_count: The instance count for a given script action
     execution status.
    :vartype instance_count: int
    """

    _validation = {
        'status': {'readonly': True},
        'instance_count': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ScriptActionExecutionSummary, self).__init__(**kwargs)
        self.status = None
        self.instance_count = None


class ScriptActionPersistedGetResponseSpec(Model):
    """The persisted script action for cluster.

    :param name: The name of script action.
    :type name: str
    :param uri: The URI to the script.
    :type uri: str
    :param parameters: The parameters for the script provided.
    :type parameters: str
    :param roles: The list of roles where script will be executed.
    :type roles: list[str]
    :param application_name: The application name for the script action.
    :type application_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'str'},
        'roles': {'key': 'roles', 'type': '[str]'},
        'application_name': {'key': 'applicationName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ScriptActionPersistedGetResponseSpec, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.uri = kwargs.get('uri', None)
        self.parameters = kwargs.get('parameters', None)
        self.roles = kwargs.get('roles', None)
        self.application_name = kwargs.get('application_name', None)


class SecurityProfile(Model):
    """The security profile which contains Ssh public key for the HDInsight
    cluster.

    :param directory_type: The directory type. Possible values include:
     'ActiveDirectory'
    :type directory_type: str or ~azure.mgmt.hdinsight.models.DirectoryType
    :param domain: The organization's active directory domain.
    :type domain: str
    :param organizational_unit_dn: The organizational unit within the Active
     Directory to place the cluster and service accounts.
    :type organizational_unit_dn: str
    :param ldaps_urls: The LDAPS protocol URLs to communicate with the Active
     Directory.
    :type ldaps_urls: list[str]
    :param domain_username: The domain user account that will have admin
     privileges on the cluster.
    :type domain_username: str
    :param domain_user_password: The domain admin password.
    :type domain_user_password: str
    :param cluster_users_group_dns: Optional. The Distinguished Names for
     cluster user groups
    :type cluster_users_group_dns: list[str]
    :param aadds_resource_id: The resource ID of the user's Azure Active
     Directory Domain Service.
    :type aadds_resource_id: str
    :param msi_resource_id: User assigned identity that has permissions to
     read and create cluster-related artifacts in the user's AADDS.
    :type msi_resource_id: str
    """

    _attribute_map = {
        'directory_type': {'key': 'directoryType', 'type': 'DirectoryType'},
        'domain': {'key': 'domain', 'type': 'str'},
        'organizational_unit_dn': {'key': 'organizationalUnitDN', 'type': 'str'},
        'ldaps_urls': {'key': 'ldapsUrls', 'type': '[str]'},
        'domain_username': {'key': 'domainUsername', 'type': 'str'},
        'domain_user_password': {'key': 'domainUserPassword', 'type': 'str'},
        'cluster_users_group_dns': {'key': 'clusterUsersGroupDNs', 'type': '[str]'},
        'aadds_resource_id': {'key': 'aaddsResourceId', 'type': 'str'},
        'msi_resource_id': {'key': 'msiResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SecurityProfile, self).__init__(**kwargs)
        self.directory_type = kwargs.get('directory_type', None)
        self.domain = kwargs.get('domain', None)
        self.organizational_unit_dn = kwargs.get('organizational_unit_dn', None)
        self.ldaps_urls = kwargs.get('ldaps_urls', None)
        self.domain_username = kwargs.get('domain_username', None)
        self.domain_user_password = kwargs.get('domain_user_password', None)
        self.cluster_users_group_dns = kwargs.get('cluster_users_group_dns', None)
        self.aadds_resource_id = kwargs.get('aadds_resource_id', None)
        self.msi_resource_id = kwargs.get('msi_resource_id', None)


class SshProfile(Model):
    """The list of SSH public keys.

    :param public_keys: The list of SSH public keys.
    :type public_keys: list[~azure.mgmt.hdinsight.models.SshPublicKey]
    """

    _attribute_map = {
        'public_keys': {'key': 'publicKeys', 'type': '[SshPublicKey]'},
    }

    def __init__(self, **kwargs):
        super(SshProfile, self).__init__(**kwargs)
        self.public_keys = kwargs.get('public_keys', None)


class SshPublicKey(Model):
    """The SSH public key for the cluster nodes.

    :param certificate_data: The certificate for SSH.
    :type certificate_data: str
    """

    _attribute_map = {
        'certificate_data': {'key': 'certificateData', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SshPublicKey, self).__init__(**kwargs)
        self.certificate_data = kwargs.get('certificate_data', None)


class StorageAccount(Model):
    """The storage Account.

    :param name: The name of the storage account.
    :type name: str
    :param is_default: Whether or not the storage account is the default
     storage account.
    :type is_default: bool
    :param container: The container in the storage account, only to be
     specified for WASB storage accounts.
    :type container: str
    :param file_system: The filesystem, only to be specified for Azure Data
     Lake Storage type Gen 2.
    :type file_system: str
    :param key: The storage account access key.
    :type key: str
    :param resource_id: The resource ID of storage account, only to be
     specified for Azure Data Lake Storage Gen 2.
    :type resource_id: str
    :param msi_resource_id: The managed identity (MSI) that is allowed to
     access the storage account, only to be specified for Azure Data Lake
     Storage Gen 2.
    :type msi_resource_id: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'container': {'key': 'container', 'type': 'str'},
        'file_system': {'key': 'fileSystem', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'msi_resource_id': {'key': 'msiResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(StorageAccount, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.is_default = kwargs.get('is_default', None)
        self.container = kwargs.get('container', None)
        self.file_system = kwargs.get('file_system', None)
        self.key = kwargs.get('key', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.msi_resource_id = kwargs.get('msi_resource_id', None)


class StorageProfile(Model):
    """The storage profile.

    :param storageaccounts: The list of storage accounts in the cluster.
    :type storageaccounts: list[~azure.mgmt.hdinsight.models.StorageAccount]
    """

    _attribute_map = {
        'storageaccounts': {'key': 'storageaccounts', 'type': '[StorageAccount]'},
    }

    def __init__(self, **kwargs):
        super(StorageProfile, self).__init__(**kwargs)
        self.storageaccounts = kwargs.get('storageaccounts', None)


class UpdateGatewaySettingsParameters(Model):
    """The update gateway settings request parameters.

    :param is_credential_enabled: Indicates whether or not the gateway
     settings based authorization is enabled. Default value: True .
    :type is_credential_enabled: bool
    :param user_name: The gateway settings user name.
    :type user_name: str
    :param password: The gateway settings user password.
    :type password: str
    """

    _attribute_map = {
        'is_credential_enabled': {'key': 'restAuthCredential\\.isEnabled', 'type': 'bool'},
        'user_name': {'key': 'restAuthCredential\\.username', 'type': 'str'},
        'password': {'key': 'restAuthCredential\\.password', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UpdateGatewaySettingsParameters, self).__init__(**kwargs)
        self.is_credential_enabled = kwargs.get('is_credential_enabled', True)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)


class Usage(Model):
    """The details about the usage of a particular limited resource.

    :param unit: The type of measurement for usage.
    :type unit: str
    :param current_value: The current usage.
    :type current_value: int
    :param limit: The maximum allowed usage.
    :type limit: int
    :param name: The details about the localizable name of the used resource.
    :type name: ~azure.mgmt.hdinsight.models.LocalizedName
    """

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
        'name': {'key': 'name', 'type': 'LocalizedName'},
    }

    def __init__(self, **kwargs):
        super(Usage, self).__init__(**kwargs)
        self.unit = kwargs.get('unit', None)
        self.current_value = kwargs.get('current_value', None)
        self.limit = kwargs.get('limit', None)
        self.name = kwargs.get('name', None)


class UsagesListResult(Model):
    """The response for the operation to get regional usages for a subscription.

    :param value: The list of usages.
    :type value: list[~azure.mgmt.hdinsight.models.Usage]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
    }

    def __init__(self, **kwargs):
        super(UsagesListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class VirtualNetworkProfile(Model):
    """The virtual network properties.

    :param id: The ID of the virtual network.
    :type id: str
    :param subnet: The name of the subnet.
    :type subnet: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'subnet': {'key': 'subnet', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualNetworkProfile, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.subnet = kwargs.get('subnet', None)
