# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class SubscriptionResource(Resource):
    """Description of Subscription Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict
    :param accessed_at: Last time a there was a receive request to this
     subscription.
    :type accessed_at: datetime
    :param auto_delete_on_idle: TimeSpan idle interval after which the topic
     is automatically deleted. The minimum duration is 5 minutes.
    :type auto_delete_on_idle: str
    :param count_details:
    :type count_details: :class:`MessageCountDetails
     <azure.mgmt.servicebus.models.MessageCountDetails>`
    :param created_at: Exact time the message was created.
    :type created_at: datetime
    :param default_message_time_to_live: Default message time to live value.
     This is the duration after which the message expires, starting from when
     the message is sent to Service Bus. This is the default value used when
     TimeToLive is not set on a message itself.
    :type default_message_time_to_live: str
    :param dead_lettering_on_filter_evaluation_exceptions: Value that
     indicates if a subscription has dead letter support on Filter evaluation
     exceptions.
    :type dead_lettering_on_filter_evaluation_exceptions: bool
    :param dead_lettering_on_message_expiration: Value that indicates if a
     subscription has dead letter support when a message expires.
    :type dead_lettering_on_message_expiration: bool
    :param enable_batched_operations: Value that indicates whether
     server-side batched operations are enabled..
    :type enable_batched_operations: bool
    :param entity_availability_status: Entity availability status for the
     topic. Possible values include: 'Available', 'Limited', 'Renaming',
     'Restoring', 'Unknown'
    :type entity_availability_status: str or :class:`EntityAvailabilityStatus
     <azure.mgmt.servicebus.models.EntityAvailabilityStatus>`
    :param is_read_only: Value that indicates whether the entity description
     is read-only.
    :type is_read_only: bool
    :param lock_duration: The lock duration time span for the subscription.
    :type lock_duration: str
    :param max_delivery_count: Number of maximum deliveries.
    :type max_delivery_count: int
    :param message_count: Number of messages.
    :type message_count: long
    :param requires_session: Value indicating if a subscription supports the
     concept of session.
    :type requires_session: bool
    :param status: Enumerates the possible values for the status of a
     messaging entity. Possible values include: 'Active', 'Creating',
     'Deleting', 'Disabled', 'ReceiveDisabled', 'Renaming', 'Restoring',
     'SendDisabled', 'Unknown'
    :type status: str or :class:`EntityStatus
     <azure.mgmt.servicebus.models.EntityStatus>`
    :param updated_at: The exact time the message has been updated.
    :type updated_at: datetime
    """ 

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'accessed_at': {'key': 'properties.accessedAt', 'type': 'iso-8601'},
        'auto_delete_on_idle': {'key': 'properties.autoDeleteOnIdle', 'type': 'str'},
        'count_details': {'key': 'properties.countDetails', 'type': 'MessageCountDetails'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'default_message_time_to_live': {'key': 'properties.defaultMessageTimeToLive', 'type': 'str'},
        'dead_lettering_on_filter_evaluation_exceptions': {'key': 'properties.deadLetteringOnFilterEvaluationExceptions', 'type': 'bool'},
        'dead_lettering_on_message_expiration': {'key': 'properties.deadLetteringOnMessageExpiration', 'type': 'bool'},
        'enable_batched_operations': {'key': 'properties.enableBatchedOperations', 'type': 'bool'},
        'entity_availability_status': {'key': 'properties.entityAvailabilityStatus', 'type': 'EntityAvailabilityStatus'},
        'is_read_only': {'key': 'properties.isReadOnly', 'type': 'bool'},
        'lock_duration': {'key': 'properties.lockDuration', 'type': 'str'},
        'max_delivery_count': {'key': 'properties.maxDeliveryCount', 'type': 'int'},
        'message_count': {'key': 'properties.messageCount', 'type': 'long'},
        'requires_session': {'key': 'properties.requiresSession', 'type': 'bool'},
        'status': {'key': 'properties.status', 'type': 'EntityStatus'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
    }

    def __init__(self, location, tags=None, accessed_at=None, auto_delete_on_idle=None, count_details=None, created_at=None, default_message_time_to_live=None, dead_lettering_on_filter_evaluation_exceptions=None, dead_lettering_on_message_expiration=None, enable_batched_operations=None, entity_availability_status=None, is_read_only=None, lock_duration=None, max_delivery_count=None, message_count=None, requires_session=None, status=None, updated_at=None):
        super(SubscriptionResource, self).__init__(location=location, tags=tags)
        self.accessed_at = accessed_at
        self.auto_delete_on_idle = auto_delete_on_idle
        self.count_details = count_details
        self.created_at = created_at
        self.default_message_time_to_live = default_message_time_to_live
        self.dead_lettering_on_filter_evaluation_exceptions = dead_lettering_on_filter_evaluation_exceptions
        self.dead_lettering_on_message_expiration = dead_lettering_on_message_expiration
        self.enable_batched_operations = enable_batched_operations
        self.entity_availability_status = entity_availability_status
        self.is_read_only = is_read_only
        self.lock_duration = lock_duration
        self.max_delivery_count = max_delivery_count
        self.message_count = message_count
        self.requires_session = requires_session
        self.status = status
        self.updated_at = updated_at
