
import logging
from pyvisdk.exceptions import InvalidArgumentError

########################################
# Automatically generated, do not edit.
########################################

log = logging.getLogger(__name__)

def HostVirtualSwitchSpec(vim, *args, **kwargs):
    '''This data object type describes the VirtualSwitch specification representing
    the properties on a VirtualSwitch that can be configured once the object
    exists.'''
    
    obj = vim.client.factory.create('ns0:HostVirtualSwitchSpec')

    # do some validation checking...
    if (len(args) + len(kwargs)) < 1:
        raise IndexError('Expected at least 2 arguments got: %d' % len(args))

    required = [ 'numPorts' ]
    optional = [ 'bridge', 'mtu', 'policy', 'dynamicProperty', 'dynamicType' ]

    for name, arg in zip(required+optional, args):
        setattr(obj, name, arg)

    for name, value in kwargs.items():
        if name in required + optional:
            setattr(obj, name, value)
        else:
            raise InvalidArgumentError("Invalid argument: %s.  Expected one of %s" % (name, ", ".join(required + optional)))

    return obj
    