/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.utils;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class ChildFirstClassLoader
extends URLClassLoader {
    private static final Logger logger = Logger.getLogger(ChildFirstClassLoader.class);

    public ChildFirstClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass == null) {
            try {
                loadedClass = this.findClass(name);
                logger.debug((Object)(name + " loaded from jar " + Arrays.toString(this.getURLs())));
            }
            catch (ClassNotFoundException e) {
                logger.debug((Object)(name + " not found in jar " + Arrays.toString(this.getURLs())));
                logger.debug((Object)(name + " loading from parent " + this.getParent()));
                loadedClass = super.loadClass(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(loadedClass);
        }
        return loadedClass;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        LinkedList<URL> allRes = new LinkedList<URL>();
        allRes.addAll(Collections.list(this.findResources(name)));
        allRes.addAll(Collections.list(super.getResources(name)));
        return Collections.enumeration(allRes);
    }

    @Override
    public URL getResource(String name) {
        URL res = this.findResource(name);
        if (res == null) {
            res = super.getResource(name);
        }
        return res;
    }
}

