/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdbm.recman.BlockIo;
import jdbm.recman.FreeLogicalRowIdPage;
import jdbm.recman.Location;
import jdbm.recman.PageCursor;
import jdbm.recman.PageManager;
import jdbm.recman.RecordFile;

final class FreeLogicalRowIdPageManager {
    private RecordFile file;
    private PageManager pageman;
    private int blockSize;
    final List<Long> freeBlocksInTransactionRowid = new ArrayList<Long>();

    FreeLogicalRowIdPageManager(RecordFile file, PageManager pageman) throws IOException {
        this.file = file;
        this.pageman = pageman;
        this.blockSize = file.BLOCK_SIZE;
    }

    long get() throws IOException {
        if (!this.freeBlocksInTransactionRowid.isEmpty()) {
            long first = this.freeBlocksInTransactionRowid.get(this.freeBlocksInTransactionRowid.size() - 1);
            this.freeBlocksInTransactionRowid.remove(this.freeBlocksInTransactionRowid.size() - 1);
            return first;
        }
        long retval = 0L;
        PageCursor curs = new PageCursor(this.pageman, 3);
        while (curs.next() != 0L) {
            FreeLogicalRowIdPage fp = FreeLogicalRowIdPage.getFreeLogicalRowIdPageView(this.file.get(curs.getCurrent()), this.blockSize);
            int slot = fp.getFirstAllocated();
            if (slot != -1) {
                retval = fp.slotToLocation(slot);
                fp.free(slot);
                if (fp.getCount() == 0) {
                    this.file.release(curs.getCurrent(), false);
                    this.pageman.free((short)3, curs.getCurrent());
                } else {
                    this.file.release(curs.getCurrent(), true);
                }
                return retval;
            }
            this.file.release(curs.getCurrent(), false);
        }
        return 0L;
    }

    void put(long rowid) throws IOException {
        this.freeBlocksInTransactionRowid.add(rowid);
    }

    public void commit() throws IOException {
        short freePhysRowId;
        long rowid;
        int slot;
        FreeLogicalRowIdPage fp;
        BlockIo curBlock;
        long freePage;
        Iterator<Long> rowidIter = this.freeBlocksInTransactionRowid.iterator();
        PageCursor curs = new PageCursor(this.pageman, 3);
        while (curs.next() != 0L) {
            freePage = curs.getCurrent();
            curBlock = this.file.get(freePage);
            fp = FreeLogicalRowIdPage.getFreeLogicalRowIdPageView(curBlock, this.blockSize);
            slot = fp.getFirstFree();
            while (slot != -1 && rowidIter.hasNext()) {
                rowid = rowidIter.next();
                freePhysRowId = fp.alloc(slot);
                fp.setLocationBlock(freePhysRowId, Location.getBlock(rowid));
                fp.setLocationOffset(freePhysRowId, Location.getOffset(rowid));
                slot = fp.getFirstFree();
            }
            this.file.release(freePage, true);
            if (rowidIter.hasNext()) continue;
            break;
        }
        while (rowidIter.hasNext()) {
            freePage = this.pageman.allocate((short)3);
            curBlock = this.file.get(freePage);
            fp = FreeLogicalRowIdPage.getFreeLogicalRowIdPageView(curBlock, this.blockSize);
            slot = fp.getFirstFree();
            while (slot != -1 && rowidIter.hasNext()) {
                rowid = rowidIter.next();
                freePhysRowId = fp.alloc(slot);
                fp.setLocationBlock(freePhysRowId, Location.getBlock(rowid));
                fp.setLocationOffset(freePhysRowId, Location.getOffset(rowid));
                slot = fp.getFirstFree();
            }
            this.file.release(freePage, true);
            if (rowidIter.hasNext()) continue;
            break;
        }
        if (rowidIter.hasNext()) {
            throw new InternalError();
        }
        this.freeBlocksInTransactionRowid.clear();
    }
}

