# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ProviderResourceType(Model):
    """
    Resource type managed by the resource provider.

    :param resource_type: Gets or sets the resource type.
    :type resource_type: str
    :param locations: Gets or sets the collection of locations where this
     resource type can be created in.
    :type locations: list of str
    :param api_versions: Gets or sets the api version.
    :type api_versions: list of str
    :param properties: Gets or sets the properties.
    :type properties: dict
    """ 

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'api_versions': {'key': 'apiVersions', 'type': '[str]'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(self, resource_type=None, locations=None, api_versions=None, properties=None, **kwargs):
        self.resource_type = resource_type
        self.locations = locations
        self.api_versions = api_versions
        self.properties = properties
